/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsImage;
import jv.objectGui.PsScanline;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;
import jv.viewer.PvLight;

public final class PvScene
extends PsObject {
    private PvGeometry[] m_allGeometry;
    private int m_numAllGeometries;
    protected int m_maxNumGeometries;
    protected int m_numGeometries = 0;
    protected PvGeometry[] m_geometry;
    protected Vector m_special;
    protected PvGeometry m_currentGeom;
    protected int m_numItems;
    protected int[][] m_itemInd;
    protected double[] m_itemHeight;
    protected int[] m_itemSort;
    protected int m_dim;
    protected PdVector[] m_bndBox;
    protected PdVector m_center;
    protected int m_pickedVertex;
    protected int m_pickedGeometry;
    private int m_geomInd;
    private PiVector[] m_faceDestBnd;
    private float[][] m_colDestBnd;
    private float[][] m_lightDestBnd;
    protected PiVector m_bndIdentifier = null;
    protected int m_dimWithZBuffer = 4;
    protected int m_zMin;
    protected int m_zMax;
    protected PdVector m_cameraPos = new PdVector(3);
    protected PdVector m_cameraDir = new PdVector(3);
    protected boolean m_bIsBurning = true;
    protected int[][] m_tpBuffer = null;
    protected int[][] m_colBuffer = null;
    private static final boolean m_bTiming = false;
    private transient Image m_destImage;
    private int m_imgWidth;
    private int m_imgHeight;
    private transient MemoryImageSource m_mis;
    protected PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    private boolean m_bBackImage = false;
    private int m_backColor = -1;
    private boolean m_bTransparency = false;

    private void collectAllGeometries() {
        this.m_numAllGeometries = this.m_numGeometries + this.m_special.size();
        this.m_allGeometry = new PvGeometry[this.m_numAllGeometries];
        if (this.m_numAllGeometries == 0) {
            return;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            this.m_allGeometry[n] = this.m_geometry[n];
            ++n;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            this.m_allGeometry[n++] = (PvGeometry)enumeration.nextElement();
        }
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            default: {
                PsDebug.warning("invalid key = " + n);
            }
            case 69: 
            case 70: 
        }
    }

    private int getGeometryIndOfItem(int n) {
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            if (this.m_itemInd[n2][0] <= n && n <= this.m_itemInd[n2][1]) {
                return n2;
            }
            ++n2;
        }
        PsDebug.warning("missing geometry of item = " + n);
        return -1;
    }

    private int getNumAllGeometryContainers() {
        return this.m_numGeometries + this.m_special.size();
    }

    public PvScene() {
        this.assureIndexList();
        this.m_allGeometry = new PvGeometry[0];
        this.m_special = new Vector();
        this.m_bIsBurning = false;
        this.init();
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return false;
        }
        return this.getGeometryContainer(pgGeometryIf) != null;
    }

    public void paint(Graphics graphics, PvDisplayIf pvDisplayIf) {
        int n;
        int n2;
        int n3;
        PgGeometryIf[] pgGeometryIfArray;
        double d;
        int n4 = this.getNumAllGeometryContainers();
        if (n4 == 0 || n4 == this.m_numGeometries && this.m_numItems == 0) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = pvDisplayIf.isShowingDepthcue();
        PdMatrix pdMatrix = pvDisplayIf.getTransMatrix(4);
        PdMatrix pdMatrix2 = pvDisplayIf.getTransMatrix(128);
        PdMatrix pdMatrix3 = pvDisplayIf.getTransMatrix(2);
        PdMatrix pdMatrix4 = pvDisplayIf.getTransMatrix(1);
        PdMatrix pdMatrix5 = pvDisplayIf.getTransMatrix(2002);
        PdMatrix pdMatrix6 = pvDisplayIf.getTransMatrix(2001);
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        boolean bl2 = pdMatrix3.m_data[3][2] != 0.0;
        double d5 = pdMatrix3.m_data[3][2];
        if (bl2) {
            this.m_cameraDir.sub(pvCameraIf.getPosition(), pvCameraIf.getInterest());
            d = -1.0 / (PvCamera.SIZE * d5);
            this.m_cameraPos.blendBase(pvCameraIf.getInterest(), d, this.m_cameraDir);
        } else {
            this.m_cameraDir.sub(pvCameraIf.getPosition(), pvCameraIf.getInterest());
            d5 = -0.001;
            d = -1.0 / (PvCamera.SIZE * d5);
            this.m_cameraPos.blendBase(pvCameraIf.getInterest(), d, this.m_cameraDir);
        }
        boolean bl3 = pvDisplayIf.getLightingModel() == 1;
        boolean bl4 = true;
        PvLight[] pvLightArray = null;
        if (bl3) {
            pgGeometryIfArray = pvDisplayIf.getLights();
            pvLightArray = new PvLight[pgGeometryIfArray.length];
            int n5 = 0;
            while (n5 < pgGeometryIfArray.length) {
                PvGeometry pvGeometry;
                pvLightArray[n5] = (PvLight)pgGeometryIfArray[n5];
                if (pvLightArray[n5].getShading() != 0) {
                    bl4 = false;
                }
                if (pvLightArray[n5].getReference() == 1) {
                    pvLightArray[n5].m_directionView.leftMultAffin(pdMatrix2, pvLightArray[n5].m_direction, false);
                    pvLightArray[n5].m_directionView.normalize();
                    pvGeometry = this.getGeometryContainer(pvLightArray[n5]);
                    pvLightArray[n5].m_positionView.leftMultAffin(pdMatrix2, pvLightArray[n5].m_position, true);
                    pvGeometry.setVertex(0, pvLightArray[n5].m_positionView);
                    pvLightArray[n5].m_interestView.leftMultAffin(pdMatrix2, pvLightArray[n5].m_interest, true);
                    pvGeometry.setVertex(1, pvLightArray[n5].m_interestView);
                    if (pvGeometry.hasModelMatrix()) {
                        pvGeometry.getModelMatrix().setIdentity();
                    }
                } else {
                    pvLightArray[n5].m_positionView.copyArray(pvLightArray[n5].m_position);
                    pvLightArray[n5].m_interestView.copyArray(pvLightArray[n5].m_interest);
                    pvLightArray[n5].m_directionView.copyArray(pvLightArray[n5].m_direction);
                    pvGeometry = this.getGeometryContainer(pvLightArray[n5]);
                    pvGeometry.setVertices(pvLightArray[n5].getVertices());
                }
                ++n5;
            }
        }
        pgGeometryIfArray = this.getAllGeometryContainers();
        Dimension dimension = new Dimension(((PvDisplay)pvDisplayIf).m_widthOff, ((PvDisplay)pvDisplayIf).m_heightOff);
        this.m_zMin = Integer.MAX_VALUE;
        this.m_zMax = Integer.MIN_VALUE;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n6 = 0;
        while (n6 < n4) {
            if (((PgGeometry)pgGeometryIfArray[n6]).isVisible()) {
                ((PvGeometry)pgGeometryIfArray[n6]).m_dispSize = dimension;
                ((PvGeometry)pgGeometryIfArray[n6]).m_bPerspectivity = bl2;
                ((PvGeometry)pgGeometryIfArray[n6]).m_bLightsSymmetric = bl4;
                ((PvGeometry)pgGeometryIfArray[n6]).m_cameraPos.copyArray(this.m_cameraPos);
                ((PvGeometry)pgGeometryIfArray[n6]).m_cameraDir.copyArray(this.m_cameraDir);
                if (bl2) {
                    ((PvGeometry)pgGeometryIfArray[n6]).m_bAutoClip = pgGeometryIfArray[n6] != this.getGeometryContainer(((PvDisplay)pvDisplayIf).m_coordFrame);
                    ((PvGeometry)pgGeometryIfArray[n6]).m_autoClip = 0x7FFFFFF;
                } else {
                    ((PvGeometry)pgGeometryIfArray[n6]).m_bAutoClip = false;
                }
                if (!bl5 && ((PgJvxSrc)pgGeometryIfArray[n6]).isShowingVertices() && (((PgJvxSrc)pgGeometryIfArray[n6]).isShowingIndices() || ((PgJvxSrc)pgGeometryIfArray[n6]).isShowingVertexLabels())) {
                    bl5 = true;
                }
                if (((PvGeometry)pgGeometryIfArray[n6]).m_bShowTexture) {
                    bl6 = true;
                }
                ((PvGeometry)pgGeometryIfArray[n6]).assureTexture(((PvGeometry)pgGeometryIfArray[n6]).m_bShowTexture);
                if (((PvGeometry)pgGeometryIfArray[n6]).m_bShowTransparencyOrig || ((PvGeometry)pgGeometryIfArray[n6]).m_bShowTexture && ((PgJvxSrc)pgGeometryIfArray[n6]).getBlendingMode() == 1) {
                    bl7 = true;
                }
                if (((PvGeometry)pgGeometryIfArray[n6]).getState(98)) {
                    bl8 = true;
                }
                if (((PvGeometry)pgGeometryIfArray[n6]).getState(101)) {
                    bl9 = true;
                }
                if (((PvGeometry)pgGeometryIfArray[n6]).getState(151)) {
                    ((PvGeometry)pgGeometryIfArray[n6]).setEnabledLighting(false);
                    ((PvGeometry)pgGeometryIfArray[n6]).setLights(null);
                } else {
                    ((PvGeometry)pgGeometryIfArray[n6]).setEnabledLighting(bl3);
                    ((PvGeometry)pgGeometryIfArray[n6]).setLights(pvLightArray);
                }
                ((PvGeometry)pgGeometryIfArray[n6]).setEnabledClipCamera(pvDisplayIf.isEnabledClip());
                ((PvGeometry)pgGeometryIfArray[n6]).m_clipFar = (double)(PvGeometry.PS_ZOOM * PvCamera.Z_STRETCH) * pvDisplayIf.getFarClip();
                ((PvGeometry)pgGeometryIfArray[n6]).m_clipNear = (double)(PvGeometry.PS_ZOOM * PvCamera.Z_STRETCH) * pvDisplayIf.getNearClip();
                ((PvGeometry)pgGeometryIfArray[n6]).setEnabledClipBounds(pvDisplayIf.isEnabledClipBounds());
                if (pvDisplayIf.isEnabledClipBounds()) {
                    int n7 = 0;
                    do {
                        ((PvGeometry)pgGeometryIfArray[n6]).m_clipBounds[0].setEntry(n7, ((PvDisplay)pvDisplayIf).m_clipBoundMin[n7].getValue());
                        ((PvGeometry)pgGeometryIfArray[n6]).m_clipBounds[1].setEntry(n7, ((PvDisplay)pvDisplayIf).m_clipBoundMax[n7].getValue());
                    } while (++n7 < 3);
                }
                ((PvGeometry)pgGeometryIfArray[n6]).setOffFac(((PvDisplay)pvDisplayIf).m_offFac);
            }
            ++n6;
        }
        n6 = ((PvDisplay)pvDisplayIf).isEnabledZBuffer() ? 1 : 0;
        if (bl7 && dimension.width > 0 && dimension.height > 0) {
            if (this.m_tpBuffer == null || this.m_tpBuffer.length != dimension.height || this.m_tpBuffer[0].length != dimension.width) {
                this.m_tpBuffer = new int[dimension.height][dimension.width];
                this.m_colBuffer = new int[dimension.height][dimension.width];
            }
        } else {
            this.m_tpBuffer = null;
            this.m_colBuffer = null;
        }
        long l = 0L;
        int n8 = 0;
        while (n8 < n4) {
            if (((PgGeometry)pgGeometryIfArray[n8]).isVisible()) {
                ((PvGeometry)pgGeometryIfArray[n8]).m_camera = pvCameraIf;
                ((PvGeometry)pgGeometryIfArray[n8]).m_zBuffer = ((PvDisplay)pvDisplayIf).getZBuffer();
                ((PvGeometry)pgGeometryIfArray[n8]).m_colBuffer = this.m_colBuffer;
                ((PvGeometry)pgGeometryIfArray[n8]).m_tpBuffer = this.m_tpBuffer;
                if (bl7) {
                    if (!((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparencyOrig) {
                        ((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparency = true;
                        ((PvGeometry)pgGeometryIfArray[n8]).m_transparency = 0;
                    }
                } else if (!((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparencyOrig && ((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparency) {
                    ((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparency = ((PvGeometry)pgGeometryIfArray[n8]).m_bShowTransparencyOrig;
                    ((PvGeometry)pgGeometryIfArray[n8]).m_transparency = ((PvGeometry)pgGeometryIfArray[n8]).m_transparencyOrig;
                }
                ((PvGeometry)pgGeometryIfArray[n8]).m_backColor = pvDisplayIf.getBackgroundColor();
                ((PvGeometry)pgGeometryIfArray[n8]).m_bShowEdgeAura = pvDisplayIf.isShowingEdgeAura();
                ((PgGeometry)pgGeometryIfArray[n8]).showBndBox(pvDisplayIf.isShowingBndBox());
                ((PvGeometry)pgGeometryIfArray[n8]).m_bShowEdgeOnce = pvDisplayIf.isShowingEdgesOnce();
                ((PvGeometry)pgGeometryIfArray[n8]).m_bShowDepthcue = !((PvGeometry)pgGeometryIfArray[n8]).getState(150) && bl;
                ((PvGeometry)pgGeometryIfArray[n8]).m_scene = this;
                ((PvGeometry)pgGeometryIfArray[n8]).m_bEnableZBuffer = n6;
                PdMatrix pdMatrix7 = null;
                if (((PgGeometry)pgGeometryIfArray[n8]).hasModelMatrix()) {
                    pdMatrix7 = ((PgGeometry)pgGeometryIfArray[n8]).getModelMatrix();
                }
                if (pgGeometryIfArray[n8] == this.getGeometryContainer(((PvDisplay)pvDisplayIf).m_coordFrame)) {
                    ((PvGeometry)pgGeometryIfArray[n8]).projectItems(pdMatrix6, pdMatrix5, pdMatrix, pdMatrix7);
                } else {
                    ((PvGeometry)pgGeometryIfArray[n8]).projectItems(pdMatrix4, pdMatrix3, pdMatrix, pdMatrix7);
                }
                ((PvGeometry)pgGeometryIfArray[n8]).m_bAdaptiveSize = pvDisplayIf.isEnabledAdaptiveSize();
                ((PvGeometry)pgGeometryIfArray[n8]).m_bEnable3DLook = pvDisplayIf.isEnabled3DLook();
                this.m_zMin = Math.min(this.m_zMin, ((PvGeometry)pgGeometryIfArray[n8]).getZMin());
                this.m_zMax = Math.max(this.m_zMax, ((PvGeometry)pgGeometryIfArray[n8]).getZMax());
                if (((PvGeometry)pgGeometryIfArray[n8]).m_bEnable3DLook) {
                    ((PvGeometry)pgGeometryIfArray[n8]).m_camPos3D = pvCameraIf.getPosition();
                    ((PvGeometry)pgGeometryIfArray[n8]).m_camView3D = pvCameraIf.getViewDir();
                    ((PvGeometry)pgGeometryIfArray[n8]).m_camUp3D = pvCameraIf.getUpVector();
                    ((PvGeometry)pgGeometryIfArray[n8]).m_camHor3D.cross(((PvGeometry)pgGeometryIfArray[n8]).m_camView3D, ((PvGeometry)pgGeometryIfArray[n8]).m_camUp3D);
                    n3 = (int)((double)PvCamera.Z_STRETCH * PvCamera.SIZE / (double)Math.min(((PvDisplay)pvDisplayIf).m_nWidth, ((PvDisplay)pvDisplayIf).m_nHeight));
                    ((PvGeometry)pgGeometryIfArray[n8]).m_z3DLookFac = n3 / ((PvDisplay)pvDisplayIf).m_offFac;
                }
            }
            ++n8;
        }
        long l2 = 0L;
        if (pvDisplayIf.isEnabledAdaptiveSize() || pvDisplayIf.isEnabled3DLook()) {
            Enumeration enumeration = this.m_special.elements();
            while (enumeration.hasMoreElements()) {
                PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
                pvGeometry.m_bAdaptiveSize = false;
                pvGeometry.m_bEnable3DLook = false;
            }
        }
        if (this.m_bIsBurning) {
            n3 = 0;
            while (n3 < n4) {
                if (((PgGeometry)pgGeometryIfArray[n3]).isVisible()) {
                    PvScene.burnGeometry((PvGeometry)pgGeometryIfArray[n3], pvDisplayIf);
                }
                ++n3;
            }
            return;
        }
        if (bl6 || n6 != 0 || bl9 || bl8) {
            n3 = (dimension.height + dimension.width) * 2;
            this.m_faceDestBnd = PiVector.realloc(this.m_faceDestBnd, n3, this.m_dimWithZBuffer);
            if (this.m_bndIdentifier == null) {
                this.m_bndIdentifier = new PiVector();
            }
            this.m_bndIdentifier.setSize(2 * n3);
            if (this.m_colDestBnd == null || this.m_colDestBnd.length != n3) {
                this.m_colDestBnd = new float[n3][3];
            }
            if (this.m_lightDestBnd == null || this.m_lightDestBnd.length != n3) {
                this.m_lightDestBnd = new float[n3][6];
            }
            int n9 = 0;
            while (n9 < n4) {
                ((PvGeometry)pgGeometryIfArray[n9]).m_dispSize = dimension;
                if (this.m_imgWidth < 0) {
                    return;
                }
                ((PvGeometry)pgGeometryIfArray[n9]).setMIS(this.m_imgWidth, this.m_imgHeight, this.m_pix.m_data);
                ((PvGeometry)pgGeometryIfArray[n9]).m_faceDestBnd = this.m_faceDestBnd;
                ((PvGeometry)pgGeometryIfArray[n9]).m_colDestBnd = this.m_colDestBnd;
                ((PvGeometry)pgGeometryIfArray[n9]).m_lightDestBnd = this.m_lightDestBnd;
                ((PvGeometry)pgGeometryIfArray[n9]).m_bndIdentifier = this.m_bndIdentifier;
                ++n9;
            }
        } else {
            this.m_faceDestBnd = null;
            this.m_bndIdentifier = null;
            this.m_colDestBnd = null;
            this.m_lightDestBnd = null;
            n3 = 0;
            while (n3 < n4) {
                ((PvGeometry)pgGeometryIfArray[n3]).clearMIS();
                ((PvGeometry)pgGeometryIfArray[n3]).m_faceDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n3]).m_colDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n3]).m_lightDestBnd = null;
                ((PvGeometry)pgGeometryIfArray[n3]).m_bndIdentifier = null;
                ++n3;
            }
        }
        n3 = ((PvDisplay)pvDisplayIf).isEnabledFastZBuffer() ? 1 : 0;
        int n10 = 0;
        while (n10 < n4) {
            if (n3 != 0 && n6 != 0) {
                boolean bl10;
                boolean bl11 = ((PvGeometry)pgGeometryIfArray[n10]).m_bShowTransparency;
                boolean bl12 = ((PvGeometry)pgGeometryIfArray[n10]).m_bShowTexture;
                boolean bl13 = ((PvGeometry)pgGeometryIfArray[n10]).getState(101);
                boolean bl14 = ((PvGeometry)pgGeometryIfArray[n10]).getState(98);
                ((PvGeometry)pgGeometryIfArray[n10]).m_bFastScanline = bl10 = !bl && !bl11 && !bl12 && !bl13 && !bl14;
                ((PvGeometry)pgGeometryIfArray[n10]).m_bFastClipping = n3;
            } else {
                ((PvGeometry)pgGeometryIfArray[n10]).m_bFastScanline = false;
                ((PvGeometry)pgGeometryIfArray[n10]).m_bFastClipping = false;
            }
            ((PvGeometry)pgGeometryIfArray[n10]).m_bFastZBuffer = n3;
            ++n10;
        }
        this.copyItemHeight();
        if ((n3 == 0 || n6 == 0) && pvDisplayIf.isEnabledPainters() && this.m_numItems > 0) {
            PuMath.heapsort(this.m_numItems, this.m_itemHeight, this.m_itemSort);
            d2 = this.m_itemHeight[this.m_itemSort[0]];
            d3 = this.m_itemHeight[this.m_itemSort[this.m_numItems - 1]];
        } else {
            d3 = Double.NEGATIVE_INFINITY;
            d2 = Double.MAX_VALUE;
            n10 = 0;
            while (n10 < this.m_numItems) {
                if (this.m_itemHeight[n10] > d3) {
                    d3 = this.m_itemHeight[n10];
                } else if (this.m_itemHeight[n10] < d2) {
                    d2 = this.m_itemHeight[n10];
                }
                this.m_itemSort[n10] = n10;
                ++n10;
            }
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
            if ((pvGeometry.getDrawingOrder() & 2) == 0 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            pvGeometry.showBackface(true);
            int n11 = pvGeometry.getNumItems();
            n2 = 0;
            while (n2 < n11) {
                pvGeometry.drawItem(graphics, n2, d4, 0.0);
                ++n2;
            }
            pvGeometry.showBackface(false);
        }
        boolean bl15 = false;
        double d6 = d3 - d2;
        if (d6 < 1.0E-10) {
            bl15 = true;
            d4 = 1.0;
        }
        if (this.m_numGeometries == 1) {
            this.m_geomInd = 0;
            if (this.m_geometry[this.m_geomInd].isVisible()) {
                n2 = 0;
                int n12 = 0;
                while (n12 < this.m_numItems) {
                    n = !bl5 && n6 != 0 && !bl7 && !bl6 ? this.m_numItems - this.m_itemSort[n12] - 1 : this.m_itemSort[n12];
                    if (bl && !bl15) {
                        d4 = (this.m_itemHeight[n] - d2) / d6;
                    }
                    this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d4, this.m_itemHeight[n]);
                    if (this.m_geometry[this.m_geomInd].m_bElementDrawn) {
                        ++n2;
                    }
                    ++n12;
                }
            }
        } else {
            n2 = 0;
            while (n2 < this.m_numItems) {
                n = !bl5 && n6 != 0 && !bl7 && !bl6 ? this.m_numItems - this.m_itemSort[n2] - 1 : this.m_itemSort[n2];
                this.m_geomInd = this.getGeometryIndOfItem(n);
                if (this.m_geometry[this.m_geomInd].isVisible()) {
                    if (bl && !bl15) {
                        d4 = (this.m_itemHeight[n] - d2) / d6;
                    }
                    this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d4, this.m_itemHeight[n]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n4) {
            if (((PgGeometry)pgGeometryIfArray[n2]).isVisible() && (((PgGeometry)pgGeometryIfArray[n2]).isShowingName() || ((PgGeometry)pgGeometryIfArray[n2]).isShowingTitle())) {
                ((PvGeometry)pgGeometryIfArray[n2]).drawTitle(graphics);
            }
            ++n2;
        }
        Enumeration enumeration2 = this.m_special.elements();
        while (enumeration2.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration2.nextElement();
            if ((pvGeometry.getDrawingOrder() & 1) == 0 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            int n13 = pvGeometry.getNumItems();
            int n14 = 0;
            while (n14 < n13) {
                pvGeometry.drawItem(graphics, n14, d4, 0.0);
                ++n14;
            }
        }
    }

    protected void assureMIS_new(int n, int n2, PvDisplayIf pvDisplayIf, boolean bl) {
        if (this.m_mis == null || this.m_imgHeight != n2 || this.m_imgWidth != n || this.m_bTransparency != bl || this.m_bBackImage != pvDisplayIf.isShowingBackgroundImage() || this.m_backColor != pvDisplayIf.getBackgroundColor().getRGB()) {
            this.m_imgWidth = n;
            this.m_imgHeight = n2;
            if (this.m_pix == null) {
                this.m_pix = new PiVector();
                this.m_pixZero = new PiVector();
            }
            this.m_pix.setSize(this.m_imgWidth * this.m_imgHeight);
            this.m_pixZero.setSize(this.m_imgWidth);
            this.m_bBackImage = pvDisplayIf.isShowingBackgroundImage();
            this.m_backColor = pvDisplayIf.getBackgroundColor().getRGB();
            if (this.m_bBackImage) {
                Image image = ((PvDisplay)pvDisplayIf).m_imageOff;
                this.m_pix.copy(PsImage.getPixels(image), this.m_imgWidth * this.m_imgHeight);
            } else if (bl) {
                this.m_pixZero.setConstant(this.m_backColor & 0xFFFFFF);
            } else if (this.m_bTransparency != bl) {
                this.m_pixZero.setConstant(this.m_backColor);
            } else {
                this.m_pixZero.setConstant(this.m_backColor & 0xFFFFFF);
            }
            if (!this.m_bBackImage) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.m_imgHeight) {
                    System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, n3, this.m_imgWidth);
                    n3 += this.m_imgWidth;
                    ++n4;
                }
            }
            this.m_bTransparency = bl;
            this.m_mis = new MemoryImageSource(this.m_imgWidth, this.m_imgHeight, this.m_pix.m_data, 0, this.m_imgWidth);
            this.m_mis.setAnimated(true);
            this.m_destImage = ((Component)((Object)pvDisplayIf)).createImage(this.m_mis);
            return;
        }
        if (!this.m_bBackImage) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.m_imgHeight) {
                System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, n5, this.m_imgWidth);
                n5 += this.m_imgWidth;
                ++n6;
            }
            return;
        }
        Image image = ((PvDisplay)pvDisplayIf).m_imageOff;
        this.m_pix.copy(PsImage.getPixels(image), this.m_imgWidth * this.m_imgHeight);
    }

    protected void resetMIS() {
        this.m_bBackImage = false;
        this.m_backColor = -1;
        this.m_bTransparency = false;
        this.m_imgWidth = -1;
        this.m_imgHeight = -1;
        this.m_pix.setSize(0);
        this.m_pixZero.setSize(0);
        this.m_mis = null;
        this.m_destImage = null;
    }

    protected void drawMIS_new(Graphics graphics, PvDisplayIf pvDisplayIf) {
        if (this.m_mis == null) {
            return;
        }
        this.m_mis.newPixels();
        if (this.m_destImage != null) {
            graphics.drawImage(this.m_destImage, 0, 0, null);
        }
    }

    private void assureIndexList() {
        if (this.m_numGeometries == 0) {
            this.m_maxNumGeometries = 20;
            this.m_geometry = new PvGeometry[this.m_maxNumGeometries];
            this.m_itemInd = new int[this.m_maxNumGeometries][3];
            this.m_numItems = 0;
            this.m_itemHeight = null;
            this.m_itemSort = null;
            return;
        }
        this.m_itemInd[0][0] = 0;
        int n = 0;
        while (n < this.m_numGeometries) {
            this.m_itemInd[n][1] = this.m_itemInd[n][0] + this.m_itemInd[n][2] - 1;
            if (n + 1 < this.m_numGeometries) {
                this.m_itemInd[n + 1][0] = this.m_itemInd[n][1] + 1;
            }
            ++n;
        }
        this.m_numItems = this.m_itemInd[this.m_numGeometries - 1][1] + 1;
        if (this.m_itemHeight == null || this.m_itemHeight.length != this.m_numItems) {
            this.m_itemHeight = new double[this.m_numItems];
            this.m_itemSort = new int[this.m_numItems];
        }
    }

    public boolean update(Object object) {
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            if (object != enumeration.nextElement()) continue;
            return true;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == object) {
                if (this.m_itemInd[n][2] == this.m_geometry[n].getNumItems()) {
                    return true;
                }
                this.m_itemInd[n][2] = this.m_geometry[n].getNumItems();
                this.assureIndexList();
                return super.update(null);
            }
            ++n;
        }
        PsDebug.warning("missing geometry");
        return super.update(object);
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_allGeometry;
    }

    public void selectGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        int n = 0;
        while (n < this.m_numAllGeometries) {
            if (this.m_allGeometry[n] == pvGeometry) {
                this.m_currentGeom = pvGeometry;
                return;
            }
            ++n;
        }
        PsDebug.warning("geometry not found, name = " + pvGeometry.getGeometry().getName());
    }

    public static void burnGeometry(PvGeometry pvGeometry, PvDisplayIf pvDisplayIf) {
        int n = pvGeometry.m_textureWidth;
        int n2 = pvGeometry.m_textureHeight;
        if (n < 1 || n2 < 1) {
            PsDebug.warning("missing texture");
            return;
        }
        int[] nArray = new int[n * n2];
        PsScanline psScanline = new PsScanline();
        boolean bl = false;
        PdVector[][] pdVectorArray = pvGeometry.getElementTextures();
        int n3 = pvGeometry.getNumElements();
        int n4 = 0;
        while (n4 < n3) {
            psScanline.makeScanlines((int)(pdVectorArray[n4][0].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[n4][0].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray[n4][1].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[n4][1].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray[n4][2].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray[n4][2].m_data[1]) * (double)(n2 - 1)));
            pvGeometry.burnElement(n4, nArray, n, n2, psScanline, bl);
            ++n4;
        }
        pvGeometry.setTexture(nArray, n, n2, 0, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        Image image = ((Component)((Object)pvDisplayIf)).createImage(memoryImageSource);
        pvGeometry.getGeometry().setTextureImage(image);
    }

    public double getDiameter() {
        if (this.m_numItems == 0) {
            return 0.0;
        }
        PdVector[] pdVectorArray = this.getBounds();
        double d = PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
        return d;
    }

    private void copyItemHeight() {
        int n = 0;
        while (n < this.m_numGeometries) {
            int n2;
            int[] nArray;
            double d;
            int[] nArray2;
            int n3;
            int n4;
            int n5 = 0;
            PvGeometry pvGeometry = this.m_geometry[n];
            if (pvGeometry.m_useVertices) {
                n4 = pvGeometry.getNumVertices();
                n3 = 0;
                while (n3 < n4) {
                    this.m_itemHeight[this.m_itemInd[n][0] + n3] = pvGeometry.m_vertexTrans[n3].m_data[2];
                    ++n3;
                }
                n5 = n4;
            } else if (pvGeometry.m_useUnusedVertices && (nArray2 = pvGeometry.getUnusedVertices()) != null) {
                int n6 = pvGeometry.getNumUnusedVertices();
                n3 = 0;
                while (n3 < n6) {
                    this.m_itemHeight[this.m_itemInd[n][0] + n3] = pvGeometry.m_vertexTrans[nArray2[n3]].m_data[2];
                    ++n3;
                }
                n5 = n6;
            }
            if (pvGeometry.m_useElements) {
                n4 = pvGeometry.getNumElements();
                PiVector[] piVectorArray = pvGeometry.getElements();
                n3 = 0;
                while (n3 < n4) {
                    d = 0.0;
                    nArray = piVectorArray[n3].m_data;
                    if (nArray != null && nArray.length > 0) {
                        n2 = 0;
                        while (n2 < nArray.length) {
                            d += (double)pvGeometry.m_vertexTrans[nArray[n2]].m_data[2];
                            ++n2;
                        }
                        d /= (double)nArray.length;
                    }
                    this.m_itemHeight[this.m_itemInd[n][0] + n5 + n3] = d;
                    ++n3;
                }
                n5 += n4;
            }
            if (pvGeometry.m_usePolygons) {
                n4 = pvGeometry.getNumPolygons();
                PiVector[] piVectorArray = pvGeometry.getPolygons();
                n3 = 0;
                while (n3 < n4) {
                    d = 0.0;
                    nArray = piVectorArray[n3].m_data;
                    if (nArray != null && nArray.length > 1) {
                        n2 = 0;
                        while (n2 < nArray.length - 1) {
                            d = (double)(pvGeometry.m_vertexTrans[nArray[n2]].m_data[2] + pvGeometry.m_vertexTrans[nArray[n2 + 1]].m_data[2]) / 2.0;
                            this.m_itemHeight[this.m_itemInd[n][0] + n5++] = d;
                            ++n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected PvGeometry getGeometryContainer(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return null;
        }
        int n = 0;
        while (n < this.m_numAllGeometries) {
            if (this.m_allGeometry[n].getGeometry() == pgGeometryIf) {
                return this.m_allGeometry[n];
            }
            ++n;
        }
        return null;
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[this.m_maxNumGeometries];
        PdVector[] pdVectorArray2 = new PdVector[this.m_maxNumGeometries];
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            PdVector[] pdVectorArray3;
            if (this.m_geometry[n2].isVisible() && !(this.m_geometry[n2].m_geometry instanceof PvLight) && (pdVectorArray3 = this.m_geometry[n2].getBounds(true)) != null) {
                pdVectorArray[n] = pdVectorArray3[0];
                pdVectorArray2[n] = pdVectorArray3[1];
                ++n;
            }
            ++n2;
        }
        if (n != 0) {
            PdVector.min(this.m_bndBox[0], pdVectorArray, n);
            PdVector.max(this.m_bndBox[1], pdVectorArray2, n);
        }
        if (n == 0) {
            this.m_bndBox[0].setConstant(0.0);
            this.m_bndBox[1].setConstant(0.0);
            return this.m_bndBox;
        }
        return this.m_bndBox;
    }

    public void init() {
        super.init();
        this.m_name = null;
        this.m_dim = 3;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-10.0);
        this.m_bndBox[1].setConstant(10.0);
        this.m_center = new PdVector(this.m_dim);
        this.m_center.setConstant(0.0);
    }

    public PvGeometry removeGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return null;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_special.removeElement(pvGeometry);
            this.collectAllGeometries();
            if (pvGeometry == this.m_currentGeom) {
                if (this.m_numGeometries > 0) {
                    int n = 0;
                    int n2 = 0;
                    while (n2 < this.m_numGeometries) {
                        if (this.m_geometry[n2].isVisible()) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    this.selectGeometry(this.m_geometry[n]);
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
            }
            return this.m_currentGeom;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == pvGeometry) {
                this.m_numGeometries += -1;
                if (n < this.m_numGeometries) {
                    this.m_geometry[n] = this.m_geometry[this.m_numGeometries];
                    this.m_itemInd[n][2] = this.m_itemInd[this.m_numGeometries][2];
                }
                this.m_geometry[this.m_numGeometries] = null;
                this.collectAllGeometries();
                this.assureIndexList();
                if (this.m_numGeometries > 0) {
                    if (pvGeometry == this.m_currentGeom) {
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < this.m_numGeometries) {
                            if (this.m_geometry[n4].isVisible()) {
                                n3 = n4;
                                break;
                            }
                            ++n4;
                        }
                        this.selectGeometry(this.m_geometry[n3]);
                    }
                } else {
                    this.m_currentGeom = null;
                }
                this.m_itemInd[this.m_numGeometries][2] = 0;
                return this.m_currentGeom;
            }
            ++n;
        }
        return this.m_currentGeom;
    }

    public void addGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (pvGeometry.isSpecial() || pvGeometry.getDrawingOrder() != 0) {
            this.m_special.addElement(pvGeometry);
            this.collectAllGeometries();
        } else {
            int n = 0;
            while (n < this.m_numGeometries) {
                if (this.m_geometry[n] == pvGeometry) {
                    this.update(pvGeometry);
                    return;
                }
                ++n;
            }
            if (this.m_numGeometries == this.m_maxNumGeometries) {
                int[][] nArray = this.m_itemInd;
                PvGeometry[] pvGeometryArray = new PvGeometry[2 * this.m_maxNumGeometries];
                this.m_itemInd = new int[2 * this.m_maxNumGeometries][3];
                int n2 = 0;
                while (n2 < this.m_maxNumGeometries) {
                    pvGeometryArray[n2] = this.m_geometry[n2];
                    int n3 = 0;
                    do {
                        this.m_itemInd[n2][n3] = nArray[n2][n3];
                    } while (++n3 < 3);
                    ++n2;
                }
                this.m_geometry = pvGeometryArray;
                this.m_maxNumGeometries = 2 * this.m_maxNumGeometries;
            }
            this.m_geometry[this.m_numGeometries++] = pvGeometry;
            this.collectAllGeometries();
            if (this.m_numGeometries == 1) {
                this.selectGeometry(pvGeometry);
            }
        }
        this.update(pvGeometry);
    }

    protected double getHeightOfElementInCurrentGeometry(int n) {
        if (n > this.m_itemInd[this.m_geomInd][2]) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = n + this.m_itemInd[this.m_geomInd][0];
        return this.m_itemHeight[n2];
    }
}

