/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdColor;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.project.PgGeometryIf;
import jv.project.PvLightIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jv.viewer.PvLight;

public class PvLight_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvLight m_light;
    protected PvDisplay m_display;
    protected TextField m_tName;
    protected Checkbox m_cLightModel;
    protected List m_listSelect;
    protected Button m_bAddDefault;
    protected Button m_bAddRGB;
    protected Button m_bAdd;
    protected Button m_bDuplicate;
    protected Button m_bDelete;
    protected Checkbox m_cSwitchedOn;
    protected Checkbox m_cVisible;
    protected Checkbox m_cHighlight;
    protected Choice m_cShading;
    protected PdColor m_color;
    protected PsPanel m_pColor;
    protected CheckboxGroup m_gType;
    protected Checkbox m_rAmbient;
    protected Checkbox m_rDirection;
    protected Checkbox m_rPoint;
    protected Checkbox m_rSpot;
    protected Checkbox m_rShadow;
    protected Checkbox m_rHead;
    protected Checkbox m_rSky;
    protected PsPanel m_pOrient;
    protected Checkbox m_cOrient;
    protected Checkbox m_cCamera;
    protected PdVector m_interest;
    protected PdVector_IP m_pInterest;
    protected PdVector m_position;
    protected PdVector_IP m_pPosition;
    protected Button m_bPickNDrag;
    protected boolean m_bPickNDragMode = false;
    private Color m_pickNDragColor = null;
    protected PuDouble m_intensity;
    protected PuDouble m_angle;
    protected PuDouble m_corona;
    protected PuDouble m_falloff;
    protected PuDouble m_exponent;
    protected PuDouble m_blend;
    protected boolean m_bDeleteMode = false;
    private Color m_deleteColor;
    protected boolean m_bDuplicateMode = false;
    private Color m_duplicateColor;
    protected Button m_bReset;
    protected Button m_bResetAll;
    private PgGeometryIf m_selectedGeom = null;
    private static /* synthetic */ Class class$jv$viewer$PvLight_IP;

    protected void setDisplay(PvDisplay pvDisplay) {
        this.m_display = pvDisplay;
        if (this.m_display != null) {
            this.setTitle(PsConfig.getMessage(24310) + " " + this.m_display.getName());
        }
    }

    public PvLight_IP() {
        if (this.getClass() == (class$jv$viewer$PvLight_IP != null ? class$jv$viewer$PvLight_IP : (class$jv$viewer$PvLight_IP = PvLight_IP.class$("jv.viewer.PvLight_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_display == null) {
            PsDebug.warning("missing display in light panel");
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cLightModel) {
            if (this.m_cLightModel.getState()) {
                this.m_display.setLightingModel(1);
                if (this.m_light == null) {
                    this.m_display.createDefaultLights();
                }
            } else {
                this.m_display.setLightingModel(0);
            }
            this.m_display.update(this.m_light);
            return;
        }
        if (this.m_light == null) {
            return;
        }
        if (object == this.m_rAmbient) {
            this.m_light.setLightType(0);
            if (this.m_light.isVisible()) {
                this.m_light.setVisible(false);
            }
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rDirection) {
            this.m_light.setLightType(1);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rPoint) {
            this.m_light.setLightType(2);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rSpot) {
            this.m_light.setLightType(3);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rShadow) {
            this.m_light.setLightType(4);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rHead) {
            this.m_light.setLightType(5);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_rSky) {
            this.m_light.setLightType(6);
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_cSwitchedOn) {
            this.m_light.setSwitchedOn(this.m_cSwitchedOn.getState());
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_cShading) {
            this.m_light.setShading(this.m_cShading.getSelectedIndex());
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_cVisible) {
            this.m_light.setVisible(this.m_cVisible.getState());
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_cHighlight) {
            this.m_light.setHighlight(this.m_cHighlight.getState());
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_cCamera) {
            PdVector pdVector = new PdVector(3);
            if (this.m_cCamera.getState()) {
                PdMatrix pdMatrix = this.m_display.getTransMatrix(4);
                pdVector.leftMultAffin(pdMatrix, this.m_light.m_position, true);
                this.m_light.setPosition(pdVector);
                pdVector.leftMultAffin(pdMatrix, this.m_light.m_interest, true);
                this.m_light.setInterest(pdVector);
                this.m_light.setReference(1);
            } else {
                PdMatrix pdMatrix = this.m_display.getTransMatrix(128);
                pdVector.leftMultAffin(pdMatrix, this.m_light.m_position, true);
                this.m_light.setPosition(pdVector);
                pdVector.leftMultAffin(pdMatrix, this.m_light.m_interest, true);
                this.m_light.setInterest(pdVector);
                this.m_light.setReference(0);
            }
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_listSelect) {
            PvLight pvLight = (PvLight)this.getSelectedLight();
            if (this.m_bDeleteMode) {
                this.m_display.removeLight(pvLight);
                this.m_bDeleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel("   " + PsConfig.getMessage(24071) + "   ");
            } else if (this.m_bDuplicateMode) {
                PvLight pvLight2 = (PvLight)pvLight.clone();
                pvLight2.setName(PsConfig.getMessage(15025) + " " + pvLight.getName());
                this.m_display.addLight(pvLight2);
                this.m_display.selectLight(pvLight2);
                this.m_bDuplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage(24070));
            } else {
                int n = pvLight.getLightType();
                if (n == 1 || n == 2 || n == 4 || n == 3) {
                    this.m_bPickNDrag.setEnabled(true);
                    if (this.m_bPickNDragMode) {
                        if (!pvLight.isVisible()) {
                            pvLight.setVisible(true);
                            pvLight.setSwitchedOn(true);
                            this.m_cSwitchedOn.setState(true);
                            pvLight.update(null);
                        }
                        this.m_display.selectGeometry(pvLight);
                    }
                } else {
                    this.m_bPickNDrag.setEnabled(false);
                    if (this.m_bPickNDragMode) {
                        this.m_bPickNDragMode = false;
                        this.m_bPickNDrag.setBackground(this.m_pickNDragColor);
                        this.m_display.setTransformationMode(0);
                        if (this.m_selectedGeom != null) {
                            this.m_display.selectGeometry(this.m_selectedGeom);
                        }
                    }
                }
                this.m_display.selectLight(pvLight);
            }
            this.m_display.update(this.m_display);
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        if (psUpdateIf == null) {
            this.m_light = null;
            this.m_listSelect.removeAll();
            super.setParent(null);
            return;
        }
        super.setParent(psUpdateIf);
        this.m_light = (PvLight)psUpdateIf;
        this.m_display = (PvDisplay)this.m_light.getDisplay();
        if (this.m_display != null) {
            this.setTitle(PsConfig.getMessage(24310) + " " + this.m_display.getName());
        }
        this.m_intensity.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_intensity.setDefValue(this.m_light.m_defIntensity);
        this.m_intensity.init();
        this.m_angle.setDefBounds(0.0, 90.0, 0.1, 1.0);
        this.m_angle.setDefValue(this.m_light.m_defAngle);
        this.m_angle.init();
        this.m_corona.setDefBounds(0.0, 90.0, 0.1, 1.0);
        this.m_corona.setDefValue(this.m_light.m_defCorona);
        this.m_corona.init();
        this.m_falloff.setDefBounds(0.0, 100.0, 0.1, 1.0);
        this.m_falloff.setDefValue(this.m_light.m_defFalloff);
        this.m_falloff.init();
        this.m_exponent.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_exponent.setDefValue(this.m_light.m_defExponent);
        this.m_exponent.init();
        this.m_blend.setDefBounds(0.0, 20.0, 0.1, 1.0);
        this.m_blend.setDefValue(this.m_light.m_defBlend);
        this.m_blend.init();
    }

    public boolean update(Object object) {
        if (this.m_light == null || object == null) {
            PsPanel.setText(this.m_tName, "");
            this.m_color.setColor(Color.black);
            this.m_interest.setConstant(0.0);
            this.m_position.setConstant(0.0);
            return true;
        }
        if (object == this.m_light) {
            int n;
            boolean bl = this.m_display.getLightingModel() == 1;
            PsPanel.setState(this.m_cLightModel, bl);
            boolean bl2 = true;
            int n2 = this.m_listSelect.getItemCount();
            int n3 = this.m_display.getNumLights();
            PvLightIf[] pvLightIfArray = this.m_display.getLights();
            if (n2 != n3) {
                bl2 = false;
            } else {
                n = 0;
                while (n < n3) {
                    String string = this.m_listSelect.getItem(n);
                    if (string == null || !string.equals(pvLightIfArray[n].getName())) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl2) {
                if (n2 > 0) {
                    this.m_listSelect.removeAll();
                }
                n = 0;
                while (n < n3) {
                    this.m_listSelect.add(pvLightIfArray[n].getName());
                    ++n;
                }
            }
            n = 0;
            while (n < n3) {
                if (pvLightIfArray[n] == this.m_display.m_currentLight) {
                    this.m_listSelect.select(n);
                    break;
                }
                ++n;
            }
            PsPanel.setText(this.m_tName, this.m_light.getName());
            PsPanel.setState(this.m_cSwitchedOn, this.m_light.isSwitchedOn());
            n = this.m_light.getLightType();
            PsPanel.setState(this.m_cVisible, this.m_light.isVisible());
            PsPanel.setEnabled(this.m_cVisible, n != 0);
            PsPanel.setState(this.m_cHighlight, this.m_light.isHighlight());
            PsPanel.setEnabled(this.m_cHighlight, n != 0 && n != 5 && n != 6);
            boolean bl3 = n == 1 || n == 2 || n == 4 || n == 3;
            PsPanel.setEnabled(this.m_bPickNDrag, bl3);
            PsPanel.setState(this.m_cCamera, this.m_light.getReference() == 1);
            PsPanel.setEnabled(this.m_cCamera, bl3);
            PsPanel.select(this.m_cShading, this.m_light.getShading());
            PsPanel.setEnabled(this.m_cShading, n != 0);
            if (this.m_display.getSelectedGeometry() != this.m_light && this.m_bPickNDragMode) {
                this.m_display.setTransformationMode(0);
                this.m_bPickNDragMode = false;
                this.m_bPickNDrag.setBackground(this.m_pickNDragColor);
            }
            switch (n) {
                default: {
                    PsDebug.warning("unknown type of light, type = " + String.valueOf(n));
                    break;
                }
                case 0: {
                    this.m_gType.setSelectedCheckbox(this.m_rAmbient);
                    PsPanel.setEnabled(this.m_pInterest, false);
                    PsPanel.setEnabled(this.m_pPosition, false);
                    this.m_exponent.setEnabled(false);
                    break;
                }
                case 1: {
                    this.m_gType.setSelectedCheckbox(this.m_rDirection);
                    PsPanel.setEnabled(this.m_pInterest, true);
                    PsPanel.setEnabled(this.m_pPosition, true);
                    this.m_exponent.setEnabled(false);
                    break;
                }
                case 2: {
                    this.m_gType.setSelectedCheckbox(this.m_rPoint);
                    PsPanel.setEnabled(this.m_pInterest, true);
                    PsPanel.setEnabled(this.m_pPosition, true);
                    this.m_exponent.setEnabled(true);
                    break;
                }
                case 3: {
                    this.m_gType.setSelectedCheckbox(this.m_rSpot);
                    PsPanel.setEnabled(this.m_pInterest, true);
                    PsPanel.setEnabled(this.m_pPosition, true);
                    this.m_exponent.setEnabled(true);
                    break;
                }
                case 4: {
                    this.m_gType.setSelectedCheckbox(this.m_rShadow);
                    PsPanel.setEnabled(this.m_pInterest, true);
                    PsPanel.setEnabled(this.m_pPosition, true);
                    this.m_exponent.setEnabled(false);
                    break;
                }
                case 5: {
                    this.m_gType.setSelectedCheckbox(this.m_rHead);
                    PsPanel.setEnabled(this.m_pInterest, false);
                    PsPanel.setEnabled(this.m_pPosition, false);
                    this.m_exponent.setEnabled(false);
                    break;
                }
                case 6: {
                    this.m_gType.setSelectedCheckbox(this.m_rSky);
                    PsPanel.setEnabled(this.m_pInterest, false);
                    PsPanel.setEnabled(this.m_pPosition, false);
                    this.m_exponent.setEnabled(false);
                }
            }
            this.m_angle.setEnabled(n == 3);
            this.m_corona.setEnabled(n == 3);
            this.m_falloff.setEnabled(n == 3);
            this.m_blend.setEnabled(false);
            this.m_color.setColor(this.m_light.getColor());
            this.m_pColor.update(this.m_color);
            this.m_interest.copy(this.m_light.getInterest());
            this.m_pInterest.update(this.m_interest);
            this.m_position.copy(this.m_light.getPosition());
            this.m_pPosition.update(this.m_position);
            this.m_intensity.setValue(this.m_light.getIntensity());
            this.m_angle.setValue(this.m_light.getAngle());
            this.m_corona.setValue(this.m_light.getCorona());
            this.m_falloff.setValue(this.m_light.getFalloff());
            this.m_exponent.setValue(this.m_light.getExponent());
            this.m_blend.setValue(this.m_light.getBlend());
            return true;
        }
        if (object == this) {
            this.m_light.setColor(this.m_color.getColor());
            this.m_light.setInterest(this.m_pInterest.getVector());
            this.m_light.setPosition(this.m_pPosition.getVector());
            this.m_light.setIntensity(this.m_intensity.getValue());
            this.m_light.setAngle(this.m_angle.getValue());
            this.m_light.setCorona(this.m_corona.getValue());
            this.m_light.setFalloff(this.m_falloff.getValue());
            this.m_light.setExponent(this.m_exponent.getValue());
            this.m_light.setBlend(this.m_blend.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_color) {
            this.m_light.setColor(this.m_color.getColor());
            return this.m_light.update(null);
        }
        if (object == this.m_pInterest) {
            this.m_light.setInterest(this.m_pInterest.getVector());
            return this.m_light.update(null);
        }
        if (object == this.m_pPosition) {
            this.m_light.setPosition(this.m_pPosition.getVector());
            return this.m_light.update(null);
        }
        if (object == this.m_intensity) {
            this.m_light.setIntensity(this.m_intensity.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_angle) {
            this.m_light.setAngle(this.m_angle.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_corona) {
            this.m_light.setCorona(this.m_corona.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_falloff) {
            this.m_light.setFalloff(this.m_falloff.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_exponent) {
            this.m_light.setExponent(this.m_exponent.getValue());
            return this.m_light.update(null);
        }
        if (object == this.m_blend) {
            this.m_light.setBlend(this.m_blend.getValue());
            return this.m_light.update(null);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PvLight[] pvLightArray;
        Object object = actionEvent.getSource();
        if (object == this.m_bAddDefault) {
            this.m_display.setLightingModel(1);
            this.m_display.createDefaultLights();
            this.m_display.update(this.m_display);
        } else if (object == this.m_bAddRGB) {
            this.m_display.setLightingModel(1);
            this.m_display.createRGBLights();
            this.m_display.update(this.m_display);
        } else if (object == this.m_bAdd) {
            pvLightArray = new PvLight(this.m_display, 2);
            pvLightArray.setName(pvLightArray.getName() + String.valueOf(PsObject.getNumObjects()));
            pvLightArray.setVisible(true);
            this.m_display.setLightingModel(1);
            this.m_display.addLight((PvLightIf)pvLightArray);
            this.m_display.selectLight((PvLightIf)pvLightArray);
            this.m_display.update(this.m_display);
        }
        if (this.m_light == null) {
            return;
        }
        if (object == this.m_bReset) {
            this.m_light.init();
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_bDuplicate) {
            if (this.m_bDuplicateMode) {
                this.m_bDuplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage(24070));
                return;
            }
            this.m_bDuplicateMode = true;
            this.m_duplicateColor = this.m_bDuplicate.getBackground();
            this.m_bDuplicate.setBackground(Color.red);
            this.m_bDuplicate.setLabel(PsConfig.getMessage(true, 24000, "Click Light"));
            return;
        }
        if (object == this.m_bDelete) {
            if (this.m_bDeleteMode) {
                this.m_bDeleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel("   " + PsConfig.getMessage(24071) + "   ");
                return;
            }
            this.m_bDeleteMode = true;
            this.m_deleteColor = this.m_bDuplicate.getBackground();
            this.m_bDelete.setBackground(Color.red);
            this.m_bDelete.setLabel(PsConfig.getMessage(true, 24000, "Click Light"));
            return;
        }
        if (object == this.m_bResetAll) {
            pvLightArray = (PvLight[])this.m_display.getLights();
            if (pvLightArray == null || pvLightArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < pvLightArray.length) {
                pvLightArray[n].init();
                ++n;
            }
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_tName) {
            this.m_light.setName(this.m_tName.getText());
            this.m_light.update(this.m_light);
            return;
        }
        if (object == this.m_bPickNDrag) {
            if (this.m_bPickNDragMode) {
                this.m_bPickNDragMode = false;
                this.m_bPickNDrag.setBackground(this.m_pickNDragColor);
                this.m_display.setTransformationMode(0);
                if (this.m_selectedGeom != null) {
                    this.m_display.selectGeometry(this.m_selectedGeom);
                }
            } else {
                this.m_bPickNDragMode = true;
                this.m_pickNDragColor = this.m_bPickNDrag.getBackground();
                this.m_bPickNDrag.setBackground(Color.red);
                this.m_display.setTransformationMode(1);
                this.m_selectedGeom = this.m_display.getSelectedGeometry();
                if (!this.m_display.containsGeometry(this.m_light)) {
                    this.m_display.addGeometry(this.m_light);
                }
                if (!this.m_light.isVisible()) {
                    this.m_light.setVisible(true);
                    this.m_light.setSwitchedOn(true);
                    this.m_cSwitchedOn.setState(true);
                    this.m_light.update(null);
                }
                this.m_display.selectGeometry(this.m_light);
            }
            this.m_display.update(this.m_display);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PvLightIf getSelectedLight() {
        String string = this.m_listSelect.getSelectedItem();
        PvLightIf[] pvLightIfArray = this.m_display.getLights();
        int n = 0;
        while (n < pvLightIfArray.length) {
            if (string.equals(pvLightIfArray[n].getName())) {
                return pvLightIfArray[n];
            }
            ++n;
        }
        return null;
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        PsMultiLineLabel psMultiLineLabel = new PsMultiLineLabel(PsConfig.getMessage(24296));
        this.add(psMultiLineLabel);
        Panel panel = new Panel(new GridLayout(1, 2));
        this.setTitle(PsConfig.getMessage(24242));
        Component component = this.getTitle();
        component.setFont(PsConfig.getFont(3));
        panel.add(component);
        this.m_cLightModel = new Checkbox(PsConfig.getMessage(24348));
        this.m_cLightModel.addItemListener(this);
        panel.add(this.m_cLightModel);
        this.add(panel);
        component = new PsPanel(new BorderLayout());
        this.m_listSelect = new List(4, false);
        this.m_listSelect.addItemListener(this);
        ((Container)component).add(this.m_listSelect, "Center");
        this.add(component);
        PsPanel psPanel = new PsPanel(new GridLayout(2, 2));
        psPanel.addTitle(PsConfig.getMessage(24306));
        Panel panel2 = new Panel(new GridLayout(1, 2));
        this.m_cSwitchedOn = new Checkbox(PsConfig.getMessage(24299));
        this.m_cSwitchedOn.addItemListener(this);
        panel2.add(this.m_cSwitchedOn);
        this.m_cVisible = new Checkbox(PsConfig.getMessage(24300));
        this.m_cVisible.addItemListener(this);
        panel2.add(this.m_cVisible);
        psPanel.add(panel2);
        Component component2 = new Label(PsConfig.getMessage(true, 24000, "Name"));
        psPanel.add(component2);
        this.m_tName = new TextField("", 7);
        this.m_tName.addActionListener(this);
        psPanel.add(this.m_tName);
        this.add(psPanel);
        panel2 = new PsPanel(new GridLayout(1, 2));
        ((PsPanel)panel2).addTitle(PsConfig.getMessage(24298));
        component2 = new Panel(new GridLayout(1, 2));
        Component component3 = new Label(PsConfig.getMessage(true, 24000, "Shading"));
        ((Container)component2).add(component3);
        this.m_cShading = new Choice();
        this.m_cShading.addItemListener(this);
        this.m_cShading.addItem(PsConfig.getMessage(true, 24000, "Symmetric"));
        this.m_cShading.addItem(PsConfig.getMessage(true, 24000, "Halfsphere"));
        this.m_cShading.addItem(PsConfig.getMessage(true, 24000, "Uniform Sky"));
        ((Container)component2).add(this.m_cShading);
        panel2.add(component2);
        this.add(panel2);
        int n = 2;
        component3 = new Panel(new GridLayout(n, 3));
        this.m_gType = new CheckboxGroup();
        this.m_rAmbient = new Checkbox(PsConfig.getMessage(24232), this.m_gType, false);
        this.m_rAmbient.addItemListener(this);
        ((Container)component3).add(this.m_rAmbient);
        this.m_rHead = new Checkbox(PsConfig.getMessage(24415), this.m_gType, true);
        this.m_rHead.addItemListener(this);
        ((Container)component3).add(this.m_rHead);
        this.m_rSky = new Checkbox(PsConfig.getMessage(24416), this.m_gType, false);
        this.m_rSky.addItemListener(this);
        ((Container)component3).add(this.m_rSky);
        this.m_rDirection = new Checkbox(PsConfig.getMessage(24301), this.m_gType, false);
        this.m_rDirection.addItemListener(this);
        ((Container)component3).add(this.m_rDirection);
        this.m_rPoint = new Checkbox(PsConfig.getMessage(24426), this.m_gType, false);
        this.m_rPoint.addItemListener(this);
        ((Container)component3).add(this.m_rPoint);
        this.m_rSpot = new Checkbox(PsConfig.getMessage(24303), this.m_gType, false);
        this.m_rSpot.addItemListener(this);
        ((Container)component3).add(this.m_rSpot);
        this.m_rShadow = new Checkbox(PsConfig.getMessage(24304), this.m_gType, false);
        this.m_rShadow.addItemListener(this);
        this.m_rShadow.setEnabled(false);
        this.add(component3);
        PsPanel psPanel2 = new PsPanel();
        this.add(psPanel2);
        Panel panel3 = new PsPanel(new GridLayout(1, 2));
        ((PsPanel)panel3).addTitle(PsConfig.getMessage(24305));
        this.m_cHighlight = new Checkbox(PsConfig.getMessage(true, 24000, "Highlight"));
        this.m_cHighlight.addItemListener(this);
        panel3.add(this.m_cHighlight);
        psPanel2.add(panel3);
        this.m_color = new PdColor(PsConfig.getMessage(24290), this);
        this.m_pColor = this.m_color.getInfoPanel();
        psPanel2.add(this.m_pColor);
        this.m_intensity = new PuDouble(PsConfig.getMessage(24291), this);
        psPanel2.add(this.m_intensity.getInfoPanel());
        this.m_exponent = new PuDouble(PsConfig.getMessage(24295), this);
        psPanel2.add(this.m_exponent.getInfoPanel());
        this.m_pOrient = new PsPanel();
        this.add(this.m_pOrient);
        panel3 = new PsPanel(new GridLayout(1, 2));
        ((PsPanel)panel3).addTitle(PsConfig.getMessage(24225));
        this.m_cCamera = new Checkbox(PsConfig.getMessage(true, 24000, "Fixed to Camera"));
        this.m_cCamera.addItemListener(this);
        panel3.add(this.m_cCamera);
        this.m_pOrient.add(panel3);
        this.m_pInterest = new PdVector_IP();
        this.m_pInterest.setTitle(PsConfig.getMessage(24227));
        this.m_pInterest.setParent(this);
        this.m_interest = new PdVector(3);
        this.m_pInterest.setVector(this.m_interest);
        this.m_pOrient.add(this.m_pInterest);
        this.m_pPosition = new PdVector_IP();
        this.m_pPosition.setTitle(PsConfig.getMessage(24225));
        this.m_pPosition.setParent(this);
        this.m_position = new PdVector(3);
        this.m_pPosition.setVector(this.m_position);
        this.m_pOrient.add(this.m_pPosition);
        this.m_angle = new PuDouble(PsConfig.getMessage(24292), this);
        this.m_pOrient.add(this.m_angle.getInfoPanel());
        this.m_corona = new PuDouble(PsConfig.getMessage(24293), this);
        this.m_pOrient.add(this.m_corona.getInfoPanel());
        this.m_falloff = new PuDouble(PsConfig.getMessage(24294), this);
        this.m_pOrient.add(this.m_falloff.getInfoPanel());
        this.m_blend = new PuDouble(PsConfig.getMessage(24425), this);
        panel3 = new Panel(new FlowLayout(1));
        this.add(panel3);
        this.m_bPickNDrag = new Button(PsConfig.getMessage(true, 24000, "Pick'n Drag"));
        this.m_bPickNDrag.addActionListener(this);
        panel3.add(this.m_bPickNDrag);
        this.m_bAddDefault = new Button(PsConfig.getMessage(24307));
        this.m_bAddDefault.addActionListener(this);
        panel3.add(this.m_bAddDefault);
        this.m_bAddRGB = new Button(PsConfig.getMessage(24308));
        this.m_bAddRGB.addActionListener(this);
        panel3.add(this.m_bAddRGB);
        Panel panel4 = new Panel(new FlowLayout(1));
        this.add(panel4);
        this.m_bAdd = new Button(PsConfig.getMessage(24309));
        this.m_bAdd.addActionListener(this);
        panel4.add(this.m_bAdd);
        this.m_bDuplicate = new Button(PsConfig.getMessage(24070));
        this.m_bDuplicate.addActionListener(this);
        panel4.add(this.m_bDuplicate);
        this.m_bDelete = new Button("   " + PsConfig.getMessage(24071) + "   ");
        this.m_bDelete.addActionListener(this);
        panel4.add(this.m_bDelete);
        this.m_bReset = new Button(PsConfig.getMessage(24104));
        this.m_bReset.addActionListener(this);
        panel4.add(this.m_bReset);
        this.m_bResetAll = new Button(PsConfig.getMessage(24237));
        this.m_bResetAll.addActionListener(this);
        panel4.add(this.m_bResetAll);
    }
}

