/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.project.PgGeometryIf;
import jv.project.PvLightIf;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;

public final class PvDisplay_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvDisplay m_display;
    protected Panel m_pColor;
    protected Panel m_pSize;
    protected Checkbox m_cAnimation;
    protected Checkbox m_cAxes;
    protected Checkbox m_cShowImage;
    protected Checkbox m_cBndbox;
    protected Checkbox m_cClearScreen;
    protected Checkbox m_cDepthcue;
    protected Checkbox m_cDoubleBuffer;
    protected Checkbox m_cEdgeAura;
    protected Checkbox m_cEdgesOnce;
    protected Checkbox m_cFrame;
    protected Checkbox m_cGrid;
    protected Checkbox m_cMagnet;
    protected Checkbox m_cPainters;
    protected Checkbox m_cZBuffer;
    protected Checkbox m_cAntiAlias;
    protected Checkbox m_cIntegerPick;
    protected Checkbox m_cBoxRatio;
    protected Checkbox m_c3DLook;
    protected Checkbox m_cAdaptiveSize;
    protected Checkbox m_cFps;
    protected Label m_lFps;
    protected PsPanel m_pFps;
    protected CheckboxGroup m_gSelectionMode;
    protected Checkbox m_cSingle;
    protected Checkbox m_cMultiple;
    protected List m_listVisible;
    protected List m_listSelect;
    protected boolean m_bDeleteMode = false;
    private Color m_deleteColor;
    protected boolean m_bDuplicateMode = false;
    private Color m_duplicateColor;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected CheckboxGroup m_gImageMode;
    protected Checkbox m_cBack;
    protected Checkbox m_cFront;
    protected Choice m_cImageFit;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bMerge;
    protected Button m_bDuplicate;
    protected Button m_bDelete;
    protected Button m_bReset;
    protected Button m_bResetFull;
    private static /* synthetic */ Class class$jv$viewer$PvDisplay_IP;

    private void duplicateGeom(PgGeometryIf pgGeometryIf) {
        if (this.m_display.m_specialGeom.contains(pgGeometryIf)) {
            PsDebug.warning("not allowed to duplicate special geometry");
            return;
        }
        PgGeometryIf pgGeometryIf2 = (PgGeometryIf)pgGeometryIf.clone();
        pgGeometryIf2.setName(PsConfig.getMessage(15007) + PsObject.getNumObjects() + "-" + pgGeometryIf.getName());
        this.m_display.addGeometry(pgGeometryIf2);
        this.m_display.selectGeometry(pgGeometryIf2);
        this.m_display.update(this.m_display);
        this.m_bDuplicateMode = false;
        this.m_bDuplicate.setBackground(this.m_duplicateColor);
        this.m_bDuplicate.setLabel(PsConfig.getMessage(24287));
    }

    private void updateGuiOfImage(Checkbox checkbox, boolean bl) {
        String string = "";
        if (checkbox == this.m_cBack) {
            string = this.m_display.getBackgroundImageFile();
            PsPanel.select(this.m_cImageFit, this.m_display.getBackgroundImageFit());
        } else {
            string = this.m_display.getForegroundImageFile();
            PsPanel.select(this.m_cImageFit, this.m_display.getForegroundImageFit());
        }
        if (!bl) {
            string = "";
        }
        PsPanel.setText(this.m_tImage, string);
        PsPanel.setEnabled(this.m_tImage, bl);
        PsPanel.setEnabled(this.m_cImageFit, bl);
        if (this.m_bBrowse != null) {
            PsPanel.setEnabled(this.m_bBrowse, bl);
        }
        if (this.m_cShowImage.getState() != bl) {
            this.m_cShowImage.setState(bl);
        }
    }

    private void deleteGeom(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return;
        }
        if (this.m_display.m_specialGeom.get("xy-grid") == pgGeometryIf) {
            this.m_display.showGrid(false);
        } else if (this.m_display.m_specialGeom.get("axes frame") == pgGeometryIf) {
            this.m_display.showAxes(false);
        } else if (this.m_display.m_specialGeom.get("bndbox") == pgGeometryIf) {
            this.m_display.showBndBox(false);
        } else if (this.m_display.m_specialGeom.get("frame") == pgGeometryIf) {
            this.m_display.showFrame(false);
        } else {
            int n = this.m_display.getNumLights();
            boolean bl = false;
            if (n > 0) {
                PvLightIf[] pvLightIfArray = this.m_display.getLights();
                int n2 = 0;
                while (n2 < n) {
                    if (pvLightIfArray[n2] == pgGeometryIf) {
                        bl = true;
                        this.m_display.removeLight(pvLightIfArray[n2]);
                        break;
                    }
                    ++n2;
                }
                if (bl && n == 1) {
                    this.m_display.setLightingModel(0);
                    if (this.m_display.m_bSavedDepthcue) {
                        this.m_display.showDepthcue(this.m_display.m_bSavedDepthcue);
                    }
                }
            }
            if (!bl) {
                this.m_display.removeGeometry(pgGeometryIf);
            }
            this.m_display.update(this.m_display);
        }
        this.m_bDeleteMode = false;
        this.m_bDelete.setBackground(this.m_deleteColor);
        this.m_bDelete.setLabel(PsConfig.getMessage(24288));
    }

    public PvDisplay_IP() {
        if (this.getClass() == (class$jv$viewer$PvDisplay_IP != null ? class$jv$viewer$PvDisplay_IP : (class$jv$viewer$PvDisplay_IP = PvDisplay_IP.class$("jv.viewer.PvDisplay_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_display == null) {
            return;
        }
        Object object = itemEvent.getSource();
        long l = this.m_display.m_sceneDefaults;
        if (object == this.m_cAnimation) {
            this.m_display.setEnabledAnimation(this.m_cAnimation.getState());
        } else if (object == this.m_cAxes) {
            this.m_display.showAxes(this.m_cAxes.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cBndbox) {
            this.m_display.showBndBox(this.m_cBndbox.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cClearScreen) {
            this.m_display.setEnabledClearScreen(this.m_cClearScreen.getState());
            if (this.m_cClearScreen.getState()) {
                this.m_display.update(this.m_display.m_currentCamera);
            }
        } else if (object == this.m_cDepthcue) {
            this.m_display.showDepthcue(this.m_cDepthcue.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cDoubleBuffer) {
            this.m_display.setEnabledDoubleBuffer(this.m_cDoubleBuffer.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cEdgeAura) {
            this.m_display.showEdgeAura(this.m_cEdgeAura.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cEdgesOnce) {
            this.m_display.showEdgesOnce(this.m_cEdgesOnce.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cFrame) {
            this.m_display.showFrame(this.m_cFrame.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cGrid) {
            this.m_display.showGrid(this.m_cGrid.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cPainters) {
            this.m_display.setEnabledPainters(this.m_cPainters.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cZBuffer) {
            this.m_display.setEnabledZBuffer(this.m_cZBuffer.getState());
            this.m_cEdgeAura.setEnabled(!this.m_display.isEnabledZBuffer());
            this.m_display.update(this.m_display);
        } else if (object == this.m_cAntiAlias) {
            this.m_display.setEnabledAntiAlias(this.m_cAntiAlias.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cFps) {
            this.m_display.m_bFpsEnabled = this.m_cFps.getState();
            this.m_display.m_sleep.setEnabled(this.m_cFps.getState());
            PsPanel.setText(this.m_lFps, PsConfig.getMessage(24261));
            if (this.m_display.m_bFpsEnabled) {
                this.m_display.start();
            } else {
                this.m_display.stop();
            }
        } else if (object == this.m_cSingle) {
            if (this.m_display.hasPaintTag(2048L)) {
                return;
            }
            this.m_display.setPaintTag(2048L, true);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
            }
            this.m_display.update(this.m_display);
        } else if (object == this.m_cMultiple) {
            if (!this.m_display.hasPaintTag(2048L)) {
                return;
            }
            this.m_display.setPaintTag(2048L, false);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
            }
        } else if (object == this.m_cBack) {
            boolean bl = this.m_display.isShowingBackgroundImage();
            this.m_cShowImage.setState(bl);
            this.updateImageInDisplay(this.m_cBack, bl);
            this.updateGuiOfImage(this.m_cBack, bl);
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cFront) {
            boolean bl = this.m_display.isShowingForegroundImage();
            this.m_cShowImage.setState(bl);
            this.updateImageInDisplay(this.m_cFront, bl);
            this.updateGuiOfImage(this.m_cFront, bl);
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cImageFit) {
            if (this.m_gImageMode.getSelectedCheckbox() == this.m_cBack) {
                this.m_display.setBackgroundImageFit(this.m_cImageFit.getSelectedIndex());
            } else {
                this.m_display.setForegroundImageFit(this.m_cImageFit.getSelectedIndex());
            }
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cShowImage) {
            this.updateImageInDisplay(this.m_gImageMode.getSelectedCheckbox(), this.m_cShowImage.getState());
            this.updateGuiOfImage(this.m_gImageMode.getSelectedCheckbox(), this.m_cShowImage.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_listVisible) {
            int n = (Integer)itemEvent.getItem();
            if (n < 0 || this.m_listVisible.getItemCount() <= n) {
                return;
            }
            PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
            if (this.m_bDeleteMode) {
                this.deleteGeom(pvGeometryArray[n].getGeometry());
            } else if (this.m_bDuplicateMode) {
                this.duplicateGeom(pvGeometryArray[n].getGeometry());
            } else {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        if (this.m_display.hasPaintTag(2048L)) {
                            this.m_display.selectGeometry(pvGeometryArray[n].getGeometry());
                            break;
                        }
                        pvGeometryArray[n].getGeometry().setVisible(true);
                        pvGeometryArray[n].setVisible(true);
                        break;
                    }
                    case 2: {
                        pvGeometryArray[n].getGeometry().setVisible(false);
                        pvGeometryArray[n].setVisible(false);
                    }
                }
            }
            if (this.m_display.isShowingAxes()) {
                this.m_display.recomputeAxes();
            }
            if (this.m_display.isShowingBndBox()) {
                this.m_display.recomputeBndBox();
            }
            this.m_display.update(this.m_display);
        } else if (object == this.m_listSelect) {
            int n = (Integer)itemEvent.getItem();
            if (n < 0 || this.m_listSelect.getItemCount() <= n) {
                return;
            }
            PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
            if (this.m_bDeleteMode) {
                this.deleteGeom(pvGeometryArray[n].getGeometry());
            } else if (this.m_bDuplicateMode) {
                this.duplicateGeom(pvGeometryArray[n].getGeometry());
            } else {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        this.m_display.selectGeometry(pvGeometryArray[n].getGeometry());
                    }
                }
            }
            if (this.m_display.isShowingAxes()) {
                this.m_display.recomputeAxes();
            }
            if (this.m_display.isShowingBndBox()) {
                this.m_display.recomputeBndBox();
            }
            this.m_display.update(this.m_display);
        } else if (object == this.m_cIntegerPick) {
            this.m_display.setPaintTag(0x40000000L, this.m_cIntegerPick.getState());
        } else if (object == this.m_cBoxRatio) {
            this.m_display.setEnabledBoxRatio(this.m_cBoxRatio.getState());
            this.m_display.update(this.m_display);
        } else if (object == this.m_c3DLook) {
            this.m_display.setEnabled3DLook(this.m_c3DLook.getState());
            this.m_display.update(this.m_display);
        } else if (object == this.m_cMagnet) {
            this.m_display.showMagnet(this.m_cMagnet.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (object == this.m_cAdaptiveSize) {
            this.m_display.setEnabledAdaptiveSize(this.m_cAdaptiveSize.getState());
            this.m_display.update(this.m_display);
        }
        this.m_display.m_sceneDefaults = l;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_display = (PvDisplay)psUpdateIf;
        this.setTitle(this.m_display.getName());
        this.m_pColor.add(this.m_display.m_backgroundColor.getInfoPanel());
        this.m_pColor.add(this.m_display.m_foregroundColor.getInfoPanel());
        this.m_pSize.add(this.m_display.m_width.getInfoPanel());
        this.m_pSize.add(this.m_display.m_height.getInfoPanel());
        if (this.m_pFps != null) {
            this.m_pFps.add(this.m_display.m_sleep.getInfoPanel());
        }
        this.validate();
    }

    public boolean update(Object object) {
        if (this.m_display == null) {
            PsDebug.warning("missing display");
            return false;
        }
        if (object == this.m_display) {
            String string;
            int n;
            this.setTitle(this.m_display.getName());
            if (this.m_gImageMode.getSelectedCheckbox() == this.m_cBack) {
                this.updateGuiOfImage(this.m_cBack, this.m_display.isShowingBackgroundImage());
                PsPanel.select(this.m_cImageFit, this.m_display.getBackgroundImageFit());
            } else {
                this.updateGuiOfImage(this.m_cFront, this.m_display.isShowingForegroundImage());
                PsPanel.select(this.m_cImageFit, this.m_display.getForegroundImageFit());
            }
            PsPanel.setState(this.m_cAnimation, this.m_display.isEnabledAnimation());
            PsPanel.setState(this.m_cAxes, this.m_display.isShowingAxes());
            PsPanel.setState(this.m_cBndbox, this.m_display.isShowingBndBox());
            PsPanel.setState(this.m_cClearScreen, this.m_display.isEnabledClearScreen());
            PsPanel.setState(this.m_cDepthcue, this.m_display.isShowingDepthcue());
            PsPanel.setState(this.m_cDoubleBuffer, this.m_display.isEnabledDoubleBuffer());
            PsPanel.setState(this.m_cEdgeAura, this.m_display.isShowingEdgeAura());
            PsPanel.setEnabled(this.m_cEdgeAura, !this.m_display.isEnabledZBuffer());
            if (this.m_display.isEnabledAntiAlias() == this.m_display.m_bSaveEnableAntiAlias) {
                PsPanel.setState(this.m_cAntiAlias, this.m_display.isEnabledAntiAlias());
            }
            PsPanel.setState(this.m_cEdgesOnce, this.m_display.isShowingEdgesOnce());
            PsPanel.setState(this.m_cFrame, this.m_display.isShowingFrame());
            PsPanel.setState(this.m_cGrid, this.m_display.isShowingGrid());
            PsPanel.setState(this.m_cMagnet, this.m_display.isShowingMagnet());
            PsPanel.setState(this.m_cPainters, this.m_display.isEnabledPainters());
            PsPanel.setEnabled(this.m_cPainters, !this.m_display.isEnabledFastZBuffer() || !this.m_display.isEnabledZBuffer());
            PsPanel.setState(this.m_cZBuffer, this.m_display.isEnabledZBuffer());
            PsPanel.setEnabled(this.m_cZBuffer, !this.m_display.m_bRequiresZBuffer);
            if (this.m_pFps != null) {
                PsPanel.setState(this.m_cFps, this.m_display.m_bFpsEnabled);
            }
            PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
            PgGeometryIf pgGeometryIf = this.m_display.getSelectedGeometry();
            if (this.m_display.hasPaintTag(2048L)) {
                PsPanel.setSelectedCheckbox(this.m_gSelectionMode, this.m_cSingle);
            } else {
                PsPanel.setSelectedCheckbox(this.m_gSelectionMode, this.m_cMultiple);
            }
            PsPanel.setState(this.m_cIntegerPick, this.m_display.hasPaintTag(0x40000000L));
            PsPanel.setState(this.m_cBoxRatio, this.m_display.isEnabledBoxRatio());
            if (this.m_cBoxRatio.isEnabled() != (this.m_display.getBoxRatio() != null)) {
                this.m_cBoxRatio.setEnabled(!this.m_cBoxRatio.isEnabled());
            }
            PsPanel.setState(this.m_c3DLook, this.m_display.isEnabled3DLook());
            PsPanel.setState(this.m_cAdaptiveSize, this.m_display.isEnabledAdaptiveSize());
            boolean bl = true;
            int n2 = 0;
            int n3 = this.m_listVisible.getItemCount();
            if (pvGeometryArray != null) {
                n2 = pvGeometryArray.length;
            }
            if (n3 != n2) {
                bl = false;
            } else {
                n = 0;
                while (n < n2) {
                    string = this.m_listVisible.getItem(n);
                    if (string == null || !string.equals(pvGeometryArray[n].getGeometry().getName())) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                if (n3 > 0) {
                    this.m_listVisible.removeAll();
                    this.m_listSelect.removeAll();
                }
                n = 0;
                while (n < n2) {
                    string = pvGeometryArray[n].getGeometry().getName();
                    this.m_listVisible.add(string);
                    this.m_listSelect.add(string);
                    ++n;
                }
            }
            n = 0;
            while (n < n2) {
                if (pvGeometryArray[n].isVisible() != this.m_listVisible.isIndexSelected(n)) {
                    if (pvGeometryArray[n].isVisible()) {
                        this.m_listVisible.select(n);
                    } else {
                        this.m_listVisible.deselect(n);
                    }
                }
                if (pvGeometryArray[n].getGeometry() == pgGeometryIf && !this.m_listSelect.isIndexSelected(n)) {
                    this.m_listSelect.select(n);
                }
                ++n;
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_display == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            Image image = null;
            image = this.m_display.loadImage(this, this.m_fileName);
            if (image == null) {
                return;
            }
            if (this.m_gImageMode.getSelectedCheckbox() == this.m_cBack) {
                this.m_display.setBackgroundImage(image);
                this.m_display.setBackgroundImageFile(this.m_fileName);
            } else {
                this.m_display.setForegroundImage(image);
                this.m_display.setForegroundImageFile(this.m_fileName);
            }
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bBrowse) {
            Object object2;
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                object2 = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24105), 0);
                if (this.m_dirName == null) {
                    this.m_dirName = PsConfig.getCodeBase() + "images";
                }
                ((FileDialog)object2).setDirectory(this.m_dirName);
                ((Dialog)object2).show();
                String string = ((FileDialog)object2).getFile();
                if (string == null) {
                    return;
                }
                this.m_dirName = ((FileDialog)object2).getDirectory();
                this.m_fileName = this.m_dirName + string;
                this.m_fileName.trim();
            }
            object2 = null;
            object2 = this.m_display.loadImage(this, this.m_fileName);
            if (object2 == null) {
                return;
            }
            if (this.m_gImageMode.getSelectedCheckbox() == this.m_cBack) {
                this.m_display.setBackgroundImage((Image)object2);
                this.m_display.setBackgroundImageFile(this.m_fileName);
            } else {
                this.m_display.setForegroundImage((Image)object2);
                this.m_display.setForegroundImageFile(this.m_fileName);
            }
            PsPanel.setText(this.m_tImage, this.m_fileName);
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bCenter) {
            this.m_display.center();
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bFit) {
            this.m_display.fit();
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bMerge) {
            PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
            PgGeometryIf pgGeometryIf = null;
            int n = 0;
            while (n < pgGeometryIfArray.length) {
                if (pgGeometryIfArray[n].isVisible()) {
                    pgGeometryIf = pgGeometryIfArray[n];
                    break;
                }
                ++n;
            }
            if (pgGeometryIf == null) {
                PsDebug.warning("missing visible geometry.");
                return;
            }
            n = 0;
            while (n < pgGeometryIfArray.length) {
                if (pgGeometryIfArray[n].isVisible() && pgGeometryIfArray[n] != pgGeometryIf) {
                    pgGeometryIf.merge(pgGeometryIfArray[n]);
                    this.m_display.removeGeometry(pgGeometryIfArray[n]);
                }
                ++n;
            }
            pgGeometryIf.update(pgGeometryIf);
            this.m_display.selectGeometry(pgGeometryIf);
            this.m_display.update(this.m_display);
            return;
        }
        if (object == this.m_bDuplicate) {
            if (this.m_bDuplicateMode) {
                this.m_bDuplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage(24287));
                return;
            }
            this.m_bDuplicateMode = true;
            this.m_duplicateColor = this.m_bDuplicate.getBackground();
            this.m_bDuplicate.setBackground(Color.red);
            this.m_bDuplicate.setLabel(PsConfig.getMessage(24289));
            return;
        }
        if (object == this.m_bDelete) {
            if (this.m_bDeleteMode) {
                this.m_bDeleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel(PsConfig.getMessage(24288));
                return;
            }
            this.m_bDeleteMode = true;
            this.m_deleteColor = this.m_bDelete.getBackground();
            this.m_bDelete.setBackground(Color.red);
            this.m_bDelete.setLabel(PsConfig.getMessage(24289));
            return;
        }
        if (object == this.m_bReset) {
            this.m_display.reset();
            this.m_display.update(this.m_display);
            return;
        }
        if (object == this.m_bResetFull) {
            this.m_display.init();
            this.m_display.update(this.m_display);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void updateImageInDisplay(Checkbox checkbox, boolean bl) {
        Image image;
        String string = "";
        if (checkbox == this.m_cBack) {
            this.m_display.showBackgroundImage(bl);
            string = this.m_display.getBackgroundImageFile();
        } else {
            this.m_display.showForegroundImage(bl);
            string = this.m_display.getForegroundImageFile();
        }
        if (bl && (image = this.m_display.loadImage(this, string)) != null) {
            if (checkbox == this.m_cBack) {
                this.m_display.setBackgroundImage(image);
                this.m_display.showBackgroundImage(bl);
                return;
            }
            this.m_display.setForegroundImage(image);
            this.m_display.showForegroundImage(bl);
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        this.addTitle("");
        this.m_pColor = new Panel(new GridLayout(2, 1));
        this.add(this.m_pColor);
        this.m_pSize = new Panel(new GridLayout(2, 1));
        this.add(this.m_pSize);
        this.addLine(1);
        PsPanel psPanel = new PsPanel(new GridLayout(3, 2));
        psPanel.setInsetSizeHorizontal(4);
        psPanel.addSubTitle(PsConfig.getMessage(24266));
        Panel panel = new Panel(new GridLayout(1, 2));
        this.m_gImageMode = new CheckboxGroup();
        this.m_cBack = new Checkbox(PsConfig.getMessage(24267), this.m_gImageMode, true);
        this.m_cBack.addItemListener(this);
        panel.add(this.m_cBack);
        this.m_cFront = new Checkbox(PsConfig.getMessage(24268), this.m_gImageMode, false);
        this.m_cFront.addItemListener(this);
        panel.add(this.m_cFront);
        psPanel.add(panel);
        this.m_cShowImage = new Checkbox(PsConfig.getMessage(24037));
        this.m_cShowImage.addItemListener(this);
        psPanel.add(this.m_cShowImage);
        this.m_cImageFit = new Choice();
        this.m_cImageFit.addItemListener(this);
        this.m_cImageFit.addItem(PsConfig.getMessage(24090));
        this.m_cImageFit.addItem(PsConfig.getMessage(24236));
        this.m_cImageFit.addItem(PsConfig.getMessage(24092));
        this.m_cImageFit.addItem(PsConfig.getMessage(24091));
        this.m_cImageFit.setEnabled(false);
        psPanel.add(this.m_cImageFit);
        Panel panel2 = new Panel(new PsSlotLayout(3));
        panel2.add("2", new Label(PsConfig.getMessage(24093)));
        this.m_bBrowse = new Button(PsConfig.getMessage(24094));
        this.m_bBrowse.addActionListener(this);
        panel2.add("1", this.m_bBrowse);
        this.m_bBrowse.setEnabled(false);
        psPanel.add(panel2);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        this.m_tImage.setEnabled(false);
        psPanel.add(this.m_tImage);
        this.add(psPanel);
        this.addLine(1);
        this.addSubTitle(PsConfig.getMessage(24269));
        panel = new PsPanel(new GridLayout(8, 2));
        ((PsPanel)panel).setInsetSizeHorizontal(4);
        this.add(panel);
        this.m_cAnimation = new Checkbox(PsConfig.getMessage(24270));
        this.m_cAnimation.addItemListener(this);
        panel.add(this.m_cAnimation);
        this.m_cAxes = new Checkbox(PsConfig.getMessage(24271));
        this.m_cAxes.addItemListener(this);
        this.m_cEdgesOnce = new Checkbox(PsConfig.getMessage(24276));
        this.m_cEdgesOnce.addItemListener(this);
        panel.add(this.m_cEdgesOnce);
        this.m_cBndbox = new Checkbox(PsConfig.getMessage(24272));
        this.m_cBndbox.addItemListener(this);
        panel.add(this.m_cBndbox);
        this.m_cDepthcue = new Checkbox(PsConfig.getMessage(24273));
        this.m_cDepthcue.addItemListener(this);
        panel.add(this.m_cDepthcue);
        this.m_cFrame = new Checkbox(PsConfig.getMessage(24274));
        this.m_cFrame.addItemListener(this);
        panel.add(this.m_cFrame);
        this.m_cGrid = new Checkbox(PsConfig.getMessage(24196));
        this.m_cGrid.addItemListener(this);
        panel.add(this.m_cGrid);
        this.m_cPainters = new Checkbox(PsConfig.getMessage(24275));
        this.m_cPainters.addItemListener(this);
        panel.add(this.m_cPainters);
        this.m_cEdgeAura = new Checkbox(PsConfig.getMessage(24277));
        this.m_cEdgeAura.addItemListener(this);
        panel.add(this.m_cEdgeAura);
        this.m_cClearScreen = new Checkbox(PsConfig.getMessage(24278));
        this.m_cClearScreen.addItemListener(this);
        panel.add(this.m_cClearScreen);
        this.m_cZBuffer = new Checkbox(PsConfig.getMessage(24279));
        this.m_cZBuffer.addItemListener(this);
        panel.add(this.m_cZBuffer);
        this.m_cAntiAlias = new Checkbox(PsConfig.getMessage(24280));
        this.m_cAntiAlias.addItemListener(this);
        panel.add(this.m_cAntiAlias);
        this.m_cDoubleBuffer = new Checkbox(PsConfig.getMessage(24281));
        this.m_cDoubleBuffer.addItemListener(this);
        panel.add(this.m_cDoubleBuffer);
        this.m_cIntegerPick = new Checkbox(PsConfig.getMessage(24346));
        this.m_cIntegerPick.addItemListener(this);
        panel.add(this.m_cIntegerPick);
        this.m_c3DLook = new Checkbox(PsConfig.getMessage(24419));
        this.m_c3DLook.addItemListener(this);
        panel.add(this.m_c3DLook);
        this.m_cMagnet = new Checkbox(PsConfig.getMessage(24366));
        this.m_cMagnet.addItemListener(this);
        panel.add(this.m_cMagnet);
        this.m_cAdaptiveSize = new Checkbox(PsConfig.getMessage(24420));
        this.m_cAdaptiveSize.addItemListener(this);
        panel.add(this.m_cAdaptiveSize);
        this.m_cBoxRatio = new Checkbox(PsConfig.getMessage(24347));
        this.m_cBoxRatio.addItemListener(this);
        this.addLine(1);
        this.m_pFps = new PsPanel(new GridLayout(2, 1));
        panel2 = new Panel(new GridLayout(1, 2));
        this.m_cFps = new Checkbox(PsConfig.getMessage(24282));
        this.m_cFps.addItemListener(this);
        this.m_cFps.setFont(PsConfig.getFont(3));
        this.m_cFps.setState(false);
        panel2.add(this.m_cFps);
        this.m_lFps = new Label(PsConfig.getMessage(24261));
        panel2.add(this.m_lFps);
        this.m_pFps.add(panel2);
        panel2 = new PsPanel();
        this.add(panel2);
        PsPanel psPanel2 = new PsPanel(new GridLayout(1, 2));
        psPanel2.addSubTitle(PsConfig.getMessage(24283));
        Panel panel3 = new Panel(new GridLayout(1, 2));
        this.m_gSelectionMode = new CheckboxGroup();
        this.m_cSingle = new Checkbox(PsConfig.getMessage(24066), this.m_gSelectionMode, false);
        this.m_cSingle.addItemListener(this);
        panel3.add(this.m_cSingle);
        this.m_cMultiple = new Checkbox(PsConfig.getMessage(24067), this.m_gSelectionMode, true);
        this.m_cMultiple.addItemListener(this);
        panel3.add(this.m_cMultiple);
        psPanel2.add(panel3);
        panel2.add(psPanel2);
        panel3 = new PsPanel(new GridLayout(1, 2));
        Panel panel4 = new Panel(new BorderLayout());
        Label label = new Label(PsConfig.getMessage(24284));
        panel4.add((Component)label, "North");
        this.m_listSelect = new List(5, false);
        this.m_listSelect.addItemListener(this);
        panel4.add((Component)this.m_listSelect, "Center");
        panel3.add(panel4);
        Panel panel5 = new Panel(new BorderLayout());
        Label label2 = new Label(PsConfig.getMessage(24285));
        panel5.add((Component)label2, "North");
        this.m_listVisible = new List(5, true);
        this.m_listVisible.addItemListener(this);
        panel5.add((Component)this.m_listVisible, "Center");
        panel3.add(panel5);
        panel2.add(panel3);
        psPanel2 = new PsPanel(new GridLayout(2, 1));
        this.add(psPanel2);
        panel3 = new PsPanel(new FlowLayout());
        psPanel2.add(panel3);
        this.m_bMerge = new Button(PsConfig.getMessage(24286));
        this.m_bMerge.addActionListener(this);
        panel3.add(this.m_bMerge);
        this.m_bDuplicate = new Button(PsConfig.getMessage(24287));
        this.m_bDuplicate.addActionListener(this);
        panel3.add(this.m_bDuplicate);
        this.m_bDelete = new Button(PsConfig.getMessage(24288));
        this.m_bDelete.addActionListener(this);
        panel3.add(this.m_bDelete);
        panel4 = new PsPanel(new FlowLayout());
        psPanel2.add(panel4);
        this.m_bCenter = new Button(PsConfig.getMessage(24090));
        this.m_bCenter.addActionListener(this);
        panel4.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage(24236));
        this.m_bFit.addActionListener(this);
        panel4.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage(24104));
        this.m_bReset.addActionListener(this);
        panel4.add(this.m_bReset);
        this.m_bResetFull = new Button(PsConfig.getMessage(24421));
        this.m_bResetFull.addActionListener(this);
        panel4.add(this.m_bResetFull);
    }
}

