/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PiVector
extends P_Vector
implements Cloneable {
    public int[] m_data;

    public static int[][] getEntries(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            return null;
        }
        int n = piVectorArray.length;
        int[][] nArrayArray = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            nArrayArray[n2] = piVectorArray[n2].getEntries();
            ++n2;
        }
        return nArrayArray;
    }

    public int[] getEntries() {
        return (int[])this.m_data.clone();
    }

    public int getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, int n2) {
        if (this.m_data == null || this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = n2;
    }

    public int getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = n;
    }

    public int indexOfMax() {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            if (this.m_data[n3] > n2) {
                n2 = this.m_data[n3];
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public int dist(PiVector piVector) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = this.m_data[n2] - piVector.m_data[n2];
            n += n3 * n3;
            ++n2;
        }
        return (int)Math.sqrt(n);
    }

    public static PiVector[] copyNew(int[][] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n = nArray.length;
        PiVector[] piVectorArray = new PiVector[n];
        int n2 = 0;
        while (n2 < n) {
            piVectorArray[n2] = new PiVector(nArray[n2]);
            ++n2;
        }
        return piVectorArray;
    }

    public static PiVector[] copyNew(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PiVector.copyNew(piVectorArray, piVectorArray.length);
    }

    public static PiVector[] copyNew(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        int n2 = 0;
        while (n2 < n) {
            piVectorArray2[n2] = PiVector.copyNew(piVectorArray[n2]);
            ++n2;
        }
        return piVectorArray2;
    }

    public static PiVector copyNew(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("v.m_data==null", piVector);
            return null;
        }
        PiVector piVector2 = new PiVector(piVector.m_data.length);
        piVector2.copy(piVector);
        return piVector2;
    }

    public boolean equals(Object object) {
        if (object instanceof PiVector) {
            return this.equals((PiVector)object);
        }
        if (object instanceof int[]) {
            return this.equals((int[])object);
        }
        return super.equals(object);
    }

    public boolean equals(int[] nArray) {
        int n = this.getSize();
        if (nArray == null && n == 0) {
            return true;
        }
        if (nArray == null) {
            return false;
        }
        if (n != nArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != nArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.equals(piVector.m_data);
    }

    public static int getSameSize(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0) {
            return -1;
        }
        if (piVectorArray[0] == null) {
            return -1;
        }
        if (piVectorArray.length < n) {
            PsDebug.warning("used vectors larger than array size.");
            n = piVectorArray.length;
        }
        int n2 = piVectorArray[0].getSize();
        int n3 = 1;
        while (n3 < n) {
            if (n2 != piVectorArray[n3].getSize()) {
                n2 = -1;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null) {
            this.m_data = new int[n];
        } else if (this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public void blendBase(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            this.m_data[n2] = piVector.m_data[n2] + n * piVector2.m_data[n2];
            ++n2;
        }
    }

    public Object clone() {
        return PiVector.copyNew(this);
    }

    public int sqrLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            n += this.m_data[n2] * this.m_data[n2];
            ++n2;
        }
        return n;
    }

    public int length() {
        return (int)this.getLength();
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            d += (double)(this.m_data[n] * this.m_data[n]);
            ++n;
        }
        return Math.sqrt(d);
    }

    public void setLength(int n) {
        int n2 = this.length();
        if (n2 == 0) {
            return;
        }
        n2 /= n;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = n3++;
            this.m_data[n4] = this.m_data[n4] / n2;
        }
    }

    public int changeValue(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (this.m_data[n5] == n2) {
                this.m_data[n5] = n3;
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public int changeValue(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.m_data.length) {
            if (this.m_data[n4] == n) {
                this.m_data[n4] = n2;
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("\t ******* PiVector ***********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + this.m_data[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(", " + this.m_data[n2]);
                ++n2;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t m_data = null");
        }
        return stringBuffer.toString();
    }

    public static final boolean max(PiVector piVector, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < n || piVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (piVector == null || piVector.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        piVector.setConstant(Integer.MIN_VALUE);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(piVector.m_data.length, piVectorArray[n2].m_data.length) - 1;
            while (n3 >= 0) {
                if (piVector.m_data[n3] < piVectorArray[n2].m_data[n3]) {
                    piVector.m_data[n3] = piVectorArray[n2].m_data[n3];
                }
                --n3;
            }
            ++n2;
        }
        return true;
    }

    public int max() {
        int n = -2147483647;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] > n) {
                n = this.m_data[n2];
            }
            ++n2;
        }
        return n;
    }

    public boolean hasUniqueEntries() {
        if (this == null || this.m_data == null) {
            return true;
        }
        int n = this.getSize();
        if (n <= 1) {
            return true;
        }
        PiVector piVector = (PiVector)this.clone();
        piVector.sort();
        int n2 = 1;
        while (n2 < n) {
            if (piVector.m_data[n2 - 1] == piVector.m_data[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int sqrDist(PiVector piVector) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = this.m_data[n2] - piVector.m_data[n2];
            n += n3 * n3;
            ++n2;
        }
        return n;
    }

    public int indexOfAbsMin() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = Math.abs(this.m_data[n3]);
            if (n4 < n2) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public void sub(PiVector piVector) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] - piVector.m_data[n];
            ++n;
        }
    }

    public void sub(PiVector piVector, PiVector piVector2) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = piVector.m_data[n] - piVector2.m_data[n];
            ++n;
        }
    }

    public int getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[0];
    }

    public static boolean copy(PiVector[] piVectorArray, int n, PiVector[] piVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (piVectorArray == null || piVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", piVectorArray);
            return false;
        }
        if (piVectorArray2 == null || piVectorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", piVectorArray2);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            piVectorArray[n + n4].copy(piVectorArray2[n2 + n4]);
            ++n4;
        }
        return true;
    }

    public void setFirstEntry(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = n;
    }

    public boolean copy(int n, PiVector piVector, int n2, int n3) {
        if (this.m_data.length < n + n3) {
            PsDebug.warning("missing space in this", this);
            return false;
        }
        if (this.m_data == null || this.m_data.length < n + n3) {
            this.setSize(n + n3);
        }
        System.arraycopy(piVector.m_data, n2, this.m_data, n, n3);
        return true;
    }

    public void copy(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(piVector);
        super.copy(piVector);
    }

    public void copy(int[] nArray, int n) {
        if (nArray == null) {
            PsDebug.warning("null vector 'm' passed\n");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        int n2 = Math.min(this.m_data.length, n);
        System.arraycopy(nArray, 0, this.m_data, 0, n2);
        int n3 = n2;
        while (n3 < this.m_data.length) {
            this.m_data[n3] = 0;
            ++n3;
        }
    }

    public static void setConstant(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray[0] == null) {
            return;
        }
        int n2 = 0;
        while (n2 < piVectorArray.length) {
            piVectorArray[n2].setConstant(n);
            ++n2;
        }
    }

    public static void setConstant(PiVector[] piVectorArray, int[] nArray) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray[0] == null) {
            return;
        }
        if (piVectorArray[0].m_data.length != nArray.length) {
            return;
        }
        int n = Math.min(piVectorArray[0].m_data.length, nArray.length);
        int n2 = 0;
        while (n2 < piVectorArray.length) {
            int n3 = 0;
            while (n3 < n) {
                piVectorArray[n2].m_data[n3] = nArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public static void setConstant(PiVector[] piVectorArray, PiVector piVector) {
        if (piVector == null) {
            return;
        }
        PiVector.setConstant(piVectorArray, piVector.m_data);
    }

    public static void setConstant(PiVector piVector, int n) {
        if (piVector == null || piVector.m_data == null) {
            return;
        }
        int n2 = piVector.getSize() - 1;
        while (n2 >= 0) {
            piVector.m_data[n2] = n;
            --n2;
        }
    }

    public void setConstant(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            return;
        }
        int n2 = this.m_data.length - 1;
        while (n2 >= 0) {
            this.m_data[n2] = n;
            --n2;
        }
    }

    public int addEntry(int n) {
        int n2 = this.getSize() + 1;
        this.setSize(n2);
        this.m_data[n2 - 1] = n;
        return n2;
    }

    public int indexOfMin() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            if (this.m_data[n3] < n2) {
                n2 = this.m_data[n3];
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public static final PiVector[] realloc(PiVector[] piVectorArray, int n, int n2) {
        int n3;
        if (piVectorArray != null && piVectorArray.length == n) {
            int n4 = 0;
            while (n4 < piVectorArray.length) {
                if (piVectorArray[n4] == null) {
                    piVectorArray[n4] = new PiVector(n2);
                } else if (piVectorArray[n4].m_data == null || piVectorArray[n4].m_data.length != n2) {
                    piVectorArray[n4].setSize(n2);
                }
                ++n4;
            }
            return piVectorArray;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        if (piVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(piVectorArray.length, n);
            System.arraycopy(piVectorArray, 0, piVectorArray2, 0, n3);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (piVectorArray2[n5] == null) {
                piVectorArray2[n5] = new PiVector(n2);
            } else if (piVectorArray2[n5].m_data == null || piVectorArray2[n5].m_data.length != n2) {
                piVectorArray2[n5].setSize(n2);
            }
            ++n5;
        }
        n5 = n3;
        while (n5 < n) {
            piVectorArray2[n5] = new PiVector(n2);
            ++n5;
        }
        return piVectorArray2;
    }

    public static final PiVector[] realloc(PiVector[] piVectorArray, int n) {
        int n2;
        int n3;
        if (piVectorArray != null && piVectorArray.length == n) {
            int n4 = 0;
            while (n4 < piVectorArray.length) {
                if (piVectorArray[n4] == null) {
                    piVectorArray[n4] = new PiVector();
                }
                ++n4;
            }
            return piVectorArray;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        if (piVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(piVectorArray.length, n);
            System.arraycopy(piVectorArray, 0, piVectorArray2, 0, n3);
            n2 = 0;
            while (n2 < n3) {
                if (piVectorArray2[n2] == null) {
                    piVectorArray2[n2] = new PiVector();
                }
                ++n2;
            }
        }
        n2 = n3;
        while (n2 < n) {
            piVectorArray2[n2] = new PiVector();
            ++n2;
        }
        return piVectorArray2;
    }

    public static int dot(PiVector piVector, PiVector piVector2) {
        int n = 0;
        int n2 = 0;
        while (n2 < piVector.m_data.length) {
            n += piVector.m_data[n2] * piVector2.m_data[n2];
            ++n2;
        }
        return n;
    }

    public int dot(PiVector piVector) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            n += this.m_data[n2] * piVector.m_data[n2];
            ++n2;
        }
        return n;
    }

    public boolean normalize() {
        int n = this.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] / n;
        }
        return true;
    }

    public void normalize(PiVector piVector) {
        int n = piVector.length();
        if (n == 0) {
            this.copyArray(piVector);
            return;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            this.m_data[n2] = piVector.m_data[n2] / n;
            ++n2;
        }
    }

    public void add(int n) {
        if (this.m_data == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] + n;
        }
    }

    public void add(PiVector piVector) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] + piVector.m_data[n];
            ++n;
        }
    }

    public void add(PiVector piVector, PiVector piVector2) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = piVector.m_data[n] + piVector2.m_data[n];
            ++n;
        }
    }

    public String toShortString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.getSize();
        if (this.m_data == null || n2 == 0) {
            stringBuffer.append("{ m_data = null} \t");
        } else {
            stringBuffer.append("{ " + PuString.intToString(this.m_data[0], 6));
            n = 1;
            while (n < n2) {
                stringBuffer.append(", " + PuString.intToString(this.m_data[n], 6));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("Attr = ");
        if (this.m_bits == null) {
            stringBuffer.append("{ } \t");
        } else {
            n = (int)this.m_bits[0];
            if (n < 1000) {
                stringBuffer.append("{ " + PuString.intToString(n, 4));
            } else {
                stringBuffer.append("{ " + n);
            }
            int n3 = 1;
            while (n3 < this.m_bits.length) {
                n = (int)this.m_bits[n3];
                if (n < 1000) {
                    stringBuffer.append("\t " + PuString.intToString(n, 4));
                } else {
                    stringBuffer.append("\t " + n);
                }
                ++n3;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static boolean adjustSizes(PiVector[] piVectorArray, int n, PiVector[] piVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (piVectorArray == null || piVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", piVectorArray2);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            piVectorArray[n + n4].setSize(piVectorArray2[n2 + n4].getSize());
            ++n4;
        }
        return true;
    }

    public void copyArray(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int n = piVector.m_data.length;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        if (this.m_data.length > n) {
            int n2 = n;
            while (n2 < this.m_data.length) {
                this.m_data[n2] = 0;
                ++n2;
            }
        } else {
            n = this.m_data.length;
        }
        switch (n) {
            case 4: {
                this.m_data[3] = piVector.m_data[3];
            }
            case 3: {
                this.m_data[2] = piVector.m_data[2];
            }
            case 2: {
                this.m_data[1] = piVector.m_data[1];
            }
            case 1: {
                this.m_data[0] = piVector.m_data[0];
                return;
            }
        }
        System.arraycopy(piVector.m_data, 0, this.m_data, 0, n);
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int[] nArray = new int[this.m_data.length];
        int n = 0;
        while (n < this.m_data.length) {
            nArray[n] = 0;
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = n;
                nArray[n3] = (int)((double)nArray[n3] + pdMatrix.m_data[n][n2] * (double)this.m_data[n2]);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = nArray[n];
            ++n;
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PiVector piVector) {
        if (this == piVector) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = 0;
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = n;
                this.m_data[n3] = (int)((double)this.m_data[n3] + pdMatrix.m_data[n][n2] * (double)piVector.m_data[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void invert(int n) {
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.m_data[n3];
            this.m_data[n3] = this.m_data[n - 1 - n3];
            this.m_data[n - 1 - n3] = n4;
            ++n3;
        }
    }

    public void invert() {
        int n = this.m_data.length / 2;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_data[n2];
            this.m_data[n2] = this.m_data[this.m_data.length - 1 - n2];
            this.m_data[this.m_data.length - 1 - n2] = n3;
            ++n2;
        }
    }

    public static final boolean min(PiVector piVector, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < n || piVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (piVector == null || piVector.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        piVector.setConstant(Integer.MAX_VALUE);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(piVector.m_data.length, piVectorArray[n2].m_data.length) - 1;
            while (n3 >= 0) {
                if (piVector.m_data[n3] > piVectorArray[n2].m_data[n3]) {
                    piVector.m_data[n3] = piVectorArray[n2].m_data[n3];
                }
                --n3;
            }
            ++n2;
        }
        return true;
    }

    public int min() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] < n) {
                n = this.m_data[n2];
            }
            ++n2;
        }
        return n;
    }

    public double maxAbs() {
        double d = -2.147483647E9;
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = Math.abs(this.m_data[n]);
            if ((double)n2 > d) {
                d = n2;
            }
            ++n;
        }
        return d;
    }

    public static PiVector blendNew(int n, PiVector piVector, int n2, PiVector piVector2) {
        PiVector piVector3 = new PiVector(piVector.getSize());
        piVector3.blend(n, piVector, n2, piVector2);
        return piVector3;
    }

    public void multScalar(int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] * n;
        }
    }

    public void multScalar(PiVector piVector, int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            this.m_data[n2] = piVector.m_data[n2] * n;
            ++n2;
        }
    }

    public void set(PiVector piVector, int n, int n2) {
        if (piVector == null || piVector.getSize() < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.m_data[n3] = piVector.m_data[n + n3];
            ++n3;
        }
    }

    public void set(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.m_data[n3] = nArray[n + n3];
            ++n3;
        }
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, n);
    }

    public void set(int[] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(nArray, 0, nArray.length);
    }

    public void set(int n) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = n;
    }

    public PiVector() {
        this(0);
    }

    public PiVector(int n) {
        this.m_data = new int[n];
    }

    public PiVector(int n, int n2) {
        this(2);
        this.m_data[0] = n;
        this.m_data[1] = n2;
    }

    public PiVector(int n, int n2, int n3) {
        this(3);
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public PiVector(int n, int n2, int n3, int n4) {
        this(4);
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
        this.m_data[3] = n4;
    }

    public PiVector(int[] nArray) {
        this();
        this.set(nArray);
    }

    public void set(int n, int n2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
    }

    public void set(int n, int n2, int n3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public void set(int n, int n2, int n3, int n4) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
        this.m_data[3] = n4;
    }

    public void shift(int n) {
        if (n != 1 && n != -1) {
            PsDebug.warning("method allows num==1 or num=-1");
            return;
        }
        int n2 = this.m_data.length;
        int n3 = this.m_data[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2 - 1) {
            int n6 = (n4 - n + n2) % n2;
            this.m_data[n4] = this.m_data[n6];
            n4 = n6;
            ++n5;
        }
        if (n == -1) {
            n = (n + n2) % n2;
        }
        this.m_data[n] = n3;
    }

    public static PiVector subNew(PiVector piVector, PiVector piVector2) {
        int n;
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n2 = piVector.getSize();
        if (n2 != (n = piVector2.getSize())) {
            PsDebug.warning("different size of argument vectors");
            n2 = Math.min(n2, n);
        }
        PiVector piVector3 = new PiVector(n2);
        piVector3.sub(piVector, piVector2);
        return piVector3;
    }

    public void blend(int n, PiVector piVector, int n2, PiVector piVector2) {
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n3 = 0;
        while (n3 < this.m_data.length) {
            this.m_data[n3] = n * piVector.m_data[n3] + n2 * piVector2.m_data[n3];
            ++n3;
        }
    }

    public void sort(PiVector piVector) {
        int n = this.getSize();
        if (piVector == null || piVector.m_data == null) {
            piVector = new PiVector(n);
        }
        if (piVector.getSize() != n) {
            piVector.setSize(n);
        }
        if (n < 10) {
            int[] nArray = piVector.m_data;
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.m_data[n2];
                ++n2;
            }
            int n3 = n - 1;
            while (n3 > 0) {
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray[n4] > nArray[n4 + 1]) {
                        n2 = nArray[n4 + 1];
                        nArray[n4 + 1] = nArray[n4];
                        nArray[n4] = n2;
                    }
                    ++n4;
                }
                --n3;
            }
            return;
        }
        int[] nArray = new int[n];
        PuMath.heapsort(n, this.m_data, nArray);
        int n5 = 0;
        while (n5 < n) {
            piVector.m_data[n5] = this.m_data[nArray[n5]];
            ++n5;
        }
    }

    public void sort() {
        int n = this.getSize();
        if (n < 10) {
            int n2 = n - 1;
            while (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    if (this.m_data[n3] > this.m_data[n3 + 1]) {
                        int n4 = this.m_data[n3 + 1];
                        this.m_data[n3 + 1] = this.m_data[n3];
                        this.m_data[n3] = n4;
                    }
                    ++n3;
                }
                --n2;
            }
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n5 = 0;
        while (n5 < n) {
            nArray2[n5] = this.m_data[n5];
            ++n5;
        }
        PuMath.heapsort(n, nArray2, nArray);
        n5 = 0;
        while (n5 < n) {
            this.m_data[n5] = nArray2[nArray[n5]];
            ++n5;
        }
    }

    public void rightMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int[] nArray = new int[this.m_data.length];
        int n = 0;
        while (n < this.m_data.length) {
            nArray[n] = 0;
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = n;
                nArray[n3] = (int)((double)nArray[n3] + (double)this.m_data[n2] * pdMatrix.m_data[n2][n]);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = nArray[n];
            ++n;
        }
    }

    public void rightMultMatrix(PiVector piVector, PdMatrix pdMatrix) {
        if (this == piVector) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != pdMatrix.m_jSize) {
            this.setSize(pdMatrix.m_jSize);
        }
        int n = 0;
        while (n < pdMatrix.m_jSize) {
            this.m_data[n] = 0;
            int n2 = 0;
            while (n2 < pdMatrix.m_iSize) {
                int n3 = n;
                this.m_data[n3] = (int)((double)this.m_data[n3] + (double)piVector.m_data[n2] * pdMatrix.m_data[n2][n]);
                ++n2;
            }
            ++n;
        }
    }

    public int getIndexOf(int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOfAbsMax() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = Math.abs(this.m_data[n3]);
            if (n4 > n2) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        return n;
    }
}

