/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdMatrix
implements Serializable {
    private int m_size = 0;
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public double[][] m_data;

    public void setColumn(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_jSize || pdVector.getSize() != this.m_iSize) {
            PsDebug.warning("invalid column index or vector size");
            return;
        }
        int n2 = 0;
        while (n2 < this.m_iSize) {
            this.m_data[n2][n] = pdVector.m_data[n2];
            ++n2;
        }
    }

    public static PdMatrix[] realloc(PdMatrix[] pdMatrixArray, int n) {
        int n2;
        int n3;
        if (pdMatrixArray != null && pdMatrixArray.length == n) {
            return pdMatrixArray;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        if (pdMatrixArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdMatrixArray.length, n);
            System.arraycopy(pdMatrixArray, 0, pdMatrixArray2, 0, n3);
            n2 = 0;
            while (n2 < n3) {
                if (pdMatrixArray2[n2] == null) {
                    pdMatrixArray2[n2] = new PdMatrix();
                }
                ++n2;
            }
        }
        n2 = n3;
        while (n2 < n) {
            pdMatrixArray2[n2] = new PdMatrix();
            ++n2;
        }
        return pdMatrixArray2;
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public double[][] getEntries() {
        double[][] dArrayArray = new double[this.m_iSize][];
        int n = 0;
        while (n < this.m_iSize) {
            dArrayArray[n] = (double[])this.m_data[n].clone();
            ++n;
        }
        return dArrayArray;
    }

    public void leftMult(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null || pdMatrix.m_iSize < n || pdMatrix.m_jSize < n) {
            PsDebug.warning("size of parameter matrix too large");
            return;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + pdMatrix.m_data[n3][n4] * this.m_data[n4][n2];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                this.m_data[n3][n2] = dArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public void leftMult(PdMatrix pdMatrix) {
        if (pdMatrix == null || pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] dArray = new double[this.m_jSize];
        int n = 0;
        while (n < this.m_jSize) {
            int n2 = 0;
            while (n2 < this.m_iSize) {
                dArray[n2] = 0.0;
                int n3 = 0;
                while (n3 < this.m_iSize) {
                    int n4 = n2;
                    dArray[n4] = dArray[n4] + pdMatrix.m_data[n2][n3] * this.m_data[n3][n];
                    ++n3;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_iSize) {
                this.m_data[n2][n] = dArray[n2];
                ++n2;
            }
            ++n;
        }
    }

    public void rightMult(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null || pdMatrix.m_iSize < n || pdMatrix.m_jSize < n) {
            PsDebug.warning("size of parameter matrix too large");
            return;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + this.m_data[n2][n4] * pdMatrix.m_data[n4][n3];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                this.m_data[n2][n3] = dArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public void rightMult(PdMatrix pdMatrix) {
        if (pdMatrix == null || pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int n = pdMatrix.m_jSize;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < this.m_iSize) {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = 0.0;
                int n4 = 0;
                while (n4 < this.m_jSize) {
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + this.m_data[n2][n4] * pdMatrix.m_data[n4][n3];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                this.m_data[n2][n3] = dArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public boolean invertTopLeft(PdMatrix pdMatrix, int n) {
        int n2;
        if (this.m_size < n || pdMatrix.m_size < n) {
            PsDebug.warning("method 'invertTopLeft' not applicable");
            return false;
        }
        PdMatrix pdMatrix2 = new PdMatrix(n);
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                pdMatrix2.m_data[n3][n2] = pdMatrix.m_data[n3][n2];
                ++n2;
            }
            ++n3;
        }
        if (!pdMatrix2.invert()) {
            PsDebug.warning("matrix singular");
            this.setIdentity();
            return false;
        }
        this.copy(pdMatrix);
        n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                this.m_data[n3][n2] = pdMatrix2.m_data[n3][n2];
                ++n2;
            }
            ++n3;
        }
        return true;
    }

    public double det() {
        double[][] dArray = this.m_data;
        switch (this.m_size) {
            case 1: {
                return dArray[0][0];
            }
            case 2: {
                return dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            }
            case 3: {
                return dArray[0][0] * (dArray[1][1] * dArray[2][2] - dArray[2][1] * dArray[1][2]) - dArray[0][1] * (dArray[1][0] * dArray[2][2] - dArray[2][0] * dArray[1][2]) + dArray[0][2] * (dArray[1][0] * dArray[2][1] - dArray[2][0] * dArray[1][1]);
            }
            case 4: {
                return dArray[0][0] * (dArray[1][1] * (dArray[2][2] * dArray[3][3] - dArray[3][2] * dArray[2][3]) - dArray[1][2] * (dArray[2][1] * dArray[3][3] - dArray[3][1] * dArray[2][3]) + dArray[1][3] * (dArray[2][1] * dArray[3][2] - dArray[3][1] * dArray[2][2])) - dArray[0][1] * (dArray[1][0] * (dArray[2][2] * dArray[3][3] - dArray[3][2] * dArray[2][3]) - dArray[1][2] * (dArray[2][0] * dArray[3][3] - dArray[3][0] * dArray[2][3]) + dArray[1][3] * (dArray[2][0] * dArray[3][2] - dArray[3][0] * dArray[2][2])) + dArray[0][2] * (dArray[1][0] * (dArray[2][1] * dArray[3][3] - dArray[3][1] * dArray[2][3]) - dArray[1][1] * (dArray[2][0] * dArray[3][3] - dArray[3][0] * dArray[2][3]) + dArray[1][3] * (dArray[2][0] * dArray[3][1] - dArray[3][0] * dArray[2][1])) - dArray[0][3] * (dArray[1][0] * (dArray[2][1] * dArray[3][2] - dArray[3][1] * dArray[2][2]) - dArray[1][1] * (dArray[2][0] * dArray[3][2] - dArray[3][0] * dArray[2][2]) + dArray[1][2] * (dArray[2][0] * dArray[3][1] - dArray[3][0] * dArray[2][1]));
            }
        }
        PsDebug.warning("not implemented for m_size>4");
        return 1.0;
    }

    public double getEntry(int n, int n2) {
        if (n < 0 || this.m_iSize <= n) {
            PsDebug.warning("index i out of range, index=" + n);
            return 0.0;
        }
        if (n2 < 0 || this.m_jSize <= n2) {
            PsDebug.warning("index j out of range, index=" + n2);
            return 0.0;
        }
        return this.m_data[n][n2];
    }

    public void setEntry(int n, int n2, double d) {
        if (this.m_iSize <= n || this.m_jSize <= n2) {
            this.setSize(n + 1, n2 + 1);
        }
        this.m_data[n][n2] = d;
    }

    public void add(PdMatrix pdMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                double[] dArray = this.m_data[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] + pdMatrix.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void add(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = pdMatrix.m_data[n][n2] + pdMatrix2.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_data == null) {
            stringBuffer.append("\t m_data = null\n");
        } else {
            int n = 0;
            while (n < this.m_iSize) {
                stringBuffer.append("\t [" + PuString.intToString(n, 3) + "] = {");
                stringBuffer.append(" " + String.valueOf(this.m_data[n][0]));
                int n2 = 1;
                while (n2 < this.m_jSize) {
                    stringBuffer.append(", " + String.valueOf(this.m_data[n][n2]));
                    ++n2;
                }
                stringBuffer.append("}\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean adjoint(PdVector pdVector) {
        return this.adjoint(pdVector, pdVector);
    }

    public boolean adjoint(PdVector pdVector, PdVector pdVector2) {
        if (this.m_iSize != pdVector.m_data.length || this.m_jSize != pdVector2.m_data.length) {
            this.setSize(pdVector.m_data.length, pdVector2.m_data.length);
        }
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = pdVector.m_data[n] * pdVector2.m_data[n2];
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public void setDiagonal(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.getSize() < this.m_size) {
            PsDebug.warning("vector too small");
            return;
        }
        int n = 0;
        while (n < this.m_size) {
            this.m_data[n][n] = pdVector.m_data[n];
            ++n;
        }
    }

    public static PdMatrix[] copyNew(PdMatrix[] pdMatrixArray) {
        if (pdMatrixArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdMatrix.copyNew(pdMatrixArray, pdMatrixArray.length);
    }

    public static PdMatrix[] copyNew(PdMatrix[] pdMatrixArray, int n) {
        if (pdMatrixArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        int n2 = 0;
        while (n2 < n) {
            pdMatrixArray2[n2] = new PdMatrix(pdMatrixArray[n2].m_iSize, pdMatrixArray[n2].m_jSize);
            pdMatrixArray2[n2].copy(pdMatrixArray[n2]);
            ++n2;
        }
        return pdMatrixArray2;
    }

    public static PdMatrix copyNew(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix pdMatrix2 = new PdMatrix(pdMatrix.m_iSize, pdMatrix.m_jSize);
        pdMatrix2.copy(pdMatrix);
        return pdMatrix2;
    }

    public void mult(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this == pdMatrix || this == pdMatrix2) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        int n = pdMatrix.m_iSize;
        int n2 = pdMatrix2.m_jSize;
        int n3 = pdMatrix.m_jSize;
        if (this.m_iSize != n || this.m_jSize != n2) {
            this.setSize(n, n2);
        }
        this.setConstant(0.0);
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n3) {
                if (pdMatrix.m_data[n4][n5] != 0.0) {
                    int n6 = 0;
                    while (n6 < n2) {
                        double[] dArray = this.m_data[n4];
                        int n7 = n6;
                        dArray[n7] = dArray[n7] + pdMatrix.m_data[n4][n5] * pdMatrix2.m_data[n5][n6];
                        ++n6;
                    }
                }
                ++n5;
            }
            ++n4;
        }
    }

    public boolean invert() {
        PdMatrix pdMatrix = new PdMatrix(this.m_size);
        pdMatrix.copy(this);
        return this.invert(pdMatrix);
    }

    public boolean invert(PdMatrix pdMatrix) {
        if (this.m_size != pdMatrix.m_size) {
            PsDebug.warning("different size of this matrix and argument matrix.");
            return false;
        }
        double d = 1.0;
        if (1 <= this.m_size && this.m_size <= 4) {
            d = pdMatrix.det();
            if (Math.abs(d) < 1.0E-10) {
                this.setIdentity();
                return false;
            }
        } else {
            PsDebug.warning("cannot invert matrix of size = " + String.valueOf(this.m_size));
            return false;
        }
        switch (this.m_size) {
            case 1: {
                this.m_data[0][0] = 1.0 / d;
                break;
            }
            case 2: {
                this.m_data[0][0] = pdMatrix.m_data[1][1] / d;
                this.m_data[0][1] = -pdMatrix.m_data[0][1] / d;
                this.m_data[1][0] = -pdMatrix.m_data[1][0] / d;
                this.m_data[1][1] = pdMatrix.m_data[0][0] / d;
                break;
            }
            case 3: {
                this.m_data[0][0] = (pdMatrix.m_data[1][1] * pdMatrix.m_data[2][2] - pdMatrix.m_data[2][1] * pdMatrix.m_data[1][2]) / d;
                this.m_data[0][1] = (pdMatrix.m_data[0][2] * pdMatrix.m_data[2][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[2][2]) / d;
                this.m_data[0][2] = (pdMatrix.m_data[0][1] * pdMatrix.m_data[1][2] - pdMatrix.m_data[0][2] * pdMatrix.m_data[1][1]) / d;
                this.m_data[1][0] = (pdMatrix.m_data[1][2] * pdMatrix.m_data[2][0] - pdMatrix.m_data[1][0] * pdMatrix.m_data[2][2]) / d;
                this.m_data[1][1] = (pdMatrix.m_data[0][0] * pdMatrix.m_data[2][2] - pdMatrix.m_data[0][2] * pdMatrix.m_data[2][0]) / d;
                this.m_data[1][2] = (pdMatrix.m_data[0][2] * pdMatrix.m_data[1][0] - pdMatrix.m_data[0][0] * pdMatrix.m_data[1][2]) / d;
                this.m_data[2][0] = (pdMatrix.m_data[1][0] * pdMatrix.m_data[2][1] - pdMatrix.m_data[1][1] * pdMatrix.m_data[2][0]) / d;
                this.m_data[2][1] = (pdMatrix.m_data[0][1] * pdMatrix.m_data[2][0] - pdMatrix.m_data[0][0] * pdMatrix.m_data[2][1]) / d;
                this.m_data[2][2] = (pdMatrix.m_data[0][0] * pdMatrix.m_data[1][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[1][0]) / d;
                break;
            }
            case 4: {
                int n;
                double[] dArray = new double[4];
                double[][] dArray2 = new double[4][4];
                int n2 = 0;
                do {
                    n = 0;
                    do {
                        dArray2[n2][n] = pdMatrix.m_data[n2][n];
                    } while (++n < 4);
                } while (++n2 < 4);
                n2 = 0;
                do {
                    int n3;
                    int n4 = n2;
                    n = n2 + 1;
                    while (n < 4) {
                        if (Math.abs(dArray2[n][n2]) > Math.abs(dArray2[n4][n2])) {
                            n4 = n;
                        }
                        ++n;
                    }
                    if (dArray2[n4][n2] == 0.0) {
                        this.setIdentity();
                        return false;
                    }
                    if (n4 != n2) {
                        n = 0;
                        do {
                            dArray[n] = dArray2[n4][n];
                            dArray2[n4][n] = dArray2[n2][n];
                            dArray2[n2][n] = dArray[n];
                        } while (++n < 4);
                        n = 0;
                        do {
                            dArray[n] = this.m_data[n4][n];
                            this.m_data[n4][n] = this.m_data[n2][n];
                            this.m_data[n2][n] = dArray[n];
                        } while (++n < 4);
                    }
                    n = 0;
                    do {
                        dArray[n] = dArray2[n][n2] / dArray2[n2][n2];
                    } while (++n < 4);
                    n = 0;
                    while (n < n2) {
                        n3 = 0;
                        do {
                            double[] dArray3 = dArray2[n];
                            int n5 = n3;
                            dArray3[n5] = dArray3[n5] - dArray2[n2][n3] * dArray[n];
                        } while (++n3 < 4);
                        n3 = 0;
                        do {
                            double[] dArray4 = this.m_data[n];
                            int n6 = n3;
                            dArray4[n6] = dArray4[n6] - this.m_data[n2][n3] * dArray[n];
                        } while (++n3 < 4);
                        ++n;
                    }
                    n = n2 + 1;
                    while (n < 4) {
                        n3 = 0;
                        do {
                            double[] dArray5 = dArray2[n];
                            int n7 = n3;
                            dArray5[n7] = dArray5[n7] - dArray2[n2][n3] * dArray[n];
                        } while (++n3 < 4);
                        n3 = 0;
                        do {
                            double[] dArray6 = this.m_data[n];
                            int n8 = n3;
                            dArray6[n8] = dArray6[n8] - this.m_data[n2][n3] * dArray[n];
                        } while (++n3 < 4);
                        ++n;
                    }
                } while (++n2 < 4);
                n2 = 0;
                do {
                    n = 0;
                    do {
                        double[] dArray7 = this.m_data[n2];
                        int n9 = n++;
                        dArray7[n9] = dArray7[n9] / dArray2[n2][n2];
                    } while (n < 4);
                } while (++n2 < 4);
            }
        }
        return true;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.m_iSize == this.m_jSize) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int n) {
        this.setSize(n, n);
    }

    public void setSize(int n, int n2) {
        if (this.m_iSize == n && this.m_jSize == n2) {
            return;
        }
        double[][] dArrayArray = new double[n][];
        int n3 = Math.min(this.m_iSize, n);
        int n4 = n3 - 1;
        while (n4 >= 0) {
            dArrayArray[n4] = PuData.realloc(this.m_data[n4], n2);
            --n4;
        }
        n4 = n3;
        while (n4 < n) {
            dArrayArray[n4] = new double[n2];
            ++n4;
        }
        this.m_size = n;
        this.m_iSize = n;
        this.m_jSize = n2;
        this.m_data = dArrayArray;
    }

    public void setColumns(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length < this.m_jSize) {
            PsDebug.warning("missing vector list, or invalid number of columns");
            return;
        }
        int n = 0;
        while (n < this.m_jSize) {
            this.setColumn(n, pdVectorArray[n]);
            ++n;
        }
    }

    public Object clone() {
        return PdMatrix.copyNew(this);
    }

    public void setIdentity() {
        int n = 0;
        while (n < this.m_size) {
            int n2 = 0;
            while (n2 < this.m_size) {
                this.m_data[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_size) {
            this.m_data[n][n] = 1.0;
            ++n;
        }
    }

    public double det33() {
        double[][] dArray = this.m_data;
        if (this.m_size < 3) {
            PsDebug.warning("not implemented for m_size<3");
            return 1.0;
        }
        return dArray[0][0] * (dArray[1][1] * dArray[2][2] - dArray[2][1] * dArray[1][2]) - dArray[0][1] * (dArray[1][0] * dArray[2][2] - dArray[2][0] * dArray[1][2]) + dArray[0][2] * (dArray[1][0] * dArray[2][1] - dArray[2][0] * dArray[1][1]);
    }

    public void multScalar(double d) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                double[] dArray = this.m_data[n];
                int n3 = n2++;
                dArray[n3] = dArray[n3] * d;
            }
            ++n;
        }
    }

    public void multScalar(PdMatrix pdMatrix, double d) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = pdMatrix.m_data[n][n2] * d;
                ++n2;
            }
            ++n;
        }
    }

    public void set(double[][] dArray) {
        if (dArray == null || dArray.length == 0) {
            this.setSize(0, 0);
            return;
        }
        if (dArray[0] == null) {
            this.setSize(dArray.length, 0);
            return;
        }
        this.setSize(dArray.length, dArray[0].length);
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] == null || dArray[n].length != dArray[0].length) {
                PsDebug.warning("non-matrix double array");
                return;
            }
            int n2 = 0;
            while (n2 < dArray[0].length) {
                this.m_data[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("PdMatrix \n");
        stringBuffer.append("\t m_iSize = " + this.m_iSize);
        stringBuffer.append(", m_jSize = " + this.m_jSize);
        stringBuffer.append(", m_size  = " + this.m_size + "\n");
        if (this.m_data == null) {
            stringBuffer.append("\t m_data = null\n");
        } else {
            int n = 0;
            while (n < this.m_iSize) {
                stringBuffer.append("\t [" + PuString.intToString(n, 3) + "] = {");
                stringBuffer.append(" " + String.valueOf(this.m_data[n][0]));
                int n2 = 1;
                while (n2 < this.m_jSize) {
                    stringBuffer.append(", " + String.valueOf(this.m_data[n][n2]));
                    ++n2;
                }
                stringBuffer.append("}\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public PdMatrix() {
        this(0);
    }

    public PdMatrix(int n) {
        this.setSize(n, n);
    }

    public PdMatrix(int n, int n2) {
        this.setSize(n, n2);
    }

    public PdMatrix(double[][] dArray) {
        this();
        this.set(dArray);
    }

    public static PdMatrix expandComponents(PdMatrix pdMatrix, int n) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument matrix");
            return null;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize) {
            PsDebug.warning("argument matrix not square");
            return null;
        }
        int n2 = pdMatrix.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n2 * n);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * n;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n5 * n;
                int n7 = 0;
                while (n7 < n) {
                    pdMatrix2.m_data[n4 + n7][n6 + n7] = pdMatrix.m_data[n3][n5];
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        return pdMatrix2;
    }

    public void transpose() {
        int n = 0;
        while (n < this.m_size) {
            int n2 = n + 1;
            while (n2 < this.m_size) {
                double d = this.m_data[n][n2];
                this.m_data[n][n2] = this.m_data[n2][n];
                this.m_data[n2][n] = d;
                ++n2;
            }
            ++n;
        }
    }

    public void transpose(PdMatrix pdMatrix) {
        int n = 0;
        while (n < this.m_size) {
            this.m_data[n][n] = pdMatrix.m_data[n][n];
            int n2 = n + 1;
            while (n2 < this.m_size) {
                this.m_data[n][n2] = pdMatrix.m_data[n2][n];
                this.m_data[n2][n] = pdMatrix.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void sub(PdMatrix pdMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                double[] dArray = this.m_data[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] - pdMatrix.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void sub(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = pdMatrix.m_data[n][n2] - pdMatrix2.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public static boolean copy(PdMatrix[] pdMatrixArray, int n, PdMatrix[] pdMatrixArray2, int n2, int n3) {
        if (pdMatrixArray == null || pdMatrixArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            pdMatrixArray[n + n4].copy(pdMatrixArray2[n2 + n4]);
            ++n4;
        }
        return true;
    }

    public void copy(PdMatrix pdMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = pdMatrix.m_data[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public int getISize() {
        return this.m_iSize;
    }

    public PdVector getRow(int n) {
        if (n < 0 || n >= this.m_iSize) {
            PsDebug.warning("invalid row index");
            return null;
        }
        PdVector pdVector = new PdVector(this.m_jSize);
        int n2 = 0;
        while (n2 < this.m_jSize) {
            pdVector.m_data[n2] = this.m_data[n][n2];
            ++n2;
        }
        return pdVector;
    }

    public void setRow(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_iSize || pdVector.getSize() != this.m_jSize) {
            PsDebug.warning("invalid row index or vector size");
            return;
        }
        int n2 = 0;
        while (n2 < this.m_jSize) {
            this.m_data[n][n2] = pdVector.m_data[n2];
            ++n2;
        }
    }

    public void setConstant(double d) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2] = d;
                ++n2;
            }
            ++n;
        }
    }

    public boolean invert34(PdMatrix pdMatrix) {
        if (!this.invertTopLeft(pdMatrix, 3)) {
            PsDebug.warning("matrix singular");
            this.setIdentity();
            return false;
        }
        int n = 0;
        do {
            this.m_data[n][3] = 0.0;
            int n2 = 0;
            do {
                double[] dArray = this.m_data[n];
                dArray[3] = dArray[3] - this.m_data[n][n2] * pdMatrix.m_data[n2][3];
            } while (++n2 < 3);
        } while (++n < 3);
        return true;
    }

    public void setRows(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length < this.m_iSize) {
            PsDebug.warning("missing vector list, or invalid number of rows");
            return;
        }
        int n = 0;
        while (n < this.m_iSize) {
            this.setRow(n, pdVectorArray[n]);
            ++n;
        }
    }

    public static PdMatrix[] realloc(PdMatrix[] pdMatrixArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 0) {
            return PdMatrix.realloc(pdMatrixArray, n);
        }
        if (pdMatrixArray != null && pdMatrixArray.length == n) {
            int n6 = 0;
            while (n6 < pdMatrixArray.length) {
                if (pdMatrixArray[n6] == null) {
                    pdMatrixArray[n6] = new PdMatrix(n2, n3);
                } else if (pdMatrixArray[n6].m_data == null || pdMatrixArray[n6].m_data.length != n2 || pdMatrixArray[n6].m_data[0].length != n3) {
                    pdMatrixArray[n6].setSize(n2, n3);
                }
                ++n6;
            }
            return pdMatrixArray;
        }
        PdMatrix[] pdMatrixArray2 = new PdMatrix[n];
        if (pdMatrixArray == null) {
            n5 = 0;
        } else {
            n5 = Math.min(pdMatrixArray.length, n);
            System.arraycopy(pdMatrixArray, 0, pdMatrixArray2, 0, n5);
            n4 = 0;
            while (n4 < n5) {
                if (pdMatrixArray2[n4] == null) {
                    pdMatrixArray2[n4] = new PdMatrix(n2, n3);
                } else if (pdMatrixArray2[n4].m_data == null || pdMatrixArray2[n4].m_data.length != n2 || pdMatrixArray[n4].m_data[0].length != n3) {
                    pdMatrixArray2[n4].setSize(n2, n3);
                }
                ++n4;
            }
        }
        n4 = n5;
        while (n4 < n) {
            pdMatrixArray2[n4] = new PdMatrix(n2, n3);
            ++n4;
        }
        return pdMatrixArray2;
    }

    public PdVector getColumn(int n) {
        if (n < 0 || n >= this.m_jSize) {
            PsDebug.warning("invalid column index");
            return null;
        }
        PdVector pdVector = new PdVector(this.m_iSize);
        int n2 = 0;
        while (n2 < this.m_iSize) {
            pdVector.m_data[n2] = this.m_data[n2][n];
            ++n2;
        }
        return pdVector;
    }
}

