/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.object.PsDebug;

public abstract class P_Vector
implements Serializable {
    protected static final int NUM_BITS = 32;
    protected static final int BITS = 6;
    protected static final int MASK = 63;
    protected long[] m_bits;
    protected String[] m_name;
    protected static final int NAME = 0;
    protected static final int DETAIL = 1;
    protected static final int URL = 2;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t" + super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("\t ******* P_Vector ***********\n");
        stringBuffer.append("\t Name Info: ");
        if (this.getName() != null) {
            stringBuffer.append("Name = " + this.getName() + "; ");
        }
        if (this.getDetail() != null) {
            stringBuffer.append("Detail = " + this.getDetail() + "; ");
        }
        if (this.getURL() != null) {
            stringBuffer.append("URL = " + this.getURL());
        }
        stringBuffer.append(")\n");
        if (this.m_bits != null && this.m_bits.length > 0) {
            stringBuffer.append("\t Attr = (" + this.m_bits[0]);
            int n = 1;
            while (n < this.m_bits.length) {
                stringBuffer.append(", " + this.m_bits[n]);
                ++n;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t Attr = null\n");
        }
        return stringBuffer.toString();
    }

    public void clearTag(int n) {
        if (this.m_bits == null) {
            return;
        }
        int n2 = n >> 6;
        if (n2 >= this.m_bits.length) {
            return;
        }
        int n3 = n2;
        this.m_bits[n3] = this.m_bits[n3] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void setTag(int n) {
        int n2;
        if (this.m_bits == null) {
            this.m_bits = new long[1];
        }
        if ((n2 = n >> 6) >= this.m_bits.length) {
            long[] lArray = new long[Math.max(this.m_bits.length << 1, n2 + 1)];
            int n3 = this.m_bits.length - 1;
            while (n3 >= 0) {
                lArray[n3] = this.m_bits[n3];
                --n3;
            }
            this.m_bits = lArray;
        }
        int n4 = n2;
        this.m_bits[n4] = this.m_bits[n4] | 1L << (n & 0x3F);
    }

    public String getDetail() {
        if (this.m_name == null) {
            return null;
        }
        return this.m_name[1];
    }

    public void setDetail(String string) {
        this.assureName(1, string);
    }

    public boolean hasTag(int n) {
        if (this.m_bits == null) {
            return false;
        }
        int n2 = n >> 6;
        if (n2 < this.m_bits.length) {
            return (this.m_bits[n2] & 1L << (n & 0x3F)) != 0L;
        }
        return false;
    }

    public void copy(P_Vector p_Vector) {
        int n;
        if (p_Vector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (p_Vector.m_bits == null) {
            this.m_bits = null;
        } else if (this.m_bits == null || this.m_bits.length < p_Vector.m_bits.length) {
            this.m_bits = (long[])p_Vector.m_bits.clone();
        } else {
            n = this.m_bits.length - 1;
            while (n >= 0) {
                this.m_bits[n] = p_Vector.m_bits[n];
                --n;
            }
        }
        if (p_Vector.m_name == null) {
            this.m_name = null;
            return;
        }
        if (this.m_name == null || this.m_name.length < p_Vector.m_name.length) {
            this.m_name = (String[])p_Vector.m_name.clone();
            return;
        }
        n = this.m_name.length - 1;
        while (n >= 0) {
            this.m_name[n] = p_Vector.m_name[n];
            --n;
        }
    }

    public static void invert(Object[] objectArray, int n) {
        if (objectArray == null || n < 2) {
            return;
        }
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n - 1 - n3];
            objectArray[n - 1 - n3] = object;
            ++n3;
        }
    }

    public String getURL() {
        if (this.m_name == null) {
            return null;
        }
        return this.m_name[2];
    }

    public String getName() {
        if (this.m_name == null) {
            return null;
        }
        return this.m_name[0];
    }

    public void setName(String string) {
        this.assureName(0, string);
    }

    public void setURL(String string) {
        this.assureName(2, string);
    }

    private void assureName(int n, String string) {
        if (string != null) {
            if (this.m_name == null) {
                this.m_name = new String[3];
            }
            this.m_name[n] = string;
            return;
        }
        if (this.m_name == null) {
            return;
        }
        if (this.m_name[(n + 1) % 3] == null && this.m_name[(n + 2) % 3] == null) {
            this.m_name = null;
            return;
        }
        this.m_name[n] = null;
    }

    public long[] getBits() {
        return this.m_bits;
    }

    public static P_Vector[][] clone(P_Vector[][] p_VectorArray) {
        if (p_VectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        P_Vector[][] p_VectorArray2 = (P_Vector[][])p_VectorArray.clone();
        int n = 0;
        while (n < p_VectorArray.length) {
            if (p_VectorArray[n] != null) {
                p_VectorArray2[n] = P_Vector.clone(p_VectorArray[n]);
            }
            ++n;
        }
        return p_VectorArray2;
    }

    public static P_Vector[] clone(P_Vector[] p_VectorArray) {
        if (p_VectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        P_Vector[] p_VectorArray2 = (P_Vector[])p_VectorArray.clone();
        try {
            int n = 0;
            while (n < p_VectorArray.length) {
                if (p_VectorArray[n] != null) {
                    p_VectorArray2[n] = (P_Vector)p_VectorArray[n].clone();
                }
                ++n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return p_VectorArray2;
    }
}

