/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgRuler
extends PgJvxSrc {
    public static final int HASH_FIXED = 0;
    public static final int MODE_FIXED = 0;
    public static final int HASH_PARTITIONED = 1;
    public static final int MODE_PARTITIONED = 1;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int NORMALHP1 = 0;
    private static final int NORMALHP2 = 1;
    private static final int UPHP1 = 2;
    private static final int UPHP2 = 3;
    public static final int NORMAL_DIRECTION = 0;
    public static final int UP_VECTOR_DIRECTION = 1;
    public static final int RULER_NAME_ALIGN_LEFT = 0;
    public static final int RULER_NAME_ALIGN_RIGHT = 1;
    public static final int RULER_NAME_ALIGN_CENTER = 2;
    protected int m_hashMode;
    protected boolean m_bMajorMode;
    protected boolean m_bMinorMode;
    protected boolean m_bHashInNormalDir;
    protected boolean m_bHashInUpDir;
    protected boolean m_bShowLabels;
    protected boolean m_bShowArrow;
    protected String m_rulerName;
    protected boolean m_bShowRulerName;
    protected int m_rulerNamePos;
    private PdVector m_minMax;
    protected PdVector m_origin;
    protected PdVector m_normalOffset;
    protected PdVector m_upOffset;
    protected PdVector m_v;
    protected PdVector m_n;
    protected PdVector m_u;
    protected boolean m_bAutoBounds;
    protected boolean m_bAutoHashing;
    protected boolean m_bAutoLayout;
    protected double[] m_minorHashExtent;
    protected double[] m_majorHashExtent;
    protected Color m_majorHashExtentColor;
    protected Color m_minorHashExtentColor;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    protected PuDouble m_bndMin;
    protected PuDouble m_bndMax;
    protected PdColor m_edgeColor;
    protected PuDouble m_edgeSize;
    private double m_defMin = -10.0;
    private double m_defMax = 10.0;
    private double m_defMajorHashUnit = 5.0;
    private double m_defMinorHashUnit = 1.0;
    private int m_defNumMajorHashings = 5;
    private int m_defNumMinorHashings = 2;
    protected double m_defhMajor = 0.4;
    protected double m_defhMinor = 0.2;
    private boolean m_defbHashInNormalDir = true;
    private boolean m_defbHashInUpDir = false;
    private Color m_defhMajorColor = Color.blue;
    private Color m_defhMinorColor = new Color(127, 127, 255);
    protected boolean m_bHasGrid = false;
    protected boolean m_bHashCentered = false;
    private PdVector m_hashBase;
    private PdVector m_hashTip;
    private PdVector m_hashOrigin;
    private int m_numMajor;
    private int m_numMinor;
    private double[] m_majorHashing;
    private double[] m_minorHashing;
    protected double m_ratio;

    public double getMaxParameter() {
        return this.m_minMax.getEntry(1);
    }

    public void setOrigin(double d, double d2, double d3) {
        this.m_origin.set(d, d2, d3);
    }

    public void setOrigin(PdVector pdVector) {
        this.m_origin.copyArray(pdVector);
    }

    public boolean isShowingMinorHashings() {
        return this.m_bMinorMode;
    }

    public void showMinorHashings(boolean bl) {
        this.m_bMinorMode = bl;
    }

    public void setMajorColor(Color color) {
        this.m_majorHashExtentColor = color;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean bl) {
        this.m_bShowLabels = bl;
    }

    public void setMinorColor(Color color) {
        this.m_minorHashExtentColor = color;
    }

    public void setPartitionedHashing(int n, int n2) {
        this.m_numMajorHashings.setValue(n);
        this.m_numMinorHashings.setValue(n2);
    }

    public void setEnabledAutoHashing(boolean bl) {
        this.m_bAutoHashing = bl;
    }

    public void setUpVector(PdVector pdVector) {
        this.m_u.copyArray(pdVector);
        this.m_u.normalize();
    }

    public void setHashOffsetInNormalDir(double d, double d2, double d3) {
        this.m_normalOffset.m_data[0] = d;
        this.m_normalOffset.m_data[1] = d2;
        if (this.m_dim > 2) {
            this.m_normalOffset.m_data[2] = d3;
        }
    }

    public void setHashOffsetInUpDir(double d, double d2, double d3) {
        this.m_upOffset.m_data[0] = d;
        this.m_upOffset.m_data[1] = d2;
        if (this.m_dim > 2) {
            this.m_upOffset.m_data[2] = d3;
        }
    }

    public boolean isShowingRulerName() {
        return this.m_bShowRulerName;
    }

    public void showRulerName(boolean bl) {
        this.m_bShowRulerName = bl;
    }

    public String getRulerName() {
        return this.m_rulerName;
    }

    public void setRulerName(String string) {
        if (string != null && !string.equals("")) {
            this.setName(string);
        }
        this.m_rulerName = string;
    }

    public void setRulerName(String string, int n) {
        this.setRulerName(string);
        this.m_rulerNamePos = n;
    }

    public void setRulerName(String string, boolean bl) {
        this.setRulerName(string);
        this.showRulerName(bl);
    }

    public void setRulerName(String string, int n, boolean bl) {
        this.setRulerName(string);
        this.showRulerName(bl);
        this.m_rulerNamePos = n;
    }

    public void setMinMax(double d, double d2) {
        if (this.m_minMax.m_data[0] == d && this.m_minMax.m_data[1] == d2) {
            return;
        }
        this.m_minMax.m_data[0] = d;
        this.m_minMax.m_data[1] = d2;
        double d3 = this.m_majorHashUnits.getLineIncr();
        double d4 = this.m_majorHashUnits.getPageIncr();
        if (d3 < (d2 - d) / 1000.0) {
            d3 = (d2 - d) / 1000.0;
        }
        if (d4 < (d2 - d) / 100.0) {
            d4 = (d2 - d) / 100.0;
        }
        this.m_majorHashUnits.setBounds(Math.min(this.m_majorHashUnits.getValue() / 10.0, 0.1), d2 - d, d3, d4);
        if (this.m_majorHashUnits.getValue() < d4) {
            this.m_majorHashUnits.setValue(10.0 * d4);
        }
        double d5 = this.m_minorHashUnits.getLineIncr();
        double d6 = this.m_minorHashUnits.getPageIncr();
        if (d5 < (d2 - d) / 1000.0) {
            d5 = (d2 - d) / 1000.0;
        }
        if (d6 < (d2 - d) / 100.0) {
            d6 = (d2 - d) / 100.0;
        }
        this.m_minorHashUnits.setBounds(Math.min(this.m_minorHashUnits.getValue() / 10.0, 0.01), d2 - d, d5, d6);
        if (this.m_minorHashUnits.getValue() < d6) {
            this.m_minorHashUnits.setValue(10.0 * d6);
        }
    }

    protected void computeHashings() {
        int n;
        double d;
        if (!this.isVisible()) {
            return;
        }
        double d2 = this.m_minMax.getEntry(0);
        if (d2 >= (d = this.m_minMax.getEntry(1))) {
            this.setNumVertices(0);
            this.setNumPolygons(0);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.m_hashMode == 0) {
            double d3 = this.m_majorHashUnits.getValue();
            double d4 = this.m_minorHashUnits.getValue();
            if (this.m_bMajorMode) {
                n2 = PgRuler.hashInterval(n2, this.m_majorHashing, d3, d2, true, d, true);
                if (this.m_bMinorMode) {
                    if (n2 == 0) {
                        n3 = PgRuler.hashInterval(n3, this.m_minorHashing, d4, d2, true, d, true);
                    } else {
                        n3 = PgRuler.hashInterval(n3, this.m_minorHashing, d4, d2, false, this.m_majorHashing[0], false);
                        n3 = PgRuler.hashInterval(n3, this.m_minorHashing, d4, this.m_majorHashing[n2 - 1], false, d, false);
                        int n4 = 1;
                        while (n4 < n2) {
                            n3 = PgRuler.hashInterval(n3, this.m_minorHashing, d4, this.m_majorHashing[n4 - 1], false, this.m_majorHashing[n4], false);
                            ++n4;
                        }
                    }
                }
            } else if (this.m_bMinorMode) {
                n3 = PgRuler.hashInterval(n3, this.m_minorHashing, d4, d2, true, d, true);
            }
        } else if (this.m_bMajorMode) {
            n2 = this.partitionInterval(n2, this.m_majorHashing, this.m_numMajorHashings.getValue(), d2, true, d, true);
            if (this.m_bMinorMode) {
                int n5 = this.m_numMinorHashings.getValue();
                n = 1;
                while (n < n2) {
                    n3 = this.partitionInterval(n3, this.m_minorHashing, n5, this.m_majorHashing[n - 1], false, this.m_majorHashing[n], false);
                    ++n;
                }
            }
        } else if (this.m_bMinorMode) {
            int n6 = (this.m_numMajorHashings.getValue() + 1) * (this.m_numMinorHashings.getValue() + 1) - 1;
            n3 = this.partitionInterval(n3, this.m_minorHashing, n6, d2, true, d, true);
        }
        int n7 = 1;
        if (this.m_bHashInNormalDir) {
            n7 += n2 + n3;
        }
        if (this.m_bHashInUpDir) {
            n7 += n2 + n3;
        }
        if (this.m_bShowLabels) {
            n7 += n2;
        }
        if (this.isShowingRulerName()) {
            ++n7;
        }
        n = 2 * n7;
        this.resetVertices();
        this.setNumVertices(n);
        this.setNumPolygons(n7);
        PdVector[] pdVectorArray = this.getVertices();
        PiVector[] piVectorArray = this.getPolygons();
        Color[] colorArray = this.getPolygonColors();
        NumberFormat numberFormat = NumberFormat.getInstance(PsConfig.getLocale());
        numberFormat.setMaximumFractionDigits(1);
        double d5 = Math.log(Math.abs(d - d2));
        if (d5 < 1.0) {
            d5 = Math.min(Math.abs(d5), 10.0);
            numberFormat.setMaximumFractionDigits(2 + (int)d5);
        }
        PdVector pdVector = this.m_v;
        int n8 = 0;
        int n9 = 0;
        piVectorArray[n9].set(n8, n8 + 1);
        colorArray[n9++] = this.m_majorHashExtentColor;
        pdVectorArray[n8++].blendBase(this.m_origin, d2, pdVector);
        pdVectorArray[n8++].blendBase(this.m_origin, d, pdVector);
        if (this.m_bShowLabels) {
            double d6 = 1.0;
            this.m_hashOrigin.copy(this.m_origin);
            if (this.m_bHashCentered && !this.m_bHasGrid) {
                double d7;
                if (this.m_bHashInUpDir) {
                    d7 = (this.m_majorHashExtent[3] - this.m_majorHashExtent[2]) / d6 / 2.0;
                    this.m_hashOrigin.blendBase(this.m_origin, -d7, this.m_u);
                } else if (this.m_bHashInNormalDir) {
                    d7 = (this.m_majorHashExtent[1] - this.m_majorHashExtent[0]) / d6 / 2.0;
                    this.m_hashOrigin.blendBase(this.m_origin, -d7, this.m_n);
                }
            }
            int n10 = 0;
            while (n10 < n2) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                pdVectorArray[n8].setName(numberFormat.format(this.m_majorHashing[n10]));
                pdVectorArray[n8++].blendBase(this.m_hashOrigin, this.m_majorHashing[n10], pdVector);
                pdVectorArray[n8++].blendBase(this.m_hashOrigin, this.m_majorHashing[n10], pdVector);
                ++n10;
            }
        }
        PdVector pdVector2 = this.m_hashBase;
        PdVector pdVector3 = this.m_hashTip;
        if (this.m_bHashInUpDir) {
            double d8 = 1.0;
            this.m_hashOrigin.add(this.m_origin, this.m_upOffset);
            if (this.m_bHashCentered && !this.m_bHasGrid) {
                double d9 = (this.m_majorHashExtent[3] - this.m_majorHashExtent[2]) / d8 / 2.0;
                pdVector2.blendBase(this.m_hashOrigin, -d9, this.m_u);
                pdVector3.blendBase(this.m_hashOrigin, d9, this.m_u);
            } else {
                pdVector2.blendBase(this.m_hashOrigin, this.m_majorHashExtent[2] / d8, this.m_u);
                pdVector3.blendBase(this.m_hashOrigin, this.m_majorHashExtent[3] / d8, this.m_u);
            }
            int n11 = 0;
            while (n11 < n2) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector2, this.m_majorHashing[n11], pdVector);
                pdVectorArray[n8++].blendBase(pdVector3, this.m_majorHashing[n11], pdVector);
                ++n11;
            }
            if (this.m_bHashCentered && !this.m_bHasGrid) {
                double d10 = (this.m_minorHashExtent[3] - this.m_minorHashExtent[2]) / d8 / 2.0;
                pdVector2.blendBase(this.m_hashOrigin, -d10, this.m_u);
                pdVector3.blendBase(this.m_hashOrigin, d10, this.m_u);
            } else {
                pdVector2.blendBase(this.m_hashOrigin, this.m_minorHashExtent[2] / d8, this.m_u);
                pdVector3.blendBase(this.m_hashOrigin, this.m_minorHashExtent[3] / d8, this.m_u);
            }
            int n12 = 0;
            while (n12 < n3) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_minorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector2, this.m_minorHashing[n12], pdVector);
                pdVectorArray[n8++].blendBase(pdVector3, this.m_minorHashing[n12], pdVector);
                ++n12;
            }
        }
        if (this.m_bHashInNormalDir) {
            double d11 = 1.0;
            this.m_hashOrigin.add(this.m_origin, this.m_normalOffset);
            if (this.m_bHashCentered && !this.m_bHasGrid) {
                double d12 = (this.m_majorHashExtent[1] - this.m_majorHashExtent[0]) / d11 / 2.0;
                pdVector2.blendBase(this.m_hashOrigin, -d12, this.m_n);
                pdVector3.blendBase(this.m_hashOrigin, d12, this.m_n);
            } else {
                pdVector2.blendBase(this.m_hashOrigin, this.m_majorHashExtent[0] / d11, this.m_n);
                pdVector3.blendBase(this.m_hashOrigin, this.m_majorHashExtent[1] / d11, this.m_n);
            }
            int n13 = 0;
            while (n13 < n2) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector2, this.m_majorHashing[n13], pdVector);
                pdVectorArray[n8++].blendBase(pdVector3, this.m_majorHashing[n13], pdVector);
                ++n13;
            }
            if (this.m_bHashCentered && !this.m_bHasGrid) {
                double d13 = (this.m_minorHashExtent[1] - this.m_minorHashExtent[0]) / d11 / 2.0;
                pdVector2.blendBase(this.m_hashOrigin, -d13, this.m_n);
                pdVector3.blendBase(this.m_hashOrigin, d13, this.m_n);
            } else {
                pdVector2.blendBase(this.m_hashOrigin, this.m_minorHashExtent[0] / d11, this.m_n);
                pdVector3.blendBase(this.m_hashOrigin, this.m_minorHashExtent[1] / d11, this.m_n);
            }
            int n14 = 0;
            while (n14 < n3) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_minorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector2, this.m_minorHashing[n14], pdVector);
                pdVectorArray[n8++].blendBase(pdVector3, this.m_minorHashing[n14], pdVector);
                ++n14;
            }
        }
        if (this.isShowingRulerName()) {
            double d14 = d2;
            switch (this.m_rulerNamePos) {
                default: {
                    d14 = d2;
                    break;
                }
                case 1: {
                    d14 = d;
                    break;
                }
                case 2: {
                    d14 = (d2 + d) / 2.0;
                }
            }
            piVectorArray[n9].set(n8, n8 + 1);
            piVectorArray[n9].setName(this.getRulerName());
            colorArray[n9] = this.m_majorHashExtentColor;
            pdVectorArray[n8].blendBase(this.m_origin, d14, pdVector);
            pdVectorArray[n8 + 1].copy(pdVectorArray[n8]);
        }
    }

    public void setEnabledAutoBounds(boolean bl) {
        this.m_bAutoBounds = bl;
        this.m_bndMin.setEnabled(!bl);
        this.m_bndMax.setEnabled(!bl);
    }

    public void init() {
        super.init();
        this.setDimOfPolygons(2);
        this.m_bHashInNormalDir = this.m_defbHashInNormalDir;
        this.m_bHashInUpDir = this.m_defbHashInUpDir;
        this.m_hashMode = 0;
        this.m_bMajorMode = true;
        this.m_bMinorMode = true;
        this.m_bShowLabels = true;
        this.showRulerName(false);
        this.m_edgeSize.init();
        this.m_edgeSize.setValue(1.0);
        this.m_edgeSize.setBounds(0.0, 10.0, 1.0, 2.0);
        this.m_majorHashExtent[0] = 0.0;
        this.m_majorHashExtent[1] = this.m_defhMajor;
        this.m_majorHashExtent[2] = 0.0;
        this.m_majorHashExtent[3] = this.m_defhMajor;
        this.m_minorHashExtent[0] = 0.0;
        this.m_minorHashExtent[1] = this.m_defhMinor;
        this.m_minorHashExtent[2] = 0.0;
        this.m_minorHashExtent[3] = this.m_defhMinor;
        this.m_majorHashExtentColor = this.m_defhMajorColor;
        this.m_minorHashExtentColor = this.m_defhMinorColor;
        this.m_numMajorHashings.setDefValue(this.m_defNumMajorHashings);
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.setDefValue(this.m_defNumMinorHashings);
        this.m_numMinorHashings.init();
        this.m_majorHashUnits.setDefBounds(0.1, 50.0, 0.1, 1.0);
        this.m_majorHashUnits.setDefValue(this.m_defMajorHashUnit);
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.setDefBounds(0.01, 10.0, 0.1, 1.0);
        this.m_minorHashUnits.setDefValue(this.m_defMinorHashUnit);
        this.m_minorHashUnits.init();
        this.m_minMax.m_data[0] = this.m_defMin;
        this.m_minMax.m_data[1] = this.m_defMax;
        this.showIndices(true);
        this.showVertices(true);
        this.setGlobalVertexSize(0.0);
        this.setGlobalPolygonSize(1.0);
        this.setEnabledIndexLabels(false);
        this.showPolygons(true);
        this.setGlobalPolygonColor(this.m_defhMajorColor);
        this.showPolygonColors(true);
        this.assurePolygonColors();
        this.computeHashings();
    }

    public void setEndPoint(PdVector pdVector, PdVector pdVector2) {
        this.m_v.sub(pdVector, this.m_origin);
        this.setDirection(this.m_v);
        this.m_minMax.setEntry(0, 0.0);
        this.m_minMax.setEntry(1, PdVector.dist(pdVector, this.m_origin));
        if (pdVector.getSize() == 3) {
            this.m_n.cross(pdVector2, this.m_v);
            this.setNormal(this.m_n);
            return;
        }
        if (Math.abs(this.m_v.m_data[1]) < 0.001) {
            this.setNormal(this.m_v.m_data[2], 0.0, this.m_v.m_data[0]);
            return;
        }
        if (Math.abs(this.m_v.m_data[0]) < 0.001) {
            this.setNormal(0.0, -this.m_v.m_data[2], this.m_v.m_data[1]);
            return;
        }
        if (Math.abs(this.m_v.m_data[2]) < 0.001) {
            this.setNormal(-this.m_v.m_data[1], this.m_v.m_data[0], 0.0);
            return;
        }
        this.setNormal(0.0, 0.0, 1.0);
    }

    protected static int hashInterval(int n, double[] dArray, double d, double d2, boolean bl, double d3, boolean bl2) {
        double d4 = d * 1.0E-8;
        double d5 = 1.0E-6;
        double d6 = bl ? d * Math.ceil(d2 / d) : d * Math.floor((d2 + d) / d);
        double d7 = bl2 ? d * Math.floor(d3 / d) : d * Math.ceil((d3 - d) / d);
        double d8 = d6;
        while (d8 < d7 + d4 && n < dArray.length) {
            dArray[n] = (float)(d8 + d4);
            if (dArray[n] > -d5 && dArray[n] < d5) {
                dArray[n] = 0.0;
            }
            ++n;
            d8 += d;
        }
        return n;
    }

    protected int partitionInterval(int n, double[] dArray, int n2, double d, boolean bl, double d2, boolean bl2) {
        double d3 = 1.0E-7;
        double d4 = (d2 - d) / (double)(n2 + 1);
        if (!bl) {
            d += d4;
        }
        if (!bl2) {
            d2 -= d4;
        }
        double d5 = d;
        while (d5 <= d2 + d3 && n < dArray.length) {
            dArray[n++] = (float)(d5 + d3);
            d5 += d4;
        }
        return n;
    }

    public void setGlobalPolygonColor(Color color) {
        super.setGlobalPolygonColor(color);
        this.m_majorHashExtentColor = color;
        this.m_minorHashExtentColor = PdColor.brighter(color);
        this.m_defhMajorColor = color;
        this.m_defhMinorColor = PdColor.brighter(color);
        this.m_edgeColor.setColor(color);
    }

    public void setHashLabel(int n, int n2, int n3, int n4) {
        this.setLabelAttribute(0, n, n2, n3, n4, 0);
    }

    public void setDirection(PdVector pdVector) {
        this.m_v.copyArray(pdVector);
        this.m_v.normalize();
        if (this.m_dim > 2) {
            this.m_u.cross(this.m_v, this.m_n);
        }
    }

    public void setDirection(double d, double d2, double d3) {
        this.m_v.set(d, d2, d3);
        this.m_v.normalize();
        if (this.m_dim > 2) {
            this.m_u.cross(this.m_v, this.m_n);
        }
    }

    public void setMajorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_majorHashExtent[0] = d;
            this.m_majorHashExtent[1] = d2;
            return;
        }
        if (n == 1) {
            this.m_majorHashExtent[2] = d;
            this.m_majorHashExtent[3] = d2;
        }
    }

    public double getMajorUnit() {
        return this.m_majorHashUnits.getValue();
    }

    public void setNameAlignment(int n, int n2, int n3, int n4) {
        this.m_rulerNamePos = n;
        this.setLabelAttribute(2, n3, n4, n2, 2, 3);
    }

    public boolean isEnabledAutoHashing() {
        return this.m_bAutoHashing;
    }

    protected void resetVertices() {
        int n = 0;
        while (n < this.m_maxNumVertices) {
            if (this.m_vertex[n] != null) {
                this.m_vertex[n].setName("");
            }
            ++n;
        }
        n = 0;
        while (n < this.m_maxNumPolygons) {
            if (this.m_polygon[n] != null) {
                this.m_polygon[n].setName("");
            }
            ++n;
        }
    }

    public int getNumMajorPartitions() {
        return this.m_numMajorHashings.getValue();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_minorHashUnits || object == this.m_majorHashUnits) {
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            int n = new Double(2.0 * this.m_minMax.getEntry(1)).intValue();
            this.m_numMajorHashings.setBounds(0, n);
            this.m_numMinorHashings.setBounds(0, n);
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_bndMin || object == this.m_bndMax) {
            return this.update(this);
        }
        if (object == this.m_edgeColor) {
            this.setGlobalPolygonColor(this.m_edgeColor.getColor());
            return this.update(this);
        }
        if (object == this.m_edgeSize) {
            this.setGlobalPolygonSize(this.m_edgeSize.getValue());
            return this.update(this);
        }
        return super.update(object);
    }

    public boolean isShowingHashingsInNormalDir() {
        return this.m_bHashInNormalDir;
    }

    public boolean isShowingHashingsInUpDir() {
        return this.m_bHashInUpDir;
    }

    public void showHashingsInNormalDir(boolean bl) {
        this.m_bHashInNormalDir = bl;
    }

    public void showHashingsInUpDir(boolean bl) {
        this.m_bHashInUpDir = bl;
    }

    public double getMinParameter() {
        return this.m_minMax.getEntry(0);
    }

    public boolean isEnabledAutoBounds() {
        return this.m_bAutoBounds;
    }

    public boolean isShowingMajorHashings() {
        return this.m_bMajorMode;
    }

    public void showMajorHashings(boolean bl) {
        this.m_bMajorMode = bl;
    }

    public PgRuler() {
        this(3);
    }

    public PgRuler(int n) {
        super(n);
        this.setTag(7);
        this.setState(151, true);
        this.setLabelAttribute(0, 0, 0, 0, 0, 3);
        Font font = PsConfig.getFont(3);
        this.setLabelSize(0, font.getSize());
        this.setLabelStyle(0, font.getStyle());
        this.m_origin = new PdVector(n);
        this.m_normalOffset = new PdVector(n);
        this.m_upOffset = new PdVector(n);
        this.m_minMax = new PdVector(2);
        this.m_bShowArrow = false;
        this.m_hashBase = new PdVector(n);
        this.m_hashTip = new PdVector(n);
        this.m_hashOrigin = new PdVector(n);
        this.m_v = new PdVector(3);
        this.m_v.setEntry(0, 1.0);
        this.m_n = new PdVector(3);
        this.m_n.setEntry(1, 1.0);
        if (n > 2) {
            this.m_u = new PdVector(3);
            this.m_u.setEntry(2, 1.0);
        }
        this.m_ratio = 1.0;
        this.m_bndMin = new PuDouble(PsConfig.getMessage(true, 24000, "Min"), this);
        this.m_bndMax = new PuDouble(PsConfig.getMessage(true, 24000, "Max"), this);
        this.m_edgeColor = new PdColor("Color", this);
        this.m_edgeSize = new PuDouble("Thickness", this);
        this.m_minorHashExtent = new double[4];
        this.m_majorHashExtent = new double[4];
        this.m_majorHashing = new double[1000];
        this.m_minorHashing = new double[1000];
        this.m_majorHashUnits = new PuDouble(PsConfig.getMessage(24191), this);
        this.m_minorHashUnits = new PuDouble(PsConfig.getMessage(24192), this);
        this.m_numMajorHashings = new PuInteger(PsConfig.getMessage(24193), this);
        this.m_numMinorHashings = new PuInteger(PsConfig.getMessage(24194), this);
        this.m_rulerNamePos = 1;
        this.init();
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2) {
        this(3);
        this.setDirection(pdVector);
        this.setNormal(pdVector2);
        this.m_u.cross(this.m_v, this.m_n);
    }

    public double getMinorUnit() {
        return this.m_minorHashUnits.getValue();
    }

    public int getHashMode() {
        return this.m_hashMode;
    }

    public void setHashMode(int n) {
        this.m_hashMode = n;
    }

    public int getMode() {
        return this.getHashMode();
    }

    public void setMode(int n) {
        this.setHashMode(n);
    }

    public void setMinorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_minorHashExtent[0] = d;
            this.m_minorHashExtent[1] = d2;
        }
        if (n == 1) {
            this.m_minorHashExtent[2] = d;
            this.m_minorHashExtent[3] = d2;
        }
    }

    public boolean isShowingArrow() {
        return this.m_bShowArrow;
    }

    public void showArrow(boolean bl) {
        this.m_bShowArrow = bl;
    }

    public void setNormal(double d, double d2, double d3) {
        this.m_n.set(d, d2, d3);
        this.m_n.normalize();
        if (this.m_dim > 2) {
            this.m_u.cross(this.m_v, this.m_n);
        }
    }

    public void setNormal(PdVector pdVector) {
        this.m_n.copyArray(pdVector);
        this.m_n.normalize();
        if (this.m_dim > 2) {
            this.m_u.cross(this.m_v, this.m_n);
        }
    }

    public void setFixedHashing(double d, double d2) {
        if (d >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(Math.min(d / 10.0, 0.1), 2.0 * d);
        }
        if (d2 >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(Math.min(d2 / 10.0, 0.01), 2.0 * d);
        }
        this.m_majorHashUnits.setValue(d);
        this.m_majorHashUnits.setLineIncr(d / 50.0);
        this.m_majorHashUnits.setPageIncr(d / 10.0);
        this.m_majorHashUnits.updatePanels(this.m_majorHashUnits);
        this.m_minorHashUnits.setValue(d2);
        this.m_minorHashUnits.setLineIncr(d2 / 50.0);
        this.m_minorHashUnits.setPageIncr(d2 / 10.0);
        this.m_minorHashUnits.updatePanels(this.m_minorHashUnits);
    }

    public boolean isShowingFixedMode() {
        return this.m_hashMode == 0;
    }

    public void showFixedMode(boolean bl) {
        if (bl) {
            this.setHashMode(0);
            return;
        }
        this.setHashMode(1);
    }

    public int getNumMinorPartitions() {
        return this.m_numMinorHashings.getValue();
    }

    public void setGlobalPolygonSize(double d) {
        super.setGlobalPolygonSize(d);
        this.m_edgeSize.setValue(d);
    }

    public void setDefaultHashSizes(int n) {
        if (n == 0) {
            this.m_majorHashExtent[0] = 0.0;
            this.m_majorHashExtent[1] = this.m_defhMajor;
            this.m_minorHashExtent[0] = 0.0;
            this.m_minorHashExtent[1] = this.m_defhMinor;
            this.m_bHashInNormalDir = true;
            this.m_bHashInUpDir = false;
            return;
        }
        if (n == 1) {
            this.m_majorHashExtent[2] = 0.0;
            this.m_majorHashExtent[3] = this.m_defhMajor;
            this.m_minorHashExtent[2] = 0.0;
            this.m_minorHashExtent[3] = this.m_defhMinor;
            this.m_bHashInNormalDir = false;
            this.m_bHashInUpDir = true;
        }
    }
}

