/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;

public final class PsJavaView
extends PsObject {
    protected static final int m_numFiles = 6;
    public static final int FILE_CODEBASE = 0;
    public static final int FILE_LICENSE = 1;
    public static final int FILE_RESOURCE = 2;
    public static final int FILE_WORKING = 3;
    public static final int FILE_GEOMETRY = 4;
    public static final int FILE_IMAGE = 5;
    public static final int MONITOR_UXGA = 0;
    public static final int MONITOR_SXGA = 1;
    public static final int MONITOR_XGA = 2;
    public static final int MONITOR_SVGA = 3;
    public static final int MONITOR_VGA = 4;
    public static final int MONITOR_QVGA = 5;
    public static final int MONITOR_USER = 6;
    protected static int[][] m_monitorSize = new int[][]{{1600, 1200}, {1280, 1024}, {1024, 768}, {800, 600}, {640, 480}, {320, 240}, {320, 240}};
    protected static int[][] m_controlSize;
    protected static int[][] m_aboutSize;
    protected static int[][] m_helpSize;
    protected static int[][] m_consoleSize;
    protected static int[][] m_animationSize;
    protected static int[][] m_newProjectSize;
    protected static int[][] m_importModelSize;
    protected static int[][] m_exportBounds;
    public static final int MONITOR = 0;
    public static final int WINDOW_CONTROL = 1;
    public static final int WINDOW_ABOUT = 2;
    public static final int WINDOW_HELP = 3;
    public static final int WINDOW_CONSOLE = 4;
    public static final int WINDOW_ANIMATION = 5;
    public static final int WINDOW_NEW_PROJECT = 6;
    public static final int WINDOW_IMPORT_MODEL = 7;
    public static final int WINDOW_EXPORT_MODEL = 8;
    public static String m_codeBaseDir;
    public static String m_workingDir;
    protected static String m_recentLicDir;
    protected static String m_recentRsrcDir;
    protected static String m_recentGeomDir;
    protected static String m_recentImgDir;
    protected static String m_recentLicFile;
    protected static String m_recentRsrcFile;
    protected static String m_recentGeomFile;
    protected static String m_recentImgFile;
    protected static boolean m_bWorkshopBackup;
    public static boolean m_bAutoIdentify;
    public static boolean m_bAutoNeighbour;
    public static boolean m_bAutoNormals;
    public static boolean m_bInstanceSharing;
    public static boolean m_bOnlyVertices;
    public static boolean m_bFilterVertices;
    public static boolean m_bFastDisplay;
    protected static String m_version;
    protected static String m_versionType;
    protected static PsAuthorInfo m_authorInfo;
    public static int m_monitorType;
    public static String m_monitorMouse;
    public static String m_viewerScreen;
    public static String m_viewerVisible;
    public static String m_controlVisible;
    public static String m_consoleVisible;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static /* synthetic */ Class class$jv$rsrc$PsJavaView;

    public static void setFileName(int n, String string) {
        switch (n) {
            case 1: {
                m_recentLicFile = string;
                return;
            }
            case 2: {
                m_recentRsrcFile = string;
                return;
            }
            case 4: {
                m_recentGeomFile = string;
                return;
            }
            case 5: {
                m_recentImgFile = string;
                return;
            }
        }
    }

    public static int[] getWindowSize(int n) {
        int[] nArray;
        switch (n) {
            case 0: {
                nArray = m_monitorSize[m_monitorType];
                break;
            }
            case 1: {
                nArray = m_controlSize[m_monitorType];
                break;
            }
            case 2: {
                nArray = m_aboutSize[m_monitorType];
                break;
            }
            case 3: {
                nArray = m_helpSize[m_monitorType];
                break;
            }
            case 4: {
                nArray = m_consoleSize[m_monitorType];
                break;
            }
            case 5: {
                nArray = m_animationSize[m_monitorType];
                break;
            }
            case 6: {
                nArray = m_newProjectSize[m_monitorType];
                break;
            }
            case 7: {
                nArray = m_importModelSize[m_monitorType];
                break;
            }
            case 8: {
                nArray = m_exportBounds[m_monitorType];
                break;
            }
            default: {
                PsDebug.warning("unknown window identifier = " + n);
                Object var1_2 = null;
                return null;
            }
        }
        int[] nArray2 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        return nArray2;
    }

    public static void setEnabledWorkshopBackup(boolean bl) {
        m_bWorkshopBackup = bl;
    }

    public PsJavaView() {
        this.setName("Preference Settings");
        String string = PsConfig.getCodeBase();
        PsJavaView.setDirectory(0, string);
        PsJavaView.setFileName(2, "jv-rsrc.jvr");
        PsJavaView.setFileName(1, "jv-lic.lic");
        String string2 = PsConfig.getUserBase();
        PsJavaView.setDirectory(3, string2);
        PsJavaView.setFileName(4, "geom.jvx");
        PsJavaView.setFileName(5, "image.jpg");
        m_authorInfo = new PsAuthorInfo();
        if (this.getClass() == (class$jv$rsrc$PsJavaView != null ? class$jv$rsrc$PsJavaView : (class$jv$rsrc$PsJavaView = PsJavaView.class$("jv.rsrc.PsJavaView")))) {
            this.init();
        }
    }

    public static String getDirectory(int n) {
        switch (n) {
            case 0: {
                return m_codeBaseDir;
            }
            case 2: {
                return m_recentRsrcDir;
            }
            case 1: {
                return m_recentLicDir;
            }
            case 3: {
                return m_workingDir;
            }
            case 4: {
                return m_recentGeomDir;
            }
            case 5: {
                return m_recentImgDir;
            }
        }
        return null;
    }

    public static void setDirectory(int n, String string) {
        if (string == null) {
            return;
        }
        string = PsUtil.assureFileSeparator(string, true);
        switch (n) {
            case 0: {
                m_codeBaseDir = string;
                m_recentRsrcDir = m_codeBaseDir + "rsrc" + PsConfig.getFileSeparator();
                m_recentLicDir = m_codeBaseDir + "rsrc" + PsConfig.getFileSeparator();
                return;
            }
            case 1: {
                m_recentLicDir = string;
                return;
            }
            case 2: {
                m_recentRsrcDir = string;
                return;
            }
            case 3: {
                m_workingDir = string;
                m_recentGeomDir = m_workingDir + "models" + PsConfig.getFileSeparator();
                m_recentImgDir = m_workingDir + "images" + PsConfig.getFileSeparator();
                return;
            }
            case 4: {
                m_recentGeomDir = string;
                return;
            }
            case 5: {
                m_recentImgDir = string;
                return;
            }
        }
    }

    public boolean read(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("could not read rsrc file = " + string);
            return false;
        }
        this.setXml(psXmlSrc);
        return true;
    }

    private static boolean parseFont(int n, PsXmlNode psXmlNode) {
        int n2;
        String string = psXmlNode.getContent();
        if (string == null) {
            PsDebug.warning("missing font type");
            return false;
        }
        if (string.equalsIgnoreCase("text")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("fixed")) {
            n2 = 1;
        } else if (string.equalsIgnoreCase("menu")) {
            n2 = 2;
        } else if (string.equalsIgnoreCase("header2")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("header4")) {
            n2 = 4;
        } else {
            PsDebug.warning("invalid font type");
            return false;
        }
        String string2 = psXmlNode.getAttribute("name");
        if (PuString.isEmpty(string2)) {
            string2 = null;
        }
        int n3 = -1;
        String string3 = psXmlNode.getAttribute("style");
        if (string3 != null) {
            if (string3.equalsIgnoreCase("bold")) {
                n3 = 1;
            } else if (string3.equalsIgnoreCase("plain")) {
                n3 = 0;
            } else if (string3.equalsIgnoreCase("italic")) {
                n3 = 2;
            } else if (string3.equalsIgnoreCase("")) {
                n3 = -1;
            } else {
                PsDebug.warning("invalid font style = " + string3);
                return false;
            }
        }
        int n4 = -1;
        String string4 = psXmlNode.getAttribute("size");
        if (string4 != null) {
            if (string4.length() == 0) {
                n4 = -1;
            } else {
                try {
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("invalid font size = " + string4);
                    return false;
                }
            }
        }
        PsConfig.setFont(n, n2, string2, n3, n4);
        return true;
    }

    public PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("jv-rsrc");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-rsrc.dtd");
        PsXmlNode psXmlNode = new PsXmlNode("jv-rsrc");
        psXmlSrc.setRootNode(psXmlNode);
        PsXmlNode psXmlNode2 = psXmlNode.addChild("meta");
        psXmlNode2.addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        int[] nArray = PsConfig.getVersion(13);
        String string = String.valueOf(nArray[0]) + ".";
        if (nArray[1] < 10) {
            string = string + "0";
        }
        string = string + String.valueOf(nArray[1]);
        if (nArray[2] != 0) {
            string = string + ".";
            if (nArray[2] < 10) {
                string = string + "00";
            } else if (nArray[2] < 100) {
                string = string + "0";
            }
            string = string + String.valueOf(nArray[2]);
        }
        psXmlNode2.addAttribute("dtd", string);
        psXmlNode2.addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode3 = psXmlNode.addChild("version", m_version);
        psXmlNode3.addAttribute("type", m_versionType);
        psXmlNode.addChild("title", this.getName());
        if (m_authorInfo != null && m_authorInfo.getNumAuthors() > 0) {
            psXmlNode.addChild(m_authorInfo.getXmlNode());
        }
        PsXmlNode psXmlNode4 = psXmlNode.addChild("preferences");
        PsXmlNode psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(3));
        psXmlNode5.addAttribute("type", "working");
        PsXmlNode psXmlNode6 = psXmlNode4.addChild("workshop");
        String string2 = m_bWorkshopBackup ? "enabled" : "disabled";
        psXmlNode6.addAttribute("backup", string2);
        return psXmlSrc;
    }

    public static boolean isEnabledWorkshopBackup() {
        return m_bWorkshopBackup;
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        Object object;
        PsXmlNode psXmlNode;
        Object object2;
        Object object3;
        PsXmlNode psXmlNode2;
        PsXmlNode psXmlNode3;
        String string;
        if (psXmlSrc == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        PsXmlNode psXmlNode4 = psXmlSrc.getRootNode();
        if (psXmlNode4 == null) {
            PsDebug.warning("missing root node.");
            return;
        }
        if (psXmlNode4.getType() == null || !psXmlNode4.getType().equalsIgnoreCase("jv-rsrc")) {
            PsDebug.warning("missing <jv-rsrc> element,\nthis is not a valid JavaView resource file.");
            return;
        }
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode4, "version");
        if (psXmlNode5 != null) {
            m_version = psXmlNode5.getContent();
            m_versionType = psXmlNode5.getAttribute("type");
        }
        if ((string = PsXmlSrc.getRsrc(psXmlNode4, "title")) != null) {
            this.setName(string);
        }
        if ((psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode4, "authors")) != null) {
            m_authorInfo.setXmlNode(psXmlNode3);
        }
        if ((psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode4, "preferences")) != null) {
            object3 = psXmlNode2.getChildren("directory");
            if (object3 != null && ((PsXmlNode[])object3).length > 0) {
                int n = 0;
                while (n < ((PsXmlNode[])object3).length) {
                    object2 = object3[n].getAttribute("type");
                    if (object2 != null && ((String)object2).equalsIgnoreCase("working")) {
                        PsJavaView.setDirectory(3, object3[n].getContent());
                    }
                    ++n;
                }
            }
            if ((psXmlNode = psXmlNode2.getChild("display")) != null) {
                m_bFastDisplay = PsJavaView.parseEnabled(psXmlNode.getAttribute("fastDisplay")) == 1;
                boolean bl = m_bInstanceSharing = PsJavaView.parseEnabled(psXmlNode.getAttribute("instanceSharing")) == 1;
            }
            if ((object2 = psXmlNode2.getChild("loader")) != null) {
                m_bAutoIdentify = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoIdentify")) != 0;
                m_bAutoNeighbour = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoNeighbour")) != 0;
                boolean bl = m_bAutoNormals = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoNormals")) != 0;
            }
            if ((object = psXmlNode2.getChild("workshop")) != null) {
                boolean bl = m_bWorkshopBackup = PsJavaView.parseEnabled(((PsXmlNode)object).getAttribute("backup")) != 0;
            }
        }
        if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode4, "windows")) != null) {
            PsXmlNode psXmlNode6;
            PsXmlNode psXmlNode7;
            psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "monitor");
            if (psXmlNode != null) {
                object2 = psXmlNode.getAttribute("size");
                if (object2 != null) {
                    m_monitorType = ((String)object2).startsWith("1600") ? 0 : (((String)object2).startsWith("1280") ? 1 : (((String)object2).startsWith("1024") ? 2 : (((String)object2).startsWith("800") ? 3 : (((String)object2).startsWith("640") ? 4 : (((String)object2).startsWith("320") ? 5 : 6)))));
                }
                if ((object = psXmlNode.getAttribute("mouse")) != null) {
                    m_monitorMouse = object;
                }
            }
            if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "viewer")) != null) {
                m_viewerScreen = ((PsXmlNode)object2).getAttribute("show");
                m_viewerVisible = ((PsXmlNode)object2).getAttribute("visible");
            }
            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "control")) != null) {
                m_controlVisible = ((PsXmlNode)object).getAttribute("visible");
            }
            if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "console")) != null) {
                m_consoleVisible = psXmlNode7.getAttribute("visible");
            }
            if ((psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "fonts")) != null) {
                PsXmlNode psXmlNode8;
                PsXmlNode psXmlNode9;
                PsXmlNode psXmlNode10;
                PsXmlNode psXmlNode11;
                int n;
                PsXmlNode[] psXmlNodeArray = psXmlNode6.getChildren("font");
                if (psXmlNodeArray != null) {
                    n = 0;
                    while (n < psXmlNodeArray.length) {
                        PsJavaView.parseFont(PsConfig.getOSId(), psXmlNodeArray[n]);
                        ++n;
                    }
                }
                if ((psXmlNode11 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_oswin")) != null && (psXmlNodeArray = psXmlNode11.getChildren("font")) != null) {
                    n = 0;
                    while (n < psXmlNodeArray.length) {
                        PsJavaView.parseFont(0, psXmlNodeArray[n]);
                        ++n;
                    }
                }
                if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_osirix")) != null && (psXmlNodeArray = psXmlNode10.getChildren("font")) != null) {
                    n = 0;
                    while (n < psXmlNodeArray.length) {
                        PsJavaView.parseFont(1, psXmlNodeArray[n]);
                        ++n;
                    }
                }
                if ((psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_ossolaris")) != null && (psXmlNodeArray = psXmlNode9.getChildren("font")) != null) {
                    n = 0;
                    while (n < psXmlNodeArray.length) {
                        PsJavaView.parseFont(2, psXmlNodeArray[n]);
                        ++n;
                    }
                }
                if ((psXmlNode8 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_oslinux")) != null && (psXmlNodeArray = psXmlNode8.getChildren("font")) != null) {
                    n = 0;
                    while (n < psXmlNodeArray.length) {
                        PsJavaView.parseFont(3, psXmlNodeArray[n]);
                        ++n;
                    }
                }
            }
        }
    }

    public boolean write(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.getXml();
        if (psXmlSrc == null) {
            return true;
        }
        PrintWriter printWriter = PsUtil.writeFile(string);
        if (printWriter == null) {
            PsDebug.warning("could not write to file = " + string);
            return false;
        }
        boolean bl = false;
        try {
            bl = PsXmlSrc.write(printWriter, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("could not write rsrc file = " + string);
        }
        printWriter.close();
        if (!bl) {
            PsDebug.warning("error during export.");
        }
        return bl;
    }

    protected static int parseEnabled(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("enabled")) {
            return 1;
        }
        return 0;
    }

    static {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[]{5, 5, 370, 730};
        nArrayArray[1] = new int[]{5, 5, 370, 730};
        nArrayArray[2] = new int[]{5, 5, 370, 730};
        int[] nArray = new int[4];
        nArray[2] = 320;
        nArray[3] = 600;
        nArrayArray[3] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 250;
        nArray2[3] = 480;
        nArrayArray[4] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[2] = 250;
        nArray3[3] = 240;
        nArrayArray[5] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[2] = 250;
        nArray4[3] = 240;
        nArrayArray[6] = nArray4;
        m_controlSize = nArrayArray;
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[]{10, 10, 400, 450};
        nArrayArray2[1] = new int[]{10, 10, 400, 450};
        nArrayArray2[2] = new int[]{10, 10, 400, 450};
        int[] nArray5 = new int[4];
        nArray5[2] = 400;
        nArray5[3] = 450;
        nArrayArray2[3] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[2] = 400;
        nArray6[3] = 450;
        nArrayArray2[4] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[2] = 320;
        nArray7[3] = 240;
        nArrayArray2[5] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[2] = 320;
        nArray8[3] = 240;
        nArrayArray2[6] = nArray8;
        m_aboutSize = nArrayArray2;
        int[][] nArrayArray3 = new int[7][];
        nArrayArray3[0] = new int[]{10, 10, 400, 550};
        nArrayArray3[1] = new int[]{10, 10, 400, 550};
        nArrayArray3[2] = new int[]{10, 10, 400, 550};
        int[] nArray9 = new int[4];
        nArray9[2] = 400;
        nArray9[3] = 550;
        nArrayArray3[3] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[2] = 400;
        nArray10[3] = 480;
        nArrayArray3[4] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[2] = 320;
        nArray11[3] = 240;
        nArrayArray3[5] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[2] = 320;
        nArray12[3] = 240;
        nArrayArray3[6] = nArray12;
        m_helpSize = nArrayArray3;
        int[][] nArrayArray4 = new int[7][];
        nArrayArray4[0] = new int[]{10, 10, 500, 350};
        nArrayArray4[1] = new int[]{10, 10, 500, 350};
        nArrayArray4[2] = new int[]{10, 10, 500, 350};
        int[] nArray13 = new int[4];
        nArray13[2] = 500;
        nArray13[3] = 350;
        nArrayArray4[3] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[2] = 500;
        nArray14[3] = 350;
        nArrayArray4[4] = nArray14;
        int[] nArray15 = new int[4];
        nArray15[2] = 320;
        nArray15[3] = 240;
        nArrayArray4[5] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[2] = 320;
        nArray16[3] = 240;
        nArrayArray4[6] = nArray16;
        m_consoleSize = nArrayArray4;
        int[][] nArrayArray5 = new int[7][];
        nArrayArray5[0] = new int[]{10, 10, 400, 300};
        nArrayArray5[1] = new int[]{10, 10, 400, 300};
        nArrayArray5[2] = new int[]{10, 10, 400, 300};
        int[] nArray17 = new int[4];
        nArray17[2] = 400;
        nArray17[3] = 300;
        nArrayArray5[3] = nArray17;
        int[] nArray18 = new int[4];
        nArray18[2] = 400;
        nArray18[3] = 300;
        nArrayArray5[4] = nArray18;
        int[] nArray19 = new int[4];
        nArray19[2] = 320;
        nArray19[3] = 240;
        nArrayArray5[5] = nArray19;
        int[] nArray20 = new int[4];
        nArray20[2] = 320;
        nArray20[3] = 240;
        nArrayArray5[6] = nArray20;
        m_animationSize = nArrayArray5;
        int[][] nArrayArray6 = new int[7][];
        nArrayArray6[0] = new int[]{10, 10, 400, 400};
        nArrayArray6[1] = new int[]{10, 10, 400, 400};
        nArrayArray6[2] = new int[]{10, 10, 400, 400};
        int[] nArray21 = new int[4];
        nArray21[2] = 400;
        nArray21[3] = 400;
        nArrayArray6[3] = nArray21;
        int[] nArray22 = new int[4];
        nArray22[2] = 400;
        nArray22[3] = 400;
        nArrayArray6[4] = nArray22;
        int[] nArray23 = new int[4];
        nArray23[2] = 320;
        nArray23[3] = 240;
        nArrayArray6[5] = nArray23;
        int[] nArray24 = new int[4];
        nArray24[2] = 320;
        nArray24[3] = 240;
        nArrayArray6[6] = nArray24;
        m_newProjectSize = nArrayArray6;
        int[][] nArrayArray7 = new int[7][];
        nArrayArray7[0] = new int[]{10, 10, 400, 450};
        nArrayArray7[1] = new int[]{10, 10, 400, 450};
        nArrayArray7[2] = new int[]{10, 10, 400, 450};
        int[] nArray25 = new int[4];
        nArray25[2] = 400;
        nArray25[3] = 450;
        nArrayArray7[3] = nArray25;
        int[] nArray26 = new int[4];
        nArray26[2] = 400;
        nArray26[3] = 450;
        nArrayArray7[4] = nArray26;
        int[] nArray27 = new int[4];
        nArray27[2] = 320;
        nArray27[3] = 240;
        nArrayArray7[5] = nArray27;
        int[] nArray28 = new int[4];
        nArray28[2] = 320;
        nArray28[3] = 240;
        nArrayArray7[6] = nArray28;
        m_importModelSize = nArrayArray7;
        int[][] nArrayArray8 = new int[7][];
        nArrayArray8[0] = new int[]{10, 10, 400, 600};
        nArrayArray8[1] = new int[]{10, 10, 400, 600};
        nArrayArray8[2] = new int[]{10, 10, 400, 600};
        int[] nArray29 = new int[4];
        nArray29[2] = 400;
        nArray29[3] = 600;
        nArrayArray8[3] = nArray29;
        int[] nArray30 = new int[4];
        nArray30[2] = 400;
        nArray30[3] = 480;
        nArrayArray8[4] = nArray30;
        int[] nArray31 = new int[4];
        nArray31[2] = 320;
        nArray31[3] = 240;
        nArrayArray8[5] = nArray31;
        int[] nArray32 = new int[4];
        nArray32[2] = 320;
        nArray32[3] = 240;
        nArrayArray8[6] = nArray32;
        m_exportBounds = nArrayArray8;
        m_bWorkshopBackup = true;
        m_bAutoIdentify = true;
        m_bAutoNeighbour = true;
        m_bAutoNormals = true;
        m_bInstanceSharing = false;
        m_bOnlyVertices = false;
        m_bFilterVertices = false;
        m_bFastDisplay = false;
        m_version = "0.99.007";
        m_versionType = "beta";
        m_monitorType = 1;
        m_viewerScreen = "multiple";
        m_viewerVisible = "show";
        m_controlVisible = "hide";
        m_consoleVisible = "hide";
    }

    public static PsAuthorInfo getAuthorInfo() {
        return m_authorInfo;
    }

    public static void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        if (psAuthorInfo == null) {
            m_authorInfo.init();
            return;
        }
        m_authorInfo.copy(psAuthorInfo);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String getFullFileName(int n) {
        String string;
        String string2 = "";
        String string3 = PsJavaView.getDirectory(n);
        if (string3 != null) {
            string2 = string2 + string3;
        }
        if ((string = PsJavaView.getFileName(n)) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    public static void setFullFileName(int n, String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return;
        }
        String string2 = PsUtil.getFilePath(string);
        if (string2 == null) {
            PsDebug.warning("missing directory in fullFileName = " + string);
            return;
        }
        PsJavaView.setDirectory(n, string2);
        String string3 = PsUtil.getFileName(string);
        if (string3 == null) {
            PsDebug.warning("missing directory in fullFileName = " + string);
            return;
        }
        PsJavaView.setFileName(n, string3);
    }

    public static String getFileName(int n) {
        switch (n) {
            case 1: {
                return m_recentLicFile;
            }
            case 2: {
                return m_recentRsrcFile;
            }
            case 4: {
                return m_recentGeomFile;
            }
            case 5: {
                return m_recentImgFile;
            }
        }
        return null;
    }
}

