/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsTabPanel;

class PsTabsHeader
extends Panel {
    protected Font normalFont;
    protected Font boldFont;
    protected FontMetrics fmBoldFont;
    protected static int selUpper = 2;
    protected static int lineWidth = 1;
    protected static int horRound = 1;
    protected static int verRound = 1;
    protected static int XTitle = 4;
    protected static int YTitle = 2;
    protected int X;
    protected int Y;
    protected int Z;
    protected String[] arrName;
    protected int[] arrEnd;
    protected int[] arrBeg;
    protected int selected = 0;
    protected int m_oldWidth = 0;
    protected int m_oldHeight = 0;
    protected int m_numTabs;
    protected int m_maxNumTabs = 9;
    protected PsTabPanel m_tabPanel;
    protected boolean m_modified = false;

    public Dimension minimumLayoutSize() {
        return this.getPreferredSize();
    }

    protected void addPanel(String string, Panel panel) {
        if (this.m_numTabs >= this.m_maxNumTabs) {
            PsDebug.warning("too many tabs, numTabs = " + this.m_numTabs);
            return;
        }
        int n = 0;
        while (n < this.m_numTabs) {
            if (this.arrName[n].equals(string)) {
                return;
            }
            ++n;
        }
        this.arrName[this.m_numTabs] = string;
        ++this.m_numTabs;
        this.m_modified = true;
    }

    PsTabsHeader(PsTabPanel psTabPanel) {
        this.addMouseListener(new PsTabsHeader_MA());
        this.m_tabPanel = psTabPanel;
        this.normalFont = PsConfig.getFont(0);
        this.boldFont = PsConfig.getFont(3);
        this.fmBoldFont = super.getFontMetrics(this.boldFont);
        this.Z = this.fmBoldFont.getHeight() + 9;
        this.arrName = new String[this.m_maxNumTabs];
        this.arrEnd = new int[this.m_maxNumTabs];
        this.arrBeg = new int[this.m_maxNumTabs];
        super.setLayout(null);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0 || this.m_numTabs == 0) {
            return;
        }
        if (dimension.width != this.m_oldWidth || dimension.height != this.m_oldHeight || this.m_modified) {
            this.m_modified = false;
            this.m_oldWidth = dimension.width;
            this.m_oldHeight = dimension.height;
            this.X = dimension.width;
            this.Y = dimension.height;
            n2 = dimension.width / this.m_numTabs;
            this.arrBeg[0] = 0;
            this.arrEnd[0] = n2 + 2;
            n = 1;
            while (n < this.m_numTabs) {
                this.arrBeg[n] = this.arrEnd[n - 1];
                this.arrEnd[n] = this.arrBeg[n] + n2;
                ++n;
            }
        }
        graphics.setColor(super.getBackground());
        graphics.fillRect(0, 0, this.X, this.Z + 1);
        int n3 = 0;
        while (n3 < this.m_numTabs) {
            if (n3 == this.selected) {
                graphics.setFont(this.boldFont);
                n = 0;
            } else {
                graphics.setFont(this.normalFont);
                n = 2;
            }
            graphics.setColor(Color.darkGray);
            graphics.drawLine(this.arrEnd[n3] - 2, n + 2, this.arrEnd[n3] - 2, this.Z - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(this.arrEnd[n3] - 1, n + 2, this.arrEnd[n3] - 1, this.Z - 2);
            graphics.drawString(this.arrName[n3], this.arrBeg[n3] + 6, n + 4 + this.fmBoldFont.getAscent());
            graphics.setColor(Color.white);
            graphics.drawLine(this.arrBeg[n3], n + 2, this.arrBeg[n3], this.Z);
            graphics.drawLine(this.arrBeg[n3] + 1, n + 1, this.arrEnd[n3] - 3, n + 1);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.arrBeg[n3] + 1, n + 2, this.arrBeg[n3] + 1, this.Z);
            graphics.drawLine(this.arrBeg[n3] + 2, n + 2, this.arrEnd[n3] - 3, n + 2);
            ++n3;
        }
        graphics.setColor(Color.darkGray);
        n2 = 0;
        do {
            if (this.selected != 0) {
                graphics.drawLine(0, this.Z - 2 + n2, this.arrBeg[this.selected], this.Z - 2 + n2);
            }
            if (this.selected != this.m_numTabs - 1) {
                graphics.drawLine(this.arrEnd[this.selected], this.Z - 2 + n2, this.X, this.Z - 2 + n2);
            }
            graphics.setColor(Color.white);
        } while (++n2 < 2);
    }

    public String getCurrentPanel() {
        return this.arrName[this.selected];
    }

    protected void show(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_numTabs) {
            if (this.arrName[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0 || n > this.m_numTabs) {
            PsDebug.warning("panel not found = " + string);
            return;
        }
        int n3 = this.selected;
        this.arrBeg[n3] = this.arrBeg[n3] + 2;
        int n4 = this.selected;
        this.arrEnd[n4] = this.arrEnd[n4] - 2;
        int n5 = this.selected = n;
        this.arrBeg[n5] = this.arrBeg[n5] - 2;
        int n6 = this.selected;
        this.arrEnd[n6] = this.arrEnd[n6] + 2;
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getParent().getInsets();
        int n = 100;
        int n2 = this.Z;
        return new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + n2);
    }

    public void init() {
        this.m_numTabs = 0;
    }

    protected void removePanel(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_numTabs) {
            if (this.arrName[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        n2 = n;
        while (n2 < this.m_numTabs - 1) {
            this.arrName[n2] = this.arrName[n2 + 1];
            ++n2;
        }
        this.m_numTabs += -1;
        this.m_modified = true;
    }

    class PsTabsHeader_MA
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() >= PsTabsHeader.this.Z) {
                return;
            }
            int n = 0;
            while (n < PsTabsHeader.this.m_numTabs) {
                if (PsTabsHeader.this.arrBeg[n] < mouseEvent.getX() && mouseEvent.getX() < PsTabsHeader.this.arrEnd[n]) {
                    if (n == PsTabsHeader.this.selected) {
                        return;
                    }
                    int n2 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrBeg[n2] = PsTabsHeader.this.arrBeg[n2] + 2;
                    int n3 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrEnd[n3] = PsTabsHeader.this.arrEnd[n3] - 2;
                    PsTabsHeader.this.selected = n;
                    PsTabsHeader.this.m_tabPanel.showFromHeader(PsTabsHeader.this.arrName[PsTabsHeader.this.selected]);
                    int n4 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrBeg[n4] = PsTabsHeader.this.arrBeg[n4] - 2;
                    int n5 = PsTabsHeader.this.selected;
                    PsTabsHeader.this.arrEnd[n5] = PsTabsHeader.this.arrEnd[n5] + 2;
                    PsTabsHeader.this.paint(PsTabsHeader.this.getGraphics());
                    return;
                }
                ++n;
            }
        }

        PsTabsHeader_MA() {
            PsTabsHeader.this.getClass();
        }
    }
}

