/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class PsStackLayout
implements LayoutManager,
Serializable {
    public static final boolean VERTICAL = true;
    public static final boolean HORIZONTAL = false;
    private int m_gap;
    protected boolean m_bVertical;

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, false);
    }

    public PsStackLayout(int n) {
        this.m_gap = n;
        this.m_bVertical = true;
    }

    private Dimension computeLayoutSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        if (this.m_bVertical) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                Dimension dimension = component.getPreferredSize();
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
                if (n4 != 0) {
                    n3 += this.m_gap;
                }
                ++n4;
            }
            Insets insets = container.getInsets();
            return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            Component component = container.getComponent(n7);
            Dimension dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            n5 = Math.max(n5, dimension.height);
            n6 += dimension.width;
            if (n7 != 0) {
                n6 += this.m_gap;
            }
            ++n7;
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n6, insets.top + insets.bottom + n5);
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, true);
    }

    public void setType(boolean bl) {
        this.m_bVertical = bl;
    }

    public void layoutContainer(Container container) {
        int n;
        Dimension dimension;
        Component component;
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        if (this.m_bVertical) {
            int n3 = container.getSize().width - (insets.left + insets.right);
            int n4 = insets.top;
            int n5 = 0;
            while (n5 < n2) {
                Component component2 = container.getComponent(n5);
                Dimension dimension2 = component2.getPreferredSize();
                component2.setBounds(insets.left, n4, n3, dimension2.height);
                n4 += dimension2.height + this.m_gap;
                ++n5;
            }
            return;
        }
        int n6 = container.getSize().height - (insets.top + insets.bottom);
        int n7 = container.getSize().width - (insets.left + insets.right);
        int n8 = insets.left;
        int n9 = 0;
        while (n9 < n2 - 1) {
            component = container.getComponent(n9);
            dimension = component.getPreferredSize();
            n = insets.top + (n6 - dimension.height) >> 2;
            component.setBounds(n8, n, dimension.width, dimension.height);
            n8 += dimension.width + this.m_gap;
            ++n9;
        }
        component = container.getComponent(n2 - 1);
        dimension = component.getPreferredSize();
        n = insets.top + (n6 - dimension.height) >> 2;
        component.setBounds(n8, n, n7 - n8, dimension.height);
    }

    public void addLayoutComponent(String string, Component component) {
    }
}

