/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Font;
import java.awt.Frame;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsResource;
import jv.object.PsUtil;
import jv.object.PsViewerIf;

public final class PsConfig {
    protected static final String PROGRAM = "JavaView";
    protected static final String PROJECT = "Visual Geometry Pages";
    protected static final String VERSION = "3.95.000";
    protected static final String TOPIC = "release version";
    protected static final String COPYRIGHT = "\u00a9 1999-2005";
    public static final String[] AUTHOR = new String[]{"Konrad Polthier", "Klaus Hildebrandt", "Eike Preuss", "Ulrich Reitebuch"};
    public static String[] CONTRIBUTOR;
    public static final String HOMEPAGE = "www.javaview.de";
    public static final String EMAIL = "support@javaview.de";
    public static final String HELP_HTML = "jars/help.html";
    public static final String FONTS_HTML = "jars/systemFonts.html";
    public static final String JAVAVIEW_LOGO = "images/JavaViewLogo.gif";
    public static final int VERSION_DTD_JVX = 11;
    public static final int VERSION_DTD_JVD = 12;
    public static final int VERSION_DTD_JVR = 13;
    public static final int VERSION_DTD_JVF = 14;
    protected static final int[] m_versionDtdJvx;
    protected static final int[] m_versionDtdJvd;
    protected static final int[] m_versionDtdJvr;
    protected static Locale m_locale;
    protected static ResourceBundle[] m_messages;
    protected static String m_codeBase;
    protected static String m_userBase;
    protected static char m_fileSeparator;
    protected static boolean m_bStandAlone;
    protected static Applet m_applet;
    protected static Frame m_frame;
    protected static Frame m_dialogFrame;
    protected static boolean m_bIsInitialized;
    protected static PsViewerIf m_viewer;
    public static final int OS_WIN = 0;
    public static final int OS_IRIX = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_OTHER = 4;
    public static int m_osId;
    protected static String m_osName;
    protected static final int m_numFonts = 5;
    public static final int FONT_TEXT = 0;
    public static final int FONT_FIXED = 1;
    public static final int FONT_MENU = 2;
    public static final int FONT_HEADER2 = 3;
    public static final int FONT_HEADER4 = 4;
    protected static Font[] m_font;
    protected static String[][] m_fontName;
    protected static int[][] m_fontStyle;
    protected static int[][] m_fontSize;
    public static final int ARCHIVE_JV = 0;
    public static final int ARCHIVE_JVX = 1;
    public static final int ARCHIVE_VGP = 2;
    public static final int ARCHIVE_DEV = 3;
    public static final String[] ARCHIVE_NAME;
    public static final int NUM_OF_ARCHIVES = 4;
    public static final boolean JV_LITE = false;
    private static boolean[] m_bIsArchiveTested;
    private static boolean[] m_bHasArchive;
    public static final int NUM_OF_RESOURCES = 3;
    public static final String[] RESOURCE_NAME;

    public static String getHomepage() {
        return HOMEPAGE;
    }

    public static PsViewerIf getViewer() {
        return m_viewer;
    }

    public static void setApplication(boolean bl) {
        m_bStandAlone = bl;
    }

    public static int[] getVersion(int n) {
        switch (n) {
            case 12: {
                return m_versionDtdJvd;
            }
            case 13: {
                return m_versionDtdJvr;
            }
            case 11: {
                return m_versionDtdJvx;
            }
        }
        PsDebug.warning("unknown version id = " + n);
        return null;
    }

    public static String getMessage(int n) {
        return PsConfig.getMessage(Integer.toString(n));
    }

    public static String getMessage(boolean bl, int n, String string) {
        if (!bl) {
            return PsConfig.getMessage(string);
        }
        return string;
    }

    public static String getMessage(String string) {
        String string2 = null;
        if (m_messages != null) {
            int n = 0;
            do {
                if (m_messages[n] == null) continue;
                try {
                    string2 = m_messages[n].getString(string);
                }
                catch (Exception exception) {}
                if (string2 != null) break;
            } while (++n < 3);
        }
        if (string2 == null) {
            string2 = PsResource.getString(string);
        }
        return string2;
    }

    public static String getVersion() {
        int n = VERSION.lastIndexOf(".000");
        if (n == -1) {
            return VERSION;
        }
        return VERSION.substring(0, n);
    }

    public static String getImageLaunch() {
        return "images/jvLaunch.jpg";
    }

    public static String getCodeBase() {
        return m_codeBase;
    }

    public static void runGC() {
        PsConfig.runGC(1, 1);
    }

    public static void runGC(int n, int n2) {
        PsDebug.initTime();
        Runtime runtime = Runtime.getRuntime();
        try {
            int n3 = 0;
            while (n3 < n) {
                PsConfig._runGC(runtime, n2);
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void _runGC(Runtime runtime, int n) throws Exception {
        long l = runtime.totalMemory() - runtime.freeMemory();
        long l2 = Long.MAX_VALUE;
        int n2 = 0;
        while (l < l2 && n2 < n) {
            runtime.runFinalization();
            runtime.gc();
            Thread.yield();
            l2 = l;
            l = runtime.totalMemory() - runtime.freeMemory();
            ++n2;
        }
    }

    public static void setCodeBase(String string) {
        m_codeBase = string;
        if (m_codeBase == null) {
            PsDebug.message("codeBase = null", false);
            return;
        }
        if (m_codeBase.startsWith("file:")) {
            String string2 = "";
            int n = 0;
            int n2 = 0;
            while ((n2 = m_codeBase.indexOf("%20", n)) > n) {
                string2 = string2 + m_codeBase.substring(n, n2) + " ";
                n = n2 + 3;
            }
            if (n > 0 && n < m_codeBase.length()) {
                string2 = string2 + m_codeBase.substring(n, m_codeBase.length());
            }
            if (!"".equals(string2)) {
                m_codeBase = string2;
            }
        }
        if (!m_codeBase.endsWith(String.valueOf(m_fileSeparator))) {
            m_codeBase = m_codeBase + m_fileSeparator;
        }
        PsDebug.message("Assigned: codeBase = " + m_codeBase, false);
    }

    public static final boolean isDev() {
        return m_bHasArchive[3];
    }

    public static boolean hasArchive(int n) {
        if (n < 0 || n >= 4) {
            PsDebug.warning("Index of archive out of bounds, index = " + String.valueOf(n));
            return false;
        }
        if (m_bIsArchiveTested[n]) {
            return m_bHasArchive[n];
        }
        PsConfig.m_bIsArchiveTested[n] = true;
        String string = ARCHIVE_NAME[n] + ".rsrc.PsResource";
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("failed with exception, className = " + string + "\n\tException = " + exception.toString() + ", Message = " + exception.getMessage());
            return false;
        }
        PsConfig.m_bHasArchive[n] = clazz != null;
        return m_bHasArchive[n];
    }

    public static String getOSName() {
        return m_osName;
    }

    public static String getAuthors() {
        String string = AUTHOR[0];
        int n = 1;
        while (n < AUTHOR.length) {
            string = string + ", " + AUTHOR[n];
            ++n;
        }
        return string;
    }

    public static String getEmail() {
        return EMAIL;
    }

    public static int getOSId() {
        return m_osId;
    }

    public static String getProject() {
        return PROJECT;
    }

    public static String getTopic() {
        return TOPIC;
    }

    public static void reset() {
        m_applet = null;
        m_frame = null;
        m_dialogFrame = null;
        m_viewer = null;
        m_bIsInitialized = false;
    }

    public static String getProgram() {
        return PROGRAM;
    }

    public static String[] getContributors() {
        CONTRIBUTOR = new String[]{"Felix K\u00e4lberer <kaelberer@zib.de> " + PsConfig.getMessage(true, 12000, "JavaView installer for MS-Windows"), "Peter Liepa <pliepa@alias.com, http://brainjam.com> " + PsConfig.getMessage(12019), "Samy Khadem-Al-Charieh <khadem@math.tu-berlin.de> " + PsConfig.getMessage(12001), "Steve Dugaro <sdugaro@sfu.ca, www.cecm.sfu.ca> " + PsConfig.getMessage(12002) + ", " + PsConfig.getMessage(12003), "Axel Friedrich <friedrich_axel@gmx.de> " + PsConfig.getMessage(12004), "Tom Dudziak <tomdz@cs.tu-berlin.de> " + PsConfig.getMessage(12005), "Ernest Friedman-Hill / Sandia National Labs <ejfried@ca.sandia.gov> " + PsConfig.getMessage(12006), "Darius Bacon <djello@well.com> " + PsConfig.getMessage(12007), "Jef Poskanzer <jef@acme.com, www.acme.com/java> " + PsConfig.getMessage(12008) + ", " + PsConfig.getMessage(12009)};
        return CONTRIBUTOR;
    }

    public static Applet getApplet() {
        return m_applet;
    }

    public static Locale getLocale() {
        if (m_locale == null) {
            return Locale.ENGLISH;
        }
        return m_locale;
    }

    private static void parseSystemProperties() {
        try {
            m_osName = System.getProperty("os.name");
            if (m_osName != null) {
                if ((m_osName = m_osName.toLowerCase()).startsWith("win")) {
                    m_osId = 0;
                } else if (m_osName.startsWith("irix")) {
                    m_osId = 1;
                } else if (m_osName.startsWith("sun")) {
                    m_osId = 2;
                } else if (m_osName.startsWith("linux")) {
                    m_osId = 3;
                }
                m_font = null;
            }
            if (PsConfig.isApplication()) {
                String string = System.getProperty("file.separator");
                if (string == null) {
                    PsDebug.warning("no propKey obtained");
                } else if (string.length() == 0) {
                    PsDebug.warning("empty propKey obtained");
                } else {
                    m_fileSeparator = string.charAt(0);
                }
                String string2 = System.getProperty("archive.dev");
                if (string2 != null) {
                    PsConfig.m_bHasArchive[3] = true;
                    return;
                }
            }
        }
        catch (SecurityException securityException) {
            System.out.println("... not succeeded to access OS.NAME !!!\nException = " + securityException.toString());
        }
    }

    public static Frame getFrame() {
        if (m_dialogFrame == null) {
            m_dialogFrame = new Frame(PsConfig.getProgram() + " v" + PsConfig.getVersion());
        }
        return m_dialogFrame;
    }

    public static String getJavaViewLogo() {
        return JAVAVIEW_LOGO;
    }

    public static String getLanguage() {
        if (m_messages == null || m_messages[0] == null) {
            return "en";
        }
        return m_messages[0].getString("_language");
    }

    public static void setLanguage(String string) {
        if (string == null || string.equalsIgnoreCase("en")) {
            m_messages = null;
            return;
        }
        m_locale = Locale.ENGLISH;
        m_locale = string.equalsIgnoreCase("de") ? Locale.GERMAN : (string.equalsIgnoreCase("fr") ? Locale.FRENCH : (string.equalsIgnoreCase("zh") ? Locale.CHINESE : (string.equalsIgnoreCase("it") ? Locale.ITALIAN : (string.equalsIgnoreCase("jp") ? Locale.JAPANESE : new Locale(string, "")))));
        m_messages = new ResourceBundle[3];
        int n = 0;
        do {
            String string2 = "rsrc/Messages_" + RESOURCE_NAME[n];
            String string3 = string2 + "_" + string + ".properties";
            try {
                PsConfig.m_messages[n] = ResourceBundle.getBundle(string2, m_locale);
                if (m_messages[n] != null && !m_locale.getLanguage().equals(m_messages[n].getString("_language"))) {
                    PsConfig.m_messages[n] = null;
                }
                if (m_messages[n] != null) continue;
                String string4 = m_locale.getCountry();
                if (string4.length() != 0) {
                    string4 = "' and country '" + string4;
                }
                PsDebug.warning("Property file: " + string3);
                PsDebug.message("\twrong '_language' or '_country' key values in message file or no message file for language '" + m_locale.getLanguage() + string4 + "' found in /rsrc");
            }
            catch (MissingResourceException missingResourceException) {
                PsConfig.m_messages[n] = null;
                PsDebug.warning("missing property file for language = " + string);
                PsDebug.message("\tMust supply file: " + string3);
            }
        } while (++n < 3);
        if (m_messages[0] == null) {
            m_messages = null;
        }
    }

    public static String getUserBase() {
        return m_userBase;
    }

    public static void setUserBase(String string) {
        m_userBase = string;
    }

    public static Font getFont(int n) {
        if (n < 0 || n >= 5) {
            PsDebug.warning("type = " + n + " out of bounds.");
            n = 0;
        }
        if (m_font == null) {
            m_font = new Font[5];
        }
        if (m_font[n] == null) {
            PsConfig.m_font[n] = new Font(m_fontName[m_osId][n], m_fontStyle[m_osId][n], m_fontSize[m_osId][n]);
        }
        return m_font[n];
    }

    public static boolean setFont(int n, int n2, String string, int n3, int n4) {
        if (n2 < 0 || n2 >= 5) {
            PsDebug.warning("type = " + n2 + " out of bounds.");
            return false;
        }
        if (n == -1) {
            n = m_osId;
        }
        if (n < 0 || n >= m_fontName.length) {
            PsDebug.warning("os = " + n + " out of bounds.");
            return false;
        }
        if (string != null) {
            PsConfig.m_fontName[n][n2] = string;
        }
        if (n3 != -1) {
            PsConfig.m_fontStyle[n][n2] = n3;
        }
        if (n4 != -1) {
            PsConfig.m_fontSize[n][n2] = n4;
        }
        if (n == m_osId) {
            if (m_font == null) {
                m_font = new Font[5];
            }
            if (m_font[n2] != null) {
                PsConfig.m_font[n2] = new Font(m_fontName[m_osId][n2], m_fontStyle[m_osId][n2], m_fontSize[m_osId][n2]);
            }
        }
        return true;
    }

    static {
        m_versionDtdJvx = new int[]{1, 11, 1};
        m_versionDtdJvd = new int[]{1, 10, 1};
        int[] nArray = new int[3];
        nArray[1] = 99;
        nArray[2] = 8;
        m_versionDtdJvr = nArray;
        m_codeBase = null;
        m_userBase = null;
        m_fileSeparator = (char)47;
        m_bStandAlone = true;
        m_bIsInitialized = false;
        m_osId = 0;
        m_osName = null;
        m_font = new Font[5];
        m_fontName = new String[][]{{"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}, {"SansSerif", "Monospaced", "SansSerif", "SansSerif", "SansSerif"}};
        int[][] nArrayArray = new int[5][];
        int[] nArray2 = new int[5];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[5];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArrayArray[2] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArrayArray[3] = nArray5;
        int[] nArray6 = new int[5];
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[4] = 1;
        nArrayArray[4] = nArray6;
        m_fontStyle = nArrayArray;
        m_fontSize = new int[][]{{12, 12, 12, 14, 12}, {8, 8, 10, 10, 8}, {12, 12, 14, 14, 12}, {10, 10, 12, 12, 10}, {8, 8, 10, 10, 8}};
        ARCHIVE_NAME = new String[]{"jv", "jvx", "vgp", "dev"};
        boolean[] blArray = new boolean[4];
        blArray[3] = true;
        m_bIsArchiveTested = blArray;
        m_bHasArchive = new boolean[4];
        RESOURCE_NAME = ARCHIVE_NAME;
    }

    public static Hashtable getProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        try {
            Properties properties = System.getProperties();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                hashtable.put(string.toLowerCase(), System.getProperty(string));
            }
        }
        catch (SecurityException securityException) {}
        hashtable.put("is_application", String.valueOf(PsConfig.isApplication()));
        if (!hashtable.containsKey("codebase")) {
            hashtable.put("codebase", PsConfig.getCodeBase());
        }
        return hashtable;
    }

    public static boolean isApplication() {
        return m_bStandAlone;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static void init(Applet applet, PsViewerIf psViewerIf, Frame frame) {
        m_viewer = psViewerIf;
        PsConfig.init(applet, frame);
    }

    public static void init(Applet applet, Frame frame) {
        m_bIsInitialized = true;
        m_applet = applet;
        m_frame = frame;
        m_locale = Locale.ENGLISH;
        PsConfig.setApplication(m_frame != null || applet == null);
        PsConfig.parseSystemProperties();
        String string = null;
        if (!PsConfig.isApplication()) {
            String string2 = m_applet.getAppletInfo();
            if (string2 != null) {
                string2 = string2.replace('\n', '\t');
                string2 = string2.replace('\r', '\n');
                PsDebug.message("*** Info of Current Applet ***\n\t" + string2, false);
            }
            URL uRL = m_applet.getCodeBase();
            PsConfig.setCodeBase(uRL.toString());
            string = applet.getParameter("language");
        } else {
            String string3;
            String string4 = null;
            try {
                string4 = System.getProperty("user.dir");
                if (string4 != null) {
                    string4 = PsUtil.assureFileSeparator(string4, true);
                    PsConfig.setUserBase(string4);
                }
                PsDebug.message("Property: userBase = " + string4, false);
            }
            catch (SecurityException securityException) {}
            String string5 = null;
            try {
                string3 = System.getProperty("path.separator");
                String string6 = System.getProperty("java.class.path");
                if (string3 != null && string6 != null) {
                    String[] stringArray = PuString.splitString(string6, string3.charAt(0));
                    int n = 0;
                    while (n < stringArray.length) {
                        int n2 = stringArray[n].indexOf("jars" + m_fileSeparator + "javaview.jar");
                        if (n2 > -1) {
                            string5 = stringArray[n].substring(0, n2);
                            break;
                        }
                        n2 = stringArray[n].indexOf("javaview.exe");
                        if (n2 > -1) {
                            string5 = stringArray[n].substring(0, n2);
                            break;
                        }
                        ++n;
                    }
                    if (string5 != null) {
                        string5 = PsUtil.assureFileSeparator(string5, true);
                    }
                    PsDebug.message("Property: instBase = " + string5, false);
                }
            }
            catch (SecurityException securityException) {}
            if (PuString.isEmpty(string3 = PsConfig.getCodeBase())) {
                try {
                    string3 = System.getProperty("codebase");
                    PsDebug.message("Property: codebase = " + string3, false);
                }
                catch (SecurityException securityException) {}
                if (PuString.isEmpty(string3) && string5 != null) {
                    string3 = string5;
                }
                if (PuString.isEmpty(string3) && string4 != null) {
                    string3 = string4;
                }
                if (!PuString.isEmpty(string3)) {
                    PsConfig.setCodeBase(string3);
                }
            }
            try {
                string = System.getProperty("language");
            }
            catch (SecurityException securityException) {}
        }
        if (string != null) {
            PsDebug.message("Argument: language = " + string, false);
        } else {
            string = "en";
        }
        PsConfig.setLanguage(string);
    }

    public static char getFileSeparator() {
        return m_fileSeparator;
    }

    public static String getImageIcon() {
        return "images/jvIcon.gif";
    }
}

