/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public final class PuDouble
extends PsObject {
    protected Color m_backgroundColor;
    protected Color m_backgroundColorDef;
    protected int m_iValue;
    protected int m_numOfIncrements;
    protected static final int m_iLineIncr = 1;
    protected int m_iPageIncr;
    protected double m_shownAccuracy = 100000.0;
    private double m_defValue = 0.0;
    private double m_defMinimum = -10.0;
    private double m_defMaximum = 10.0;
    private double m_defLineIncr = 0.1;
    private double m_defPageIncr = 1.0;
    protected double m_value;
    protected double m_minimum;
    protected double m_maximum;
    protected double m_lineIncr;
    protected double m_pageIncr;
    protected boolean m_enabled = true;
    protected boolean m_bEnabledConfigButton = true;

    protected void setIntValue(int n) {
        this.m_value = this.m_minimum + (double)n * this.m_lineIncr;
        this.m_iValue = n;
    }

    public double getDefValue() {
        return this.m_defValue;
    }

    public void setDefValue(double d) {
        if (this.m_defMinimum > d) {
            this.m_defMinimum = d;
        }
        if (this.m_defMaximum < d) {
            this.m_defMaximum = d;
        }
        this.m_defValue = d;
    }

    public double getPageIncr() {
        return this.m_pageIncr;
    }

    public void setPageIncr(double d) {
        if (d > this.m_maximum - this.m_minimum) {
            d = (this.m_maximum - this.m_minimum) / 100.0;
        }
        if (d == 0.0) {
            d = 1.0;
        }
        this.m_pageIncr = d;
        this.m_numOfIncrements = (int)((this.m_maximum - this.m_minimum) / this.m_lineIncr);
        if ((double)this.m_numOfIncrements * this.m_lineIncr != this.m_maximum - this.m_minimum) {
            ++this.m_numOfIncrements;
        }
        this.m_iPageIncr = (int)(this.m_pageIncr / this.m_lineIncr);
    }

    public void initWithDefaults(double d, double d2, double d3, double d4, double d5) {
        this.setDefBounds(d, d2, d3, d4);
        this.setDefValue(d5);
        this.init();
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (d2 < d) {
            double d5 = d;
            d = d2;
            d2 = d5;
        }
        if (d3 >= d2 - d) {
            d3 = (d2 - d) / 100.0;
        }
        if (d4 >= d2 - d) {
            d4 = (d2 - d) / 10.0;
        }
        this.m_minimum = d;
        this.m_maximum = d2;
        this.m_lineIncr = d3;
        this.m_pageIncr = d4;
        this.m_numOfIncrements = (int)((this.m_maximum - this.m_minimum) / this.m_lineIncr);
        if ((double)this.m_numOfIncrements * this.m_lineIncr != this.m_maximum - this.m_minimum) {
            ++this.m_numOfIncrements;
        }
        this.m_iPageIncr = (int)(this.m_pageIncr / this.m_lineIncr);
        this.setValue(this.enforceBounds(this.m_value));
    }

    public void setBounds(double d, double d2) {
        this.setBounds(d, d2, Math.abs(d2 - d) / 100.0, Math.abs(d2 - d) / 10.0);
    }

    public double getDefMaximum() {
        return this.m_defMaximum;
    }

    public boolean isEnabledConfigButton() {
        return this.m_bEnabledConfigButton;
    }

    public void setValue(double d) {
        this.enlargeBounds(d);
        this.setValueFromPanel(d, this);
    }

    public double getValue() {
        return this.m_value;
    }

    public double getMin() {
        return this.m_minimum;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public Color getBackground() {
        return this.m_backgroundColor;
    }

    public PuDouble(String string) {
        this(string, null);
    }

    public PuDouble(String string, PsUpdateIf psUpdateIf) {
        this.setTag(4);
        this.setTag(7);
        this.setParent(psUpdateIf);
        this.setName(string);
        this.init();
    }

    public double getDefPageIncr() {
        return this.m_defPageIncr;
    }

    public void blend(double d, PuDouble puDouble, double d2, PuDouble puDouble2) {
        this.m_defValue = d * puDouble.m_defValue + d2 * puDouble2.m_defValue;
        this.m_defMinimum = d * puDouble.m_defMinimum + d2 * puDouble2.m_defMinimum;
        this.m_defMaximum = d * puDouble.m_defMaximum + d2 * puDouble2.m_defMaximum;
        this.m_defLineIncr = d * puDouble.m_defLineIncr + d2 * puDouble2.m_defLineIncr;
        this.m_defPageIncr = d * puDouble.m_defPageIncr + d2 * puDouble2.m_defPageIncr;
        this.m_value = d * puDouble.m_value + d2 * puDouble2.m_value;
        this.m_minimum = d * puDouble.m_minimum + d2 * puDouble2.m_minimum;
        this.m_maximum = d * puDouble.m_maximum + d2 * puDouble2.m_maximum;
        this.m_lineIncr = d * puDouble.m_lineIncr + d2 * puDouble2.m_lineIncr;
        this.m_pageIncr = d * puDouble.m_pageIncr + d2 * puDouble2.m_pageIncr;
        this.updatePanels(this);
    }

    public void setBackground(Color color) {
        this.m_backgroundColorDef = color;
        this.m_backgroundColor = color;
    }

    public void setDefBounds(double d, double d2, double d3, double d4) {
        if (d2 < d) {
            double d5 = d;
            d = d2;
            d2 = d5;
        }
        if (d3 > d2 - d) {
            d3 = (d2 - d) / 100.0;
        }
        if (d4 > d2 - d) {
            d4 = (d2 - d) / 10.0;
        }
        this.m_defMinimum = d;
        this.m_defMaximum = d2;
        this.m_defLineIncr = d3;
        this.m_defPageIncr = d4;
        if (this.m_defValue < this.m_defMinimum) {
            this.m_defValue = this.m_defMinimum;
        }
        if (this.m_defValue > this.m_defMaximum) {
            this.m_defValue = this.m_defMaximum;
        }
    }

    public double enforceBounds(double d) {
        if (d < this.m_minimum) {
            d = this.m_minimum;
        } else if (this.m_maximum < d) {
            d = this.m_maximum;
        }
        return d;
    }

    protected void setValueFromPanel(double d, Object object) {
        if (d <= this.m_minimum) {
            d = this.m_minimum;
            this.m_iValue = 0;
            object = this;
        } else if (this.m_maximum <= d) {
            d = this.m_maximum;
            this.m_iValue = this.m_numOfIncrements;
            object = this;
        } else {
            this.m_iValue = (int)((d - this.m_minimum) / this.m_lineIncr);
        }
        if (this.m_value == d) {
            return;
        }
        this.m_value = d;
        this.updatePanels(object);
    }

    public double getDefMinimum() {
        return this.m_defMinimum;
    }

    public double getLineIncr() {
        return this.m_lineIncr;
    }

    public void setLineIncr(double d) {
        if (d > this.m_maximum - this.m_minimum) {
            d = (this.m_maximum - this.m_minimum) / 10.0;
        }
        if (d == 0.0) {
            d = 0.1;
        }
        this.m_lineIncr = d;
        this.m_numOfIncrements = (int)((this.m_maximum - this.m_minimum) / this.m_lineIncr);
        if ((double)this.m_numOfIncrements * this.m_lineIncr != this.m_maximum - this.m_minimum) {
            ++this.m_numOfIncrements;
        }
        this.m_iPageIncr = (int)(this.m_pageIncr / this.m_lineIncr);
    }

    public void copy(PuDouble puDouble) {
        super.copy(puDouble);
        this.m_iValue = puDouble.m_iValue;
        this.m_numOfIncrements = puDouble.m_numOfIncrements;
        this.m_iPageIncr = puDouble.m_iPageIncr;
        this.m_shownAccuracy = puDouble.m_shownAccuracy;
        this.m_defValue = puDouble.m_defValue;
        this.m_defMinimum = puDouble.m_defMinimum;
        this.m_defMaximum = puDouble.m_defMaximum;
        this.m_defLineIncr = puDouble.m_defLineIncr;
        this.m_defPageIncr = puDouble.m_defPageIncr;
        this.m_value = puDouble.m_value;
        this.m_minimum = puDouble.m_minimum;
        this.m_maximum = puDouble.m_maximum;
        this.m_lineIncr = puDouble.m_lineIncr;
        this.m_pageIncr = puDouble.m_pageIncr;
    }

    public double getMax() {
        return this.m_maximum;
    }

    private void enlargeBounds(double d) {
        if (this.m_minimum > d) {
            this.m_minimum = d;
        } else if (this.m_maximum < d) {
            this.m_maximum = d;
        } else {
            return;
        }
        this.setBounds(this.m_minimum, this.m_maximum, this.m_lineIncr, this.m_pageIncr);
    }

    public void init() {
        super.init();
        this.m_shownAccuracy = 100000.0;
        this.setBounds(this.m_defMinimum, this.m_defMaximum, this.m_defLineIncr, this.m_defPageIncr);
        this.m_value = 0.0;
        this.m_iValue = (int)((this.m_value - this.m_minimum) / this.m_lineIncr);
        this.setValue(this.m_defValue);
        this.updatePanels(this);
    }

    public void setEnabled(boolean bl) {
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        this.updatePanels(this);
    }

    public double getDefLineIncr() {
        return this.m_defLineIncr;
    }

    public void setEnabledConfigButton(boolean bl) {
        this.m_bEnabledConfigButton = bl;
        this.updatePanels(this);
    }
}

