/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.vecmath.PdVector;

public class PdVector_IP
extends PsPanel
implements ActionListener {
    protected PdVector m_vector;
    protected int m_length;
    protected Panel m_pVector;
    protected TextField[] m_text;
    protected double m_shownAccuracy = 1000000.0;
    private boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$number$PdVector_IP;

    public PdVector_IP() {
        if (this.getClass() == (class$jv$number$PdVector_IP != null ? class$jv$number$PdVector_IP : (class$jv$number$PdVector_IP = PdVector_IP.class$("jv.number.PdVector_IP")))) {
            this.init();
        }
    }

    public boolean setVector(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!this.setLength(pdVector.getSize())) {
            PsDebug.warning("invalid length");
            return false;
        }
        this.m_vector = pdVector;
        this.update(this.m_vector);
        return true;
    }

    public PdVector getVector() {
        return this.m_vector;
    }

    public boolean update(Object object) {
        if (object == null) {
            PsDebug.warning("missing event");
            return false;
        }
        if (this.m_vector == null) {
            PsDebug.warning("missing vector");
            return false;
        }
        if (object == this.m_vector) {
            this.m_bInteractive = false;
            int n = 0;
            while (n < this.m_length) {
                double d = Math.rint(this.m_shownAccuracy * this.m_vector.getEntry(n)) / this.m_shownAccuracy;
                PsPanel.setText(this.m_text[n], PuString.toString(d));
                ++n;
            }
            this.m_bInteractive = true;
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        if (this.m_vector == null) {
            PsDebug.warning("missing vector, return");
            return;
        }
        Object object = actionEvent.getSource();
        int n = 0;
        while (n < this.m_length) {
            if (object == this.m_text[n]) {
                String string = this.m_text[n].getText();
                if (PuString.isEmpty(string)) {
                    return;
                }
                try {
                    this.m_vector.setEntry(n, new Double(string));
                    this.m_parent.update(this);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + string);
                    ((TextComponent)this.m_text[n]).setText(String.valueOf(this.m_vector.getEntry(n)));
                    return;
                }
            }
            ++n;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        this.m_lTitle = new Label();
        this.add(this.m_lTitle);
        this.m_pVector = new Panel();
        this.add(this.m_pVector);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        PsPanel.setEnabled(this.m_lTitle, bl);
        int n = 0;
        while (n < this.m_length) {
            PsPanel.setEnabled(this.m_text[n], bl);
            ++n;
        }
    }

    protected boolean setLength(int n) {
        if (n == this.m_length) {
            return true;
        }
        if (n > 5) {
            PsDebug.warning("vector length=" + this.m_length + " too large");
            return false;
        }
        this.m_length = n;
        this.m_pVector.removeAll();
        if (this.m_text == null || this.m_text.length != this.m_length) {
            int n2;
            if (this.m_text != null) {
                n2 = 0;
                while (n2 < this.m_text.length) {
                    this.m_text[n2].removeActionListener(this);
                    ++n2;
                }
            }
            this.m_pVector.setLayout(new GridLayout(1, this.m_length));
            this.m_text = new TextField[this.m_length];
            n2 = 0;
            while (n2 < this.m_length) {
                this.m_text[n2] = new TextField();
                this.m_text[n2].addActionListener(this);
                this.m_pVector.add(this.m_text[n2]);
                ++n2;
            }
            this.m_pVector.validate();
        }
        return true;
    }
}

