/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.number.PdColor;
import jv.number.PdColor_Dialog;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;

public class PdColor_IP
extends PsPanel
implements MouseListener,
TextListener {
    protected PdColor m_color;
    protected int[] m_rgbOld = new int[3];
    protected int[] m_rgbNew = new int[3];
    protected int m_length = 3;
    protected int m_min = 0;
    protected int m_max = 255;
    protected PsPanel m_pColor;
    protected TextField[] m_text;
    private boolean m_bInteractive = true;

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        PdColor_Dialog pdColor_Dialog = new PdColor_Dialog(this.m_color);
        pdColor_Dialog.show();
    }

    public PdColor_IP() {
        this.setLayout(new PsSlotLayout(6));
        this.m_lTitle = new Label();
        this.add("2", this.m_lTitle);
        this.m_pColor = new PsPanel(new BorderLayout());
        this.m_pColor.setBorderType(2);
        this.m_pColor.addMouseListener(this);
        this.m_pColor.setBackColor(Color.red);
        this.add("1", this.m_pColor);
        PsPanel psPanel = new PsPanel(new GridLayout(1, this.m_length));
        this.add("3", psPanel);
        this.m_text = new TextField[this.m_length];
        int n = 0;
        while (n < this.m_length) {
            this.m_text[n] = new TextField("0");
            this.m_text[n].addTextListener(this);
            psPanel.add(this.m_text[n]);
            ++n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_color = (PdColor)psUpdateIf;
        int n = 0;
        while (n < this.m_length) {
            this.m_rgbOld[0] = this.m_color.getEntry(n);
            ++n;
        }
    }

    public Color getColor() {
        return new Color(this.m_rgbNew[0], this.m_rgbNew[1], this.m_rgbNew[2]);
    }

    public boolean update(Object object) {
        if (this.m_color == null) {
            PsDebug.warning("missing color");
            return true;
        }
        if (object == this.m_color) {
            this.setEnabled(this.m_color.isEnabled());
            this.setTitle(this.m_color.getName());
            this.m_bInteractive = false;
            int n = 0;
            while (n < this.m_length) {
                this.m_rgbNew[n] = this.m_color.getEntry(n);
                PsPanel.setText(this.m_text[n], String.valueOf(this.m_rgbNew[n]));
                ++n;
            }
            this.m_bInteractive = true;
            this.m_pColor.setBackColor(this.m_color.getColor());
            this.m_pColor.repaint();
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        if (this.m_color == null) {
            PsDebug.warning("no color assigned, return");
            return;
        }
        Object object = textEvent.getSource();
        int n = 0;
        while (n < this.m_length) {
            if (object == this.m_text[n]) {
                String string = this.m_text[n].getText();
                if (string == null || string.equals("")) {
                    return;
                }
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < this.m_min || this.m_max < n2) {
                        PsDebug.warning("wrong format");
                        PsPanel.setText(this.m_text[n], String.valueOf(this.m_rgbNew[n]));
                        return;
                    }
                    this.m_rgbNew[n] = n2;
                    this.m_color.setEntry(n, this.m_rgbNew[n]);
                    this.m_pColor.setBackColor(this.m_color.getColor());
                    this.m_pColor.repaint();
                    this.m_color.update(null);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + string);
                    PsPanel.setText(this.m_text[n], String.valueOf(this.m_color.getEntry(n)));
                    return;
                }
            }
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        PsPanel.setEnabled(this.m_lTitle, bl);
        PsPanel.setEnabled(this.m_pColor, bl);
        int n = 0;
        while (n < this.m_length) {
            PsPanel.setEnabled(this.m_text[n], bl);
            ++n;
        }
    }
}

