/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.P_Vector_CP;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.vecmath.PdVector;

public class PdArray_IP
extends PsPanel
implements ActionListener,
AdjustmentListener,
ItemListener {
    protected PdVector[] m_vector;
    protected Scrollbar m_scroll;
    protected Panel m_coordPanel;
    protected Panel m_configPanel;
    protected TextField[][] m_text;
    protected Button[] m_bConfig;
    protected Label[] m_headerLabel;
    protected Checkbox[] m_indexLabel;
    protected int m_index = 0;
    protected int m_shownDim = -1;
    protected int m_shownVectors = -1;
    protected int m_maxVisibleDim = 5;
    protected int m_maxVisibleVectors = 5;
    private static /* synthetic */ Class class$jv$number$PdArray_IP;

    public void setHeader(String[] stringArray) {
        if (stringArray == null) {
            PsDebug.warning("missing header labels");
            return;
        }
        int n = 0;
        while (n < this.m_shownDim) {
            PsPanel.setText(this.m_headerLabel[n], stringArray[n]);
            ++n;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.m_scroll) {
            if (this.m_index == this.m_scroll.getValue()) {
                return;
            }
            this.m_index = this.m_scroll.getValue();
            this.updateContent();
        }
    }

    public PdArray_IP(int n, int n2) {
        this.m_maxVisibleVectors = n;
        this.m_maxVisibleDim = n2;
        if (this.getClass() == (class$jv$number$PdArray_IP != null ? class$jv$number$PdArray_IP : (class$jv$number$PdArray_IP = PdArray_IP.class$("jv.number.PdArray_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        int n = 0;
        while (n < this.m_shownVectors) {
            if (object == this.m_indexLabel[n]) {
                PdVector pdVector = this.m_vector[n + this.m_index];
                if (this.m_indexLabel[n].getState()) {
                    pdVector.setTag(1);
                } else {
                    pdVector.clearTag(1);
                }
                if (this.m_parent != null) {
                    this.m_parent.update(this);
                    return;
                }
                PsDebug.warning("missing parent");
                return;
            }
            ++n;
        }
    }

    public void setVector(PdVector[] pdVectorArray, String[] stringArray, int n, int n2) {
        if (n2 < 1) {
            n2 = this.m_maxVisibleDim;
        }
        if (stringArray == null || pdVectorArray == null) {
            PsDebug.warning("missing or empty argument");
            return;
        }
        this.m_vector = pdVectorArray;
        if (!this.setNumOfEntries(n, n2)) {
            PsDebug.error("invalid length", this);
            return;
        }
        if (this.m_index >= n - this.m_shownVectors) {
            this.m_index = Math.max(0, n - this.m_shownVectors);
        }
        this.m_scroll.setValues(this.m_index, 1, 0, Math.max(0, n - this.m_shownVectors + 1));
        int n3 = 0;
        while (n3 < this.m_shownDim) {
            PsPanel.setText(this.m_headerLabel[n3], stringArray[n3]);
            ++n3;
        }
        this.updateContent();
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
    }

    protected static void fillTable(TextField[][] textFieldArray, int n, int n2, PdVector[] pdVectorArray, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        int n8 = 0;
        if (pdVectorArray != null) {
            n7 = Math.min(n, n5);
        }
        int n9 = 0;
        while (n9 < n7) {
            if (pdVectorArray[n9 + n3] != null) {
                n8 = Math.min(n2, pdVectorArray[n9 + n3].getSize());
            }
            n6 = 0;
            while (n6 < n8) {
                double d = pdVectorArray[n9 + n3].m_data[n6 + n4];
                PsPanel.setText(textFieldArray[n9][n6], PuString.toString(d));
                ++n6;
            }
            n6 = n8;
            while (n6 < n2) {
                PsPanel.setText(textFieldArray[n9][n6], "");
                ++n6;
            }
            ++n9;
        }
        n9 = n7;
        while (n9 < n) {
            n6 = n8;
            while (n6 < n2) {
                PsPanel.setText(textFieldArray[n9][n6], "");
                ++n6;
            }
            ++n9;
        }
    }

    private void updateContent() {
        int n = Math.max(0, this.m_shownVectors);
        while (n < this.m_maxVisibleVectors) {
            PsPanel.setLabel(this.m_indexLabel[n], "");
            PsPanel.setState(this.m_indexLabel[n], false);
            ++n;
        }
        if (this.m_vector != null && this.m_vector.length >= this.m_shownVectors + this.m_index) {
            n = 0;
            while (n < this.m_shownVectors) {
                PsPanel.setLabel(this.m_indexLabel[n], String.valueOf(n + this.m_index));
                PsPanel.setState(this.m_indexLabel[n], this.m_vector[n + this.m_index].hasTag(1));
                ++n;
            }
            PdArray_IP.fillTable(this.m_text, this.m_maxVisibleVectors, this.m_shownDim, this.m_vector, this.m_index, 0, this.m_shownVectors);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        while (n < this.m_shownVectors) {
            PdVector pdVector = this.m_vector[n + this.m_index];
            int n2 = 0;
            while (n2 < this.m_shownDim) {
                if (object == this.m_text[n][n2]) {
                    if (n2 >= pdVector.getSize()) {
                        pdVector.setSize(n2 + 1);
                        PsDebug.warning("empty field edited, j=" + n2);
                    }
                    try {
                        pdVector.m_data[n2] = new Double(this.m_text[n][n2].getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        PsDebug.warning("wrong format = " + this.m_text[n][n2].getText());
                        PsPanel.setText(this.m_text[n][n2], String.valueOf(pdVector.m_data[n2]));
                        return;
                    }
                    this.m_parent.update(this);
                    return;
                }
                ++n2;
            }
            if (object == this.m_bConfig[n]) {
                P_Vector_CP p_Vector_CP = new P_Vector_CP(pdVector);
                p_Vector_CP.show();
                if (p_Vector_CP.getUserAction() == 4) {
                    this.m_parent.update(this);
                }
                return;
            }
            ++n;
        }
    }

    public boolean update(Object object) {
        if (this.m_parent == null) {
            PsDebug.warning("missing parent");
            return true;
        }
        if (object == this.m_parent) {
            this.updateContent();
            return true;
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean setNumOfEntries(int n, int n2) {
        if (n < 0) {
            n = this.m_maxVisibleVectors;
        }
        if (n2 < 1) {
            n2 = this.m_maxVisibleDim;
        }
        if (this.m_shownDim == Math.min(this.m_maxVisibleDim, n2) && this.m_shownVectors == Math.min(this.m_maxVisibleVectors, n)) {
            return true;
        }
        if (n2 > this.m_maxVisibleDim) {
            // empty if block
        }
        this.m_coordPanel.removeAll();
        this.m_shownVectors = Math.min(this.m_maxVisibleVectors, n);
        this.m_shownDim = Math.min(this.m_maxVisibleDim, n2);
        this.m_coordPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, this.m_shownDim));
        this.m_headerLabel = new Label[this.m_shownDim];
        int n3 = 0;
        while (n3 < this.m_shownDim) {
            this.m_headerLabel[n3] = new Label("", 1);
            this.m_coordPanel.add(this.m_headerLabel[n3]);
            ++n3;
        }
        this.m_text = new TextField[this.m_maxVisibleVectors][];
        int n4 = 0;
        while (n4 < this.m_maxVisibleVectors) {
            this.m_text[n4] = new TextField[this.m_shownDim];
            n3 = 0;
            while (n3 < this.m_shownDim) {
                this.m_text[n4][n3] = new TextField(10);
                this.m_text[n4][n3].addActionListener(this);
                this.m_coordPanel.add(this.m_text[n4][n3]);
                ++n3;
            }
            ++n4;
        }
        this.m_coordPanel.validate();
        this.m_configPanel.removeAll();
        this.m_configPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, 1));
        this.m_configPanel.add(new Label(""));
        this.m_bConfig = new Button[this.m_maxVisibleVectors];
        n4 = 0;
        while (n4 < this.m_maxVisibleVectors) {
            this.m_bConfig[n4] = new Button(PsConfig.getMessage(24132));
            this.m_bConfig[n4].addActionListener(this);
            this.m_configPanel.add(this.m_bConfig[n4]);
            ++n4;
        }
        this.m_configPanel.validate();
        return true;
    }

    public void init() {
        super.init();
        this.setLayout(new PsSlotLayout(5));
        Panel panel = new Panel(new BorderLayout());
        this.add("1", panel);
        panel.add((Component)new Label(PsConfig.getMessage(24120), 1), "North");
        this.m_scroll = new Scrollbar(1);
        this.m_scroll.addAdjustmentListener(this);
        panel.add((Component)this.m_scroll, "West");
        PsPanel psPanel = new PsPanel(new GridLayout(this.m_maxVisibleVectors, 1));
        psPanel.setInsetSize(4);
        this.m_indexLabel = new Checkbox[this.m_maxVisibleVectors];
        int n = 0;
        while (n < this.m_maxVisibleVectors) {
            this.m_indexLabel[n] = new Checkbox(String.valueOf(n));
            this.m_indexLabel[n].addItemListener(this);
            psPanel.add(this.m_indexLabel[n]);
            ++n;
        }
        panel.add((Component)psPanel, "Center");
        psPanel = new PsPanel(new BorderLayout());
        this.add("4", psPanel);
        this.m_coordPanel = new Panel();
        psPanel.add((Component)this.m_coordPanel, "Center");
        this.m_configPanel = new Panel();
        psPanel.add((Component)this.m_configPanel, "East");
    }
}

