/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.project.PvLightIf;
import jv.rsrc.PsAuthorInfo;
import jv.thirdParty.ruler.PgAxes;
import jv.thirdParty.ruler.PgRuler;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;
import jv.viewer.PvDisplay;
import jv.viewer.PvLight;

public final class PvDisplayOption
extends P_Vector {
    public static final int SHOW_ANTIALIAS = 1;
    public static final int SHOW_AUTOCENTER = 2;
    public static final int SHOW_AUTOFIT = 3;
    public static final int SHOW_AUTOROTATE = 4;
    public static final int SHOW_AXES = 5;
    public static final int SHOW_AXES_AUTO_BOUNDS = 42;
    public static final int SHOW_AXES_AUTO_CONFIGURE = 41;
    public static final int SHOW_AXES_AUTO_HASHING = 41;
    public static final int SHOW_AXES_AUTO_LAYOUT = 43;
    public static final int SHOW_AXES_NAME = 9;
    public static final int SHOW_AXES_NUMBERS = 6;
    public static final int SHOW_AXES_LABEL = 6;
    public static final int SHOW_AXES_TITLE = 999991111;
    public static final int SHOW_BACKGROUND_IMAGE = 10;
    public static final int SHOW_BORDER = 11;
    public static final int SHOW_BOUNDING_BOX = 12;
    public static final int SHOW_CENTER = 13;
    public static final int SHOW_CROSS = 14;
    public static final int SHOW_DEPTHCUE = 15;
    public static final int SHOW_DOUBLEBUFFER = 16;
    public static final int SHOW_DRAWING = 17;
    public static final int SHOW_EDGE_AURA = 18;
    public static final int SHOW_FOREGROUND_IMAGE = 19;
    public static final int SHOW_FRAME = 20;
    public static final int SHOW_INFO = 21;
    public static final int SHOW_LIGHTING = 22;
    public static final int SHOW_MAGNET = 23;
    public static final int SHOW_SINGLE = 24;
    public static final int SHOW_SORTING = 25;
    public static final int SHOW_VISIBLE = 26;
    public static final int SHOW_XY_GRID = 27;
    public static final int SHOW_XZ_GRID = 28;
    public static final int SHOW_YZ_GRID = 29;
    public static final int SHOW_ZBUFFER = 30;
    public static final int SHOW_LOCAL_TRANSFORM = 31;
    public static final int SHOW_DIRECT_SELECT = 32;
    public static final int SHOW_TITLE = 33;
    public static final int SHOW_COPYRIGHT = 34;
    public static final int SHOW_BOX_RATIO = 35;
    public static final int SHOW_FILL_DISPLAY = 46;
    public static final int SHOW_CLIP_BOUNDS = 36;
    public static final int SHOW_CLIP_AUTO_BOUNDS = 45;
    public static final int SHOW_3DLOOK = 37;
    public static final int SHOW_ADAPTIVE_SIZE = 38;
    public static final int SHOW_INTEGER_PICK = 39;
    public static final int SHOW_EDGES_ONCE = 40;
    public static final int SHOW_CLEAR_SCREEN = 44;
    protected String m_version = "0.99";
    protected String m_versionType = "dump";
    protected String m_title;
    protected PsAuthorInfo m_authorInfo;
    protected String m_abstract;
    protected int m_dim;
    protected PgAxes m_axes;
    protected String[] m_axesLabel;
    protected int m_axesCoordSystem;
    protected String[] m_axesTitle;
    protected int m_axesType;
    protected boolean[] m_bAxesShowHashingFlags;
    protected int m_numRulers;
    protected boolean[] m_bShowRuler;
    protected int[] m_rulerMode;
    protected String[] m_rulerName;
    protected boolean[] m_bShowRulerName;
    protected boolean[] m_bShowRulerArrow;
    protected boolean[] m_bShowRulerNumbers;
    protected boolean[] m_bShowRulerHashingsNormal;
    protected boolean[] m_bShowRulerHashingsUp;
    protected boolean[] m_bShowRulerTicksMajor;
    protected boolean[] m_bShowRulerTicksMinor;
    protected double[] m_rulerMinValue;
    protected double[] m_rulerMaxValue;
    protected double[] m_rulerMinorHashUnit;
    protected double[] m_rulerMajorHashUnit;
    protected int[] m_rulerNumMinorHashings;
    protected int[] m_rulerNumMajorHashings;
    protected int m_transformMode;
    protected boolean m_bDirectSelect;
    protected int m_majorMode;
    protected int m_numCameras;
    protected int m_currentCamera;
    protected String[] m_cameraName;
    protected int[] m_cameraProjection;
    protected PdVector[] m_cameraPosition;
    protected PdVector[] m_cameraInterest;
    protected double[] m_cameraRoll;
    protected double[] m_cameraFieldOfView;
    protected boolean[] m_bCameraEnableClip;
    protected double[] m_cameraNearClip;
    protected double[] m_cameraFarClip;
    protected boolean[] m_bCameraSceneRatio;
    protected boolean[] m_bCameraFillDisplay;
    protected int m_lightingModel;
    protected int m_numLights;
    protected int m_selectedLight;
    protected String[] m_lightName;
    protected int[] m_lightType;
    protected PdVector[] m_lightPosition;
    protected PdVector[] m_lightInterest;
    protected Color[] m_lightColor;
    protected boolean[] m_bLightSwitchedOn;
    protected boolean[] m_bLightVisible;
    protected int[] m_lightReference;
    protected int[] m_lightShading;
    protected double[] m_lightIntensity;
    protected boolean[] m_bLightHighlight;
    protected double[] m_lightAngle;
    protected double[] m_lightCorona;
    protected double[] m_lightExponent;
    protected double[] m_lightFalloff;
    protected String[] m_searchPath;
    protected Color m_backgroundColor;
    protected int m_backgroundImageFit;
    protected String m_backgroundImageFile;
    protected Image m_backgroundImage;
    protected Color m_foregroundColor;
    protected int m_foregroundImageFit;
    protected String m_foregroundImageFile;
    protected Image m_foregroundImage;
    protected Point m_windowPosition;
    protected Dimension m_windowSize;
    protected int m_arrayPosition;
    protected Dimension m_arraySize;
    protected PiVector m_axesEdge;
    protected Color[] m_rulerColor;
    protected double[] m_rulerSize;
    protected Color m_bndBoxColor;
    protected double m_bndBoxSize;
    protected PdVector m_bndBoxRatio;
    protected PdVector[] m_clipBounds;
    protected int m_clipBoundsType;
    protected PdVector m_viewCenter;

    public Image getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.m_backgroundImage = image;
    }

    public double getLightFalloff(int n) {
        return this.m_lightFalloff[n];
    }

    public boolean isEnabledCameraClip(int n) {
        return this.m_bCameraEnableClip[n];
    }

    public void setLightFalloff(int n, double d) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightFalloff[n] = d;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public boolean isEnabledCameraSceneRatio(int n) {
        return this.m_bCameraSceneRatio[n];
    }

    public double getLightCorona(int n) {
        return this.m_lightCorona[n];
    }

    public void setLightCorona(int n, double d) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightCorona[n] = d;
    }

    public boolean isShowingRulerTicksMajor(int n) {
        return this.m_bShowRulerTicksMajor[n];
    }

    public void showRulerTicksMajor(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerTicksMajor[n] = bl;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
    }

    public boolean isLightVisible(int n) {
        return this.m_bLightVisible[n];
    }

    public PgAxes getAxes() {
        return this.m_axes;
    }

    public void setAxes(PgAxes pgAxes) {
        this.m_axes = pgAxes;
    }

    public int getNumLights() {
        return this.m_numLights;
    }

    public void setNumLights(int n) {
        if (n < 0) {
            PsDebug.warning("number = " + n + " < 0");
            return;
        }
        if (n == this.m_numLights) {
            return;
        }
        this.m_numLights = n;
        this.m_lightName = PuData.realloc(this.m_lightName, this.m_numLights);
        this.m_lightType = PuData.realloc(this.m_lightType, this.m_numLights);
        this.m_lightShading = PuData.realloc(this.m_lightShading, this.m_numLights, 0);
        this.m_lightReference = PuData.realloc(this.m_lightReference, this.m_numLights, 0);
        this.m_lightPosition = PdVector.realloc(this.m_lightPosition, this.m_numLights, this.m_dim);
        this.m_lightInterest = PdVector.realloc(this.m_lightInterest, this.m_numLights, this.m_dim);
        this.m_lightColor = PdColor.realloc(this.m_lightColor, this.m_numLights);
        this.m_bLightSwitchedOn = PuData.realloc(this.m_bLightSwitchedOn, this.m_numLights, true);
        this.m_bLightVisible = PuData.realloc(this.m_bLightVisible, this.m_numLights, false);
        this.m_bLightHighlight = PuData.realloc(this.m_bLightHighlight, this.m_numLights, false);
        this.m_lightIntensity = PuData.realloc(this.m_lightIntensity, this.m_numLights, 0.8);
        this.m_lightAngle = PuData.realloc(this.m_lightAngle, this.m_numLights, -1.0);
        this.m_lightCorona = PuData.realloc(this.m_lightCorona, this.m_numLights, -1.0);
        this.m_lightExponent = PuData.realloc(this.m_lightExponent, this.m_numLights, 10.0);
        this.m_lightFalloff = PuData.realloc(this.m_lightFalloff, this.m_numLights, -1.0);
    }

    public PdMatrix getCameraMatrix(int n) {
        PdVector pdVector = this.getCameraInterest(n);
        PdVector pdVector2 = this.getCameraPosition(n);
        PdVector pdVector3 = PdVector.subNew(pdVector, pdVector2);
        pdVector3.normalize();
        PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
        if (!pdVector6.normalize()) {
            pdVector4.m_data[1] = pdVector4.m_data[1] + 1.0;
            pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
            if (!pdVector6.normalize()) {
                pdVector4.m_data[2] = pdVector4.m_data[2] + 1.0;
                pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
                if (!pdVector6.normalize()) {
                    pdVector4.m_data[2] = pdVector4.m_data[2] + 1.0;
                    pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
                }
            }
        }
        pdVector4.copy(pdVector6);
        PuVectorGeom.rotatePointAroundVector(pdVector6, pdVector4, pdVector3, this.m_cameraRoll[n] * Math.PI / 180.0);
        pdVector5.cross(pdVector3, pdVector6);
        PdMatrix pdMatrix = new PdMatrix(4);
        double d = PdVector.dist(pdVector2, pdVector);
        int n2 = 0;
        do {
            pdMatrix.m_data[0][n2] = d * pdVector5.m_data[n2];
            pdMatrix.m_data[1][n2] = d * pdVector6.m_data[n2];
            pdMatrix.m_data[2][n2] = -d * pdVector3.m_data[n2];
            pdMatrix.m_data[3][n2] = pdVector.m_data[n2];
        } while (++n2 < 3);
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public void setCameraMatrix(int n, PdMatrix pdMatrix) {
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n2 = 0;
        do {
            pdVector4.m_data[n2] = pdMatrix.m_data[0][n2];
            pdVector3.m_data[n2] = pdMatrix.m_data[1][n2];
            pdVector2.m_data[n2] = -pdMatrix.m_data[2][n2];
            pdVector.m_data[n2] = pdMatrix.m_data[3][n2];
            pdVector5.m_data[n2] = pdMatrix.m_data[n2][2];
        } while (++n2 < 3);
        this.setCameraPosition(n, PdVector.subNew(pdVector, pdVector2));
        this.setCameraInterest(n, pdVector);
        pdVector5.setEntry(2, 0.0);
        pdVector5.normalize();
        double d = Math.acos(pdVector5.getEntry(1)) * 180.0 / Math.PI;
        this.setCameraRoll(n, d);
    }

    public double getCameraFieldOfView(int n) {
        return this.m_cameraFieldOfView[n];
    }

    public void setCameraFieldOfView(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraFieldOfView[n] = d;
    }

    public int getRulerNumMajorHashings(int n) {
        return this.m_rulerNumMajorHashings[n];
    }

    public void setRulerNumMajorHashings(int n, int n2) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerNumMajorHashings[n] = n2;
    }

    public Color getAmbientLight() {
        int n = 0;
        while (n < this.m_numLights) {
            if (this.getLightType(n) == 0) {
                return PdColor.getDimmedColor(this.getLightColor(n), this.getLightIntensity(n));
            }
            ++n;
        }
        return Color.black;
    }

    public void setAmbientLight(Color color) {
        int n = 0;
        while (n < this.m_numLights) {
            if (this.getLightType(n) == 0) {
                this.setLightColor(n, color);
                return;
            }
            ++n;
        }
        PsDebug.warning("missing ambient light, allocate before usage.");
    }

    public boolean isLightHighlight(int n) {
        return this.m_bLightHighlight[n];
    }

    public PdVector getBoxRatio() {
        return this.m_bndBoxRatio;
    }

    public void setBoxRatio(PdVector pdVector) {
        this.m_bndBoxRatio = pdVector;
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public void setAbstract(String string) {
        this.m_abstract = string;
    }

    public int getCameraProjection(int n) {
        return this.m_cameraProjection[n];
    }

    public void setCameraProjection(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraProjection[n] = n2;
    }

    public Point getWindowPosition() {
        return this.m_windowPosition;
    }

    public boolean isLightSwitchedOn(int n) {
        return this.m_bLightSwitchedOn[n];
    }

    public void setWindowPosition(Point point) {
        this.m_windowPosition = point;
    }

    public void setWindowPosition(int n, int n2) {
        this.setWindowPosition(new Point(n, n2));
    }

    public boolean isShowingRulerArrow(int n) {
        return this.m_bShowRulerArrow[n];
    }

    public void showRulerArrow(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerArrow[n] = bl;
    }

    public double getRulerMinorHashUnit(int n) {
        return this.m_rulerMinorHashUnit[n];
    }

    public void setRulerMinorHashUnit(int n, double d) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerMinorHashUnit[n] = d;
    }

    public int getBackgroundImageFit() {
        return this.m_backgroundImageFit;
    }

    public String[] getAxesLabel() {
        return this.m_axesLabel;
    }

    public void setAxesLabel(String[] stringArray) {
        if (stringArray == null) {
            this.m_axesLabel = null;
            return;
        }
        this.m_axesLabel = (String[])stringArray.clone();
    }

    public void setBackgroundImageFit(int n) {
        this.m_backgroundImageFit = n;
    }

    public Dimension getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(Dimension dimension) {
        this.m_windowSize = dimension;
    }

    public int getAxesCoordSystem() {
        return this.m_axesCoordSystem;
    }

    public void setAxesCoordSystem(int n) {
        this.m_axesCoordSystem = n;
    }

    public void setWindowSize(int n, int n2) {
        this.setWindowSize(new Dimension(n, n2));
    }

    public void setArrayPosition(int n) {
        this.m_arrayPosition = n;
    }

    public int getArrayPosition() {
        return this.m_arrayPosition;
    }

    public void setArraySize(Dimension dimension) {
        this.m_arraySize = dimension;
    }

    public Dimension getArraySize() {
        return this.m_arraySize;
    }

    public int getClipBoundsType() {
        return this.m_clipBoundsType;
    }

    public void setClipBoundsType(int n) {
        this.m_clipBoundsType = n;
    }

    public String getCameraName(int n) {
        return this.m_cameraName[n];
    }

    public void setCameraName(int n, String string) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraName[n] = string;
    }

    public String getLightName(int n) {
        return this.m_lightName[n];
    }

    public void setLightName(int n, String string) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightName[n] = string;
    }

    public void setEnabledCameraClip(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_bCameraEnableClip[n] = bl;
    }

    public double getCameraNearClip(int n) {
        return this.m_cameraNearClip[n];
    }

    public void setCameraNearClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraNearClip[n] = d;
    }

    public Image getForegroundImage() {
        return this.m_foregroundImage;
    }

    public void setForegroundImage(Image image) {
        this.m_foregroundImage = image;
    }

    public void setEnabledCameraSceneRatio(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_bCameraSceneRatio[n] = bl;
    }

    public int getLightingModel() {
        return this.m_lightingModel;
    }

    public PvDisplayOption() {
        this.setOption(1, false);
        this.setOption(38, false);
        this.setOption(2, false);
        this.setOption(3, false);
        this.setOption(4, false);
        this.setOption(5, false);
        this.setOption(42, true);
        this.setOption(41, true);
        this.setOption(43, true);
        this.setOption(6, true);
        this.setOption(9, true);
        this.setOption(10, false);
        this.setOption(12, false);
        this.setOption(35, false);
        this.setOption(11, true);
        this.setOption(13, false);
        this.setOption(44, true);
        this.setOption(45, true);
        this.setOption(36, false);
        this.setOption(34, false);
        this.setOption(14, false);
        this.setOption(15, true);
        this.setOption(32, false);
        this.setOption(16, true);
        this.setOption(17, true);
        this.setOption(18, false);
        this.setOption(40, true);
        this.setOption(46, false);
        this.setOption(19, false);
        this.setOption(20, false);
        this.setOption(21, false);
        this.setOption(39, false);
        this.setOption(22, false);
        this.setOption(31, false);
        this.setOption(23, false);
        this.setOption(24, false);
        this.setOption(25, true);
        this.setOption(33, false);
        this.setOption(26, true);
        this.setOption(27, false);
        this.setOption(28, false);
        this.setOption(29, false);
        this.setOption(30, false);
        this.setOption(37, false);
        this.m_dim = 3;
        this.m_majorMode = 0;
        this.m_transformMode = 0;
        this.m_axesCoordSystem = 0;
        this.m_axesType = 2;
        this.m_axesLabel = new String[]{"x", "y", "z"};
        this.m_bAxesShowHashingFlags = new boolean[6];
        this.m_bndBoxSize = 1.0;
        this.m_clipBoundsType = -1;
        this.m_lightingModel = 0;
        this.m_backgroundImageFit = 2;
        this.m_foregroundImageFit = 2;
        this.m_arrayPosition = 1;
        this.m_arraySize = new Dimension(1, 1);
    }

    public int getTransformMode() {
        return this.m_transformMode;
    }

    public void setTransformMode(int n) {
        this.m_transformMode = n;
    }

    public void setLightingModel(int n) {
        this.m_lightingModel = n;
    }

    public Color getLightColor(int n) {
        return this.m_lightColor[n];
    }

    public void setLightColor(int n, Color color) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightColor[n] = color;
    }

    public void setLightVisible(int n, boolean bl) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_bLightVisible[n] = bl;
    }

    public double getLightExponent(int n) {
        return this.m_lightExponent[n];
    }

    public void setLightExponent(int n, double d) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightExponent[n] = d;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor = color;
    }

    public double getLightIntensity(int n) {
        return this.m_lightIntensity[n];
    }

    public void setLightIntensity(int n, double d) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightIntensity[n] = d;
    }

    public String getLightingModelAsString() {
        return PvLight.getLightingModelAsString(this.m_lightingModel);
    }

    public void setLightingModelAsString(String string) {
        this.m_lightingModel = PvLight.getLightingModelAsInt(string);
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public boolean isShowingRulerNumbers(int n) {
        return this.m_bShowRulerNumbers[n];
    }

    public void showRulerNumbers(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerNumbers[n] = bl;
    }

    public void setAxesType(int n) {
        this.m_axesType = n;
    }

    public int getAxesType() {
        return this.m_axesType;
    }

    public double getCameraRoll(int n) {
        return this.m_cameraRoll[n];
    }

    public void setCameraRoll(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraRoll[n] = d;
    }

    public double[] getClipBounds(int n) {
        double[] dArray = null;
        if (this.m_clipBounds != null && this.m_clipBounds[0].getSize() > n) {
            dArray = new double[]{this.m_clipBounds[0].getEntry(n), this.m_clipBounds[1].getEntry(n)};
        }
        return dArray;
    }

    public void setClipBounds(int n, double[] dArray) {
        if (n < 0 || 2 < n) {
            PsDebug.warning("index out of range [0,2], index = " + n);
            return;
        }
        if (dArray == null) {
            this.m_clipBounds = null;
            return;
        }
        if (dArray.length < 2) {
            PsDebug.warning("range array too small");
            return;
        }
        if (this.m_clipBounds == null) {
            this.m_clipBounds = PdVector.realloc(this.m_clipBounds, 2, 3);
            this.m_clipBounds[0].setConstant(Double.NEGATIVE_INFINITY);
            this.m_clipBounds[1].setConstant(Double.MAX_VALUE);
        }
        this.m_clipBounds[0].setEntry(n, dArray[0]);
        this.m_clipBounds[1].setEntry(n, dArray[1]);
        if (this.m_clipBoundsType == -1) {
            this.m_clipBoundsType = 0;
        }
    }

    public boolean getOption(int n) {
        return this.hasTag(n);
    }

    public void setOption(int n, boolean bl) {
        if (bl) {
            this.setTag(n);
        } else {
            this.clearTag(n);
        }
        if (n == 6) {
            int n2 = 0;
            while (n2 < this.m_numRulers) {
                this.showRulerNumbers(n2, bl);
                ++n2;
            }
            return;
        }
        if (n == 9) {
            int n3 = 0;
            while (n3 < this.m_numRulers) {
                this.showRulerName(n3, bl);
                ++n3;
            }
        }
    }

    public PiVector getAxesEdge() {
        return this.m_axesEdge;
    }

    public void setAxesEdge(PiVector piVector) {
        this.m_axesEdge = piVector;
    }

    public int getCurrentCamera() {
        return this.m_currentCamera;
    }

    public void setCurrentCamera(int n) {
        this.m_currentCamera = n;
    }

    public Color getBndBoxColor() {
        return this.m_bndBoxColor;
    }

    public void setBndBoxColor(Color color) {
        this.m_bndBoxColor = color;
    }

    public int getSelectedLight() {
        return this.m_selectedLight;
    }

    public void setSelectedLight(int n) {
        this.m_selectedLight = n;
    }

    public boolean isShowingRuler(int n) {
        return this.m_bShowRuler[n];
    }

    public void showRuler(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRuler[n] = bl;
    }

    public void setLightSwitchedOn(int n, boolean bl) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_bLightSwitchedOn[n] = bl;
    }

    public void setLightHighlight(int n, boolean bl) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_bLightHighlight[n] = bl;
    }

    public boolean isShowingRulerHashingsUp(int n) {
        return this.m_bShowRulerHashingsUp[n];
    }

    public void showRulerHashingsUp(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerHashingsUp[n] = bl;
    }

    public int getLightReference(int n) {
        return this.m_lightReference[n];
    }

    public void setLightReference(int n, int n2) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightReference[n] = n2;
    }

    public double getRulerMaxValue(int n) {
        return this.m_rulerMaxValue[n];
    }

    public void setRulerMaxValue(int n, double d) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerMaxValue[n] = d;
    }

    public int getLightShading(int n) {
        return this.m_lightShading[n];
    }

    public void setLightShading(int n, int n2) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightShading[n] = n2;
    }

    public String getForegroundImageFile() {
        return this.m_foregroundImageFile;
    }

    public void setForegroundImageFile(String string) {
        this.m_foregroundImageFile = string;
    }

    public String getRulerName(int n) {
        return this.m_rulerName[n];
    }

    public void setRulerName(int n, String string) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerName[n] = string;
    }

    public boolean isShowingRulerName(int n) {
        return this.m_bShowRulerName[n];
    }

    public void showRulerName(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerName[n] = bl;
    }

    public double getCameraFarClip(int n) {
        return this.m_cameraFarClip[n];
    }

    public void setCameraFarClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraFarClip[n] = d;
    }

    public PdVector getCameraPosition(int n) {
        return this.m_cameraPosition[n];
    }

    public void setCameraPosition(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraPosition[n].copy(pdVector);
    }

    public PdVector getLightPosition(int n) {
        return this.m_lightPosition[n];
    }

    public void setLightPosition(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightPosition[n] = pdVector;
    }

    public double getRulerMajorHashUnit(int n) {
        return this.m_rulerMajorHashUnit[n];
    }

    public void setRulerMajorHashUnit(int n, double d) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerMajorHashUnit[n] = d;
    }

    public int getForegroundImageFit() {
        return this.m_foregroundImageFit;
    }

    public void setForegroundImageFit(int n) {
        this.m_foregroundImageFit = n;
    }

    public Color getRulerColor(int n) {
        return this.m_rulerColor[n];
    }

    public void setRulerColor(int n, Color color) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerColor[n] = color;
    }

    public int getRulerNumMinorHashings(int n) {
        return this.m_rulerNumMinorHashings[n];
    }

    public void setRulerNumMinorHashings(int n, int n2) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerNumMinorHashings[n] = n2;
    }

    public void configure(PvDisplayIf pvDisplayIf) {
        Cloneable cloneable;
        if (pvDisplayIf == null) {
            PsDebug.warning("missing display");
            return;
        }
        pvDisplayIf.setPaintTag(1L, false);
        pvDisplayIf.setEnabledUpdate(false);
        if (this.getBndBoxColor() != null) {
            pvDisplayIf.setBndBoxColor(this.getBndBoxColor());
        }
        pvDisplayIf.setBndBoxSize(this.getBndBoxSize());
        pvDisplayIf.setBoxRatio(this.getBoxRatio());
        pvDisplayIf.setEnabledAntiAlias(this.getOption(1));
        pvDisplayIf.setEnabledAnimation(this.getOption(4));
        if (pvDisplayIf instanceof PvDisplay) {
            ((PvDisplay)pvDisplayIf).setSearchPaths(this.getSearchPaths());
        }
        if (this.getBackgroundColor() != null) {
            pvDisplayIf.setBackgroundColor(this.getBackgroundColor());
        }
        pvDisplayIf.setBackgroundImageFit(this.m_backgroundImageFit);
        pvDisplayIf.setBackgroundImageFile(this.getBackgroundImageFile());
        pvDisplayIf.setBackgroundImage(this.getBackgroundImage());
        pvDisplayIf.showBackgroundImage(this.getOption(10));
        pvDisplayIf.setPaintTag(4L, this.getOption(11));
        pvDisplayIf.setEnabledBoxRatio(this.getOption(35));
        pvDisplayIf.setPaintTag(16384L, this.getOption(13));
        pvDisplayIf.setPaintTag(8192L, this.getOption(44));
        pvDisplayIf.setEnabledClipBounds(this.getOption(36));
        pvDisplayIf.showCopyright(this.getOption(34));
        pvDisplayIf.setPaintTag(16L, this.getOption(14));
        pvDisplayIf.showDepthcue(this.getOption(15));
        pvDisplayIf.setEnabledDirectSelect(this.getOption(32));
        pvDisplayIf.setEnabledDoubleBuffer(this.getOption(16));
        pvDisplayIf.setPaintTag(1L, this.getOption(17));
        pvDisplayIf.showEdgeAura(this.getOption(18));
        pvDisplayIf.showEdgesOnce(this.getOption(40));
        pvDisplayIf.setEnabledFillDisplay(this.getOption(46));
        if (this.getForegroundColor() != null) {
            pvDisplayIf.setForegroundColor(this.getForegroundColor());
        }
        pvDisplayIf.setForegroundImageFit(this.m_foregroundImageFit);
        pvDisplayIf.setForegroundImageFile(this.getForegroundImageFile());
        pvDisplayIf.setForegroundImage(this.getForegroundImage());
        pvDisplayIf.showForegroundImage(this.getOption(19));
        pvDisplayIf.setPaintTag(256L, this.getOption(21));
        pvDisplayIf.setEnabledIntegerPick(this.getOption(39));
        pvDisplayIf.setEnabledLocalTransform(this.getOption(31));
        pvDisplayIf.showMagnet(this.getOption(23));
        pvDisplayIf.setPaintTag(2048L, this.getOption(24));
        pvDisplayIf.setEnabledPainters(this.getOption(25));
        pvDisplayIf.showTitle(this.getOption(33));
        pvDisplayIf.setEnabledZBuffer(this.getOption(30));
        pvDisplayIf.setEnabledBoxRatio(this.getOption(35));
        pvDisplayIf.setEnabledClipBounds(this.getOption(36));
        pvDisplayIf.setEnabledClipAutoBounds(this.getOption(45));
        pvDisplayIf.setEnabled3DLook(this.getOption(37));
        pvDisplayIf.setEnabledAdaptiveSize(this.getOption(38));
        pvDisplayIf.setMajorMode(this.getMajorMode());
        pvDisplayIf.setTransformationMode(this.getTransformMode());
        pvDisplayIf.setClipBoundsType(this.getClipBoundsType());
        int n = 0;
        do {
            pvDisplayIf.setClipBounds(n, this.getClipBounds(n));
        } while (++n < 3);
        if (!this.getOption(2) && !this.getOption(3)) {
            pvDisplayIf.setAutoCenter(false);
        }
        pvDisplayIf.selectCamera(this.getCurrentCamera());
        n = 0;
        while (n < this.m_numCameras) {
            PvCameraIf pvCameraIf = null;
            if (!pvDisplayIf.hasCamera(this.m_cameraProjection[n])) {
                pvDisplayIf.selectCamera(this.m_cameraProjection[n]);
            }
            pvCameraIf = pvDisplayIf.getCamera(this.m_cameraProjection[n]);
            if (this.m_cameraName[n] != null) {
                pvCameraIf.setName(this.m_cameraName[n]);
            }
            pvCameraIf.setBoxRatio(this.getBoxRatio());
            pvCameraIf.setEnabledBoxRatio(this.getOption(35));
            pvCameraIf.setInterest(this.m_cameraInterest[n]);
            pvCameraIf.setPosition(this.m_cameraPosition[n]);
            pvCameraIf.setFieldOfView(this.m_cameraFieldOfView[n]);
            pvCameraIf.setRoll(this.m_cameraRoll[n]);
            pvCameraIf.setEnabledClip(this.isEnabledCameraClip(n));
            pvCameraIf.setNearClip(this.getCameraNearClip(n));
            pvCameraIf.setFarClip(this.getCameraFarClip(n));
            pvCameraIf.setEnabledSceneRatio(this.isEnabledCameraSceneRatio(n));
            pvCameraIf.update(pvCameraIf);
            ++n;
        }
        pvDisplayIf.selectCamera(this.getCurrentCamera());
        pvDisplayIf.setEnabledUpdate(true);
        pvDisplayIf.showBndBox(this.getOption(12));
        pvDisplayIf.showFrame(this.getOption(20));
        pvDisplayIf.showGrid(this.getOption(27));
        Cloneable cloneable2 = null;
        pvDisplayIf.removeLights();
        int n2 = 0;
        while (n2 < this.m_numLights) {
            cloneable = new PvLight(pvDisplayIf, this.getLightType(n2));
            if (this.m_lightName[n2] != null) {
                cloneable.setName(this.m_lightName[n2]);
            }
            cloneable.setReference(this.getLightReference(n2));
            cloneable.setShading(this.getLightShading(n2));
            cloneable.setPosition(this.getLightPosition(n2));
            cloneable.setInterest(this.getLightInterest(n2));
            cloneable.setColor(this.getLightColor(n2));
            cloneable.setSwitchedOn(this.isLightSwitchedOn(n2));
            cloneable.setVisible(this.isLightVisible(n2));
            cloneable.setHighlight(this.isLightHighlight(n2));
            cloneable.setIntensity(this.getLightIntensity(n2));
            if (this.getLightAngle(n2) != -1.0) {
                cloneable.setAngle(this.getLightAngle(n2));
            }
            if (this.getLightCorona(n2) != -1.0) {
                cloneable.setCorona(this.getLightCorona(n2));
            }
            cloneable.setExponent(this.getLightExponent(n2));
            if (this.getLightFalloff(n2) != -1.0) {
                cloneable.setFalloff(this.getLightFalloff(n2));
            }
            pvDisplayIf.addLight((PvLightIf)((Object)cloneable));
            if (n2 == this.m_selectedLight) {
                cloneable2 = cloneable;
            }
            ++n2;
        }
        if (cloneable2 != null) {
            pvDisplayIf.selectLight((PvLightIf)((Object)cloneable2));
        }
        pvDisplayIf.setLightingModel(this.getLightingModel());
        Frame frame = pvDisplayIf.getFrame();
        if (frame != null && (cloneable = this.getWindowPosition()) != null) {
            ((Component)frame).setLocation((Point)cloneable);
        }
        if ((cloneable = this.getWindowSize()) != null) {
            pvDisplayIf.setSizeWithinFrame(((Dimension)cloneable).width, ((Dimension)cloneable).height);
        }
        if (this.getTitle() != null) {
            pvDisplayIf.setName(this.getTitle());
        }
        if (this.getOption(2)) {
            pvDisplayIf.center();
        }
        if (this.getOption(3)) {
            pvDisplayIf.fit();
        }
        int n3 = 0;
        while (n3 < this.m_numCameras) {
            PvCameraIf pvCameraIf = pvDisplayIf.getCamera(this.m_cameraProjection[n3]);
            pvCameraIf.saveAsDefault();
            ++n3;
        }
        if (pvDisplayIf instanceof PvDisplay) {
            PvDisplay pvDisplay = (PvDisplay)pvDisplayIf;
            boolean bl = this.m_axesType != -1 && this.getOption(5);
            pvDisplay.showAxes(bl);
            if (bl) {
                PgAxes pgAxes = pvDisplay.getAxes();
                if (pgAxes != null && this.m_numRulers > 0) {
                    pgAxes.reset();
                    pgAxes.setDisplay(pvDisplay);
                    if (this.m_bAxesShowHashingFlags != null) {
                        pgAxes.setHashingsFlags(this.m_bAxesShowHashingFlags);
                    }
                    pgAxes.setCoordSystem(this.getAxesCoordSystem());
                    pgAxes.setNumRulers(this.m_numRulers);
                    if (this.m_axesLabel != null) {
                        pgAxes.setNames(this.m_axesLabel);
                    }
                    pgAxes.showNames(this.getOption(9));
                    pgAxes.showLabels(this.getOption(6));
                    pgAxes.setMode(this.m_axesType);
                    pgAxes.setEnabledAutoBounds(this.getOption(42));
                    pgAxes.setEnabledAutoHashing(this.getOption(41));
                    pgAxes.setEnabledAutoLayout(this.getOption(43));
                    PgRuler[] pgRulerArray = pgAxes.getAxes();
                    if (pgRulerArray != null) {
                        Object object;
                        if (this.m_numRulers > 0) {
                            pgAxes.setAxesColor(this.getRulerColor(0));
                            pgAxes.setAxesSize(this.getRulerSize(0));
                        }
                        if (!this.getOption(42)) {
                            PdVector pdVector = new PdVector(this.m_rulerMinValue);
                            object = new PdVector(this.m_rulerMaxValue);
                            pgAxes.setBounds(new PdVector[]{pdVector, object});
                        }
                        if (this.m_numRulers > 0 && !this.getOption(41)) {
                            pgAxes.setFixedHashings(this.getRulerMajorHashUnit(0), this.getRulerMinorHashUnit(0));
                            pgAxes.setPartitionedHashing(this.getRulerNumMajorHashings(0), this.getRulerNumMinorHashings(0));
                        }
                        int n4 = 0;
                        while (n4 < this.m_numRulers) {
                            object = this.getRulerName(n4);
                            if (object != null) {
                                pgRulerArray[n4].setRulerName(this.getRulerName(n4));
                            }
                            pgRulerArray[n4].showRulerName(this.isShowingRulerName(n4));
                            pgRulerArray[n4].showArrow(this.isShowingRulerArrow(n4));
                            pgRulerArray[n4].showLabels(this.isShowingRulerNumbers(n4));
                            pgRulerArray[n4].setHashMode(this.getRulerMode(n4));
                            pgRulerArray[n4].setGlobalPolygonColor(this.getRulerColor(n4));
                            pgRulerArray[n4].setGlobalPolygonSize(this.getRulerSize(n4));
                            pgRulerArray[n4].showHashingsInNormalDir(this.isShowingRulerHashingsNormal(n4));
                            pgRulerArray[n4].showHashingsInUpDir(this.isShowingRulerHashingsUp(n4));
                            pgRulerArray[n4].showMajorHashings(this.isShowingRulerTicksMajor(n4));
                            pgRulerArray[n4].showMinorHashings(this.isShowingRulerTicksMinor(n4));
                            pgRulerArray[n4].setVisible(this.isShowingRuler(n4));
                            if (!this.getOption(42)) {
                                pgRulerArray[n4].setMinMax(this.getRulerMinValue(n4), this.getRulerMaxValue(n4));
                            }
                            if (!this.getOption(41)) {
                                pgRulerArray[n4].setFixedHashing(this.getRulerMajorHashUnit(n4), this.getRulerMinorHashUnit(n4));
                                pgRulerArray[n4].setPartitionedHashing(this.getRulerNumMajorHashings(n4), this.getRulerNumMinorHashings(n4));
                            }
                            ++n4;
                        }
                    }
                }
                pvDisplay.recomputeAxes();
            }
        }
        pvDisplayIf.setPaintTag(1L, true);
    }

    public int getDimAxes() {
        int n = 3;
        if (this.m_axesType == 9 || this.m_axesType == 3 || this.m_axesType == 4 || this.m_axesType == 5 || this.m_axesType == 6 || this.m_axesType == 7 || this.m_axesType == 8) {
            n = 2;
        }
        return n;
    }

    public int getRulerMode(int n) {
        return this.m_rulerMode[n];
    }

    public void setRulerMode(int n, int n2) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerMode[n] = n2;
    }

    private boolean assureRulerIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numRulers) {
            return true;
        }
        this.setNumRulers(n + 1);
        return true;
    }

    public void setOptions(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing display");
            return;
        }
        this.setOption(1, pvDisplayIf.isEnabledAntiAlias());
        this.setOption(4, pvDisplayIf.isEnabledAnimation());
        this.setOption(5, pvDisplayIf.isShowingAxes());
        this.setBackgroundColor(pvDisplayIf.getBackgroundColor());
        this.setOption(10, pvDisplayIf.isShowingBackgroundImage());
        this.setBackgroundImageFit(pvDisplayIf.getBackgroundImageFit());
        this.setBackgroundImageFile(pvDisplayIf.getBackgroundImageFile());
        this.setBackgroundImage(pvDisplayIf.getBackgroundImage());
        this.setOption(12, pvDisplayIf.isShowingBndBox());
        this.setOption(11, pvDisplayIf.hasPaintTag(4L));
        this.setOption(35, pvDisplayIf.isEnabledBoxRatio());
        this.setOption(13, pvDisplayIf.hasPaintTag(16384L));
        this.setOption(44, pvDisplayIf.hasPaintTag(8192L));
        this.setOption(45, pvDisplayIf.isEnabledClipAutoBounds());
        this.setOption(36, pvDisplayIf.isEnabledClipBounds());
        this.setOption(34, pvDisplayIf.isShowingCopyright());
        this.setOption(14, pvDisplayIf.hasPaintTag(16L));
        this.setOption(15, pvDisplayIf.isShowingDepthcue());
        this.setOption(32, pvDisplayIf.isEnabledDirectSelect());
        this.setOption(16, pvDisplayIf.isEnabledDoubleBuffer());
        this.setOption(17, pvDisplayIf.hasPaintTag(1L));
        this.setOption(18, pvDisplayIf.isShowingEdgeAura());
        this.setOption(40, pvDisplayIf.isShowingEdgesOnce());
        this.setOption(46, pvDisplayIf.isEnabledFillDisplay());
        this.setForegroundColor(pvDisplayIf.getForegroundColor());
        this.setOption(19, pvDisplayIf.isShowingForegroundImage());
        this.setForegroundImageFit(pvDisplayIf.getForegroundImageFit());
        this.setForegroundImageFile(pvDisplayIf.getForegroundImageFile());
        this.setForegroundImage(pvDisplayIf.getForegroundImage());
        this.setOption(20, pvDisplayIf.isShowingFrame());
        this.setOption(21, pvDisplayIf.hasPaintTag(256L));
        this.setOption(39, pvDisplayIf.isEnabledIntegerPick());
        this.setOption(31, pvDisplayIf.isEnabledLocalTransform());
        this.setOption(23, pvDisplayIf.isShowingMagnet());
        this.setOption(24, pvDisplayIf.hasPaintTag(2048L));
        this.setOption(25, pvDisplayIf.isEnabledPainters());
        this.setOption(33, pvDisplayIf.isShowingTitle());
        this.setOption(27, pvDisplayIf.isShowingGrid());
        this.setOption(30, pvDisplayIf.isEnabledZBuffer());
        this.setOption(37, pvDisplayIf.isEnabled3DLook());
        this.setOption(38, pvDisplayIf.isEnabledAdaptiveSize());
        this.setMajorMode(pvDisplayIf.getMajorMode());
        this.setTransformMode(pvDisplayIf.getTransformationMode());
        this.setBndBoxColor(pvDisplayIf.getBndBoxColor());
        this.setBndBoxSize(pvDisplayIf.getBndBoxSize());
        this.setBoxRatio(pvDisplayIf.getBoxRatio());
        this.setClipBoundsType(pvDisplayIf.getClipBoundsType());
        int n = 0;
        do {
            this.setClipBounds(n, pvDisplayIf.getClipBounds(n));
        } while (++n < 3);
        PvCameraIf[] pvCameraIfArray = pvDisplayIf.getCameras();
        int n2 = pvCameraIfArray.length;
        this.setNumCameras(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.setCameraName(n3, pvCameraIfArray[n3].getName());
            this.setCameraProjection(n3, pvCameraIfArray[n3].getProjectionMode());
            this.setCameraPosition(n3, pvCameraIfArray[n3].getPosition());
            this.setCameraInterest(n3, pvCameraIfArray[n3].getInterest());
            this.setCameraFieldOfView(n3, pvCameraIfArray[n3].getFieldOfView());
            this.setCameraRoll(n3, pvCameraIfArray[n3].getRoll());
            this.setEnabledCameraClip(n3, pvCameraIfArray[n3].isEnabledClip());
            this.setCameraNearClip(n3, pvCameraIfArray[n3].getNearClip());
            this.setCameraFarClip(n3, pvCameraIfArray[n3].getFarClip());
            this.setEnabledCameraSceneRatio(n3, pvCameraIfArray[n3].isEnabledSceneRatio());
            ++n3;
        }
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        if (pvCameraIf != null) {
            this.setCurrentCamera(pvCameraIf.getProjectionMode());
        }
        this.setLightingModel(pvDisplayIf.getLightingModel());
        PvLightIf[] pvLightIfArray = pvDisplayIf.getLights();
        PvLightIf pvLightIf = pvDisplayIf.getSelectedLight();
        int n4 = pvDisplayIf.getNumLights();
        this.setNumLights(n4);
        int n5 = 0;
        while (n5 < n4) {
            this.setLightType(n5, pvLightIfArray[n5].getLightType());
            this.setLightName(n5, pvLightIfArray[n5].getName());
            this.setLightReference(n5, pvLightIfArray[n5].getReference());
            this.setLightShading(n5, pvLightIfArray[n5].getShading());
            this.setLightPosition(n5, pvLightIfArray[n5].getPosition());
            this.setLightInterest(n5, pvLightIfArray[n5].getInterest());
            this.setLightColor(n5, pvLightIfArray[n5].getColor());
            this.setLightSwitchedOn(n5, pvLightIfArray[n5].isSwitchedOn());
            this.setLightVisible(n5, pvLightIfArray[n5].isVisible());
            this.setLightIntensity(n5, pvLightIfArray[n5].getIntensity());
            this.setLightHighlight(n5, pvLightIfArray[n5].isHighlight());
            this.setLightExponent(n5, pvLightIfArray[n5].getExponent());
            this.setLightAngle(n5, pvLightIfArray[n5].getAngle());
            this.setLightCorona(n5, pvLightIfArray[n5].getCorona());
            this.setLightFalloff(n5, pvLightIfArray[n5].getFalloff());
            if (pvLightIfArray[n5] == pvLightIf) {
                this.m_selectedLight = n5;
            }
            ++n5;
        }
        Frame frame = pvDisplayIf.getFrame();
        if (frame != null) {
            this.setWindowPosition(frame.getLocation());
        } else {
            this.setWindowPosition(null);
        }
        this.setWindowSize(pvDisplayIf.getSize());
        this.setTitle(pvDisplayIf.getName());
        this.setAxes(((PvDisplay)pvDisplayIf).getAxes());
        if (this.m_axes != null) {
            this.m_axesLabel = this.m_axes.getNames();
            this.m_bAxesShowHashingFlags = this.m_axes.getHashingFlags();
            this.setAxesCoordSystem(this.m_axes.getCoordSystem());
            this.setAxesType(this.m_axes.getMode());
            this.setOption(42, this.m_axes.isEnabledAutoBounds());
            this.setOption(41, this.m_axes.isEnabledAutoHashing());
            this.setOption(43, this.m_axes.isEnabledAutoLayout());
            this.setOption(6, this.m_axes.isShowingLabels());
            this.setOption(9, this.m_axes.isShowingNames());
            this.setNumRulers(this.m_axes.getNumRulers());
            PgRuler[] pgRulerArray = this.m_axes.getAxes();
            if (pgRulerArray != null) {
                int n6 = 0;
                while (n6 < this.m_numRulers) {
                    this.setRulerName(n6, pgRulerArray[n6].getRulerName());
                    this.showRulerName(n6, pgRulerArray[n6].isShowingRulerName());
                    this.showRulerArrow(n6, pgRulerArray[n6].isShowingArrow());
                    this.showRulerNumbers(n6, pgRulerArray[n6].isShowingLabels());
                    this.setRulerMode(n6, pgRulerArray[n6].getHashMode());
                    this.setRulerColor(n6, pgRulerArray[n6].getGlobalPolygonColor());
                    this.setRulerSize(n6, pgRulerArray[n6].getGlobalPolygonSize());
                    this.showRulerHashingsNormal(n6, pgRulerArray[n6].isShowingHashingsInNormalDir());
                    this.showRulerHashingsUp(n6, pgRulerArray[n6].isShowingHashingsInUpDir());
                    this.showRulerTicksMajor(n6, pgRulerArray[n6].isShowingMajorHashings());
                    this.showRulerTicksMinor(n6, pgRulerArray[n6].isShowingMinorHashings());
                    this.showRuler(n6, pgRulerArray[n6].isVisible());
                    this.setRulerMinValue(n6, pgRulerArray[n6].getMinParameter());
                    this.setRulerMaxValue(n6, pgRulerArray[n6].getMaxParameter());
                    this.setRulerMinorHashUnit(n6, pgRulerArray[n6].getMinorUnit());
                    this.setRulerMajorHashUnit(n6, pgRulerArray[n6].getMajorUnit());
                    this.setRulerNumMinorHashings(n6, pgRulerArray[n6].getNumMinorPartitions());
                    this.setRulerNumMajorHashings(n6, pgRulerArray[n6].getNumMajorPartitions());
                    ++n6;
                }
            }
        }
    }

    public boolean isShowingRulerTicksMinor(int n) {
        return this.m_bShowRulerTicksMinor[n];
    }

    public void showRulerTicksMinor(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerTicksMinor[n] = bl;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public String getBackgroundImageFile() {
        return this.m_backgroundImageFile;
    }

    public void setBackgroundImageFile(String string) {
        this.m_backgroundImageFile = string;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PdVector getCameraInterest(int n) {
        return this.m_cameraInterest[n];
    }

    public void setCameraInterest(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraInterest[n].copy(pdVector);
    }

    public int getLightType(int n) {
        return this.m_lightType[n];
    }

    public void setLightType(int n, int n2) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightType[n] = n2;
        if (n2 == 5) {
            this.m_lightReference[n] = 1;
            return;
        }
        if (n2 == 2) {
            this.m_bLightHighlight[n] = true;
        }
    }

    public PdVector getLightInterest(int n) {
        return this.m_lightInterest[n];
    }

    public void setLightInterest(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightInterest[n] = pdVector;
    }

    public int getNumCameras() {
        return this.m_numCameras;
    }

    public void setNumCameras(int n) {
        if (n < 0) {
            PsDebug.warning("num = " + n + " < 0");
            return;
        }
        if (n == this.m_numCameras) {
            return;
        }
        this.m_numCameras = n;
        this.m_cameraName = PuData.realloc(this.m_cameraName, this.m_numCameras);
        this.m_cameraProjection = PuData.realloc(this.m_cameraProjection, this.m_numCameras, 0);
        this.m_cameraPosition = PdVector.realloc(this.m_cameraPosition, this.m_numCameras, this.m_dim);
        this.m_cameraInterest = PdVector.realloc(this.m_cameraInterest, this.m_numCameras, this.m_dim);
        this.m_cameraFieldOfView = PuData.realloc(this.m_cameraFieldOfView, this.m_numCameras, 0.0);
        this.m_cameraRoll = PuData.realloc(this.m_cameraRoll, this.m_numCameras, 0.0);
        this.m_bCameraEnableClip = PuData.realloc(this.m_bCameraEnableClip, this.m_numCameras, false);
        this.m_cameraNearClip = PuData.realloc(this.m_cameraNearClip, this.m_numCameras, 10.0);
        this.m_cameraFarClip = PuData.realloc(this.m_cameraFarClip, this.m_numCameras, -10.0);
        this.m_bCameraSceneRatio = PuData.realloc(this.m_bCameraSceneRatio, this.m_numCameras, false);
    }

    public boolean isShowingRulerHashingsNormal(int n) {
        return this.m_bShowRulerHashingsNormal[n];
    }

    public void showRulerHashingsNormal(int n, boolean bl) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_bShowRulerHashingsNormal[n] = bl;
    }

    public String[] getSearchPaths() {
        return this.m_searchPath;
    }

    public void setSearchPaths(String[] stringArray) {
        this.m_searchPath = stringArray;
    }

    public double getBndBoxSize() {
        return this.m_bndBoxSize;
    }

    public void setBndBoxSize(double d) {
        this.m_bndBoxSize = d;
    }

    public int getNumRulers() {
        return this.m_numRulers;
    }

    public void setNumRulers(int n) {
        if (n < 0) {
            PsDebug.warning("num = " + n + " < 0");
            return;
        }
        if (n == this.m_numRulers) {
            return;
        }
        this.m_numRulers = n;
        this.m_rulerMode = PuData.realloc(this.m_rulerMode, this.m_numRulers);
        this.m_rulerColor = PdColor.realloc(this.m_rulerColor, this.m_numRulers);
        this.m_rulerSize = PuData.realloc(this.m_rulerSize, this.m_numRulers);
        this.m_rulerName = PuData.realloc(this.m_rulerName, this.m_numRulers);
        this.m_bShowRulerName = PuData.realloc(this.m_bShowRulerName, this.m_numRulers);
        this.m_bShowRulerArrow = PuData.realloc(this.m_bShowRulerArrow, this.m_numRulers);
        this.m_bShowRulerNumbers = PuData.realloc(this.m_bShowRulerNumbers, this.m_numRulers);
        this.m_bShowRulerHashingsNormal = PuData.realloc(this.m_bShowRulerHashingsNormal, this.m_numRulers);
        this.m_bShowRulerHashingsUp = PuData.realloc(this.m_bShowRulerHashingsUp, this.m_numRulers);
        this.m_bShowRulerTicksMajor = PuData.realloc(this.m_bShowRulerTicksMajor, this.m_numRulers);
        this.m_bShowRulerTicksMinor = PuData.realloc(this.m_bShowRulerTicksMinor, this.m_numRulers);
        this.m_bShowRuler = PuData.realloc(this.m_bShowRuler, this.m_numRulers);
        this.m_rulerMinValue = PuData.realloc(this.m_rulerMinValue, this.m_numRulers);
        this.m_rulerMaxValue = PuData.realloc(this.m_rulerMaxValue, this.m_numRulers);
        this.m_rulerMinorHashUnit = PuData.realloc(this.m_rulerMinorHashUnit, this.m_numRulers);
        this.m_rulerMajorHashUnit = PuData.realloc(this.m_rulerMajorHashUnit, this.m_numRulers);
        this.m_rulerNumMinorHashings = PuData.realloc(this.m_rulerNumMinorHashings, this.m_numRulers);
        this.m_rulerNumMajorHashings = PuData.realloc(this.m_rulerNumMajorHashings, this.m_numRulers);
        int n2 = 0;
        while (n2 < this.m_numRulers) {
            this.showRulerName(n2, this.getOption(9));
            this.showRulerNumbers(n2, this.getOption(6));
            this.m_rulerSize[n2] = 1.0;
            ++n2;
        }
    }

    public int getMajorMode() {
        return this.m_majorMode;
    }

    public void setMajorMode(int n) {
        this.m_majorMode = n;
    }

    private boolean assureCameraIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numCameras) {
            return true;
        }
        this.setNumCameras(n + 1);
        return true;
    }

    private boolean assureLightIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numLights) {
            return true;
        }
        this.setNumLights(n + 1);
        return true;
    }

    public double getCameraAngle(int n) {
        return this.getCameraFieldOfView(n);
    }

    public void setCameraAngle(int n, double d) {
        this.setCameraFieldOfView(n, d);
    }

    public double getLightAngle(int n) {
        return this.m_lightAngle[n];
    }

    public void setLightAngle(int n, double d) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightAngle[n] = d;
    }

    public double getRulerSize(int n) {
        return this.m_rulerSize[n];
    }

    public void setRulerSize(int n, double d) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerSize[n] = d;
    }

    public boolean[] getAxesHash() {
        return this.m_bAxesShowHashingFlags;
    }

    public void setAxesHash(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        this.m_bAxesShowHashingFlags = (boolean[])blArray.clone();
    }

    public double getRulerMinValue(int n) {
        return this.m_rulerMinValue[n];
    }

    public void setRulerMinValue(int n, double d) {
        if (!this.assureRulerIndex(n)) {
            return;
        }
        this.m_rulerMinValue[n] = d;
    }
}

