/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PvCameraIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PvDisplayLoader {
    protected BitSet m_geometryOption;
    private int m_jvdVersion = Integer.MAX_VALUE;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    private static void parseOption(PvDisplayOption pvDisplayOption, int n, String string) {
        if (string == null) {
            return;
        }
        pvDisplayOption.setOption(n, string.equalsIgnoreCase("show"));
    }

    protected PvDisplayOption[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        Object[] objectArray;
        Object object;
        Object object2;
        String[] stringArray;
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        if (psXmlNode2.getType() == null || !psXmlNode2.getType().equalsIgnoreCase("jv-disp")) {
            PsDebug.warning("missing <jv-disp> element,\nthis is not a valid JavaView display file.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "meta");
        if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
            int n = 0;
            while (n < psXmlNodeArray.length) {
                int n2;
                stringArray = psXmlNodeArray[n].getAttribute("generator");
                if (stringArray != null && (object2 = stringArray).startsWith("JavaView v.")) {
                    object = object2.substring(object2.indexOf(".") + 1);
                    objectArray = PuString.splitString((String)object, '.');
                    if (objectArray != null && objectArray.length <= 3) {
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            if (n2 == 0) {
                                this.m_jvdVersion = 100000 * Integer.parseInt(objectArray[n2]);
                            } else if (n2 == 1) {
                                this.m_jvdVersion += 1000 * Integer.parseInt(objectArray[n2]);
                            } else if (n2 == 2) {
                                try {
                                    this.m_jvdVersion += Integer.parseInt(objectArray[n2]);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            ++n2;
                        }
                    } else {
                        PsDebug.warning("void JavaView version information in meta tag, generator = " + (String)object2);
                    }
                }
                if ((stringArray = psXmlNodeArray[n].getAttribute("dtd")) != null && (object2 = PuString.splitString((String)stringArray, '.')) != null && ((String[])object2).length > 0) {
                    object = new int[((String[])object2).length];
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        if (n3 == 0) {
                            this.m_jvdVersion = 100000 * Integer.parseInt(object2[n3]);
                        } else if (n3 == 1) {
                            this.m_jvdVersion += 1000 * Integer.parseInt(object2[n3]);
                        } else if (n3 == 2) {
                            this.m_jvdVersion += Integer.parseInt(object2[n3]);
                        }
                        object[n3] = Integer.parseInt(object2[n3]);
                        ++n3;
                    }
                    objectArray = PsConfig.getVersion(12);
                    n2 = 0;
                    while (n2 < Math.min(1, ((String[])object2).length)) {
                        if (objectArray[n2] != object[n2]) {
                            if (objectArray[n2] > object[n2]) break;
                            PsDebug.message("Parsing a JVD file with jv-disp.dtd version=" + (String)stringArray + " which is newer than\n" + "\tversion=" + (int)objectArray[0] + "." + (int)objectArray[1] + "." + (int)objectArray[2] + " implemented by the loader of this JavaView program." + "\n\tMight need to upgrade JavaView.", false);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        String string = null;
        stringArray = null;
        object2 = null;
        object = PsXmlSrc.getRsrcNode(psXmlNode2, "version");
        if (object == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            stringArray = "dump";
        } else {
            string = ((PsXmlNode)object).getContent();
            stringArray = ((PsXmlNode)object).getAttribute("type");
        }
        objectArray = PsXmlSrc.getRsrc(psXmlNode2, "title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode2, "authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode3 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.setXmlNode(psXmlNode3);
        }
        object2 = (psXmlNode = PsXmlSrc.getRsrcNode(psXmlNode2, "description")) != null ? PsXmlSrc.getRsrc(psXmlNode, "abstract") : PsXmlSrc.getRsrc(psXmlNode2, "abstract");
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode2, "displays");
        if (psXmlNode4 == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] stringArray2 = new String[]{"tag", "name"};
        PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode4, "display");
        if (psXmlNodeArray2 == null || psXmlNodeArray2.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[psXmlNodeArray2.length];
        int n = 0;
        while (n < psXmlNodeArray2.length) {
            String string2;
            int n4;
            PsXmlNode psXmlNode5;
            Object object3;
            Object object4;
            int n5;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            int n6;
            Object object12;
            Object object13;
            pvDisplayOptionArray[n] = new PvDisplayOption();
            pvDisplayOptionArray[n].setVersion(string);
            pvDisplayOptionArray[n].setVersionType((String)stringArray);
            pvDisplayOptionArray[n].setAuthorInfo(psAuthorInfo);
            pvDisplayOptionArray[n].setAbstract((String)object2);
            String string3 = psXmlNodeArray2[n].getAttribute("name");
            if (objectArray != null) {
                pvDisplayOptionArray[n].setTitle((String)objectArray);
            } else {
                pvDisplayOptionArray[n].setTitle(string3);
            }
            pvDisplayOptionArray[n].setName(string3);
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 1, psXmlNodeArray2[n].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 4, psXmlNodeArray2[n].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 5, psXmlNodeArray2[n].getAttribute("axes"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 6, psXmlNodeArray2[n].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 11, psXmlNodeArray2[n].getAttribute("border"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 12, psXmlNodeArray2[n].getAttribute("boundingBox"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 13, psXmlNodeArray2[n].getAttribute("center"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 44, psXmlNodeArray2[n].getAttribute("clearScreen"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 34, psXmlNodeArray2[n].getAttribute("copyright"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 14, psXmlNodeArray2[n].getAttribute("cross"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 15, psXmlNodeArray2[n].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 16, psXmlNodeArray2[n].getAttribute("doubleBuffer"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 17, psXmlNodeArray2[n].getAttribute("drawing"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 18, psXmlNodeArray2[n].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 40, psXmlNodeArray2[n].getAttribute("edgesOnce"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 46, psXmlNodeArray2[n].getAttribute("fillDisplay"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 20, psXmlNodeArray2[n].getAttribute("frame"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 21, psXmlNodeArray2[n].getAttribute("info"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 39, psXmlNodeArray2[n].getAttribute("integerPick"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 23, psXmlNodeArray2[n].getAttribute("magnet"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 24, psXmlNodeArray2[n].getAttribute("single"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 25, psXmlNodeArray2[n].getAttribute("sorting"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 33, psXmlNodeArray2[n].getAttribute("title"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 26, psXmlNodeArray2[n].getAttribute("visible"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 27, psXmlNodeArray2[n].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 28, psXmlNodeArray2[n].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 29, psXmlNodeArray2[n].getAttribute("yzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 30, psXmlNodeArray2[n].getAttribute("zBuffer"));
            String string4 = psXmlNodeArray2[n].getAttribute("3dLook");
            if (string4 != null) {
                PsDebug.warning("found deprecated display attribute \"3dLook\", change to \"thickLook\"");
                PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 37, string4);
            }
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 37, psXmlNodeArray2[n].getAttribute("thickLook"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 38, psXmlNodeArray2[n].getAttribute("adaptiveSize"));
            PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "axes");
            if (psXmlNode6 != null) {
                object13 = psXmlNode6.getAttribute("longHash");
                if (object13 != null && ((String)object13).length() == 6) {
                    object12 = new boolean[6];
                    object13 = ((String)object13).toLowerCase();
                    n6 = 0;
                    do {
                        object12[n6] = ((String)object13).charAt(n6) == 't';
                    } while (++n6 < 6);
                    pvDisplayOptionArray[n].setAxesHash((boolean[])object12);
                }
                object12 = psXmlNode6.getAttribute("dim");
                int n7 = 3;
                if (object12 != null && ((String)object12).equalsIgnoreCase("2")) {
                    n7 = 2;
                }
                if ((object11 = psXmlNode6.getAttribute("visible")) != null && ((String)object11).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(5, true);
                }
                if ((object10 = psXmlNode6.getAttribute("autoBounds")) != null && ((String)object10).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(42, false);
                }
                if ((object9 = psXmlNode6.getAttribute("autoHashing")) == null) {
                    object9 = psXmlNode6.getAttribute("autoConfigure");
                }
                if (object9 != null && ((String)object9).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(41, false);
                }
                if ((object8 = psXmlNode6.getAttribute("autoLayout")) != null && object8.equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(43, false);
                }
                if ((object7 = psXmlNode6.getAttribute("coordSystem")) != null) {
                    if (((String)object7).equalsIgnoreCase("adjust")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(0);
                    } else if (((String)object7).equalsIgnoreCase("scene")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(1);
                    } else if (((String)object7).equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(2);
                    } else if (((String)object7).equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(3);
                    } else {
                        PsDebug.warning("unknown coordinate system of axes, coordSystem = " + (String)object7);
                    }
                }
                if ((object6 = psXmlNode6.getAttribute("type")) == null) {
                    object6 = "center";
                }
                if (object6 != null) {
                    object5 = psXmlNode6.getAttribute("span");
                    if (object5 == null) {
                        object5 = "xy";
                    }
                    if (((String)object6).equalsIgnoreCase("bndbox")) {
                        if (n7 == 2) {
                            pvDisplayOptionArray[n].setAxesType(9);
                        } else {
                            pvDisplayOptionArray[n].setAxesType(2);
                        }
                    } else if (((String)object6).equalsIgnoreCase("center")) {
                        if (n7 == 2) {
                            if (((String)object5).equalsIgnoreCase("xy")) {
                                pvDisplayOptionArray[n].setAxesType(3);
                            } else if (((String)object5).equalsIgnoreCase("yz")) {
                                pvDisplayOptionArray[n].setAxesType(4);
                            } else if (((String)object5).equalsIgnoreCase("zx")) {
                                pvDisplayOptionArray[n].setAxesType(5);
                            } else {
                                PsDebug.warning("unknown span of axes, span = " + (String)object5);
                            }
                        } else {
                            pvDisplayOptionArray[n].setAxesType(0);
                        }
                    } else if (((String)object6).equalsIgnoreCase("corner")) {
                        if (n7 == 2) {
                            if (((String)object5).equalsIgnoreCase("xy")) {
                                pvDisplayOptionArray[n].setAxesType(6);
                            } else if (((String)object5).equalsIgnoreCase("yz")) {
                                pvDisplayOptionArray[n].setAxesType(7);
                            } else if (((String)object5).equalsIgnoreCase("zx")) {
                                pvDisplayOptionArray[n].setAxesType(8);
                            } else {
                                PsDebug.warning("unknown span of axes, span = " + (String)object5);
                            }
                        } else {
                            pvDisplayOptionArray[n].setAxesType(1);
                        }
                    } else {
                        PsDebug.warning("unknown type of axes, type = " + (String)object6);
                    }
                }
                if ((object5 = PsXmlSrc.getRsrcNodes(psXmlNode6, "ruler")) != null) {
                    n5 = ((PsXmlNode[])object5).length;
                    pvDisplayOptionArray[n].setNumRulers(n5);
                    n6 = 0;
                    while (n6 < n5) {
                        Color color;
                        int n8;
                        object4 = ((PsXmlNode)object5[n6]).getAttribute("name");
                        if (object4 != null) {
                            pvDisplayOptionArray[n].setRulerName(n6, (String)object4);
                        }
                        if ((object3 = ((PsXmlNode)object5[n6]).getAttribute("mode")) != null) {
                            if (((String)object3).equalsIgnoreCase("fixed")) {
                                pvDisplayOptionArray[n].setRulerMode(n6, 0);
                            } else if (((String)object3).equalsIgnoreCase("partitioned")) {
                                pvDisplayOptionArray[n].setRulerMode(n6, 1);
                            }
                        }
                        pvDisplayOptionArray[n].showRulerArrow(n6, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "arrow", "show"));
                        pvDisplayOptionArray[n].showRulerName(n6, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "label", "show"));
                        pvDisplayOptionArray[n].showRulerNumbers(n6, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "numbers", "hide"));
                        pvDisplayOptionArray[n].showRulerHashingsNormal(n6, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "hashsNormal", "show"));
                        pvDisplayOptionArray[n].showRulerHashingsUp(n6, PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "hashsUp", "show"));
                        pvDisplayOptionArray[n].showRulerTicksMajor(n6, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "ticksMajor", "hide"));
                        pvDisplayOptionArray[n].showRulerTicksMinor(n6, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "ticksMinor", "hide"));
                        pvDisplayOptionArray[n].showRuler(n6, !PvDisplayLoader.hasAttribute((PsXmlNode)object5[n6], "visible", "hide"));
                        double d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n6], "minValue");
                        if (d != 0.0) {
                            pvDisplayOptionArray[n].setRulerMinValue(n6, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n6], "maxValue")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMaxValue(n6, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n6], "minorUnit")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMinorHashUnit(n6, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n6], "majorUnit")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMajorHashUnit(n6, d);
                        }
                        if (((PsXmlNode)object5[n6]).hasChild("majorHashings") && !((PsXmlNode)object5[n6]).hasChild("minorHashings")) {
                            PsDebug.error("known bug encountered, ruler has majorHashings but no minorHashings.\n\tThis is a known bug of the JavaView, todo: correct your JVD file!");
                        }
                        if ((n8 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[n6], "minorHashings")) != 0) {
                            pvDisplayOptionArray[n].setRulerNumMinorHashings(n6, n8);
                        }
                        if ((n8 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[n6], "majorHashings")) != 0) {
                            pvDisplayOptionArray[n].setRulerNumMajorHashings(n6, n8);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object5[n6], "color")) != null) {
                            pvDisplayOptionArray[n].setRulerColor(n6, color);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n6], "thickness")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerSize(n6, d);
                        }
                        ++n6;
                    }
                }
            }
            if ((object13 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "bndbox")) != null) {
                double d;
                Color color;
                object12 = ((PsXmlNode)object13).getAttribute("visible");
                if (object12 != null && ((String)object12).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(12, true);
                }
                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object13, "color")) != null) {
                    pvDisplayOptionArray[n].setBndBoxColor(color);
                }
                if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object13, "thickness")) != 0.0) {
                    pvDisplayOptionArray[n].setBndBoxSize(d);
                }
            }
            if ((object12 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "boxRatio")) != null) {
                String string5 = ((PsXmlNode)object12).getAttribute("visible");
                if (string5 != null && string5.equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(35, true);
                }
                if ((object11 = PsXmlLoader.parsePdVector((PsXmlNode)object12, null)) != null) {
                    pvDisplayOptionArray[n].setBoxRatio((PdVector)object11);
                }
            }
            if ((psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "clipRange")) != null) {
                int n9;
                object11 = new String("XYZ");
                object10 = psXmlNode5.getAttribute("autoBounds");
                if (object10 != null && ((String)object10).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(45, false);
                }
                if ((object9 = psXmlNode5.getAttribute("select")) != null) {
                    n9 = ((String)object11).indexOf((String)object9);
                    if (n9 < 0) {
                        PsDebug.warning("unknown range type, select = " + (String)object9);
                        n9 = 0;
                    }
                    pvDisplayOptionArray[n].setClipBoundsType(n9);
                }
                if ((object8 = psXmlNode5.getAttribute("visible")) != null && object8.equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(36, true);
                }
                if ((object7 = PsXmlSrc.getRsrcNodes(psXmlNode5, "range")) != null && ((PsXmlNode[])object7).length > 0) {
                    n6 = 0;
                    while (n6 < ((PsXmlNode[])object7).length) {
                        object6 = ((PsXmlNode)object7[n6]).getAttribute("type");
                        n9 = ((String)object11).indexOf((String)object6);
                        if (n9 < 0) {
                            PsDebug.warning("unknown range type = " + (String)object6);
                            n9 = n6;
                        }
                        if ((object5 = PsXmlLoader.parsePdVector((PsXmlNode)object7[n6], null)) != null && ((PdVector)object5).getSize() == 2) {
                            pvDisplayOptionArray[n].setClipBounds(n9, ((PdVector)object5).m_data);
                        }
                        ++n6;
                    }
                }
            }
            if ((object11 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "cameras")) != null) {
                object10 = ((PsXmlNode)object11).getAttribute("select");
                int n10 = -1;
                n6 = 0;
                while (n6 < PvCameraIf.CAMERA_NAME.length) {
                    if (((String)object10).equals(PvCameraIf.CAMERA_NAME[n6])) {
                        n10 = n6;
                        break;
                    }
                    if (((String)object10).equals(PvCameraIf.CAMERA_NAME[n6] + " Projection")) {
                        n10 = n6;
                        break;
                    }
                    ++n6;
                }
                if (n10 == -1) {
                    PsDebug.warning("unknown selected camera type = " + (String)object10);
                    n10 = 0;
                }
                pvDisplayOptionArray[n].setCurrentCamera(n10);
                object8 = PsXmlSrc.getRsrcNodes((PsXmlNode)object11, "camera");
                if (object8 != null) {
                    pvDisplayOptionArray[n].setNumCameras(((PsXmlNode[])object8).length);
                    n4 = 0;
                    while (n4 < ((PsXmlNode[])object8).length) {
                        PsXmlNode psXmlNode7;
                        double d;
                        object7 = object8[n4].getAttribute("name");
                        if (object7 != null) {
                            pvDisplayOptionArray[n].setCameraName(n4, (String)object7);
                        }
                        if ((object6 = object8[n4].getAttribute("sceneRatio")) != null && ((String)object6).equalsIgnoreCase("show")) {
                            pvDisplayOptionArray[n].setEnabledCameraSceneRatio(n4, true);
                        }
                        object10 = object8[n4].getAttribute("projection");
                        int n11 = -1;
                        n6 = 0;
                        while (n6 < PvCameraIf.CAMERA_NAME.length) {
                            if (((String)object10).equals(PvCameraIf.CAMERA_NAME[n6])) {
                                n11 = n6;
                                break;
                            }
                            if (((String)object10).equals(PvCameraIf.CAMERA_NAME[n6] + " Projection")) {
                                n11 = n6;
                                break;
                            }
                            ++n6;
                        }
                        if (n11 == -1) {
                            PsDebug.warning("unknown type of camera[" + n6 + "], type = " + (String)object10);
                            n11 = 0;
                        }
                        pvDisplayOptionArray[n].setCameraProjection(n4, n11);
                        PdVector pdVector = PsXmlLoader.parsePdVector(object8[n4], "position", stringArray2);
                        if (pdVector != null) {
                            pvDisplayOptionArray[n].setCameraPosition(n4, pdVector);
                        }
                        if ((pdVector = PsXmlLoader.parsePdVector(object8[n4], "interest", stringArray2)) != null) {
                            pvDisplayOptionArray[n].setCameraInterest(n4, pdVector);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(object8[n4], "fieldOfView")) == 53.13) {
                            d = 0.0;
                        }
                        pvDisplayOptionArray[n].setCameraFieldOfView(n4, d);
                        d = PsXmlSrc.getRsrcAsDouble(object8[n4], "roll");
                        if (d != 0.0) {
                            pvDisplayOptionArray[n].setCameraRoll(n4, d);
                        }
                        if ((psXmlNode7 = PsXmlSrc.getRsrcNode(object8[n4], "clipping")) != null) {
                            string2 = psXmlNode7.getAttribute("enable");
                            if (string2 != null && string2.equalsIgnoreCase("show")) {
                                pvDisplayOptionArray[n].setEnabledCameraClip(n4, true);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble(object8[n4], "near")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraNearClip(n4, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble(object8[n4], "far")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraFarClip(n4, d);
                            }
                        }
                        ++n4;
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            if ((object10 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "lights")) != null) {
                String string6 = ((PsXmlNode)object10).getAttribute("lightingModel");
                if (string6 != null) {
                    pvDisplayOptionArray[n].setLightingModelAsString(string6);
                }
                if ((object8 = ((PsXmlNode)object10).getAttribute("select")) != null) {
                    pvDisplayOptionArray[n].setSelectedLight(Integer.parseInt((String)object8));
                }
                if ((object7 = PsXmlSrc.getRsrcNodes((PsXmlNode)object10, "light")) != null) {
                    pvDisplayOptionArray[n].setNumLights(((PsXmlNode[])object7).length);
                    n4 = 0;
                    while (n4 < ((PsXmlNode[])object7).length) {
                        double d;
                        String string7;
                        object6 = ((PsXmlNode)object7[n4]).getAttribute("name");
                        if (object6 != null) {
                            pvDisplayOptionArray[n].setLightName(n4, (String)object6);
                        }
                        if ((string7 = ((PsXmlNode)object7[n4]).getAttribute("type")) != null) {
                            if (string7.equalsIgnoreCase("ambient")) {
                                pvDisplayOptionArray[n].setLightType(n4, 0);
                            } else if (string7.equalsIgnoreCase("direction")) {
                                pvDisplayOptionArray[n].setLightType(n4, 1);
                            } else if (string7.equalsIgnoreCase("point")) {
                                pvDisplayOptionArray[n].setLightType(n4, 2);
                            } else if (string7.equalsIgnoreCase("spot")) {
                                pvDisplayOptionArray[n].setLightType(n4, 3);
                            } else if (string7.equalsIgnoreCase("shadow")) {
                                pvDisplayOptionArray[n].setLightType(n4, 4);
                            } else if (string7.equalsIgnoreCase("head")) {
                                pvDisplayOptionArray[n].setLightType(n4, 5);
                            } else if (string7.equalsIgnoreCase("sky")) {
                                pvDisplayOptionArray[n].setLightType(n4, 6);
                            } else {
                                PsDebug.warning("unknown light type = " + string7);
                                pvDisplayOptionArray[n].setLightType(n4, 1);
                            }
                        } else {
                            pvDisplayOptionArray[n].setLightType(n4, 1);
                        }
                        String string8 = ((PsXmlNode)object7[n4]).getAttribute("highlight");
                        if (string8 != null) {
                            pvDisplayOptionArray[n].setLightHighlight(n4, string8.equalsIgnoreCase("on"));
                        }
                        if ((object4 = ((PsXmlNode)object7[n4]).getAttribute("reference")) != null) {
                            if (((String)object4).equalsIgnoreCase("camera")) {
                                pvDisplayOptionArray[n].setLightReference(n4, 1);
                            } else if (((String)object4).equalsIgnoreCase("scene")) {
                                pvDisplayOptionArray[n].setLightReference(n4, 0);
                            } else {
                                PsDebug.warning("unknown light reference = " + (String)object4);
                                pvDisplayOptionArray[n].setLightReference(n4, 0);
                            }
                        }
                        if ((object3 = ((PsXmlNode)object7[n4]).getAttribute("shading")) != null) {
                            if (((String)object3).equalsIgnoreCase("symmetric")) {
                                pvDisplayOptionArray[n].setLightShading(n4, 0);
                            } else if (((String)object3).equalsIgnoreCase("halfSphere")) {
                                pvDisplayOptionArray[n].setLightShading(n4, 1);
                            } else if (((String)object3).equalsIgnoreCase("fullSphere")) {
                                pvDisplayOptionArray[n].setLightShading(n4, 2);
                            } else {
                                PsDebug.warning("unknown light shading = " + (String)object3);
                                pvDisplayOptionArray[n].setLightReference(n4, 0);
                            }
                        }
                        String string9 = ((PsXmlNode)object7[n4]).getAttribute("switch");
                        pvDisplayOptionArray[n].setLightSwitchedOn(n4, string9 == null || string9.equalsIgnoreCase("on"));
                        string2 = ((PsXmlNode)object7[n4]).getAttribute("visible");
                        pvDisplayOptionArray[n].setLightVisible(n4, string2 != null && string2.equalsIgnoreCase("show"));
                        if (string7 != null && string7.equalsIgnoreCase("head") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[n].setLightReference(n4, 1);
                            pvDisplayOptionArray[n].setLightShading(n4, 0);
                            pvDisplayOptionArray[n].setLightPosition(n4, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[n].setLightInterest(n4, new PdVector(0.0, 0.0, 0.0));
                        } else if (string7 != null && string7.equalsIgnoreCase("sky") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[n].setLightReference(n4, 0);
                            pvDisplayOptionArray[n].setLightShading(n4, 0);
                            pvDisplayOptionArray[n].setLightPosition(n4, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[n].setLightInterest(n4, new PdVector(0.0, 0.0, 0.0));
                        } else {
                            PdVector pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object7[n4], "position", stringArray2);
                            if (pdVector != null) {
                                pvDisplayOptionArray[n].setLightPosition(n4, pdVector);
                            }
                            if ((pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object7[n4], "interest", stringArray2)) != null) {
                                pvDisplayOptionArray[n].setLightInterest(n4, pdVector);
                            }
                        }
                        Color color = PsXmlLoader.parseColorRGB((PsXmlNode)object7[n4], "color");
                        if (color != null) {
                            pvDisplayOptionArray[n].setLightColor(n4, color);
                        }
                        double d2 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n4], "intensity");
                        pvDisplayOptionArray[n].setLightIntensity(n4, d2);
                        if (((PsXmlNode)object7[n4]).hasChild("angle")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n4], "angle");
                            pvDisplayOptionArray[n].setLightAngle(n4, d);
                        }
                        if (((PsXmlNode)object7[n4]).hasChild("corona")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n4], "corona");
                            pvDisplayOptionArray[n].setLightCorona(n4, d);
                        }
                        if (((PsXmlNode)object7[n4]).hasChild("exponent")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n4], "exponent");
                            pvDisplayOptionArray[n].setLightExponent(n4, d);
                        }
                        if (((PsXmlNode)object7[n4]).hasChild("falloff")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n4], "falloff");
                            pvDisplayOptionArray[n].setLightFalloff(n4, d);
                        }
                        ++n4;
                    }
                }
            }
            if ((object9 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "transform")) != null) {
                String string10;
                object8 = ((PsXmlNode)object9).getAttribute("majorMode");
                if (object8 != null) {
                    if (object8.equalsIgnoreCase("rotate")) {
                        pvDisplayOptionArray[n].setMajorMode(0);
                    } else if (object8.equalsIgnoreCase("rotate-xy")) {
                        pvDisplayOptionArray[n].setMajorMode(17);
                    } else if (object8.equalsIgnoreCase("scale")) {
                        pvDisplayOptionArray[n].setMajorMode(1);
                    } else if (object8.equalsIgnoreCase("translate")) {
                        pvDisplayOptionArray[n].setMajorMode(3);
                    } else if (object8.equalsIgnoreCase("translate-z")) {
                        pvDisplayOptionArray[n].setMajorMode(4);
                    } else if (object8.equalsIgnoreCase("initial")) {
                        pvDisplayOptionArray[n].setMajorMode(6);
                    } else if (object8.equalsIgnoreCase("pick")) {
                        pvDisplayOptionArray[n].setMajorMode(5);
                    } else {
                        PsDebug.warning("unknown major mode = " + (String)object8);
                    }
                }
                if ((object7 = ((PsXmlNode)object9).getAttribute("localTransform")) != null && ((String)object7).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(31, true);
                }
                if ((object6 = ((PsXmlNode)object9).getAttribute("directSelect")) != null && ((String)object6).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(32, true);
                }
                if ((string10 = ((PsXmlNode)object9).getAttribute("mode")) != null) {
                    if (string10.equalsIgnoreCase("camera")) {
                        pvDisplayOptionArray[n].setTransformMode(0);
                    } else if (string10.equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[n].setTransformMode(1);
                    } else if (string10.equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[n].setTransformMode(2);
                    } else {
                        PsDebug.warning("unknown transform mode = " + string10);
                    }
                }
            }
            if ((object8 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "background")) != null) {
                PsXmlNode psXmlNode8;
                object7 = PsXmlLoader.parseColorRGB((PsXmlNode)object8, "color");
                if (object7 != null) {
                    pvDisplayOptionArray[n].setBackgroundColor((Color)object7);
                }
                object6 = object8.getAttribute("image");
                pvDisplayOptionArray[n].setOption(10, object6 != null && ((String)object6).equalsIgnoreCase("show"));
                String string11 = object8.getAttribute("imageFit");
                if (string11 != null) {
                    if (string11.equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(0);
                    } else if (string11.equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(1);
                    } else if (string11.equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(2);
                    } else if (string11.equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(3);
                    }
                }
                if ((psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)object8, "image")) != null && (object4 = PsXmlSrc.getRsrcNode(psXmlNode8, "url")) != null) {
                    pvDisplayOptionArray[n].setBackgroundImageFile(((PsXmlNode)object4).getContent());
                }
            }
            if ((object7 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "foreground")) != null) {
                object6 = PsXmlLoader.parseColorRGB((PsXmlNode)object7, "color");
                if (object6 != null) {
                    pvDisplayOptionArray[n].setForegroundColor((Color)object6);
                }
                String string12 = ((PsXmlNode)object7).getAttribute("image");
                pvDisplayOptionArray[n].setOption(19, string12 != null && string12.equalsIgnoreCase("show"));
                String string13 = ((PsXmlNode)object7).getAttribute("imageFit");
                if (string13 != null) {
                    if (string13.equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(0);
                    } else if (string13.equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(1);
                    } else if (string13.equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(2);
                    } else if (string13.equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(3);
                    }
                }
                if ((object4 = PsXmlSrc.getRsrcNode((PsXmlNode)object7, "image")) != null && (object3 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "url")) != null) {
                    pvDisplayOptionArray[n].setForegroundImageFile(((PsXmlNode)object3).getContent());
                }
            }
            if ((object6 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "window")) != null) {
                PsXmlNode psXmlNode9 = PsXmlSrc.getRsrcNode((PsXmlNode)object6, "x");
                if (psXmlNode9 != null) {
                    n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object6, "x");
                    int n12 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object6, "y");
                    pvDisplayOptionArray[n].setWindowPosition(new Point(n5, n12));
                }
                n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object6, "width");
                int n13 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object6, "height");
                pvDisplayOptionArray[n].setWindowSize(new Dimension(n5, n13));
            }
            ++n;
        }
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = this.read(bufferedReader);
        if (pvDisplayOptionArray != null && pvDisplayOptionArray.length > 0) {
            String[] stringArray = new String[]{PsUtil.getFilePath(string)};
            int n = 0;
            while (n < pvDisplayOptionArray.length) {
                pvDisplayOptionArray[n].setSearchPaths(stringArray);
                ++n;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parsing XML in reader");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = this.parseRsrcTree(psXmlSrc);
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("failed to interpret content of JVD in reader");
            return null;
        }
        return pvDisplayOptionArray;
    }

    private static boolean hasAttribute(PsXmlNode psXmlNode, String string, String string2) {
        return PvDisplayLoader.hasAttribute(psXmlNode.getAttribute(string), string2);
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    public String write(PvDisplayOption[] pvDisplayOptionArray) {
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pvDisplayOptionArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PvDisplayOption[] pvDisplayOptionArray) {
        PsXmlNode psXmlNode;
        Object object;
        Object object2;
        Serializable serializable;
        PsXmlNode psXmlNode2;
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jv-disp");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        psXmlSrc.setDocName("jv-disp");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-disp.dtd");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
        }
        if (bl) {
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
            serializable = psXmlNode2.addChild("meta");
            object2 = PsConfig.getVersion(12);
            object = String.valueOf((int)object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf((int)object2[1]);
            if (object2[2] != false) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf((int)object2[2]);
            }
            ((PsXmlNode)serializable).addAttribute("dtd", (String)object);
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("date", new Date().toString());
            psXmlNode = psXmlNode2.addChild("version", pvDisplayOptionArray[0].getVersion());
            psXmlNode.addAttribute("type", pvDisplayOptionArray[0].getVersionType());
            if (pvDisplayOptionArray[0].getTitle() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getTitle());
            } else if (pvDisplayOptionArray[0].getName() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getName());
            }
        }
        if (bl2 && (serializable = pvDisplayOptionArray[0].getAuthorInfo()) != null && ((PsAuthorInfo)serializable).getNumAuthors() > 0 && (object2 = ((PsAuthorInfo)serializable).getXmlNode()) != null) {
            psXmlNode2.addChild((PsXmlNode)object2);
        }
        if (bl3 && pvDisplayOptionArray[0].getAbstract() != null) {
            serializable = psXmlNode2.addChild("description");
            ((PsXmlNode)serializable).addChild("abstract", pvDisplayOptionArray[0].getAbstract());
        }
        serializable = psXmlNode2.addChild("displays");
        int n = 0;
        while (n < pvDisplayOptionArray.length) {
            Dimension dimension;
            Serializable serializable2;
            int n2;
            int n3;
            String string;
            PsXmlNode psXmlNode3;
            int n4;
            PsXmlNode psXmlNode4;
            int n5;
            Object[] objectArray;
            object = ((PsXmlNode)serializable).addChild("display");
            ((PsXmlNode)object).addAttribute("name", pvDisplayOptionArray[n].getName());
            if (pvDisplayOptionArray[n].getOption(1)) {
                ((PsXmlNode)object).addAttribute("antiAlias", "show");
            }
            if (pvDisplayOptionArray[n].getOption(4)) {
                ((PsXmlNode)object).addAttribute("autoRotate", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(11)) {
                ((PsXmlNode)object).addAttribute("border", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(13)) {
                ((PsXmlNode)object).addAttribute("center", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(44)) {
                ((PsXmlNode)object).addAttribute("clearScreen", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(34)) {
                ((PsXmlNode)object).addAttribute("copyright", "show");
            }
            if (pvDisplayOptionArray[n].getOption(14)) {
                ((PsXmlNode)object).addAttribute("cross", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(15)) {
                ((PsXmlNode)object).addAttribute("depthcue", "hide");
            }
            if (!pvDisplayOptionArray[n].getOption(16)) {
                ((PsXmlNode)object).addAttribute("doubleBuffer", "hide");
            }
            if (!pvDisplayOptionArray[n].getOption(17)) {
                ((PsXmlNode)object).addAttribute("drawing", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(18)) {
                ((PsXmlNode)object).addAttribute("edgeAura", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(40)) {
                ((PsXmlNode)object).addAttribute("edgesOnce", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(46)) {
                ((PsXmlNode)object).addAttribute("fillDisplay", "show");
            }
            if (pvDisplayOptionArray[n].getOption(20)) {
                ((PsXmlNode)object).addAttribute("frame", "show");
            }
            if (pvDisplayOptionArray[n].getOption(21)) {
                ((PsXmlNode)object).addAttribute("info", "show");
            }
            if (pvDisplayOptionArray[n].getOption(39)) {
                ((PsXmlNode)object).addAttribute("integerPick", "show");
            }
            if (pvDisplayOptionArray[n].getOption(23)) {
                ((PsXmlNode)object).addAttribute("magnet", "show");
            }
            if (pvDisplayOptionArray[n].getOption(24)) {
                ((PsXmlNode)object).addAttribute("single", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(25)) {
                ((PsXmlNode)object).addAttribute("sorting", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(37)) {
                ((PsXmlNode)object).addAttribute("thickLook", "show");
            }
            if (pvDisplayOptionArray[n].getOption(33)) {
                ((PsXmlNode)object).addAttribute("title", "show");
            }
            if (!pvDisplayOptionArray[n].getOption(26)) {
                ((PsXmlNode)object).addAttribute("visible", "hide");
            }
            if (pvDisplayOptionArray[n].getOption(27)) {
                ((PsXmlNode)object).addAttribute("xyGrid", "show");
            }
            if (pvDisplayOptionArray[n].getOption(28)) {
                ((PsXmlNode)object).addAttribute("xzGrid", "show");
            }
            if (pvDisplayOptionArray[n].getOption(29)) {
                ((PsXmlNode)object).addAttribute("yzGrid", "show");
            }
            if (pvDisplayOptionArray[n].getOption(30)) {
                ((PsXmlNode)object).addAttribute("zBuffer", "show");
            }
            if (pvDisplayOptionArray[n].getOption(38)) {
                ((PsXmlNode)object).addAttribute("adaptiveSize", "show");
            }
            if (pvDisplayOptionArray[n].getAxes() != null) {
                int n6;
                psXmlNode = ((PsXmlNode)object).addChild("axes");
                psXmlNode.addAttribute("name", pvDisplayOptionArray[n].getAxes().getName());
                objectArray = pvDisplayOptionArray[n].getAxesHash();
                if (objectArray != null) {
                    char[] cArray = new char[6];
                    n6 = 0;
                    do {
                        cArray[n6] = objectArray[n6] ? 116 : 102;
                    } while (++n6 < 6);
                    psXmlNode.addAttribute("longHash", String.valueOf(cArray));
                }
                if (!pvDisplayOptionArray[n].getOption(42)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (!pvDisplayOptionArray[n].getOption(41)) {
                    psXmlNode.addAttribute("autoHashing", "hide");
                }
                if (!pvDisplayOptionArray[n].getOption(43)) {
                    psXmlNode.addAttribute("autoLayout", "hide");
                }
                switch (pvDisplayOptionArray[n].getAxesCoordSystem()) {
                    default: {
                        psXmlNode.addAttribute("coordSystem", "adjust");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("coordSystem", "scene");
                        break;
                    }
                    case 2: {
                        psXmlNode.addAttribute("coordSystem", "model");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("coordSystem", "ambient");
                    }
                }
                psXmlNode.addAttribute("dim", String.valueOf(pvDisplayOptionArray[n].getDimAxes()));
                if (pvDisplayOptionArray[n].getOption(5)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                switch (pvDisplayOptionArray[n].getAxesType()) {
                    case 2: {
                        psXmlNode.addAttribute("type", "bndbox");
                        break;
                    }
                    case 0: {
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 4: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 5: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 6: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 7: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 8: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "corner");
                    }
                }
                n5 = pvDisplayOptionArray[n].getNumRulers();
                n6 = 0;
                while (n6 < n5) {
                    psXmlNode4 = psXmlNode.addChild("ruler");
                    psXmlNode4.addAttribute("name", pvDisplayOptionArray[n].getRulerName(n6));
                    if (pvDisplayOptionArray[n].getRulerMode(n6) == 1) {
                        psXmlNode4.addAttribute("mode", "partitioned");
                    }
                    if (pvDisplayOptionArray[n].isShowingRulerArrow(n6)) {
                        psXmlNode4.addAttribute("arrow", "show");
                    }
                    if (pvDisplayOptionArray[n].isShowingRulerName(n6)) {
                        psXmlNode4.addAttribute("label", "show");
                    }
                    if (!pvDisplayOptionArray[n].isShowingRulerNumbers(n6)) {
                        psXmlNode4.addAttribute("numbers", "hide");
                    }
                    if (pvDisplayOptionArray[n].isShowingRulerHashingsNormal(n6)) {
                        psXmlNode4.addAttribute("hashsNormal", "show");
                    }
                    if (pvDisplayOptionArray[n].isShowingRulerHashingsUp(n6)) {
                        psXmlNode4.addAttribute("hashsUp", "show");
                    }
                    if (!pvDisplayOptionArray[n].isShowingRulerTicksMajor(n6)) {
                        psXmlNode4.addAttribute("ticksMajor", "hide");
                    }
                    if (!pvDisplayOptionArray[n].isShowingRulerTicksMinor(n6)) {
                        psXmlNode4.addAttribute("ticksMinor", "hide");
                    }
                    if (!pvDisplayOptionArray[n].isShowingRuler(n6)) {
                        psXmlNode4.addAttribute("visible", "hide");
                    }
                    psXmlNode4.addChild("minValue", pvDisplayOptionArray[n].getRulerMinValue(n6));
                    psXmlNode4.addChild("maxValue", pvDisplayOptionArray[n].getRulerMaxValue(n6));
                    psXmlNode4.addChild("minorUnit", pvDisplayOptionArray[n].getRulerMinorHashUnit(n6));
                    psXmlNode4.addChild("majorUnit", pvDisplayOptionArray[n].getRulerMajorHashUnit(n6));
                    psXmlNode4.addChild("minorHashings", pvDisplayOptionArray[n].getRulerNumMinorHashings(n6));
                    psXmlNode4.addChild("majorHashings", pvDisplayOptionArray[n].getRulerNumMajorHashings(n6));
                    PsXmlLoader.addColor(psXmlNode4, "color", pvDisplayOptionArray[n].getRulerColor(n6));
                    if (pvDisplayOptionArray[n].getRulerSize(n6) != 0.0) {
                        psXmlNode4.addChild("thickness", pvDisplayOptionArray[n].getRulerSize(n6));
                    }
                    ++n6;
                }
            }
            if (pvDisplayOptionArray[n].getBndBoxColor() != null || pvDisplayOptionArray[n].getBndBoxSize() != 0.0 || pvDisplayOptionArray[n].getOption(12)) {
                psXmlNode = ((PsXmlNode)object).addChild("bndbox");
                if (pvDisplayOptionArray[n].getOption(12)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                PsXmlLoader.addColor(psXmlNode, "color", pvDisplayOptionArray[n].getBndBoxColor());
                if (pvDisplayOptionArray[n].getBndBoxSize() != 0.0) {
                    psXmlNode.addChild("thickness", pvDisplayOptionArray[n].getBndBoxSize());
                }
            }
            if (pvDisplayOptionArray[n].getBoxRatio() != null || pvDisplayOptionArray[n].getOption(35)) {
                psXmlNode = PsXmlLoader.addVector((PsXmlNode)object, "boxRatio", pvDisplayOptionArray[n].getBoxRatio(), false);
                if (pvDisplayOptionArray[n].getOption(35)) {
                    psXmlNode.addAttribute("visible", "show");
                }
            }
            if (pvDisplayOptionArray[n].getOption(36) || !pvDisplayOptionArray[n].getOption(45)) {
                psXmlNode = ((PsXmlNode)object).addChild("clipRange");
                objectArray = new String[]{"X", "Y", "Z"};
                if (!pvDisplayOptionArray[n].getOption(45)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (pvDisplayOptionArray[n].getClipBoundsType() != -1) {
                    psXmlNode.addAttribute("select", (String)objectArray[pvDisplayOptionArray[n].getClipBoundsType()]);
                }
                if (pvDisplayOptionArray[n].getOption(36)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                n5 = 0;
                do {
                    double[] dArray;
                    if ((dArray = pvDisplayOptionArray[n].getClipBounds(n5)) == null || dArray[0] == Double.NEGATIVE_INFINITY && dArray[1] == Double.MAX_VALUE) continue;
                    psXmlNode4 = PsXmlLoader.addVector(psXmlNode, "range", new PdVector(dArray), false);
                    psXmlNode4.addAttribute("type", (String)objectArray[n5]);
                } while (++n5 < 3);
            }
            psXmlNode = ((PsXmlNode)object).addChild("cameras");
            int n7 = pvDisplayOptionArray[n].getCurrentCamera();
            if (n7 < 0 || n7 >= PvCameraIf.CAMERA_NAME.length) {
                PsDebug.warning("unknown camera type = " + n7);
            } else {
                psXmlNode.addAttribute("select", PvCameraIf.CAMERA_NAME[n7]);
            }
            n5 = pvDisplayOptionArray[n].getNumCameras();
            int n8 = 0;
            while (n8 < n5) {
                psXmlNode4 = psXmlNode.addChild("camera");
                psXmlNode4.addAttribute("name", pvDisplayOptionArray[n].getCameraName(n8));
                if (pvDisplayOptionArray[n].isEnabledCameraSceneRatio(n8)) {
                    psXmlNode4.addAttribute("sceneRatio", "show");
                }
                if ((n4 = pvDisplayOptionArray[n].getCameraProjection(n8)) < 0 || n4 >= PvCameraIf.CAMERA_NAME.length) {
                    PsDebug.warning("unknown camera type = " + n4);
                } else {
                    psXmlNode4.addAttribute("projection", PvCameraIf.CAMERA_NAME[n4]);
                }
                PsXmlLoader.addVector(psXmlNode4, "position", pvDisplayOptionArray[n].getCameraPosition(n8), true);
                PsXmlLoader.addVector(psXmlNode4, "interest", pvDisplayOptionArray[n].getCameraInterest(n8), true);
                psXmlNode4.addChild("fieldOfView", pvDisplayOptionArray[n].getCameraAngle(n8));
                psXmlNode4.addChild("roll", pvDisplayOptionArray[n].getCameraRoll(n8));
                psXmlNode3 = psXmlNode4.addChild("clipping");
                if (pvDisplayOptionArray[n].isEnabledCameraClip(n8)) {
                    psXmlNode3.addAttribute("enable", "show");
                } else {
                    psXmlNode3.addAttribute("enable", "hide");
                }
                psXmlNode3.addChild("near", pvDisplayOptionArray[n].getCameraNearClip(n8));
                psXmlNode3.addChild("far", pvDisplayOptionArray[n].getCameraFarClip(n8));
                ++n8;
            }
            PsXmlNode psXmlNode5 = ((PsXmlNode)object).addChild("lights");
            psXmlNode5.addAttribute("lightingModel", pvDisplayOptionArray[n].getLightingModelAsString());
            int n9 = pvDisplayOptionArray[n].getNumLights();
            if (n9 > 0) {
                psXmlNode5.addAttribute("select", String.valueOf(pvDisplayOptionArray[n].getSelectedLight()));
            }
            n4 = 0;
            while (n4 < n9) {
                psXmlNode3 = psXmlNode5.addChild("light");
                string = pvDisplayOptionArray[n].getLightName(n4);
                if (string != null && !string.equalsIgnoreCase("")) {
                    psXmlNode3.addAttribute("name", string);
                }
                int n10 = pvDisplayOptionArray[n].getLightType(n4);
                switch (n10) {
                    case 0: {
                        psXmlNode3.addAttribute("type", "ambient");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("type", "direction");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("type", "point");
                        break;
                    }
                    case 3: {
                        psXmlNode3.addAttribute("type", "spot");
                        break;
                    }
                    case 4: {
                        psXmlNode3.addAttribute("type", "shadow");
                        break;
                    }
                    case 5: {
                        psXmlNode3.addAttribute("type", "head");
                        break;
                    }
                    case 6: {
                        psXmlNode3.addAttribute("type", "sky");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light type = " + n10);
                    }
                }
                if (pvDisplayOptionArray[n].isLightHighlight(n4)) {
                    psXmlNode3.addAttribute("highlight", "on");
                } else {
                    psXmlNode3.addAttribute("highlight", "off");
                }
                n3 = pvDisplayOptionArray[n].getLightReference(n4);
                switch (n3) {
                    case 1: {
                        psXmlNode3.addAttribute("reference", "camera");
                        break;
                    }
                    case 0: {
                        psXmlNode3.addAttribute("reference", "scene");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light reference = " + n3);
                    }
                }
                n2 = pvDisplayOptionArray[n].getLightShading(n4);
                switch (n2) {
                    case 0: {
                        psXmlNode3.addAttribute("shading", "symmetric");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("shading", "halfSphere");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("shading", "fullSphere");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light shading = " + n2);
                    }
                }
                if (pvDisplayOptionArray[n].isLightSwitchedOn(n4)) {
                    psXmlNode3.addAttribute("switch", "on");
                } else {
                    psXmlNode3.addAttribute("switch", "off");
                }
                if (pvDisplayOptionArray[n].isLightVisible(n4)) {
                    psXmlNode3.addAttribute("visible", "show");
                } else {
                    psXmlNode3.addAttribute("visible", "hide");
                }
                PsXmlLoader.addVector(psXmlNode3, "position", pvDisplayOptionArray[n].getLightPosition(n4), true);
                PsXmlLoader.addVector(psXmlNode3, "interest", pvDisplayOptionArray[n].getLightInterest(n4), true);
                PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[n].getLightColor(n4));
                psXmlNode3.addChild("intensity", pvDisplayOptionArray[n].getLightIntensity(n4));
                psXmlNode3.addChild("exponent", pvDisplayOptionArray[n].getLightExponent(n4));
                psXmlNode3.addChild("angle", pvDisplayOptionArray[n].getLightAngle(n4));
                psXmlNode3.addChild("corona", pvDisplayOptionArray[n].getLightCorona(n4));
                psXmlNode3.addChild("falloff", pvDisplayOptionArray[n].getLightFalloff(n4));
                ++n4;
            }
            PsXmlNode psXmlNode6 = ((PsXmlNode)object).addChild("transform");
            int n11 = pvDisplayOptionArray[n].getMajorMode();
            string = "rotate";
            switch (n11) {
                case 0: {
                    string = "rotate";
                    break;
                }
                case 17: {
                    string = "rotate-xy";
                    break;
                }
                case 1: {
                    string = "scale";
                    break;
                }
                case 3: {
                    string = "translate";
                    break;
                }
                case 4: {
                    string = "translate-z";
                    break;
                }
                case 6: {
                    string = "initial";
                    break;
                }
                case 5: {
                    string = "pick";
                    break;
                }
                default: {
                    PsDebug.warning("unknown major mode = " + n11);
                }
            }
            psXmlNode6.addAttribute("majorMode", string);
            if (pvDisplayOptionArray[n].getOption(31)) {
                psXmlNode6.addAttribute("localTransform", "show");
            }
            if (pvDisplayOptionArray[n].getOption(32)) {
                psXmlNode6.addAttribute("directSelect", "show");
            }
            switch (pvDisplayOptionArray[n].getTransformMode()) {
                case 0: {
                    psXmlNode6.addAttribute("mode", "camera");
                    break;
                }
                case 1: {
                    psXmlNode6.addAttribute("mode", "model");
                    break;
                }
                case 2: {
                    psXmlNode6.addAttribute("mode", "ambient");
                    break;
                }
                default: {
                    PsDebug.warning("unknown transformation mode = " + pvDisplayOptionArray[n].getTransformMode());
                }
            }
            psXmlNode3 = ((PsXmlNode)object).addChild("background");
            PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[n].getBackgroundColor());
            boolean bl4 = pvDisplayOptionArray[n].getOption(10);
            String string2 = pvDisplayOptionArray[n].getBackgroundImageFile();
            if (bl4 && string2 != null) {
                if (bl4) {
                    psXmlNode3.addAttribute("image", "show");
                }
                if ((n3 = pvDisplayOptionArray[n].getBackgroundImageFit()) == 0) {
                    psXmlNode3.addAttribute("imageFit", "center");
                } else if (n3 == 1) {
                    psXmlNode3.addAttribute("imageFit", "fit");
                } else if (n3 == 2) {
                    psXmlNode3.addAttribute("imageFit", "resize");
                } else if (n3 == 3) {
                    psXmlNode3.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown background imageFit type = " + n3);
                }
                PsXmlNode psXmlNode7 = psXmlNode3.addChild("image");
                psXmlNode7.addChild("url", string2);
            }
            PsXmlNode psXmlNode8 = ((PsXmlNode)object).addChild("foreground");
            PsXmlLoader.addColor(psXmlNode8, "color", pvDisplayOptionArray[n].getForegroundColor());
            bl4 = pvDisplayOptionArray[n].getOption(19);
            string2 = pvDisplayOptionArray[n].getForegroundImageFile();
            if (bl4 && string2 != null) {
                if (bl4) {
                    psXmlNode8.addAttribute("image", "show");
                }
                if ((n2 = pvDisplayOptionArray[n].getForegroundImageFit()) == 0) {
                    psXmlNode8.addAttribute("imageFit", "center");
                } else if (n2 == 1) {
                    psXmlNode8.addAttribute("imageFit", "fit");
                } else if (n2 == 2) {
                    psXmlNode8.addAttribute("imageFit", "resize");
                } else if (n2 == 3) {
                    psXmlNode8.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown foreground imageFit type = " + n2);
                }
                serializable2 = psXmlNode8.addChild("image");
                ((PsXmlNode)serializable2).addChild("url", string2);
            }
            PsXmlNode psXmlNode9 = ((PsXmlNode)object).addChild("window");
            serializable2 = pvDisplayOptionArray[n].getWindowPosition();
            if (serializable2 != null) {
                psXmlNode9.addChild("x", ((Point)serializable2).x);
                psXmlNode9.addChild("y", ((Point)serializable2).y);
            }
            if ((dimension = pvDisplayOptionArray[n].getWindowSize()) != null) {
                psXmlNode9.addChild("width", dimension.width);
                psXmlNode9.addChild("height", dimension.height);
            }
            ++n;
        }
        return psXmlSrc;
    }
}

