/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.loader.PgLoader;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PsXmlLoader {
    public static void parseVectorAttr(P_Vector p_Vector, PsXmlNode psXmlNode, String[] stringArray) {
        if (p_Vector == null || psXmlNode == null || stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = psXmlNode.getAttribute(stringArray[n]);
            if (string != null) {
                if (string.equalsIgnoreCase("mark")) {
                    p_Vector.setTag(1);
                } else if (stringArray[n].equalsIgnoreCase("name")) {
                    p_Vector.setName(string);
                } else if (stringArray[n].equalsIgnoreCase("detail")) {
                    string = PuString.replace(string, "\\n", "\n");
                    p_Vector.setDetail(string);
                } else if (stringArray[n].equalsIgnoreCase("url")) {
                    p_Vector.setURL(string);
                } else {
                    PsDebug.warning("unknown attribute = " + stringArray[n]);
                    stringArray = null;
                    return;
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean parse(BufferedReader var0, PsXmlSrc var1_1) throws IOException {
        if (var0 == null || var1_1 == null) {
            PsDebug.warning("missing reader or XML source");
            return false;
        }
        var0.mark(200);
        var2_2 = var0.readLine();
        if (var2_2 != null) ** GOTO lbl13
        PsDebug.warning("empty file");
        return false;
lbl-1000:
        // 1 sources

        {
            var2_2 = var0.readLine();
            if (var2_2 != null) continue;
            PsDebug.warning("empty file");
            return false;
lbl13:
            // 2 sources

            ** while (var2_2.equals((Object)""))
        }
lbl14:
        // 1 sources

        var0.reset();
        if (!var2_2.startsWith("<?xml")) {
            var3_3 = var2_2.indexOf("<?xml");
            if (var3_3 == -1) {
                if (!var2_2.startsWith("<javaview-models>")) {
                    PsDebug.warning("invalid XML file, first line = " + var2_2);
                    return false;
                }
            } else if (var3_3 > 0) {
                var2_2 = var2_2.substring(var3_3);
                var0.read(new char[var3_3], 0, var3_3);
            }
        }
        var3_4 = new StreamTokenizer(var0);
        var3_4.eolIsSignificant(true);
        var3_4.ordinaryChars(48, 48);
        var3_4.ordinaryChars(49, 57);
        var3_4.ordinaryChar(124);
        var3_4.ordinaryChar(60);
        var3_4.ordinaryChar(62);
        var3_4.ordinaryChar(47);
        var3_4.ordinaryChar(33);
        var3_4.ordinaryChar(63);
        var3_4.ordinaryChar(91);
        var3_4.ordinaryChar(93);
        var3_4.ordinaryChar(123);
        var3_4.ordinaryChar(125);
        var3_4.ordinaryChar(45);
        var3_4.ordinaryChar(43);
        var3_4.ordinaryChar(46);
        var3_4.ordinaryChar(39);
        var3_4.ordinaryChar(92);
        var3_4.ordinaryChar(96);
        var3_4.ordinaryChar(180);
        var3_4.ordinaryChar(176);
        var3_4.wordChars(124, 124);
        var3_4.wordChars(39, 39);
        var3_4.wordChars(92, 92);
        var3_4.wordChars(96, 96);
        var3_4.wordChars(180, 180);
        var3_4.wordChars(176, 176);
        var3_4.wordChars(35, 35);
        var3_4.wordChars(94, 94);
        var3_4.wordChars(38, 38);
        var3_4.wordChars(36, 36);
        var3_4.wordChars(40, 40);
        var3_4.wordChars(41, 41);
        var3_4.wordChars(123, 123);
        var3_4.wordChars(125, 125);
        var3_4.wordChars(126, 126);
        var3_4.wordChars(64, 64);
        var3_4.wordChars(45, 45);
        var3_4.wordChars(43, 43);
        var3_4.wordChars(42, 42);
        var3_4.wordChars(48, 48);
        var3_4.wordChars(49, 57);
        var3_4.wordChars(46, 46);
        var3_4.wordChars(44, 44);
        var3_4.wordChars(59, 59);
        var3_4.wordChars(95, 95);
        var3_4.wordChars(58, 58);
        var3_4.whitespaceChars(61, 61);
        var4_5 = 0;
        var5_6 = null;
        var6_7 = null;
        var7_8 = false;
        var8_9 = false;
        var9_10 = false;
        var10_11 = false;
        var11_12 = false;
        var12_13 = false;
        var13_14 = true;
        try {
            block29: while (true) {
                if (var8_9) {
                    if (var4_5 > 0) {
                        PsDebug.warning("missing closing element");
                        if (var5_6 != null) {
                            PsDebug.warning("current element = " + var5_6.getType());
                        }
                        return false;
                    }
                    if (var4_5 < 0) {
                        PsDebug.warning("too many closing element");
                        if (var5_6 != null) {
                            PsDebug.warning("current element = " + var5_6.getType());
                        }
                        return false;
                    }
                    if (var6_7 != var5_6) {
                        PsDebug.warning("mismatch between opening and closing elements.");
                    }
                    var1_1.setRootNode(var6_7);
                    return true;
                }
                switch (var3_4.nextToken()) {
                    default: {
                        if (var12_13) {
                            if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                                var5_6.setMixedMode(true);
                                var5_6.addMixedContent(var5_6.getChild());
                            }
                            var5_6.appendContent(String.valueOf((char)var3_4.ttype));
                            continue block29;
                        }
                        PsDebug.warning("parsing broke abnormally\n\t in line=" + var3_4.lineno() + " reading st.sval=" + var3_4.sval + ", st.ttype=" + var3_4.ttype);
                        return false;
                    }
                    case 10: {
                        if (!var10_11 || var5_6 == null || !var5_6.hasContent()) continue block29;
                        var5_6.appendContent("\n");
                        continue block29;
                    }
                    case -1: {
                        var8_9 = true;
                        continue block29;
                    }
                    case 60: {
                        var3_4.whitespaceChars(32, 32);
                        var3_4.ordinaryChar(47);
                        var3_4.ordinaryChar(34);
                        var3_4.quoteChar(34);
                        if (var10_11 && var5_6 != null && var5_6.hasContent() && var5_6.contentEndsWith('\n')) {
                            var14_16 = var5_6.getContent();
                            var14_16 = var14_16.substring(0, var14_16.length() - 1);
                            var5_6.setContent(var14_16);
                        }
                        var10_11 = false;
                        var14_15 = var3_4.nextToken();
                        if (var14_15 == 33 || var14_15 == 63) {
                            var3_4.nextToken();
                            if (var3_4.sval.equals("xml")) {
                                while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                                }
                                continue block29;
                            }
                            if (var3_4.sval.equals("DOCTYPE")) {
                                var3_4.nextToken();
                                if (var3_4.sval != null) {
                                    var1_1.setDocName(var3_4.sval);
                                } else {
                                    PsDebug.warning("missing DTD doc name.");
                                }
                                var15_18 = var3_4.nextToken();
                                if (var3_4.sval != null && var3_4.sval.equals("SYSTEM")) {
                                    var3_4.nextToken();
                                    if (var3_4.sval != null) {
                                        var1_1.setDocType(var3_4.sval);
                                        continue block29;
                                    }
                                    PsDebug.warning("missing DTD doc type.");
                                    continue block29;
                                }
                                if (var3_4.sval != null && var3_4.sval.equals("PUBLIC")) {
                                    var3_4.nextToken();
                                    var3_4.nextToken();
                                    if (var3_4.sval != null) {
                                        var1_1.setDocType(var3_4.sval);
                                        continue block29;
                                    }
                                    var3_4.pushBack();
                                    continue block29;
                                }
                                if (var15_18 == 91) {
                                    var11_12 = true;
                                    continue block29;
                                }
                                PsDebug.warning("error while parsing doctype.\n\t in line=" + var3_4.lineno() + " reading st.sval=" + var3_4.sval + ", st.ttype=" + var3_4.ttype);
                                continue block29;
                            }
                            if (var3_4.sval.equals("ENTITY")) {
                                while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                                }
                                continue block29;
                            }
                            if (var3_4.sval.equals("ELEMENT")) {
                                while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                                }
                                continue block29;
                            }
                            if (var3_4.sval.equals("ATTLIST")) {
                                while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                                }
                                continue block29;
                            }
                            if (var3_4.sval.equals("--")) {
                                while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                                }
                                continue block29;
                            }
                            PsDebug.warning("unknown command.\n\t in line=" + var3_4.lineno() + " reading st.sval=" + var3_4.sval + ", st.ttype=" + var3_4.ttype);
                            while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                            }
                            continue block29;
                        }
                        if (var3_4.sval != null && var3_4.sval.equals("!--")) {
                            while ((var14_15 = var3_4.nextToken()) != 62 && var14_15 != -1) {
                            }
                            continue block29;
                        }
                        if (var3_4.sval != null && var3_4.sval.equals("![CDATA[")) {
                            var3_4.ordinaryChar(93);
                            var3_4.wordChars(32, 32);
                            var3_4.wordChars(61, 61);
                            var3_4.ordinaryChar(34);
                            var3_4.wordChars(34, 34);
                            var3_4.wordChars(47, 47);
                            var15_19 = new StringBuffer();
                            if (var5_6.hasContent()) {
                                var5_6.appendContent("\n");
                            }
                            var5_6.appendContent("<" + var3_4.sval);
                            var16_21 = true;
                            block37: while (var16_21) {
                                var17_24 = var3_4.nextToken();
                                switch (var17_24) {
                                    default: {
                                        if (var3_4.sval != null) {
                                            var15_19.append(var3_4.sval);
                                            break;
                                        }
                                        var18_26 = (char)var3_4.ttype;
                                        var15_19.append(var18_26);
                                        break;
                                    }
                                    case 93: {
                                        var15_19.append("]");
                                        if (var3_4.nextToken() != 93) continue block37;
                                        var15_19.append("]");
                                        if (var3_4.nextToken() != 62) continue block37;
                                        var15_19.append(">");
                                        if (var5_6 != null) {
                                            if (!var5_6.hasContent()) {
                                                var5_6.setContent(var15_19.toString());
                                            } else {
                                                var5_6.appendContent(var15_19.toString());
                                            }
                                        }
                                        var16_21 = false;
                                        break;
                                    }
                                    case 10: {
                                        var15_19.append("\n");
                                        break;
                                    }
                                    case -1: {
                                        PsDebug.warning("premature end of a CDATA block, missed ']]>' closing");
                                        return false;
                                    }
                                }
                            }
                            var3_4.wordChars(93, 93);
                            var3_4.whitespaceChars(32, 32);
                            var3_4.whitespaceChars(61, 61);
                            var3_4.ordinaryChar(34);
                            var3_4.quoteChar(34);
                            var3_4.ordinaryChar(47);
                            continue block29;
                        }
                        if (var14_15 == 47) {
                            --var4_5;
                            var3_4.nextToken();
                            if (!(var3_4.sval.equals(var5_6.getType()) && var5_6.isExpanded() || (var5_6 = var5_6.getFather()).getType().equals(var3_4.sval))) {
                                PsDebug.warning("closing element <" + var3_4.sval + "> does not match open element <" + var5_6.getType() + "> " + "in line=" + var3_4.lineno());
                            }
                            if (var5_6.isMixedMode() && var5_6.hasContent()) {
                                var5_6.addMixedContent(var5_6.getContent());
                                var5_6.setContent(null);
                            }
                            var5_6.setExpanded(false);
                            if (var5_6 != var6_7) continue block29;
                            var7_8 = true;
                            continue block29;
                        }
                        if (var13_14) {
                            var13_14 = false;
                            var3_4.wordChars(33, 33);
                            var3_4.wordChars(63, 63);
                            var3_4.wordChars(91, 91);
                            var3_4.wordChars(93, 93);
                        }
                        var12_13 = false;
                        ++var4_5;
                        var15_20 = new PsXmlNode(var3_4.sval);
                        if (var5_6 == null) {
                            var6_7 = var15_20;
                        } else if (var5_6.isExpanded()) {
                            var5_6.addChild(var15_20);
                            var16_22 = var5_6.isMixedMode();
                            if (!var16_22 && var5_6.hasContent()) {
                                var5_6.setMixedMode(true);
                                var16_22 = true;
                            }
                            if (var16_22) {
                                if (var5_6.hasContent()) {
                                    var5_6.addMixedContent(var5_6.getContent());
                                    var5_6.setContent(null);
                                }
                                var5_6.addMixedContent(var15_20);
                            }
                        } else {
                            var5_6.setSibling(var15_20);
                        }
                        var5_6 = var15_20;
                        var5_6.setExpanded(true);
                        var9_10 = true;
                        var3_4.whitespaceChars(61, 61);
                        continue block29;
                    }
                    case 62: {
                        var9_10 = false;
                        var3_4.ordinaryChar(61);
                        var3_4.wordChars(61, 61);
                        var12_13 = true;
                        var3_4.ordinaryChar(34);
                        var3_4.wordChars(34, 34);
                        var3_4.wordChars(47, 47);
                        if (var7_8) {
                            var8_9 = true;
                            continue block29;
                        }
                        if (var5_6 == null || var5_6.isExpanded() || var5_6.getFather() == null || !var5_6.getFather().isMixedMode()) continue block29;
                        var5_6 = var5_6.getFather();
                        continue block29;
                    }
                    case 93: {
                        if (var11_12) {
                            var11_12 = false;
                            continue block29;
                        }
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("]");
                        continue block29;
                    }
                    case 47: {
                        if (var9_10) {
                            if (var3_4.nextToken() == 62) {
                                var9_10 = false;
                                --var4_5;
                                var5_6.setExpanded(false);
                                continue block29;
                            }
                            PsDebug.error("found '/' in attribute mode, error in line=" + var3_4.lineno());
                            return false;
                        }
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("/");
                        var10_11 = true;
                        continue block29;
                    }
                    case 91: {
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent(" [");
                        continue block29;
                    }
                    case 34: {
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("\"");
                        continue block29;
                    }
                    case 33: {
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("!");
                        continue block29;
                    }
                    case 63: {
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("?");
                        continue block29;
                    }
                    case 61: {
                        if (!var12_13) continue block29;
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        var5_6.appendContent("=");
                        continue block29;
                    }
                    case -3: {
                        if (var9_10) {
                            var16_23 = var3_4.sval;
                            var3_4.ordinaryChar(34);
                            if (var3_4.nextToken() == 34) {
                                var17_25 = null;
                                var3_4.ordinaryChar(32);
                                var3_4.wordChars(32, 32);
                                var3_4.ordinaryChar(61);
                                var3_4.wordChars(61, 61);
                                var18_26 = '\u0001';
                                while (var18_26 != '\u0000') {
                                    switch (var3_4.nextToken()) {
                                        case -1: {
                                            PsDebug.warning("premature end of attribute = " + var16_23 + ", missed '\"' closing");
                                            return false;
                                        }
                                        case 34: {
                                            var5_6.addAttribute(var16_23, var17_25);
                                            var18_26 = '\u0000';
                                            break;
                                        }
                                        case 10: {
                                            if (var17_25 == null) {
                                                var17_25 = "\n";
                                                break;
                                            }
                                            var17_25 = var17_25 + "\n";
                                            break;
                                        }
                                        case -3: {
                                            if (var17_25 == null) {
                                                var17_25 = var3_4.sval;
                                                break;
                                            }
                                            var17_25 = var17_25 + var3_4.sval;
                                            break;
                                        }
                                        default: {
                                            var19_27 = String.valueOf((char)var3_4.ttype);
                                            var17_25 = var17_25 == null ? var19_27 : var17_25 + var19_27;
                                        }
                                    }
                                }
                                var3_4.whitespaceChars(32, 32);
                                var3_4.whitespaceChars(61, 61);
                            } else {
                                PsDebug.warning("attribute value not enclosed with quotes \"att-value\".");
                                var5_6.addAttribute(var16_23, var3_4.sval);
                            }
                            var3_4.quoteChar(34);
                            continue block29;
                        }
                        if (!var5_6.isExpanded()) {
                            var5_6 = var5_6.getFather();
                        }
                        if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                            var5_6.setMixedMode(true);
                            var5_6.addMixedContent(var5_6.getChild());
                        }
                        if (!var5_6.hasContent()) {
                            var5_6.setContent(var3_4.sval);
                        } else if (var5_6.contentEndsWith('\n') || var5_6.contentEndsWith('/')) {
                            var5_6.appendContent(var3_4.sval);
                        } else {
                            var5_6.appendContent(" " + var3_4.sval);
                        }
                        var10_11 = true;
                        continue block29;
                    }
                    case -2: 
                }
                if (!var5_6.isMixedMode() && var5_6.getChild() != null) {
                    var5_6.setMixedMode(true);
                }
                if (!var5_6.hasContent()) {
                    var5_6.setContent(String.valueOf(var3_4.nval));
                } else {
                    var5_6.appendContent(" " + String.valueOf(var3_4.nval));
                }
                var10_11 = true;
            }
        }
        catch (Exception var14_17) {
            PsDebug.warning("Exception thrown in line=" + var3_4.lineno() + ", Exception = " + var14_17);
            return false;
        }
    }

    public static PsXmlSrc read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (psXmlSrc == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        psXmlSrc.setRsrcFile(string);
        return psXmlSrc;
    }

    public static PsXmlSrc read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        try {
            boolean bl = PsXmlLoader.parse(bufferedReader, psXmlSrc);
            if (!bl) {
                PsDebug.warning("failed reading stream = " + bufferedReader);
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed reading stream = " + bufferedReader);
            iOException.printStackTrace();
            return null;
        }
        return psXmlSrc;
    }

    public static PdVector[] parseDoubleList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            pdVectorArray[n] = PsXmlLoader.parsePdVector(psXmlNodeArray[n], stringArray);
            if (pdVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return pdVectorArray;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector pdVector, int n) {
        if (pdVector == null || pdVector.getSize() < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            psXmlNode.addChild(string, PuString.toString(pdVector.getEntry(n2)));
            ++n2;
        }
    }

    public static Color parseColorContent(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        String string = psXmlNode.getContent();
        return PdColor.parseColor(string);
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        boolean bl = "p".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, pdVectorArray[n2], bl);
            ++n2;
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length < n) {
            return;
        }
        boolean bl = "e".equals(string) || "f".equals(string) || "l".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, piVectorArray[n2], bl);
            ++n2;
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[][] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < pdVectorArray[n3].length) {
                psXmlNode.addChild(string, PuString.toString(pdVectorArray[n3][n4].m_data));
                ++n4;
            }
            n2 += pdVectorArray[n3].length;
            ++n3;
        }
        psXmlNode.addAttribute("num", String.valueOf(n2));
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, Color[] colorArray, int n) {
        if (colorArray == null || colorArray.length < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            String string2 = String.valueOf(colorArray[n2].getRed()) + " " + String.valueOf(colorArray[n2].getGreen()) + " " + String.valueOf(colorArray[n2].getBlue());
            psXmlNode.addChild(string, string2);
            ++n2;
        }
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            return new PiVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PiVector();
        }
        PiVector piVector = new PiVector(stringArray.length);
        try {
            int n = 0;
            while (n < stringArray.length) {
                piVector.setEntry(n, Integer.parseInt(stringArray[n]));
                ++n;
            }
            return piVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(psXmlNode2, stringArray);
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PiVector piVector = PsXmlLoader.parsePiVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(piVector, psXmlNode, stringArray);
        }
        return piVector;
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PdVector pdVector, boolean bl) {
        if (pdVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(pdVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, pdVector, bl);
        return psXmlNode2;
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PiVector piVector, boolean bl) {
        if (piVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(piVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, piVector, bl);
        return psXmlNode2;
    }

    public static PsXmlNode addMatrix(PsXmlNode psXmlNode, String string, PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        int n = pdMatrix.getISize();
        int n2 = 0;
        while (n2 < n) {
            psXmlNode2.addChild("row", PuString.toString(pdMatrix.m_data[n2], false));
            ++n2;
        }
        return psXmlNode2;
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, String string2, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        if (PsXmlLoader.addColor(psXmlNode2, string2, color) == null) {
            return null;
        }
        return psXmlNode2;
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        psXmlNode2.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        psXmlNode2.addAttribute("type", "rgb");
        return psXmlNode2;
    }

    public static PiVector[] parseIntegerList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            piVectorArray[n] = PsXmlLoader.parsePiVector(psXmlNodeArray[n], stringArray);
            if (piVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return piVectorArray;
    }

    public static Color[] parseColorList(PsXmlNode psXmlNode, String string) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        Color[] colorArray = new Color[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            colorArray[n] = PsXmlLoader.parseColorContent(psXmlNodeArray[n]);
            if (colorArray[n] == null) {
                PsDebug.warning("failed to parse color at index = " + n);
                return null;
            }
            ++n;
        }
        return colorArray;
    }

    private static PsXmlNode addVectorAttr(PsXmlNode psXmlNode, P_Vector p_Vector, boolean bl) {
        if (bl) {
            String string = p_Vector.getName();
            if (string != null) {
                psXmlNode.addAttribute("name", string);
            }
            if ((string = p_Vector.getURL()) != null) {
                psXmlNode.addAttribute("url", string);
            }
            if ((string = p_Vector.getDetail()) != null) {
                string = PuString.replace(string, "\n", "\\n");
                psXmlNode.addAttribute("detail", string);
            }
        }
        if (p_Vector.hasTag(1)) {
            psXmlNode.addAttribute("tag", "mark");
        }
        return psXmlNode;
    }

    public static Color parseColorRGB(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(psXmlNode2);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(psXmlNode2, stringArray);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PdVector pdVector = PsXmlLoader.parsePdVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(pdVector, psXmlNode, stringArray);
        }
        return pdVector;
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            return new PdVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PdVector();
        }
        PdVector pdVector = new PdVector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            pdVector.setEntry(n, PgLoader.parseDouble(stringArray[n]));
            ++n;
        }
        return pdVector;
    }

    public static PdMatrix parsePdMatrix(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing parent node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            PsDebug.warning("missing matrix node.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "row");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            PsDebug.warning("missing rows in matrix");
            return null;
        }
        String[] stringArray = PuString.splitString(psXmlNodeArray[0].getContent(), ' ');
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing entries in row = 0");
            return null;
        }
        int n = psXmlNodeArray.length;
        int n2 = stringArray.length;
        PdMatrix pdMatrix = new PdMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            stringArray = PuString.splitString(psXmlNodeArray[n3].getContent(), ' ');
            if (stringArray == null || stringArray.length != n2) {
                PsDebug.warning("invalid number of entries in row = " + n3);
                return null;
            }
            int n4 = 0;
            while (n4 < n2) {
                pdMatrix.setEntry(n3, n4, PgLoader.parseDouble(stringArray[n4]));
                ++n4;
            }
            ++n3;
        }
        return pdMatrix;
    }
}

