/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsSlotLayout;
import jv.project.PjProject_IP;

public final class PjImportModel_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected static int NUM_ROWS = 10;
    protected PjImportModel m_pjImport;
    protected String[] m_subDir;
    protected List m_lCategory;
    protected List m_lEntry;
    protected TextField m_tSelectedEntry;
    protected Label m_lCurrDir;
    protected PsPanel m_pReplaceChoice;
    protected Checkbox m_cClose;
    protected Checkbox m_cAdd;
    protected CheckboxGroup m_gHelp;
    protected Checkbox m_cShowInfo;
    protected Checkbox m_cShowAuthor;
    protected PsMultiLineLabel m_mGeomInfo;
    private static /* synthetic */ Class class$jv$loader$PjImportModel_IP;

    public PjImportModel_IP() {
        if (this.getClass() == (class$jv$loader$PjImportModel_IP != null ? class$jv$loader$PjImportModel_IP : (class$jv$loader$PjImportModel_IP = PjImportModel_IP.class$("jv.loader.PjImportModel_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_lEntry && this.m_lEntry.getItemCount() > 0) {
            String string = this.m_lEntry.getSelectedItem();
            boolean bl = false;
            if (this.m_subDir != null) {
                int n = 0;
                while (n < this.m_subDir.length) {
                    if (this.m_subDir[n].equals(string)) {
                        this.readCategories(this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory() + PjImportModel.DIR_LIST);
                        this.m_pjImport.setCategory(this.m_pjImport.getCategory() + string + '/');
                        this.selectCategory(string + '/');
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                PsPanel.setText(this.m_tSelectedEntry, string);
                String string2 = this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory() + string;
                this.m_pjImport.setConfirm(2);
                this.m_pjImport.load(string2);
                this.m_pjImport.fireAction(1001, "OK");
                return;
            }
        } else {
            if (object == this.m_lCategory) {
                String string = this.m_lCategory.getSelectedItem();
                if (string.equals("..")) {
                    this.selectCategory(string);
                    return;
                }
                this.selectCategory(string + '/');
                return;
            }
            if (object == this.m_cClose || object == this.m_cAdd) {
                this.m_pjImport.setEnabledRemoveGeometry(this.m_cClose.getState());
                return;
            }
            if (object == this.m_cShowInfo) {
                this.updateNotice();
                return;
            }
            if (object == this.m_cShowAuthor) {
                this.updateNotice();
            }
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pjImport = (PjImportModel)psUpdateIf;
        this.readCategories(this.m_pjImport.getBaseDir() + PjImportModel.DIR_LIST);
        String string = this.m_pjImport.getCategory();
        if (this.getIndex(this.m_lCategory, string) == -1) {
            if (this.m_lCategory.getItemCount() > 1) {
                string = this.m_lCategory.getItem(1);
            } else if (this.m_lCategory.getItemCount() == 1) {
                string = this.m_lCategory.getItem(0);
            } else {
                PsDebug.warning("missing categories");
                return;
            }
            string = string + '/';
            this.m_pjImport.setCategory(string);
        }
        this.selectCategory(string);
        if (this.m_pjImport.isVisibleReplaceChoice()) {
            this.addProjectCheckboxes();
        } else {
            this.m_pReplaceChoice.removeAll();
        }
        this.m_pReplaceChoice.validate();
    }

    public void setClosing(boolean bl) {
        this.m_cClose.setState(bl);
    }

    public void addProjectCheckboxes() {
        if (this.m_pReplaceChoice.getComponentCount() == 3) {
            return;
        }
        this.m_pReplaceChoice.add("1", new Label(PsConfig.getMessage(24383), 0));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_cClose = new Checkbox(PsConfig.getMessage(24140), checkboxGroup, true);
        this.m_cClose.addItemListener(this);
        this.m_pReplaceChoice.add("1", this.m_cClose);
        this.m_cAdd = new Checkbox(PsConfig.getMessage(24384), checkboxGroup, false);
        this.m_cAdd.addItemListener(this);
        this.m_pReplaceChoice.add("1", this.m_cAdd);
    }

    public boolean update(Object object) {
        if (this.m_project == null) {
            PsDebug.warning("missing parent, setParent not called");
            return false;
        }
        if (object == this.m_project) {
            this.updateNotice();
            String string = this.m_pjImport.getCategory();
            if (string == null) {
                PsDebug.warning("missing model category in project");
                return false;
            }
            String string2 = this.m_lCategory.getSelectedItem();
            if (string2 != null && string.startsWith(string2)) {
                return true;
            }
            this.selectCategory(this.m_pjImport.getCategory());
            PsPanel.setState(this.m_cClose, this.m_pjImport.isEnabledRemoveGeometry());
            PsPanel.setState(this.m_cAdd, !this.m_pjImport.isEnabledRemoveGeometry());
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if ((object == this.m_lEntry || object == this.m_tSelectedEntry) && "".compareTo(string = this.m_tSelectedEntry.getText()) != 0) {
            if (this.m_subDir != null) {
                int n = 0;
                while (n < this.m_subDir.length) {
                    if (this.m_subDir[n].equals(string)) {
                        return;
                    }
                    ++n;
                }
            }
            String string2 = this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory() + string;
            this.m_pjImport.setConfirm(2);
            this.m_pjImport.load(string2);
            this.m_pjImport.fireAction(1001, "OK");
            return;
        }
    }

    public boolean isClosing() {
        return this.m_cClose.getState();
    }

    private void selectCategory(String string) {
        if (string.equals("..")) {
            String string2 = this.m_pjImport.getCategory();
            if (PuString.isEmpty(string2)) {
                return;
            }
            int n = (string2 = string2.substring(0, string2.length() - 1)).lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            n = string2.lastIndexOf(47);
            String string3 = string2.substring(0, n + 1);
            this.readCategories(this.m_pjImport.getBaseDir() + string3 + PjImportModel.DIR_LIST);
            this.m_pjImport.setCategory(string2 + '/');
            this.readModels(this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory() + PjImportModel.DIR_LIST);
            return;
        }
        int n = this.getIndex(this.m_lCategory, string);
        if (n == -1) {
            PsDebug.warning("category not found in list.");
            return;
        }
        this.m_lCategory.select(n);
        String string4 = this.m_pjImport.getCategory();
        if (string4.length() > 0) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        int n2 = string4.lastIndexOf(47);
        String string5 = string4.substring(0, n2 + 1);
        this.m_pjImport.setCategory(string5 + string);
        this.readModels(this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory() + PjImportModel.DIR_LIST);
    }

    private int getIndex(List list, String string) {
        String[] stringArray = list.getItems();
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return -1;
        }
        String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && string2.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getSelection() {
        return this.m_tSelectedEntry.getText();
    }

    private void readCategories(String string) {
        if (!PgLoader.readDirs(this.m_lCategory, string)) {
            PsDebug.warning("failed reading model list\n\t file = " + string);
        }
    }

    public void init() {
        super.init();
        PsPanel psPanel = new PsPanel();
        psPanel.addTitle(PsConfig.getMessage(24109));
        Panel panel = new Panel(new PsSlotLayout(3));
        Panel panel2 = new Panel(new PsStackLayout(2));
        panel.add("1", panel2);
        Panel panel3 = new Panel(new PsStackLayout(2));
        panel.add("2", panel3);
        panel2.add(new Label(PsConfig.getMessage(24114)));
        panel3.add(new Label(PsConfig.getMessage(24117)));
        this.m_lCategory = new List(NUM_ROWS, false);
        this.m_lCategory.addItemListener(this);
        panel2.add(this.m_lCategory);
        this.m_lEntry = new List(NUM_ROWS, false);
        this.m_lEntry.addActionListener(this);
        this.m_lEntry.addItemListener(this);
        panel3.add(this.m_lEntry);
        panel2.add(new Label(PsConfig.getMessage(24115) + ": ", 0));
        this.m_lCurrDir = new Label();
        panel3.add(this.m_lCurrDir);
        panel2.add(new Label(PsConfig.getMessage(24116) + ": ", 0));
        this.m_tSelectedEntry = new TextField(25);
        this.m_tSelectedEntry.addActionListener(this);
        panel3.add(this.m_tSelectedEntry);
        psPanel.add(panel);
        this.add(psPanel);
        this.m_pReplaceChoice = new PsPanel(new PsSlotLayout(3));
        this.add(this.m_pReplaceChoice);
        panel = new PsPanel();
        ((PsPanel)panel).addLine(1);
        panel2 = new PsPanel();
        ((PsPanel)panel2).addSubTitle(PsConfig.getMessage(24381));
        panel3 = new PsPanel(new GridLayout(1, 2));
        this.m_gHelp = new CheckboxGroup();
        this.m_cShowInfo = new Checkbox(PsConfig.getMessage(24382), this.m_gHelp, true);
        this.m_cShowInfo.addItemListener(this);
        panel3.add(this.m_cShowInfo);
        this.m_cShowAuthor = new Checkbox(PsConfig.getMessage(24218), this.m_gHelp, false);
        this.m_cShowAuthor.addItemListener(this);
        panel3.add(this.m_cShowAuthor);
        panel2.add(panel3);
        PsPanel psPanel2 = new PsPanel();
        this.m_mGeomInfo = new PsMultiLineLabel();
        psPanel2.add(this.m_mGeomInfo);
        panel2.add(psPanel2);
        panel.add(panel2);
        this.add(panel);
    }

    private void readModels(String string) {
        PsPanel.setText(this.m_lCurrDir, this.m_pjImport.getBaseDir() + this.m_pjImport.getCategory());
        if (!PgLoader.readAll(this.m_lEntry, string)) {
            PsDebug.warning("failed reading model list\n\t file = " + string);
            return;
        }
        this.m_subDir = PgLoader.readDirs(string);
    }

    private void updateNotice() {
        String string = this.m_pjImport.getInfo();
        PsPanel.setEnabled(this.m_cShowInfo, !PuString.isEmpty(string));
        String string2 = this.m_pjImport.getAuthor();
        PsPanel.setEnabled(this.m_cShowAuthor, !PuString.isEmpty(string2));
        String string3 = this.m_mGeomInfo.getText();
        String string4 = "";
        if (this.m_cShowInfo.getState()) {
            if (string != null) {
                string4 = string;
            }
        } else if (string2 != null) {
            string4 = string2;
        }
        if (string4 != null && !string4.equals(string3)) {
            this.m_mGeomInfo.setText(string4);
            this.m_mGeomInfo.validate();
        }
    }
}

