/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsJavaView;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgObjLoader
implements PgLoaderIf {
    protected BitSet m_geometryOption;
    protected boolean m_bHandleVectors = false;
    protected int m_numVertices = 0;
    protected int m_numColors = 0;
    protected int m_numNormals = 0;
    protected int m_numNormalIndices = 0;
    protected int m_numTextures = 0;
    protected int m_numTextureIndices = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected Vector m_vNormal;
    protected Vector m_vNormalInd;
    protected Vector m_vTexture;
    protected Vector m_vTextureInd;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;
    private static final String StrNL = "\n";
    protected static boolean m_bNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bElementTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bPolygonNormals = false;

    protected static boolean writePolygons(Writer writer, int n, PiVector[] piVectorArray) throws IOException {
        if (n < 0 || piVectorArray == null || n > piVectorArray.length) {
            return false;
        }
        writer.write("# Polygon List\n");
        writer.write("# Number of Polygons = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            writer.write("l  ");
            if (piVectorArray[n2] == null) {
                return false;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                writer.write(String.valueOf(n4));
                if (m_bPolygonNormals) {
                    writer.write("/" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    writer.write(" ");
                }
                ++n3;
            }
            writer.write(StrNL);
            ++n2;
        }
        return true;
    }

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader var1_1) {
        block58: {
            var2_2 = 3;
            var3_3 = 200;
            var4_4 = 4;
            var5_5 = 5;
            var6_6 = new int[var2_2];
            var7_7 = new float[var2_2];
            var8_8 = new double[var4_4];
            var9_9 = new double[var4_4];
            var10_10 = new double[var4_4];
            var11_11 = new double[var4_4];
            var12_12 = new int[var3_3];
            var13_13 = new int[var3_3];
            var14_14 = new int[var3_3];
            var15_15 = new int[var3_3];
            this.m_vVertex = new Vector<E>();
            this.m_vVertexColor = new Vector<E>();
            this.m_vNormal = new Vector<E>();
            this.m_vNormalInd = new Vector<E>();
            this.m_vTexture = new Vector<E>();
            this.m_vTextureInd = new Vector<E>();
            this.m_vVertexVector = new Vector<E>();
            this.m_vElement = new Vector<E>();
            this.m_vElementColor = new Vector<E>();
            this.m_vPolygon = new Vector<E>();
            this.m_vPolygonColor = new Vector<E>();
            this.m_vPolygonColorInd = new PiVector();
            var16_16 = new StreamTokenizer(var1_1);
            var16_16.eolIsSignificant(true);
            var16_16.ordinaryChars(47, 47);
            var16_16.commentChar(35);
            var16_16.commentChar(36);
            this.m_numVertices = 0;
            this.m_numNormals = 0;
            this.m_numTextures = 0;
            this.m_numElements = 0;
            try {
                var18_17 = 0;
                var19_19 = false;
                block7: while (!var19_19) {
                    switch (var16_16.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally in line=" + var16_16.lineno() + " reading st.sval=" + var16_16.sval + ", st.ttype=" + var16_16.ttype);
                            return false;
                        }
                        case -3: {
                            if (!"mt".equals(var16_16.sval)) ** GOTO lbl53
                            this.m_numMeshType = 0;
                            this.m_meshType = new int[var5_5];
                            while (var16_16.nextToken() == -2) {
                                this.m_meshType[this.m_numMeshType] = (int)var16_16.nval;
                                ++this.m_numMeshType;
                            }
                            ** GOTO lbl265
lbl53:
                            // 1 sources

                            if (!"v".equals(var16_16.sval)) ** GOTO lbl76
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                if (var17_20 < 3) {
                                    var16_16.pushBack();
                                    var8_8[var17_20] = PgLoader.parseDouble(var16_16);
                                } else {
                                    var6_6[var17_20 - 3] = (int)var16_16.nval;
                                }
                                ++var17_20;
                            }
                            if (PsJavaView.m_bFilterVertices && ++var18_17 % 100 != 1) ** GOTO lbl269
                            if (var17_20 > 0) {
                                ++this.m_numVertices;
                                var20_21 = new PdVector(Math.min(3, var17_20));
                                var20_21.copy(var8_8, var17_20);
                                this.m_vVertex.addElement(var20_21);
                                if (var17_20 == 6) {
                                    var21_29 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                    this.m_vVertexColor.addElement(var21_29);
                                    ++this.m_numColors;
                                }
                            } else {
                                PsDebug.warning("vertex with no coords in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl76:
                            // 1 sources

                            if (!"vc".equals(var16_16.sval)) ** GOTO lbl90
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var16_16.pushBack();
                                var7_7[var17_20] = (float)PgLoader.parseDouble(var16_16);
                                ++var17_20;
                            }
                            if (var17_20 == 3) {
                                var20_22 = new Color(var7_7[0], var7_7[1], var7_7[2]);
                                this.m_vVertexColor.addElement(var20_22);
                                ++this.m_numColors;
                            } else {
                                PsDebug.warning("vertex color with wrong num coords in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl90:
                            // 1 sources

                            if (!"vn".equals(var16_16.sval)) ** GOTO lbl105
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var16_16.pushBack();
                                var9_9[var17_20] = PgLoader.parseDouble(var16_16);
                                ++var17_20;
                            }
                            if (var17_20 > 0) {
                                var20_23 = new PdVector(var17_20);
                                var20_23.copy(var9_9, var17_20);
                                this.m_vNormal.addElement(var20_23);
                                ++this.m_numNormals;
                            } else {
                                PsDebug.warning("vertex normal with no coords in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl105:
                            // 1 sources

                            if (!"vt".equals(var16_16.sval)) ** GOTO lbl119
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var16_16.pushBack();
                                var10_10[var17_20++] = PgLoader.parseDouble(var16_16);
                            }
                            if (var17_20 > 0) {
                                var20_24 = new PdVector(var17_20);
                                var20_24.copy(var10_10, var17_20);
                                this.m_vTexture.addElement(var20_24);
                                ++this.m_numTextures;
                            } else {
                                PsDebug.warning("vertex texture with no coords in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl119:
                            // 1 sources

                            if (!"vd".equals(var16_16.sval)) ** GOTO lbl133
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var16_16.pushBack();
                                var11_11[var17_20++] = PgLoader.parseDouble(var16_16);
                            }
                            if (var17_20 > 0) {
                                var20_25 = new PdVector(var17_20);
                                var20_25.copy(var11_11, var17_20);
                                this.m_vVertexVector.addElement(var20_25);
                                ++this.m_numVertexVectors;
                            } else {
                                PsDebug.warning("vertex user data with no values in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl133:
                            // 1 sources

                            if (!"f".equals(var16_16.sval) && !"fo".equals(var16_16.sval)) ** GOTO lbl200
                            if (!PsJavaView.m_bOnlyVertices) ** GOTO lbl137
                            var19_19 = true;
                            ** GOTO lbl269
lbl137:
                            // 1 sources

                            if (var16_16.nextToken() == 92) {
                                var16_16.nextToken();
                            } else {
                                var16_16.pushBack();
                            }
                            var17_20 = 0;
                            var20_26 = false;
                            var21_30 = false;
                            while (var16_16.nextToken() == -2) {
                                var12_12[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl173
                                if (var16_16.nextToken() != -2) ** GOTO lbl164
                                var21_30 = true;
                                var14_14[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl162
                                if (var16_16.nextToken() == -2) {
                                    var20_26 = true;
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var16_16.lineno());
                                    break;
lbl162:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
                                ** GOTO lbl174
lbl164:
                                // 1 sources

                                if (var16_16.ttype != 47) ** GOTO lbl171
                                if (var16_16.nextToken() == -2) {
                                    var20_26 = true;
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var16_16.lineno());
                                    break;
lbl171:
                                    // 1 sources

                                    PsDebug.warning("parse error in face/ = " + this.m_numElements + "/" + var17_20);
                                    break;
lbl173:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
lbl174:
                                // 4 sources

                                ++var17_20;
                            }
                            if (var17_20 > 0) {
                                var22_31 = new PiVector(var17_20);
                                var22_31.copy(var12_12, var17_20);
                                this.m_vElement.addElement(var22_31);
                                if (var21_30) {
                                    var23_32 = new PiVector(var17_20);
                                    var23_32.copy(var14_14, var17_20);
                                    this.m_vTextureInd.addElement(var23_32);
                                } else {
                                    this.m_vTextureInd.addElement(this);
                                }
                                if (var20_26) {
                                    var23_32 = new PiVector(var17_20);
                                    var23_32.copy(var13_13, var17_20);
                                    this.m_vNormalInd.addElement(var23_32);
                                } else {
                                    this.m_vNormalInd.addElement(this);
                                }
                                ++this.m_numElements;
                            } else {
                                PsDebug.warning("face with no vertex in line=" + var16_16.lineno());
                            }
                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                            }
                            ** GOTO lbl265
lbl200:
                            // 1 sources

                            if (!"l".equals(var16_16.sval) && !"lo".equals(var16_16.sval)) ** GOTO lbl245
                            if (!PsJavaView.m_bOnlyVertices) ** GOTO lbl204
                            var19_19 = true;
                            ** GOTO lbl269
lbl204:
                            // 1 sources

                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var15_15[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl230
                                if (var16_16.nextToken() != -2) ** GOTO lbl222
                                var14_14[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl220
                                if (var16_16.nextToken() == -2) {
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_16.lineno());
                                    break;
lbl220:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
                                ** GOTO lbl231
lbl222:
                                // 1 sources

                                if (var16_16.ttype != 47) ** GOTO lbl228
                                if (var16_16.nextToken() == -2) {
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_16.lineno());
                                    break;
lbl228:
                                    // 1 sources

                                    PsDebug.warning("parse error in polygon/ = " + this.m_numPolygons + "/" + var17_20);
                                    break;
lbl230:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
lbl231:
                                // 4 sources

                                ++var17_20;
                            }
                            if (var17_20 > 0) {
                                ++this.m_numPolygons;
                                var20_27 = new PiVector(var17_20);
                                var20_27.copy(var15_15, var17_20);
                                this.m_vPolygon.addElement(var20_27);
                            } else {
                                PsDebug.warning("polygon with no vertex in line=" + var16_16.lineno());
                            }
                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                            }
                            ** GOTO lbl265
lbl245:
                            // 1 sources

                            if (!"lc".equals(var16_16.sval)) ** GOTO lbl263
                            if (PsJavaView.m_bOnlyVertices) ** GOTO lbl269
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var16_16.pushBack();
                                var7_7[var17_20] = (float)PgLoader.parseDouble(var16_16);
                                ++var17_20;
                            }
                            if (var17_20 == 3) {
                                var20_28 = new Color(var7_7[0], var7_7[1], var7_7[2]);
                                if (this.m_vPolygonColorInd.getSize() <= this.m_vPolygonColor.size() + 1) {
                                    this.m_vPolygonColorInd.setSize(this.m_vPolygonColor.size() + 1000);
                                }
                                this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                this.m_vPolygonColor.addElement(var20_28);
                            } else {
                                PsDebug.warning("polygon color with wrong num coords in line=" + var16_16.lineno());
                            }
                            ** GOTO lbl265
lbl263:
                            // 1 sources

                            if ("g".equals(var16_16.sval)) {
                                // empty if block
                            }
lbl265:
                            // 19 sources

                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                            }
                        }
lbl269:
                        // 6 sources

                        case 10: {
                            continue block7;
                        }
                        case -1: {
                            if (this.m_vPolygonColorInd.getSize() <= 0) break block58;
                        }
                    }
                }
            }
            catch (Exception var18_18) {
                PsDebug.warning("Exception thrown in line=" + var16_16.lineno() + ", Exception = " + var18_18);
                return false;
            }
            if (this.m_vPolygonColorInd.getSize() <= 0) break block58;
            this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
        }
        return true;
    }

    protected static boolean writePdVectors(Writer writer, String string, String string2, int n, PdVector[] pdVectorArray) throws IOException {
        if (n < 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return false;
        }
        writer.write("# " + string + " List\n");
        writer.write("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            writer.write(string2 + " ");
            if (pdVectorArray[n2] == null) {
                return false;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    writer.write(String.valueOf((float)pdVectorArray[n2].m_data[n3]));
                } else {
                    writer.write(String.valueOf(0.0f));
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    writer.write(" ");
                }
                ++n3;
            }
            writer.write(StrNL);
            ++n2;
        }
        return true;
    }

    protected static boolean writePdVectors(Writer writer, String string, String string2, int n, PdVector[][] pdVectorArray) throws IOException {
        if (n < 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return false;
        }
        writer.write("# " + string + " List\n");
        writer.write("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                return false;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].length) {
                PdVector pdVector = pdVectorArray[n2][n3];
                if (pdVector == null || pdVector.m_data == null) {
                    return false;
                }
                writer.write(string2 + " ");
                int n4 = 0;
                while (n4 < pdVector.m_data.length) {
                    if (Math.abs(pdVector.m_data[n4]) > 1.0E-10) {
                        writer.write(String.valueOf((float)pdVector.m_data[n4]));
                    } else {
                        writer.write(String.valueOf(0.0f));
                    }
                    if (n4 < pdVector.m_data.length - 1) {
                        writer.write(" ");
                    }
                    ++n4;
                }
                writer.write(StrNL);
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        PdVector[] pdVectorArray;
        Object object;
        Enumeration enumeration;
        int n2;
        Object object2;
        Serializable[] serializableArray;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setEnabledInstanceSharing(true);
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    pgJvxSrc.setType(32);
                    break;
                }
                case 2: {
                    pgJvxSrc.setType(33);
                    break;
                }
                case 3: {
                    pgJvxSrc.setType(34);
                    break;
                }
                default: {
                    pgJvxSrc.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            pgJvxSrc.setType(33);
        } else if (this.m_numPolygons > 0) {
            pgJvxSrc.setType(32);
        } else {
            pgJvxSrc.setType(30);
        }
        if (this.m_numVertices > 0) {
            serializableArray = (Color[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(serializableArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            object2 = new PdVector[this.m_numVertices];
            n2 = 0;
            enumeration = this.m_vVertex.elements();
            while (enumeration.hasMoreElements()) {
                object2[n2++] = (PdVector)enumeration.nextElement();
            }
            pgJvxSrc.setVertices((PdVector[])object2);
            this.m_vVertex = null;
        }
        if (this.m_numColors > 0 && this.m_numColors == this.m_numVertices) {
            serializableArray = new Color[this.m_numColors];
            n2 = 0;
            object2 = this.m_vVertexColor.elements();
            while (object2.hasMoreElements()) {
                serializableArray[n2++] = (Color)object2.nextElement();
            }
            pgJvxSrc.setVertexColors((Color[])serializableArray);
            pgJvxSrc.showElementColors(true);
            pgJvxSrc.showElementFromVertexColors(true);
            this.m_vVertexColor = null;
        }
        if (this.m_numNormals > 0 && this.m_numNormals == this.m_numVertices) {
            serializableArray = new PdVector[this.m_numNormals];
            n2 = 0;
            object2 = this.m_vNormal.elements();
            while (object2.hasMoreElements()) {
                serializableArray[n2++] = (PdVector)object2.nextElement();
            }
            pgJvxSrc.setVertexNormals((PdVector[])serializableArray);
            this.m_vNormal = null;
        }
        if (this.m_bHandleVectors && this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int n3 = this.m_numVertexVectors / this.m_numVertices;
                pgJvxSrc.setNumVectorFields(n3);
                object2 = this.m_vVertexVector.elements();
                int n4 = 0;
                while (n4 < n3) {
                    object = (PdVector)this.m_vVertexVector.elementAt(n4 * this.m_numVertices);
                    pgJvxSrc.setNumVectors(n4, this.m_numVertices, ((PdVector)object).getSize());
                    pdVectorArray = pgJvxSrc.getVectors(n4);
                    n2 = 0;
                    n = 0;
                    while (n < this.m_numVertices) {
                        pdVectorArray[n2++] = (PdVector)object2.nextElement();
                        ++n;
                    }
                    ++n4;
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
            this.m_vVertexVector = null;
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            PiVector[] piVectorArray = new PiVector[this.m_numElements];
            n2 = 0;
            object2 = this.m_vElement.elements();
            while (object2.hasMoreElements()) {
                piVectorArray[n2++] = (PiVector)object2.nextElement();
            }
            pgJvxSrc.setElements(piVectorArray);
            this.m_vElement = null;
        }
        if (this.m_numTextures > 0) {
            pgJvxSrc.assureElementTextures();
            PdVector[][] pdVectorArray2 = pgJvxSrc.getElementTextures();
            object2 = pgJvxSrc.getElements();
            n2 = 0;
            while (n2 < this.m_numElements) {
                int n5 = ((PiVector)object2[n2]).getSize();
                object = this.m_vTextureInd.elementAt(n2);
                if (object != this) {
                    pdVectorArray = (PdVector[])object;
                    n = 0;
                    while (n < n5) {
                        pdVectorArray2[n2][n].copyArray((PdVector)this.m_vTexture.elementAt(pdVectorArray.getEntry(n)));
                        ++n;
                    }
                }
                ++n2;
            }
            this.m_vTexture = null;
            this.m_vTextureInd = null;
        }
        if (this.m_numPolygons > 0) {
            pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
            pgJvxSrc.setNumPolygons(this.m_numPolygons);
            PiVector[] piVectorArray = new PiVector[this.m_numPolygons];
            n2 = 0;
            object2 = this.m_vPolygon.elements();
            while (object2.hasMoreElements()) {
                piVectorArray[n2++] = (PiVector)object2.nextElement();
            }
            pgJvxSrc.setPolygons(piVectorArray);
            this.m_vPolygon = null;
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            pgJvxSrc.assurePolygonColors();
            Color[] colorArray = new Color[this.m_numPolygons];
            n2 = 0;
            object2 = (Color)this.m_vPolygonColor.firstElement();
            n = 0;
            while (n < this.m_vPolygonColorInd.getEntry(0)) {
                colorArray[n] = object2;
                ++n;
            }
            enumeration = this.m_vPolygonColor.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Color)enumeration.nextElement();
                n = this.m_vPolygonColorInd.getEntry(n2);
                while (n < this.m_vPolygonColorInd.getEntry(n2 + 1)) {
                    colorArray[n] = object2;
                    ++n;
                }
                ++n2;
            }
            pgJvxSrc.setPolygonColors(colorArray);
            pgJvxSrc.showPolygonColors(true);
            this.m_vPolygonColor = null;
            this.m_vPolygonColorInd = null;
        }
        PgObjLoader.geomInitType(pgJvxSrc);
        pgJvxSrc.setEnabledInstanceSharing(false);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName(string));
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(3);
            bl2 = this.m_geometryOption.get(5);
            bl3 = this.m_geometryOption.get(6);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = Wavefront OBJ\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            writer.write("#     Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("#     Number of Polygons = " + n + StrNL);
        }
        if (bl && pgJvxSrc.getVertexNormals() != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (bl2 && pgJvxSrc.getVertexTextures() != null) {
            writer.write("#     Additional: Vertex Texture Coordinates\n");
        } else if (bl2 && pgJvxSrc.getElementTextures() != null) {
            writer.write("#     Additional: Element Texture Coordinates\n");
        }
        if (bl3 && this.m_bHandleVectors && pgJvxSrc.getNumVectorFields() != 0 && pgJvxSrc.getNumVectors(0) == pgJvxSrc.getNumVertices()) {
            writer.write("#     Additional: Vertex Vector Field\n");
        }
        writer.write("#\n# End of Header\n");
        PgObjLoader.writePdVectors(writer, "Vertex", "v", n2, pgJvxSrc.getVertices());
        writer.flush();
        if (bl3 && this.m_bHandleVectors && pgJvxSrc.getNumVectorFields() != 0 && pgJvxSrc.getNumVectors(0) == pgJvxSrc.getNumVertices()) {
            PgObjLoader.writePdVectors(writer, "Vertex Vector", "vd", pgJvxSrc.getVectors(0).length, pgJvxSrc.getVectors(0));
            writer.flush();
        }
        m_bNormals = false;
        if (bl && pgJvxSrc.getVertexNormals() != null) {
            if (PgObjLoader.writePdVectors(writer, "Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) {
                m_bNormals = true;
            }
            writer.flush();
        }
        m_bVertexTextures = false;
        m_bElementTextures = false;
        if (bl2 && pgJvxSrc.getVertexTextures() != null) {
            if (PgObjLoader.writePdVectors(writer, "Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) {
                m_bVertexTextures = true;
            }
        } else if (bl2 && pgJvxSrc.getElementTextures() != null && PgObjLoader.writePdVectors(writer, "Element Texture", "vt", n3, pgJvxSrc.getElementTextures())) {
            m_bElementTextures = true;
        }
        if (pgJvxSrc.getElements() != null) {
            PgObjLoader.writeElements(writer, n3, pgJvxSrc.getElements());
            writer.flush();
        }
        m_bPolygonNormals = false;
        if (bl && pgJvxSrc.getPolygonNormals() != null && PgObjLoader.writePdVectors(writer, "Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) {
            m_bPolygonNormals = true;
        }
        if (pgJvxSrc.getPolygons() != null) {
            PgObjLoader.writePolygons(writer, n, pgJvxSrc.getPolygons());
        }
        writer.flush();
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.showEdges(false);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    protected static boolean writeElements(Writer writer, int n, PiVector[] piVectorArray) throws IOException {
        if (n < 0 || piVectorArray == null || n > piVectorArray.length) {
            return false;
        }
        writer.write("# Face List\n");
        writer.write("# Number of Faces = " + n + StrNL);
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            writer.write("f  ");
            if (piVectorArray[n3] == null) {
                return false;
            }
            int n4 = 0;
            while (n4 < piVectorArray[n3].m_data.length) {
                int n5 = piVectorArray[n3].m_data[n4] + 1;
                writer.write(String.valueOf(n5));
                if (m_bVertexTextures || m_bElementTextures) {
                    if (m_bVertexTextures) {
                        writer.write("/" + n5);
                    } else {
                        writer.write("/" + n2++);
                    }
                    if (m_bNormals) {
                        writer.write("/" + n5);
                    }
                } else if (!m_bVertexTextures && !m_bElementTextures && m_bNormals) {
                    writer.write("//" + n5);
                }
                if (n4 < piVectorArray[n3].m_data.length - 1) {
                    writer.write(" ");
                }
                ++n4;
            }
            writer.write(StrNL);
            ++n3;
        }
        return true;
    }
}

