/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Vector;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgMathLoader
implements PgLoaderIf {
    protected int m_dim = 0;
    protected boolean m_bIsKeyAnimation = false;
    protected boolean m_bIsAnimation = false;
    protected Vector m_graphicsVector;
    protected int m_numGraphics = 0;
    protected PvDisplayOption m_displayOption;
    protected Vector m_displayOptionVector;
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected PdVector m_viewVertical;
    protected Vector m_viewVerticalVector;
    protected Color m_defaultColor;
    protected Vector m_defaultColorVector;
    protected Color m_bndBoxColor;
    protected Vector m_bndBoxColorVector;
    protected PdVector m_boxRatio;
    protected Vector m_boxRatioVector;
    protected Vector m_graphicsArrayPosition;
    private int m_arrayCount0 = 0;
    private int m_arrayCount1 = 0;
    private boolean m_bGrayLevel = false;
    private Vector m_bGrayLevelVector;
    private boolean m_bBlackWhite = false;
    private Vector m_bBlackWhiteVector;
    private boolean m_isGraphicsArray = false;
    private static final int COLOR_FACE_FRONT = 0;
    private static final int COLOR_FACE_BACK = 1;
    private static final int COLOR_FACE_FRONT_REFL = 2;
    private static final int COLOR_FACE_BACK_REFL = 3;
    private static final int COLOR_FACE_FRONT_NOLIGHTS = 4;
    private static final int COLOR_FACE_BACK_NOLIGHTS = 5;
    private static final int COLOR_ELEMENT_EDGE = 6;
    private static final int COLOR_POINT = 7;
    private static final int COLOR_POLYGON = 8;
    private static final int COLOR_DISK = 9;
    private static final int COLOR_CIRCLE = 10;
    private static final int COLOR_TEXT = 11;
    private static final int COLOR_FUNCTION_GRAY = 0;
    private static final int COLOR_FUNCTION_HUE = 1;
    private int m_colorFunction = 0;
    private boolean m_bColorFunctionScaling = true;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(BufferedReader bufferedReader) {
        int n;
        int n2;
        StreamTokenizer streamTokenizer;
        try {
            this.m_displayOption = new PvDisplayOption();
            this.setDisplayDefault();
            streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(123);
            streamTokenizer.ordinaryChar(125);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.ordinaryChar(35);
            streamTokenizer.ordinaryChar(38);
            streamTokenizer.ordinaryChar(36);
            streamTokenizer.ordinaryChar(40);
            streamTokenizer.ordinaryChar(41);
            streamTokenizer.parseNumbers();
            streamTokenizer.ordinaryChar(45);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            n2 = 0;
            n = 0;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return false;
        }
        block12: while (true) {
            int n3 = 0;
            block13: do {
                switch (n3 == 0 ? streamTokenizer.nextToken() : n3) {
                    default: {
                        PsDebug.warning("parsing broke abnormally reading st.sval = " + streamTokenizer.sval + ", st.ttype = " + streamTokenizer.ttype + "  in line: " + streamTokenizer.lineno());
                        break;
                    }
                    case -1: {
                        if (n2 != 0) {
                            PsDebug.warning("'}' missing");
                            return false;
                        }
                        if (n == 0) return true;
                        PsDebug.warning("']' missing");
                        return false;
                    }
                    case -3: {
                        n3 = 44;
                        if ("InputForm".equals(streamTokenizer.sval)) continue block13;
                        if ("Graphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readGraphics(streamTokenizer, true)) {
                                PsDebug.warning("failed reading Graphics");
                                return false;
                            }
                            this.nextGraphics(n2);
                            break;
                        }
                        if ("Graphics3D".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readGraphics(streamTokenizer, true)) {
                                PsDebug.warning("failed reading Graphics3D");
                                return false;
                            }
                            this.nextGraphics(n2);
                            break;
                        }
                        if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                return false;
                            }
                            this.nextGraphics(n2);
                            break;
                        }
                        if ("DensityGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                return false;
                            }
                            this.nextGraphics(n2);
                            break;
                        }
                        if (!("KeyAnimation".equals(streamTokenizer.sval) || "Animation".equals(streamTokenizer.sval) || "ShowAnimation".equals(streamTokenizer.sval) || "GraphicsArray".equals(streamTokenizer.sval))) {
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        if ("KeyAnimation".equals(streamTokenizer.sval)) {
                            this.m_bIsKeyAnimation = true;
                        } else if ("Animation".equals(streamTokenizer.sval)) {
                            this.m_bIsAnimation = true;
                        } else if ("ShowAnimation".equals(streamTokenizer.sval)) {
                            this.m_bIsKeyAnimation = true;
                        } else if ("GraphicsArray".equals(streamTokenizer.sval)) {
                            this.m_isGraphicsArray = true;
                        }
                        streamTokenizer.nextToken();
                        int n4 = n2++;
                        int n5 = n++;
                        if (streamTokenizer.ttype != 123 && streamTokenizer.ttype != 91) {
                            PsDebug.warning("Expected '{' or '['  Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        while (n2 != n4 || n != n5) {
                            streamTokenizer.nextToken();
                            if ("Graphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readGraphics(streamTokenizer, true)) {
                                    PsDebug.warning("failed reading Graphics");
                                    continue;
                                }
                                this.nextGraphics(n2);
                                continue;
                            }
                            if ("Graphics3D".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readGraphics(streamTokenizer, true)) {
                                    PsDebug.warning("failed reading Graphics3D");
                                    continue;
                                }
                                this.nextGraphics(n2);
                                continue;
                            }
                            if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                    continue;
                                }
                                this.nextGraphics(n2);
                                continue;
                            }
                            if ("DensityGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                    return false;
                                }
                                this.nextGraphics(n2);
                                continue;
                            }
                            if (streamTokenizer.ttype == 123) {
                                ++n2;
                                continue;
                            }
                            if (streamTokenizer.ttype == 125) {
                                if (--n2 != 1) continue;
                                this.m_arrayCount1 = 0;
                                ++this.m_arrayCount0;
                                continue;
                            }
                            if (streamTokenizer.ttype == 91) {
                                ++n;
                                continue;
                            }
                            if (streamTokenizer.ttype == 93) {
                                --n;
                                continue;
                            }
                            if (streamTokenizer.ttype == 44) continue;
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if (!this.readOptions(streamTokenizer, true)) continue;
                            streamTokenizer.ordinaryChar(45);
                        }
                        break;
                    }
                    case 40: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 42) {
                            streamTokenizer.pushBack();
                            break;
                        }
                        int n4 = 1;
                        while (n4 != 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 42) continue;
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 41) {
                                n4 = 0;
                                continue;
                            }
                            streamTokenizer.pushBack();
                        }
                        break;
                    }
                    case 123: {
                        ++n2;
                        break;
                    }
                    case 125: {
                        if (--n2 == 1) {
                            this.m_arrayCount1 = 0;
                            ++this.m_arrayCount0;
                        }
                        n3 = 44;
                        if (n2 >= 0) continue block13;
                        PsDebug.warning("More '}' than '{' Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    case 91: {
                        ++n;
                        break;
                    }
                    case 93: {
                        if (--n < 0) {
                            PsDebug.warning("More ']' than '[' Line: " + streamTokenizer.lineno());
                            return false;
                        }
                    }
                    case 44: 
                }
                continue block12;
            } while (true);
        }
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.m_graphicsVector = new Vector();
        this.m_displayOptionVector = new Vector();
        this.m_viewVerticalVector = new Vector();
        this.m_defaultColorVector = new Vector();
        this.m_bndBoxColorVector = new Vector();
        this.m_boxRatioVector = new Vector();
        this.m_bGrayLevelVector = new Vector();
        this.m_bBlackWhiteVector = new Vector();
        this.m_graphicsArrayPosition = new Vector();
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        if (this.m_numGraphics == 0) {
            PsDebug.warning("missing graphics");
            return null;
        }
        this.evaluateOptions();
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.m_numGraphics) {
            n5 += this.m_animArr[n6].length;
            ++n6;
        }
        if (this.m_isGraphicsArray) {
            PiVector[] piVectorArray = new PiVector[this.m_numGraphics];
            n4 = 1;
            n3 = 0;
            while (n3 < this.m_numGraphics) {
                piVectorArray[n3] = (PiVector)this.m_graphicsArrayPosition.elementAt(n3);
                if (piVectorArray[n3].getSize() == 2) {
                    n4 = 2;
                }
                ++n3;
            }
            n3 = 0;
            n2 = 0;
            n = 0;
            while (n < this.m_numGraphics) {
                if (n4 == 1) {
                    if (n2 < piVectorArray[n].m_data[0]) {
                        n2 = piVectorArray[n].m_data[0];
                    }
                } else {
                    if (n3 < piVectorArray[n].m_data[0]) {
                        n3 = piVectorArray[n].m_data[0];
                    }
                    if (n2 < piVectorArray[n].m_data[1]) {
                        n2 = piVectorArray[n].m_data[1];
                    }
                }
                ++n;
            }
            ++n3;
            ++n2;
            n = 0;
            while (n < this.m_numGraphics) {
                if (n4 == 1) {
                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArrayPosition(piVectorArray[n].m_data[0]);
                } else {
                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArrayPosition(piVectorArray[n].m_data[0] * n2 + piVectorArray[n].m_data[1]);
                }
                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setArraySize(new Dimension(n2, n3));
                ++n;
            }
        } else {
            ((PvDisplayOption)this.m_displayOptionVector.elementAt(0)).setArrayPosition(0);
            ((PvDisplayOption)this.m_displayOptionVector.elementAt(0)).setArraySize(new Dimension(1, 1));
        }
        if (!this.isAnimation() && !this.isKeyAnimation() && this.m_animArr.length > 1) {
            PgJvxSrc[][] pgJvxSrcArrayArray = new PgJvxSrc[][]{new PgJvxSrc[n5]};
            n4 = 0;
            n3 = 0;
            while (n3 < this.m_numGraphics) {
                n2 = this.m_animArr[n3].length;
                n = 0;
                while (n < n2) {
                    pgJvxSrcArrayArray[0][n4] = this.m_animArr[n3][n];
                    ++n4;
                    ++n;
                }
                ++n3;
            }
            this.m_animArr = pgJvxSrcArrayArray;
        }
        if (this.m_animArr == null || this.m_animArr.length == 0) {
            return null;
        }
        return this.m_animArr[0];
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.m_displayOption = pvDisplayOption;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    private static String readString2(StreamTokenizer streamTokenizer) {
        try {
            boolean bl = false;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3 && "StyleForm".equals(streamTokenizer.sval)) {
                bl = true;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
            }
            String string = new String("");
            string = streamTokenizer.ttype == 34 ? PgMathLoader.readString(streamTokenizer) : (streamTokenizer.ttype == -3 ? string + streamTokenizer.sval : (streamTokenizer.ttype == -2 ? string + NumberFormat.getInstance().format(streamTokenizer.nval) : null));
            if (bl) {
                int n = 1;
                while (n != 0) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return null;
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.ttype != 93) continue;
                    --n;
                }
            }
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    public PvDisplayOption[] getDisplayOptions() {
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[this.m_numGraphics];
        int n = 0;
        while (n < this.m_numGraphics) {
            pvDisplayOptionArray[n] = (PvDisplayOption)this.m_displayOptionVector.elementAt(n);
            ++n;
        }
        return pvDisplayOptionArray;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        String string;
        int n;
        int n2;
        int n3;
        PiVector[] piVectorArray;
        int n4;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        int n5 = pgJvxSrc.getDimOfVertices();
        if (n5 != 2 && n5 != 3) {
            PsDebug.warning("wrong dimension of vertices, dim = " + n5);
            return false;
        }
        writer.write("(* Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("   JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("   by " + PsConfig.getAuthors() + "\n");
        writer.write("     File Format = Mathematica Graphics MGS\n");
        writer.write("     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("     Date        = " + new Date().toString() + "\n//\n");
        int n6 = pgJvxSrc.getNumVertices();
        writer.write("     Number of Vertices = " + n6 + "\n");
        int n7 = pgJvxSrc.getNumElements();
        if (n7 > 0) {
            writer.write("     Number of Elements = " + n7 + "\n");
        }
        if ((n4 = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("     Number of Polygons = " + n4 + "\n");
        }
        writer.write("\n End of Header *)\n");
        if (n5 == 3) {
            writer.write("Graphics3D[{");
        } else if (n5 == 2) {
            writer.write("Graphics[{");
        }
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        String string2 = null;
        Color[] colorArray = null;
        boolean bl = false;
        if (n4 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingPolygonColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                writer.write(string2 + ",");
            } else {
                colorArray = pgJvxSrc.getPolygonColors();
            }
            piVectorArray = pgJvxSrc.getPolygons();
            n3 = 0;
            while (n3 < n4) {
                if (pgJvxSrc.isShowingPolygonColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{" + string2 + ",");
                }
                writer.write("Line[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                    ++n;
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingPolygonColors()) {
                    writer.write("}");
                }
                if (n3 < n4 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n3;
            }
        } else if (n7 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingEdges()) {
                writer.write("EdgeForm[],");
            }
            if (!pgJvxSrc.isShowingElementColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                writer.write("SurfaceColor[" + string2 + "],");
            } else {
                colorArray = pgJvxSrc.getElementColors();
            }
            piVectorArray = pgJvxSrc.getElements();
            n3 = 0;
            while (n3 < n7) {
                if (pgJvxSrc.isShowingElementColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{" + string2 + ",");
                }
                writer.write("Polygon[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                    ++n;
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingElementColors()) {
                    writer.write("}");
                }
                if (n3 < n7 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n3;
            }
        }
        if (n6 > 0 && pgJvxSrc.isShowingVertices()) {
            if (bl) {
                writer.write(",\n");
            }
            int n8 = 0;
            while (n8 < n6) {
                writer.write("Point[");
                String string3 = PgMathLoader.writeVertex(pdVectorArray[n8]);
                writer.write(string3);
                writer.write("]");
                if (n8 < n6 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n8;
            }
        }
        writer.write("}]\n");
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    private static Color readRGBColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
            return new Color((float)pdVector.m_data[0], (float)pdVector.m_data[1], (float)pdVector.m_data[2]);
        }
        return Color.red;
    }

    private static int readSurfaceColor(StreamTokenizer streamTokenizer, Color[] colorArray) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            int n = 1;
            colorArray[0] = PgMathLoader.readColor(streamTokenizer);
            colorArray[1] = colorArray[0];
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                streamTokenizer.nextToken();
                colorArray[1] = PgMathLoader.readColor(streamTokenizer);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 44) {
                    n = (int)PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                }
            }
            return n;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 1;
        }
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("RGBColor[");
        stringBuffer.append(String.valueOf((float)color.getRed() / 255.0f) + ", " + String.valueOf((float)color.getGreen() / 255.0f) + ", " + String.valueOf((float)color.getBlue() / 255.0f) + "]");
        return stringBuffer.toString();
    }

    private static Color readColor(StreamTokenizer streamTokenizer) {
        if (streamTokenizer.ttype != -3 || !"CMYKColor".equals(streamTokenizer.sval) && !"GrayLevel".equals(streamTokenizer.sval) && !"Hue".equals(streamTokenizer.sval) && !"RGBColor".equals(streamTokenizer.sval)) {
            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue' or 'RGBColor' expected in line " + streamTokenizer.lineno());
        }
        if ("RGBColor".equals(streamTokenizer.sval)) {
            return PgMathLoader.readRGBColor(streamTokenizer);
        }
        if ("GrayLevel".equals(streamTokenizer.sval)) {
            return PgMathLoader.readGrayLevel(streamTokenizer);
        }
        if ("Hue".equals(streamTokenizer.sval)) {
            return PgMathLoader.readHueColor(streamTokenizer);
        }
        if ("CMYKColor".equals(streamTokenizer.sval)) {
            return PgMathLoader.readCMYKColor(streamTokenizer);
        }
        return Color.white;
    }

    private void setDisplayDefault() {
        this.m_defaultColor = null;
        this.m_bndBoxColor = null;
        this.m_bGrayLevel = false;
        this.m_bBlackWhite = false;
        this.m_boxRatio = null;
        this.m_displayOption.setBackgroundColor(Color.white);
        this.m_displayOption.clearTag(5);
        this.m_displayOption.setTag(6);
        this.m_displayOption.clearTag(9);
        this.m_displayOption.clearTag(11);
        this.m_displayOption.setTag(12);
        this.m_displayOption.clearTag(15);
        this.m_displayOption.setTag(22);
        this.m_displayOption.setNumLights(4);
        this.m_displayOption.setLightType(0, 0);
        this.m_displayOption.setAmbientLight(Color.black);
        this.m_displayOption.setLightColor(1, Color.red);
        this.m_displayOption.setLightPosition(1, new PdVector(1.0, 0.0, 1.0));
        this.m_displayOption.setLightType(1, 1);
        this.m_displayOption.setLightColor(2, Color.green);
        this.m_displayOption.setLightPosition(2, new PdVector(1.0, 1.0, 1.0));
        this.m_displayOption.setLightType(2, 1);
        this.m_displayOption.setLightColor(3, Color.blue);
        this.m_displayOption.setLightPosition(3, new PdVector(0.0, 1.0, 1.0));
        this.m_displayOption.setLightType(3, 1);
        this.m_displayOption.setNumCameras(1);
        this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
        this.m_displayOption.setCameraProjection(0, 0);
        this.m_displayOption.setCameraInterest(0, new PdVector(0.5, 0.5, 0.5));
        this.m_displayOption.setEnabledCameraClip(0, false);
        this.m_displayOption.setCameraFieldOfView(0, 0.5);
        this.m_displayOption.setCameraRoll(0, 0.0);
        this.m_displayOption.setCurrentCamera(0);
        this.m_displayOption.setCameraNearClip(0, 0.0);
        this.m_displayOption.setCameraFarClip(0, 0.0);
        this.m_viewVertical = new PdVector(0.0, 0.0, 1.0);
        PiVector piVector = new PiVector(6);
        piVector.setConstant(0);
        this.m_displayOption.setAxesEdge(piVector);
    }

    private static double readNumber(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
            }
            double d = streamTokenizer.nval;
            streamTokenizer.ordinaryChar(69);
            streamTokenizer.ordinaryChar(101);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 42) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 94) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        streamTokenizer.wordChars(69, 69);
                        streamTokenizer.wordChars(101, 101);
                        return d;
                    }
                    d *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else if (streamTokenizer.ttype == 69 || streamTokenizer.ttype == 101) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                    streamTokenizer.wordChars(69, 69);
                    streamTokenizer.wordChars(101, 101);
                    return d;
                }
                d *= Math.pow(10.0, streamTokenizer.nval);
            } else {
                streamTokenizer.pushBack();
            }
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return d;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return 0.0;
        }
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("{" + String.valueOf((float)pdVector.m_data[0]));
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(", ");
            if (Math.abs(pdVector.m_data[n2]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n2]);
            } else {
                stringBuffer.append("0.");
            }
            ++n2;
        }
        stringBuffer.append("}");
        n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == 'E' || stringBuffer.charAt(n2) == 'e') {
                stringBuffer.setCharAt(n2, '*');
                stringBuffer.insert(n2 + 1, '^');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalElementBackColor(Color.white);
                pgJvxSrc.setGlobalElementColor(Color.white);
                pgJvxSrc.showElements(true);
                if (pgJvxSrc.getElementNormals() != null || pgJvxSrc.getDimOfVertices() < 3) break;
                pgJvxSrc.makeElementNormals();
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
            case 36: {
                pgJvxSrc.showVertices(false);
                return;
            }
        }
    }

    private void adjustViewer() {
        PdVector pdVector = this.m_displayOption.getCameraInterest(0);
        PdVector pdVector2 = this.m_displayOption.getCameraPosition(0);
        PdVector pdVector3 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
        this.m_boxRatio = this.m_displayOption.getBoxRatio();
        if (this.m_boxRatio != null) {
            double d = this.m_boxRatio.m_data[0] + this.m_boxRatio.m_data[1] + this.m_boxRatio.m_data[2];
            int n = 0;
            do {
                if (this.m_boxRatio.m_data[n] == 0.0 || !(this.m_boxRatio.m_data[n] < d)) continue;
                d = this.m_boxRatio.m_data[n];
            } while (++n < 3);
            n = 0;
            do {
                if (this.m_boxRatio.m_data[n] == 0.0) continue;
                int n2 = n;
                pdVector2.m_data[n2] = pdVector2.m_data[n2] / (this.m_boxRatio.m_data[n] / d);
            } while (++n < 3);
        }
        int n = 0;
        do {
            int n3 = n;
            this.m_viewVertical.m_data[n3] = this.m_viewVertical.m_data[n3] * pdVector3.m_data[n];
            double d = pdVector.m_data[n];
            pdVector.m_data[n] = (1.0 - d) * this.m_boundingBoxMin.m_data[n] + d * this.m_boundingBoxMax.m_data[n];
            int n4 = n;
            pdVector3.m_data[n4] = pdVector3.m_data[n4] * (1.0 + 2.0 * Math.abs(0.5 - d));
            if (pdVector3.m_data[n] != 0.0) continue;
            pdVector3.m_data[n] = 1.0;
        } while (++n < 3);
        double d = 0.5;
        double d2 = pdVector2.length() - d;
        double d3 = d2 < 1.0E-10 ? 0.5 : 1.0 / d2;
        this.m_displayOption.setCameraFieldOfView(0, d3);
        pdVector2.normalize();
        pdVector2.multScalar(pdVector3.length());
        pdVector2.add(pdVector);
        PdVector pdVector4 = PdVector.subNew(pdVector2, pdVector);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
        if (!pdVector6.normalize()) {
            pdVector5.m_data[1] = pdVector5.m_data[1] + 1.0;
            pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
            if (!pdVector6.normalize()) {
                pdVector5.m_data[2] = pdVector5.m_data[2] + 1.0;
                pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
                if (!pdVector6.normalize()) {
                    pdVector5.m_data[2] = pdVector5.m_data[2] + 1.0;
                    pdVector6 = pdVector5.orthogonalPart(null, pdVector4);
                }
            }
        }
        PdVector pdVector7 = PdVector.crossNew(pdVector4, pdVector6);
        double d4 = -PdVector.angleWithOrientation(PdVector.crossNew(pdVector4, this.m_viewVertical), pdVector7, pdVector4) * 180.0 / Math.PI;
        this.m_displayOption.setCameraRoll(0, d4);
        int n5 = this.m_displayOption.getNumLights();
        if (n5 == 4 && PdVector.subNew(this.m_displayOption.getLightPosition(1), new PdVector(1.0, 0.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(1).getRGB() == -65536 && this.m_displayOption.getLightType(1) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(2), new PdVector(1.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(2).getRGB() == -16711936 && this.m_displayOption.getLightType(2) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(3), new PdVector(0.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(3).getRGB() == -16776961 && this.m_displayOption.getLightType(3) == 1 && this.m_displayOption.getAmbientLight().getRGB() == -16777216) {
            this.m_displayOption.setNumLights(6);
            n5 = 6;
            this.m_displayOption.setLightColor(4, Color.gray);
            this.m_displayOption.setLightPosition(4, new PdVector(-1.0, -1.0, -1.0));
            this.m_displayOption.setLightType(4, 1);
            this.m_displayOption.setLightColor(5, Color.blue);
            this.m_displayOption.setLightPosition(5, new PdVector(0.0, 0.0, -1.0));
            this.m_displayOption.setLightType(5, 1);
        }
        int n6 = 0;
        while (n6 < n5) {
            if (this.m_displayOption.getLightType(n6) == 1) {
                PdVector pdVector8 = this.m_displayOption.getLightPosition(n6);
                PdVector pdVector9 = PdVector.crossNew(pdVector4, this.m_viewVertical);
                if (!pdVector9.normalize() && !(pdVector9 = PdVector.crossNew(pdVector4, new PdVector(0.0, 1.0, 0.0))).normalize()) {
                    pdVector9 = PdVector.crossNew(pdVector4, new PdVector(0.0, 0.0, 1.0));
                    pdVector9.normalize();
                }
                PdVector pdVector10 = PdVector.crossNew(pdVector4, pdVector9);
                pdVector10.normalize();
                PdVector pdVector11 = PdVector.copyNew(pdVector4);
                pdVector11.normalize();
                PdVector pdVector12 = PdVector.blendNew(-pdVector8.m_data[0], pdVector9, -pdVector8.m_data[1], pdVector10);
                PdVector pdVector13 = PdVector.blendNew(pdVector8.m_data[2], pdVector11, 1.0, pdVector12);
                this.m_displayOption.setLightPosition(n6, pdVector13);
            }
            ++n6;
        }
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    private boolean readOptions(StreamTokenizer streamTokenizer) {
        return this.readOptions(streamTokenizer, false);
    }

    private boolean readOptions(StreamTokenizer streamTokenizer, boolean bl) {
        try {
            block184: {
                block187: {
                    block185: {
                        block188: {
                            block186: {
                                if ("Boxed".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if ("True".equals(streamTokenizer.sval)) {
                                        this.m_displayOption.setTag(12);
                                        if (bl) {
                                            int n = 0;
                                            while (n < this.m_numGraphics - 1) {
                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTag(12);
                                                ++n;
                                            }
                                        }
                                    } else {
                                        this.m_displayOption.clearTag(12);
                                        if (bl) {
                                            int n = 0;
                                            while (n < this.m_numGraphics - 1) {
                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).clearTag(12);
                                                ++n;
                                            }
                                        }
                                    }
                                    return true;
                                }
                                if ("AxesLabel".equals(streamTokenizer.sval)) {
                                    this.readAxesLabel(streamTokenizer, this.m_dim);
                                    if (bl) {
                                        int n = 0;
                                        while (n < this.m_numGraphics - 1) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setAxesLabel(this.m_displayOption.getAxesLabel());
                                            ++n;
                                        }
                                    }
                                    return true;
                                }
                                if ("ColorOutput".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if ("GrayLevel".equals(streamTokenizer.sval)) {
                                        this.m_bGrayLevel = true;
                                        this.m_bBlackWhite = false;
                                        return true;
                                    }
                                    if ("None".equals(streamTokenizer.sval)) {
                                        this.m_bGrayLevel = true;
                                        this.m_bBlackWhite = true;
                                        return true;
                                    }
                                    this.m_bGrayLevel = false;
                                    this.m_bBlackWhite = false;
                                    streamTokenizer.pushBack();
                                    return true;
                                }
                                if ("ColorFunction".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.ttype == -3) {
                                        this.m_colorFunction = "Hue".equals(streamTokenizer.sval) ? 1 : 0;
                                        return true;
                                    }
                                    if (streamTokenizer.ttype == 40 || streamTokenizer.ttype == 91 || streamTokenizer.ttype == 123) {
                                        int n = 1;
                                        while (n != 0) {
                                            streamTokenizer.nextToken();
                                            if (streamTokenizer.ttype == 40 || streamTokenizer.ttype == 91 || streamTokenizer.ttype == 123) {
                                                ++n;
                                                continue;
                                            }
                                            if (streamTokenizer.ttype != 41 && streamTokenizer.ttype != 93 && streamTokenizer.ttype != 125) continue;
                                            --n;
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                if ("ColorFunctionScaling".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    this.m_bColorFunctionScaling = "True".equals(streamTokenizer.sval);
                                    return true;
                                }
                                if ("AxesStyle".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.parseNumbers();
                                    if (streamTokenizer.ttype == -3) {
                                        if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                            Color color = PgMathLoader.readColor(streamTokenizer);
                                            int n = 0;
                                            while (n < this.m_dim) {
                                                this.m_displayOption.setRulerColor(n, color);
                                                if (bl) {
                                                    int n2 = 0;
                                                    while (n2 < this.m_numGraphics - 1) {
                                                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n2)).setRulerColor(n, color);
                                                        ++n2;
                                                    }
                                                }
                                                ++n;
                                            }
                                        } else if ("Thickness".equals(streamTokenizer.sval)) {
                                            streamTokenizer.nextToken();
                                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                            int n = 0;
                                            while (n < this.m_dim) {
                                                this.m_displayOption.setRulerSize(n, d);
                                                if (bl) {
                                                    int n3 = 0;
                                                    while (n3 < this.m_numGraphics - 1) {
                                                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n3)).setRulerSize(n, d);
                                                        ++n3;
                                                    }
                                                }
                                                ++n;
                                            }
                                            streamTokenizer.nextToken();
                                        } else if ("AbsoluteThickness".equals(streamTokenizer.sval)) {
                                            streamTokenizer.nextToken();
                                            double d = PgMathLoader.readNumber(streamTokenizer);
                                            int n = 0;
                                            while (n < this.m_dim) {
                                                this.m_displayOption.setRulerSize(n, d);
                                                if (bl) {
                                                    int n4 = 0;
                                                    while (n4 < this.m_numGraphics - 1) {
                                                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n4)).setRulerSize(n, d);
                                                        ++n4;
                                                    }
                                                }
                                                ++n;
                                            }
                                            streamTokenizer.nextToken();
                                        }
                                    } else {
                                        streamTokenizer.nextToken();
                                        if (streamTokenizer.ttype == -3) {
                                            int n = 1;
                                            streamTokenizer.pushBack();
                                            while (n > 0) {
                                                streamTokenizer.nextToken();
                                                if (streamTokenizer.ttype == -1) {
                                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                                    return false;
                                                }
                                                if (streamTokenizer.ttype == -3) {
                                                    int n5;
                                                    int n6;
                                                    if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                                        Color color = PgMathLoader.readColor(streamTokenizer);
                                                        int n7 = 0;
                                                        while (n7 < this.m_dim) {
                                                            this.m_displayOption.setRulerColor(n7, color);
                                                            if (bl) {
                                                                n6 = 0;
                                                                while (n6 < this.m_numGraphics - 1) {
                                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n6)).setRulerColor(n7, color);
                                                                    ++n6;
                                                                }
                                                            }
                                                            ++n7;
                                                        }
                                                        continue;
                                                    }
                                                    if ("Thickness".equals(streamTokenizer.sval)) {
                                                        streamTokenizer.nextToken();
                                                        double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                                        n6 = 0;
                                                        while (n6 < this.m_dim) {
                                                            this.m_displayOption.setRulerSize(n6, d);
                                                            if (bl) {
                                                                n5 = 0;
                                                                while (n5 < this.m_numGraphics - 1) {
                                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n5)).setRulerSize(n6, d);
                                                                    ++n5;
                                                                }
                                                            }
                                                            ++n6;
                                                        }
                                                        streamTokenizer.nextToken();
                                                        continue;
                                                    }
                                                    if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                                    streamTokenizer.nextToken();
                                                    double d = PgMathLoader.readNumber(streamTokenizer);
                                                    n6 = 0;
                                                    while (n6 < this.m_dim) {
                                                        this.m_displayOption.setRulerSize(n6, d);
                                                        if (bl) {
                                                            n5 = 0;
                                                            while (n5 < this.m_numGraphics - 1) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n5)).setRulerSize(n6, d);
                                                                ++n5;
                                                            }
                                                        }
                                                        ++n6;
                                                    }
                                                    streamTokenizer.nextToken();
                                                    continue;
                                                }
                                                if (streamTokenizer.ttype == 123) {
                                                    ++n;
                                                    continue;
                                                }
                                                if (streamTokenizer.ttype != 125) continue;
                                                --n;
                                            }
                                        } else {
                                            streamTokenizer.pushBack();
                                            int n = 0;
                                            while (n < this.m_dim) {
                                                streamTokenizer.nextToken();
                                                int n8 = 1;
                                                while (n8 > 0) {
                                                    streamTokenizer.nextToken();
                                                    if (streamTokenizer.ttype == -1) {
                                                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                                        return false;
                                                    }
                                                    if (streamTokenizer.ttype == -3) {
                                                        int n9;
                                                        if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                                            Color color = PgMathLoader.readColor(streamTokenizer);
                                                            this.m_displayOption.setRulerColor(n, color);
                                                            if (!bl) continue;
                                                            int n10 = 0;
                                                            while (n10 < this.m_numGraphics - 1) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n10)).setRulerColor(n, color);
                                                                ++n10;
                                                            }
                                                            continue;
                                                        }
                                                        if ("Thickness".equals(streamTokenizer.sval)) {
                                                            streamTokenizer.nextToken();
                                                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                                            this.m_displayOption.setRulerSize(n, d);
                                                            if (bl) {
                                                                n9 = 0;
                                                                while (n9 < this.m_numGraphics - 1) {
                                                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n9)).setRulerSize(n, d);
                                                                    ++n9;
                                                                }
                                                            }
                                                            streamTokenizer.nextToken();
                                                            continue;
                                                        }
                                                        if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                                        streamTokenizer.nextToken();
                                                        double d = PgMathLoader.readNumber(streamTokenizer);
                                                        if (bl) {
                                                            n9 = 0;
                                                            while (n9 < this.m_numGraphics - 1) {
                                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n9)).setRulerSize(n, d);
                                                                ++n9;
                                                            }
                                                        }
                                                        streamTokenizer.nextToken();
                                                        continue;
                                                    }
                                                    if (streamTokenizer.ttype == 123) {
                                                        ++n8;
                                                        continue;
                                                    }
                                                    if (streamTokenizer.ttype != 125) continue;
                                                    --n8;
                                                }
                                                streamTokenizer.nextToken();
                                                ++n;
                                            }
                                        }
                                    }
                                    return true;
                                }
                                if ("PlotLabel".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                                        return true;
                                    }
                                    streamTokenizer.pushBack();
                                    this.m_displayOption.setTag(33);
                                    String string = PgMathLoader.readString2(streamTokenizer);
                                    this.m_displayOption.setTitle(string);
                                    if (bl) {
                                        int n = 0;
                                        while (n < this.m_numGraphics - 1) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTag(33);
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTitle(string);
                                            ++n;
                                        }
                                    }
                                    return true;
                                }
                                if ("PlotRange".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    streamTokenizer.parseNumbers();
                                    streamTokenizer.nextToken();
                                    double[][] dArrayArray = new double[this.m_dim][];
                                    int n = 0;
                                    while (n < this.m_dim) {
                                        dArrayArray[n] = new double[]{Double.NEGATIVE_INFINITY, Double.MAX_VALUE};
                                        n += 1;
                                    }
                                    n = 0;
                                    if (streamTokenizer.ttype != -3 || !"All".equals(streamTokenizer.sval) && !"Automatic".equals(streamTokenizer.sval)) {
                                        n = 1;
                                        streamTokenizer.nextToken();
                                        if (streamTokenizer.ttype == -2) {
                                            streamTokenizer.pushBack();
                                            double[] dArray = new double[2];
                                            dArray[0] = PgMathLoader.readNumber(streamTokenizer);
                                            streamTokenizer.nextToken();
                                            dArray[1] = PgMathLoader.readNumber(streamTokenizer);
                                            streamTokenizer.nextToken();
                                            if (dArray[0] <= dArray[1]) {
                                                dArrayArray[this.m_dim - 1] = dArray;
                                            }
                                        } else {
                                            streamTokenizer.pushBack();
                                            int n11 = 0;
                                            while (n11 < this.m_dim) {
                                                streamTokenizer.nextToken();
                                                if (streamTokenizer.ttype != -3 || !"All".equals(streamTokenizer.sval) && !"Automatic".equals(streamTokenizer.sval)) {
                                                    double[] dArray = new double[2];
                                                    dArray[0] = PgMathLoader.readNumber(streamTokenizer);
                                                    streamTokenizer.nextToken();
                                                    dArray[1] = PgMathLoader.readNumber(streamTokenizer);
                                                    streamTokenizer.nextToken();
                                                    if (dArray[0] <= dArray[1]) {
                                                        dArrayArray[n11] = dArray;
                                                    }
                                                }
                                                streamTokenizer.nextToken();
                                                ++n11;
                                            }
                                        }
                                    }
                                    int n12 = 0;
                                    while (n12 < this.m_dim) {
                                        this.m_displayOption.setClipBounds(n12, dArrayArray[n12]);
                                        if (bl) {
                                            int n13 = 0;
                                            while (n13 < this.m_numGraphics - 1) {
                                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n13)).setClipBounds(n12, (double[])dArrayArray[n12].clone());
                                                ++n13;
                                            }
                                        }
                                        ++n12;
                                    }
                                    this.m_displayOption.setOption(36, n != 0);
                                    if (bl) {
                                        n12 = 0;
                                        while (n12 < this.m_numGraphics - 1) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n12)).setOption(36, true);
                                            ++n12;
                                        }
                                    }
                                    return true;
                                }
                                if (!"BoxStyle".equals(streamTokenizer.sval)) break block184;
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                if (streamTokenizer.ttype != -3) break block185;
                                if (!"RGBColor".equals(streamTokenizer.sval) && !"Hue".equals(streamTokenizer.sval) && !"GrayLevel".equals(streamTokenizer.sval) && !"CMYKColor".equals(streamTokenizer.sval)) break block186;
                                this.m_bndBoxColor = PgMathLoader.readColor(streamTokenizer);
                                break block187;
                            }
                            if (!"Thickness".equals(streamTokenizer.sval)) break block188;
                            streamTokenizer.nextToken();
                            double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                            this.m_displayOption.setBndBoxSize(d);
                            if (bl) {
                                int n = 0;
                                while (n < this.m_numGraphics - 1) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setBndBoxSize(d);
                                    ++n;
                                }
                            }
                            streamTokenizer.nextToken();
                            break block187;
                        }
                        if (!"AbsoluteThickness".equals(streamTokenizer.sval)) break block187;
                        streamTokenizer.nextToken();
                        double d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                        this.m_displayOption.setBndBoxSize(d);
                        if (bl) {
                            int n = 0;
                            while (n < this.m_numGraphics - 1) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setBndBoxSize(d);
                                ++n;
                            }
                        }
                        streamTokenizer.nextToken();
                        break block187;
                    }
                    if (streamTokenizer.ttype == 123) {
                        int n = 1;
                        while (n > 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if (streamTokenizer.ttype == -3) {
                                int n14;
                                double d;
                                if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                                    this.m_bndBoxColor = PgMathLoader.readColor(streamTokenizer);
                                    continue;
                                }
                                if ("Thickness".equals(streamTokenizer.sval)) {
                                    streamTokenizer.nextToken();
                                    d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                    this.m_displayOption.setBndBoxSize(d);
                                    if (bl) {
                                        n14 = 0;
                                        while (n14 < this.m_numGraphics - 1) {
                                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n14)).setBndBoxSize(d);
                                            ++n14;
                                        }
                                    }
                                    streamTokenizer.nextToken();
                                    continue;
                                }
                                if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                this.m_displayOption.setBndBoxSize(d);
                                if (bl) {
                                    n14 = 0;
                                    while (n14 < this.m_numGraphics - 1) {
                                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n14)).setBndBoxSize(d);
                                        ++n14;
                                    }
                                }
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (streamTokenizer.ttype == 123) {
                                ++n;
                                continue;
                            }
                            if (streamTokenizer.ttype != 125) continue;
                            --n;
                        }
                    }
                }
                return true;
            }
            if ("DefaultColor".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("Automatic".equals(streamTokenizer.sval)) {
                    Color color = this.m_displayOption.getBackgroundColor();
                    if (color != null) {
                        int n = 0;
                        int n15 = 0;
                        int n16 = 0;
                        if (color.getRed() < 127) {
                            n16 = 255;
                        }
                        if (color.getBlue() < 127) {
                            n = 255;
                        }
                        if (color.getGreen() < 127) {
                            n15 = 255;
                        }
                        this.m_defaultColor = new Color(n16, n15, n);
                    }
                } else {
                    this.m_defaultColor = PgMathLoader.readColor(streamTokenizer);
                }
                return true;
            }
            if ("ImageSize".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    int n = (int)streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    int n17 = (int)streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    this.m_displayOption.setWindowSize(n, n17);
                    if (bl) {
                        int n18 = 0;
                        while (n18 < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n18)).setWindowSize(n, n17);
                            ++n18;
                        }
                    }
                }
                return true;
            }
            if ("Axes".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval) || "Automatic".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(5);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTag(5);
                            ++n;
                        }
                    }
                } else {
                    this.m_displayOption.clearTag(5);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).clearTag(5);
                            ++n;
                        }
                    }
                }
                return true;
            }
            if ("Lighting".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(22);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTag(22);
                            ++n;
                        }
                    }
                } else {
                    this.m_displayOption.clearTag(22);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).clearTag(22);
                            ++n;
                        }
                    }
                }
                return true;
            }
            if ("LightSources".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 125) {
                    this.m_displayOption.setNumLights(1);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setNumLights(1);
                            ++n;
                        }
                    }
                } else {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        PdVector[] pdVectorArray = new PdVector[1];
                        Color[] colorArray = new Color[1];
                        pdVectorArray[0] = new PdVector(3);
                        int n = 0;
                        do {
                            streamTokenizer.pushBack();
                            pdVectorArray[0].m_data[n] = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } while (++n < 3);
                        streamTokenizer.nextToken();
                        colorArray[0] = PgMathLoader.readColor(streamTokenizer);
                        streamTokenizer.nextToken();
                    } else {
                        int n;
                        Vector<PdVector> vector = new Vector<PdVector>();
                        Vector<Color> vector2 = new Vector<Color>();
                        while (streamTokenizer.ttype != 125) {
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            PdVector pdVector = new PdVector(3);
                            n = 0;
                            do {
                                pdVector.m_data[n] = PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                            } while (++n < 3);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            Color color = PgMathLoader.readColor(streamTokenizer);
                            streamTokenizer.nextToken();
                            vector.addElement(pdVector);
                            vector2.addElement(color);
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 44) continue;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        }
                        PdVector[] pdVectorArray = new PdVector[vector.size()];
                        Color[] colorArray = new Color[vector2.size()];
                        int n19 = vector.size();
                        this.m_displayOption.setNumLights(n19 + 1);
                        if (bl) {
                            int n20 = 0;
                            while (n20 < this.m_numGraphics - 1) {
                                ((PvDisplayOption)this.m_displayOptionVector.elementAt(n20)).setNumLights(n19 + 1);
                                ++n20;
                            }
                        }
                        int n21 = 0;
                        while (n21 < n19) {
                            pdVectorArray[n21] = (PdVector)vector.elementAt(n21);
                            colorArray[n21] = (Color)vector2.elementAt(n21);
                            this.m_displayOption.setLightColor(n21 + 1, (Color)vector2.elementAt(n21));
                            this.m_displayOption.setLightPosition(n21 + 1, (PdVector)vector.elementAt(n21));
                            this.m_displayOption.setLightType(n21 + 1, 1);
                            if (bl) {
                                n = 0;
                                while (n < this.m_numGraphics - 1) {
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightColor(n21 + 1, (Color)vector2.elementAt(n21));
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightPosition(n21 + 1, (PdVector)((PdVector)vector.elementAt(n21)).clone());
                                    ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setLightType(n21 + 1, 1);
                                    ++n;
                                }
                            }
                            ++n21;
                        }
                    }
                }
                return true;
            }
            if ("ViewPoint".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                PdVector pdVector = new PdVector();
                if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                    return false;
                }
                this.m_displayOption.setCameraPosition(0, pdVector);
                if (bl) {
                    int n = 0;
                    while (n < this.m_numGraphics - 1) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setCameraPosition(0, (PdVector)pdVector.clone());
                        ++n;
                    }
                }
                return true;
            }
            if ("ViewCenter".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.pushBack();
                    PdVector pdVector = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    this.m_displayOption.setCameraInterest(0, pdVector);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setCameraInterest(0, (PdVector)pdVector.clone());
                            ++n;
                        }
                    }
                }
                return true;
            }
            if ("AxesEdge".equals(streamTokenizer.sval)) {
                int n;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PiVector piVector = new PiVector(6);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    n = 0;
                    do {
                        piVector.m_data[n] = -1;
                    } while (++n < 6);
                } else {
                    n = 0;
                    do {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3) {
                            if ("Automatic".equals(streamTokenizer.sval)) {
                                piVector.m_data[n * 2] = -1;
                                piVector.m_data[n * 2 + 1] = -1;
                            } else {
                                piVector.m_data[n * 2] = 0;
                                piVector.m_data[n * 2 + 1] = 0;
                            }
                        } else {
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2 + 1] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                    } while (++n < 3);
                }
                this.m_displayOption.setAxesEdge(piVector);
                if (bl) {
                    n = 0;
                    while (n < this.m_numGraphics - 1) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setAxesEdge((PiVector)piVector.clone());
                        ++n;
                    }
                }
                return true;
            }
            if ("AmbientLight".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                Color color = PgMathLoader.readColor(streamTokenizer);
                this.m_displayOption.setAmbientLight(color);
                if (bl) {
                    int n = 0;
                    while (n < this.m_numGraphics - 1) {
                        ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setAmbientLight(color);
                        ++n;
                    }
                }
                return true;
            }
            if ("BoxRatios".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                this.m_boxRatio = null;
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.pushBack();
                    PdVector pdVector = new PdVector(3);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    this.m_boxRatio = pdVector;
                }
                return true;
            }
            if ("Background".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval))) {
                    Color color;
                    Color color2 = PgMathLoader.readColor(streamTokenizer);
                    this.m_displayOption.setBackgroundColor(color2);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setBackgroundColor(color2);
                            ++n;
                        }
                    }
                    if (this.m_defaultColor == null && (color = this.m_displayOption.getBackgroundColor()) != null) {
                        int n = 0;
                        int n22 = 0;
                        int n23 = 0;
                        if (color.getRed() < 127) {
                            n23 = 255;
                        }
                        if (color.getBlue() < 127) {
                            n = 255;
                        }
                        if (color.getGreen() < 127) {
                            n22 = 255;
                        }
                        this.m_defaultColor = new Color(n23, n22, n);
                    }
                }
                return true;
            }
            if ("PolygonIntersections".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("False".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(30);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).setTag(30);
                            ++n;
                        }
                    }
                } else {
                    this.m_displayOption.clearTag(30);
                    if (bl) {
                        int n = 0;
                        while (n < this.m_numGraphics - 1) {
                            ((PvDisplayOption)this.m_displayOptionVector.elementAt(n)).clearTag(30);
                            ++n;
                        }
                    }
                }
                return true;
            }
            if ("ViewVertical".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    return true;
                }
                streamTokenizer.pushBack();
                streamTokenizer.parseNumbers();
                return PgMathLoader.parseVector(streamTokenizer, this.m_viewVertical, 3);
            }
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private void evaluateOptions() {
        if (!(this.m_isGraphicsArray || this.m_bIsAnimation || this.m_bIsKeyAnimation)) {
            int n;
            int n2;
            this.m_displayOption = (PvDisplayOption)this.m_displayOptionVector.elementAt(0);
            this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(0);
            this.m_defaultColor = (Color)this.m_defaultColorVector.elementAt(0);
            this.m_bndBoxColor = (Color)this.m_bndBoxColorVector.elementAt(0);
            this.m_boxRatio = (PdVector)this.m_boxRatioVector.elementAt(0);
            this.m_bGrayLevel = (Boolean)this.m_bGrayLevelVector.elementAt(0);
            this.m_bBlackWhite = (Boolean)this.m_bBlackWhiteVector.elementAt(0);
            this.m_dim = 0;
            int n3 = 0;
            this.m_animArr = new PgJvxSrc[this.m_numGraphics][];
            int n4 = 0;
            while (n4 < this.m_numGraphics) {
                this.m_animArr[n4] = (PgJvxSrc[])this.m_graphicsVector.elementAt(n4);
                int n5 = this.m_animArr[n4].length;
                n3 += n5;
                n2 = 0;
                while (n2 < n5) {
                    n = this.m_animArr[n4][n2].getDimOfVertices();
                    if (n > this.m_dim) {
                        this.m_dim = n;
                    }
                    ++n2;
                }
                ++n4;
            }
            this.m_boundingBoxMin = new PdVector(3);
            this.m_boundingBoxMax = new PdVector(3);
            PdVector[] pdVectorArray = new PdVector[n3];
            PdVector[] pdVectorArray2 = new PdVector[n3];
            n2 = 0;
            n = 0;
            while (n < this.m_numGraphics) {
                int n6 = this.m_animArr[n].length;
                int n7 = 0;
                while (n7 < n6) {
                    PdVector[] pdVectorArray3 = this.m_animArr[n][n7].getBounds();
                    if (pdVectorArray3 != null) {
                        pdVectorArray[n2] = pdVectorArray3[0];
                        pdVectorArray2[n2] = pdVectorArray3[1];
                        ++n2;
                    }
                    ++n7;
                }
                n += 1;
            }
            if (n2 != 0) {
                PdVector.min(this.m_boundingBoxMin, pdVectorArray, n2);
                PdVector.max(this.m_boundingBoxMax, pdVectorArray2, n2);
            } else {
                this.m_boundingBoxMin.setConstant(-10.0);
                this.m_boundingBoxMax.setConstant(10.0);
            }
            int n8 = n = this.m_boxRatio == null ? 0 : 1;
            if (n) {
                PdVector pdVector = new PdVector(3);
                double d = this.m_boundingBoxMax.m_data[0] - this.m_boundingBoxMin.m_data[0];
                pdVector.setEntry(0, this.m_boxRatio.m_data[0]);
                pdVector.setEntry(1, this.m_boxRatio.m_data[1] * d / (this.m_boundingBoxMax.m_data[1] - this.m_boundingBoxMin.m_data[1]));
                pdVector.setEntry(2, this.m_boxRatio.m_data[2] * d / (this.m_boundingBoxMax.m_data[2] - this.m_boundingBoxMin.m_data[2]));
                this.m_displayOption.setBoxRatio(pdVector);
            } else {
                this.m_displayOption.setBoxRatio(null);
            }
            this.m_displayOption.setOption(35, n != 0);
            if (this.m_dim == 3) {
                this.adjustViewer();
                this.m_displayOption.setAxesType(2);
            } else {
                this.m_displayOption.setCameraProjection(0, 1);
                PdVector pdVector = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
                this.m_displayOption.setCameraInterest(0, pdVector);
                PdVector pdVector2 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
                double d = pdVector2.max();
                pdVector = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, d);
                this.m_displayOption.setCameraPosition(0, pdVector);
                this.m_displayOption.setCameraRoll(0, 0.0);
                this.m_displayOption.setCurrentCamera(1);
                this.m_displayOption.setCameraFieldOfView(0, 0.0);
                this.m_displayOption.clearTag(12);
                this.m_displayOption.setAxesType(3);
            }
            this.m_displayOption.setOption(3, false);
            this.m_displayOption.setOption(2, false);
            if (this.m_displayOption.getAxesType() != -1) {
                this.m_displayOption.setNumRulers(this.m_dim);
                String[] stringArray = this.m_displayOption.getAxesLabel();
                int n9 = 0;
                while (n9 < this.m_dim) {
                    if (stringArray != null && stringArray.length > n9) {
                        this.m_displayOption.setRulerName(n9, stringArray[n9]);
                    }
                    this.m_displayOption.setRulerMode(n9, 0);
                    this.m_displayOption.showRuler(n9, true);
                    if (this.m_displayOption.getRulerName(n9) == null) {
                        this.m_displayOption.showRulerName(n9, false);
                    }
                    this.m_displayOption.showRulerNumbers(n9, true);
                    this.m_displayOption.showRulerHashingsNormal(n9, false);
                    this.m_displayOption.showRulerHashingsUp(n9, false);
                    this.m_displayOption.showRulerTicksMajor(n9, true);
                    this.m_displayOption.showRulerTicksMinor(n9, true);
                    ++n9;
                }
            }
            int n10 = 0;
            while (n10 < this.m_numGraphics) {
                int n11 = this.m_animArr[n10].length;
                int n12 = 0;
                while (n12 < n11) {
                    PgJvxSrc pgJvxSrc = this.m_animArr[n10][n12];
                    if (pgJvxSrc.getType() == 33 && pgJvxSrc.getDimOfVertices() == 3) {
                        this.computeMathematicaColors(pgJvxSrc);
                    }
                    ++n12;
                }
                ++n10;
            }
            return;
        }
        int n = 0;
        this.m_animArr = new PgJvxSrc[this.m_numGraphics][];
        int n13 = 0;
        while (n13 < this.m_numGraphics) {
            Object object;
            this.m_displayOption = (PvDisplayOption)this.m_displayOptionVector.elementAt(n13);
            this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(n13);
            this.m_defaultColor = (Color)this.m_defaultColorVector.elementAt(n13);
            this.m_bndBoxColor = (Color)this.m_bndBoxColorVector.elementAt(n13);
            this.m_boxRatio = (PdVector)this.m_boxRatioVector.elementAt(n13);
            this.m_bGrayLevel = (Boolean)this.m_bGrayLevelVector.elementAt(n13);
            this.m_bBlackWhite = (Boolean)this.m_bBlackWhiteVector.elementAt(n13);
            this.m_animArr[n13] = (PgJvxSrc[])this.m_graphicsVector.elementAt(n13);
            int n14 = this.m_animArr[n13].length;
            n += n14;
            this.m_dim = 0;
            int n15 = 0;
            while (n15 < n14) {
                int n16 = this.m_animArr[n13][n15].getDimOfVertices();
                if (n16 > this.m_dim) {
                    this.m_dim = n16;
                }
                ++n15;
            }
            this.m_boundingBoxMin = new PdVector(3);
            this.m_boundingBoxMax = new PdVector(3);
            PdVector[] pdVectorArray = new PdVector[n14];
            PdVector[] pdVectorArray4 = new PdVector[n14];
            int n17 = 0;
            int n18 = 0;
            while (n18 < n14) {
                object = this.m_animArr[n13][n18].getBounds();
                if (object != null) {
                    pdVectorArray[n17] = object[0];
                    pdVectorArray4[n17] = object[1];
                    ++n17;
                }
                ++n18;
            }
            if (n17 != 0) {
                PdVector.min(this.m_boundingBoxMin, pdVectorArray, n17);
                PdVector.max(this.m_boundingBoxMax, pdVectorArray4, n17);
            } else {
                this.m_boundingBoxMin.setConstant(-10.0);
                this.m_boundingBoxMax.setConstant(10.0);
            }
            if (this.m_dim == 3) {
                this.m_viewVertical = (PdVector)this.m_viewVerticalVector.elementAt(n13);
                this.adjustViewer();
                this.m_displayOption.setAxesType(2);
            } else {
                this.m_displayOption.setCameraProjection(0, 1);
                PdVector pdVector = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
                this.m_displayOption.setCameraInterest(0, pdVector);
                object = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
                double d = ((PdVector)object).max();
                pdVector = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, d);
                this.m_displayOption.setCameraPosition(0, pdVector);
                this.m_displayOption.setCameraRoll(0, 0.0);
                this.m_displayOption.setCurrentCamera(1);
                this.m_displayOption.setCameraFieldOfView(0, 0.0);
                this.m_displayOption.clearTag(12);
                this.m_displayOption.setAxesType(3);
            }
            this.m_displayOption.setOption(3, false);
            this.m_displayOption.setOption(2, false);
            if (this.m_displayOption.getAxesType() != -1) {
                this.m_displayOption.setNumRulers(this.m_dim);
                int n19 = 0;
                while (n19 < this.m_dim) {
                    if (this.m_displayOption.getAxesLabel() != null && this.m_displayOption.m_axesLabel.length > n19 && this.m_displayOption.getAxesLabel()[n19] != null) {
                        this.m_displayOption.setRulerName(n19, this.m_displayOption.getAxesLabel()[n19]);
                    }
                    this.m_displayOption.setRulerMode(n19, 0);
                    this.m_displayOption.showRuler(n19, true);
                    this.m_displayOption.showRulerNumbers(n19, true);
                    this.m_displayOption.showRulerHashingsNormal(n19, false);
                    this.m_displayOption.showRulerHashingsUp(n19, false);
                    this.m_displayOption.showRulerTicksMajor(n19, true);
                    this.m_displayOption.showRulerTicksMinor(n19, true);
                    ++n19;
                }
            }
            n18 = 0;
            while (n18 < n14) {
                object = this.m_animArr[n13][n18];
                if (((PgGeometry)object).getType() == 33 && ((PgGeometry)object).getDimOfVertices() == 3) {
                    this.computeMathematicaColors((PgJvxSrc)object);
                }
                ++n18;
            }
            ++n13;
        }
    }

    private static Color readGrayLevel(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            double d = PgMathLoader.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            return new Color((float)d, (float)d, (float)d);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return Color.gray;
        }
    }

    private void readAxesLabel(StreamTokenizer streamTokenizer, int n) {
        try {
            int n2;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            String[] stringArray = new String[n];
            if (streamTokenizer.ttype == -3) {
                if ("None".equals(streamTokenizer.sval)) {
                    int n3 = 0;
                    while (n3 < n) {
                        stringArray[n3] = "";
                        ++n3;
                    }
                    this.m_displayOption.setAxesLabel(stringArray);
                    this.m_displayOption.clearTag(9);
                    return;
                }
                streamTokenizer.pushBack();
            }
            if (streamTokenizer.ttype == 123) {
                this.m_displayOption.setTag(9);
                n2 = 0;
                while (n2 < n) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                        stringArray[n2] = "";
                    } else {
                        streamTokenizer.pushBack();
                        stringArray[n2] = PgMathLoader.readString2(streamTokenizer);
                    }
                    streamTokenizer.ordinaryChar(92);
                    int n4 = 1;
                    while (n4 != 0) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44 && n4 == 1 || streamTokenizer.ttype == 125 || streamTokenizer.ttype == 93) {
                            --n4;
                        } else if (streamTokenizer.ttype == 123 || streamTokenizer.ttype == 91) {
                            ++n4;
                        }
                        if (n4 <= 0) continue;
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            continue;
                        }
                        if (streamTokenizer.ttype == -3) {
                            int n5 = n2;
                            stringArray[n5] = stringArray[n5] + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            streamTokenizer.pushBack();
                            int n6 = n2;
                            stringArray[n6] = stringArray[n6] + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 91) {
                            int n7 = n2;
                            stringArray[n7] = stringArray[n7] + "[";
                            continue;
                        }
                        if (streamTokenizer.ttype == 93) {
                            int n8 = n2;
                            stringArray[n8] = stringArray[n8] + "]";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            int n9 = n2;
                            stringArray[n9] = stringArray[n9] + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            int n10 = n2;
                            stringArray[n10] = stringArray[n10] + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype == 94) {
                            int n11 = n2;
                            stringArray[n11] = stringArray[n11] + "^";
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            int n12 = n2;
                            stringArray[n12] = stringArray[n12] + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            int n13 = n2;
                            stringArray[n13] = stringArray[n13] + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 40) {
                            int n14 = n2;
                            stringArray[n14] = stringArray[n14] + "(";
                            continue;
                        }
                        if (streamTokenizer.ttype == 41) {
                            int n15 = n2;
                            stringArray[n15] = stringArray[n15] + ")";
                            continue;
                        }
                        if (streamTokenizer.ttype == 45) {
                            int n16 = n2;
                            stringArray[n16] = stringArray[n16] + "-";
                            continue;
                        }
                        if (streamTokenizer.ttype == 62) {
                            int n17 = n2;
                            stringArray[n17] = stringArray[n17] + ">";
                            continue;
                        }
                        if (streamTokenizer.ttype == 47) {
                            int n18 = n2;
                            stringArray[n18] = stringArray[n18] + "/";
                            continue;
                        }
                        if (streamTokenizer.ttype != 92) continue;
                        int n19 = n2;
                        stringArray[n19] = stringArray[n19] + "\\";
                    }
                    streamTokenizer.whitespaceChars(92, 92);
                    ++n2;
                }
            } else {
                this.m_displayOption.setTag(9);
                n2 = 0;
                while (n2 < n - 1) {
                    stringArray[n2] = "";
                    ++n2;
                }
                stringArray[n - 1] = PgMathLoader.readString2(streamTokenizer);
            }
            n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] != null && "".equals(stringArray[n2])) {
                    stringArray[n2] = null;
                }
                ++n2;
            }
            this.m_displayOption.setAxesLabel(stringArray);
            return;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return;
        }
    }

    private static String readString(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.ordinaryChar(92);
            streamTokenizer.ordinaryChar(32);
            streamTokenizer.nextToken();
            String string = new String("");
            while (streamTokenizer.ttype != 34) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                    return null;
                }
                if (streamTokenizer.ttype == -3) {
                    string = string + streamTokenizer.sval;
                } else if (streamTokenizer.ttype == -2) {
                    streamTokenizer.pushBack();
                    string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                } else if (streamTokenizer.ttype == 32) {
                    string = string + " ";
                } else if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                } else if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                } else if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                } else if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                } else if (streamTokenizer.ttype == 94) {
                    string = string + "^";
                } else if (streamTokenizer.ttype == 123) {
                    string = string + "{";
                } else if (streamTokenizer.ttype == 125) {
                    string = string + "}";
                } else if (streamTokenizer.ttype == 40) {
                    string = string + "(";
                } else if (streamTokenizer.ttype == 41) {
                    string = string + ")";
                } else if (streamTokenizer.ttype == 45) {
                    string = string + "-";
                } else if (streamTokenizer.ttype == 62) {
                    string = string + ">";
                } else if (streamTokenizer.ttype == 47) {
                    string = string + "/";
                } else if (streamTokenizer.ttype == 92) {
                    string = string + "\\";
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(92, 92);
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    private void computeMathematicaColors(PgJvxSrc pgJvxSrc) {
        if (!this.m_displayOption.hasTag(22)) {
            return;
        }
        if (pgJvxSrc.getDimOfVertices() != 3) {
            return;
        }
        int n = pgJvxSrc.getNumElements();
        if (n == 0) {
            return;
        }
        Color[] colorArray = new Color[n];
        Color[] colorArray2 = new Color[n];
        int n2 = this.m_displayOption.getNumLights();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.m_displayOption.getLightType(n4) == 1) {
                ++n3;
            }
            ++n4;
        }
        Color[] colorArray3 = new Color[n3];
        PdVector[] pdVectorArray = new PdVector[n3];
        Color color = this.m_displayOption.getAmbientLight();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            if (this.m_displayOption.getLightType(n6) == 1) {
                colorArray3[n5] = this.m_displayOption.getLightColor(n6);
                pdVectorArray[n5] = this.m_displayOption.getLightPosition(n6);
                ++n5;
            }
            ++n6;
        }
        pgJvxSrc.makeElementNormals();
        PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
        Color[] colorArray4 = pgJvxSrc.getElementColors();
        Color[] colorArray5 = pgJvxSrc.getElementBackColors();
        int n7 = 0;
        while (n7 < n) {
            double d = color.getRed();
            double d2 = color.getGreen();
            double d3 = color.getBlue();
            double d4 = d;
            double d5 = d2;
            double d6 = d3;
            int n8 = 0;
            while (n8 < n3) {
                double d7 = PdVector.dot(pdVectorArray2[n7], pdVectorArray[n8]) / pdVectorArray[n8].length();
                if (d7 > 0.0) {
                    d += d7 * (double)colorArray3[n8].getRed();
                    d2 += d7 * (double)colorArray3[n8].getGreen();
                    d3 += d7 * (double)colorArray3[n8].getBlue();
                } else {
                    d4 -= d7 * (double)colorArray3[n8].getRed();
                    d5 -= d7 * (double)colorArray3[n8].getGreen();
                    d6 -= d7 * (double)colorArray3[n8].getBlue();
                }
                ++n8;
            }
            Color color2 = colorArray4[n7];
            d = Math.min(d, (double)color2.getRed());
            d /= 255.0;
            d2 = Math.min(d2, (double)color2.getGreen());
            d2 /= 255.0;
            d3 = Math.min(d3, (double)color2.getBlue());
            d3 /= 255.0;
            Color color3 = colorArray5[n7];
            d4 = Math.min(d4, (double)color3.getRed());
            d4 /= 255.0;
            d5 = Math.min(d5, (double)color3.getGreen());
            d5 /= 255.0;
            d6 = Math.min(d6, (double)color3.getBlue());
            d6 /= 255.0;
            if (this.m_bGrayLevel) {
                double d8 = (d + d2 + d3) / 3.0;
                if (this.m_bBlackWhite) {
                    d8 = d8 > 0.5 ? 1.0 : 0.0;
                }
                colorArray[n7] = new Color((float)d8, (float)d8, (float)d8);
                d8 = (d4 + d5 + d6) / 3.0;
                if (this.m_bBlackWhite) {
                    d8 = d8 >= 0.5 ? 1.0 : 0.0;
                }
                colorArray2[n7] = new Color((float)d8, (float)d8, (float)d8);
            } else {
                colorArray[n7] = new Color((float)d, (float)d2, (float)d3);
                colorArray2[n7] = new Color((float)d4, (float)d5, (float)d6);
            }
            ++n7;
        }
        pgJvxSrc.setElementColors(colorArray);
        pgJvxSrc.setElementBackColors(colorArray2);
    }

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return true;
    }

    public boolean isKeyAnimation() {
        return this.m_bIsKeyAnimation;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    private void nextGraphics(int n) {
        int n2;
        this.m_displayOption.setNumRulers(this.m_dim);
        if (this.m_bndBoxColor != null) {
            this.m_displayOption.setBndBoxColor(this.m_bndBoxColor);
        } else if (this.m_defaultColor != null) {
            this.m_displayOption.setBndBoxColor(this.m_defaultColor);
        } else {
            Color color = this.m_displayOption.getBackgroundColor();
            if (color != null) {
                n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (color.getRed() < 127) {
                    n4 = 255;
                }
                if (color.getBlue() < 127) {
                    n2 = 255;
                }
                if (color.getGreen() < 127) {
                    n3 = 255;
                }
                this.m_displayOption.setBndBoxColor(new Color(n4, n3, n2));
            } else {
                this.m_displayOption.setBndBoxColor(Color.black);
            }
        }
        int n5 = 0;
        while (n5 < this.m_dim) {
            Color color = this.m_displayOption.getRulerColor(n5);
            if (color == null) {
                if (this.m_defaultColor != null) {
                    color = this.m_defaultColor;
                } else {
                    Color color2 = this.m_displayOption.getBackgroundColor();
                    if (color2 != null) {
                        int n6 = 0;
                        int n7 = 0;
                        n2 = 0;
                        if (color2.getRed() < 127) {
                            n2 = 255;
                        }
                        if (color2.getBlue() < 127) {
                            n6 = 255;
                        }
                        if (color2.getGreen() < 127) {
                            n7 = 255;
                        }
                        color = new Color(n2, n7, n6);
                    } else {
                        color = Color.black;
                    }
                }
                this.m_displayOption.setRulerColor(n5, color);
            }
            ++n5;
        }
        this.m_displayOptionVector.addElement(this.m_displayOption);
        PiVector piVector = new PiVector(n);
        if (n == 1) {
            piVector.m_data[0] = this.m_arrayCount0++;
        } else if (n > 1) {
            piVector.setSize(2);
            piVector.m_data[0] = this.m_arrayCount0;
            piVector.m_data[1] = this.m_arrayCount1++;
        }
        this.m_graphicsArrayPosition.addElement(piVector);
        this.m_viewVerticalVector.addElement(PdVector.copyNew(this.m_viewVertical));
        this.m_defaultColorVector.addElement(this.m_defaultColor);
        this.m_bndBoxColorVector.addElement(this.m_bndBoxColor);
        if (this.m_boxRatio != null) {
            this.m_boxRatioVector.addElement(PdVector.copyNew(this.m_boxRatio));
        } else {
            this.m_boxRatioVector.addElement(null);
        }
        this.m_bGrayLevelVector.addElement(new Boolean(this.m_bGrayLevel));
        this.m_bBlackWhiteVector.addElement(new Boolean(this.m_bBlackWhite));
        this.m_displayOption = new PvDisplayOption();
        this.setDisplayDefault();
        ++this.m_numGraphics;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private boolean readParametricSurface(StreamTokenizer streamTokenizer) {
        try {
            int n;
            this.m_colorFunction = 0;
            this.m_bColorFunctionScaling = true;
            streamTokenizer.parseNumbers();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            Vector<PdVector> vector = new Vector<PdVector>();
            Vector[] vectorArray = new Vector[4];
            int n2 = 0;
            do {
                vectorArray[n2] = new Vector();
            } while (++n2 <= 3);
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            Color color = null;
            double d = 1.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            int n3 = 0;
            int n4 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                ++n4;
                int n5 = n3;
                n3 = 0;
                while (streamTokenizer.ttype != 125) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    ++n3;
                    if (this.m_dim == 3) {
                        PdVector pdVector = new PdVector(3);
                        pdVector.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        vector.addElement(pdVector);
                    } else if (this.m_dim == 2) {
                        double d6 = PgMathLoader.readNumber(streamTokenizer);
                        bl = true;
                        n = 0;
                        do {
                            vectorArray[n].addElement(new PdVector(d6));
                        } while (++n <= 3);
                    }
                    streamTokenizer.nextToken();
                }
                if (n4 > 1 && n5 != n3) {
                    PsDebug.warning("Number of U-Lines not constant - V-Line: " + n4 + " Line: " + streamTokenizer.lineno());
                    return false;
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.nextToken();
            int n6 = 1;
            d2 = 1.0;
            d4 = 1.0;
            d3 = n3;
            d5 = n4;
            while (n6 != 0) {
                streamTokenizer.ordinaryChar(45);
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("PgMathLoader.readElementSet: ']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n6;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n6;
                }
                if (streamTokenizer.ttype == -3) {
                    if (this.readOptions(streamTokenizer)) {
                        streamTokenizer.ordinaryChar(45);
                    } else if ("Mesh".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl3 = "True".equals(streamTokenizer.sval);
                    } else if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                        streamTokenizer.parseNumbers();
                        bl = true;
                        Color color2 = PgMathLoader.readColor(streamTokenizer);
                        n = 0;
                        do {
                            vectorArray[n].addElement(color2);
                        } while (++n <= 3);
                        piVector.addEntry(1);
                        piVector2.addEntry(1);
                    } else if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        streamTokenizer.parseNumbers();
                        bl = true;
                        Color[] colorArray = new Color[2];
                        n = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                        piVector.addEntry(n);
                        piVector2.addEntry(n);
                        int n7 = 0;
                        do {
                            vectorArray[n7].addElement(colorArray[0]);
                        } while (++n7 <= 1);
                        n7 = 2;
                        do {
                            vectorArray[n7].addElement(colorArray[1]);
                        } while (++n7 <= 3);
                    } else if ("FaceForm".equals(streamTokenizer.sval)) {
                        Color[] colorArray;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                        }
                        streamTokenizer.parseNumbers();
                        bl = true;
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray = new Color[2];
                            piVector.addEntry(PgMathLoader.readSurfaceColor(streamTokenizer, colorArray));
                            vectorArray[0].addElement(colorArray[0]);
                            vectorArray[2].addElement(colorArray[1]);
                        } else {
                            colorArray = PgMathLoader.readColor(streamTokenizer);
                            vectorArray[0].addElement(colorArray);
                            vectorArray[2].addElement(colorArray);
                            piVector.addEntry(1);
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                                PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                            }
                            if ("SurfaceColor".equals(streamTokenizer.sval)) {
                                colorArray = new Color[2];
                                piVector2.addEntry(PgMathLoader.readSurfaceColor(streamTokenizer, colorArray));
                                vectorArray[1].addElement(colorArray[0]);
                                vectorArray[3].addElement(colorArray[1]);
                            } else {
                                colorArray = PgMathLoader.readColor(streamTokenizer);
                                vectorArray[1].addElement(colorArray);
                                vectorArray[3].addElement(colorArray);
                                piVector2.addEntry(1);
                            }
                            streamTokenizer.nextToken();
                        } else {
                            int n8 = vectorArray[0].size() - 1;
                            vectorArray[1].addElement(vectorArray[0].elementAt(n8));
                            vectorArray[3].addElement(vectorArray[2].elementAt(n8));
                            piVector2.addEntry(piVector.m_data[n8]);
                        }
                    } else if ("MeshStyle".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        int n9 = -1;
                        while (n9 != 0) {
                            if (n9 == -1) {
                                n9 = 0;
                            }
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            streamTokenizer.nextToken();
                            streamTokenizer.parseNumbers();
                            if (streamTokenizer.ttype == 123) {
                                ++n9;
                                continue;
                            }
                            if (streamTokenizer.ttype == 125) {
                                --n9;
                                continue;
                            }
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                color = PgMathLoader.readColor(streamTokenizer);
                                continue;
                            }
                            if ("Thickness".equals(streamTokenizer.sval)) {
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if ("EdgeForm".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            bl3 = false;
                        }
                        while (streamTokenizer.ttype != 93) {
                            if (streamTokenizer.ttype == -3) {
                                if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                    bl2 = true;
                                    streamTokenizer.parseNumbers();
                                    color = PgMathLoader.readColor(streamTokenizer);
                                }
                                if (!"Thickness".equals(streamTokenizer.sval)) continue;
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (streamTokenizer.ttype == -1) {
                                PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            streamTokenizer.nextToken();
                        }
                    } else if ("MeshRange".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                            streamTokenizer.parseNumbers();
                            streamTokenizer.nextToken();
                            d2 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d3 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.ordinaryChar(45);
                        }
                    } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl4 = "True".equals(streamTokenizer.sval);
                    } else if ("Shading".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl5 = "True".equals(streamTokenizer.sval);
                    } else if ("Prolog".equals(streamTokenizer.sval) || "Epilog".equals(streamTokenizer.sval)) {
                        int n10 = this.m_dim;
                        this.m_dim = 2;
                        if (this.readGraphics(streamTokenizer, false)) {
                            ++this.m_numGraphics;
                        }
                        this.m_dim = n10;
                    }
                }
                streamTokenizer.nextToken();
            }
            if (this.m_dim == 2) {
                ++n3;
                ++n4;
                int n11 = 0;
                while (n11 < n3 * n4) {
                    vector.addElement(new PdVector(2));
                    ++n11;
                }
            }
            double d7 = (d3 - d2) / (double)(n3 - 1);
            double d8 = (d5 - d4) / (double)(n4 - 1);
            int n12 = 0;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            pgJvxSrc.setDimOfVertices(this.m_dim);
            pgJvxSrc.setNumVertices(n3 * n4);
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            int n13 = 0;
            while (n13 < n4) {
                int n14 = 0;
                while (n14 < n3) {
                    pdVectorArray[n13 * n3 + n14].copy((PdVector)vector.elementAt(n12));
                    pdVectorArray[n13 * n3 + n14].m_data[0] = d2 + (double)n14 * d7;
                    pdVectorArray[n13 * n3 + n14].m_data[1] = d4 + (double)n13 * d8;
                    ++n12;
                    ++n14;
                }
                ++n13;
            }
            pgJvxSrc.setDimOfElements(4);
            pgJvxSrc.setNumElements((n3 - 1) * (n4 - 1));
            pgJvxSrc.assureNeighbours();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
            int n15 = 0;
            int n16 = 0;
            while (n16 < n4 - 1) {
                int n17 = 0;
                while (n17 < n3 - 1) {
                    piVectorArray[n15].m_data[0] = n16 * n3 + n17;
                    piVectorArray[n15].m_data[1] = (n16 + 1) * n3 + n17;
                    piVectorArray[n15].m_data[2] = (n16 + 1) * n3 + n17 + 1;
                    piVectorArray[n15].m_data[3] = n16 * n3 + n17 + 1;
                    if (n16 < n4 - 2) {
                        piVectorArray2[n15].m_data[0] = n15 + n3 - 1;
                    }
                    if (n17 < n3 - 2) {
                        piVectorArray2[n15].m_data[1] = n15 + 1;
                    }
                    if (n16 > 0) {
                        piVectorArray2[n15].m_data[2] = n15 - n3 + 1;
                    }
                    if (n17 > 0) {
                        piVectorArray2[n15].m_data[3] = n15 - 1;
                    }
                    ++n15;
                    ++n17;
                }
                ++n16;
            }
            PgMathLoader.geomInitType(pgJvxSrc);
            pgJvxSrc.showEdges(bl3);
            if (this.m_dim == 3) {
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n16 = (n3 - 1) * (n4 - 1);
                Color[][] colorArrayArray = new Color[4][];
                int n18 = 0;
                do {
                    colorArrayArray[n18] = new Color[n16];
                } while (++n18 <= 3);
                if (bl) {
                    if (vectorArray[0].size() == n16) {
                        n18 = 0;
                        while (n18 < n16) {
                            int n19 = 0;
                            do {
                                colorArrayArray[n19][n18] = (Color)vectorArray[n19].elementAt(n18);
                            } while (++n19 <= 3);
                            ++n18;
                        }
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    } else {
                        n18 = 0;
                        do {
                            Color color3 = (Color)vectorArray[n18].elementAt(0);
                            int n20 = 0;
                            while (n20 < n16) {
                                colorArrayArray[n18][n20] = color3;
                                ++n20;
                            }
                        } while (++n18 <= 3);
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    }
                } else {
                    n18 = 0;
                    while (n18 < n16) {
                        int n21 = 0;
                        do {
                            colorArrayArray[n21][n18] = Color.white;
                        } while (++n21 <= 3);
                        ++n18;
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                } else if (this.m_defaultColor != null) {
                    pgJvxSrc.setGlobalEdgeColor(this.m_defaultColor);
                }
            } else if (this.m_dim == 2) {
                pgJvxSrc.setDimOfVertices(2);
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n16 = (n3 - 1) * (n4 - 1);
                Color[] colorArray = new Color[n16];
                if (bl) {
                    if (vectorArray[0].size() == n16) {
                        double d9;
                        double d10 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        double d11 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        int n22 = 0;
                        while (n22 < n16) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n22)).m_data[0];
                            if (d9 > d11) {
                                d11 = d9;
                            }
                            if (d9 < d10) {
                                d10 = d9;
                            }
                            ++n22;
                        }
                        if (d10 == d11) {
                            d11 += 1.0;
                        }
                        n22 = 0;
                        while (n22 < n16) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n22)).m_data[0];
                            if (this.m_bColorFunctionScaling) {
                                d9 = (d9 - d10) / (d11 - d10);
                            }
                            colorArray[n22] = this.m_colorFunction == 0 ? new Color((float)d9, (float)d9, (float)d9) : new Color(Color.HSBtoRGB((float)d9, 1.0f, 1.0f));
                            ++n22;
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    } else {
                        int n23 = 0;
                        while (n23 < n16) {
                            colorArray[n23] = Color.gray;
                            ++n23;
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    }
                } else {
                    int n24 = 0;
                    while (n24 < n16) {
                        colorArray[n24] = Color.gray;
                        ++n24;
                    }
                    pgJvxSrc.setElementColors(colorArray);
                    pgJvxSrc.setElementBackColors(colorArray);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                }
            }
            if (!this.m_displayOption.hasTag(22) && this.m_dim == 3) {
                n16 = pgJvxSrc.getNumElements();
                Color[] colorArray = new Color[n16];
                Color[] colorArray2 = new Color[n16];
                double d12 = pdVectorArray[0].m_data[2];
                double d13 = pdVectorArray[0].m_data[2];
                int n25 = 0;
                while (n25 < n3 * n4) {
                    if (pdVectorArray[n25].m_data[2] > d13) {
                        d13 = pdVectorArray[n25].m_data[2];
                    }
                    if (pdVectorArray[n25].m_data[2] < d12) {
                        d12 = pdVectorArray[n25].m_data[2];
                    }
                    ++n25;
                }
                double d14 = d13 - d12;
                PiVector[] piVectorArray3 = pgJvxSrc.getElements();
                PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
                int n26 = 0;
                while (n26 < n16) {
                    PiVector piVector3 = piVectorArray3[n26];
                    int n27 = piVector3.getSize();
                    double d15 = 0.0;
                    int n28 = 0;
                    while (n28 < n27) {
                        d15 += pdVectorArray2[piVector3.m_data[n28]].m_data[2];
                        ++n28;
                    }
                    double d16 = this.m_bColorFunctionScaling ? (d15 - d12) / d14 : (d15 /= (double)n27);
                    colorArray[n26] = this.m_colorFunction == 0 ? new Color((float)d16, (float)d16, (float)d16) : new Color(Color.HSBtoRGB((float)d16, 1.0f, 1.0f));
                    colorArray2[n26] = colorArray[n26];
                    ++n26;
                }
                pgJvxSrc.setElementColors(colorArray);
                pgJvxSrc.setElementBackColors(colorArray2);
            }
            pgJvxSrc.setGlobalEdgeSize(d);
            this.m_geomArr = new PgJvxSrc[1];
            this.m_geomArr[0] = pgJvxSrc;
            this.m_graphicsVector.addElement(this.m_geomArr);
            streamTokenizer.ordinaryChar(45);
            streamTokenizer.pushBack();
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private static Color readHueColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            float f = (float)PgMathLoader.readNumber(streamTokenizer);
            float f2 = 1.0f;
            float f3 = 1.0f;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                f2 = (float)PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                f3 = (float)PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
            }
            return new Color(Color.HSBtoRGB(f, f2, f3));
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return Color.red;
        }
    }

    private static Color readCMYKColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (PgMathLoader.parseVector(streamTokenizer, pdVector, 4)) {
            return new Color((float)(1.0 - (pdVector.m_data[0] + pdVector.m_data[3])), (float)(1.0 - (pdVector.m_data[1] + pdVector.m_data[3])), (float)(1.0 - (pdVector.m_data[2] + pdVector.m_data[3])));
        }
        PsDebug.warning("Reading of CMYKColor failed.");
        return Color.red;
    }

    private boolean readGraphics(StreamTokenizer streamTokenizer, boolean bl) {
        try {
            Color color;
            int n;
            int n2;
            streamTokenizer.parseNumbers();
            this.m_defaultColor = null;
            Vector[] vectorArray = new Vector[7];
            Vector vector = new Vector();
            vector.addElement(null);
            int n3 = 0;
            do {
                vectorArray[n3] = new Vector();
                vectorArray[n3].addElement(null);
            } while (++n3 <= 5);
            PiVector piVector = new PiVector(1);
            piVector.m_data[0] = 1;
            PiVector piVector2 = new PiVector(1);
            piVector2.m_data[0] = 1;
            vectorArray[6] = new Vector();
            vectorArray[6].addElement(null);
            boolean bl2 = false;
            boolean bl3 = false;
            Vector[] vectorArray2 = new Vector[12];
            int n4 = 0;
            do {
                vectorArray2[n4] = new Vector();
            } while (++n4 <= 11);
            Vector<PdVector> vector2 = new Vector<PdVector>();
            Vector<PiVector> vector3 = new Vector<PiVector>();
            Vector<PdVector> vector4 = new Vector<PdVector>();
            Vector<PdVector[]> vector5 = new Vector<PdVector[]>();
            Vector<PgJvxSrc> vector6 = new Vector<PgJvxSrc>();
            Vector<PdVector> vector7 = new Vector<PdVector>();
            Vector<PdVector> vector8 = new Vector<PdVector>();
            Vector vector9 = new Vector();
            Vector<PdVector> vector10 = new Vector<PdVector>();
            Vector<Double> vector11 = new Vector<Double>();
            PdVector pdVector = new PdVector(1);
            pdVector.m_data[0] = this.m_dim == 3 ? 0.01 : 0.008;
            pdVector.m_data[0] = pdVector.m_data[0] * 200.0;
            boolean bl4 = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            boolean bl5 = true;
            if (this.m_dim == 2) {
                bl5 = false;
            }
            double d = 1.0;
            double d2 = 1.0;
            int n13 = 0;
            if (bl) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'['Expected Line: " + streamTokenizer.lineno());
                    return false;
                }
            }
            String string = "";
            int n14 = -1;
            while (n14 != 0) {
                if (n14 == -1) {
                    n14 = 0;
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 45 && !bl) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                }
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 123) {
                    int n15;
                    int n16 = vector.size();
                    if (++n14 + 1 > n16) {
                        vector.addElement(vector.elementAt(n16 - 1));
                        n15 = 0;
                        do {
                            vectorArray[n15].addElement(vectorArray[n15].elementAt(n16 - 1));
                        } while (++n15 <= 6);
                        piVector.setSize(n14 + 1);
                        piVector2.setSize(n14 + 1);
                        pdVector.setSize(n14 + 1);
                    } else {
                        vector.setElementAt(vector.elementAt(n14 - 1), n14);
                        n15 = 0;
                        do {
                            vectorArray[n15].setElementAt(vectorArray[n15].elementAt(n14 - 1), n14);
                        } while (++n15 <= 6);
                    }
                    piVector.m_data[n14] = piVector.m_data[n14 - 1];
                    piVector2.m_data[n14] = piVector2.m_data[n14 - 1];
                    pdVector.m_data[n14] = pdVector.m_data[n14 - 1];
                    continue;
                }
                if (streamTokenizer.ttype == 125) {
                    --n14;
                    continue;
                }
                if (streamTokenizer.ttype == 44) continue;
                if (streamTokenizer.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifyer expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                if ("Polygon".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    int n17 = 0;
                    while (streamTokenizer.ttype != 125) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        PdVector pdVector2 = new PdVector(this.m_dim);
                        if (!PgMathLoader.parseVector(streamTokenizer, pdVector2, this.m_dim)) {
                            return false;
                        }
                        vector2.addElement(pdVector2);
                        ++n17;
                        ++n5;
                        streamTokenizer.nextToken();
                    }
                    PiVector piVector3 = new PiVector(n17);
                    int n18 = 0;
                    while (n18 < n17) {
                        piVector3.m_data[n18] = n13 + n18;
                        ++n18;
                    }
                    n13 += n17;
                    vector3.addElement(piVector3);
                    ++n6;
                    streamTokenizer.nextToken();
                    n18 = 0;
                    do {
                        vectorArray2[n18].addElement(vectorArray[n18].elementAt(n14));
                    } while (++n18 <= 6);
                    continue;
                }
                if ("Point".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector3 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector3, this.m_dim)) {
                        return false;
                    }
                    vector4.addElement(pdVector3);
                    vector11.addElement(new Double(pdVector.m_data[n14]));
                    ++n7;
                    streamTokenizer.nextToken();
                    vectorArray2[7].addElement(vector.elementAt(n14));
                    continue;
                }
                if ("Line".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    Vector<PdVector> vector12 = new Vector<PdVector>();
                    int n19 = 0;
                    while (streamTokenizer.ttype != 125) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        PdVector pdVector4 = new PdVector();
                        if (!PgMathLoader.parseVector(streamTokenizer, pdVector4, this.m_dim)) {
                            return false;
                        }
                        vector12.addElement(pdVector4);
                        ++n19;
                        streamTokenizer.nextToken();
                    }
                    PgJvxSrc pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(this.m_dim);
                    pgJvxSrc.setNumVertices(n19);
                    int n20 = 0;
                    while (n20 < n19) {
                        pgJvxSrc.setVertex(n20, (PdVector)vector12.elementAt(n20));
                        ++n20;
                    }
                    ++n9;
                    vector6.addElement(pgJvxSrc);
                    streamTokenizer.nextToken();
                    vectorArray2[8].addElement(vector.elementAt(n14));
                    continue;
                }
                if ("Arrow".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector[] pdVectorArray = new PdVector[2];
                    pdVectorArray[0] = new PdVector(this.m_dim);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVectorArray[0], this.m_dim)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    pdVectorArray[1] = new PdVector(this.m_dim);
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVectorArray[1], this.m_dim)) {
                        return false;
                    }
                    vector5.addElement(pdVectorArray);
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                    }
                    ++n8;
                    continue;
                }
                if ("Circle".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector5 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector5, 2)) {
                        return false;
                    }
                    pdVector5.setSize(4);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        pdVector5.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        pdVector5.m_data[3] = pdVector5.m_data[2];
                    } else {
                        pdVector5.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector5.m_data[3] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        pdVector5.setSize(6);
                        streamTokenizer.nextToken();
                        pdVector5.m_data[4] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector5.m_data[5] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    }
                    ++n10;
                    vector7.addElement(pdVector5);
                    vectorArray2[10].addElement(vector.elementAt(n14));
                    continue;
                }
                if ("Disk".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector6 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector6, 2)) {
                        return false;
                    }
                    pdVector6.setSize(4);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        pdVector6.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        pdVector6.m_data[3] = pdVector6.m_data[2];
                    } else {
                        pdVector6.m_data[2] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector6.m_data[3] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        pdVector6.setSize(6);
                        streamTokenizer.nextToken();
                        pdVector6.m_data[4] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        pdVector6.m_data[5] = PgMathLoader.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    }
                    ++n11;
                    vector8.addElement(pdVector6);
                    vectorArray2[9].addElement(vectorArray[0].elementAt(n14));
                    continue;
                }
                if ("Rectangle".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector7 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector7, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector8 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector8, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        if (this.m_dim != 2) {
                            PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        PiVector piVector4 = new PiVector(4);
                        int n21 = 0;
                        do {
                            piVector4.m_data[n21] = n13 + n21;
                        } while (++n21 < 4);
                        vector3.addElement(piVector4);
                        ++n6;
                        PdVector[] pdVectorArray = new PdVector[]{pdVector7, new PdVector(pdVector8.m_data[0], pdVector7.m_data[1]), pdVector8, new PdVector(pdVector7.m_data[0], pdVector8.m_data[1])};
                        int n22 = 0;
                        do {
                            vector2.addElement(pdVectorArray[n22]);
                        } while (++n22 < 4);
                        n5 += 4;
                        n13 += 4;
                        n22 = 0;
                        do {
                            vectorArray2[n22].addElement(vectorArray[n22].elementAt(n14));
                        } while (++n22 <= 6);
                        continue;
                    }
                    string = string + "Rectangle[{" + pdVector7.m_data[0] + "," + pdVector7.m_data[1] + "},{" + pdVector8.m_data[0] + "," + pdVector8.m_data[1] + "}" + streamTokenizer.sval;
                    int n23 = 1;
                    while (n23 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            --n23;
                            string = string + "]";
                        }
                        if (streamTokenizer.ttype == 91) {
                            ++n23;
                            string = string + "[";
                        }
                        if (streamTokenizer.ttype == -3) {
                            string = string + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            streamTokenizer.pushBack();
                            string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            string = string + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            string = string + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            string = string + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            string = string + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype != 94) continue;
                        string = string + "^";
                    }
                    continue;
                }
                if ("Raster".equals(streamTokenizer.sval) || "RasterArray".equals(streamTokenizer.sval)) {
                    int n24;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    Vector<Serializable> vector13;
                    boolean bl6 = false;
                    if ("Raster".equals(streamTokenizer.sval)) {
                        bl6 = true;
                    }
                    streamTokenizer.nextToken();
                    int n25 = -1;
                    int n26 = 0;
                    streamTokenizer.nextToken();
                    if (bl6) {
                        vector13 = new Vector<Serializable>();
                        n2 = 0;
                        while (streamTokenizer.ttype != 125) {
                            int n27 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 125) {
                                if (streamTokenizer.ttype == -1) {
                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                    return false;
                                }
                                vector13.addElement(new Double(PgMathLoader.readNumber(streamTokenizer)));
                                streamTokenizer.nextToken();
                                ++n27;
                            }
                            if (n25 == -1) {
                                n25 = n27;
                            }
                            if (n27 != n25) {
                                PsDebug.warning("Different length of lines in Raster");
                                return false;
                            }
                            ++n26;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d7 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d6 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 44) {
                                streamTokenizer.nextToken();
                                double d8 = PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                double d9 = PgMathLoader.readNumber(streamTokenizer);
                                d9 -= d8;
                                streamTokenizer.nextToken();
                                int n28 = 0;
                                while (n28 < n26) {
                                    int n29 = 0;
                                    while (n29 < n25) {
                                        d3 = ((Double)vector13.elementAt(n28 * n25 + n29) - d8) / d9;
                                        if (d3 > 1.0) {
                                            d3 = 1.0;
                                        }
                                        if (d3 < 0.0) {
                                            d3 = 0.0;
                                        }
                                        Color color2 = new Color((float)d3, (float)d3, (float)d3);
                                        int n30 = 0;
                                        do {
                                            vectorArray2[n30].addElement(color2);
                                        } while (++n30 <= 5);
                                        vectorArray2[6].addElement(vectorArray[6].elementAt(n14));
                                        ++n29;
                                    }
                                    ++n28;
                                }
                                n2 = 1;
                                streamTokenizer.nextToken();
                            }
                        } else {
                            d7 = 0.0;
                            d6 = 0.0;
                            d5 = n25;
                            d4 = n26;
                        }
                        if (n2 == 0) {
                            int n31 = 0;
                            while (n31 < n26) {
                                n24 = 0;
                                while (n24 < n25) {
                                    d3 = (Double)vector13.elementAt(n31 * n25 + n24);
                                    if (d3 > 1.0) {
                                        d3 = 1.0;
                                    }
                                    if (d3 < 0.0) {
                                        d3 = 0.0;
                                    }
                                    Color color3 = new Color((float)d3, (float)d3, (float)d3);
                                    int n32 = 0;
                                    do {
                                        vectorArray2[n32].addElement(color3);
                                    } while (++n32 <= 5);
                                    vectorArray2[6].addElement(vectorArray[6].elementAt(n14));
                                    ++n24;
                                }
                                ++n31;
                            }
                        }
                    } else {
                        vector13 = new Vector();
                        while (streamTokenizer.ttype != 125) {
                            int n33 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 125) {
                                if (streamTokenizer.ttype == -1) {
                                    PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                                    return false;
                                }
                                streamTokenizer.nextToken();
                                vector13.addElement(PgMathLoader.readColor(streamTokenizer));
                                streamTokenizer.nextToken();
                                ++n33;
                            }
                            if (n25 == -1) {
                                n25 = n33;
                            }
                            if (n33 != n25) {
                                PsDebug.warning("Different length of lines in Raster");
                                return false;
                            }
                            ++n26;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d7 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d6 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d5 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            d4 = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } else {
                            d7 = 0.0;
                            d6 = 0.0;
                            d5 = n25;
                            d4 = n26;
                        }
                        n2 = 0;
                        while (n2 < n26) {
                            int n34 = 0;
                            while (n34 < n25) {
                                Color color4 = (Color)vector13.elementAt(n2 * n25 + n34);
                                int n35 = 0;
                                do {
                                    vectorArray2[n35].addElement(color4);
                                } while (++n35 <= 5);
                                vectorArray2[6].addElement(vectorArray[6].elementAt(n14));
                                ++n34;
                            }
                            ++n2;
                        }
                    }
                    double d10 = (d5 - d7) / (double)n25;
                    d3 = (d4 - d6) / (double)n26;
                    int n36 = 0;
                    while (n36 <= n26) {
                        n24 = 0;
                        while (n24 <= n25) {
                            vector2.addElement(new PdVector(d7 + (double)n24 * d10, d6 + (double)n36 * d3));
                            ++n24;
                        }
                        ++n36;
                    }
                    n5 += (n25 + 1) * (n26 + 1);
                    n36 = 0;
                    while (n36 < n26) {
                        n24 = 0;
                        while (n24 < n25) {
                            PiVector piVector5 = new PiVector(4);
                            piVector5.m_data[0] = n13 + n36 * (n25 + 1) + n24;
                            piVector5.m_data[1] = n13 + (n36 + 1) * (n25 + 1) + n24;
                            piVector5.m_data[2] = n13 + (n36 + 1) * (n25 + 1) + n24 + 1;
                            piVector5.m_data[3] = n13 + n36 * (n25 + 1) + n24 + 1;
                            vector3.addElement(piVector5);
                            ++n24;
                        }
                        ++n36;
                    }
                    n6 += n25 * n26;
                    n13 += (n25 + 1) * (n26 + 1);
                    bl2 = true;
                    continue;
                }
                if ("Cuboid".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 3) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector9 = new PdVector();
                    if (!PgMathLoader.parseVector(streamTokenizer, pdVector9, 3)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector10 = new PdVector();
                    if (streamTokenizer.ttype == 44) {
                        if (!PgMathLoader.parseVector(streamTokenizer, pdVector10, 3)) {
                            return false;
                        }
                        streamTokenizer.nextToken();
                    } else {
                        pdVector10 = PdVector.copyNew(pdVector9);
                        pdVector10.add(1.0);
                    }
                    PiVector[] piVectorArray = new PiVector[]{new PiVector(n13, n13 + 4, n13 + 5, n13 + 1), new PiVector(n13 + 3, n13 + 2, n13 + 6, n13 + 7), new PiVector(n13, n13 + 1, n13 + 2, n13 + 3), new PiVector(n13 + 4, n13 + 7, n13 + 6, n13 + 5), new PiVector(n13 + 1, n13 + 5, n13 + 6, n13 + 2), new PiVector(n13, n13 + 3, n13 + 7, n13 + 4)};
                    int n37 = 0;
                    do {
                        vector3.addElement(piVectorArray[n37]);
                    } while (++n37 < 6);
                    n6 += 6;
                    n13 += 8;
                    PdVector[] pdVectorArray = new PdVector[]{pdVector9, new PdVector(pdVector10.m_data[0], pdVector9.m_data[1], pdVector9.m_data[2]), new PdVector(pdVector10.m_data[0], pdVector9.m_data[1], pdVector10.m_data[2]), new PdVector(pdVector9.m_data[0], pdVector9.m_data[1], pdVector10.m_data[2]), new PdVector(pdVector9.m_data[0], pdVector10.m_data[1], pdVector9.m_data[2]), new PdVector(pdVector10.m_data[0], pdVector10.m_data[1], pdVector9.m_data[2]), pdVector10, new PdVector(pdVector9.m_data[0], pdVector10.m_data[1], pdVector10.m_data[2])};
                    int n38 = 0;
                    do {
                        vector2.addElement(pdVectorArray[n38]);
                    } while (++n38 < 8);
                    n5 += 8;
                    n38 = 0;
                    do {
                        n = 0;
                        do {
                            vectorArray2[n].addElement(vectorArray[n].elementAt(n14));
                        } while (++n <= 6);
                    } while (++n38 < 6);
                    continue;
                }
                if ("Text".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    String string2 = PgMathLoader.readString2(streamTokenizer);
                    streamTokenizer.nextToken();
                    PdVector pdVector11 = new PdVector();
                    PgMathLoader.parseVector(streamTokenizer, pdVector11, this.m_dim);
                    streamTokenizer.nextToken();
                    PdVector pdVector12 = new PdVector(0.0, 0.0);
                    if (streamTokenizer.ttype == 44) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 123) {
                            streamTokenizer.pushBack();
                            PgMathLoader.parseVector(streamTokenizer, pdVector12, 2);
                        } else {
                            streamTokenizer.pushBack();
                        }
                    } else {
                        streamTokenizer.pushBack();
                    }
                    vector10.addElement(pdVector12);
                    int n39 = 1;
                    while (n39 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 91) {
                            ++n39;
                        }
                        if (streamTokenizer.ttype != 93) continue;
                        --n39;
                    }
                    Vector<Object> vector14 = new Vector<Object>();
                    vector14.addElement(string2);
                    vector14.addElement(pdVector11);
                    vector9.addElement(vector14);
                    ++n12;
                    continue;
                }
                if ("PointSize".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    bl4 = true;
                    pdVector.m_data[n14] = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("AbsolutePointSize".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    bl4 = true;
                    pdVector.m_data[n14] = PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("RGBColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                    bl2 = true;
                    Color color5 = PgMathLoader.readColor(streamTokenizer);
                    vector.setElementAt(color5, n14);
                    int n40 = 4;
                    do {
                        vectorArray[n40].setElementAt(color5, n14);
                    } while (++n40 <= 5);
                    if (this.m_dim == 3) continue;
                    n40 = 0;
                    do {
                        vectorArray[n40].setElementAt(color5, n14);
                    } while (++n40 <= 3);
                    piVector.m_data[n14] = 1;
                    piVector2.m_data[n14] = 1;
                    continue;
                }
                if ("SurfaceColor".equals(streamTokenizer.sval)) {
                    bl2 = true;
                    Color[] colorArray = new Color[2];
                    piVector.m_data[n14] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                    Color color6 = colorArray[0];
                    Color color7 = colorArray[1];
                    piVector2.m_data[n14] = piVector.m_data[n14];
                    int n41 = 0;
                    do {
                        vectorArray[n41].setElementAt(color6, n14);
                    } while (++n41 <= 1);
                    n41 = 2;
                    do {
                        vectorArray[n41].setElementAt(color7, n14);
                    } while (++n41 <= 3);
                    continue;
                }
                if ("EdgeForm".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        bl5 = false;
                    }
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype == -3) {
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                bl3 = true;
                                Color color8 = PgMathLoader.readColor(streamTokenizer);
                                vectorArray[6].setElementAt(color8, 0);
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if ("Thickness".equals(streamTokenizer.sval)) {
                                streamTokenizer.nextToken();
                                d = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                continue;
                            }
                            if (!"AbsoluteThickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = PgMathLoader.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            continue;
                        }
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("Missing closing bracket in Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                    }
                    continue;
                }
                if ("Thickness".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    d2 = 200.0 * PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("AbsoluteThickness".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    d2 = PgMathLoader.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    continue;
                }
                if ("FaceForm".equals(streamTokenizer.sval)) {
                    Color[] colorArray;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    bl2 = true;
                    boolean bl7 = true;
                    if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        colorArray = new Color[2];
                        piVector.m_data[n14] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                        Color color9 = colorArray[0];
                        Color color10 = colorArray[1];
                        vectorArray[0].setElementAt(color9, n14);
                        vectorArray[2].setElementAt(color10, n14);
                    } else {
                        bl7 = false;
                        colorArray = PgMathLoader.readColor(streamTokenizer);
                        vectorArray[4].setElementAt(colorArray, n14);
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        streamTokenizer.nextToken();
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray = new Color[2];
                            piVector2.m_data[n14] = PgMathLoader.readSurfaceColor(streamTokenizer, colorArray);
                            Color color11 = colorArray[0];
                            Color color12 = colorArray[1];
                            vectorArray[1].setElementAt(color11, n14);
                            vectorArray[3].setElementAt(color12, n14);
                        } else {
                            colorArray = PgMathLoader.readColor(streamTokenizer);
                            vectorArray[5].setElementAt(colorArray, n14);
                        }
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl7) {
                        vectorArray[1].setElementAt(vectorArray[0].elementAt(n14), n14);
                        vectorArray[3].setElementAt(vectorArray[2].elementAt(n14), n14);
                        piVector2.m_data[n14] = piVector.m_data[n14];
                        continue;
                    }
                    vectorArray[5].setElementAt(vectorArray[4].elementAt(n14), n14);
                    continue;
                }
                PsDebug.warning("skipping " + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                string = string + streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'[' expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                int n42 = 1;
                string = string + "[";
                while (n42 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        --n42;
                        string = string + "]";
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n42;
                        string = string + "[";
                    }
                    if (streamTokenizer.ttype == -3) {
                        string = string + streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        string = string + Double.toString(PgMathLoader.readNumber(streamTokenizer));
                        continue;
                    }
                    if (streamTokenizer.ttype == 123) {
                        string = string + "{";
                        continue;
                    }
                    if (streamTokenizer.ttype == 125) {
                        string = string + "}";
                        continue;
                    }
                    if (streamTokenizer.ttype == 44) {
                        string = string + ",";
                        continue;
                    }
                    if (streamTokenizer.ttype == 42) {
                        string = string + "*";
                        continue;
                    }
                    if (streamTokenizer.ttype != 94) continue;
                    string = string + "^";
                }
            }
            boolean bl8 = true;
            boolean bl9 = true;
            if (bl) {
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
                int n43 = 1;
                while (n43 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    if (streamTokenizer.ttype == 93) {
                        --n43;
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n43;
                    }
                    if (streamTokenizer.ttype == -3) {
                        if (this.readOptions(streamTokenizer)) {
                            streamTokenizer.ordinaryChar(45);
                        } else if ("Prolog".equals(streamTokenizer.sval) || "Epilog".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            int n44 = this.m_dim;
                            this.m_dim = 2;
                            if (this.readGraphics(streamTokenizer, false)) {
                                ++this.m_numGraphics;
                            }
                            this.m_dim = n44;
                        } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            bl9 = "True".equals(streamTokenizer.sval);
                        } else if ("Shading".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            bl8 = "True".equals(streamTokenizer.sval);
                        }
                    }
                    streamTokenizer.nextToken();
                }
                streamTokenizer.pushBack();
            }
            if (this.m_displayOption.getBackgroundColor() == null) {
                this.m_displayOption.setBackgroundColor(Color.white);
            }
            if (this.m_defaultColor == null && (color = this.m_displayOption.getBackgroundColor()) != null) {
                n = 0;
                int n45 = 0;
                int n46 = 0;
                if (color.getRed() < 127) {
                    n46 = 255;
                }
                if (color.getBlue() < 127) {
                    n = 255;
                }
                if (color.getGreen() < 127) {
                    n45 = 255;
                }
                this.m_defaultColor = new Color(n46, n45, n);
            }
            if (this.m_dim < 3 && bl) {
                this.m_displayOption.clearTag(22);
            }
            int n47 = 0;
            if (n6 != 0 || n11 != 0) {
                ++n47;
            }
            if (n7 != 0) {
                ++n47;
            }
            if (n8 != 0) {
                ++n47;
            }
            if (n9 != 0 || n10 != 0) {
                ++n47;
            }
            this.m_geomArr = new PgJvxSrc[n47 += n12];
            int n48 = 0;
            if (n6 != 0 || n11 != 0) {
                Serializable serializable;
                int n49 = 72;
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n5 + n11 * n49);
                int n50 = 0;
                while (n50 < n5) {
                    pgJvxSrc.setVertex(n50, (PdVector)vector2.elementAt(n50));
                    ++n50;
                }
                n50 = 0;
                while (n50 < n11) {
                    int n51;
                    serializable = (PdVector)vector8.elementAt(n50);
                    if (serializable.getSize() == 4) {
                        n51 = 0;
                        while (n51 < n49) {
                            pgJvxSrc.setVertex(n5 + n50 * n49 + n51, new PdVector(serializable.m_data[0] + Math.cos((double)n51 * 2.0 * Math.PI / (double)n49) * serializable.m_data[2], serializable.m_data[1] + Math.sin((double)n51 * 2.0 * Math.PI / (double)n49) * serializable.m_data[3]));
                            ++n51;
                        }
                    } else {
                        pgJvxSrc.setVertex(n5 + n50 * n49, new PdVector(serializable.m_data[0], serializable.m_data[1]));
                        n51 = 0;
                        while (n51 < n49 - 1) {
                            pgJvxSrc.setVertex(n5 + n50 * n49 + n51 + 1, new PdVector(serializable.m_data[0] + Math.cos(serializable.m_data[4] + (serializable.m_data[5] - serializable.m_data[4]) * (double)n51 / (double)(n49 - 2)) * serializable.m_data[2], serializable.m_data[1] + Math.sin(serializable.m_data[4] + (serializable.m_data[5] - serializable.m_data[4]) * (double)n51 / (double)(n49 - 2)) * serializable.m_data[3]));
                            ++n51;
                        }
                    }
                    ++n50;
                }
                pgJvxSrc.setDimOfElements(-1);
                pgJvxSrc.setNumElements(n6 + n11);
                n50 = 0;
                while (n50 < n6) {
                    pgJvxSrc.setElement(n50, (PiVector)vector3.elementAt(n50));
                    ++n50;
                }
                n50 = 0;
                while (n50 < n11) {
                    serializable = new PiVector(n49);
                    int n52 = 0;
                    while (n52 < n49) {
                        ((PiVector)serializable).m_data[n52] = n5 + n50 * n49 + n52;
                        ++n52;
                    }
                    pgJvxSrc.setElement(n6 + n50, (PiVector)serializable);
                    ++n50;
                }
                PgMathLoader.geomInitType(pgJvxSrc);
                if (bl5) {
                    pgJvxSrc.showEdges(true);
                } else {
                    pgJvxSrc.showEdges(false);
                }
                pgJvxSrc.setGlobalEdgeSize(d);
                pgJvxSrc.showElementColors(bl8);
                pgJvxSrc.showElementBackColors(bl8);
                pgJvxSrc.showElements(bl9);
                Color[][] colorArrayArray = new Color[4][];
                serializable = Color.white;
                Color color13 = Color.black;
                if (this.m_defaultColor != null) {
                    if (!this.m_displayOption.hasTag(22)) {
                        serializable = this.m_defaultColor;
                    }
                    color13 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalElementColor((Color)serializable);
                pgJvxSrc.setGlobalElementBackColor((Color)serializable);
                pgJvxSrc.setGlobalEdgeColor(color13);
                int n53 = 0;
                do {
                    colorArrayArray[n53] = new Color[n6 + n11];
                } while (++n53 <= 3);
                if (bl2) {
                    if (this.m_displayOption.hasTag(22) && bl) {
                        n53 = 0;
                        while (n53 < n6) {
                            int n54 = 0;
                            do {
                                colorArrayArray[n54][n53] = (Color)vectorArray2[n54].elementAt(n53);
                                if (colorArrayArray[n54][n53] != null) continue;
                                colorArrayArray[n54][n53] = Color.white;
                            } while (++n54 <= 3);
                            ++n53;
                        }
                    } else {
                        n53 = 0;
                        while (n53 < n6) {
                            int n55 = 0;
                            do {
                                colorArrayArray[n55][n53] = (Color)vectorArray2[n55 + 4].elementAt(n53);
                                if (colorArrayArray[n55][n53] != null) continue;
                                colorArrayArray[n55][n53] = serializable;
                            } while (++n55 <= 1);
                            ++n53;
                        }
                        n53 = 0;
                        while (n53 < n11) {
                            int n56 = 0;
                            do {
                                colorArrayArray[n56][n53 + n6] = (Color)vectorArray2[9].elementAt(n53);
                                if (colorArrayArray[n56][n53 + n6] != null) continue;
                                colorArrayArray[n56][n53 + n6] = serializable;
                            } while (++n56 <= 1);
                            ++n53;
                        }
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    if (bl3) {
                        Color[] colorArray = new Color[n6];
                        int n57 = 0;
                        while (n57 < n6) {
                            colorArray[n57] = (Color)vectorArray2[6].elementAt(n57);
                            ++n57;
                        }
                        if (vectorArray[6].elementAt(0) != null) {
                            pgJvxSrc.setGlobalEdgeColor((Color)vectorArray[6].elementAt(0));
                        }
                    }
                } else {
                    n53 = 0;
                    while (n53 < n6 + n11) {
                        int n58 = 0;
                        do {
                            colorArrayArray[n58][n53] = serializable;
                        } while (++n58 <= 3);
                        ++n53;
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                }
                this.m_geomArr[n48] = pgJvxSrc;
                this.m_geomArr[n48].setName("ElementSet from Mathematica");
                ++n48;
            }
            if (n7 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(30);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n7);
                int n59 = 0;
                while (n59 < n7) {
                    pgJvxSrc.setVertex(n59, (PdVector)vector4.elementAt(n59));
                    ++n59;
                }
                if (bl4) {
                    PdVector pdVector13 = new PdVector(n7);
                    int n60 = 0;
                    while (n60 < n7) {
                        pdVector13.m_data[n60] = (Double)vector11.elementAt(n60);
                        if (pdVector13.m_data[n60] < 1.0) {
                            pdVector13.m_data[n60] = 1.0;
                        }
                        ++n60;
                    }
                    pgJvxSrc.setGlobalVertexSize(1.0);
                    pgJvxSrc.setVertexSizes(pdVector13);
                    pgJvxSrc.showVertexSizes(true);
                }
                Color color14 = Color.black;
                if (this.m_defaultColor != null) {
                    color14 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalVertexColor(color14);
                if (bl2) {
                    Color[] colorArray = new Color[n7];
                    int n61 = 0;
                    while (n61 < n7) {
                        colorArray[n61] = (Color)vectorArray2[7].elementAt(n61);
                        if (colorArray[n61] == null) {
                            colorArray[n61] = color14;
                        }
                        ++n61;
                    }
                    pgJvxSrc.setVertexColors(colorArray);
                    pgJvxSrc.showVertexColors(true);
                }
                pgJvxSrc.showVertexOutline(false);
                this.m_geomArr[n48] = pgJvxSrc;
                this.m_geomArr[n48].setName("PointSet from Mathematica");
                ++n48;
            }
            if (n12 != 0) {
                int n62 = 0;
                while (n62 < n12) {
                    PgJvxSrc pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setType(30);
                    PgMathLoader.geomInitType(pgJvxSrc);
                    pgJvxSrc.setDimOfVertices(this.m_dim);
                    pgJvxSrc.setNumVertices(1);
                    pgJvxSrc.setVertex(0, (PdVector)((Vector)vector9.elementAt(n62)).elementAt(1));
                    pgJvxSrc.getVertex(0).setName((String)((Vector)vector9.elementAt(n62)).elementAt(0));
                    PdVector pdVector14 = (PdVector)vector10.elementAt(n62);
                    int n63 = pdVector14.m_data[0] > 0.5 ? 2 : (pdVector14.m_data[0] < -0.5 ? 0 : 1);
                    int n64 = pdVector14.m_data[1] > 0.5 ? 2 : (pdVector14.m_data[1] < -0.5 ? 0 : 1);
                    pgJvxSrc.setLabelAttribute(0, 0, 0, n63, n64, 0);
                    pgJvxSrc.showVertices(true);
                    pgJvxSrc.setGlobalVertexSize(0.0);
                    pgJvxSrc.showVertexLabels(true);
                    this.m_geomArr[n48] = pgJvxSrc;
                    this.m_geomArr[n48].setName("Text from Mathematica " + n62);
                    ++n48;
                    ++n62;
                }
            }
            if (n8 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(36);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n8);
                pgJvxSrc.setNumVectorFields(1);
                pgJvxSrc.setNumVectors(0, n8, this.m_dim);
                PdVector[] pdVectorArray = new PdVector[n8];
                PdVector[] pdVectorArray2 = new PdVector[n8];
                int n65 = 0;
                while (n65 < n8) {
                    pdVectorArray[n65] = ((PdVector[])vector5.elementAt(n65))[0];
                    pdVectorArray2[n65] = PdVector.subNew(((PdVector[])vector5.elementAt(n65))[1], pdVectorArray[n65]);
                    ++n65;
                }
                pgJvxSrc.setVertices(pdVectorArray);
                pgJvxSrc.setVectors(0, pdVectorArray2);
                pgJvxSrc.showVectorArrows(0, true);
                pgJvxSrc.setGlobalVectorColor(0, Color.black);
                this.m_geomArr[n48] = pgJvxSrc;
                this.m_geomArr[n48].setName("VectorField from Mathematica");
                ++n48;
            }
            if (n9 != 0 || n10 != 0) {
                Object object;
                int n66 = 72;
                PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[n9];
                int n67 = 0;
                int n68 = 0;
                while (n68 < n9) {
                    pgJvxSrcArray[n68] = (PgJvxSrc)vector6.elementAt(n68);
                    n67 += pgJvxSrcArray[n68].getNumVertices();
                    ++n68;
                }
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(32);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.showVertices(false);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n67 + n10 * n66);
                int n69 = 0;
                int n70 = 0;
                while (n70 < n9) {
                    int n71 = pgJvxSrcArray[n70].getNumVertices();
                    object = pgJvxSrcArray[n70].getVertices();
                    int n72 = 0;
                    while (n72 < n71) {
                        pgJvxSrc.setVertex(n69, (PdVector)object[n72]);
                        ++n69;
                        ++n72;
                    }
                    ++n70;
                }
                boolean[] blArray = new boolean[n10];
                int n73 = 0;
                while (n73 < n10) {
                    int n74;
                    object = (PdVector)vector7.elementAt(n73);
                    if (((PdVector)object).getSize() == 4) {
                        blArray[n73] = true;
                        n74 = 0;
                        while (n74 < n66) {
                            pgJvxSrc.setVertex(n67 + n73 * n66 + n74, new PdVector(((PdVector)object).m_data[0] + Math.cos((double)n74 * 2.0 * Math.PI / (double)n66) * ((PdVector)object).m_data[2], ((PdVector)object).m_data[1] + Math.sin((double)n74 * 2.0 * Math.PI / (double)n66) * ((PdVector)object).m_data[3]));
                            ++n74;
                        }
                    } else {
                        blArray[n73] = false;
                        n74 = 0;
                        while (n74 < n66) {
                            pgJvxSrc.setVertex(n67 + n73 * n66 + n74, new PdVector(((PdVector)object).m_data[0] + Math.cos(((PdVector)object).m_data[4] + (((PdVector)object).m_data[5] - ((PdVector)object).m_data[4]) * (double)n74 / (double)(n66 - 1)) * ((PdVector)object).m_data[2], ((PdVector)object).m_data[1] + Math.sin(((PdVector)object).m_data[4] + (((PdVector)object).m_data[5] - ((PdVector)object).m_data[4]) * (double)n74 / (double)(n66 - 1)) * ((PdVector)object).m_data[3]));
                            ++n74;
                        }
                    }
                    ++n73;
                }
                pgJvxSrc.setDimOfPolygons(-1);
                pgJvxSrc.setNumPolygons(n9 + n10);
                PiVector[] piVectorArray = pgJvxSrc.getPolygons();
                int n75 = 0;
                int n76 = 0;
                while (n76 < n9) {
                    n2 = pgJvxSrcArray[n76].getNumVertices();
                    piVectorArray[n76].setSize(n2);
                    int n77 = 0;
                    while (n77 < n2) {
                        piVectorArray[n76].m_data[n77] = n77 + n75;
                        ++n77;
                    }
                    n75 += n2;
                    ++n76;
                }
                n76 = 0;
                while (n76 < n10) {
                    if (blArray[n76]) {
                        piVectorArray[n9 + n76].setSize(n66 + 1);
                        n2 = 0;
                        while (n2 < n66 + 1) {
                            piVectorArray[n9 + n76].m_data[n2] = n67 + n76 * n66 + n2 % n66;
                            ++n2;
                        }
                    } else {
                        piVectorArray[n9 + n76].setSize(n66);
                        n2 = 0;
                        while (n2 < n66) {
                            piVectorArray[n9 + n76].m_data[n2] = n67 + n76 * n66 + n2;
                            ++n2;
                        }
                    }
                    ++n76;
                }
                Color color15 = Color.black;
                if (this.m_defaultColor != null) {
                    color15 = this.m_defaultColor;
                }
                pgJvxSrc.setGlobalPolygonColor(color15);
                if (bl2) {
                    Color[] colorArray = new Color[n9 + n10];
                    int n78 = 0;
                    while (n78 < n9) {
                        colorArray[n78] = (Color)vectorArray2[8].elementAt(n78);
                        if (colorArray[n78] == null) {
                            colorArray[n78] = color15;
                        }
                        ++n78;
                    }
                    n78 = 0;
                    while (n78 < n10) {
                        colorArray[n9 + n78] = (Color)vectorArray2[10].elementAt(n78);
                        if (colorArray[n9 + n78] == null) {
                            colorArray[n9 + n78] = color15;
                        }
                        ++n78;
                    }
                    pgJvxSrc.setPolygonColors(colorArray);
                    pgJvxSrc.showPolygonColors(true);
                }
                pgJvxSrc.setGlobalPolygonSize(d2);
                this.m_geomArr[n48] = pgJvxSrc;
                this.m_geomArr[n48].setName("PgPolygonSet from Mathematica");
                ++n48;
            }
            streamTokenizer.ordinaryChar(45);
            if (n47 <= 0) {
                return false;
            }
            this.m_graphicsVector.addElement(this.m_geomArr);
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private static boolean parseVector(StreamTokenizer streamTokenizer, PdVector pdVector, int n) {
        pdVector.setSize(n);
        try {
            streamTokenizer.nextToken();
            boolean bl = false;
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("Offset")) {
                bl = true;
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
            }
            int n2 = 0;
            while (n2 < n) {
                pdVector.m_data[n2] = PgMathLoader.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                ++n2;
            }
            if (bl) {
                streamTokenizer.nextToken();
            }
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("parseVector throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    public void setKeyAnimation(boolean bl) {
        this.m_bIsKeyAnimation = bl;
    }
}

