/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.List;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.loader.PgExport_Dialog;
import jv.loader.PgHtmlLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PgMathLoader;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.acmeEncoders.GifEncoder;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.PpmEncoder;

public final class PgLoader {
    protected PvDisplayOption[] m_displayOption;
    protected BitSet m_geometryOption;
    protected boolean m_bIsAnimated;
    protected boolean m_bShowAnimationPanel;
    protected boolean m_bIsEnabledOptimization;
    public static final int NUM_GEOMETRY_TAGS = 10;
    private static /* synthetic */ Class class$jv$geom$PgPolygon;
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet;
    private static /* synthetic */ Class class$jv$geom$PgElementSet;
    private static /* synthetic */ Class class$jv$geom$PgPointSet;

    public PgGeometry[] readAnimation(PgJvxSrc[] pgJvxSrcArray, boolean bl) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n = pgJvxSrcArray.length;
        PgJvxSrc[][] pgJvxSrcArray2 = new PgJvxSrc[n][1];
        int n2 = 0;
        while (n2 < n) {
            pgJvxSrcArray2[n2][0] = pgJvxSrcArray[n2];
            ++n2;
        }
        return this.readAnimation(pgJvxSrcArray2, bl);
    }

    public static PsKeyframe[] readAnimation(PsKeyframe[] psKeyframeArray, int n, int n2, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(psKeyframeArray, n, n2, string, 0);
    }

    public PsKeyframe[] readAnimation(PsKeyframe[] psKeyframeArray, int n, int n2, String string, int n3) {
        if (string == null) {
            PsDebug.warning("missing file name to load");
            return null;
        }
        int n4 = n2 - n + 1;
        int n5 = -1;
        psKeyframeArray = null;
        double d = 0.0;
        double d2 = 100.0;
        double d3 = d;
        double d4 = (d2 - d) / ((double)n4 - 1.0);
        String[] stringArray = PuString.splitString(string, '*');
        if (stringArray == null || stringArray.length != 2) {
            PsDebug.warning("wrong syntax, fileName = " + string);
            return null;
        }
        int n6 = 0;
        while (n6 < n4) {
            int n7;
            String string2;
            PgGeometry[] pgGeometryArray;
            String string3 = String.valueOf(n6 + 1);
            if (n3 > 1) {
                int n8 = string3.length();
                while (n8 < n3) {
                    string3 = "0" + string3;
                    ++n8;
                }
            }
            if ((pgGeometryArray = this.loadGeometry((PgGeometry[])null, string2 = stringArray[0] + string3 + stringArray[1])) == null || pgGeometryArray.length == 0) {
                PsDebug.warning("failed loading file = " + string2);
                return null;
            }
            if (n6 == 0) {
                n5 = pgGeometryArray.length;
                psKeyframeArray = new PsKeyframe[n5];
                n7 = 0;
                while (n7 < n5) {
                    psKeyframeArray[n7] = new PsKeyframe();
                    ++n7;
                }
            } else if (n5 != pgGeometryArray.length) {
                PsDebug.warning("different number of geometries in file = " + string2);
                return null;
            }
            n7 = 0;
            while (n7 < n5) {
                int n9 = psKeyframeArray[n7].addKey(pgGeometryArray[n7], d3);
                if (n9 == -1) {
                    PsDebug.warning("geometry of different type: key=" + n6 + ", geom=" + n7);
                    return null;
                }
                ++n7;
            }
            d3 += d4;
            ++n6;
        }
        String string4 = PsUtil.getFileName(string);
        int n10 = 0;
        while (n10 < n5) {
            psKeyframeArray[n10].setTime(d);
            if (n5 == 1) {
                psKeyframeArray[n10].setName(string4);
            } else {
                psKeyframeArray[n10].setName(string4 + "[" + n10 + "]");
            }
            ++n10;
        }
        return psKeyframeArray;
    }

    public PgGeometry[] readAnimation(PgJvxSrc[][] pgJvxSrcArray, boolean bl) {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n2 = pgJvxSrcArray.length;
        int n3 = pgJvxSrcArray[0].length;
        PgGeometry[] pgGeometryArray = new PgGeometry[n3];
        PsKeyframe[] psKeyframeArray = new PsKeyframe[n3];
        int n4 = 0;
        while (n4 < n3) {
            Object object;
            n = pgJvxSrcArray[0][n4].getType();
            int n5 = pgJvxSrcArray[0][n4].getDimOfVertices();
            psKeyframeArray[n4] = new PsKeyframe();
            int n6 = 0;
            while (n6 < n2) {
                if (n != pgJvxSrcArray[n6][n4].getType()) {
                    PsDebug.warning("geometry type changes among key frames");
                    return null;
                }
                if (n5 != pgJvxSrcArray[n6][n4].getDimOfVertices()) {
                    PsDebug.warning("dimension of vertices changes among key frames");
                    return null;
                }
                switch (n) {
                    case 33: {
                        object = new PgElementSet(n5);
                        break;
                    }
                    case 30: {
                        object = new PgPointSet(n5);
                        break;
                    }
                    case 31: {
                        object = new PgPolygon(n5);
                        break;
                    }
                    case 32: {
                        object = new PgPolygonSet(n5);
                        break;
                    }
                    default: {
                        object = pgJvxSrcArray[n6][n4];
                    }
                }
                ((PgGeometry)object).setJvx(pgJvxSrcArray[n6][n4]);
                double d = n2 == 1 ? 0.0 : 100.0 * (double)n6 / ((double)n2 - 1.0);
                psKeyframeArray[n4].addKey((PgGeometry)object, d);
                ++n6;
            }
            psKeyframeArray[n4].setTime(0.0);
            pgGeometryArray[n4] = psKeyframeArray[n4].getDynamic();
            String string = PsConfig.getMessage(15012);
            object = PsConfig.getMessage(13000);
            if (pgGeometryArray[n4] != null) {
                String string2 = string;
                if (n3 > 1) {
                    string2 = string2 + "[" + n4 + "]";
                }
                pgGeometryArray[n4].setName(string2 + " " + (String)object + " " + pgJvxSrcArray[0][n4].getName());
            }
            ++n4;
        }
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName(PsConfig.getMessage(15013));
        n = 0;
        while (n < n3) {
            psAnimation.addTimeListener(psKeyframeArray[n]);
            ++n;
        }
        psAnimation.enableKeys(true);
        if (bl) {
            psAnimation.getAnimationPanel().show();
        }
        psAnimation.setTimeInterval(0.0, 100.0, 10.0 / ((double)n2 - 1.0), 50.0 / ((double)n2 - 1.0));
        return pgGeometryArray;
    }

    public boolean isAnimated() {
        return this.m_bIsAnimated;
    }

    public PgGeometry[] loadGeometry(String string, String string2) {
        return this.loadGeometry(null, string, string2);
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing argument: data");
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        pgGeometryArray = this.loadGeometry(pgGeometryArray, bufferedReader, string2);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgGeometryArray;
    }

    public PgGeometry[] loadGeometry(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        return this.loadGeometry((PgGeometry[])null, string);
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, String string) {
        String[] stringArray;
        String string2;
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string3 = PsUtil.getFileExtension(string);
        if (PuString.isEmpty(string3)) {
            PsDebug.warning("missing extension in file=" + string);
            return null;
        }
        string3 = string3.toLowerCase();
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        pgGeometryArray = this.loadGeometry(pgGeometryArray, bufferedReader, string3);
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {}
        if (pgGeometryArray == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        int n = 0;
        while (n < pgGeometryArray.length) {
            if (pgGeometryArray[n] != null && ((string2 = pgGeometryArray[n].getName()) == null || string2.toLowerCase().startsWith("object_"))) {
                stringArray = PsUtil.getFileBaseName(string);
                if (n == 0) {
                    pgGeometryArray[n].setName((String)stringArray);
                } else {
                    pgGeometryArray[n].setName((String)stringArray + "[" + n + "]");
                }
            }
            ++n;
        }
        if (string3.indexOf("jvx") != -1 || string3.indexOf("wrl") != -1 || string3.indexOf("vrml") != -1) {
            n = 0;
            while (n < pgGeometryArray.length) {
                string2 = pgGeometryArray[n].getTextureImageName();
                if (string2 != null) {
                    stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getCodeBase()};
                    Image image = null;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        image = this.loadImageFromPath(stringArray[n2], string2);
                        if (image != null) {
                            pgGeometryArray[n].setTextureImage(image);
                            pgGeometryArray[n].setTextureImageName(stringArray[n2] + string2);
                            break;
                        }
                        ++n2;
                    }
                    if (image == null) {
                        PsDebug.warning("failed loading texture image = " + string2 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
                    }
                }
                ++n;
            }
        }
        return pgGeometryArray;
    }

    public PgGeometry[] loadGeometry(PgGeometry[] pgGeometryArray, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        string = string.toLowerCase();
        this.setDisplayOptions(null);
        try {
            if (string.indexOf("mgs") != -1 || string.equalsIgnoreCase("m")) {
                PgMathLoader pgMathLoader = new PgMathLoader();
                if (this.isAnimated()) {
                    pgMathLoader.setKeyAnimation(true);
                }
                if (!pgMathLoader.load(bufferedReader)) {
                    PsDebug.warning("loading failed");
                    return null;
                }
                this.setDisplayOption(pgMathLoader.getDisplayOption());
                PgJvxSrc[][] pgJvxSrcArray = pgMathLoader.getAnimations();
                if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null || pgJvxSrcArray[0].length == 0) {
                    PsDebug.warning("missing animations");
                    return null;
                }
                if (pgMathLoader.isAnimation() || pgMathLoader.isKeyAnimation()) {
                    pgGeometryArray = this.readAnimation(pgJvxSrcArray, this.m_bShowAnimationPanel);
                } else {
                    PgJvxSrc[] pgJvxSrcArray2 = pgJvxSrcArray[0];
                    pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray2.length);
                    int n = 0;
                    while (n < pgJvxSrcArray2.length) {
                        pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray2[n].getType(), pgJvxSrcArray2[n].getDimOfVertices());
                        pgGeometryArray[n].setJvx(pgJvxSrcArray2[n]);
                        if (this.isEnabledOptimization() && pgMathLoader.isEnabledOptimization()) {
                            PuCleanMesh.identifyVertices(pgGeometryArray[n]);
                        }
                        ++n;
                    }
                }
            } else {
                if (string.indexOf("jvd") != -1) {
                    this.loadDisplay(bufferedReader, "jvd");
                    return null;
                }
                PgLoaderIf pgLoaderIf = PgLoader.getLoader(string);
                if (pgLoaderIf == null) {
                    PsDebug.warning("unknown file extension = \"" + string + "\", no loader found");
                    return null;
                }
                if (this.isAnimated()) {
                    pgLoaderIf.setAnimation(true);
                }
                if (!pgLoaderIf.load(bufferedReader)) {
                    PsDebug.warning("loading failed");
                    return null;
                }
                this.setDisplayOption(pgLoaderIf.getDisplayOption());
                if (pgLoaderIf.isAnimation()) {
                    PgJvxSrc[][] pgJvxSrcArray = pgLoaderIf.getAnimations();
                    if (pgJvxSrcArray == null) {
                        PgJvxSrc[] pgJvxSrcArray3 = pgLoaderIf.getGeometries();
                        if (pgJvxSrcArray3 == null || pgJvxSrcArray3.length == 0) {
                            PsDebug.warning("missing geometries");
                            return null;
                        }
                        pgGeometryArray = this.readAnimation(pgJvxSrcArray3, this.m_bShowAnimationPanel);
                    } else {
                        if (pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null || pgJvxSrcArray[0].length == 0) {
                            PsDebug.warning("incomplete animation array");
                            return null;
                        }
                        pgGeometryArray = this.readAnimation(pgJvxSrcArray, this.m_bShowAnimationPanel);
                    }
                } else {
                    PgGeometryIf[] pgGeometryIfArray = pgLoaderIf.getSpecializedGeometries();
                    if (pgGeometryIfArray != null) {
                        pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgGeometryIfArray.length);
                        int n = 0;
                        while (n < pgGeometryIfArray.length) {
                            pgGeometryArray[n] = (PgGeometry)pgGeometryIfArray[n];
                            ++n;
                        }
                    } else {
                        PgJvxSrc[] pgJvxSrcArray = pgLoaderIf.getGeometries();
                        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                            PsDebug.warning("missing geometries");
                            return null;
                        }
                        pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
                        boolean bl = pgLoaderIf.isEnabledOptimization();
                        pgLoaderIf = null;
                        if (PsConfig.isApplication()) {
                            PsConfig.runGC();
                        }
                        int n = 0;
                        while (n < pgJvxSrcArray.length) {
                            pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                            pgGeometryArray[n].setEnabledInstanceSharing(true);
                            pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                            pgGeometryArray[n].setEnabledInstanceSharing(false);
                            pgJvxSrcArray[n] = null;
                            if (this.isEnabledOptimization() && bl && PsJavaView.m_bAutoIdentify) {
                                PuCleanMesh.identifyVertices(pgGeometryArray[n]);
                            }
                            if (!string.equalsIgnoreCase("jvx") || bl) {
                                switch (pgGeometryArray[n].getType()) {
                                    case 33: {
                                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                                        if (!PsJavaView.m_bAutoNeighbour) break;
                                        pgElementSet.makeNeighbour();
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PsDebug.outOfMemory(outOfMemoryError);
        }
        if (PsConfig.isApplication()) {
            PsConfig.runGC();
        }
        return pgGeometryArray;
    }

    public static String saveToString(PgGeometryIf[] pgGeometryIfArray, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveGeometryToString((PgGeometry[])pgGeometryIfArray, string);
    }

    public boolean saveString(String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing data to save.");
            return false;
        }
        if (string2 == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        if (PsConfig.isApplication()) {
            PrintWriter printWriter = PsUtil.writeFile(string2);
            if (printWriter == null) {
                PsDebug.warning("could not open file = " + string2);
                return false;
            }
            printWriter.println(string);
            printWriter.close();
        } else {
            PgExport_Dialog pgExport_Dialog = new PgExport_Dialog(PsConfig.getFrame(), PsConfig.getProgram() + " " + PsConfig.getMessage(24108), false);
            String string3 = PsUtil.getFileExtension(string2);
            if (string3 != null) {
                pgExport_Dialog.setFilenameExtension(string3);
            }
            pgExport_Dialog.setText(string);
            pgExport_Dialog.show();
        }
        return true;
    }

    public static boolean readAll(List list, String string) {
        PsXmlNode psXmlNode;
        Object object;
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string, list);
            return false;
        }
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node when reading list from file = " + string, list);
            return false;
        }
        list.removeAll();
        PsXmlNode psXmlNode3 = psXmlNode2.getChild("directories");
        if (psXmlNode3 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return false;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode3.getChildren("directory");
        if (psXmlNodeArray != null) {
            PsDebug.message("directory contains no subdirectories, dir = " + string, false);
            int n = 0;
            while (n < psXmlNodeArray.length) {
                object = psXmlNodeArray[n].getChild("name");
                if (object == null) {
                    PsDebug.warning("directory has no name, dir = " + string);
                }
                list.add(((PsXmlNode)object).getContent());
                ++n;
            }
        }
        if ((psXmlNode = psXmlNode2.getChild("models")) == null) {
            PsDebug.warning("directory contains no directory section, model = " + string);
            return false;
        }
        object = psXmlNode.getChildren("model");
        if (object != null) {
            int n = 0;
            while (n < ((PsXmlNode[])object).length) {
                list.add(object[n].getContent());
                ++n;
            }
        }
        return true;
    }

    public static PgGeometry[] read(PgJvxSrc[] pgJvxSrcArray, boolean bl) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(pgJvxSrcArray, bl);
    }

    public PvDisplayOption[] getDisplayOptions() {
        return this.m_displayOption;
    }

    public PvDisplayOption getDisplayOption() {
        if (this.m_displayOption == null || this.m_displayOption.length <= 0) {
            return null;
        }
        return this.m_displayOption[0];
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.setDisplayOptions(new PvDisplayOption[]{pvDisplayOption});
    }

    public void setDisplayOptions(PvDisplayOption[] pvDisplayOptionArray) {
        this.m_displayOption = pvDisplayOptionArray;
    }

    public static PgGeometry[] read(PgJvxSrc[][] pgJvxSrcArray, boolean bl) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.readAnimation(pgJvxSrcArray, bl);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string, String string2) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, string, string2);
    }

    public static PgGeometry[] load(String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry((PgGeometry[])null, string);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, string);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, BufferedReader bufferedReader, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadGeometry(pgGeometryArray, bufferedReader, string);
    }

    public static PvDisplayOption[] load(BufferedReader bufferedReader, String string) {
        PsDebug.warning("use of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.loadDisplay(bufferedReader, string);
    }

    private Image loadImageFromPath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Image image = PsImage.getImage(string + string2);
        if (image != null && !PsImage.loadImage(PsConfig.getFrame(), image)) {
            return null;
        }
        return image;
    }

    public static boolean save(PgGeometryIf[] pgGeometryIfArray, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveGeometry(pgGeometryIfArray, string);
    }

    public static boolean save(String string, String string2) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveString(string, string2);
    }

    public static boolean save(PvDisplayOption[] pvDisplayOptionArray, String string) {
        PsDebug.warning("usage of deprecated method.");
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveDisplay(pvDisplayOptionArray, string);
    }

    public static boolean save(Image image, String string) {
        PgLoader pgLoader = new PgLoader();
        return pgLoader.saveImage(image, string);
    }

    public static double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        do {
            streamTokenizer.nextToken();
        } while (streamTokenizer.ttype == 10);
        if (streamTokenizer.ttype != -2) {
            PsDebug.warning("called with tokenType different to TT_NUMBER, st = " + streamTokenizer.toString());
            return 0.0;
        }
        double d = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 47) {
            return d / PgLoader.parseDouble(streamTokenizer);
        }
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.startsWith("e") && !streamTokenizer.sval.startsWith("E")) {
            streamTokenizer.pushBack();
            return d;
        }
        if (streamTokenizer.sval.equals("e") || streamTokenizer.sval.equals("E")) {
            double d2;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 43) {
                streamTokenizer.nextToken();
                d2 = streamTokenizer.nval;
            } else if (streamTokenizer.ttype == 45) {
                streamTokenizer.nextToken();
                d2 = -streamTokenizer.nval;
            } else {
                d2 = streamTokenizer.nval;
            }
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("Number expected.");
                return 0.0;
            }
            return d * Math.pow(10.0, d2);
        }
        String string = "1." + streamTokenizer.sval;
        return d * Double.valueOf(string);
    }

    private static PgGeometry assureType(PgGeometry pgGeometry, int n, int n2) {
        if (pgGeometry != null && pgGeometry.getDimOfVertices() != n2) {
            pgGeometry = null;
        }
        switch (n) {
            case 31: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPolygon != null ? class$jv$geom$PgPolygon : (class$jv$geom$PgPolygon = PgLoader.class$("jv.geom.PgPolygon")))) break;
                pgGeometry = new PgPolygon(n2);
                break;
            }
            case 32: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPolygonSet != null ? class$jv$geom$PgPolygonSet : (class$jv$geom$PgPolygonSet = PgLoader.class$("jv.geom.PgPolygonSet")))) break;
                pgGeometry = new PgPolygonSet(n2);
                break;
            }
            case 33: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgElementSet != null ? class$jv$geom$PgElementSet : (class$jv$geom$PgElementSet = PgLoader.class$("jv.geom.PgElementSet")))) break;
                pgGeometry = new PgElementSet(n2);
                break;
            }
            default: {
                if (pgGeometry != null && pgGeometry.getClass() == (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PgLoader.class$("jv.geom.PgPointSet")))) break;
                pgGeometry = new PgPointSet(n2);
            }
        }
        return pgGeometry;
    }

    public boolean saveImage(Image image, String string) {
        if (image == null) {
            PsDebug.warning("missing image to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!(string2 = string2.toLowerCase()).equalsIgnoreCase("gif") && !string2.equalsIgnoreCase("ppm")) {
            PsDebug.warning("unknown image file ext = " + string2);
            return false;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageEncoder imageEncoder = null;
            if (string2.equalsIgnoreCase("gif")) {
                imageEncoder = new GifEncoder(image, (OutputStream)byteArrayOutputStream);
            } else if (string2.equalsIgnoreCase("ppm")) {
                imageEncoder = new PpmEncoder(image, (OutputStream)byteArrayOutputStream);
            }
            if (imageEncoder == null) {
                PsDebug.warning("Failed to create an encoder, ext = " + string2 + "\n\t file = " + string);
                return false;
            }
            imageEncoder.encode();
            if (byteArrayOutputStream.size() == 0) {
                PsDebug.warning("image data has size 0");
                return false;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (fileOutputStream == null) {
                PsDebug.warning("could not open file = " + string);
                return false;
            }
            byteArrayOutputStream.writeTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            PsDebug.error("Failed to save image: Exception = " + iOException.toString() + "\n\t file = " + string);
            return false;
        }
        return true;
    }

    public static double parseDouble(String string) {
        if (string == null) {
            PsDebug.warning("missing string");
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("-Infinity")) {
                return -1.7976931348623157E308;
            }
            if (string.equals("Infinity")) {
                return Double.MAX_VALUE;
            }
            PsDebug.warning("wrong format = " + string);
            return 0.0;
        }
    }

    private static PgGeometry[] assureLength(PgGeometry[] pgGeometryArray, int n) {
        if (pgGeometryArray == null) {
            return new PgGeometry[n];
        }
        if (n == pgGeometryArray.length) {
            return pgGeometryArray;
        }
        PgGeometry[] pgGeometryArray2 = new PgGeometry[n];
        int n2 = 0;
        while (n2 < Math.min(n, pgGeometryArray.length)) {
            pgGeometryArray2[n2] = pgGeometryArray[n2];
            ++n2;
        }
        return pgGeometryArray2;
    }

    public boolean isEnabledOptimization() {
        return this.m_bIsEnabledOptimization;
    }

    public boolean saveDisplay(PvDisplayOption[] pvDisplayOptionArray, String string) {
        Object object;
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("missing option to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!(string2 = string2.toLowerCase()).equalsIgnoreCase("jvd")) {
            PsDebug.warning("unknown option file ext = " + string2);
            return false;
        }
        int n = 0;
        while (n < pvDisplayOptionArray.length) {
            object = pvDisplayOptionArray[n].getBackgroundImage();
            boolean bl = pvDisplayOptionArray[n].getOption(10);
            Image image = pvDisplayOptionArray[n].getForegroundImage();
            boolean bl2 = pvDisplayOptionArray[n].getOption(10);
            if (object != null && bl || image != null && bl2) {
                File file;
                String string3;
                File file2;
                boolean bl3;
                String string4;
                String string5 = null;
                String string6 = null;
                string5 = PsUtil.getFilePath(string);
                string6 = PsUtil.getFileBaseName(string);
                if (string5 == null || string6 == null) {
                    PsDebug.warning("unable to extract path or base name of file name = " + string);
                    break;
                }
                if (bl && object != null) {
                    string4 = pvDisplayOptionArray[n].getBackgroundImageFile();
                    bl3 = false;
                    if (string4 != null) {
                        file2 = new File(string5 + string4);
                        bl3 = file2.exists();
                    }
                    if (!bl3) {
                        boolean bl4 = false;
                        if (string4 == null) {
                            string4 = string6 + "_" + pvDisplayOptionArray[n].getName() + ".gif";
                            pvDisplayOptionArray[n].setBackgroundImageFile(string4);
                        } else {
                            bl4 = !string4.endsWith(".gif");
                            string4 = PsUtil.getFileBaseName(string4);
                            string4 = string4 + ".gif";
                            pvDisplayOptionArray[n].setBackgroundImageFile(string4);
                        }
                        string3 = string5 + string4;
                        file = new File(string3);
                        if (!file.exists()) {
                            if (bl4) {
                                PsDebug.warning("currently, background image is always saved in GIF format.");
                            }
                            this.saveImage((Image)object, string3);
                        }
                    }
                }
                if (bl2 && image != null) {
                    string4 = pvDisplayOptionArray[n].getForegroundImageFile();
                    bl3 = false;
                    if (string4 != null) {
                        file2 = new File(string5 + string4);
                        bl3 = file2.exists();
                    }
                    if (!bl3) {
                        boolean bl5 = false;
                        if (string4 == null) {
                            string4 = string6 + "_" + pvDisplayOptionArray[n].getName() + ".gif";
                            pvDisplayOptionArray[n].setForegroundImageFile(string4);
                        } else {
                            bl5 = !string4.endsWith(".gif");
                            string4 = PsUtil.getFileBaseName(string4);
                            string4 = string4 + ".gif";
                            pvDisplayOptionArray[n].setForegroundImageFile(string4);
                        }
                        string3 = string5 + string4;
                        file = new File(string3);
                        if (!file.exists()) {
                            if (bl5) {
                                PsDebug.warning("currently, foreground image is always saved in GIF format.");
                            }
                            this.saveImage(image, string3);
                        }
                    }
                }
            }
            ++n;
        }
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        if (this.m_geometryOption != null) {
            pvDisplayLoader.setGeometryOption(this.m_geometryOption);
        }
        object = pvDisplayLoader.write(pvDisplayOptionArray);
        return this.saveString((String)object, string);
    }

    public String saveGeometryToString(PgGeometry[] pgGeometryArray, String string) {
        PgLoaderIf pgLoaderIf;
        if (pgGeometryArray == null || pgGeometryArray.length == 0) {
            PsDebug.warning("missing geometry to save.");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing file name extension.");
            return null;
        }
        if ((string = string.toLowerCase()).equalsIgnoreCase("byu") || string.equalsIgnoreCase("dxf") || string.equalsIgnoreCase("fe") || string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("mpl") || string.equalsIgnoreCase("obj") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("stl")) {
            if (pgGeometryArray.length > 1) {
                PsDebug.warning("only the active geometry of the scene is saved\n\tbecause restriction of the file format resp. export module\n\tUse JVX format to save more geometries in a single file.");
            }
            if ((string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("stl")) && !(pgGeometryArray[0] instanceof PgJvxSrc) && !(pgGeometryArray[0] instanceof PgElementSet)) {
                PsDebug.warning("format does not save other geometries besides surfaces, ext = " + string);
                return null;
            }
        }
        if ((pgLoaderIf = PgLoader.getLoader(string)) == null) {
            PsDebug.warning("unknown file extension, no loader found");
            return null;
        }
        if (this.getDisplayOption() != null) {
            pgLoaderIf.setDisplayOption(this.getDisplayOption());
        }
        PgJvxSrc[] pgJvxSrcArray = PgLoader.assureJvx(pgGeometryArray);
        StringWriter stringWriter = new StringWriter();
        try {
            if (!pgLoaderIf.write(stringWriter, pgJvxSrcArray)) {
                PsDebug.warning("error during export.");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed writing to writer,", iOException);
        }
        return stringWriter.toString();
    }

    public PgLoader() {
        this.init();
    }

    public boolean getTag(int n) {
        if (this.m_geometryOption == null) {
            return false;
        }
        return this.m_geometryOption.get(n);
    }

    public void setTag(int n, boolean bl) {
        if (bl) {
            if (this.m_geometryOption == null) {
                this.m_geometryOption = new BitSet(10);
            }
            this.m_geometryOption.set(n);
            return;
        }
        if (this.m_geometryOption == null) {
            return;
        }
        this.m_geometryOption.clear(n);
    }

    public static boolean readDirs(List list, String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        list.removeAll();
        list.add("..");
        String[] stringArray = PgLoader.readDirs(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
        return true;
    }

    public static String[] readDirs(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("could not read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild("directories");
        if (psXmlNode2 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode2.getChildren("directory");
        if (psXmlNodeArray == null) {
            return null;
        }
        String[] stringArray = new String[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            PsXmlNode psXmlNode3 = psXmlNodeArray[n].getChild("name");
            if (psXmlNode3 == null) {
                PsDebug.warning("directory has no name, dir = " + string);
            }
            stringArray[n] = psXmlNode3.getContent();
            ++n;
        }
        return stringArray;
    }

    public boolean saveGeometry(PgGeometry[] pgGeometryArray, String string) {
        Object object;
        Object object2;
        Object object3;
        if (pgGeometryArray == null) {
            PsDebug.warning("missing geometries");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        string2 = string2.toLowerCase();
        boolean bl = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(5);
        }
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < pgGeometryArray.length) {
            if (string3 == null) {
                string3 = PsUtil.getFilePath(string);
                string4 = PsUtil.getFileBaseName(string);
            }
            if (string3 == null || string4 == null) {
                PsDebug.warning("unable to extract path or base name of file name = " + string);
                break;
            }
            if (bl && (object3 = pgGeometryArray[n].getTextureImage()) != null) {
                String string5;
                if (!string2.equalsIgnoreCase("jvx") && !string2.equalsIgnoreCase("wrl")) {
                    if (string2.equalsIgnoreCase("obj")) {
                        PsDebug.warning("Texture coordinates and image saved,\n but OBJ file will only know the texture coordinates\n and not the name of the image file.");
                    } else {
                        PsDebug.warning("geometry format does not know about texture. Texture image saved anyway.");
                    }
                }
                if ((string5 = pgGeometryArray[n].getTextureImageName()) == null) {
                    string5 = pgGeometryArray[n].getName() + ".gif";
                } else if (!(string5 = PsUtil.getFileBaseName(string5)).endsWith(".gif")) {
                    PsDebug.warning("currently, texture is always saved in GIF format.");
                    string5 = string5 + ".gif";
                }
                if (!string5.startsWith(string4)) {
                    string5 = string4 + "_" + string5;
                }
                pgGeometryArray[n].setTextureImageName(string5);
                object2 = string3 + string5;
                this.saveImage((Image)object3, (String)object2);
                object = ((String)object2).substring(0, ((String)object2).lastIndexOf(46)) + ".ppm";
                this.saveImage((Image)object3, (String)object);
            }
            ++n;
        }
        if (PsConfig.isApplication()) {
            PgJvxSrc[] pgJvxSrcArray = PgLoader.assureJvx(pgGeometryArray);
            object3 = PsUtil.writeFile(string);
            if (object3 == null) {
                PsDebug.warning("could not open file = " + string);
                return false;
            }
            boolean bl2 = false;
            try {
                if (string2.equalsIgnoreCase("html") || string2.equalsIgnoreCase("htm")) {
                    string4 = string.substring(0, string.lastIndexOf(".html"));
                    this.saveGeometry(pgGeometryArray, string4 + ".jvx");
                    object2 = new Dimension(400, 300);
                    object = this.getDisplayOption();
                    if (object != null) {
                        this.saveDisplay(this.m_displayOption, string4 + ".jvd");
                        object2 = ((PvDisplayOption)object).getWindowSize();
                    }
                    string4 = PsUtil.getFileName(string4);
                    bl2 = PgHtmlLoader.write((Writer)object3, string4 + ".jvx", string4 + ".jvd", ((Dimension)object2).width, ((Dimension)object2).height);
                } else {
                    object2 = PgLoader.getLoader(string2);
                    if (object2 == null) {
                        PsDebug.warning("unknown file extension, no loader found");
                        ((PrintWriter)object3).close();
                        return false;
                    }
                    if (this.m_geometryOption != null) {
                        object2.setGeometryOption(this.m_geometryOption);
                    }
                    if (this.getDisplayOption() != null) {
                        object2.setDisplayOption(this.getDisplayOption());
                    }
                    bl2 = object2.write((Writer)object3, pgJvxSrcArray);
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("failed writing to writer,", iOException);
            }
            ((PrintWriter)object3).close();
            object3 = null;
            PsConfig.runGC();
            if (!bl2) {
                PsDebug.warning("error during export.");
            }
            return bl2;
        }
        String string6 = PgLoader.saveToString(pgGeometryArray, string2);
        if (string6 == null) {
            PsDebug.warning("error during export.");
            return false;
        }
        return PgLoader.save(string6, string);
    }

    public boolean saveGeometry(PgGeometryIf[] pgGeometryIfArray, String string) {
        if (pgGeometryIfArray == null) {
            PsDebug.warning("missing geometry to save.");
            return false;
        }
        PgGeometry[] pgGeometryArray = new PgGeometry[pgGeometryIfArray.length];
        int n = 0;
        while (n < pgGeometryIfArray.length) {
            pgGeometryArray[n] = (PgGeometry)pgGeometryIfArray[n];
            ++n;
        }
        return this.saveGeometry(pgGeometryArray, string);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static PgLoaderIf getLoader(String string) {
        if (string.endsWith(".gz") || string.endsWith(".zip")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if (PuString.isEmpty(string)) {
            PsDebug.warning("extension must have the form *.ext or *.ext.gz or *.ext.zip\n\twhere 'ext' is one of the supported geometry file formats.");
            return null;
        }
        String string2 = string.equalsIgnoreCase("mpl") ? "Maple" : (string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("m") ? "Math" : (string.equalsIgnoreCase("wrl") || string.equalsIgnoreCase("vrml") ? "Wrl" : String.valueOf(string.charAt(0)).toUpperCase() + string.substring(1, string.length())));
        String string3 = "Pg" + string2 + "Loader";
        Object object = PsUtil.newInstance("jv.loader." + string3);
        if (object == null && PsConfig.hasArchive(1)) {
            object = PsUtil.newInstance("jvx.loader." + string3);
        }
        if (object == null && PsConfig.hasArchive(2)) {
            object = PsUtil.newInstance("vgp.tutor.loader." + string3);
        }
        if ((string2.equalsIgnoreCase("jvf") || object == null) && PsConfig.hasArchive(2)) {
            object = PsUtil.newInstance("dev.loader." + string3);
        }
        if (object != null && !(object instanceof PgLoaderIf)) {
            PsDebug.warning("loader does not support interface jv.loader.PgLoaderIf, loader = " + string3);
            return null;
        }
        return (PgLoaderIf)object;
    }

    private static PgJvxSrc[] assureJvx(PgGeometryIf[] pgGeometryIfArray) {
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[pgGeometryIfArray.length];
        int n = 0;
        while (n < pgGeometryIfArray.length) {
            if (pgGeometryIfArray[n] == null) {
                PsDebug.warning("missing geometry at index i = " + n);
            } else if (pgGeometryIfArray[n] instanceof PgJvxSrc) {
                pgJvxSrcArray[n] = (PgJvxSrc)pgGeometryIfArray[n];
            } else {
                pgJvxSrcArray[n] = pgGeometryIfArray[n].getJvx();
                if (pgJvxSrcArray[n] == null) {
                    PsDebug.warning("failed to create jvx source of geom = " + pgGeometryIfArray[n].getName());
                }
            }
            ++n;
        }
        return pgJvxSrcArray;
    }

    public void init() {
        this.m_displayOption = null;
        this.m_bIsAnimated = false;
        this.m_bShowAnimationPanel = true;
        this.m_bIsEnabledOptimization = true;
    }

    public void setAnimated(boolean bl) {
        this.m_bIsAnimated = bl;
    }

    public PvDisplayOption[] loadDisplay(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null || !string2.equalsIgnoreCase("jvd")) {
            PsDebug.warning("missing or wrong extension in file=" + string);
            return null;
        }
        string2 = string2.toLowerCase();
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = null;
        try {
            try {
                pvDisplayOptionArray = this.loadDisplay(bufferedReader, string2);
            }
            catch (Exception exception) {
                PsDebug.warning("exception when reading file = " + string, exception);
                PvDisplayOption[] pvDisplayOptionArray2 = null;
                Object var11_9 = null;
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {}
                return pvDisplayOptionArray2;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {}
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        int n = 0;
        while (n < pvDisplayOptionArray.length) {
            if (pvDisplayOptionArray[n] != null) {
                int n2;
                Image image;
                String[] stringArray;
                String string3 = pvDisplayOptionArray[n].getBackgroundImageFile();
                if (string3 != null) {
                    stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getCodeBase()};
                    if (pvDisplayOptionArray[n].getOption(10)) {
                        image = null;
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            image = this.loadImageFromPath(stringArray[n2], string3);
                            if (image != null) {
                                pvDisplayOptionArray[n].setBackgroundImage(image);
                                pvDisplayOptionArray[n].setBackgroundImageFile(stringArray[n2] + string3);
                                break;
                            }
                            ++n2;
                        }
                        if (image == null) {
                            PsDebug.warning("failed loading background image = " + string3 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
                        }
                    } else {
                        pvDisplayOptionArray[n].setBackgroundImageFile(stringArray[0] + string3);
                    }
                } else {
                    pvDisplayOptionArray[n].setBackgroundImage(null);
                    pvDisplayOptionArray[n].setBackgroundImageFile(null);
                }
                if ((string3 = pvDisplayOptionArray[n].getForegroundImageFile()) != null) {
                    stringArray = new String[]{PsUtil.getFilePath(string), PsConfig.getCodeBase()};
                    if (pvDisplayOptionArray[n].getOption(19)) {
                        image = null;
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            image = this.loadImageFromPath(stringArray[n2], string3);
                            if (image != null) {
                                pvDisplayOptionArray[n].setForegroundImage(image);
                                pvDisplayOptionArray[n].setForegroundImageFile(stringArray[n2] + string3);
                                break;
                            }
                            ++n2;
                        }
                        if (image == null) {
                            PsDebug.warning("failed loading foreground image = " + string3 + " in:" + "\n\t" + PuString.mergeStrings(stringArray, "\n\t"));
                        }
                    } else {
                        pvDisplayOptionArray[n].setForegroundImageFile(stringArray[0] + string3);
                    }
                } else {
                    pvDisplayOptionArray[n].setForegroundImage(null);
                    pvDisplayOptionArray[n].setForegroundImageFile(null);
                }
            }
            ++n;
        }
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] loadDisplay(BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        if ((string = string.toLowerCase()).indexOf("jvd") == -1) {
            PsDebug.warning("wrong format for display options, ext = " + string);
            return null;
        }
        try {
            if (!bufferedReader.ready()) {
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("exception = " + iOException.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        PvDisplayOption[] pvDisplayOptionArray = pvDisplayLoader.read(bufferedReader);
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("reading of display from reader");
            return null;
        }
        this.setDisplayOption(pvDisplayOptionArray[0]);
        return pvDisplayOptionArray;
    }

    public static boolean parseEndOfLine(StreamTokenizer streamTokenizer) throws IOException {
        do {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -1) continue;
            return false;
        } while (streamTokenizer.ttype != 10);
        return true;
    }

    public void setEnabledOptimization(boolean bl) {
        this.m_bIsEnabledOptimization = bl;
    }
}

