/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PgLoaderIf;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgJvxLoader
implements PgLoaderIf {
    protected boolean m_bIsEnabledOptimization = false;
    protected BitSet m_geometryOption;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;
    private int m_jvVersion = Integer.MAX_VALUE;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public boolean isEnabledOptimization() {
        return this.m_bIsEnabledOptimization;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected PgJvxSrc[] parseRsrcTree(PsXmlSrc var1_1) {
        block239: {
            block230: {
                var2_2 = var1_1.getRootNode();
                if (var2_2 == null) {
                    PsDebug.warning("missing root node.");
                    return null;
                }
                if (var2_2.getType() == null || !var2_2.getType().equalsIgnoreCase("jvx-model")) {
                    PsDebug.warning("missing <jvx-model> element,\nthis is not a valid JavaView geometry file.");
                    return null;
                }
                var3_3 = PsXmlSrc.getRsrcNodes(var2_2, "meta");
                if (var3_3 != null && var3_3.length > 0) {
                    var4_4 = 0;
                    while (var4_4 < var3_3.length) {
                        var5_6 = var3_3[var4_4].getAttribute("generator");
                        if (var5_6 != null && (var6_7 /* !! */  = var5_6).startsWith("JavaView v.")) {
                            var7_8 = var6_7 /* !! */ .substring(var6_7 /* !! */ .indexOf(".") + 1);
                            var8_9 /* !! */  = PuString.splitString((String)var7_8, '.');
                            if (var8_9 /* !! */  != null && var8_9 /* !! */ .length <= 3) {
                                var9_14 = 0;
                                while (var9_14 < var8_9 /* !! */ .length) {
                                    if (var9_14 == 0) {
                                        this.m_jvVersion = 100000 * Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                    } else if (var9_14 == 1) {
                                        this.m_jvVersion += 1000 * Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                    } else if (var9_14 == 2) {
                                        try {
                                            this.m_jvVersion += Integer.parseInt(var8_9 /* !! */ [var9_14]);
                                        }
                                        catch (NumberFormatException v0) {}
                                    }
                                    ++var9_14;
                                }
                            } else {
                                PsDebug.warning("void JavaView version information in meta tag, generator = " + (String)var6_7 /* !! */ );
                            }
                        }
                        if ((var5_6 = var3_3[var4_4].getAttribute("dtd")) != null && (var6_7 /* !! */  = PuString.splitString(var5_6, '.')) != null && var6_7 /* !! */ .length > 0) {
                            var7_8 = new int[var6_7 /* !! */ .length];
                            var8_10 = 0;
                            while (var8_10 < var6_7 /* !! */ .length) {
                                var7_8[var8_10] = Integer.parseInt(var6_7 /* !! */ [var8_10]);
                                ++var8_10;
                            }
                            var8_9 /* !! */  = (String[])PsConfig.getVersion(11);
                            var9_14 = 0;
                            while (var9_14 < Math.min(1, var6_7 /* !! */ .length)) {
                                if (var8_9 /* !! */ [var9_14] != var7_8[var9_14]) {
                                    if (var8_9 /* !! */ [var9_14] > var7_8[var9_14]) break;
                                    PsDebug.message("Parsing a JVX file with jvx.dtd version=" + var5_6 + " which is newer than\n" + "\tversion=" + (int)var8_9 /* !! */ [0] + "." + (int)var8_9 /* !! */ [1] + "." + (int)var8_9 /* !! */ [2] + " implemented by the loader of this JavaView program." + "\n\tMight need to upgrade JavaView.", false);
                                    break;
                                }
                                ++var9_14;
                            }
                        }
                        ++var4_4;
                    }
                }
                var4_5 = null;
                var5_6 = null;
                var6_7 /* !! */  = PsXmlSrc.getRsrcNode(var2_2, "version");
                if (var6_7 /* !! */  == null) {
                    var4_5 = "0.0";
                    var5_6 = "dump";
                } else {
                    var4_5 = var6_7 /* !! */ .getContent();
                    var5_6 = var6_7 /* !! */ .getAttribute("type");
                }
                var7_8 = PsXmlSrc.getRsrc(var2_2, "title");
                var11_15 = null;
                var12_16 = new String[]{"tag", "name", "url", "detail"};
                var13_17 = PsXmlSrc.getRsrcNode(var2_2, "geometries");
                if (var13_17 == null) break block230;
                var14_18 /* !! */  = PsXmlSrc.getRsrcNodes(var13_17, "geometry");
                if (var14_18 /* !! */  == null || var14_18 /* !! */ .length == 0) {
                    return null;
                }
                var11_15 = new PgJvxSrc[var14_18 /* !! */ .length];
                var8_11 = 0;
                while (var8_11 < var11_15.length) {
                    block231: {
                        block232: {
                            block236: {
                                block238: {
                                    block237: {
                                        block233: {
                                            block235: {
                                                block234: {
                                                    var15_20 = new PgJvxSrc();
                                                    var11_15[var8_11] = var15_20;
                                                    var15_20.setVersion(var4_5);
                                                    var15_20.setVersionType(var5_6);
                                                    var15_20.setTitle((String)var7_8);
                                                    var16_21 = var14_18 /* !! */ [var8_11].getAttribute("name");
                                                    if (var16_21 != null) {
                                                        var15_20.setName((String)var16_21);
                                                    }
                                                    var15_20.setVisible(PgJvxLoader.parseVisibility(var14_18 /* !! */ [var8_11].getAttribute("visible")) != 0);
                                                    var17_22 = null;
                                                    if (var14_18 /* !! */ [var8_11].hasChild("labelAtt")) {
                                                        var18_23 = var14_18 /* !! */ [var8_11].getChild("labelAtt");
                                                        var17_22 = this.parseLabelAtt(var18_23);
                                                        if (var17_22 != null) {
                                                            var15_20.setLabelAttribute(5, (PiVector)var17_22);
                                                            var15_20.showName(var17_22.getEntry(5) == 1);
                                                            var19_24 = var18_23.getAttribute("name");
                                                            if (var19_24 != null) {
                                                                var15_20.setLabelFont(5, (String)var19_24);
                                                                var15_20.setLabelSize(5, var17_22.getEntry(6));
                                                                var15_20.setLabelStyle(5, var17_22.getEntry(7));
                                                            }
                                                        }
                                                        if (var18_23.hasChild("color")) {
                                                            var19_24 = PsXmlLoader.parseColorRGB(var18_23, "color");
                                                            var15_20.setLabelColor(5, (Color)var19_24);
                                                        }
                                                    }
                                                    if ((var18_23 = var14_18 /* !! */ [var8_11].getChild("material")) != null) {
                                                        var19_24 = var18_23.getAttribute("shading");
                                                        if (var19_24 != null && var19_24.equalsIgnoreCase("gouraud")) {
                                                            var15_20.showSmoothLighting(true);
                                                        } else {
                                                            var15_20.showSmoothLighting(false);
                                                        }
                                                        if (var18_23.hasChild("specular")) {
                                                            var20_25 = PsXmlLoader.parseColorRGB(var18_23.getChild("specular"), "color");
                                                            var15_20.setSpecularColor((Color)var20_25);
                                                        }
                                                        if ((var20_25 = var18_23.getChild("transparency")) != null) {
                                                            var21_26 = PsXmlSrc.getRsrcAsDouble(var18_23, "transparency");
                                                            var15_20.setTransparency(var21_26);
                                                            var23_27 = PgJvxLoader.parseVisibility(var20_25.getAttribute("visible"));
                                                            if (this.m_jvVersion < 280000 && var23_27 != 0) {
                                                                var15_20.showTransparency(true);
                                                            } else {
                                                                var15_20.showTransparency(var23_27 == 1);
                                                            }
                                                        }
                                                    }
                                                    var20_25 = null;
                                                    var21_26 = 0.0;
                                                    var26_35 = PsXmlSrc.getRsrcNode(var14_18 /* !! */ [var8_11], "pointSet");
                                                    if (var26_35 != null) {
                                                        var27_36 = var26_35.getAttribute("dim");
                                                        if (var27_36 == null) {
                                                            PsDebug.warning("missing dimension of geometry[" + var8_11 + "]");
                                                            return null;
                                                        }
                                                        var15_20.setDimOfVertices(Integer.parseInt((String)var27_36));
                                                        var15_20.showVertices(PgJvxLoader.parseVisibility(var26_35.getAttribute("point")) != 0);
                                                        var15_20.showVertexColors(PgJvxLoader.parseVisibility(var26_35.getAttribute("color")) == 1);
                                                        var15_20.showVertexNormals(PgJvxLoader.parseVisibility(var26_35.getAttribute("normal")) == 1);
                                                        var15_20.showVertexNormalArrow(PgJvxLoader.parseVisibility(var26_35.getAttribute("normalArrow")) == 1);
                                                        var15_20.showVertexSizes(PgJvxLoader.parseVisibility(var26_35.getAttribute("thicknesses")) == 1);
                                                        var15_20.showTaggedVertices(PgJvxLoader.parseVisibility(var26_35.getAttribute("pointMark")) != 0);
                                                        var15_20.showVertexOutline(PgJvxLoader.parseVisibility(var26_35.getAttribute("pointOutline")) != 0);
                                                        var15_20.setType(30);
                                                        var28_37 = PsXmlSrc.getRsrcNode(var26_35, "points");
                                                        if (var28_37 != null) {
                                                            var29_39 /* !! */  = PsXmlLoader.parseDoubleList(var28_37, "p", var12_16);
                                                            if (var29_39 /* !! */  != null) {
                                                                var15_20.setDimOfVertices(var29_39 /* !! */ [0].getSize());
                                                                var15_20.setNumVertices(var29_39 /* !! */ .length);
                                                                var15_20.setVertices((PdVector[])var29_39 /* !! */ );
                                                            } else {
                                                                var30_43 = PgJvxLoader.parseFunList(var28_37, "pf", var12_16);
                                                                if (var30_43 != null) {
                                                                    var15_20.setDimOfVertices(var30_43[0].length);
                                                                    var15_20.setNumVertices(((String[][])var30_43).length);
                                                                    var15_20.setVertexFunctions((String[][])var30_43);
                                                                }
                                                            }
                                                            if (var28_37.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble(var28_37, "thickness");
                                                                var15_20.setGlobalVertexSize(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB(var28_37, "color")) != null) {
                                                                var15_20.setGlobalVertexColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB(var28_37, "colorTag")) != null) {
                                                                var15_20.setGlobalVertexTagColor((Color)var20_25);
                                                            }
                                                            if (var28_37.hasChild("labelAtt")) {
                                                                var30_43 = var28_37.getChild("labelAtt");
                                                                v1 = var31_48 = PgJvxLoader.parseVisibility(var30_43.getAttribute("auto")) != 0;
                                                                if (!var31_48) {
                                                                    var15_20.setEnabledIndexLabels(false);
                                                                }
                                                                if ((var17_22 = this.parseLabelAtt((PsXmlNode)var30_43)) != null) {
                                                                    var15_20.setLabelAttribute(0, (PiVector)var17_22);
                                                                    var15_20.showVertexLabels(var17_22.getEntry(5) == 1);
                                                                    var32_52 = var30_43.getAttribute("name");
                                                                    if (var32_52 != null) {
                                                                        var15_20.setLabelFont(0, (String)var32_52);
                                                                        var15_20.setLabelSize(0, var17_22.getEntry(6));
                                                                        var15_20.setLabelStyle(0, var17_22.getEntry(7));
                                                                    }
                                                                }
                                                                if (var30_43.hasChild("color")) {
                                                                    var32_52 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_43, "color");
                                                                    var15_20.setLabelColor(0, (Color)var32_52);
                                                                }
                                                            }
                                                        }
                                                        if ((var29_39 /* !! */  = PsXmlSrc.getRsrcNode(var26_35, "colors")) != null && (var23_28 = PsXmlLoader.parseColorList((PsXmlNode)var29_39 /* !! */ , "c")) != null) {
                                                            var15_20.setVertexColors(var23_28);
                                                        }
                                                        if ((var30_43 = PsXmlSrc.getRsrcNode(var26_35, "normals")) != null) {
                                                            var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var30_43, "n", null);
                                                            if (var24_33 != null) {
                                                                var15_20.setVertexNormals(var24_33);
                                                            }
                                                            if (var30_43.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_43, "thickness");
                                                                var15_20.setGlobalVertexNormalSize(var21_26);
                                                            }
                                                            if (var30_43.hasChild("length")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_43, "length");
                                                                var15_20.setGlobalVertexNormalLength(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_43, "color")) != null) {
                                                                var15_20.setGlobalVertexNormalColor((Color)var20_25);
                                                            }
                                                        }
                                                        if ((var31_47 = PsXmlSrc.getRsrcNode(var26_35, "textures")) != null) {
                                                            var32_52 = var31_47.getAttribute("blend");
                                                            if (var32_52 != null) {
                                                                if (var32_52.equals("replace")) {
                                                                    var15_20.setBlendingMode(0);
                                                                } else if (var32_52.equals("material")) {
                                                                    var15_20.setBlendingMode(1);
                                                                } else if (var32_52.equals("alpha")) {
                                                                    var15_20.setBlendingMode(2);
                                                                } else {
                                                                    PsDebug.warning("Unknown texture attribute: blend = " + (String)var32_52);
                                                                }
                                                            } else {
                                                                var15_20.setBlendingMode(0);
                                                            }
                                                            var33_53 = var31_47.getAttribute("filter");
                                                            if (var33_53 != null) {
                                                                if (var33_53.equals("direct")) {
                                                                    var15_20.setFilterType(0);
                                                                } else if (var33_53.equals("linear")) {
                                                                    var15_20.setFilterType(1);
                                                                } else if (var33_53.equals("quadratic")) {
                                                                    var15_20.setFilterType(2);
                                                                } else {
                                                                    PsDebug.warning("Unknown texture attribute: filter = " + (String)var33_53);
                                                                }
                                                            } else {
                                                                var15_20.setFilterType(0);
                                                            }
                                                            var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var31_47, "t", null);
                                                            if (var24_33 != null) {
                                                                var15_20.setVertexTextures(var24_33);
                                                            }
                                                            if ((var34_56 = var31_47.getChild("image")) != null) {
                                                                var35_61 = PsXmlSrc.getRsrcNode((PsXmlNode)var34_56, "url");
                                                                if (var35_61 != null) {
                                                                    var19_24 = var35_61.getContent();
                                                                } else {
                                                                    var19_24 = var34_56.getContent();
                                                                    if (var19_24 != null) {
                                                                        PsDebug.warning("Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                    }
                                                                }
                                                                var36_62 /* !! */  = var34_56.getAttribute("repeat");
                                                                if (var36_62 /* !! */  != null && !"no".equals(var36_62 /* !! */ )) {
                                                                    PsDebug.warning("repeat mode in images not supported yet.");
                                                                }
                                                                if (var19_24 != null) {
                                                                    var15_20.setTextureImageName((String)var19_24);
                                                                }
                                                            }
                                                            if ((var35_61 = var31_47.getChild("imageCoords")) != null && (var36_62 /* !! */  = PsXmlLoader.parseDoubleList((PsXmlNode)var35_61, "p", null)) != null) {
                                                                var15_20.setTextureImageBnd(var36_62 /* !! */ );
                                                            }
                                                        }
                                                        if ((var32_52 = PsXmlSrc.getRsrcNode(var26_35, "thicknesses")) != null && (var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var32_52, "th", null)) != null) {
                                                            var33_53 = new PdVector(var24_33.length);
                                                            var10_19 = 0;
                                                            while (var10_19 < var24_33.length) {
                                                                var33_53.setEntry(var10_19, var24_33[var10_19].getEntry(0));
                                                                ++var10_19;
                                                            }
                                                            var15_20.setVertexSizes((PdVector)var33_53);
                                                        }
                                                    }
                                                    if ((var27_36 = PsXmlSrc.getRsrcNode(var14_18 /* !! */ [var8_11], "lineSet")) != null) {
                                                        var15_20.showPolygonStartArrow(PgJvxLoader.parseVisibility(var27_36.getAttribute("arrowStart")) == 1);
                                                        var15_20.showPolygonEndArrow(PgJvxLoader.parseVisibility(var27_36.getAttribute("arrow")) == 1);
                                                        var15_20.showPolygons(PgJvxLoader.parseVisibility(var27_36.getAttribute("line")) != 0);
                                                        var28_38 = PgJvxLoader.parseVisibility(var27_36.getAttribute("color")) == 1;
                                                        v2 = var29_40 = PgJvxLoader.parseVisibility(var27_36.getAttribute("colorFromPoints")) == 1;
                                                        if (var29_40 && var15_20.getVertexColors() == null) {
                                                            PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                            var29_40 = false;
                                                        }
                                                        var15_20.showPolygonColors(var28_38);
                                                        var15_20.showElementFromVertexColors(var29_40);
                                                        if (!var28_38 && var29_40 && PgJvxLoader.parseVisibility(var27_36.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                            PsDebug.warning("Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                            var15_20.showPolygonColors(true);
                                                        }
                                                        var15_20.showPolygonNormals(PgJvxLoader.parseVisibility(var27_36.getAttribute("normal")) == 1);
                                                        var15_20.showPolygonNormalArrow(PgJvxLoader.parseVisibility(var27_36.getAttribute("normalArrow")) == 1);
                                                        var15_20.showPolygonSizes(PgJvxLoader.parseVisibility(var27_36.getAttribute("thicknesses")) == 1);
                                                        var15_20.showSmoothElementColors(PgJvxLoader.parseVisibility(var27_36.getAttribute("colorSmooth")) == 1);
                                                        var15_20.showTaggedPolygons(PgJvxLoader.parseVisibility(var27_36.getAttribute("lineMark")) != 0);
                                                        var15_20.setType(32);
                                                        var30_43 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_36, "lines");
                                                        if (var30_43 != null) {
                                                            var31_47 = PsXmlLoader.parseIntegerList((PsXmlNode)var30_43, "l", var12_16);
                                                            if (var31_47 != null) {
                                                                var15_20.setDimOfPolygons(-1);
                                                                var15_20.setNumPolygons(var31_47.length);
                                                                var15_20.setPolygons(var31_47);
                                                            }
                                                            if (var30_43.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var30_43, "thickness");
                                                                var15_20.setGlobalPolygonSize(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_43, "color")) != null) {
                                                                var15_20.setGlobalPolygonColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var30_43, "colorTag")) != null) {
                                                                var15_20.setGlobalPolygonTagColor((Color)var20_25);
                                                            }
                                                            if (var30_43.hasChild("labelAtt")) {
                                                                var32_52 = var30_43.getChild("labelAtt");
                                                                var17_22 = this.parseLabelAtt((PsXmlNode)var32_52);
                                                                if (var17_22 != null) {
                                                                    var15_20.setLabelAttribute(2, (PiVector)var17_22);
                                                                    var15_20.showPolygonLabels(var17_22.getEntry(5) == 1);
                                                                    var33_53 = var32_52.getAttribute("name");
                                                                    if (var33_53 != null) {
                                                                        var15_20.setLabelFont(2, (String)var33_53);
                                                                        var15_20.setLabelSize(2, var17_22.getEntry(6));
                                                                        var15_20.setLabelStyle(2, var17_22.getEntry(7));
                                                                    }
                                                                }
                                                                if (var32_52.hasChild("color")) {
                                                                    var33_53 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "color");
                                                                    var15_20.setLabelColor(2, (Color)var33_53);
                                                                }
                                                            }
                                                        }
                                                        if ((var31_47 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_36, "colors")) != null) {
                                                            var23_29 = PsXmlLoader.parseColorList((PsXmlNode)var31_47, "c");
                                                            if (var23_29 != null) {
                                                                var15_20.setPolygonColors(var23_29);
                                                            }
                                                        } else if (var28_38 && !var29_40) {
                                                            PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual edge nor vertex colors.\n");
                                                            var29_40 = false;
                                                        }
                                                        if ((var32_52 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_36, "normals")) != null) {
                                                            var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var32_52, "n", null);
                                                            if (var24_33 != null) {
                                                                var15_20.setPolygonNormals(var24_33);
                                                            }
                                                            if (var32_52.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_52, "thickness");
                                                                var15_20.setGlobalPolygonNormalSize(var21_26);
                                                            }
                                                            if (var32_52.hasChild("length")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_52, "length");
                                                                var15_20.setGlobalPolygonNormalLength(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "color")) != null) {
                                                                var15_20.setGlobalPolygonNormalColor((Color)var20_25);
                                                            }
                                                        }
                                                        if ((var33_53 = PsXmlSrc.getRsrcNode((PsXmlNode)var27_36, "thicknesses")) != null && (var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var33_53, "th", null)) != null) {
                                                            var34_56 = new PdVector(var24_33.length);
                                                            var10_19 = 0;
                                                            while (var10_19 < var24_33.length) {
                                                                var34_56.setEntry(var10_19, var24_33[var10_19].getEntry(0));
                                                                ++var10_19;
                                                            }
                                                            var15_20.setPolygonSizes((PdVector)var34_56);
                                                        }
                                                    }
                                                    if ((var28_37 = PsXmlSrc.getRsrcNode(var14_18 /* !! */ [var8_11], "faceSet")) != null) {
                                                        var15_20.showElements(PgJvxLoader.parseVisibility(var28_37.getAttribute("face")) != 0);
                                                        var15_20.showEdges(PgJvxLoader.parseVisibility(var28_37.getAttribute("edge")) != 0);
                                                        var15_20.showElementNormals(PgJvxLoader.parseVisibility(var28_37.getAttribute("normal")) == 1);
                                                        var15_20.showElementNormalArrow(PgJvxLoader.parseVisibility(var28_37.getAttribute("normalArrow")) == 1);
                                                        var29_42 = PgJvxLoader.parseVisibility(var28_37.getAttribute("color")) == 1;
                                                        v3 = var30_44 = PgJvxLoader.parseVisibility(var28_37.getAttribute("colorFromPoints")) == 1;
                                                        if (var30_44 && var15_20.getVertexColors() == null) {
                                                            PsDebug.warning("Missing vertex colors, found <colorFromPoints> attribute but missing <color> section of pointSet.\n");
                                                            var30_44 = false;
                                                        }
                                                        var15_20.showElementColors(var29_42);
                                                        var15_20.showElementFromVertexColors(var30_44);
                                                        if (!var29_42 && var30_44 && PgJvxLoader.parseVisibility(var28_37.getAttribute("color")) == -1 && this.m_jvVersion < 361000) {
                                                            PsDebug.warning("Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.61 or later.");
                                                            var15_20.showElementColors(true);
                                                        }
                                                        var15_20.showElementBackColor(PgJvxLoader.parseVisibility(var28_37.getAttribute("colorBackGlobal")) == 1);
                                                        var15_20.showElementBackColors(PgJvxLoader.parseVisibility(var28_37.getAttribute("colorBackLocal")) == 1);
                                                        var15_20.showSmoothElementColors(PgJvxLoader.parseVisibility(var28_37.getAttribute("colorSmooth")) == 1);
                                                        var15_20.showEdgeColors(PgJvxLoader.parseVisibility(var28_37.getAttribute("colorEdge")) == 1);
                                                        var15_20.showEdgeColorFromElements(PgJvxLoader.parseVisibility(var28_37.getAttribute("colorEdgeInduced")) == 1);
                                                        var31_49 = PgJvxLoader.parseVisibility(var28_37.getAttribute("backface")) != 0;
                                                        var15_20.showBackface(var31_49);
                                                        var15_20.showBoundaries(PgJvxLoader.parseVisibility(var28_37.getAttribute("boundary")) == 1);
                                                        var15_20.showSilhouette(PgJvxLoader.parseVisibility(var28_37.getAttribute("silhouette")) == 1);
                                                        var15_20.showTaggedElements(PgJvxLoader.parseVisibility(var28_37.getAttribute("faceMark")) != 0);
                                                        var15_20.setType(33);
                                                        var32_52 = PsXmlSrc.getRsrcNode(var28_37, "faces");
                                                        if (var32_52 != null) {
                                                            var33_53 = PsXmlLoader.parseIntegerList((PsXmlNode)var32_52, "f", var12_16);
                                                            if (var33_53 != null) {
                                                                var15_20.setDimOfElements(-1);
                                                                var15_20.setNumElements(var33_53.length);
                                                                var15_20.setElements(var33_53);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "color")) != null) {
                                                                var15_20.setGlobalElementColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "colorBack")) != null) {
                                                                var15_20.setGlobalElementBackColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "colorTag")) != null) {
                                                                var15_20.setGlobalElementTagColor((Color)var20_25);
                                                            }
                                                            if (var32_52.hasChild("creaseAngle")) {
                                                                var34_57 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_52, "creaseAngle");
                                                                var15_20.setCreaseAngle(var34_57);
                                                            }
                                                            if (var32_52.hasChild("labelAtt")) {
                                                                var34_59 = var32_52.getChild("labelAtt");
                                                                var17_22 = this.parseLabelAtt(var34_59);
                                                                if (var17_22 != null) {
                                                                    var15_20.setLabelAttribute(3, (PiVector)var17_22);
                                                                    var15_20.showElementLabels(var17_22.getEntry(5) == 1);
                                                                    var35_61 = var34_59.getAttribute("name");
                                                                    if (var35_61 != null) {
                                                                        var15_20.setLabelFont(3, (String)var35_61);
                                                                        var15_20.setLabelSize(3, var17_22.getEntry(6));
                                                                        var15_20.setLabelStyle(3, var17_22.getEntry(7));
                                                                    }
                                                                }
                                                                if (var34_59.hasChild("color")) {
                                                                    var35_61 = PsXmlLoader.parseColorRGB(var34_59, "color");
                                                                    var15_20.setLabelColor(3, (Color)var35_61);
                                                                }
                                                            }
                                                        }
                                                        if ((var33_53 = PsXmlSrc.getRsrcNode(var28_37, "neighbours")) != null) {
                                                            var34_60 = PsXmlLoader.parseIntegerList((PsXmlNode)var33_53, "nb", null);
                                                            if (var34_60 != null) {
                                                                var15_20.setNeighbours(var34_60);
                                                            } else {
                                                                this.m_bIsEnabledOptimization = PgJvxLoader.parseVisibility(var33_53.getAttribute("auto")) == 1;
                                                            }
                                                        } else {
                                                            this.m_bIsEnabledOptimization = true;
                                                            PsDebug.message("JVX surface (name=" + var15_20.getName() + ") with no neighbour information found, identifying equal vertices.", false);
                                                        }
                                                        var34_56 = PsXmlSrc.getRsrcNode(var28_37, "edges");
                                                        if (var34_56 != null) {
                                                            var25_34 = PsXmlLoader.parseIntegerList((PsXmlNode)var34_56, "e", null);
                                                            if (var25_34 != null) {
                                                                var15_20.setEdges(var25_34);
                                                            }
                                                            if (var34_56.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var34_56, "thickness");
                                                                var15_20.setGlobalEdgeSize(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_56, "color")) != null) {
                                                                var15_20.setGlobalEdgeColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var34_56, "colorTag")) != null) {
                                                                var15_20.setGlobalEdgeTagColor((Color)var20_25);
                                                            }
                                                            if (var34_56.hasChild("labelAtt")) {
                                                                var35_61 = var34_56.getChild("labelAtt");
                                                                var17_22 = this.parseLabelAtt((PsXmlNode)var35_61);
                                                                if (var17_22 != null) {
                                                                    var15_20.setLabelAttribute(1, (PiVector)var17_22);
                                                                    var15_20.showEdgeLabels(var17_22.getEntry(5) == 1);
                                                                    var36_62 /* !! */  = var35_61.getAttribute("name");
                                                                    if (var36_62 /* !! */  != null) {
                                                                        var15_20.setLabelFont(1, (String)var36_62 /* !! */ );
                                                                        var15_20.setLabelSize(1, var17_22.getEntry(6));
                                                                        var15_20.setLabelStyle(1, var17_22.getEntry(7));
                                                                    }
                                                                }
                                                                if (var35_61.hasChild("color")) {
                                                                    var36_62 /* !! */  = PsXmlLoader.parseColorRGB((PsXmlNode)var35_61, "color");
                                                                    var15_20.setLabelColor(1, (Color)var36_62 /* !! */ );
                                                                }
                                                            }
                                                        }
                                                        if ((var35_61 = PsXmlSrc.getRsrcNode(var28_37, "colors")) != null) {
                                                            var23_30 = PsXmlLoader.parseColorList((PsXmlNode)var35_61, "c");
                                                            if (var23_30 != null) {
                                                                var15_20.setElementColors(var23_30);
                                                            }
                                                        } else if (var29_42 && !var30_44) {
                                                            PsDebug.warning("Missing individual colors, found <color=show> attribute but neither individual element nor vertex colors.\n");
                                                            var30_44 = false;
                                                        }
                                                        if ((var36_62 /* !! */  = PsXmlSrc.getRsrcNode(var28_37, "colorsBack")) != null && (var23_31 = PsXmlLoader.parseColorList((PsXmlNode)var36_62 /* !! */ , "c")) != null) {
                                                            var15_20.setElementBackColors(var23_31);
                                                        }
                                                        if ((var37_63 = PsXmlSrc.getRsrcNode(var28_37, "normals")) != null) {
                                                            var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var37_63, "n", null);
                                                            if (var24_33 != null) {
                                                                var15_20.setElementNormals(var24_33);
                                                            }
                                                            if (var37_63.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var37_63, "thickness");
                                                                var15_20.setGlobalElementNormalSize(var21_26);
                                                            }
                                                            if (var37_63.hasChild("length")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var37_63, "length");
                                                                var15_20.setGlobalElementNormalLength(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var37_63, "color")) != null) {
                                                                var15_20.setGlobalElementNormalColor((Color)var20_25);
                                                            }
                                                        } else if ((!var31_49 || var15_20.isShowingElementNormals()) && var15_20.getDimOfVertices() == 3) {
                                                            var15_20.makeElementNormals();
                                                        }
                                                        var38_65 = PsXmlSrc.getRsrcNode(var28_37, "textures");
                                                        v4 = var39_66 = PgJvxLoader.parseVisibility(var28_37.getAttribute("texture")) == 1;
                                                        if (var38_65 == null) {
                                                            var15_20.showVertexTexture(var39_66);
                                                        } else {
                                                            var15_20.showElementTexture(var39_66);
                                                            var40_67 = var38_65.getAttribute("blend");
                                                            if (var40_67 != null) {
                                                                if (var40_67.equals("replace")) {
                                                                    var15_20.setBlendingMode(0);
                                                                } else if (var40_67.equals("material")) {
                                                                    var15_20.setBlendingMode(1);
                                                                } else if (var40_67.equals("alpha")) {
                                                                    var15_20.setBlendingMode(2);
                                                                } else {
                                                                    PsDebug.warning("Unknown texture attribute: blend = " + (String)var40_67);
                                                                }
                                                            } else {
                                                                var15_20.setBlendingMode(0);
                                                            }
                                                            var41_68 = var38_65.getAttribute("filter");
                                                            if (var41_68 != null) {
                                                                if (var41_68.equals("direct")) {
                                                                    var15_20.setFilterType(0);
                                                                } else if (var41_68.equals("linear")) {
                                                                    var15_20.setFilterType(1);
                                                                } else if (var41_68.equals("quadratic")) {
                                                                    var15_20.setFilterType(2);
                                                                } else {
                                                                    PsDebug.warning("Unknown texture attribute: filter = " + var41_68);
                                                                }
                                                            } else {
                                                                var15_20.setFilterType(0);
                                                            }
                                                            var42_69 = PsXmlLoader.parseDoubleList((PsXmlNode)var38_65, "t", null);
                                                            var43_70 = var15_20.getNumElements();
                                                            if (var42_69 != null && var43_70 > 0) {
                                                                var15_20.assureElementTextures();
                                                                var44_71 = var15_20.getElementTextures();
                                                                var45_73 = 0;
                                                                var46_75 /* !! */  = var15_20.getElements();
                                                                var10_19 = 0;
                                                                while (var10_19 < var43_70) {
                                                                    var47_76 = var46_75 /* !! */ [var10_19].getSize();
                                                                    var48_77 = 0;
                                                                    while (var48_77 < var47_76) {
                                                                        var44_71[var10_19][var48_77].copy(var42_69[var45_73++]);
                                                                        ++var48_77;
                                                                    }
                                                                    ++var10_19;
                                                                }
                                                                if (var45_73 != var42_69.length) {
                                                                    PsDebug.warning("element texture coordinates do not match elements.");
                                                                    var15_20.setElementTextures(null);
                                                                } else {
                                                                    var15_20.setVertexTextures(null);
                                                                }
                                                            }
                                                            if ((var44_71 = var38_65.getChild("image")) != null) {
                                                                var45_74 = PsXmlSrc.getRsrcNode((PsXmlNode)var44_71, "url");
                                                                if (var45_74 != null) {
                                                                    var19_24 = var45_74.getContent();
                                                                } else {
                                                                    var19_24 = var44_71.getContent();
                                                                    if (var19_24 != null) {
                                                                        PsDebug.warning("Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                                    }
                                                                }
                                                                var46_75 /* !! */  = var44_71.getAttribute("repeat");
                                                                if (var46_75 /* !! */  != null && !"no".equals(var46_75 /* !! */ )) {
                                                                    PsDebug.warning("repeat mode in images not supported yet.");
                                                                }
                                                                if (var19_24 != null) {
                                                                    var15_20.setTextureImageName((String)var19_24);
                                                                }
                                                            }
                                                            if ((var45_72 = var38_65.getChild("imageCoords")) != null && (var46_75 /* !! */  = PsXmlLoader.parseDoubleList(var45_72, "p", null)) != null) {
                                                                var15_20.setTextureImageBnd((PdVector[])var46_75 /* !! */ );
                                                            }
                                                        }
                                                        var40_67 = PsXmlSrc.getRsrcNode(var28_37, "boundaries");
                                                        if (var40_67 != null) {
                                                            if (var40_67.hasChild("thickness")) {
                                                                var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var40_67, "thickness");
                                                                var15_20.setGlobalBndSize(var21_26);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var40_67, "color")) != null) {
                                                                var15_20.setGlobalBndColor((Color)var20_25);
                                                            }
                                                            if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var40_67, "colorTag")) != null) {
                                                                var15_20.setGlobalBndTagColor((Color)var20_25);
                                                            }
                                                        }
                                                    }
                                                    if ((var29_39 /* !! */  = PsXmlSrc.getRsrcNodes(var14_18 /* !! */ [var8_11], "vectorField")) != null && var29_39 /* !! */ .length > 0) {
                                                        var15_20.setNumVectorFields(var29_39 /* !! */ .length);
                                                        var15_20.showVectorFields(true);
                                                        var9_14 = 0;
                                                        while (var9_14 < var29_39 /* !! */ .length) {
                                                            var30_46 = var29_39 /* !! */ [var9_14].getAttribute("name");
                                                            if (var30_46 != null) {
                                                                var15_20.setVectorFieldName(var9_14, var30_46);
                                                            }
                                                            if ((var31_50 = var29_39 /* !! */ [var9_14].getAttribute("base")) != null) {
                                                                var15_20.setVectorElementBased(var9_14, var31_50.equals("element"));
                                                            }
                                                            var15_20.showVectorField(var9_14, PgJvxLoader.parseVisibility(var29_39 /* !! */ [var9_14].getAttribute("vector")) != 0);
                                                            var15_20.showIndividualMaterial(var9_14, PgJvxLoader.parseVisibility(var29_39 /* !! */ [var9_14].getAttribute("material")) != 0);
                                                            var15_20.showVectorArrows(var9_14, PgJvxLoader.parseVisibility(var29_39 /* !! */ [var9_14].getAttribute("arrow")) == 1);
                                                            var15_20.showVectorColors(var9_14, PgJvxLoader.parseVisibility(var29_39 /* !! */ [var9_14].getAttribute("color")) == 1);
                                                            var32_52 = PsXmlSrc.getRsrcNode(var29_39 /* !! */ [var9_14], "vectors");
                                                            if (var32_52 != null) {
                                                                var24_33 = PsXmlLoader.parseDoubleList((PsXmlNode)var32_52, "v", var12_16);
                                                                if (var24_33 != null && (var33_54 = var24_33.length) > 0) {
                                                                    var15_20.setNumVectors(var9_14, var33_54, var24_33[0].getSize());
                                                                    var15_20.setVectors(var9_14, var24_33);
                                                                }
                                                                if (var32_52.hasChild("thickness")) {
                                                                    var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_52, "thickness");
                                                                    var15_20.setGlobalVectorSize(var9_14, var21_26);
                                                                }
                                                                if (var32_52.hasChild("length")) {
                                                                    var21_26 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)var32_52, "length");
                                                                    var15_20.setGlobalVectorLength(var9_14, var21_26);
                                                                }
                                                                if ((var20_25 = PsXmlLoader.parseColorRGB((PsXmlNode)var32_52, "color")) != null) {
                                                                    var15_20.setGlobalVectorColor(var9_14, (Color)var20_25);
                                                                }
                                                            }
                                                            if ((var33_53 = PsXmlSrc.getRsrcNode(var29_39 /* !! */ [var9_14], "colors")) != null && (var23_32 = PsXmlLoader.parseColorList((PsXmlNode)var33_53, "c")) != null) {
                                                                var15_20.setVectorColors(var9_14, var23_32);
                                                            }
                                                            ++var9_14;
                                                        }
                                                    }
                                                    if ((var30_43 = PsXmlSrc.getRsrcNode(var14_18 /* !! */ [var8_11], "center")) != null) {
                                                        var31_51 = var30_43.getAttribute("visible");
                                                        var15_20.showCenter(var31_51 == null || var31_51.equalsIgnoreCase("show") != false);
                                                        var32_52 = PsXmlLoader.parsePdVector((PsXmlNode)var30_43, "p", null);
                                                        var15_20.setCenter((PdVector)var32_52);
                                                    }
                                                    if ((var31_47 = PsXmlSrc.getRsrcNode(var14_18 /* !! */ [var8_11], "primitive")) != null) {
                                                        PsDebug.warning("parsing of primitives not implemented yet.");
                                                    }
                                                    if ((var32_52 = var14_18 /* !! */ [var8_11].getChild("transform")) == null) break block231;
                                                    if (var32_52.hasChild("modelMat") && (var33_53 = PsXmlLoader.parsePdMatrix((PsXmlNode)var32_52, "modelMat")) != null) {
                                                        var15_20.setModelMatrix((PdMatrix)var33_53);
                                                    }
                                                    if ((var33_53 = var32_52.getChild("ambient")) == null) break block231;
                                                    var34_56 = var33_53.getAttribute("dim");
                                                    var35_61 = var33_53.getAttribute("space");
                                                    var36_62 /* !! */  = var33_53.getAttribute("projection");
                                                    if (var35_61 == null || var34_56 == null || var36_62 /* !! */  == null) break block232;
                                                    var37_64 = Integer.parseInt((String)var34_56);
                                                    if (!var35_61.equalsIgnoreCase("euclidean")) break block233;
                                                    if (var37_64 == 1) {
                                                        var15_20.setAmbientSpace(0);
                                                    } else if (var37_64 == 2) {
                                                        var15_20.setAmbientSpace(1);
                                                    } else if (var37_64 == 3) {
                                                        var15_20.setAmbientSpace(3);
                                                    } else if (var37_64 == 4) {
                                                        var15_20.setAmbientSpace(6);
                                                    } else if (var37_64 == 5) {
                                                        var15_20.setAmbientSpace(9);
                                                    } else {
                                                        PsDebug.warning("combination of ambient space and dimension not allowed");
                                                        return null;
                                                    }
                                                    if (!var36_62 /* !! */ .equalsIgnoreCase("parallel")) break block234;
                                                    var15_20.setAmbientProjection(0);
                                                    break block232;
                                                }
                                                if (!var36_62 /* !! */ .equalsIgnoreCase("stereographic")) break block235;
                                                var15_20.setAmbientProjection(1);
                                                break block232;
                                            }
                                            PsDebug.warning("combination of ambient space and projection not allowed");
                                            return null;
                                        }
                                        if (!var35_61.equalsIgnoreCase("spherical")) break block236;
                                        if (var37_64 == 2) {
                                            var15_20.setAmbientSpace(2);
                                        } else if (var37_64 == 3) {
                                            var15_20.setAmbientSpace(4);
                                        } else if (var37_64 == 4) {
                                            var15_20.setAmbientSpace(7);
                                        } else if (var37_64 == 5) {
                                            var15_20.setAmbientSpace(10);
                                        } else {
                                            PsDebug.warning("combination of ambient space and dimension not allowed");
                                            return null;
                                        }
                                        if (!var36_62 /* !! */ .equalsIgnoreCase("parallel")) break block237;
                                        var15_20.setAmbientProjection(0);
                                        break block232;
                                    }
                                    if (!var36_62 /* !! */ .equalsIgnoreCase("stereographic")) break block238;
                                    var15_20.setAmbientProjection(1);
                                    break block232;
                                }
                                PsDebug.warning("combination of ambient space and projection not allowed");
                                return null;
                            }
                            if (!var35_61.equalsIgnoreCase("hyperbolic")) ** GOTO lbl645
                            if (var37_64 == 3) {
                                var15_20.setAmbientSpace(5);
                            } else if (var37_64 == 4) {
                                var15_20.setAmbientSpace(8);
                            } else if (var37_64 == 5) {
                                var15_20.setAmbientSpace(11);
                            } else {
                                PsDebug.warning("combination of ambient space and dimension not allowed");
                                return null;
                            }
                            if (var36_62 /* !! */ .equalsIgnoreCase("parallel")) {
                                var15_20.setAmbientProjection(0);
                            } else if (var36_62 /* !! */ .equalsIgnoreCase("poincare")) {
                                var15_20.setAmbientProjection(1);
                            } else if (var36_62 /* !! */ .equalsIgnoreCase("klein")) {
                                var15_20.setAmbientProjection(2);
                            } else if (var36_62 /* !! */ .equalsIgnoreCase("uhs")) {
                                var15_20.setAmbientProjection(3);
                            } else {
                                PsDebug.warning("combination of ambient space and projection not allowed");
                                return null;
lbl645:
                                // 1 sources

                                if (var35_61.equalsIgnoreCase("lorentz")) {
                                    PsDebug.warning("not implemented yet, ambient space = " + (String)var35_61);
                                    return null;
                                }
                                PsDebug.warning("unknown ambient space = " + (String)var35_61);
                                return null;
                            }
                        }
                        var37_63 = PsXmlLoader.parsePdMatrix((PsXmlNode)var33_53, "ambientMat");
                        var38_65 = PsXmlLoader.parsePdMatrix((PsXmlNode)var33_53, "ambientInvMat");
                        if (var37_63 != null && var38_65 != null) {
                            var15_20.setAmbientMatrix((PdMatrix)var37_63, (PdMatrix)var38_65);
                        }
                    }
                    ++var8_11;
                }
                break block239;
            }
            PsDebug.warning("missing XML node <geometries>.");
        }
        var14_18 /* !! */  = PsXmlSrc.getRsrcNode(var2_2, "authors");
        var15_20 = null;
        if (var14_18 /* !! */  != null) {
            var15_20 = new PsAuthorInfo();
            var15_20.setXmlNode((PsXmlNode)var14_18 /* !! */ );
        }
        var16_21 = PsXmlSrc.getRsrcNode(var2_2, "description");
        var17_22 = null;
        if (var16_21 != null) {
            var17_22 = new PsGeometryInfo();
            var17_22.setXmlNode((PsXmlNode)var16_21, null);
        }
        if (var11_15 != null) {
            var8_13 = 0;
            while (var8_13 < var11_15.length) {
                if (var15_20 != null) {
                    var11_15[var8_13].setAuthorInfo((PsAuthorInfo)var15_20);
                }
                if (var17_22 != null) {
                    var11_15[var8_13].setGeometryInfo((PsGeometryInfo)var17_22);
                }
                ++var8_13;
            }
        }
        return var11_15;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parseRsrcTree(psXmlSrc);
        if (pgJvxSrcArray == null) {
            PsDebug.warning("failed to interpret JVX tree");
            return null;
        }
        return pgJvxSrcArray;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgJvxLoader pgJvxLoader = new PgJvxLoader();
        PgJvxSrc[] pgJvxSrcArray = pgJvxLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        pgJvxLoader = null;
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                String string2;
                if (pgJvxSrcArray[n] != null && ((string2 = pgJvxSrcArray[n].getName()) == null || string2.toLowerCase().startsWith("object_"))) {
                    String string3 = PsUtil.getFileBaseName(string);
                    if (n == 0) {
                        pgJvxSrcArray[n].setName(string3);
                    } else {
                        pgJvxSrcArray[n].setName(string3 + "[" + n + "]");
                    }
                }
                ++n;
            }
        }
        return pgJvxSrcArray;
    }

    protected static PsXmlNode fillLabelAttr(boolean bl) {
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(bl));
        return psXmlNode;
    }

    protected static PsXmlNode fillLabelAttr(PiVector piVector, String string) {
        int n = piVector.getEntry(0);
        int n2 = piVector.getEntry(1);
        int n3 = piVector.getEntry(2);
        int n4 = piVector.getEntry(3);
        int n5 = piVector.getEntry(4);
        int n6 = piVector.getEntry(5);
        int n7 = piVector.getEntry(6);
        int n8 = piVector.getEntry(7);
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(n6 == 1));
        switch (n3) {
            case 0: {
                psXmlNode.addAttribute("horAlign", "head");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("horAlign", "center");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("horAlign", "tail");
            }
        }
        switch (n4) {
            case 2: {
                psXmlNode.addAttribute("verAlign", "top");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("verAlign", "middle");
                break;
            }
            case 0: {
                psXmlNode.addAttribute("verAlign", "bottom");
            }
        }
        switch (n5) {
            case 0: {
                psXmlNode.addAttribute("font", "text");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("font", "fixed");
                break;
            }
            case 3: {
                psXmlNode.addAttribute("font", "header2");
                break;
            }
            case 4: {
                psXmlNode.addAttribute("font", "header4");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("font", "menu");
            }
        }
        psXmlNode.addChild("xOffset", String.valueOf(n));
        psXmlNode.addChild("yOffset", String.valueOf(n2));
        if (string != null) {
            psXmlNode.addAttribute("name", string);
            switch (n8) {
                case 0: {
                    psXmlNode.addAttribute("style", "plain");
                    break;
                }
                case 1: {
                    psXmlNode.addAttribute("style", "bold");
                    break;
                }
                case 2: {
                    psXmlNode.addAttribute("style", "italic");
                    break;
                }
                case 3: {
                    psXmlNode.addAttribute("style", "bold+italic");
                }
            }
            psXmlNode.addChild("size", String.valueOf(n7));
        }
        return psXmlNode;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    protected static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            String string2 = psXmlNodeArray[n].getContent();
            if (string2 != null) {
                String[] stringArray3 = PuString.splitString(string2, ' ');
                stringArray2[n] = new String[stringArray3.length];
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray2[n][n2] = stringArray3[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray2;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null) {
            PsDebug.warning("missing geometries.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write(writer, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("failed to write XML tree", iOException);
            return false;
        }
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public String write(PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometries.");
            return null;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        Object object;
        Object object2;
        String string;
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(8);
        String string2 = psXmlNode.getAttribute("visible");
        if (string2 != null && "hide".equalsIgnoreCase(string2)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string3 = psXmlNode.getAttribute("horAlign");
        if (string3 == null || "head".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string3)) {
            piVector.setEntry(2, 2);
        }
        String string4 = psXmlNode.getAttribute("verAlign");
        if ("bottom".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 0);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning("Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                piVector.setEntry(3, 2);
            }
        } else if (string4 == null || "middle".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string4)) {
            piVector.setEntry(3, 2);
            if (this.m_jvVersion > 221000 && this.m_jvVersion < 299030) {
                PsDebug.warning("Encountered void use of attribute \"verAlign\" produced with a JavaView beta.\n\tSave JVX file with a newer JavaView such as v.2.99.030");
                piVector.setEntry(3, 0);
            }
        } else if ("head".equalsIgnoreCase(string4)) {
            PsDebug.warning("Encountered void use of attribute \"verAlign\".\n\tSave JVX file with a newer JavaView such as v.2.99.030");
            piVector.setEntry(3, 1);
        }
        if ((string = psXmlNode.getAttribute("font")) == null) {
            piVector.setEntry(4, 0);
        } else if ("text".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string)) {
            piVector.setEntry(4, 2);
        }
        try {
            object2 = PsXmlSrc.getRsrcNode(psXmlNode, "xOffset");
            if (object2 != null) {
                piVector.setEntry(0, Integer.parseInt(((PsXmlNode)object2).getContent()));
            }
            if ((object = PsXmlSrc.getRsrcNode(psXmlNode, "yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(((PsXmlNode)object).getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format parsing offset");
            return null;
        }
        object2 = psXmlNode.getAttribute("name");
        if (object2 != null) {
            object = psXmlNode.getAttribute("style");
            if (object == null) {
                piVector.setEntry(7, 0);
            } else if (((String)object).equals("plain")) {
                piVector.setEntry(7, 0);
            } else if (((String)object).equals("bold")) {
                piVector.setEntry(7, 1);
            } else if (((String)object).equals("italic")) {
                piVector.setEntry(7, 2);
            } else if (((String)object).equals("bold+italic")) {
                piVector.setEntry(7, 3);
            }
            if (psXmlNode.hasChild("size")) {
                int n = (int)PsXmlSrc.getRsrcAsDouble(psXmlNode, "size");
                piVector.setEntry(6, n);
            } else {
                piVector.setEntry(6, 12);
            }
        }
        return piVector;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        Object object;
        Object object2;
        Serializable serializable;
        PsXmlNode psXmlNode;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            return null;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
            bl4 = this.m_geometryOption.get(3);
            bl5 = this.m_geometryOption.get(4);
            bl6 = this.m_geometryOption.get(5);
            bl7 = this.m_geometryOption.get(6);
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode = psXmlSrc.getRootNode()) == null) {
            psXmlNode = new PsXmlNode("jvx-model");
            psXmlSrc.setRootNode(psXmlNode);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvx-model");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jvx.dtd");
        if (bl) {
            serializable = psXmlNode.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
            serializable = psXmlNode.addChild("meta");
            object2 = PsConfig.getVersion(11);
            object = String.valueOf((int)object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf((int)object2[1]);
            if (object2[2] != false) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf((int)object2[2]);
            }
            ((PsXmlNode)serializable).addAttribute("dtd", (String)object);
            serializable = psXmlNode.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("date", new Date().toString());
            PsXmlNode psXmlNode2 = psXmlNode.addChild("version", pgJvxSrc.getVersion());
            psXmlNode2.addAttribute("type", pgJvxSrc.getVersionType());
            if (pgJvxSrc.getTitle() != null) {
                psXmlNode.addChild("title", pgJvxSrc.getTitle());
            } else {
                psXmlNode.addChild("title", pgJvxSrc.getName());
            }
        }
        if (bl2 && (serializable = pgJvxSrc.getAuthorInfo()) != null && ((PsAuthorInfo)serializable).getNumAuthors() > 0 && (object2 = ((PsAuthorInfo)serializable).getXmlNode()) != null) {
            psXmlNode.addChild((PsXmlNode)object2);
        }
        if (bl3 && (serializable = pgJvxSrc.getGeometryInfo()) != null && (object2 = ((PsGeometryInfo)serializable).getXmlNode()) != null) {
            psXmlNode.addChild((PsXmlNode)object2);
        }
        object2 = psXmlNode.addChild("geometries");
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                boolean bl8;
                PdVector[] pdVectorArray;
                PsXmlNode psXmlNode3;
                Object object3;
                Object object4;
                Object object5;
                Serializable serializable2;
                Serializable serializable3;
                PdVector[] pdVectorArray2;
                int n2;
                pgJvxSrc = pgJvxSrcArray[n];
                object = ((PsXmlNode)object2).addChild("geometry");
                ((PsXmlNode)object).addAttribute("name", pgJvxSrc.getName());
                if (!pgJvxSrc.isVisible()) {
                    ((PsXmlNode)object).addAttribute("visible", "hide");
                }
                if ((n2 = pgJvxSrc.getType()) == -1) {
                    PsDebug.error("geom = " + pgJvxSrc.getName() + " has unknown geometry type, JVX may not conform to jvx.dtd.");
                    n2 = 30;
                }
                if (n2 == 30 || n2 == 31 || n2 == 32 || n2 == 33) {
                    pdVectorArray2 = ((PsXmlNode)object).addChild("pointSet");
                    pdVectorArray2.addAttribute("dim", String.valueOf(pgJvxSrc.getDimOfVertices()));
                    if (pgJvxSrc.isShowingVertices()) {
                        pdVectorArray2.addAttribute("point", "show");
                    } else {
                        pdVectorArray2.addAttribute("point", "hide");
                    }
                    if (bl5 && pgJvxSrc.isShowingVertexColors() && pgJvxSrc.getVertexColors() != null) {
                        pdVectorArray2.addAttribute("color", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingVertexNormals() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray2.addAttribute("normal", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingVertexNormalArrow() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray2.addAttribute("normalArrow", "show");
                    }
                    if (pgJvxSrc.isShowingVertexSizes() && pgJvxSrc.getVertexSizes() != null) {
                        pdVectorArray2.addAttribute("thicknesses", "show");
                    }
                    if (!pgJvxSrc.isShowingTaggedVertices()) {
                        pdVectorArray2.addAttribute("pointMark", "hide");
                    }
                    if (!pgJvxSrc.isShowingVertexOutline()) {
                        pdVectorArray2.addAttribute("pointOutline", "hide");
                    }
                    serializable3 = pdVectorArray2.addChild("points");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable3, "p", pgJvxSrc.getVertices(), pgJvxSrc.getNumVertices());
                    ((PsXmlNode)serializable3).addChild("thickness", pgJvxSrc.getGlobalVertexSize());
                    if (pgJvxSrc.getGlobalVertexColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalVertexColor());
                    }
                    if (pgJvxSrc.getGlobalVertexTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalVertexTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingVertexLabels() || !pgJvxSrc.isEnabledIndexLabels()) {
                        serializable2 = pgJvxSrc.getLabelAttribute(0);
                        serializable2 = (PiVector)((PiVector)serializable2).clone();
                        ((PiVector)serializable2).setSize(8);
                        object5 = null;
                        if (serializable2 != null) {
                            ((PiVector)serializable2).setEntry(5, 1);
                            ((PiVector)serializable2).setEntry(6, (int)pgJvxSrc.getLabelSize(0));
                            ((PiVector)serializable2).setEntry(7, pgJvxSrc.getLabelStyle(0));
                            object5 = PgJvxLoader.fillLabelAttr((PiVector)serializable2, pgJvxSrc.getLabelFont(0));
                        } else {
                            object5 = PgJvxLoader.fillLabelAttr(true);
                        }
                        if (!pgJvxSrc.isEnabledIndexLabels()) {
                            ((PsXmlNode)object5).addAttribute("auto", "hide");
                        }
                        PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getLabelColor(0));
                        ((PsXmlNode)serializable3).addChild((PsXmlNode)object5);
                    }
                    if (bl5 && pgJvxSrc.getVertexColors() != null) {
                        serializable2 = pdVectorArray2.addChild("colors");
                        ((PsXmlNode)serializable2).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "c", pgJvxSrc.getVertexColors(), pgJvxSrc.getNumVertices());
                    }
                    if (bl4 && pgJvxSrc.getVertexNormals() != null) {
                        serializable2 = pdVectorArray2.addChild("normals");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "n", pgJvxSrc.getVertexNormals(), pgJvxSrc.getNumVertices());
                        ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalVertexNormalSize());
                        ((PsXmlNode)serializable2).addChild("length", pgJvxSrc.getGlobalVertexNormalLength());
                        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalVertexNormalColor());
                        }
                    }
                    if (bl6 && pgJvxSrc.getVertexTextures() != null) {
                        serializable2 = pdVectorArray2.addChild("textures");
                        ((PsXmlNode)serializable2).addAttribute("dim", String.valueOf(2));
                        if (pgJvxSrc.getBlendingMode() == 1) {
                            ((PsXmlNode)serializable2).addAttribute("blend", "material");
                        } else if (pgJvxSrc.getBlendingMode() == 2) {
                            ((PsXmlNode)serializable2).addAttribute("blend", "alpha");
                        }
                        if (pgJvxSrc.getFilterType() == 1) {
                            ((PsXmlNode)serializable2).addAttribute("filter", "linear");
                        } else if (pgJvxSrc.getFilterType() == 2) {
                            ((PsXmlNode)serializable2).addAttribute("filter", "quadratic");
                        }
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "t", pgJvxSrc.getVertexTextures(), pgJvxSrc.getNumVertices());
                        if (pgJvxSrc.getTextureImage() != null) {
                            object5 = ((PsXmlNode)serializable2).addChild("image");
                            ((PsXmlNode)object5).addAttribute("repeat", "no");
                            object4 = pgJvxSrc.getTextureImageName();
                            if (object4 == null) {
                                object4 = pgJvxSrc.getName() + "_texture.gif";
                            }
                            ((PsXmlNode)object5).addChild("url", (String)object4);
                            object3 = pgJvxSrc.getTextureImageBnd();
                            if (object3[0].getEntry(0) != 0.0 || ((PdVector)object3[0]).getEntry(1) != 0.0 || ((PdVector)object3[1]).getEntry(0) != 1.0 || ((PdVector)object3[1]).getEntry(1) != 1.0) {
                                psXmlNode3 = ((PsXmlNode)serializable2).addChild("imageCoords");
                                PsXmlLoader.addVectorList(psXmlNode3, "p", (PdVector[])object3, 2);
                            }
                        }
                    }
                    if (pgJvxSrc.getVertexSizes() != null) {
                        serializable2 = pdVectorArray2.addChild("thicknesses");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "th", pgJvxSrc.getVertexSizes(), pgJvxSrc.getNumVertices());
                    }
                }
                if (n2 == 31 || n2 == 32) {
                    pdVectorArray2 = ((PsXmlNode)object).addChild("lineSet");
                    if (pgJvxSrc.isShowingPolygons()) {
                        pdVectorArray2.addAttribute("line", "show");
                    } else {
                        pdVectorArray2.addAttribute("line", "hide");
                    }
                    if (pgJvxSrc.isShowingPolygonStartArrow()) {
                        pdVectorArray2.addAttribute("arrowStart", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonEndArrow()) {
                        pdVectorArray2.addAttribute("arrow", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingPolygonColors() && (pgJvxSrc.getPolygonColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                        pdVectorArray2.addAttribute("color", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                        pdVectorArray2.addAttribute("colorFromPoints", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                        pdVectorArray2.addAttribute("colorSmooth", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingPolygonNormals()) {
                        pdVectorArray2.addAttribute("normal", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingPolygonNormalArrow()) {
                        pdVectorArray2.addAttribute("normalArrow", "show");
                    }
                    if (!pgJvxSrc.isShowingTaggedPolygons()) {
                        pdVectorArray2.addAttribute("lineMark", "hide");
                    }
                    if (pgJvxSrc.isShowingPolygonSizes() && pgJvxSrc.getPolygonSizes() != null) {
                        pdVectorArray2.addAttribute("thicknesses", "show");
                    }
                    serializable3 = pdVectorArray2.addChild("lines");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable3, "l", pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
                    ((PsXmlNode)serializable3).addChild("thickness", pgJvxSrc.getGlobalPolygonSize());
                    if (pgJvxSrc.getGlobalPolygonColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalPolygonColor());
                    }
                    if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalPolygonTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingPolygonLabels()) {
                        serializable2 = pgJvxSrc.getLabelAttribute(2);
                        serializable2 = (PiVector)((PiVector)serializable2).clone();
                        ((PiVector)serializable2).setSize(8);
                        object5 = null;
                        if (serializable2 != null) {
                            ((PiVector)serializable2).setEntry(5, 1);
                            ((PiVector)serializable2).setEntry(6, (int)pgJvxSrc.getLabelSize(2));
                            ((PiVector)serializable2).setEntry(7, pgJvxSrc.getLabelStyle(2));
                            object5 = PgJvxLoader.fillLabelAttr((PiVector)serializable2, pgJvxSrc.getLabelFont(2));
                        } else {
                            object5 = PgJvxLoader.fillLabelAttr(true);
                        }
                        PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getLabelColor(2));
                        ((PsXmlNode)serializable3).addChild((PsXmlNode)object5);
                    }
                    if (bl5 && pgJvxSrc.getPolygonColors() != null) {
                        serializable2 = pdVectorArray2.addChild("colors");
                        ((PsXmlNode)serializable2).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "c", pgJvxSrc.getPolygonColors(), pgJvxSrc.getNumPolygons());
                    }
                    if (bl4 && pgJvxSrc.getPolygonNormals() != null) {
                        serializable2 = pdVectorArray2.addChild("normals");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "n", pgJvxSrc.getPolygonNormals(), pgJvxSrc.getNumPolygons());
                        ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalPolygonNormalSize());
                        ((PsXmlNode)serializable2).addChild("length", pgJvxSrc.getGlobalPolygonNormalLength());
                        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalPolygonNormalColor());
                        }
                    }
                    if (pgJvxSrc.getPolygonSizes() != null) {
                        serializable2 = pdVectorArray2.addChild("thicknesses");
                        PsXmlLoader.addVectorList((PsXmlNode)serializable2, "th", pgJvxSrc.getPolygonSizes(), pgJvxSrc.getNumPolygons());
                    }
                }
                if (n2 == 33) {
                    pdVectorArray2 = ((PsXmlNode)object).addChild("faceSet");
                    if (pgJvxSrc.isShowingEdges()) {
                        pdVectorArray2.addAttribute("edge", "show");
                    } else {
                        pdVectorArray2.addAttribute("edge", "hide");
                    }
                    if (pgJvxSrc.isShowingElements()) {
                        pdVectorArray2.addAttribute("face", "show");
                    } else {
                        pdVectorArray2.addAttribute("face", "hide");
                    }
                    if (bl5 && pgJvxSrc.isShowingElementColors() && (pgJvxSrc.getElementColors() != null || pgJvxSrc.isShowingElementFromVertexColors())) {
                        pdVectorArray2.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        pdVectorArray2.addAttribute("colorBackGlobal", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingElementBackColors() && pgJvxSrc.getElementBackColors() != null) {
                        pdVectorArray2.addAttribute("colorBackLocal", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingElementFromVertexColors()) {
                        pdVectorArray2.addAttribute("colorFromPoints", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingSmoothElementColors()) {
                        pdVectorArray2.addAttribute("colorSmooth", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingEdgeColors()) {
                        pdVectorArray2.addAttribute("colorEdge", "show");
                    }
                    if (bl5 && pgJvxSrc.isShowingEdgeColorFromElements()) {
                        pdVectorArray2.addAttribute("colorEdgeInduced", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingElementNormals() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray2.addAttribute("normal", "show");
                    }
                    if (bl4 && pgJvxSrc.isShowingElementNormalArrow() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray2.addAttribute("normalArrow", "show");
                    }
                    if (bl6 && (pgJvxSrc.isShowingVertexTexture() && pgJvxSrc.getVertexTextures() != null || pgJvxSrc.isShowingElementTexture() && pgJvxSrc.getElementTextures() != null)) {
                        pdVectorArray2.addAttribute("texture", "show");
                    }
                    if (!pgJvxSrc.isShowingBackface()) {
                        pdVectorArray2.addAttribute("backface", "hide");
                    }
                    if (pgJvxSrc.isShowingBoundaries()) {
                        pdVectorArray2.addAttribute("boundary", "show");
                    }
                    if (pgJvxSrc.isShowingSilhouette()) {
                        pdVectorArray2.addAttribute("silhouette", "show");
                    }
                    if (!pgJvxSrc.isShowingTaggedElements()) {
                        pdVectorArray2.addAttribute("faceMark", "hide");
                    }
                    serializable3 = pdVectorArray2.addChild("faces");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable3, "f", pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
                    if (pgJvxSrc.getGlobalElementColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "color", pgJvxSrc.getGlobalElementColor());
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "colorBack", pgJvxSrc.getGlobalElementBackColor());
                    }
                    if (pgJvxSrc.getGlobalElementTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable3, "colorTag", pgJvxSrc.getGlobalElementTagColor());
                    }
                    double d = pgJvxSrc.getCreaseAngle();
                    ((PsXmlNode)serializable3).addChild("creaseAngle", d);
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingElementLabels()) {
                        object4 = pgJvxSrc.getLabelAttribute(3);
                        object4 = (PiVector)((PiVector)object4).clone();
                        ((PiVector)object4).setSize(8);
                        object3 = null;
                        if (object4 != null) {
                            ((PiVector)object4).setEntry(5, 1);
                            ((PiVector)object4).setEntry(6, (int)pgJvxSrc.getLabelSize(3));
                            ((PiVector)object4).setEntry(7, pgJvxSrc.getLabelStyle(3));
                            object3 = PgJvxLoader.fillLabelAttr((PiVector)object4, pgJvxSrc.getLabelFont(3));
                        } else {
                            object3 = PgJvxLoader.fillLabelAttr(true);
                        }
                        PsXmlLoader.addColor((PsXmlNode)object3, "color", pgJvxSrc.getLabelColor(3));
                        ((PsXmlNode)serializable3).addChild((PsXmlNode)object3);
                    }
                    if (pgJvxSrc.getNeighbours() != null) {
                        object4 = pdVectorArray2.addChild("neighbours");
                        PsXmlLoader.addVectorList((PsXmlNode)object4, "nb", pgJvxSrc.getNeighbours(), pgJvxSrc.getNumElements());
                    }
                    object4 = pdVectorArray2.addChild("edges");
                    if (pgJvxSrc.getNumEdges() > 0) {
                        PsXmlLoader.addVectorList((PsXmlNode)object4, "e", pgJvxSrc.getEdges(), pgJvxSrc.getNumEdges());
                    }
                    ((PsXmlNode)object4).addChild("thickness", pgJvxSrc.getGlobalEdgeSize());
                    if (pgJvxSrc.getGlobalEdgeColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)object4, "color", pgJvxSrc.getGlobalEdgeColor());
                    }
                    if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)object4, "colorTag", pgJvxSrc.getGlobalEdgeTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingEdgeLabels()) {
                        object3 = pgJvxSrc.getLabelAttribute(1);
                        object3 = (PiVector)((PiVector)object3).clone();
                        ((PiVector)object3).setSize(8);
                        psXmlNode3 = null;
                        if (object3 != null) {
                            ((PiVector)object3).setEntry(5, 1);
                            ((PiVector)object3).setEntry(6, (int)pgJvxSrc.getLabelSize(1));
                            ((PiVector)object3).setEntry(7, pgJvxSrc.getLabelStyle(1));
                            psXmlNode3 = PgJvxLoader.fillLabelAttr((PiVector)object3, pgJvxSrc.getLabelFont(1));
                        } else {
                            psXmlNode3 = PgJvxLoader.fillLabelAttr(true);
                        }
                        PsXmlLoader.addColor(psXmlNode3, "color", pgJvxSrc.getLabelColor(1));
                        ((PsXmlNode)object4).addChild(psXmlNode3);
                    }
                    if (bl5 && pgJvxSrc.getElementColors() != null) {
                        object3 = pdVectorArray2.addChild("colors");
                        ((PsXmlNode)object3).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)object3, "c", pgJvxSrc.getElementColors(), pgJvxSrc.getNumElements());
                    }
                    if (bl5 && pgJvxSrc.getElementBackColors() != null) {
                        object3 = pdVectorArray2.addChild("colorsBack");
                        ((PsXmlNode)object3).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)object3, "c", pgJvxSrc.getElementBackColors(), pgJvxSrc.getNumElements());
                    }
                    if (bl4 && pgJvxSrc.getElementNormals() != null) {
                        object3 = pdVectorArray2.addChild("normals");
                        PsXmlLoader.addVectorList((PsXmlNode)object3, "n", pgJvxSrc.getElementNormals(), pgJvxSrc.getNumElements());
                        ((PsXmlNode)object3).addChild("thickness", pgJvxSrc.getGlobalElementNormalSize());
                        ((PsXmlNode)object3).addChild("length", pgJvxSrc.getGlobalElementNormalLength());
                        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object3, "color", pgJvxSrc.getGlobalElementNormalColor());
                        }
                    }
                    if (bl6 && pgJvxSrc.getElementTextures() != null) {
                        object3 = pdVectorArray2.addChild("textures");
                        ((PsXmlNode)object3).addAttribute("dim", String.valueOf(2));
                        if (pgJvxSrc.getBlendingMode() == 1) {
                            ((PsXmlNode)object3).addAttribute("blend", "material");
                        } else if (pgJvxSrc.getBlendingMode() == 2) {
                            ((PsXmlNode)object3).addAttribute("blend", "alpha");
                        }
                        if (pgJvxSrc.getFilterType() == 1) {
                            ((PsXmlNode)object3).addAttribute("filter", "linear");
                        } else if (pgJvxSrc.getFilterType() == 2) {
                            ((PsXmlNode)object3).addAttribute("filter", "quadratic");
                        }
                        PsXmlLoader.addVectorList((PsXmlNode)object3, "t", pgJvxSrc.getElementTextures(), pgJvxSrc.getNumElements());
                        if (pgJvxSrc.getTextureImage() != null) {
                            psXmlNode3 = ((PsXmlNode)object3).addChild("image");
                            psXmlNode3.addAttribute("repeat", "no");
                            String string = pgJvxSrc.getTextureImageName();
                            if (string == null) {
                                string = pgJvxSrc.getName() + "_texture.gif";
                            }
                            psXmlNode3.addChild("url", string);
                            pdVectorArray = pgJvxSrc.getTextureImageBnd();
                            if (pdVectorArray[0].getEntry(0) != 0.0 || pdVectorArray[0].getEntry(1) != 0.0 || pdVectorArray[1].getEntry(0) != 1.0 || pdVectorArray[1].getEntry(1) != 1.0) {
                                PsXmlNode psXmlNode4 = ((PsXmlNode)object3).addChild("imageCoords");
                                PsXmlLoader.addVectorList(psXmlNode4, "p", pdVectorArray, 2);
                            }
                        }
                    }
                    if (pgJvxSrc.isShowingBoundaries() || pgJvxSrc.isShowingSilhouette()) {
                        object3 = pdVectorArray2.addChild("boundaries");
                        ((PsXmlNode)object3).addChild("thickness", pgJvxSrc.getGlobalBndSize());
                        if (pgJvxSrc.getGlobalBndColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object3, "color", pgJvxSrc.getGlobalBndColor());
                        }
                        if (pgJvxSrc.getGlobalBndTagColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object3, "colorTag", pgJvxSrc.getGlobalBndTagColor());
                        }
                    }
                }
                if (bl7 && pgJvxSrc.getNumVectorFields() != 0) {
                    int n3 = pgJvxSrc.getNumVectorFields();
                    int n4 = 0;
                    while (n4 < n3) {
                        PsXmlNode psXmlNode5 = ((PsXmlNode)object).addChild("vectorField");
                        if (pgJvxSrc.getVectorFieldName(n4) != null) {
                            psXmlNode5.addAttribute("name", pgJvxSrc.getVectorFieldName(n4));
                        }
                        if (!pgJvxSrc.isShowingVectorFields() || !pgJvxSrc.isShowingVectorField(n4)) {
                            psXmlNode5.addAttribute("vector", "hide");
                        }
                        if (!pgJvxSrc.isShowingIndividualMaterial(n4)) {
                            psXmlNode5.addAttribute("material", "hide");
                        }
                        if (pgJvxSrc.isShowingVectorArrows(n4)) {
                            psXmlNode5.addAttribute("arrow", "show");
                        }
                        if (pgJvxSrc.isShowingVectorColors(n4)) {
                            psXmlNode5.addAttribute("color", "show");
                        }
                        if (pgJvxSrc.isVectorElementBased(n4)) {
                            psXmlNode5.addAttribute("base", "element");
                        } else {
                            psXmlNode5.addAttribute("base", "vertex");
                        }
                        object5 = pgJvxSrc.getVectors(n4);
                        if (object5 == null || ((PdVector[])object5).length == 0) {
                            PsDebug.warning("missing vectors of vector field[" + n4 + "]");
                        } else {
                            object4 = psXmlNode5.addChild("vectors");
                            PsXmlLoader.addVectorList((PsXmlNode)object4, "v", (PdVector[])object5, ((Object)object5).length);
                            ((PsXmlNode)object4).addChild("thickness", pgJvxSrc.getGlobalVectorSize(n4));
                            ((PsXmlNode)object4).addChild("length", pgJvxSrc.getGlobalVectorLength(n4));
                            if (pgJvxSrc.getGlobalVectorColor(n4) != null) {
                                PsXmlLoader.addColor((PsXmlNode)object4, "color", pgJvxSrc.getGlobalVectorColor(n4));
                            }
                            if (pgJvxSrc.getVectorFieldColors(n4) != null) {
                                object3 = psXmlNode5.addChild("colors");
                                ((PsXmlNode)object3).addAttribute("type", "rgb");
                                PsXmlLoader.addVectorList((PsXmlNode)object3, "c", pgJvxSrc.getVectorFieldColors(n4), ((Object)object5).length);
                            }
                        }
                        ++n4;
                    }
                }
                if ((pdVectorArray2 = pgJvxSrc.getBounds()) != null && pdVectorArray2.length == 2) {
                    PsXmlNode psXmlNode6 = ((PsXmlNode)object).addChild("bndbox");
                    if (pgJvxSrc.isShowingBndBox()) {
                        psXmlNode6.addAttribute("visible", "show");
                    } else {
                        psXmlNode6.addAttribute("visible", "hide");
                    }
                    psXmlNode6.addChild("p", PuString.toString(pdVectorArray2[0].getEntries()));
                    psXmlNode6.addChild("p", PuString.toString(pdVectorArray2[1].getEntries()));
                }
                if ((serializable3 = pgJvxSrc.getCenter()) != null) {
                    PsXmlNode psXmlNode7 = ((PsXmlNode)object).addChild("center");
                    if (pgJvxSrc.isShowingCenter()) {
                        psXmlNode7.addAttribute("visible", "show");
                    } else {
                        psXmlNode7.addAttribute("visible", "hide");
                    }
                    psXmlNode7.addChild("p", PuString.toString(((PdVector)serializable3).getEntries()));
                }
                if (pgJvxSrc.isShowingName()) {
                    PiVector piVector = pgJvxSrc.getLabelAttribute(5);
                    piVector = (PiVector)piVector.clone();
                    piVector.setSize(8);
                    object5 = null;
                    if (piVector != null) {
                        piVector.setEntry(5, 1);
                        piVector.setEntry(6, (int)pgJvxSrc.getLabelSize(5));
                        piVector.setEntry(7, pgJvxSrc.getLabelStyle(5));
                        object5 = PgJvxLoader.fillLabelAttr(piVector, pgJvxSrc.getLabelFont(5));
                    } else {
                        object5 = PgJvxLoader.fillLabelAttr(true);
                    }
                    PsXmlLoader.addColor((PsXmlNode)object5, "color", pgJvxSrc.getLabelColor(5));
                    ((PsXmlNode)object).addChild((PsXmlNode)object5);
                }
                if (pgJvxSrc.isShowingTransparency() || pgJvxSrc.isShowingSmoothLighting()) {
                    PsXmlNode psXmlNode8 = ((PsXmlNode)object).addChild("material");
                    if (pgJvxSrc.isShowingSmoothLighting()) {
                        psXmlNode8.addAttribute("shading", "gouraud");
                    }
                    psXmlNode8.addChild("ambientIntensity", 0.2);
                    PsXmlLoader.addColor(psXmlNode8, "diffuse", "color", new Color(0.8f, 0.8f, 0.8f));
                    PsXmlLoader.addColor(psXmlNode8, "emissive", "color", Color.black);
                    psXmlNode8.addChild("shininess", pgJvxSrc.getShininess());
                    PsXmlLoader.addColor(psXmlNode8, "specular", "color", pgJvxSrc.getSpecularColor());
                    object5 = psXmlNode8.addChild("transparency", pgJvxSrc.getTransparency());
                    if (pgJvxSrc.isShowingTransparency()) {
                        ((PsXmlNode)object5).addAttribute("visible", "show");
                    }
                }
                boolean bl9 = pgJvxSrc.hasModelMatrix();
                boolean bl10 = bl8 = pgJvxSrc.hasAmbientMatrix() || pgJvxSrc.getAmbientSpace() != 1 && pgJvxSrc.getAmbientSpace() != 3;
                if (bl9 || bl8) {
                    object4 = ((PsXmlNode)object).addChild("transform");
                    if (bl9) {
                        PsXmlLoader.addMatrix((PsXmlNode)object4, "modelMat", pgJvxSrc.getModelMatrix());
                    }
                    if (bl8) {
                        int n5 = pgJvxSrc.getAmbientSpace();
                        int n6 = pgJvxSrc.getAmbientProjection();
                        int n7 = pgJvxSrc.getDimOfVertices();
                        pdVectorArray = ((PsXmlNode)object4).addChild("ambient");
                        pdVectorArray.addAttribute("dim", String.valueOf(n7));
                        if (n5 == 0 | n5 == 1 | n5 == 3 | n5 == 6 | n5 == 9) {
                            pdVectorArray.addAttribute("space", "euclidean");
                        } else if (n5 == 2 | n5 == 4 | n5 == 7 | n5 == 10) {
                            pdVectorArray.addAttribute("space", "spherical");
                        } else if (n5 == 5 | n5 == 8 | n5 == 11) {
                            pdVectorArray.addAttribute("space", "hyperbolic");
                        } else {
                            PsDebug.warning("unknown ambient space = " + n5);
                            return null;
                        }
                        if (n6 == 0) {
                            pdVectorArray.addAttribute("projection", "parallel");
                        } else if (n6 == 1) {
                            pdVectorArray.addAttribute("projection", "stereographic");
                        } else if (n6 == 1) {
                            pdVectorArray.addAttribute("projection", "poincare");
                        } else if (n6 == 2) {
                            pdVectorArray.addAttribute("projection", "klein");
                        } else if (n6 == 3) {
                            pdVectorArray.addAttribute("projection", "uhs");
                        } else if (n6 == 2) {
                            pdVectorArray.addAttribute("projection", "klein");
                        } else {
                            PsDebug.warning("unknown ambient projection = " + n6);
                            return null;
                        }
                        PsXmlLoader.addMatrix((PsXmlNode)pdVectorArray, "ambientMat", pgJvxSrc.getAmbientMatrix());
                        PsXmlLoader.addMatrix((PsXmlNode)pdVectorArray, "ambientInvMat", pgJvxSrc.getAmbientInvMatrix());
                    }
                }
                ++n;
            }
        }
        return psXmlSrc;
    }

    protected static String fillVisibility(boolean bl) {
        if (bl) {
            return "show";
        }
        return "hide";
    }
}

