/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PgFileDialog
extends FileDialog {
    protected String m_ext = null;

    public PgFileDialog(Frame frame, String string, int n) {
        super(frame, string, n);
        this.setDirectory(PsConfig.getCodeBase());
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.hide();
            return;
        }
        this.show();
    }

    public boolean isFileSelected() {
        return this.getDirectory() != null && this.getFile() != null;
    }

    public void show() {
        if (this.getFile() == null) {
            if (this.m_ext != null) {
                super.setFile("*." + this.m_ext);
            } else {
                super.setFile("*.*");
            }
        }
        super.show();
    }

    public String getFullFileName() {
        String string = this.getFile();
        if (string == null) {
            return null;
        }
        String string2 = this.getDirectory();
        if (string2 == null) {
            return null;
        }
        String string3 = string2 + string;
        return string3.trim();
    }

    public void setExtension(String string) {
        this.m_ext = string;
    }

    public File openFile() {
        if (this.getDirectory() == null || this.getFile() == null) {
            PsDebug.warning("missing dir or file name");
            return null;
        }
        File file = null;
        file = PsConfig.isApplication() ? new File(this.getDirectory() + this.getFile()) : new File(this.getFile());
        if (file == null) {
            PsDebug.warning("could not open file = " + this.getFile() + " in directory = " + this.getDirectory());
        }
        return file;
    }
}

