/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PuCleanMesh {
    private static void identifyVerticesPolygonSet(PgPolygonSet pgPolygonSet, int[] nArray) {
        int n = pgPolygonSet.getNumPolygons();
        int n2 = 0;
        while (n2 < n) {
            PiVector piVector = pgPolygonSet.getPolygon(n2);
            int n3 = piVector.getSize();
            piVector.m_data[0] = nArray[piVector.m_data[0]];
            int n4 = 1;
            int n5 = 1;
            while (n5 < n3) {
                if (nArray[piVector.m_data[n5]] != nArray[piVector.m_data[n5 - 1]]) {
                    piVector.m_data[n4] = nArray[piVector.m_data[n5]];
                    ++n4;
                }
                ++n5;
            }
            piVector.setSize(n4);
            if (n4 == 1) {
                piVector.setTag(2);
            }
            ++n2;
        }
        pgPolygonSet.removeMarkedPolygons();
        pgPolygonSet.removeUnusedVertices();
    }

    private static void identifyVerticesPointSet(PgPointSet pgPointSet, int[] nArray) {
        int n = pgPointSet.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != n2) {
                pgPointSet.setTagVertex(n2, 2);
            } else {
                pgPointSet.clearTagVertex(nArray[n2], 2);
            }
            ++n2;
        }
        pgPointSet.removeMarkedVertices();
    }

    public static int identifyVertices(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning("Geometry not instance of PgPointSet, name = " + pgGeometry.getClass());
            return 0;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        int n = PuCleanMesh.identifyVertices(pgPointSet, 0.0);
        if (n > 0 && pgPointSet.hasVertexNormals()) {
            switch (pgGeometry.getType()) {
                case 33: {
                    ((PgElementSet)pgGeometry).makeVertexNormals();
                    break;
                }
                case 31: {
                    ((PgPolygon)pgGeometry).makeVertexNormals();
                    break;
                }
                case 32: {
                    ((PgPolygonSet)pgGeometry).makeVertexNormals();
                }
            }
        }
        return n;
    }

    public static int identifyVertices(PgPointSet pgPointSet, double d) {
        return PuCleanMesh.identifyVertices(pgPointSet, d, false);
    }

    public static int identifyVertices(PgPointSet pgPointSet, double d, boolean bl) {
        PgElementSet pgElementSet;
        if (pgPointSet == null) {
            return 0;
        }
        int n = pgPointSet.getNumVertices();
        if (n < 2) {
            return 0;
        }
        int n2 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        boolean bl2 = pgPointSet.hasVertexNormals();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        PdVector[] pdVectorArray2 = pgPointSet.getBounds();
        PdVector pdVector = PdVector.subNew(pdVectorArray2[1], pdVectorArray2[0]);
        if (pdVector.getSize() != n2) {
            pdVector.setSize(n2);
        }
        pdVector.setLength(1.0);
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = n3;
            dArray[n3] = PdVector.dot(pdVector, pdVectorArray[n3]);
            ++n3;
        }
        PuMath.heapsort(n, dArray, nArray2);
        boolean bl3 = false;
        if (pgPointSet.getType() == 33 && (bl3 = (pgElementSet = (PgElementSet)pgPointSet).hasBoundary())) {
            pgElementSet.markBoundary();
        }
        boolean bl4 = false;
        boolean bl5 = false;
        n3 = 0;
        while (n3 < n) {
            if (nArray[nArray2[n3]] == nArray2[n3] && (!bl || pdVectorArray[nArray2[n3]].hasTag(1))) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    if (dArray[nArray2[n4]] > dArray[nArray2[n3]] + d) break;
                    if (!(bl && !pdVectorArray[nArray2[n4]].hasTag(1) || bl4 && pdVectorArray[nArray2[n4]].hasTag(14))) {
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < n2) {
                            if (Math.abs(pdVectorArray[nArray2[n3]].m_data[n6] - pdVectorArray[nArray2[n4]].m_data[n6]) > d) break;
                            ++n5;
                            ++n6;
                        }
                        if (n5 == n2) {
                            nArray[nArray2[n4]] = nArray2[n3];
                            if (!bl5) {
                                bl5 = true;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (!bl5) {
            return 0;
        }
        switch (pgPointSet.getType()) {
            case 30: {
                PuCleanMesh.identifyVerticesPointSet(pgPointSet, nArray);
                break;
            }
            case 33: {
                PuCleanMesh.identifyVerticesElementSet((PgElementSet)pgPointSet, nArray);
                break;
            }
            case 31: {
                PuCleanMesh.identifyVerticesPolygon((PgPolygon)pgPointSet, nArray);
                break;
            }
            case 32: {
                PuCleanMesh.identifyVerticesPolygonSet((PgPolygonSet)pgPointSet, nArray);
                break;
            }
            default: {
                PuCleanMesh.identifyVerticesPointSet(pgPointSet, nArray);
            }
        }
        if (bl2) {
            pgPointSet.makeVertexNormals();
        }
        return n - pgPointSet.getNumVertices();
    }

    private static void identifyVerticesElementSet(PgElementSet pgElementSet, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = pgElementSet.getNumVertices();
        int n7 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n8 = 0;
        while (n8 < n7) {
            n5 = piVectorArray[n8].getSize();
            int n9 = 0;
            while (n9 < n5) {
                piVectorArray[n8].m_data[n9] = nArray[piVectorArray[n8].m_data[n9]];
                ++n9;
            }
            ++n8;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            n5 = 0;
            while (n5 < pgBndPolygonArray.length) {
                if (!pgBndPolygonArray[n5].hasTag(2)) {
                    PiVector piVector = pgBndPolygonArray[n5].getVertexInd();
                    n4 = pgBndPolygonArray[n5].getNumVertices();
                    boolean bl = true;
                    n3 = 0;
                    while (n3 < n4) {
                        if (piVector.m_data[n3] == -1 || piVector.m_data[n3] >= n6) {
                            pgBndPolygonArray[n5].setTag(2);
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl) {
                        n3 = 0;
                        while (n3 < n4) {
                            piVector.m_data[n3] = nArray[piVector.m_data[n3]];
                            ++n3;
                        }
                        pgBndPolygonArray[n5].assignVertices();
                    }
                }
                ++n5;
            }
            pgElementSet.removeDeletedBoundaries();
        }
        PuCleanMesh.removeDegenerateElements(pgElementSet);
        pgElementSet.removeUnusedVertices();
        n7 = pgElementSet.getNumElements();
        n6 = pgElementSet.getNumVertices();
        piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        Vector[] vectorArray = new Vector[n6];
        int n10 = 0;
        while (n10 < n7) {
            PiVector piVector = piVectorArray[n10];
            PiVector piVector2 = piVectorArray2[n10];
            n3 = piVector.getSize();
            n2 = 0;
            while (n2 < n3) {
                if (piVector2.m_data[n2] == -1) {
                    int n11;
                    if (piVector.m_data[(n2 + 1) % n3] < piVector.m_data[(n2 + 2) % n3]) {
                        n = piVector.m_data[(n2 + 1) % n3];
                        n11 = piVector.m_data[(n2 + 2) % n3];
                    } else {
                        n11 = piVector.m_data[(n2 + 1) % n3];
                        n = piVector.m_data[(n2 + 2) % n3];
                    }
                    if (vectorArray[n] == null || vectorArray[n].size() == 0) {
                        vectorArray[n] = new Vector();
                    }
                    vectorArray[n].addElement(new PiVector(n11, n10, n2));
                }
                ++n2;
            }
            ++n10;
        }
        n10 = 0;
        while (n10 < n6) {
            if (vectorArray[n10] != null && (n4 = vectorArray[n10].size()) > 1) {
                boolean[] blArray = new boolean[n4];
                n3 = 0;
                while (n3 < n4) {
                    blArray[n3] = false;
                    ++n3;
                }
                n3 = 0;
                while (n3 < n4) {
                    if (!blArray[n3]) {
                        n2 = -1;
                        blArray[n3] = true;
                        n = ((PiVector)vectorArray[n10].elementAt((int)n3)).m_data[0];
                        int n12 = n3 + 1;
                        while (n12 < n4) {
                            if (n == ((PiVector)vectorArray[n10].elementAt((int)n12)).m_data[0]) {
                                blArray[n12] = true;
                                n2 = n2 == -1 ? n12 : -2;
                            }
                            ++n12;
                        }
                        if (n2 > -1) {
                            PiVector piVector = (PiVector)vectorArray[n10].elementAt(n3);
                            PiVector piVector3 = (PiVector)vectorArray[n10].elementAt(n2);
                            piVectorArray2[piVector.m_data[1]].m_data[piVector.m_data[2]] = piVector3.m_data[1];
                            piVectorArray2[piVector3.m_data[1]].m_data[piVector3.m_data[2]] = piVector.m_data[1];
                        }
                    }
                    ++n3;
                }
            }
            ++n10;
        }
    }

    public static void removeDegenerateElements(PgElementSet pgElementSet) {
        int n;
        int n2;
        PiVector piVector;
        PiVector piVector2;
        if (pgElementSet == null) {
            return;
        }
        int n3 = pgElementSet.getNumElements();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            piVector2 = pgElementSet.getElement(n4);
            piVector = pgElementSet.getNeighbour(n4);
            int n6 = n5 = piVector2.getSize();
            while (n6 > 1 && piVector2.m_data[n6 - 1] == piVector2.m_data[0]) {
                --n6;
            }
            if (n6 != n5) {
                bl = true;
                piVector2.setSize(n6);
                piVector.m_data[n6 - 1] = piVector.m_data[n5 - 1];
                piVector.setSize(n6);
            }
            if (n6 < 3) {
                piVector2.setTag(2);
                bl = true;
            } else {
                int n7;
                n2 = 0;
                n = 0;
                block2: while (n < n6 - 1) {
                    n7 = n + 1;
                    while (n7 < n6) {
                        if (piVector2.m_data[n] == piVector2.m_data[n7]) {
                            n2 = 1;
                            break block2;
                        }
                        ++n7;
                    }
                    ++n;
                }
                if (n2 != 0) {
                    n = piVector2.m_data[0];
                    n7 = 1;
                    int n8 = -1;
                    int n9 = 1;
                    while (n9 < n6) {
                        if (piVector2.m_data[n9] != n) {
                            piVector2.m_data[n7] = piVector2.m_data[n9];
                            if (n7 == 1) {
                                n8 = n9 == 1 ? piVector.m_data[n6 - 1] : piVector.m_data[n9 - 2];
                            } else {
                                piVector.m_data[n7 - 2] = piVector.m_data[n9 - 2];
                            }
                            ++n7;
                        } else {
                            bl = true;
                        }
                        n = piVector2.m_data[n9];
                        ++n9;
                    }
                    piVector.m_data[n7 - 2] = piVector.m_data[n6 - 2];
                    piVector.m_data[n7 - 1] = n8;
                    piVector2.setSize(n7);
                    piVector.setSize(n7);
                    n9 = 0;
                    while (n9 != -1) {
                        int n10;
                        n9 = -1;
                        int n11 = -1;
                        int n12 = 0;
                        while (n12 < n7 - 1) {
                            n10 = n12 + 1;
                            while (n10 < n7) {
                                if (piVector2.m_data[n12] == piVector2.m_data[n10]) {
                                    n9 = n12;
                                    n11 = n10;
                                    break;
                                }
                                ++n10;
                            }
                            if (n9 != -1) break;
                            ++n12;
                        }
                        if (n9 == -1) continue;
                        bl = true;
                        n12 = n11 - n9;
                        n10 = n7 + n9 - n11;
                        PiVector piVector3 = new PiVector(n12);
                        PiVector piVector4 = new PiVector(n10);
                        int n13 = 0;
                        while (n13 < n12) {
                            piVector3.m_data[n13] = piVector2.m_data[(n13 + n9) % n7];
                            ++n13;
                        }
                        n13 = 0;
                        while (n13 < n10) {
                            piVector4.m_data[n13] = piVector2.m_data[(n13 + n11) % n7];
                            ++n13;
                        }
                        PiVector piVector5 = new PiVector(n12);
                        PiVector piVector6 = new PiVector(n10);
                        int n14 = 0;
                        while (n14 < n12) {
                            piVector5.m_data[(n14 + n12 - 1) % n12] = piVector.m_data[(n14 + n9 + n7 - 1) % n7];
                            ++n14;
                        }
                        n14 = 0;
                        while (n14 < n10) {
                            piVector6.m_data[(n14 + n10 - 1) % n10] = piVector.m_data[(n14 + n11 + n7 - 1) % n7];
                            ++n14;
                        }
                        pgElementSet.setNumElements(n3 + 1);
                        PiVector piVector7 = pgElementSet.getElement(n3);
                        piVector7.setSize(n10);
                        piVector7.copy(piVector4);
                        PiVector piVector8 = pgElementSet.getNeighbour(n3);
                        piVector8.setSize(n10);
                        piVector8.copy(piVector6);
                        int n15 = 0;
                        while (n15 < n10) {
                            if (piVector.m_data[(n15 + n11 - 1 + n7) % n7] != -1) {
                                int n16;
                                PiVector piVector9;
                                PiVector piVector10 = pgElementSet.getNeighbour(piVector.m_data[(n15 + n11 - 1 + n7) % n7]);
                                int n17 = pgElementSet.getOppVertexLocInd(n4, (n15 + n11 - 1 + n7) % n7);
                                if (!(piVector2.m_data[(n15 + n11) % n7] == piVector9.m_data[(n17 + 1) % (n16 = (piVector9 = pgElementSet.getElement(piVector.m_data[(n15 + n11 - 1 + n7) % n7])).getSize())] && piVector2.m_data[(n15 + n11 + 1) % n7] == piVector9.m_data[(n17 + 2) % n16] || piVector2.m_data[(n15 + n11) % n7] == piVector9.m_data[(n17 + 2) % n16] && piVector2.m_data[(n15 + n11 + 1) % n7] == piVector9.m_data[(n17 + 1) % n16])) {
                                    n17 = 0;
                                    while (n17 < n16) {
                                        if (piVector2.m_data[(n15 + n11) % n7] == piVector9.m_data[(n17 + 1) % n16] && piVector2.m_data[(n15 + n11 + 1) % n7] == piVector9.m_data[(n17 + 2) % n16] || piVector2.m_data[(n15 + n11) % n7] == piVector9.m_data[(n17 + 2) % n16] && piVector2.m_data[(n15 + n11 + 1) % n7] == piVector9.m_data[(n17 + 1) % n16]) break;
                                        ++n17;
                                    }
                                }
                                piVector10.m_data[n17] = n3;
                            }
                            ++n15;
                        }
                        ++n3;
                        piVector2.setSize(n12);
                        piVector.setSize(n12);
                        piVector2.copy(piVector3);
                        piVector.copy(piVector5);
                        n7 = n11 - n9;
                    }
                    if (n7 < 3) {
                        piVector2.setTag(2);
                    }
                }
            }
            ++n4;
        }
        if (!bl) {
            return;
        }
        n4 = 0;
        while (n4 < n3) {
            if (pgElementSet.hasTagElement(n4, 2) && (piVector2 = pgElementSet.getElement(n4)).getSize() == 2) {
                piVector = pgElementSet.getNeighbour(n4);
                if (piVector.m_data[0] == -1) {
                    if (piVector.m_data[1] != -1) {
                        PiVector piVector11 = pgElementSet.getNeighbour(piVector.m_data[1]);
                        int n18 = pgElementSet.getOppVertexLocInd(n4, 1);
                        piVector11.m_data[n18] = -1;
                    }
                } else if (piVector.m_data[1] == -1) {
                    PiVector piVector12 = pgElementSet.getNeighbour(piVector.m_data[0]);
                    int n19 = pgElementSet.getOppVertexLocInd(n4, 0);
                    piVector12.m_data[n19] = -1;
                } else {
                    PiVector piVector13 = pgElementSet.getNeighbour(piVector.m_data[0]);
                    PiVector piVector14 = pgElementSet.getNeighbour(piVector.m_data[1]);
                    n2 = pgElementSet.getOppVertexLocInd(n4, 0);
                    n = pgElementSet.getOppVertexLocInd(n4, 1);
                    piVector13.m_data[n2] = piVector.m_data[1];
                    piVector14.m_data[n] = piVector.m_data[0];
                }
            }
            ++n4;
        }
        pgElementSet.setDimOfElements(-1);
        pgElementSet.removeMarkedElements();
        pgElementSet.assureDimOfElements();
    }

    private static void identifyVerticesPolygon(PgPolygon pgPolygon, int[] nArray) {
        int n = pgPolygon.getNumVertices();
        int n2 = 1;
        while (n2 < n) {
            pgPolygon.setTagVertex(n2, 2);
            ++n2;
        }
        if (nArray[0] != 0) {
            pgPolygon.setVertex(0, pgPolygon.getVertex(nArray[0]));
        }
        n2 = 1;
        while (n2 < n) {
            if (nArray[n2] != nArray[n2 - 1]) {
                if (nArray[n2] != n2) {
                    pgPolygon.setVertex(n2, pgPolygon.getVertex(nArray[n2]));
                }
                pgPolygon.clearTagVertex(n2, 2);
            }
            ++n2;
        }
        pgPolygon.removeMarkedVertices();
    }
}

