/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgVectorField
extends PgGeometry {
    protected PgPointSet m_basePoints;
    protected PgElementSet m_surface;
    public static final int VERTEX_BASED = 0;
    public static final int ELEMENT_BASED = 1;
    protected int m_basedOn;
    protected int m_dimOfVectors;
    protected int m_numVectors;
    protected int m_maxNumVectors;
    protected PdVector[] m_vector;
    protected Color[] m_vectorColor;
    protected boolean m_bShowVectorArrow;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors;
    protected boolean m_bShowIndividualMaterial;
    protected int m_index;
    private static /* synthetic */ Class class$jv$geom$PgVectorField;

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public void setBasedOn(int n) {
        if (this.m_basedOn == n) {
            return;
        }
        this.m_basedOn = n;
        if (this.m_surface != null) {
            if (this.m_basedOn == 1) {
                this.setNumVectors(this.m_surface.getNumElements());
                return;
            }
            this.setNumVectors(this.m_surface.getNumVertices());
        }
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double d) {
        this.m_globalVectorSize.setValue(d);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgVectorField)) {
            return false;
        }
        PgVectorField pgVectorField = (PgVectorField)pgGeometryIf;
        int n = this.m_numVectors;
        int n2 = this.m_numVectors + pgVectorField.m_numVectors;
        this.setNumVectors(n2);
        PdVector.copy(this.m_vector, n, pgVectorField.m_vector, 0, pgVectorField.m_numVectors);
        if (pgVectorField.m_vectorColor != null) {
            this.assureVectorColors();
            PdColor.copy(this.m_vectorColor, n, pgVectorField.m_vectorColor, 0, pgVectorField.m_numVectors);
        }
        return true;
    }

    public boolean computeGradient(PgElementSet pgElementSet, PgPointSet pgPointSet) {
        return this.computeGradient(pgElementSet, null, pgPointSet.getVertices(), 0);
    }

    public boolean computeGradient(PgElementSet pgElementSet, PgPointSet pgPointSet, int n) {
        return this.computeGradient(pgElementSet, null, pgPointSet.getVertices(), n);
    }

    public boolean computeGradient(PgElementSet pgElementSet, PdVector[] pdVectorArray, int n) {
        return this.computeGradient(pgElementSet, null, pdVectorArray, n);
    }

    public boolean computeGradient(PgElementSet pgElementSet, PdVector pdVector) {
        return this.computeGradient(pgElementSet, pdVector, null, 0);
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double d) {
        this.m_globalVectorLength.setValue(d);
    }

    private boolean computeGradient(PgElementSet pgElementSet, PdVector pdVector, PdVector[] pdVectorArray, int n) {
        boolean bl;
        boolean bl2 = bl = pdVector != null;
        if (pgElementSet == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_dim != pgElementSet.getDimOfVertices()) {
            PsDebug.warning("domain and vf have different dimension.");
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate(pgElementSet);
        }
        int n2 = pgElementSet.getNumVertices();
        if (!bl) {
            if (pdVectorArray == null) {
                PsDebug.warning("missing argument");
                return false;
            }
            if (n >= pdVectorArray.length) {
                PsDebug.warning("image has less then " + n + " coordinates.");
                return false;
            }
            if (n2 > pdVectorArray.length) {
                PsDebug.warning("domain and image have different number of vertices.");
                return false;
            }
        } else if (n2 != pdVector.getSize()) {
            PsDebug.warning("domain and image have different number of vertices.");
            return false;
        }
        int n3 = pgElementSet.getNumElements();
        this.setBasedOn(1);
        this.setGeometry(pgElementSet);
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = PdVector.realloc(null, 3, this.m_dim);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, 3, this.m_dim);
        int n4 = 0;
        while (n4 < n3) {
            int[] nArray = piVectorArray[n4].m_data;
            double d = pgElementSet.getAreaOfElement(n4);
            PuVectorGeom.ctg(dArray, pdVectorArray2[nArray[0]], pdVectorArray2[nArray[1]], pdVectorArray2[nArray[2]]);
            int n5 = 0;
            do {
                pdVectorArray3[n5].sub(pdVectorArray2[nArray[(n5 + 2) % 3]], pdVectorArray2[nArray[(n5 + 1) % 3]]);
            } while (++n5 < 3);
            n5 = 0;
            do {
                pdVectorArray4[n5].blend(dArray[(n5 + 1) % 3], pdVectorArray3[(n5 + 1) % 3], -dArray[(n5 + 2) % 3], pdVectorArray3[(n5 + 2) % 3]);
                pdVectorArray4[n5].multScalar(1.0 / (2.0 * d));
            } while (++n5 < 3);
            this.m_vector[n4].setConstant(0.0);
            n5 = 0;
            do {
                if (bl) {
                    pdVectorArray4[n5].multScalar(pdVector.m_data[nArray[n5]]);
                } else {
                    pdVectorArray4[n5].multScalar(pdVectorArray[nArray[n5]].m_data[n]);
                }
                this.m_vector[n4].add(pdVectorArray4[n5]);
            } while (++n5 < 3);
            ++n4;
        }
        return true;
    }

    public PdVector[] getVertices() {
        if (this.m_basePoints == null) {
            PsDebug.warning("missing base points.");
            return null;
        }
        return this.m_basePoints.getVertices();
    }

    protected void project(int n) {
        if (this.m_dim < 3) {
            return;
        }
        int n2 = this.m_surface.getDimOfVertices();
        if (this.m_basedOn == 1) {
            double d;
            PiVector piVector = this.m_surface.getElement(n);
            int n3 = piVector.getSize();
            if (n3 < 3) {
                return;
            }
            double d2 = 1.0E-10;
            PdVector[] pdVectorArray = this.m_surface.getVertices();
            PdVector pdVector = new PdVector(n2);
            PdVector pdVector2 = new PdVector(n2);
            PdVector pdVector3 = new PdVector(n2);
            pdVector.sub(pdVectorArray[piVector.m_data[1]], pdVectorArray[piVector.m_data[0]]);
            if (!pdVector.normalize()) {
                PsDebug.warning("edges degenerated in element set");
                return;
            }
            int n4 = 2;
            boolean bl = false;
            do {
                pdVector2.sub(pdVectorArray[piVector.m_data[n4]], pdVectorArray[piVector.m_data[0]]);
                if (pdVector2.normalize()) continue;
                PsDebug.warning("edges degenerated in element set");
                return;
            } while ((bl = Math.abs(d = PdVector.dot(pdVector2, pdVector)) - 1.0 < d2) && ++n4 < n3);
            if (bl) {
                PsDebug.warning("elements degenerated in element set");
                return;
            }
            pdVector3.copy(pdVector);
            pdVector3.multScalar(d);
            pdVector2.sub(pdVector3);
            pdVector2.normalize();
            d = PdVector.dot(pdVector, this.m_vector[n]);
            pdVector.multScalar(d);
            d = PdVector.dot(pdVector2, this.m_vector[n]);
            pdVector2.multScalar(d);
            pdVector.setSize(this.m_dim);
            pdVector2.setSize(this.m_dim);
            this.m_vector[n].add(pdVector, pdVector2);
            return;
        }
        if (this.m_basedOn == 0) {
            PdVector pdVector = this.m_surface.getVertexNormal(n);
            this.m_vector[n].setSize(pdVector.getSize());
            double d = PdVector.dot(this.m_vector[n], pdVector);
            pdVector.multScalar(-d);
            this.m_vector[n].sub(pdVector);
            this.m_vector[n].setSize(this.m_dim);
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (object == this.m_surface) {
            this.setGeometry(this.m_surface);
            return super.update(this);
        }
        if (object == this.m_basePoints) {
            this.setGeometry(this.m_basePoints);
            return super.update(this);
        }
        if (object == this.m_globalVectorSize) {
            return super.update(this);
        }
        if (object == this.m_globalVectorLength) {
            return super.update(this);
        }
        if (object == this.m_globalVectorColor) {
            return super.update(this);
        }
        return super.update(object);
    }

    public void makeTangent() {
        if (this.m_surface == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        if (this.m_basedOn == 0 && !this.m_surface.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return;
        }
        int n = 0;
        while (n < this.m_numVectors) {
            this.project(n);
            ++n;
        }
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
    }

    public boolean isShowingVectorColors() {
        return this.m_bShowVectorColors;
    }

    public void showVectorColors(boolean bl) {
        this.m_bShowVectorColors = bl;
    }

    public void assureVectorColors() {
        if (this.m_vectorColor == null || this.m_vectorColor.length != this.m_maxNumVectors) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_maxNumVectors);
        }
    }

    public Color[] getVectorColors() {
        return this.m_vectorColor;
    }

    public void setVectorColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vectorColor = null;
            return;
        }
        if (colorArray.length < this.m_numVectors) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVectorColors();
        PdColor.copy(this.m_vectorColor, 0, colorArray, 0, this.m_numVectors);
    }

    public int getNumVectors() {
        return this.m_numVectors;
    }

    public void setNumVectors(int n) {
        if (n == this.m_numVectors) {
            return;
        }
        if (n > this.m_maxNumVectors) {
            this.setMaxNumVectors(n);
        }
        this.m_numVectors = n;
    }

    public Object clone() {
        PgVectorField pgVectorField = (PgVectorField)super.clone();
        if (pgVectorField == null) {
            return null;
        }
        pgVectorField.m_basePoints = null;
        pgVectorField.m_surface = null;
        pgVectorField.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        pgVectorField.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        pgVectorField.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        pgVectorField.m_globalVectorSize.setParent(pgVectorField);
        pgVectorField.m_globalVectorLength.setParent(pgVectorField);
        pgVectorField.m_globalVectorColor.setParent(pgVectorField);
        if (this.m_vector != null) {
            pgVectorField.m_vector = (PdVector[])P_Vector.clone(this.m_vector);
        }
        if (this.m_vectorColor != null) {
            pgVectorField.m_vectorColor = (Color[])this.m_vectorColor.clone();
        }
        return pgVectorField;
    }

    public boolean isShowingIndividualMaterial() {
        return this.m_bShowIndividualMaterial;
    }

    public void showIndividualMaterial(boolean bl) {
        if (this.m_bShowIndividualMaterial == bl) {
            return;
        }
        this.m_bShowIndividualMaterial = bl;
        this.m_globalVectorColor.setEnabled(bl);
        this.m_globalVectorLength.setEnabled(bl);
        this.m_globalVectorSize.setEnabled(bl);
        if (!this.m_bShowIndividualMaterial && this.m_surface != null) {
            this.setGlobalVectorColor(this.m_surface.getGlobalVectorColor());
            this.setGlobalVectorLength(this.m_surface.getGlobalVectorLength());
            this.setGlobalVectorSize(this.m_surface.getGlobalVectorSize());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgVectorField ***********\n");
        stringBuffer.append("\t m_numVectors = " + this.m_numVectors + "\n");
        stringBuffer.append("\t ******* m_vector *******\n");
        if (this.m_vector != null && this.m_numVectors > 0) {
            int n = 0;
            while (n < this.m_numVectors) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vector[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vector = null");
        }
        return stringBuffer.toString();
    }

    public PgVectorField(int n) {
        this(n, 0);
    }

    public PgVectorField(int n, int n2) {
        super(n);
        this.setTag(4);
        this.m_dimOfVectors = n;
        this.m_basedOn = n2;
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage(24050), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage(24049), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage(24048), this);
        this.m_index = -1;
        if (this.getClass() == (class$jv$geom$PgVectorField != null ? class$jv$geom$PgVectorField : (class$jv$geom$PgVectorField = PgVectorField.class$("jv.geom.PgVectorField")))) {
            this.init();
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        pvGeometryIf.setNumVectors(this.m_index, this.m_numVectors, this.m_dimOfVectors);
        pvGeometryIf.setVectors(this.m_index, this.m_vector);
        pvGeometryIf.setVectorElementBased(this.m_index, this.m_basedOn == 1);
        pvGeometryIf.showVectorField(this.m_index, this.isVisible());
        pvGeometryIf.showVectorArrows(this.m_index, this.m_bShowVectorArrow);
        pvGeometryIf.setVectorColors(this.m_index, this.m_vectorColor);
        pvGeometryIf.showVectorColors(this.m_index, this.m_bShowVectorColors);
        pvGeometryIf.setGlobalVectorColor(this.m_index, this.m_globalVectorColor.getColor());
        pvGeometryIf.setGlobalVectorLength(this.m_index, this.m_globalVectorLength.getValue());
        pvGeometryIf.setGlobalVectorSize(this.m_index, this.m_globalVectorSize.getValue());
    }

    public void clearTagVector(int n, int n2) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vector[n].clearTag(n2);
    }

    public boolean isShowingVectorArrows() {
        return this.m_bShowVectorArrow;
    }

    public void showVectorArrows(boolean bl) {
        this.m_bShowVectorArrow = bl;
    }

    public PdVector getVector(int n) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vector[n];
    }

    public boolean setVector(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vector[n].copy(pdVector);
        return true;
    }

    public void setVector(int n, double d) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dimOfVectors != 1) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(n + 1);
        }
        this.m_vector[n].set(d);
    }

    public void setVector(int n, double d, double d2) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dimOfVectors != 2) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(n + 1);
        }
        this.m_vector[n].set(d, d2);
    }

    public void setVector(int n, double d, double d2, double d3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dimOfVectors != 3) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(n + 1);
        }
        this.m_vector[n].set(d, d2, d3);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgVectorField) || !(pgGeometry2 instanceof PgVectorField)) {
            return false;
        }
        PgVectorField pgVectorField = (PgVectorField)pgGeometry;
        PgVectorField pgVectorField2 = (PgVectorField)pgGeometry2;
        if (pgVectorField.m_numVectors == 0) {
            PsDebug.warning("missing vectors of first argument");
            return false;
        }
        if (pgVectorField.m_numVectors != pgVectorField2.m_numVectors) {
            PsDebug.warning("unequal number of vectors of a and b");
            return false;
        }
        PgVectorField pgVectorField3 = d > 0.5 ? pgVectorField : pgVectorField2;
        this.m_dimOfVectors = pgVectorField3.m_dimOfVectors;
        this.setVisible(pgVectorField3.isVisible());
        this.m_globalVectorColor.blend(d, pgVectorField.m_globalVectorColor, d2, pgVectorField2.m_globalVectorColor);
        this.m_globalVectorSize.blend(d, pgVectorField.m_globalVectorSize, d2, pgVectorField2.m_globalVectorSize);
        this.m_globalVectorLength.blend(d, pgVectorField.m_globalVectorLength, d2, pgVectorField2.m_globalVectorLength);
        this.setNumVectors(pgVectorField3.m_numVectors);
        if (pgVectorField.m_vector != null && pgVectorField2.m_vector != null) {
            n = 0;
            while (n < this.m_numVectors) {
                this.m_vector[n].blend(d, pgVectorField.m_vector[n], d2, pgVectorField2.m_vector[n]);
                ++n;
            }
        }
        if (pgVectorField.m_vectorColor != null && pgVectorField2.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_numVectors);
            n = 0;
            while (n < this.m_numVectors) {
                this.m_vectorColor[n] = PdColor.blend(d, pgVectorField.m_vectorColor[n], d2, pgVectorField2.m_vectorColor[n]);
                ++n;
            }
        }
        return true;
    }

    public static PgVectorField sub(PgVectorField pgVectorField, PgVectorField pgVectorField2) {
        if (pgVectorField == null || pgVectorField2 == null) {
            PsDebug.warning("Cannot subtract vector fields. One of the fields is null.");
            return pgVectorField;
        }
        int n = Math.min(pgVectorField.getNumVectors(), pgVectorField2.getNumVectors());
        int n2 = pgVectorField2.getNumVectors();
        if (n2 < n) {
            n = n2;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PdVector[] pdVectorArray2 = pgVectorField2.getVectors();
        n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].sub(pdVectorArray2[n2]);
            ++n2;
        }
        return pgVectorField;
    }

    public void setTagVector(int n, int n2) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vector[n].setTag(n2);
    }

    public boolean removeVector(int n) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        this.m_vector[n].setTag(2);
        return true;
    }

    public void setGeometry(PgPointSet pgPointSet) {
        this.m_basePoints = pgPointSet;
        int n = pgPointSet.getNumVertices();
        this.m_surface = null;
        if (pgPointSet instanceof PgElementSet) {
            this.m_surface = (PgElementSet)pgPointSet;
            if (this.m_basedOn == 1) {
                n = this.m_surface.getNumElements();
            }
        }
        if (n != this.m_numVectors) {
            this.setNumVectors(n);
        }
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgVectorField)) {
            return;
        }
        PgVectorField pgVectorField = (PgVectorField)psObject;
        this.m_basePoints = pgVectorField.m_basePoints;
        this.m_surface = pgVectorField.m_surface;
        this.m_basedOn = pgVectorField.m_basedOn;
        this.m_dimOfVectors = pgVectorField.m_dimOfVectors;
        this.m_numVectors = pgVectorField.m_numVectors;
        this.m_maxNumVectors = pgVectorField.m_maxNumVectors;
        this.m_vector = pgVectorField.m_vector != null ? PdVector.copyNew(pgVectorField.m_vector) : null;
        if (pgVectorField.m_vectorColor != null) {
            this.m_vectorColor = new Color[pgVectorField.m_vectorColor.length];
            PdColor.copy(this.m_vectorColor, 0, pgVectorField.m_vectorColor, 0, pgVectorField.m_vectorColor.length);
        } else {
            this.m_vectorColor = null;
        }
        this.m_bShowVectorArrow = pgVectorField.m_bShowVectorArrow;
        this.m_globalVectorColor.copy(pgVectorField.m_globalVectorColor);
        this.m_globalVectorLength.copy(pgVectorField.m_globalVectorLength);
        this.m_globalVectorSize.copy(pgVectorField.m_globalVectorSize);
        this.m_bShowVectorColors = pgVectorField.m_bShowVectorColors;
    }

    public PgPointSet getGeometry() {
        if (this.m_surface != null) {
            return this.m_surface;
        }
        return this.m_basePoints;
    }

    protected void setIndex(int n) {
        this.m_index = n;
    }

    public boolean applyModelingMatrix() {
        if (this.m_numVectors == 0) {
            return true;
        }
        if (this.m_basePoints == null || !this.m_basePoints.hasModelMatrix()) {
            return false;
        }
        if (this.m_dimOfVectors != this.m_basePoints.getDimOfVertices()) {
            return false;
        }
        PdMatrix pdMatrix = this.m_basePoints.getModelMatrix();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        int n = 0;
        while (n < this.m_numVectors) {
            pdVector.copyArray(this.m_vector[n]);
            pdVector2.leftMultAffin(pdMatrix, pdVector, false);
            this.m_vector[n].copyArray(pdVector2);
            ++n;
        }
        return true;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        if (pdMatrix == null) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        int n = this.getDimOfVectors();
        if (n != 1 && pdMatrix.getSize() != n + 1) {
            PsDebug.warning("wrong size of transformation matrix, size = " + pdMatrix.getSize());
            return null;
        }
        PgVectorField pgVectorField = (PgVectorField)super.reflect(pdMatrix, bl, bl2);
        if (n == 1) {
            return pgVectorField;
        }
        PdVector[] pdVectorArray = this.m_vector;
        PdVector[] pdVectorArray2 = pgVectorField.m_vector;
        int n2 = 0;
        while (n2 < this.m_numVectors) {
            pdVectorArray2[n2].leftMultAffin(pdMatrix, pdVectorArray[n2], false);
            ++n2;
        }
        return pgVectorField;
    }

    public PdVector[] getVectors() {
        return this.m_vector;
    }

    public void init() {
        super.init();
        this.m_numVectors = -1;
        this.m_maxNumVectors = -1;
        this.setMaxNumVectors(0);
        this.m_bShowVectorArrow = false;
        this.m_bShowVectorColors = false;
        this.m_bShowIndividualMaterial = true;
        this.showIndividualMaterial(false);
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_globalVectorLength.setDefValue(1.0);
        this.m_globalVectorLength.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.init();
    }

    public boolean setVectors(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing vector array");
            return false;
        }
        if (pdVectorArray.length < this.m_numVectors) {
            PsDebug.warning("length of vector array smaller than number of vectors");
            return false;
        }
        if (this.m_numVectors == 0) {
            return true;
        }
        int n = pdVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numVectors) {
            int n3 = pdVectorArray[n2].getSize();
            this.m_vector[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dimOfVectors = n;
        PdVector.copy(this.m_vector, 0, pdVectorArray, 0, this.m_numVectors);
        return true;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    protected int getMaxNumVectors() {
        return this.m_maxNumVectors;
    }

    protected void setMaxNumVectors(int n) {
        if (this.m_maxNumVectors == n) {
            return;
        }
        this.m_vector = PdVector.realloc(this.m_vector, n, this.m_dimOfVectors);
        if (this.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, n);
        }
        this.m_maxNumVectors = n;
        if (this.m_maxNumVectors < this.m_numVectors) {
            this.m_numVectors = this.m_maxNumVectors;
        }
    }

    public void setDimOfVectors(int n) {
        this.setDimOfVertices(n);
        this.m_dimOfVectors = n;
        int n2 = 0;
        while (n2 < this.m_maxNumVectors) {
            this.m_vector[n2].setSize(n);
            ++n2;
        }
    }
}

