/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementEdge;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgElementSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected int m_dimOfElements;
    protected int m_maxDimOfElements = 300;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected Color[] m_elementBackColor;
    protected PdVector[] m_elementNormal;
    protected PiVector[] m_neighbour;
    protected PgBndPolygon[] m_bndList;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected PuDouble m_globalBndSize;
    protected boolean m_bConforming = true;
    protected PiVector[] m_elementSaved;
    protected int m_savedNumVertices;
    protected boolean m_bShowElementTexture;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowSilhouette;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected Color[] m_edgeColor;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeColorFromElements;
    protected PdColor m_globalEdgeColor;
    protected PdColor m_globalEdgeTagColor;
    protected PuDouble m_globalEdgeSize;
    protected PuDouble m_creaseAngle;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowBackface;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected PuDouble m_globalElementNormalLength;
    protected PuDouble m_globalElementNormalSize;
    protected PdColor m_globalElementNormalColor;
    protected boolean m_bShowElementColors;
    protected PdColor m_globalElementColor;
    protected PdColor m_globalElementTagColor;
    protected PdColor m_globalElementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothElementColors;
    protected boolean m_bInduceElementFromVertexColors;
    private static /* synthetic */ Class class$jv$geom$PgElementSet;

    public boolean refineGlobalIntoFour() {
        return this.refineGlobalIntoFour(true);
    }

    public boolean refineGlobalIntoFour(boolean bl) {
        int n;
        Object object;
        Serializable serializable;
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        int n5;
        int n6;
        int n7;
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{3, 4, 5};
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 4;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{1, 3, 5};
        nArrayArray[3] = new int[]{2, 4, 3};
        int[][] nArrayArray2 = nArrayArray;
        int[] nArray2 = new int[6];
        if (this.m_dimOfElements != 3 && (n7 = PgElementSet.triangulate(this)) == 0) {
            PsDebug.error("initial triangulation failed");
            return false;
        }
        int n8 = this.m_numVertices;
        int n9 = this.m_numElements;
        n7 = this.m_numVertices + this.getNumEdges();
        this.setNumVertices(n7);
        PdVector[][] pdVectorArray = this.hasElementTextures() ? this.getElementTextures() : new PdVector[1][1];
        this.setNumElements(4 * n9);
        if (this.m_bndList != null) {
            n6 = 0;
            while (n6 < this.m_bndList.length) {
                if (!this.m_bndList[n6].hasTag(2)) {
                    n5 = this.m_bndList[n6].getNumVertices();
                    cloneable = this.m_bndList[n6];
                    ((PgPolygon)cloneable).setNumVertices(2 * n5 - 1);
                    n4 = n5 - 1;
                    while (n4 >= 0) {
                        ((PgBndPolygon)cloneable).m_vertexInd.m_data[2 * n4] = ((PgBndPolygon)cloneable).m_vertexInd.m_data[n4];
                        --n4;
                    }
                }
                ++n6;
            }
        }
        cloneable = new PiVector(n7 - n8);
        PiVector piVector = new PiVector(n7 - n8);
        int n10 = n8 - 1;
        n6 = n9 - 1;
        while (n6 >= 0) {
            n4 = 0;
            do {
                if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                if (++n10 == this.m_numVertices) {
                    PsDebug.error("internal error");
                    return false;
                }
                n3 = this.m_element[n6].m_data[(n4 + 3 - 1) % 3];
                n2 = this.m_element[n6].m_data[(n4 + 1) % 3];
                ((PiVector)cloneable).setEntry(n10 - n8, n3);
                piVector.setEntry(n10 - n8, n2);
                if (!bl) continue;
                this.m_vertex[n10].blend(0.5, this.m_vertex[n3], 0.5, this.m_vertex[n2]);
            } while (++n4 < 3);
            --n6;
        }
        if (this.hasVertexColors()) {
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    Color color = this.getVertexColor(this.m_element[n6].m_data[(n4 + 3 - 1) % 3]);
                    Color color2 = this.getVertexColor(this.m_element[n6].m_data[(n4 + 1) % 3]);
                    serializable = PdColor.blend(0.5, color, 0.5, color2);
                    this.setVertexColor(++n10, (Color)serializable);
                } while (++n4 < 3);
                --n6;
            }
        }
        if (this.hasVertexNormals()) {
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    ++n10;
                    PdVector pdVector = this.getVertexNormal(this.m_element[n6].m_data[(n4 + 3 - 1) % 3]);
                    PdVector pdVector2 = this.getVertexNormal(this.m_element[n6].m_data[(n4 + 1) % 3]);
                    serializable = PdVector.blendNew(0.5, pdVector, 0.5, pdVector2);
                    ((PdVector)serializable).normalize();
                    this.setVertexNormal(n10, (PdVector)serializable);
                } while (++n4 < 3);
                --n6;
            }
        }
        if (this.hasVertexTextures()) {
            PdVector[] pdVectorArray2 = this.getVertexTextures();
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    PdVector pdVector = pdVectorArray2[this.m_element[n6].m_data[(n4 + 3 - 1) % 3]];
                    serializable = pdVectorArray2[this.m_element[n6].m_data[(n4 + 1) % 3]];
                    object = new PdVector(this.getDimOfTextures());
                    ((PdVector)object).blend(0.5, pdVector, 0.5, (PdVector)serializable);
                    pdVectorArray2[++n10] = object;
                } while (++n4 < 3);
                --n6;
            }
        }
        n3 = this.hasBoundary();
        n10 = n8 - 1;
        n6 = n9 - 1;
        while (n6 >= 0) {
            n4 = 0;
            block11: do {
                int n11;
                nArray2[n4] = this.m_element[n6].m_data[n4];
                if (this.m_neighbour[n6].m_data[n4] < n6) {
                    n2 = this.m_element[n6].m_data[(n4 + 3 - 1) % 3];
                    int n12 = this.m_element[n6].m_data[(n4 + 1) % 3];
                    nArray2[n4 + 3] = ++n10;
                    if (this.m_neighbour[n6].m_data[n4] != -1 || n3 == 0) continue;
                    boolean bl2 = false;
                    n = 0;
                    while (n < this.m_bndList.length && !bl2) {
                        if (!this.m_bndList[n].hasTag(2)) {
                            n5 = this.m_bndList[n].getNumVertices();
                            n11 = 0;
                            while (n11 < n5 - 2) {
                                if (this.m_bndList[n].m_vertexInd.m_data[n11] == n2 && this.m_bndList[n].m_vertexInd.m_data[n11 + 2] == n12 || this.m_bndList[n].m_vertexInd.m_data[n11] == n12 && this.m_bndList[n].m_vertexInd.m_data[n11 + 2] == n2) {
                                    this.m_bndList[n].m_vertexInd.m_data[n11 + 1] = n10;
                                    bl2 = true;
                                    break;
                                }
                                n11 += 2;
                            }
                        }
                        ++n;
                    }
                    if (bl2) continue;
                    PsDebug.warning("boundary edge not found\n\tEdge = (" + n2 + ", " + n12 + ")");
                    continue;
                }
                n2 = this.m_neighbour[n6].m_data[n4];
                n11 = 0;
                do {
                    if (this.m_neighbour[n2].m_data[n11] != n6) continue;
                    nArray2[n4 + 3] = this.m_element[n2].m_data[n11];
                    continue block11;
                } while (++n11 < 3);
            } while (++n4 < 3);
            n4 = 0;
            do {
                n = 0;
                do {
                    this.m_element[n6 + n4 * n9].m_data[n] = nArray2[nArrayArray2[n4][n]];
                } while (++n < 3);
            } while (++n4 < 4);
            --n6;
        }
        n6 = 0;
        while (n6 < n9) {
            n4 = 0;
            do {
                n2 = n6 + (n4 + 1) * n9;
                int n13 = n6 + ((n4 + 1) % 3 + 1) * n9;
                int n14 = this.m_neighbour[n6].m_data[(n4 + 2) % 3];
                if (n14 == -1) {
                    this.m_neighbour[n2].m_data[2] = -1;
                    this.m_neighbour[n13].m_data[1] = -1;
                    continue;
                }
                n = 1;
                while (this.m_element[n14 + n * n9].m_data[0] != this.m_element[n2].m_data[0] && ++n < 4) {
                }
                this.m_neighbour[n2].m_data[2] = n14 + n * n9;
                n = 1;
                while (this.m_element[n14 + n * n9].m_data[0] != this.m_element[n13].m_data[0] && ++n < 4) {
                }
                this.m_neighbour[n13].m_data[1] = n14 + n * n9;
            } while (++n4 < 3);
            ++n6;
        }
        n6 = 0;
        while (n6 < n9) {
            n4 = 0;
            do {
                this.m_neighbour[n6].m_data[n4] = n6 + (n4 + 1) * n9;
                this.m_neighbour[n6 + (n4 + 1) * n9].m_data[0] = n6;
            } while (++n4 < 3);
            ++n6;
        }
        if (this.hasElementColors()) {
            Color[] colorArray = this.getElementColors();
            n6 = 0;
            while (n6 < n9) {
                this.setElementColor(n6 + n9, colorArray[n6]);
                this.setElementColor(n6 + 2 * n9, colorArray[n6]);
                this.setElementColor(n6 + 3 * n9, colorArray[n6]);
                ++n6;
            }
        }
        if (this.m_elementBackColor != null) {
            Color[] colorArray = this.getElementBackColors();
            n6 = 0;
            while (n6 < n9) {
                this.setElementBackColor(n6 + n9, colorArray[n6]);
                this.setElementBackColor(n6 + 2 * n9, colorArray[n6]);
                this.setElementBackColor(n6 + 3 * n9, colorArray[n6]);
                ++n6;
            }
        }
        if (this.hasElementNormals()) {
            PdVector[] pdVectorArray3 = this.getElementNormals();
            n6 = 0;
            while (n6 < n9) {
                this.setElementNormal(n6 + n9, pdVectorArray3[n6]);
                this.setElementNormal(n6 + 2 * n9, pdVectorArray3[n6]);
                this.setElementNormal(n6 + 3 * n9, pdVectorArray3[n6]);
                ++n6;
            }
        }
        int n15 = this.getNumVectorFields();
        n6 = 0;
        while (n6 < n15) {
            PgVectorField pgVectorField = this.getVectorField(n6);
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setNumVectors(n7);
                object = pgVectorField.getVectors();
                n4 = n8;
                while (n4 < n7) {
                    ((PdVector)object[n4]).blend(0.5, (PdVector)object[((PiVector)cloneable).getEntry(n4 - n8)], 0.5, (PdVector)object[piVector.getEntry(n4 - n8)]);
                    ++n4;
                }
            } else {
                pgVectorField.setNumVectors(n9 * 4);
                n4 = 0;
                while (n4 < n9) {
                    object = pgVectorField.getVector(n4);
                    pgVectorField.setVector(n4 + n9, (PdVector)object);
                    pgVectorField.setVector(n4 + 2 * n9, (PdVector)object);
                    pgVectorField.setVector(n4 + 3 * n9, (PdVector)object);
                    ++n4;
                }
            }
            ++n6;
        }
        if (this.hasElementTextures()) {
            PdVector[][] pdVectorArray4 = this.getElementTextures();
            object = new PdVector[6];
            n6 = 0;
            while (n6 < n9) {
                object[0] = PdVector.copyNew(pdVectorArray[n6][0]);
                object[1] = PdVector.copyNew(pdVectorArray[n6][1]);
                object[2] = PdVector.copyNew(pdVectorArray[n6][2]);
                object[3] = PdVector.blendNew(0.5, pdVectorArray[n6][1], 0.5, pdVectorArray[n6][2]);
                object[4] = PdVector.blendNew(0.5, pdVectorArray[n6][2], 0.5, pdVectorArray[n6][0]);
                object[5] = PdVector.blendNew(0.5, pdVectorArray[n6][0], 0.5, pdVectorArray[n6][1]);
                n4 = 0;
                do {
                    if (n4 != 0) {
                        pdVectorArray4[n4 * n9 + n6] = new PdVector[3];
                    }
                    n = 0;
                    do {
                        pdVectorArray4[n4 * n9 + n6][n] = PdVector.copyNew((PdVector)object[nArrayArray2[n4][n]]);
                    } while (++n < 3);
                } while (++n4 < 4);
                ++n6;
            }
        }
        if (this.m_bndList != null) {
            n = 0;
            while (n < this.m_bndList.length) {
                if (!this.m_bndList[n].hasTag(2) && !this.m_bndList[n].makeElementInd()) {
                    this.removeBoundaries();
                    break;
                }
                ++n;
            }
        }
        return true;
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computePlane(n, n2, d, d2, d3, d4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public static boolean triangulate(PgElementSet pgElementSet) {
        int n;
        Object object;
        if (pgElementSet.getDimOfElements() == 3) {
            return true;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < pgElementSet.m_numElements) {
            n2 += pgElementSet.m_element[n3].getSize();
            ++n3;
        }
        PiVector piVector = new PiVector(n2 -= 2 * pgElementSet.getNumElements());
        PiVector[] piVectorArray = new PiVector[n2];
        boolean bl = pgElementSet.hasElementTextures();
        PdVector[][] pdVectorArray = null;
        if (bl) {
            pdVectorArray = new PdVector[n2][3];
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < pgElementSet.m_numElements) {
            PiVector piVector2 = pgElementSet.m_element[n3];
            int n5 = piVector2.getSize();
            if (n4 + n5 - 2 > n2) {
                PsDebug.warning("too many triangles, programming error");
            }
            object = pgElementSet.getElementVertices(n3);
            PiVector[] piVectorArray2 = PgUtil.triangulate((PdVector[])object, n5);
            n = 0;
            while (n < n5 - 2) {
                int n6;
                piVectorArray2[n].copy((P_Vector)piVector2);
                if (bl) {
                    n6 = 0;
                    do {
                        pdVectorArray[n4 + n][n6] = PdVector.copyNew(pgElementSet.m_elementTexture[n3][piVectorArray2[n].m_data[n6]]);
                    } while (++n6 < 3);
                }
                n6 = 0;
                do {
                    piVectorArray2[n].m_data[n6] = piVector2.m_data[piVectorArray2[n].m_data[n6]];
                } while (++n6 < 3);
                piVectorArray[n4 + n] = piVectorArray2[n];
                piVector.m_data[n4 + n] = n3;
                ++n;
            }
            n4 += n5 - 2;
            ++n3;
        }
        pgElementSet.setDimOfElements(3);
        pgElementSet.setNumElements(n2);
        pgElementSet.setElements(piVectorArray);
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasElementColors()) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                pgElementSet.setElementColor(n3, pgElementSet.getElementColor(piVector.m_data[n3]));
                --n3;
            }
        }
        if (pgElementSet.getElementBackColors() != null) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                pgElementSet.setElementBackColor(n3, pgElementSet.getElementBackColor(piVector.m_data[n3]));
                --n3;
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (bl) {
            pgElementSet.setElementTextures(pdVectorArray);
        }
        int n7 = pgElementSet.getNumVectorFields();
        n3 = 0;
        while (n3 < n7) {
            object = pgElementSet.getVectorField(n3);
            if (((PgVectorField)object).getBasedOn() != 0) {
                ((PgVectorField)object).setNumVectors(n2);
                n = n2 - 1;
                while (n >= 0) {
                    ((PgVectorField)object).setVector(n, ((PgVectorField)object).getVector(piVector.m_data[n]));
                    --n;
                }
            }
            ++n3;
        }
        int n8 = pgElementSet.getNumBoundaries();
        n3 = 0;
        while (n3 < n8) {
            if (!pgElementSet.m_bndList[n3].makeElementInd()) {
                pgElementSet.removeBoundaries();
                break;
            }
            ++n3;
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        return true;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = this.m_dim == 2 ? new PdVector(2) : pdVector5;
        PdVector pdVector7 = new PdVector(3);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdVector pdVector8 = null;
        if (this.m_dim == 2) {
            pdVector8 = new PdVector(3);
        }
        int n4 = 0;
        while (n4 < this.m_numElements) {
            PdVector[] pdVectorArray = this.getElementVertices(n4);
            if (pdVectorArray != null && pdVectorArray.length >= 3) {
                if (this.m_dim == 2) {
                    pdVector8.copyArray(pdVectorArray[0]);
                } else {
                    pdVector8 = pdVectorArray[0];
                }
                int n5 = 1;
                while (n5 < pdVectorArray.length - 1) {
                    if (pdVector3.normalOfPlane(pdVectorArray[0], pdVectorArray[n5], pdVectorArray[n5 + 1]) && !((d = PuVectorGeom.intersectionOfLineAndPlane(pdVector5, pdVector, pdVector2, pdVector8, pdVector3)) >= d2)) {
                        if (this.m_dim == 2) {
                            pdVector6.m_data[0] = pdVector5.m_data[0];
                            pdVector6.m_data[1] = pdVector5.m_data[1];
                        }
                        PdBary.getBary(pdBary, pdVector6, pdVectorArray[0], pdVectorArray[n5], pdVectorArray[n5 + 1]);
                        if (pdBary.isInside()) {
                            d2 = d;
                            n2 = n4;
                            n3 = n5;
                            pdBary2.copy(pdBary);
                            pdVector4.copy(pdVector3);
                            pdVector7.copy(pdVector5);
                            if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                                n = this.m_element[n4].getEntry(0);
                            } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                                n = this.m_element[n4].getEntry(n5);
                            } else if (Math.abs(1.0 - pdBary.getEntry(2)) < 0.1) {
                                n = this.m_element[n4].getEntry(n5 + 1);
                            }
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector7);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(0.0);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public boolean hasElementNormals() {
        return this.m_elementNormal != null && this.m_elementNormal.length == this.m_maxNumElements;
    }

    public boolean makeElementNormals() {
        if (this.m_numElements < 1) {
            return true;
        }
        this.assureElementNormals();
        if (this.m_dim != 3) {
            return true;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
        PdVector.setConstant(this.m_elementNormal, 0.0);
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            if (n2 >= 2) {
                PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[(-2 + n2) % n2]];
                PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(-1 + n2) % n2]];
                pdVector.sub(pdVector5, pdVector4);
                int n3 = 0;
                while (n3 < n2) {
                    pdVector4 = pdVector5;
                    pdVector5 = this.m_vertex[this.m_element[n].m_data[n3]];
                    pdVector2.sub(pdVector5, pdVector4);
                    boolean bl = pdVector3.cross(pdVector, pdVector2);
                    pdVector.copyArray(pdVector2);
                    if (bl && pdVector3.normalize()) {
                        this.m_elementNormal[n].add(pdVector3);
                    }
                    ++n3;
                }
                this.m_elementNormal[n].normalize();
            }
            ++n;
        }
        return true;
    }

    public boolean makeVertexNormals() {
        super.makeVertexNormals();
        if (this.m_dim != 3) {
            return true;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
        PdVector pdVector4 = new PdVector(this.m_dimOfVectors);
        boolean[] blArray = new boolean[this.m_maxDimOfElements];
        PdVector.setConstant(this.m_vertexNormal, 0.0);
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            if (n2 >= 3) {
                double d;
                if (n2 > this.m_maxDimOfElements && n2 > blArray.length) {
                    blArray = new boolean[this.m_maxDimOfElements + n2];
                    PsDebug.warning("dimension of an element = " + n2 + " too large.");
                }
                if (!((d = this.getAreaOfElement(n)) < 1.0E-10)) {
                    int n3;
                    int[] nArray = this.m_element[n].m_data;
                    PdVector pdVector5 = this.m_vertex[nArray[(-2 + n2) % n2]];
                    PdVector pdVector6 = this.m_vertex[nArray[(-1 + n2) % n2]];
                    pdVector.sub(pdVector6, pdVector5);
                    boolean bl = false;
                    pdVector4.setConstant(0.0);
                    int n4 = 0;
                    while (n4 < n2) {
                        n3 = nArray[(n4 - 1 + n2) % n2];
                        pdVector5 = pdVector6;
                        pdVector6 = this.m_vertex[nArray[n4]];
                        pdVector2.sub(pdVector6, pdVector5);
                        boolean bl2 = pdVector3.cross(pdVector, pdVector2);
                        pdVector.copyArray(pdVector2);
                        boolean bl3 = blArray[n4] = bl2 && pdVector3.setLength(d);
                        if (blArray[n4]) {
                            if (this.m_vertexNormal[n3].dot(pdVector3) < -0.707) {
                                this.m_vertexNormal[n3].sub(pdVector3);
                                pdVector4.sub(pdVector3);
                            } else {
                                this.m_vertexNormal[n3].add(pdVector3);
                                pdVector4.add(pdVector3);
                            }
                        } else {
                            bl = true;
                        }
                        ++n4;
                    }
                    if (bl) {
                        n4 = 0;
                        while (n4 < n2) {
                            n3 = nArray[(n4 - 1 + n2) % n2];
                            if (!blArray[n4]) {
                                this.m_vertexNormal[n3].add(pdVector4);
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.m_numVertices) {
            this.m_vertexNormal[n].normalize();
            ++n;
        }
        return true;
    }

    public void removeElementNormals() {
        this.setElementNormals(null);
    }

    public PiVector getNeighbour(int n) {
        if (this.m_neighbour == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public boolean setNeighbour(int n, PiVector piVector) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("element index out of range, ind = " + n);
            return false;
        }
        if (piVector == null || piVector.getSize() != this.m_element[n].getSize()) {
            PsDebug.warning("size of given neighbour array does not match size of existing element, elemInd = " + n);
            return false;
        }
        this.m_neighbour[n].copyArray(piVector);
        return true;
    }

    public PiVector getEdge(int n) {
        if (n < 0 || n >= this.m_numEdges) {
            return null;
        }
        return this.m_edge[n];
    }

    public boolean setEdge(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.error("index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numEdges) {
            PsDebug.warning("index=" + n + " > " + this.m_numEdges + "=m_numEdges, bad programming style");
            this.setNumEdges(n + 1);
        }
        this.m_edge[n].copy(piVector);
        return true;
    }

    public PgElementEdge[] getEdgeList() {
        int n;
        int n2;
        int n3;
        if (this.m_numElements < 1) {
            return null;
        }
        PgElementEdge pgElementEdge = null;
        int[] nArray = new int[2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.m_numElements) {
            int n7 = this.m_element[n6].getSize();
            n3 = 0;
            while (n3 < n7) {
                if (this.m_element[n6].m_data[n3] >= n5) {
                    n5 = this.m_element[n6].m_data[n3] + 1;
                }
                ++n3;
            }
            ++n6;
        }
        Vector[] vectorArray = new Vector[n5];
        n6 = 0;
        while (n6 < this.m_numElements) {
            int n8 = this.m_element[n6].getSize();
            n3 = 0;
            while (n3 < n8) {
                nArray[0] = this.m_element[n6].m_data[n3];
                nArray[1] = this.m_element[n6].m_data[(n3 + 1) % n8];
                if (nArray[0] > nArray[1]) {
                    n2 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n2;
                }
                boolean bl = false;
                if (vectorArray[nArray[0]] == null) {
                    vectorArray[nArray[0]] = new Vector();
                } else {
                    n2 = vectorArray[nArray[0]].size();
                    n = 0;
                    while (n < n2) {
                        pgElementEdge = (PgElementEdge)vectorArray[nArray[0]].elementAt(n);
                        if (pgElementEdge.getEdgeInd(1) == nArray[1]) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    pgElementEdge.addElement(n6, (n3 - 1 + n8) % n8);
                } else {
                    ++n4;
                    pgElementEdge = new PgElementEdge(nArray[0], nArray[1]);
                    pgElementEdge.addElement(n6, (n3 - 1 + n8) % n8);
                    vectorArray[nArray[0]].addElement(pgElementEdge);
                }
                ++n3;
            }
            ++n6;
        }
        PgElementEdge[] pgElementEdgeArray = new PgElementEdge[n4];
        n2 = 0;
        n6 = 0;
        while (n6 < n5) {
            if (vectorArray[n6] != null) {
                int n9 = vectorArray[n6].size();
                n = 0;
                while (n < n9) {
                    pgElementEdgeArray[n2] = (PgElementEdge)vectorArray[n6].elementAt(n);
                    ++n2;
                    ++n;
                }
            }
            ++n6;
        }
        if (n2 != n4) {
            PsDebug.warning("numEdges is wrong, edge list is void");
            PsDebug.warning("\t numEdges = " + n4 + ", countEdges = " + n2);
        }
        return pgElementEdgeArray;
    }

    public PgElementEdge getEdge(int n, int n2) {
        PgElementEdge pgElementEdge = null;
        int n3 = 0;
        while (n3 < this.m_numElements) {
            block6: {
                int[] nArray = this.m_element[n3].m_data;
                if (nArray == null) break block6;
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    block7: {
                        int n6;
                        block9: {
                            int n7;
                            block8: {
                                if (nArray[n5] != n) break block7;
                                int n8 = (n5 + 1) % n4;
                                n7 = (n5 - 1 + n4) % n4;
                                if (nArray[n8] != n2) break block8;
                                n6 = n7;
                                break block9;
                            }
                            if (nArray[n7] != n2) break block7;
                            n6 = (n5 - 2 + n4) % n4;
                        }
                        if (pgElementEdge == null) {
                            pgElementEdge = new PgElementEdge(n, n2);
                        }
                        pgElementEdge.addElement(n3, n6);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return pgElementEdge;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public void showElementBackColor(boolean bl) {
        this.m_globalElementBackColor.setEnabled(bl);
        this.m_bShowElementBackColor = bl;
    }

    public Color getElementBackColor(int n) {
        if (this.m_elementBackColor == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementBackColor[n];
    }

    public boolean setElementBackColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementBackColor == null || n >= this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        this.m_elementBackColor[n] = color;
        return true;
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSphere(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public Object clone() {
        PgElementSet pgElementSet = (PgElementSet)super.clone();
        if (pgElementSet == null) {
            return null;
        }
        pgElementSet.m_globalElementColor = (PdColor)this.m_globalElementColor.clone();
        pgElementSet.m_globalElementBackColor = (PdColor)this.m_globalElementBackColor.clone();
        pgElementSet.m_globalElementTagColor = (PdColor)this.m_globalElementTagColor.clone();
        pgElementSet.m_globalElementColor.setParent(pgElementSet);
        pgElementSet.m_globalElementBackColor.setParent(pgElementSet);
        pgElementSet.m_globalElementTagColor.setParent(pgElementSet);
        pgElementSet.m_globalBndSize = (PuDouble)this.m_globalBndSize.clone();
        pgElementSet.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        pgElementSet.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        pgElementSet.m_globalBndSize.setParent(pgElementSet);
        pgElementSet.m_globalBndColor.setParent(pgElementSet);
        pgElementSet.m_globalBndTagColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgElementSet.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgElementSet.m_globalEdgeTagColor = (PdColor)this.m_globalEdgeTagColor.clone();
        pgElementSet.m_globalEdgeSize.setParent(pgElementSet);
        pgElementSet.m_globalEdgeColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeTagColor.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalLength = (PuDouble)this.m_globalElementNormalLength.clone();
        pgElementSet.m_globalElementNormalSize = (PuDouble)this.m_globalElementNormalSize.clone();
        pgElementSet.m_globalElementNormalColor = (PdColor)this.m_globalElementNormalColor.clone();
        pgElementSet.m_globalElementNormalLength.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalSize.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalColor.setParent(pgElementSet);
        pgElementSet.m_creaseAngle = (PuDouble)this.m_creaseAngle.clone();
        pgElementSet.m_creaseAngle.setParent(pgElementSet);
        if (this.m_element != null) {
            pgElementSet.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            pgElementSet.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            pgElementSet.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            pgElementSet.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            pgElementSet.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            pgElementSet.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_bndList != null) {
            pgElementSet.m_bndList = null;
            int n = this.getNumBoundaries();
            if (n > 0) {
                PgBndPolygon[] pgBndPolygonArray = (PgBndPolygon[])this.m_bndList.clone();
                int n2 = 0;
                while (n2 < n) {
                    pgBndPolygonArray[n2] = (PgBndPolygon)pgBndPolygonArray[n2].clone();
                    ++n2;
                }
                pgElementSet.setBoundary(pgBndPolygonArray);
            }
        }
        if (this.m_elementSaved != null) {
            pgElementSet.m_elementSaved = (PiVector[])P_Vector.clone(this.m_elementSaved);
        }
        if (this.m_edge != null) {
            pgElementSet.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            pgElementSet.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        return pgElementSet;
    }

    public void buildTriangle(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n2 = n * (n + 1) / 2;
        int n3 = (n - 1) * (n - 1);
        this.setNumVertices(n2);
        this.setNumElements(n3);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d = (double)n5 / (double)(n - 1);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[1]);
            this.m_vertex[n4++].copy(pdVector);
            int n6 = 1;
            while (n6 < n - n5) {
                double d2 = (double)n6 / (double)(n - 1 - n5);
                this.m_vertex[n4++].blend(1.0 - d2, pdVector, d2, pdVector2);
                ++n6;
            }
            ++n5;
        }
        this.makeTriangleConn(n);
        this.makeTriangleBnd(n);
    }

    public void setNumEdges(int n) {
        if (this.m_numEdges == n) {
            return;
        }
        this.m_numEdges = n;
        if (n == 0) {
            this.m_edge = null;
            this.m_edgeColor = null;
            return;
        }
        this.m_edge = PiVector.realloc(this.m_edge, n);
    }

    public boolean isShowingTaggedEdges() {
        return this.m_bShowTaggedEdges;
    }

    public void showTaggedEdges(boolean bl) {
        this.m_bShowTaggedEdges = bl;
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public void showBackface(boolean bl) {
        this.m_bShowBackface = bl;
    }

    public void flipEdges() {
        int n;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("valid for triangulations only");
            return;
        }
        PiVector piVector = PgElementSet.getVertexValence(this);
        PdVector[] pdVectorArray = new PdVector[4];
        boolean bl = true;
        double[] dArray = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PiVector piVector2 = new PiVector(4);
        while (bl) {
            if (++n3 > 10) {
                PsDebug.warning("too many passes, num = " + n3);
                return;
            }
            bl = false;
            int n5 = 0;
            while (n5 < this.m_numElements) {
                boolean bl2 = false;
                piVector2.setConstant(-1);
                piVector2.setEntry(0, n5);
                n = 1;
                do {
                    if (this.m_neighbour[n5].m_data[n - 1] != -1 && piVector2.getIndexOf(this.m_neighbour[n5].m_data[n - 1]) > -1) {
                        bl2 = true;
                        break;
                    }
                    piVector2.setEntry(n, this.m_neighbour[n5].m_data[n - 1]);
                } while (++n < 4);
                if (!bl2) {
                    n = 0;
                    do {
                        int n6;
                        if ((n6 = this.m_neighbour[n5].m_data[n]) == -1 || n6 > n5) continue;
                        int n7 = n;
                        int n8 = (n + 1) % 3;
                        int n9 = (n + 2) % 3;
                        int n10 = this.getOppVertexLocInd(n5, n);
                        int n11 = (n10 + 1) % 3;
                        int n12 = (n10 + 2) % 3;
                        if (this.m_element[n5].m_data[n8] == this.m_element[n6].m_data[n11]) {
                            n11 = (n10 + 2) % 3;
                            n12 = (n10 + 1) % 3;
                        }
                        if (this.m_element[n5].m_data[n7] == this.m_element[n6].m_data[n10]) {
                            ++n4;
                            continue;
                        }
                        if (this.m_vertex[this.m_element[n5].m_data[n8]].hasTag(1) && this.m_vertex[this.m_element[n5].m_data[n9]].hasTag(1)) continue;
                        int n13 = this.m_neighbour[n6].m_data[n11];
                        int n14 = this.m_neighbour[n6].m_data[n12];
                        if (n13 > -1 && n13 == n14 || n13 > -1 && piVector2.getIndexOf(n13) > -1 || n14 > -1 && piVector2.getIndexOf(n14) > -1) {
                            ++n4;
                            continue;
                        }
                        if (piVector.getEntry(this.m_element[n5].m_data[n8]) <= 4 || piVector.getEntry(this.m_element[n5].m_data[n9]) <= 4) continue;
                        pdVectorArray[0] = this.m_vertex[this.m_element[n5].m_data[n7]];
                        pdVectorArray[1] = this.m_vertex[this.m_element[n5].m_data[n8]];
                        pdVectorArray[2] = this.m_vertex[this.m_element[n6].m_data[n10]];
                        pdVectorArray[3] = this.m_vertex[this.m_element[n5].m_data[n9]];
                        PdVector.angle(dArray, pdVectorArray);
                        if (!(dArray[0] + dArray[2] > dArray[1] + dArray[3])) continue;
                        ++n2;
                        bl = true;
                        int n15 = this.m_element[n5].m_data[n7];
                        piVector.m_data[n15] = piVector.m_data[n15] + 1;
                        int n16 = this.m_element[n5].m_data[n8];
                        piVector.m_data[n16] = piVector.m_data[n16] + -1;
                        int n17 = this.m_element[n5].m_data[n9];
                        piVector.m_data[n17] = piVector.m_data[n17] + -1;
                        int n18 = this.m_element[n6].m_data[n10];
                        piVector.m_data[n18] = piVector.m_data[n18] + 1;
                        int n19 = this.m_neighbour[n5].m_data[n8];
                        if (n19 > -1) {
                            this.m_neighbour[n19].m_data[this.getOppVertexLocInd((int)n5, (int)n8)] = n6;
                        }
                        if ((n19 = this.m_neighbour[n6].m_data[n11]) > -1) {
                            this.m_neighbour[n19].m_data[this.getOppVertexLocInd((int)n6, (int)n11)] = n5;
                        }
                        this.m_element[n5].m_data[n9] = this.m_element[n6].m_data[n10];
                        this.m_element[n6].m_data[n12] = this.m_element[n5].m_data[n7];
                        this.m_neighbour[n5].m_data[n7] = this.m_neighbour[n6].m_data[n11];
                        this.m_neighbour[n6].m_data[n10] = this.m_neighbour[n5].m_data[n8];
                        this.m_neighbour[n5].m_data[n8] = n6;
                        this.m_neighbour[n6].m_data[n11] = n5;
                    } while (++n < 3);
                }
                ++n5;
            }
        }
        n = 0;
        while (this.m_bndList != null && n < this.m_bndList.length) {
            if (!this.m_bndList[n].hasTag(2)) {
                this.m_bndList[n].makeElementInd();
            }
            ++n;
        }
        if (this.hasElementNormals()) {
            this.makeElementNormals();
        }
        if (this.hasVertexNormals()) {
            this.makeVertexNormals();
        }
    }

    public int getNumBoundaryEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                n += this.m_element[n2].getSize();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.m_numElements) {
                int n4 = this.m_element[n3].getSize();
                int n5 = 0;
                while (n5 < n4) {
                    if (this.m_neighbour[n3].m_data[n5] == -1) {
                        ++n;
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                n += this.m_element[n2].getSize();
                ++n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < this.m_numElements) {
            int n4 = this.m_element[n3].getSize();
            int n5 = 0;
            while (n5 < n4) {
                if (this.m_neighbour[n3].m_data[n5] < n3) {
                    ++n;
                }
                ++n5;
            }
            ++n3;
        }
        return n;
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(14)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public void makeQuadrConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * (n - 1) * (n2 - 1));
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n - 1) {
                int n6 = 0;
                while (n6 < n2 - 1) {
                    this.m_element[n3++].set(n5 * n2 + n6, (n5 + 1) * n2 + n6, n5 * n2 + n6 + 1);
                    this.m_element[n3++].set(n5 * n2 + n6 + 1, (n5 + 1) * n2 + n6, (n5 + 1) * n2 + n6 + 1);
                    this.m_neighbour[n4].set(n4 + 1, n4 - 2 * (n2 - 1) + 1, n4 - 1);
                    this.m_neighbour[++n4].set(n4 + 2 * (n2 - 1) - 1, n4 + 1, n4 - 1);
                    ++n4;
                    ++n6;
                }
                ++n5;
            }
            n4 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_neighbour[n4].m_data[2] = -1;
                this.m_neighbour[n4 += 2 * (n2 - 1) - 1].m_data[1] = -1;
                ++n4;
                ++n5;
            }
            n4 = 0;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_neighbour[n4].m_data[1] = -1;
                n4 += 2;
                ++n5;
            }
            n4 = 2 * (n2 - 1) * (n - 2) + 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_neighbour[n4].m_data[0] = -1;
                n4 += 2;
                ++n5;
            }
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n - 1) {
            int n10 = 0;
            while (n10 < n2 - 1) {
                this.m_element[n7++].set(n9 * n2 + n10, (n9 + 1) * n2 + n10, (n9 + 1) * n2 + n10 + 1, n9 * n2 + n10 + 1);
                this.m_neighbour[n8].set(n8 + (n2 - 1), n8 + 1, n8 - (n2 - 1), n8 - 1);
                ++n8;
                ++n10;
            }
            ++n9;
        }
        n8 = 0;
        n9 = 0;
        while (n9 < n - 1) {
            this.m_neighbour[n8].m_data[3] = -1;
            this.m_neighbour[n8 += n2 - 1 - 1].m_data[1] = -1;
            ++n8;
            ++n9;
        }
        n8 = 0;
        n9 = 0;
        while (n9 < n2 - 1) {
            this.m_neighbour[n8].m_data[2] = -1;
            ++n8;
            ++n9;
        }
        n8 = (n2 - 1) * (n - 2);
        n9 = 0;
        while (n9 < n2 - 1) {
            this.m_neighbour[n8].m_data[0] = -1;
            ++n8;
            ++n9;
        }
    }

    public void makeAlternatingQuadrConn(int n, int n2, boolean bl) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.setDimOfElements(3);
        this.setNumElements(2 * (n - 1) * (n2 - 1));
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                if (!bl) {
                    if (n5 % 2 == 0) {
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                        this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                    } else {
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5 + 1, n4 * n2 + n5 + 1);
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                    }
                } else if (n4 % 2 == 0) {
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                    this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                } else {
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5 + 1, n4 * n2 + n5 + 1);
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                }
                ++n5;
            }
            ++n4;
        }
        this.makeNeighbour();
    }

    public void setConforming(boolean bl) {
        this.m_bConforming = bl;
        if (this.m_bndList != null) {
            int n = 0;
            while (n < this.m_bndList.length) {
                if (this.m_bndList[n] != null) {
                    this.m_bndList[n].m_bConforming = bl;
                }
                ++n;
            }
        }
    }

    public int getNumBoundaries() {
        this.removeDeletedBoundaries();
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public void showTaggedBoundaries(boolean bl) {
        this.m_bShowTaggedBoundaries = bl;
    }

    public void buildPolygon(PdVector[] pdVectorArray, int n) {
        PsDebug.error("method not implemented yet");
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSnail(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void markBoundary() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(14);
            ++n;
        }
        if (this.m_neighbour == null) {
            PsDebug.warning("missing neighbour information.");
            return;
        }
        if (this.m_neighbour.length != this.m_element.length) {
            PsDebug.warning("void neighbour structure");
            return;
        }
        n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_neighbour[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] < 0) {
                    if (this.isConforming()) {
                        this.m_vertex[this.m_element[n].m_data[(n3 + 1) % n2]].setTag(14);
                        this.m_vertex[this.m_element[n].m_data[(n3 + 2) % n2]].setTag(14);
                    } else {
                        this.m_vertex[this.m_element[n].m_data[n3]].setTag(14);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numElements < 1 || !this.m_bConforming) {
            return true;
        }
        this.assureNeighbours();
        PgElementEdge[] pgElementEdgeArray = this.getEdgeList();
        if (pgElementEdgeArray == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < pgElementEdgeArray.length) {
            int[] nArray = pgElementEdgeArray[n2].getElements();
            if (nArray != null) {
                int n3 = pgElementEdgeArray[n2].getSize();
                if (n3 > n) {
                    n = n3;
                }
                if (n3 == 1) {
                    this.m_neighbour[nArray[0]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[0]] = -1;
                } else if (n3 == 2) {
                    this.m_neighbour[nArray[0]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[0]] = nArray[1];
                    this.m_neighbour[nArray[1]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[1]] = nArray[0];
                } else if (n3 > 2) {
                    boolean bl = false;
                    if (bl || !this.hasElementNormals()) {
                        int n4 = 0;
                        while (n4 < n3) {
                            this.m_neighbour[nArray[n4]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n4]] = -1;
                            ++n4;
                        }
                    } else {
                        int n5;
                        double d = -1.0;
                        int n6 = -1;
                        int n7 = -1;
                        int n8 = 0;
                        while (n8 < n3) {
                            PdVector pdVector = this.m_elementNormal[nArray[n8]];
                            n5 = n8 + 1;
                            while (n5 < n3) {
                                PdVector pdVector2 = this.m_elementNormal[nArray[n5]];
                                double d2 = PdVector.dot(pdVector, pdVector2);
                                if (!(d2 <= d)) {
                                    d = d2;
                                    n6 = n8;
                                    n7 = n5;
                                }
                                ++n5;
                            }
                            ++n8;
                        }
                        n8 = 0;
                        while (n8 < n3) {
                            this.m_neighbour[nArray[n8]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n8]] = -1;
                            ++n8;
                        }
                        this.m_neighbour[nArray[n6]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n6]] = nArray[n7];
                        this.m_neighbour[nArray[n7]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n7]] = nArray[n6];
                        if (n3 == 4) {
                            n8 = -1;
                            int n9 = -1;
                            n5 = 0;
                            while (n5 < n3) {
                                if (n8 == -1 && n5 != n6 && n5 != n7) {
                                    n8 = n5;
                                    break;
                                }
                                ++n5;
                            }
                            n5 = 0;
                            while (n5 < n3) {
                                if (n9 == -1 && n5 != n8 && n5 != n6 && n5 != n7) {
                                    n9 = n5;
                                    break;
                                }
                                ++n5;
                            }
                            this.m_neighbour[nArray[n8]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n8]] = nArray[n9];
                            this.m_neighbour[nArray[n9]].m_data[pgElementEdgeArray[n2].m_neighbourLocInd[n9]] = nArray[n8];
                        }
                    }
                }
            }
            ++n2;
        }
        if (n > 2) {
            PsDebug.message("Geometry " + this.getName() + " has edge with multiple elements, num = " + n, false);
        }
        return true;
    }

    public int getMaxDimOfElements() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public int getNumBoundaryComponents() {
        int n = this.m_numVertices;
        int n2 = this.m_numElements;
        if (this.m_dimOfElements == 3) {
            int n3 = this.getNumBoundaryEdges();
            int n4 = n - n3;
            return (n2 - 2 * n4 - n3 + 2) / 2 + 1;
        }
        int n5 = this.getNumEdges();
        return 2 - (n - n5 + n2);
    }

    public double getArea() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            d += this.getAreaOfElement(n);
            ++n;
        }
        return d;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Object object;
        P_Vector[] p_VectorArray;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)super.reflect(pdMatrix, bl, bl2);
        if (!bl) {
            p_VectorArray = pgElementSet.getElements();
            int n4 = 0;
            while (n4 < this.m_numElements) {
                ((PiVector)p_VectorArray[n4]).invert();
                ++n4;
            }
            object = pgElementSet.getNeighbours();
            if (object != null) {
                n3 = 0;
                while (n3 < this.m_numElements) {
                    ((PiVector)object[n3]).invert();
                    n2 = ((PiVector)object[n3]).getSize();
                    n = 3;
                    while (n < n2) {
                        ((PiVector)object[n3]).shift(1);
                        ++n;
                    }
                    ++n3;
                }
            }
        }
        if (this.hasElementNormals()) {
            p_VectorArray = this.getElementNormals();
            object = pgElementSet.getElementNormals();
            n3 = 0;
            while (n3 < this.m_numElements) {
                ((PdVector)object[n3]).leftMultAffin(pdMatrix, (PdVector)p_VectorArray[n3], false);
                if (!bl2) {
                    ((PdVector)object[n3]).multScalar(-1.0);
                }
                ((PdVector)object[n3]).normalize();
                ++n3;
            }
        }
        if (!bl && this.hasElementTextures()) {
            p_VectorArray = pgElementSet.getElementTextures();
            n3 = 0;
            while (n3 < this.m_numElements) {
                n2 = ((P_Vector)p_VectorArray[n3]).length;
                n = n2 / 2;
                int n5 = 0;
                while (n5 < n) {
                    object = p_VectorArray[n3][n5];
                    p_VectorArray[n3][n5] = p_VectorArray[n3][n2 - 1 - n5];
                    p_VectorArray[n3][n2 - 1 - n5] = object;
                    ++n5;
                }
                ++n3;
            }
        }
        return pgElementSet;
    }

    public boolean hasElementTextures() {
        return this.m_elementTexture != null && this.m_elementTexture.length == this.m_maxNumElements;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_bShowVertices = false;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_elementColor = null;
        this.m_bShowElementColors = false;
        this.m_globalElementColor.setColor(new Color(150, 220, 255));
        this.m_globalElementTagColor.setColor(Color.magenta);
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothElementColors = false;
        this.m_bInduceElementFromVertexColors = false;
        this.m_elementBackColor = null;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_globalElementBackColor.setColor(new Color(255, 200, 0));
        this.m_globalElementBackColor.setEnabled(this.m_bShowElementBackColor);
        this.m_elementNormal = null;
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_globalElementNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalElementNormalSize.setDefValue(1.0);
        this.m_globalElementNormalSize.init();
        this.m_globalElementNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalElementNormalLength.setDefValue(0.5);
        this.m_globalElementNormalLength.init();
        this.m_globalElementNormalColor.setColor(Color.yellow);
        this.m_creaseAngle.setDefBounds(0.0, 3.2, 0.02, 0.2);
        this.m_creaseAngle.setDefValue(3.2);
        this.m_creaseAngle.init();
        this.m_bShowSilhouette = false;
        this.m_edge = null;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = false;
        this.m_edgeColor = null;
        this.m_bShowEdgeColors = false;
        this.m_bShowEdgeColorFromElements = true;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.magenta);
        this.m_globalEdgeSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_bndList = null;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_globalBndSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalBndSize.setDefValue(3.0);
        this.m_globalBndSize.init();
        this.m_elementTexture = null;
        this.m_bShowElementTexture = false;
    }

    public void setBoundary(PgBndPolygon[] pgBndPolygonArray) {
        if (pgBndPolygonArray == null) {
            this.removeBoundaries();
            return;
        }
        this.m_bndList = new PgBndPolygon[pgBndPolygonArray.length];
        int n = 0;
        while (n < pgBndPolygonArray.length) {
            this.m_bndList[n] = pgBndPolygonArray[n];
            this.m_bndList[n].setElementSet(this);
            ++n;
        }
        this.removeDeletedBoundaries();
    }

    public void assureBoundary(int n) {
        int n2;
        if (this.m_bndList != null && this.m_bndList.length == n) {
            return;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_bndList;
        this.m_bndList = new PgBndPolygon[n];
        int n3 = 0;
        if (pgBndPolygonArray != null) {
            n3 = pgBndPolygonArray.length;
            n2 = 0;
            while (n2 < Math.min(n3, n)) {
                this.m_bndList[n2] = pgBndPolygonArray[n2];
                this.m_bndList[n2].clearTag(2);
                ++n2;
            }
        }
        n2 = n3;
        while (n2 < n) {
            this.m_bndList[n2] = new PgBndPolygon(this.m_dim);
            this.m_bndList[n2].setName("Boundary_" + String.valueOf(n2));
            this.m_bndList[n2].setElementSet(this);
            this.m_bndList[n2].setDimOfVectors(this.getDimOfVectors());
            ++n2;
        }
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.hasBoundary()) {
            int n2 = 0;
            while (n2 < this.m_bndList.length) {
                if (this.m_bndList[n2] != null) {
                    this.m_bndList[n2].setDimOfVectors(n);
                }
                ++n2;
            }
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public PdVector[] getElementTexture(int n) {
        if (!this.hasElementTextures()) {
            PsDebug.warning("missing element textures");
            return null;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        return this.m_elementTexture[n];
    }

    public boolean isShowingElementTexture() {
        return this.m_bShowElementTexture;
    }

    public void showElementTexture(boolean bl) {
        this.m_bShowElementTexture = bl;
        if (bl && this.isShowingVertexTexture()) {
            this.showVertexTexture(false);
        }
    }

    public void showVertexTexture(boolean bl) {
        if (bl && this.isShowingElementTextures()) {
            this.showElementTexture(false);
        }
        super.showVertexTexture(bl);
    }

    public void buildTriangleFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        int n;
        double d;
        int n2;
        int n3;
        PdVector pdVector;
        PdVector pdVector2;
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pgPolygonArray.length != 3 || pgBndConstraintArray.length != 3) {
            PsDebug.warning("wrong argument array list");
            return;
        }
        int n4 = pgPolygonArray[0].getNumVertices();
        int n5 = n4 * (n4 + 1) / 2;
        int n6 = (n4 - 1) * (n4 - 1);
        this.setNumVertices(n5);
        this.setNumElements(n6);
        int n7 = n4;
        int n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[0].m_vertex[n8];
            pdVector = pgPolygonArray[1].m_vertex[n4 - 1 - n8];
            n3 = 1;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    this.m_vertex[n7 + n3].m_data[n] = pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]);
                    ++n;
                }
                ++n3;
                ++n2;
            }
            n7 += n4 - n8;
            ++n8;
        }
        --n7;
        n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[1].m_vertex[n8];
            pdVector = pgPolygonArray[2].m_vertex[n4 - 1 - n8];
            n3 = -n8 - 2;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    int n9 = n;
                    this.m_vertex[n7 + n3].m_data[n9] = this.m_vertex[n7 + n3].m_data[n9] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                    ++n;
                }
                n3 -= n8 + n2 + 2;
                ++n2;
            }
            n7 -= n8 + 1;
            ++n8;
        }
        --n7;
        n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[2].m_vertex[n8];
            pdVector = pgPolygonArray[0].m_vertex[n4 - 1 - n8];
            n3 = n4 - 1;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    int n10 = n;
                    this.m_vertex[n7 + n3].m_data[n10] = this.m_vertex[n7 + n3].m_data[n10] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                    ++n;
                }
                n3 += n4 - 1 - n2;
                ++n2;
            }
            --n7;
            ++n8;
        }
        n7 = n4;
        n8 = 1;
        while (n8 < n4 - 1) {
            n3 = 1;
            n2 = 1;
            while (n2 < n4 - n8 - 1) {
                n = 0;
                while (n < this.m_dim) {
                    int n11 = n++;
                    this.m_vertex[n7 + n3].m_data[n11] = this.m_vertex[n7 + n3].m_data[n11] / 3.0;
                }
                ++n3;
                ++n2;
            }
            n7 += n4 - n8;
            ++n8;
        }
        n7 = 0;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[0].m_vertex[n8]);
            n7 += n4 - n8;
            ++n8;
        }
        --n7;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[1].m_vertex[n8]);
            n7 -= n8 + 1;
            ++n8;
        }
        n7 += n4;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[2].m_vertex[n8]);
            --n7;
            ++n8;
        }
        this.makeTriangleConn(n4);
        this.makeTriangleBnd(n4);
        n8 = 0;
        while (n8 < pgBndConstraintArray.length) {
            this.m_bndList[n8].m_bndConstraint = pgBndConstraintArray[n8];
            ++n8;
        }
    }

    public boolean setElementTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementTexture == null || n >= this.m_elementTexture.length) {
            this.assureElementTextures();
        }
        this.m_elementTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public void setElementColors(Color[] colorArray) {
        if (this.m_bInstanceSharing) {
            this.m_elementColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementColor == null || this.m_numElements > this.m_elementColor.length) {
            this.assureElementColors();
        }
        PdColor.copy(this.m_elementColor, 0, colorArray, 0, this.m_numElements);
    }

    public double getVolumeOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            return 0.0;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector.setConstant(0.0);
        pdVector2.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        double d = -PuVectorGeom.distOfPointToPlane(pdVector, pdVectorArray[0], pdVector2);
        double d2 = PdVector.area(pdVectorArray);
        return d2 * d / 3.0;
    }

    public boolean makeElementFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            if (n2 != 0) {
                if (n2 == 1) {
                    this.setElementColor(n, this.m_vertexColor[this.m_element[n].m_data[0]]);
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = this.m_vertexColor[this.m_element[n].m_data[n3]].getRGB();
                        f += (float)(n4 >> 16 & 0xFF);
                        f2 += (float)(n4 >> 8 & 0xFF);
                        f3 += (float)(n4 & 0xFF);
                        ++n3;
                    }
                    this.setElementColor(n, new Color((int)(f /= (float)n2), (int)(f2 /= (float)n2), (int)(f3 /= (float)n2)));
                }
            }
            ++n;
        }
        return true;
    }

    public boolean makeVertexFromElementColors() {
        if (!this.hasElementColors()) {
            PsDebug.warning("missing element colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numElements == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.m_element[n].m_data[n3];
                int n5 = this.m_elementColor[n].getRGB();
                int[] nArray3 = nArray[n4];
                nArray3[0] = nArray3[0] + (n5 >> 16 & 0xFF);
                int[] nArray4 = nArray[n4];
                nArray4[1] = nArray4[1] + (n5 >> 8 & 0xFF);
                int[] nArray5 = nArray[n4];
                nArray5[2] = nArray5[2] + (n5 & 0xFF);
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                ++n3;
            }
            ++n;
        }
        this.assureVertexColors();
        n = 0;
        while (n < this.m_numVertices) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
            } else {
                this.setVertexColor(n, Color.black);
            }
            ++n;
        }
        return true;
    }

    public boolean makeElementFromVertexTexture() {
        if (!this.hasVertexTextures()) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        PdVector[] pdVectorArray = this.getVertexTextures();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        this.assureElementTextures();
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                this.m_elementTexture[n][n3] = PdVector.copyNew(this.m_vertexTexture[this.m_element[n].m_data[n3]]);
                ++n3;
            }
            ++n;
        }
        this.showElementTexture(true);
        this.showVertexTexture(false);
        this.setVertexTextures(null);
        return true;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength.getValue();
    }

    public void setGlobalElementNormalLength(double d) {
        this.setGlobalVertexNormalLength(d);
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalElementNormalLength.setValue(d);
        super.setGlobalVertexNormalLength(d);
    }

    public void buildQuadr(PdVector[] pdVectorArray, int n, int n2) {
        if (pdVectorArray == null || pdVectorArray.length < 4) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = (1 + (n - 1) * (n3 + 1)) * (1 + (n2 - 1) * (n4 + 1));
        int n6 = 4 + 2 * n3 + 2 * n4 - 2;
        int n7 = (n - 1) * (n2 - 1) * n6;
        this.setNumVertices(n5);
        this.setNumElements(n7);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            double d = (double)n9 / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[2]);
            int n10 = 0;
            while (n10 < n2) {
                double d2 = (double)n10 / ((double)n2 - 1.0);
                this.m_vertex[n8++].blend(1.0 - d2, pdVector, d2, pdVector2);
                ++n10;
            }
            ++n9;
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public void showElementNormals(boolean bl) {
        this.m_bShowElementNormals = bl;
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_elementNormal = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_elementNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_elementNormal == null || this.m_numElements > this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        PdVector.copy(this.m_elementNormal, 0, pdVectorArray, 0, this.m_numElements);
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return false;
        }
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] == -1) {
                    this.m_vertexNormal[this.m_element[n].m_data[(n3 + 1) % n2]].setConstant(0.0);
                    this.m_vertexNormal[this.m_element[n].m_data[(n3 + 2) % n2]].setConstant(0.0);
                }
                ++n3;
            }
            ++n;
        }
        return true;
    }

    public PgElementSet() {
        this(3);
        this.m_bShowVertices = true;
    }

    public PgElementSet(int n) {
        super(n);
        this.setType(33);
        this.setTag(6);
        this.m_geomItem.addElement("Element");
        this.setDimOfSimplex(2);
        this.m_element = new PiVector[0];
        this.m_neighbour = null;
        this.m_elementSaved = null;
        this.m_elementTexture = null;
        this.m_globalElementColor = new PdColor(PsConfig.getMessage(24017), this);
        this.m_globalElementBackColor = new PdColor(PsConfig.getMessage(24018), this);
        this.m_globalElementTagColor = new PdColor(PsConfig.getMessage(24019), this);
        this.m_globalElementNormalLength = new PuDouble(PsConfig.getMessage(24020), this);
        this.m_globalElementNormalSize = new PuDouble(PsConfig.getMessage(24021), this);
        this.m_globalElementNormalColor = new PdColor(PsConfig.getMessage(24022), this);
        this.m_creaseAngle = new PuDouble(PsConfig.getMessage(24367), this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage(24023), this);
        this.m_globalEdgeTagColor = new PdColor(PsConfig.getMessage(24024), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage(24025), this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage(24026), this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage(24027), this);
        this.m_globalBndSize = new PuDouble(PsConfig.getMessage(24028), this);
        if (this.getClass() == (class$jv$geom$PgElementSet != null ? class$jv$geom$PgElementSet : (class$jv$geom$PgElementSet = PgElementSet.class$("jv.geom.PgElementSet")))) {
            this.init();
        }
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(84, this.isShowingElementLabels());
        pvGeometryIf.setState(68, this.m_bShowBackface);
        pvGeometryIf.setState(88, this.m_bShowSilhouette);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(94, this.m_bShowEdgeColors);
        pvGeometryIf.setState(95, this.m_bShowEdgeColorFromElements);
        if (this.m_bShowEdges || this.m_bShowSilhouette) {
            if (this.m_globalEdgeSize != null) {
                pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
            }
            if (this.m_globalEdgeColor != null) {
                pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
            }
            if (this.m_globalEdgeTagColor != null) {
                pvGeometryIf.setGlobalEdgeTagColor(this.m_globalEdgeTagColor.getColor());
            }
        }
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_bShowBoundaries || this.m_bShowSilhouette) {
            if (this.m_globalBndSize != null) {
                pvGeometryIf.setGlobalBndSize(this.m_globalBndSize.getValue());
            }
            if (this.m_globalBndColor != null) {
                pvGeometryIf.setGlobalBndColor(this.m_globalBndColor.getColor());
            }
            if (this.m_globalBndColor != null) {
                pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
            }
        }
        pvGeometryIf.setState(56, this.m_bShowElements);
        pvGeometryIf.setState(57, this.m_bShowTaggedElements);
        pvGeometryIf.setState(101, this.isShowingSmoothLighting());
        pvGeometryIf.setState(102, this.isShowingSmoothElementColors());
        pvGeometryIf.setState(103, this.isShowingElementFromVertexColors());
        pvGeometryIf.setState(96, this.m_bShowElementColors);
        pvGeometryIf.setState(99, this.m_bShowElementBackColor);
        pvGeometryIf.setState(100, this.m_bShowElementBackColors);
        pvGeometryIf.setDimOfElements(this.m_dimOfElements);
        pvGeometryIf.setNumElements(this.m_numElements);
        pvGeometryIf.setElements(this.m_element);
        pvGeometryIf.setState(104, this.isConforming());
        pvGeometryIf.setNeighbours(this.m_neighbour);
        pvGeometryIf.setElementColors(this.m_elementColor);
        pvGeometryIf.setElementBackColors(this.m_elementBackColor);
        pvGeometryIf.setState(62, this.m_bShowElementNormals);
        pvGeometryIf.setState(63, this.m_bShowElementNormalArrow);
        pvGeometryIf.setElementNormals(this.m_elementNormal);
        if (this.m_globalElementNormalSize != null) {
            pvGeometryIf.setGlobalElementNormalSize(this.m_globalElementNormalSize.getValue());
        }
        if (this.m_globalElementNormalLength != null) {
            pvGeometryIf.setGlobalElementNormalLength(this.m_globalElementNormalLength.getValue());
        }
        if (this.m_globalElementNormalColor != null) {
            pvGeometryIf.setGlobalElementNormalColor(this.m_globalElementNormalColor.getColor());
        }
        if (this.m_creaseAngle != null) {
            pvGeometryIf.setCreaseAngle(this.m_creaseAngle.getValue());
        }
        pvGeometryIf.setState(72, this.m_bShowElementTexture);
        pvGeometryIf.setElementTextures(this.m_elementTexture);
        if (this.m_globalElementColor != null) {
            pvGeometryIf.setGlobalElementColor(this.m_globalElementColor.getColor());
        }
        if (this.m_globalElementBackColor != null) {
            pvGeometryIf.setGlobalElementBackColor(this.m_globalElementBackColor.getColor());
        }
        if (this.m_globalElementTagColor != null) {
            pvGeometryIf.setGlobalElementTagColor(this.m_globalElementTagColor.getColor());
        }
    }

    public int[] removeElement(int n) {
        this.m_element[n].setTag(2);
        return this.removeMarkedElements();
    }

    public void setTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].setTag(n2);
    }

    public Color getElementColor(int n) {
        if (this.m_elementColor == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementColor[n];
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementColor == null || n >= this.m_elementColor.length) {
            this.assureElementColors();
        }
        this.m_elementColor[n] = color;
        return true;
    }

    public void removeTexture() {
        this.setElementTextures(null);
        this.showElementTexture(false);
        super.removeTexture();
    }

    public double getAreaOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        double d = PdVector.area(pdVectorArray);
        return d;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public void showElementNormalArrow(boolean bl) {
        this.m_bShowElementNormalArrow = bl;
    }

    public void computeCone(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCone(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public PdVector getElementNormal(int n) {
        if (this.m_elementNormal == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementNormal[n];
    }

    public boolean setElementNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementNormal == null || n >= this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        this.m_elementNormal[n].copy(pdVector);
        return true;
    }

    public int getSavedNumVertices() {
        return this.m_savedNumVertices;
    }

    public void setSavedNumVertices(int n) {
        this.m_savedNumVertices = n;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(33);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showElementLabels(this.isShowingElementLabels());
        pgJvxSrc.showBackface(this.isShowingBackface());
        pgJvxSrc.showSilhouette(this.isShowingSilhouette());
        pgJvxSrc.showTaggedElements(this.isShowingTaggedElements());
        pgJvxSrc.showElements(this.isShowingElements());
        pgJvxSrc.setDimOfElements(this.getDimOfElements());
        pgJvxSrc.setNumElements(this.getNumElements());
        pgJvxSrc.setElements(this.getElements());
        pgJvxSrc.setNeighbours(this.getNeighbours());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothElementColors());
        pgJvxSrc.showElementFromVertexColors(this.isShowingElementFromVertexColors());
        pgJvxSrc.showElementColors(this.isShowingElementColors());
        pgJvxSrc.setElementColors(this.getElementColors());
        pgJvxSrc.showElementBackColors(this.isShowingElementBackColors());
        pgJvxSrc.setElementBackColors(this.getElementBackColors());
        pgJvxSrc.setGlobalElementColor(this.getGlobalElementColor());
        pgJvxSrc.setGlobalElementTagColor(this.getGlobalElementTagColor());
        pgJvxSrc.setGlobalElementBackColor(this.getGlobalElementBackColor());
        pgJvxSrc.showElementBackColor(this.isShowingElementBackColor());
        if (this.hasElementNormals()) {
            pgJvxSrc.showElementNormals(this.isShowingElementNormals());
            pgJvxSrc.setElementNormals(this.getElementNormals());
        } else {
            pgJvxSrc.showElementNormals(false);
        }
        pgJvxSrc.showElementNormalArrow(this.isShowingElementNormalArrow());
        pgJvxSrc.setGlobalElementNormalColor(this.getGlobalElementNormalColor());
        pgJvxSrc.setGlobalElementNormalLength(this.getGlobalElementNormalLength());
        pgJvxSrc.setGlobalElementNormalSize(this.getGlobalElementNormalSize());
        pgJvxSrc.setCreaseAngle(this.getCreaseAngle());
        if (this.hasElementTextures()) {
            pgJvxSrc.showElementTexture(this.isShowingElementTexture());
            pgJvxSrc.setElementTextures(this.getElementTextures());
        } else {
            pgJvxSrc.showElementTexture(false);
        }
        pgJvxSrc.showEdges(this.isShowingEdges());
        pgJvxSrc.showEdgeColors(this.isShowingEdgeColors());
        pgJvxSrc.showEdgeColorFromElements(this.isShowingEdgeColorFromElements());
        pgJvxSrc.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalEdgeTagColor(this.getGlobalEdgeTagColor());
        pgJvxSrc.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgJvxSrc.showBoundaries(this.isShowingBoundaries());
        pgJvxSrc.setGlobalBndColor(this.getGlobalBndColor());
        pgJvxSrc.setGlobalBndTagColor(this.getGlobalBndTagColor());
        pgJvxSrc.setGlobalBndSize(this.getGlobalBndSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showElementLabels(pgJvxSrc.isShowingElementLabels());
        this.showSilhouette(pgJvxSrc.isShowingSilhouette());
        this.showBackface(pgJvxSrc.isShowingBackface());
        this.showTaggedElements(pgJvxSrc.isShowingTaggedElements());
        this.showElements(pgJvxSrc.isShowingElements());
        int n = PiVector.getSameSize(pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
        this.setDimOfElements(n);
        this.setNumElements(pgJvxSrc.getNumElements());
        if (this.isEnabledInstanceSharing()) {
            this.setMaxNumElements(pgJvxSrc.getNumElements());
        }
        this.setElements(pgJvxSrc.getElements());
        if (pgJvxSrc.getNeighbours() != null) {
            this.setNeighbours(pgJvxSrc.getNeighbours());
        } else if (PsJavaView.m_bAutoNeighbour) {
            this.makeNeighbour();
        } else {
            this.setNeighbours(null);
        }
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothElementColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showElementFromVertexColors(pgJvxSrc.isShowingElementFromVertexColors());
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalElementColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalElementTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        this.setElementColors(pgJvxSrc.getElementColors());
        this.showElementColors(pgJvxSrc.isShowingElementColors());
        this.setElementBackColors(pgJvxSrc.getElementBackColors());
        this.showElementBackColors(pgJvxSrc.isShowingElementBackColors());
        if (pgJvxSrc.getGlobalElementBackColor() != null) {
            this.setGlobalElementBackColor(pgJvxSrc.getGlobalElementBackColor());
        }
        this.showElementBackColor(pgJvxSrc.isShowingElementBackColor());
        this.showElementNormals(pgJvxSrc.isShowingElementNormals());
        this.showElementNormalArrow(pgJvxSrc.isShowingElementNormalArrow());
        if (pgJvxSrc.getElementNormals() != null) {
            this.setElementNormals(pgJvxSrc.getElementNormals());
        } else if (PsJavaView.m_bAutoNeighbour) {
            this.makeElementNormals();
        }
        if (pgJvxSrc.getVertexNormals() == null && PsJavaView.m_bAutoNeighbour) {
            this.makeVertexNormals();
        }
        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
            this.setGlobalElementNormalColor(pgJvxSrc.getGlobalElementNormalColor());
        }
        this.setGlobalElementNormalLength(pgJvxSrc.getGlobalElementNormalLength());
        this.setGlobalElementNormalSize(pgJvxSrc.getGlobalElementNormalSize());
        this.setCreaseAngle(pgJvxSrc.getCreaseAngle());
        this.setElementTextures(pgJvxSrc.getElementTextures());
        this.showElementTexture(pgJvxSrc.isShowingElementTexture());
        this.showEdges(pgJvxSrc.isShowingEdges());
        this.setEdges(pgJvxSrc.getEdges());
        this.showEdgeColors(pgJvxSrc.isShowingEdgeColors());
        this.showEdgeColorFromElements(pgJvxSrc.isShowingEdgeColorFromElements());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
            this.setGlobalEdgeTagColor(pgJvxSrc.getGlobalEdgeTagColor());
        }
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        this.setGlobalBndSize(pgJvxSrc.getGlobalBndSize());
        if (pgJvxSrc.getNumVectorFields() > 0) {
            int n2 = pgJvxSrc.getNumVectorFields();
            int n3 = 0;
            while (n3 < n2) {
                if (pgJvxSrc.isVectorElementBased(n3)) {
                    PgVectorField pgVectorField = this.getVectorField(n3);
                    PdVector[] pdVectorArray = pgJvxSrc.getVectors(n3);
                    if (pdVectorArray == null) {
                        PsDebug.warning("missing vectors in vector field[" + n3 + "].");
                        return;
                    }
                    int n4 = pdVectorArray.length;
                    pgVectorField.setGeometry(this);
                    pgVectorField.setBasedOn(1);
                    pgVectorField.setNumVectors(n4);
                    pgVectorField.setVectorColors(pgJvxSrc.getVectorFieldColors(n3));
                    pgVectorField.setVectors(pdVectorArray);
                }
                ++n3;
            }
        }
    }

    public int getNeighbourLocInd(int n, int n2, int n3) {
        int n4 = this.m_element[n].getSize();
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_element[n].m_data[n5] == n2 && this.m_element[n].m_data[(n5 + 1) % n4] == n3) {
                return (n5 + n4 - 1) % n4;
            }
            if (this.m_element[n].m_data[n5] == n3 && this.m_element[n].m_data[(n5 + 1) % n4] == n2) {
                return (n5 + n4 - 1) % n4;
            }
            ++n5;
        }
        PsDebug.error("cannot find edge (" + n2 + "," + n3 + ") in element[" + n + "]");
        return -1;
    }

    public double getCreaseAngle() {
        return this.m_creaseAngle.getValue();
    }

    public void setCreaseAngle(double d) {
        this.m_creaseAngle.setValue(d);
    }

    public boolean isShowingTaggedElements() {
        return this.m_bShowTaggedElements;
    }

    public void showTaggedElements(boolean bl) {
        this.m_bShowTaggedElements = bl;
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public void setNumElements(int n) {
        int n2;
        if (this.m_numElements == n) {
            return;
        }
        if (this.m_bInstanceSharing) {
            this.m_numElements = n;
            return;
        }
        if (n > this.m_maxNumElements || n < this.m_maxNumElements / 2 && n < this.m_maxNumElements - 100) {
            this.setMaxNumElements(n);
        } else if (n < this.m_numElements && this.m_dimOfElements == -1) {
            n2 = n;
            while (n2 < this.m_numElements) {
                this.m_element[n2].setSize(0);
                if (this.m_neighbour != null) {
                    this.m_neighbour[n2].setSize(0);
                }
                ++n2;
            }
        }
        if (this.m_neighbour != null) {
            n2 = 0;
            while (n2 < this.m_numElements) {
                int n3 = this.m_neighbour[n2].getSize() - 1;
                while (n3 >= 0) {
                    if (this.m_neighbour[n2].m_data[n3] >= n) {
                        this.m_neighbour[n2].m_data[n3] = -1;
                    }
                    --n3;
                }
                ++n2;
            }
            n2 = this.m_numElements;
            while (n2 < n) {
                this.m_neighbour[n2].setConstant(-1);
                ++n2;
            }
        }
        if ((n2 = this.getNumVectorFields()) > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n4 = 0;
            while (n4 < n2) {
                if (pgVectorFieldArray[n4].getBasedOn() == 1) {
                    pgVectorFieldArray[n4].setNumVectors(n);
                }
                ++n4;
            }
        }
        this.m_numElements = n;
    }

    public String printEdgeList() {
        PgElementEdge[] pgElementEdgeArray = this.getEdgeList();
        if (pgElementEdgeArray == null) {
            return "missing edge list";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t" + PsConfig.getMessage(33004) + " = " + pgElementEdgeArray.length + "\n");
        stringBuffer.append("\t" + PsConfig.getMessage(33005) + " = " + this.getNumVertices() + "\n");
        stringBuffer.append("\t" + PsConfig.getMessage(33006) + " = " + this.getNumElements() + "\n");
        int n = 0;
        while (n < pgElementEdgeArray.length) {
            stringBuffer.append("\t" + PsConfig.getMessage(33007) + "[" + n + "] = (" + pgElementEdgeArray[n].getEdgeInd(0) + ", " + pgElementEdgeArray[n].getEdgeInd(1) + ")");
            stringBuffer.append("   " + PsConfig.getMessage(33008) + " = {");
            int n2 = pgElementEdgeArray[n].getSize();
            stringBuffer.append(String.valueOf(pgElementEdgeArray[n].getElementInd(0)));
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append(", " + pgElementEdgeArray[n].getElementInd(n3));
                ++n3;
            }
            stringBuffer.append("}\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setElementTexturesFromList(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.getNumElementIndices()) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureElementTextures();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                this.m_elementTexture[n2][n4].copy(pdVectorArray[n++]);
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isShowingSilhouette() {
        return this.m_bShowSilhouette;
    }

    public void showSilhouette(boolean bl) {
        this.m_bShowSilhouette = bl;
    }

    public void makeTriangleBnd(int n) {
        int n2 = 3;
        this.assureBoundary(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.m_bndList[n3].setNumVertices(n);
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            this.m_bndList[0].m_vertexInd.m_data[n5] = n4;
            n4 += n - n5;
            ++n5;
        }
        n4 = 0;
        n5 = 0;
        while (n5 < n) {
            this.m_bndList[1].m_vertexInd.m_data[n5] = (n4 += n - n5) - 1;
            ++n5;
        }
        n5 = 0;
        while (n5 < n) {
            this.m_bndList[2].m_vertexInd.m_data[n5] = n - 1 - n5;
            ++n5;
        }
        n3 = 0;
        while (n3 < n2) {
            this.m_bndList[n3].makeElementInd();
            ++n3;
        }
    }

    public int addElement(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return -1;
        }
        int n = this.getNumElements();
        if (this.m_numElements == this.m_maxNumElements) {
            this.setMaxNumElements((int)((double)(this.m_numElements + 1) * 1.2));
        }
        this.setNumElements(n + 1);
        this.setElement(n, piVector);
        int n2 = piVector.getSize();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = piVector.m_data[(n3 + 1) % n2];
            int n5 = piVector.m_data[(n3 + 2) % n2];
            int n6 = 0;
            block1: while (n6 < n) {
                int n7 = this.m_element[n6].getSize();
                int n8 = this.m_element[n6].m_data[1];
                int n9 = 0;
                while (n9 < n7) {
                    int n10 = n8;
                    n8 = this.m_element[n6].m_data[(n9 + 2) % n7];
                    if (n4 == n8 && n5 == n10 || n4 == n10 && n5 == n8) {
                        this.m_neighbour[n].setEntry(n3, n6);
                        this.m_neighbour[n6].setEntry(n9, n);
                        break block1;
                    }
                    ++n9;
                }
                ++n6;
            }
            ++n3;
        }
        if (this.m_elementColor != null) {
            this.m_elementColor[n] = this.m_globalElementColor.getColor();
        }
        if (this.m_elementNormal != null) {
            this.makeElementNormal(n);
        }
        return n;
    }

    public boolean addElement(PiVector piVector, int n) {
        if (n < 0 || n > this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range.");
            return false;
        }
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return false;
        }
        int n2 = piVector.getSize();
        if (this.m_numElements == 0) {
            this.m_dimOfElements = n2;
        } else if (this.m_dimOfElements != n2) {
            this.m_dimOfElements = -1;
        }
        this.setNumElements(this.m_numElements + 1);
        if (n == this.m_numElements - 1) {
            this.m_element[this.m_numElements - 1].setSize(n2);
            this.m_element[this.m_numElements - 1].copy(piVector);
            return true;
        }
        int n3 = this.m_numElements - 2;
        while (n3 >= n) {
            this.m_element[n3 + 1].setSize(this.m_element[n3].getSize());
            this.m_element[n3 + 1].copy(this.m_element[n3]);
            --n3;
        }
        this.m_element[n].setSize(n2);
        this.m_element[n].copy(piVector);
        return true;
    }

    public boolean hasTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_element[n].hasTag(n2);
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public boolean isShowingSmoothElementColors() {
        return this.m_bShowSmoothElementColors;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor.getColor();
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor.setColor(color);
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor.getColor();
    }

    public void setGlobalElementNormalColor(Color color) {
        this.setGlobalVertexNormalColor(color);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalElementNormalColor.setColor(color);
        super.setGlobalVertexNormalColor(color);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasElementTextures()) {
            return null;
        }
        int n = this.getNumElementIndices();
        PdVector[] pdVectorArray = new PdVector[n];
        n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                pdVectorArray[n++] = this.m_elementTexture[n2][n4];
                ++n4;
            }
            ++n2;
        }
        return pdVectorArray;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize.getValue();
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize.setValue(d);
    }

    public boolean isShowingElementTextures() {
        return this.m_bShowElementTexture;
    }

    public void showSmoothElementColors(boolean bl) {
        this.m_bShowSmoothElementColors = bl;
    }

    public boolean isShowingElementFromVertexColors() {
        return this.m_bInduceElementFromVertexColors;
    }

    public void showElementFromVertexColors(boolean bl) {
        this.m_bInduceElementFromVertexColors = bl;
    }

    public void showElementLabels(boolean bl) {
        this.m_bShowElementLabels = bl;
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        if (this.m_elementTexture.length != this.m_maxNumElements) {
            PdVector[][] pdVectorArrayArray = new PdVector[this.m_maxNumElements][];
            int n = this.m_elementTexture.length;
            if (n > this.m_maxNumElements) {
                n = this.m_maxNumElements;
            }
            int n2 = 0;
            while (n2 < n) {
                pdVectorArrayArray[n2] = this.m_elementTexture[n2];
                ++n2;
            }
            this.m_elementTexture = pdVectorArrayArray;
        }
        int n = 0;
        while (n < this.m_maxNumElements) {
            this.m_elementTexture[n] = PdVector.realloc(this.m_elementTexture[n], this.m_element[n].getSize(), this.m_dimOfTextures);
            ++n;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    protected boolean makeElementNormal(int n) {
        if (this.m_dim != 3) {
            return true;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        this.m_elementNormal[n].setConstant(0.0);
        int n2 = this.m_element[n].getSize();
        if (n2 < 2) {
            return false;
        }
        PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[(-2 + n2) % n2]];
        PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(-1 + n2) % n2]];
        pdVector.sub(pdVector5, pdVector4);
        int n3 = 0;
        while (n3 < n2) {
            pdVector4 = pdVector5;
            pdVector5 = this.m_vertex[this.m_element[n].m_data[n3]];
            pdVector2.sub(pdVector5, pdVector4);
            boolean bl = pdVector3.cross(pdVector, pdVector2);
            pdVector.copyArray(pdVector2);
            if (bl && pdVector3.normalize()) {
                this.m_elementNormal[n].add(pdVector3);
            }
            ++n3;
        }
        this.m_elementNormal[n].normalize();
        return true;
    }

    public int getNumUnusedVertices() {
        int n;
        boolean[] blArray = new boolean[this.m_numVertices];
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            blArray[n2] = true;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_numElements) {
            n = this.m_element[n2].m_data.length - 1;
            while (n >= 0) {
                blArray[this.m_element[n2].m_data[n]] = false;
                --n;
            }
            ++n2;
        }
        n2 = 0;
        n = 0;
        while (n < this.m_numVertices) {
            if (blArray[n]) {
                ++n2;
            }
            ++n;
        }
        return n2;
    }

    public void setElementTextures(PdVector[][] pdVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_elementTexture = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        int n = 0;
        while (n < this.m_numElements) {
            if (pdVectorArray[n] == null || pdVectorArray[n].length != this.m_element[n].getSize()) {
                PsDebug.warning("void length of texCoords[" + n + "]");
                return;
            }
            ++n;
        }
        this.assureElementTextures();
        n = 0;
        while (n < this.m_numElements) {
            PdVector.copy(this.m_elementTexture[n], 0, pdVectorArray[n], 0, this.m_element[n].getSize());
            ++n;
        }
    }

    public double getEdgeLength(int n, int n2) {
        int[] nArray = this.m_element[n].m_data;
        double d = PdVector.dist(this.m_vertex[nArray[(n2 + 1) % nArray.length]], this.m_vertex[nArray[(n2 + 2) % nArray.length]]);
        return d;
    }

    public static PiVector getVertexValence(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumVertices();
        int n2 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PiVector piVector = new PiVector(n);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = piVectorArray[n3].getSize();
            int n5 = 0;
            while (n5 < n4) {
                if (piVectorArray2[n3].m_data[n5] <= n3) {
                    int n6 = piVectorArray[n3].m_data[(n5 + 1) % n4];
                    piVector.m_data[n6] = piVector.m_data[n6] + 1;
                    int n7 = piVectorArray[n3].m_data[(n5 + 2) % n4];
                    piVector.m_data[n7] = piVector.m_data[n7] + 1;
                }
                ++n5;
            }
            ++n3;
        }
        return piVector;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgElementSet *********\n");
        stringBuffer.append("\t m_numElements    = " + this.m_numElements + " (max = " + this.m_maxNumElements + ")\n");
        stringBuffer.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        stringBuffer.append("\t m_bConforming    = " + this.isConforming() + "\n");
        stringBuffer.append("\t ******* m_element *******\n");
        if (this.m_element != null) {
            n = 0;
            while (n < this.m_numElements) {
                stringBuffer.append("\t [" + n + "] = " + this.m_element[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_element = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            n = 0;
            while (n < this.m_numElements) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        stringBuffer.append("\t ******* m_elementNormal *******\n");
        if (this.m_elementNormal != null && this.m_numElements > 0) {
            n = 0;
            while (n < this.m_numElements) {
                stringBuffer.append("\t [" + n + "] = " + this.m_elementNormal[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_elementNormal = null\n");
        }
        stringBuffer.append("\t ******* m_elementTexture *******\n");
        if (this.m_elementTexture != null && this.m_numElements > 0) {
            n = 0;
            while (n < this.m_numElements) {
                if (this.m_elementTexture[n] == null) {
                    stringBuffer.append("\t [" + n + "] = null");
                } else {
                    int n2 = 0;
                    while (n2 < this.m_elementTexture[n].length) {
                        stringBuffer.append("\t [" + n + "][" + n2 + "] = " + this.m_elementTexture[n][n2].toShortString());
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            stringBuffer.append("\t m_elementTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public int getOppVertexInd(int n, int n2) {
        int n3 = this.getOppVertexLocInd(n, n2);
        if (n3 == -1) {
            return -1;
        }
        if (this.m_neighbour[n].m_data[n2] < 0) {
            return -1;
        }
        return this.m_element[this.m_neighbour[n].m_data[n2]].m_data[n3];
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public void showElements(boolean bl) {
        this.m_bShowElements = bl;
    }

    public int getMaxNumElements() {
        return this.m_maxNumElements;
    }

    protected void setMaxNumElements(int n) {
        int n2;
        if (this.m_maxNumElements == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumElements = n;
            return;
        }
        if (this.m_dimOfElements > -1) {
            this.m_element = PiVector.realloc(this.m_element, n, this.m_dimOfElements);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n, this.m_dimOfElements);
                n2 = this.m_maxNumElements;
                while (n2 < n) {
                    this.m_neighbour[n2].setConstant(-1);
                    ++n2;
                }
            }
        } else {
            this.m_element = PiVector.realloc(this.m_element, n);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n);
            }
        }
        this.m_maxNumElements = n;
        this.assureNeighbours();
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
        if ((n2 = this.getNumVectorFields()) > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n3 = 0;
            while (n3 < n2) {
                if (pgVectorFieldArray[n3].getBasedOn() == 1) {
                    pgVectorFieldArray[n3].setNumVectors(n);
                }
                ++n3;
            }
        }
    }

    public int getDimOfElements() {
        return this.m_dimOfElements;
    }

    public void setDimOfElements(int n) {
        if (n == this.m_dimOfElements) {
            return;
        }
        if (n != -1 && n < 3) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfElements = n;
        if (n == -1) {
            int n2 = this.m_numElements;
            while (n2 < this.m_maxNumElements) {
                this.m_element[n2].setSize(0);
                this.m_neighbour[n2].setSize(0);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.m_maxNumElements) {
                this.m_element[n3].setSize(n);
                if (this.m_neighbour[n3].getSize() != n || n3 >= this.m_numElements) {
                    this.m_neighbour[n3].setSize(n);
                    this.m_neighbour[n3].setConstant(-1);
                }
                ++n3;
            }
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public void copyElementSet(PgElementSet pgElementSet) {
        int n;
        this.setDimOfElements(pgElementSet.getDimOfElements());
        this.setNumElements(pgElementSet.getNumElements());
        this.m_bConforming = pgElementSet.m_bConforming;
        this.m_savedNumVertices = pgElementSet.m_savedNumVertices;
        if (pgElementSet.m_elementSaved != null) {
            this.m_elementSaved = PiVector.copyNew(pgElementSet.m_elementSaved, pgElementSet.m_elementSaved.length);
        }
        if (this.m_dimOfElements == -1) {
            PiVector.adjustSizes(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        }
        PiVector.copy(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray != null) {
            if (this.m_dimOfElements == -1) {
                n = 0;
                while (n < this.m_numElements) {
                    this.m_neighbour[n].setSize(pgElementSet.getNeighbour(n).getSize());
                    ++n;
                }
            }
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
        } else {
            this.m_neighbour = null;
        }
        if (pgElementSet.m_edge != null) {
            this.setNumEdges(pgElementSet.getNumEdges());
            PiVector.copy(this.m_edge, 0, pgElementSet.getEdges(), 0, this.m_numEdges);
        } else {
            this.m_edge = null;
        }
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, 0, pgElementSet.getElementNormals(), 0, this.m_numElements);
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy(this.m_elementColor, 0, pgElementSet.getElementColors(), 0, this.m_numElements);
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null) {
            this.assureElementBackColors();
            PdColor.copy(this.m_elementBackColor, 0, pgElementSet.getElementBackColors(), 0, this.m_numElements);
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            n = 0;
            while (n < this.m_numElements) {
                PdVector.copy(this.m_elementTexture[n], 0, pgElementSet.m_elementTexture[n], 0, pgElementSet.m_elementTexture[n].length);
                ++n;
            }
        } else {
            this.m_elementTexture = null;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            this.assureBoundary(pgBndPolygonArray.length);
            int n2 = 0;
            while (n2 < this.m_bndList.length) {
                this.m_bndList[n2].copy(pgBndPolygonArray[n2]);
                ++n2;
            }
            return;
        }
        this.m_bndList = null;
    }

    public boolean assureDimOfElements() {
        int n = PiVector.getSameSize(this.m_element, this.m_numElements);
        if (n != this.m_dimOfElements) {
            this.setDimOfElements(n);
            return false;
        }
        return true;
    }

    public int[] removeMarkedElements() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numElements);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        int n5 = 0;
        while (n5 < this.m_numElements) {
            if (!this.m_element[n5].hasTag(2)) {
                nArray[n5] = n3;
            }
            ++n5;
        }
        int n6 = 0;
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] == n3) {
                nArray[n5] = n6++;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] != n4) {
                n2 = 0;
                while (n2 < this.m_element[n5].m_data.length) {
                    if (this.m_neighbour[n5].m_data[n2] > -1) {
                        this.m_neighbour[n5].m_data[n2] = nArray[this.m_neighbour[n5].m_data[n2]];
                    }
                    ++n2;
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] != n4 && nArray[n5] < n5) {
                this.m_element[nArray[n5]].setSize(this.m_element[n5].getSize());
                this.m_element[nArray[n5]].copy(this.m_element[n5]);
                this.m_neighbour[nArray[n5]].setSize(this.m_neighbour[n5].getSize());
                this.m_neighbour[nArray[n5]].copy(this.m_neighbour[n5]);
            }
            ++n5;
        }
        if (this.m_elementNormal != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementNormal[nArray[n5]].setSize(this.m_elementNormal[n5].getSize());
                    this.m_elementNormal[nArray[n5]].copy(this.m_elementNormal[n5]);
                }
                ++n5;
            }
        }
        if (this.m_elementColor != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementColor[nArray[n5]] = this.m_elementColor[n5];
                }
                ++n5;
            }
        }
        if (this.m_elementBackColor != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementBackColor[nArray[n5]] = this.m_elementBackColor[n5];
                }
                ++n5;
            }
        }
        if (this.m_elementTexture != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementTexture[nArray[n5]] = PdVector.copyNew(this.m_elementTexture[n5]);
                }
                ++n5;
            }
        }
        if (this.m_bndList != null) {
            n = 0;
            n5 = 0;
            while (n5 < this.m_bndList.length) {
                if (!this.m_bndList[n5].hasTag(2)) {
                    int n7 = this.m_bndList[n5].getNumElements();
                    int n8 = 0;
                    n2 = 0;
                    while (n2 < n7) {
                        if (nArray[this.m_bndList[n5].m_elementInd.m_data[n2]] == n4) {
                            if (this.isConforming()) {
                                this.m_bndList[n5].setTag(2);
                                n = 1;
                                break;
                            }
                        } else {
                            this.m_bndList[n5].m_elementInd.m_data[n8++] = nArray[this.m_bndList[n5].m_elementInd.m_data[n2]];
                        }
                        ++n2;
                    }
                }
                ++n5;
            }
            if (n != 0) {
                this.removeDeletedBoundaries();
            }
        }
        n = this.getNumVectorFields();
        n5 = 0;
        while (n5 < n) {
            PgVectorField pgVectorField = this.getVectorField(n5);
            if (pgVectorField.getBasedOn() != 0) {
                n2 = 0;
                while (n2 < this.m_numElements) {
                    if (nArray[n2] != n4 && nArray[n2] < n2) {
                        pgVectorField.setVector(nArray[n2], pgVectorField.getVector(n2));
                    }
                    ++n2;
                }
                pgVectorField.setNumVectors(n6);
            }
            ++n5;
        }
        this.setNumElements(n6);
        this.setMaxNumElements(n6);
        return nArray;
    }

    public void setElements(PiVector[] piVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_element = piVectorArray;
            return;
        }
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        int n = 0;
        int n2 = piVectorArray[0].getSize();
        if (n2 < 3) {
            n2 = -1;
        }
        int n3 = 0;
        while (n3 < this.m_numElements) {
            int n4 = piVectorArray[n3].getSize();
            if (n4 > this.m_maxDimOfElements) {
                n = n4;
                n4 = this.m_maxDimOfElements;
            }
            if (n4 != this.m_element[n3].getSize()) {
                this.m_element[n3].setSize(n4);
                if (this.m_neighbour != null) {
                    this.m_neighbour[n3].setSize(n4);
                }
            }
            if (n2 != -1 && n4 != n2) {
                n2 = -1;
            }
            ++n3;
        }
        if (this.m_dimOfElements != n2) {
            this.setDimOfElements(n2);
        }
        PiVector.copy(this.m_element, 0, piVectorArray, 0, this.m_numElements);
        if (n > 0) {
            PsDebug.error("maximal dimension of an element = " + n + " truncated to size = " + this.m_maxDimOfElements);
        }
    }

    public double getVolume() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            d += this.getVolumeOfElement(n);
            ++n;
        }
        return d;
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeTorus(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgElementSet)) {
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)psObject;
        this.copyElementSet(pgElementSet);
        int n = this.getNumVectorFields();
        int n2 = 0;
        while (n2 < n) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setGeometry(this);
            }
            ++n2;
        }
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCylinder(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgBndPolygon[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
            return this.m_bndList;
        }
        this.removeDeletedBoundaries();
        return this.m_bndList;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void flipOrientation() {
        super.flipOrientation();
        int n = 100;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < this.m_numElements) {
            this.m_element[n2].invert();
            int n3 = this.m_element[n2].m_data.length;
            if (n3 > n) {
                n = 2 * n3;
                nArray = new int[n];
            }
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = this.m_neighbour[n2].m_data[n4];
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                this.m_neighbour[n2].m_data[n4] = nArray[(n3 - 4 - n4 + n3) % n3];
                ++n4;
            }
            ++n2;
        }
        if (this.m_elementNormal != null) {
            n2 = 0;
            while (n2 < this.m_numElements) {
                this.m_elementNormal[n2].multScalar(-1.0);
                ++n2;
            }
        }
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor.getColor();
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor.getColor();
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor.setColor(color);
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor.setColor(color);
    }

    public int getElementWithVertex(int n) {
        int n2 = 0;
        while (n2 < this.m_numElements) {
            if (this.m_element[n2].getIndexOf(n) > -1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        boolean bl2;
        int n;
        int n2;
        int n3 = this.m_numVertices;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
        if (this.m_numElements == 0) {
            this.setDimOfElements(pgElementSet.m_dimOfElements);
        } else if (pgElementSet.m_dimOfElements != this.m_dimOfElements) {
            this.setDimOfElements(-1);
        }
        int n4 = this.m_numElements;
        int n5 = this.m_numElements + pgElementSet.m_numElements;
        this.setNumElements(n5);
        PiVector.copy(this.m_element, n4, pgElementSet.m_element, 0, pgElementSet.m_numElements);
        int n6 = 0;
        while (n6 < pgElementSet.m_numElements) {
            n2 = pgElementSet.m_element[n6].getSize();
            if (this.m_dimOfElements == -1) {
                this.m_element[n4 + n6].setSize(n2);
            }
            n = 0;
            while (n < n2) {
                int n7 = n++;
                this.m_element[n4 + n6].m_data[n7] = this.m_element[n4 + n6].m_data[n7] + n3;
            }
            ++n6;
        }
        if (pgElementSet.m_neighbour != null) {
            PiVector.copy(this.m_neighbour, n4, pgElementSet.m_neighbour, 0, pgElementSet.m_numElements);
            n6 = 0;
            while (n6 < pgElementSet.m_numElements) {
                n2 = pgElementSet.m_element[n6].getSize();
                if (this.m_dimOfElements == -1) {
                    this.m_neighbour[n4 + n6].setSize(n2);
                }
                n = 0;
                while (n < n2) {
                    if (pgElementSet.m_neighbour[n6].m_data[n] > -1) {
                        int n8 = n;
                        this.m_neighbour[n4 + n6].m_data[n8] = this.m_neighbour[n4 + n6].m_data[n8] + n4;
                    }
                    ++n;
                }
                ++n6;
            }
        }
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, n4, pgElementSet.m_elementNormal, 0, pgElementSet.m_numElements);
        }
        Color color = this.getGlobalElementColor();
        Color color2 = pgElementSet.getGlobalElementColor();
        boolean bl3 = color.getRGB() != color2.getRGB() || this.hasElementColors() || pgElementSet.hasElementColors();
        boolean bl4 = color.getRGB() == color2.getRGB() && !this.isShowingElementColors() && !pgElementSet.isShowingElementColors();
        boolean bl5 = bl3 && !this.isShowingElementColors();
        boolean bl6 = bl2 = bl3 && !pgElementSet.isShowingElementColors();
        if (!bl4) {
            this.showElementColors(true);
        }
        if (bl3) {
            this.assureElementColors();
            if (bl5) {
                n6 = 0;
                while (n6 < n4) {
                    this.setElementColor(n6, color);
                    ++n6;
                }
            }
            if (bl2) {
                n6 = n4;
                while (n6 < n5) {
                    this.setElementColor(n6, color2);
                    ++n6;
                }
            } else {
                PdColor.copy(this.m_elementColor, n4, pgElementSet.m_elementColor, 0, pgElementSet.m_numElements);
            }
        }
        Color color3 = this.getGlobalElementBackColor();
        Color color4 = pgElementSet.getGlobalElementBackColor();
        boolean bl7 = color3.getRGB() != color4.getRGB() || this.hasElementBackColors() || pgElementSet.hasElementBackColors();
        boolean bl8 = color3.getRGB() == color4.getRGB() && !this.isShowingElementBackColors() && !pgElementSet.isShowingElementBackColors();
        boolean bl9 = bl3 && !this.isShowingElementBackColors();
        boolean bl10 = bl = bl3 && !pgElementSet.isShowingElementBackColors();
        if (!bl8) {
            this.showElementBackColors(true);
        }
        if (bl7) {
            this.assureElementBackColors();
            if (bl9) {
                n6 = 0;
                while (n6 < n4) {
                    this.setElementBackColor(n6, color3);
                    ++n6;
                }
            }
            if (bl) {
                n6 = n4;
                while (n6 < n5) {
                    this.setElementBackColor(n6, color4);
                    ++n6;
                }
            } else {
                PdColor.copy(this.m_elementBackColor, n4, pgElementSet.m_elementBackColor, 0, pgElementSet.m_numElements);
            }
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            n6 = 0;
            while (n6 < pgElementSet.m_numElements) {
                n2 = pgElementSet.m_element[n6].getSize();
                PdVector.copy(this.m_elementTexture[n4 + n6], 0, pgElementSet.m_elementTexture[n6], 0, n2);
                ++n6;
            }
        }
        if (pgElementSet.m_bndList != null) {
            PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
            this.m_bndList = new PgBndPolygon[pgBndPolygonArray.length + pgElementSet.m_bndList.length];
            n6 = 0;
            while (n6 < pgBndPolygonArray.length) {
                this.m_bndList[n6] = pgBndPolygonArray[n6];
                ++n6;
            }
            n6 = 0;
            while (n6 < pgElementSet.m_bndList.length) {
                this.m_bndList[pgBndPolygonArray.length + n6] = pgElementSet.m_bndList[n6];
                ++n6;
            }
            n6 = pgBndPolygonArray.length;
            while (n6 < this.m_bndList.length) {
                if (this.m_bndList[n6].m_vertexInd != null) {
                    n = 0;
                    while (n < this.m_bndList[n6].m_numVertices) {
                        int n9 = n++;
                        this.m_bndList[n6].m_vertexInd.m_data[n9] = this.m_bndList[n6].m_vertexInd.m_data[n9] + n3;
                    }
                }
                if (this.m_bndList[n6].m_elementInd != null) {
                    n = 0;
                    while (n < this.m_bndList[n6].m_numVertices - 1) {
                        int n10 = n++;
                        this.m_bndList[n6].m_elementInd.m_data[n10] = this.m_bndList[n6].m_elementInd.m_data[n10] + n4;
                    }
                }
                this.m_bndList[n6].m_triang = this;
                this.m_bndList[n6].assignVertices();
                ++n6;
            }
        }
        return true;
    }

    public void copyConnectivity(PgElementSet pgElementSet) {
        this.setDimOfElements(pgElementSet.getDimOfElements());
        this.setNumElements(pgElementSet.getNumElements());
        this.m_bConforming = pgElementSet.m_bConforming;
        PiVector.copy(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
        }
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeDisk(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public int getDimOfElement(int n) {
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return -1;
        }
        return this.m_element[n].getSize();
    }

    public void setDimOfElement(int n, int n2) {
        if (this.m_dimOfElements == n2) {
            return;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return;
        }
        if (n2 < 3) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(n2);
        } else if (this.m_dimOfElements != -1) {
            this.setDimOfElements(-1);
        }
        this.m_element[n].setSize(n2);
        this.m_neighbour[n].setSize(n2);
        this.m_neighbour[n].setConstant(-1);
        if (this.m_elementTexture != null) {
            this.m_elementTexture[n] = PdVector.realloc(this.m_elementTexture[n], n2, this.m_dimOfTextures);
        }
    }

    public void clearTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].clearTag(n2);
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_element[n];
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    protected void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            n = 0;
            while (n < this.m_maxNumElements) {
                if (this.m_neighbour[n].m_data == null || this.m_element[n].m_data == null || this.m_neighbour[n].m_data.length != this.m_element[n].m_data.length) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setSize(this.m_element[n].getSize());
                ++n;
            }
        }
        if (bl) {
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setConstant(-1);
                ++n;
            }
        }
    }

    public void setElement(int n, int n2, int n3, int n4) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 3);
        this.m_element[n].set(n2, n3, n4);
    }

    public void setElement(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 4);
        this.m_element[n].set(n2, n3, n4, n5);
    }

    public boolean setElement(int n, int[] nArray) {
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        int n2 = nArray.length;
        this.setDimOfElement(n, n2);
        this.m_element[n].copy(nArray, n2);
        return true;
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " > " + this.m_numElements + "=m_numElements, bad programming style");
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, piVector.getSize());
        this.m_element[n].copy(piVector);
        return true;
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_neighbour = piVectorArray;
            return;
        }
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        int n = 0;
        while (n < this.m_numElements) {
            this.m_neighbour[n].setSize(piVectorArray[n].getSize());
            ++n;
        }
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    public void setEdges(PiVector[] piVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_edge = piVectorArray;
            return;
        }
        if (piVectorArray == null) {
            this.m_edge = null;
            this.m_numEdges = 0;
            return;
        }
        if (piVectorArray.length < this.m_numEdges) {
            PsDebug.warning("edge array too small");
            return;
        }
        PiVector.copy(this.m_edge, 0, piVectorArray, 0, this.m_numEdges);
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public int getNumElementIndices() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements * this.m_numElements;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            n += this.m_element[n2].getSize();
            ++n2;
        }
        return n;
    }

    public void setDimOfVertices(int n) {
        if (this.m_elementNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumElements) {
                this.m_elementNormal[n2].setSize(n);
                ++n2;
            }
        }
        super.setDimOfVertices(n);
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        int n4 = 0;
        while (n4 < this.m_numElements) {
            n = 0;
            while (n < this.m_element[n4].m_data.length) {
                nArray[this.m_element[n4].m_data[n]] = n2;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n2) {
                nArray[n4] = n5++;
            }
            ++n4;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n3 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]] = this.m_vertex[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numElements) {
            n = 0;
            while (n < this.m_element[n4].m_data.length) {
                this.m_element[n4].m_data[n] = nArray[this.m_element[n4].m_data[n]];
                ++n;
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]] = this.m_vertexNormal[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexTexture != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexTexture[nArray[n4]] = this.m_vertexTexture[n4];
                }
                ++n4;
            }
        }
        int n6 = this.getNumVectorFields();
        n4 = 0;
        while (n4 < n6) {
            PgVectorField pgVectorField = this.getVectorField(n4);
            if (pgVectorField.getBasedOn() != 1) {
                n = 0;
                while (n < this.m_numVertices) {
                    if (nArray[n] != n3 && nArray[n] < n) {
                        pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
                    }
                    ++n;
                }
                pgVectorField.setNumVectors(n5);
            }
            ++n4;
        }
        if (this.m_bndList != null) {
            n4 = 0;
            while (n4 < this.m_bndList.length) {
                if (!this.m_bndList[n4].hasTag(2)) {
                    int n7 = this.m_bndList[n4].getNumVertices();
                    boolean bl = true;
                    n = 0;
                    while (n < n7) {
                        if (this.m_bndList[n4].m_vertexInd.m_data[n] == -1 || this.m_bndList[n4].m_vertexInd.m_data[n] >= this.m_numVertices) {
                            this.m_bndList[n4].setTag(2);
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                    if (bl) {
                        n = 0;
                        while (n < n7) {
                            this.m_bndList[n4].m_vertexInd.m_data[n] = nArray[this.m_bndList[n4].m_vertexInd.m_data[n]];
                            ++n;
                        }
                        this.m_bndList[n4].assignVertices();
                    }
                }
                ++n4;
            }
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalBndColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndSize) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_globalElementColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementBackColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalSize) {
            return super.update(null);
        }
        if (object == this.m_creaseAngle) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            this.m_globalElementNormalColor.copy(this.m_globalVertexNormalColor);
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalLength) {
            this.m_globalElementNormalLength.copy(this.m_globalVertexNormalLength);
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalSize) {
            this.m_globalElementNormalSize.copy(this.m_globalVertexNormalSize);
            return super.update(object);
        }
        return super.update(object);
    }

    public int[] removeMarkedVertices() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = -1;
        int[] nArray = super.removeMarkedVertices();
        if (!this.isConforming()) {
            n4 = 0;
            while (n4 < this.m_numElements) {
                n3 = this.m_element[n4].getSize() - 1;
                while (n3 >= 0) {
                    if (nArray[this.m_element[n4].m_data[n3]] == n5) {
                        n2 = this.m_neighbour[n4].m_data[(n3 + 1) % 3];
                        n = this.m_neighbour[n4].m_data[(n3 + 2) % 3];
                        int n6 = this.getOppVertexLocInd(n4, (n3 + 1) % 3);
                        int n7 = this.getOppVertexLocInd(n4, (n3 + 2) % 3);
                        if (n6 == -1 || n7 == -1) break;
                        this.m_element[n].m_data[n7] = this.m_element[n2].m_data[n6];
                        this.m_neighbour[n2].m_data[n6] = n;
                        this.m_neighbour[n].m_data[n7] = n2;
                        break;
                    }
                    --n3;
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < this.m_numElements) {
            n3 = this.m_element[n4].getSize() - 1;
            while (n3 >= 0) {
                if (nArray[this.m_element[n4].m_data[n3]] == n5) {
                    this.m_element[n4].setTag(2);
                    break;
                }
                this.m_element[n4].m_data[n3] = nArray[this.m_element[n4].m_data[n3]];
                --n3;
            }
            ++n4;
        }
        if (this.m_bndList != null) {
            n4 = 0;
            while (n4 < this.m_bndList.length) {
                if (!this.m_bndList[n4].hasTag(2)) {
                    n3 = this.m_bndList[n4].getNumVertices();
                    n2 = 0;
                    n = 0;
                    while (n < n3) {
                        if (nArray[this.m_bndList[n4].m_vertexInd.m_data[n]] != n5) {
                            this.m_bndList[n4].m_vertexInd.m_data[n2++] = nArray[this.m_bndList[n4].m_vertexInd.m_data[n]];
                        }
                        ++n;
                    }
                    if (n2 < n3) {
                        this.m_bndList[n4].setNumVertices(n2);
                    }
                }
                ++n4;
            }
        }
        this.removeMarkedElements();
        return nArray;
    }

    public PdVector[] getElementVertices(int n) {
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("elemInd out of bounds, elemInd = " + n);
            return null;
        }
        if (this.m_element[n].getSize() == 0) {
            return null;
        }
        int n2 = this.m_element[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_element[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public boolean setElementVertices(int n, PdVector[] pdVectorArray) {
        PiVector piVector = this.m_element[n];
        int n2 = piVector.getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("element and array have different length");
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.setVertex(piVector.m_data[n2], pdVectorArray[n2]);
            --n2;
        }
        return true;
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            PsDebug.error("missing neighbour variable");
            return -2;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_element[n].getSize();
        int n5 = this.m_element[n].m_data[(n2 + 1) % n4];
        int n6 = this.m_element[n].m_data[(n2 + 2) % n4];
        int n7 = this.m_neighbour[n3].getSize();
        if (this.m_bConforming) {
            int n8 = 0;
            while (n8 < n7) {
                if (this.m_neighbour[n3].m_data[n8] == n && (n5 == this.m_element[n3].m_data[(n8 + 2) % n7] && n6 == this.m_element[n3].m_data[(n8 + 1) % n7] || n5 == this.m_element[n3].m_data[(n8 + 1) % n7] && n6 == this.m_element[n3].m_data[(n8 + 2) % n7])) {
                    return n8;
                }
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < n7) {
                if (this.m_neighbour[n3].m_data[n9] == n) {
                    return n9;
                }
                ++n9;
            }
        }
        PsDebug.error("error in neighbour connectivity");
        return -2;
    }

    public double getL2Norm() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            PdVector[] pdVectorArray = this.getElementVertices(n);
            double d2 = 0.0;
            int n2 = this.m_element[n].getSize();
            int n3 = 1;
            while (n3 < n2 - 1) {
                d2 += pdVectorArray[0].sqrLength() + PdVector.dot(pdVectorArray[0], pdVectorArray[n3]);
                d2 += pdVectorArray[n3].sqrLength() + PdVector.dot(pdVectorArray[n3], pdVectorArray[n3 + 1]);
                double d3 = PdVector.area(pdVectorArray[0], pdVectorArray[n3], pdVectorArray[n3 + 1]);
                d += 2.0 * d3 * (d2 += pdVectorArray[n3 + 1].sqrLength() + PdVector.dot(pdVectorArray[n3 + 1], pdVectorArray[0])) / 12.0;
                ++n3;
            }
            ++n;
        }
        return d;
    }

    public boolean hasEdges() {
        return this.m_edge != null;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n = 0;
        while (n < this.m_dim) {
            if (dArray[n] < 1.0E-10) {
                dArray[n] = 1.0;
            }
            ++n;
        }
        n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n2].m_data), pdVectorArray[0]);
            int n3 = 0;
            while (n3 < n) {
                fArray[n3] = (float)(pdVector.m_data[n3] / dArray[n3]);
                ++n3;
            }
            if (n == 1) {
                colorArray[n2] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n2] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n == 3) {
                colorArray[n2] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n2;
        }
        return true;
    }

    public void removeBoundaries() {
        if (this.m_bndList == null) {
            return;
        }
        int n = 0;
        while (n < this.m_bndList.length) {
            this.m_bndList[n].setElementSet(null);
            ++n;
        }
        this.m_bndList = null;
    }

    public int removeDeletedBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_bndList.length) {
            if (!this.m_bndList[n2].hasTag(2)) {
                ++n;
            }
            ++n2;
        }
        if (n == this.m_bndList.length) {
            return 0;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_bndList;
        this.m_bndList = new PgBndPolygon[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < pgBndPolygonArray.length) {
            if (pgBndPolygonArray[n4].hasTag(2)) {
                pgBndPolygonArray[n4].setElementSet(null);
            } else {
                this.m_bndList[n3++] = pgBndPolygonArray[n4];
            }
            ++n4;
        }
        return pgBndPolygonArray.length - n;
    }

    public boolean isShowingEdgeColorFromElements() {
        return this.m_bShowEdgeColorFromElements;
    }

    public void showEdgeColorFromElements(boolean bl) {
        this.m_bShowEdgeColorFromElements = bl;
    }

    public void makeCylinderConn(int n, int n2) {
        if (n < 1 || n2 <= 1) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * (n - 1) * n2);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                int n5 = 0;
                while (n5 < n2 - 1) {
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                    this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                    ++n5;
                }
                this.m_element[n3++].set(n4 * n2 + n2 - 1, (n4 + 1) * n2 + n2 - 1, n4 * n2);
                this.m_element[n3++].set(n4 * n2, (n4 + 1) * n2 + n2 - 1, (n4 + 1) * n2);
                ++n4;
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements((n - 1) * n2);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n - 1) {
                int n8 = 0;
                while (n8 < n2 - 1) {
                    this.m_element[n6++].set(n7 * n2 + n8, (n7 + 1) * n2 + n8, (n7 + 1) * n2 + n8 + 1, n7 * n2 + n8 + 1);
                    ++n8;
                }
                this.m_element[n6++].set(n7 * n2 + n2 - 1, (n7 + 1) * n2 + n2 - 1, (n7 + 1) * n2, n7 * n2);
                ++n7;
            }
        }
        this.makeNeighbour();
    }

    public void makeQuadrBnd(int n, int n2) {
        int n3;
        int n4 = 4;
        this.assureBoundary(n4);
        this.m_bndList[0].setNumVertices(n);
        this.m_bndList[1].setNumVertices(n2);
        this.m_bndList[2].setNumVertices(n);
        this.m_bndList[3].setNumVertices(n2);
        int n5 = 0;
        while (n5 < n) {
            this.m_bndList[0].m_vertexInd.m_data[n5] = n5 * n2;
            this.m_bndList[2].m_vertexInd.m_data[n5] = (n - n5) * n2 - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            this.m_bndList[3].m_vertexInd.m_data[n6] = n2 - 1 - n6;
            this.m_bndList[1].m_vertexInd.m_data[n6] = (n - 1) * n2 + n6;
            ++n6;
        }
        if (this.m_dimOfElements == 3) {
            n3 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[0].m_elementInd.m_data[n5] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n5] = 2;
                n3 += 2 * (n2 - 1);
                ++n5;
            }
            n3 = 2 * (n - 2) * (n2 - 1) + 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[1].m_elementInd.m_data[n5] = n3;
                this.m_bndList[1].m_neighbourLocInd.m_data[n5] = 0;
                n3 += 2;
                ++n5;
            }
            n3 = 2 * (n - 1) * (n2 - 1) - 1;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[2].m_elementInd.m_data[n5] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= 2 * (n2 - 1);
                ++n5;
            }
            n3 = 2 * (n2 - 1) - 2;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[3].m_elementInd.m_data[n5] = n3;
                this.m_bndList[3].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= 2;
                ++n5;
            }
        } else {
            n3 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[0].m_elementInd.m_data[n5] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n5] = 3;
                n3 += n2 - 1;
                ++n5;
            }
            n3 = (n - 2) * (n2 - 1);
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[1].m_elementInd.m_data[n5] = n3++;
                this.m_bndList[1].m_neighbourLocInd.m_data[n5] = 0;
                ++n5;
            }
            n3 = (n - 1) * (n2 - 1) - 1;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[2].m_elementInd.m_data[n5] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= n2 - 1;
                ++n5;
            }
            n3 = n2 - 1 - 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[3].m_elementInd.m_data[n5] = n3--;
                this.m_bndList[3].m_neighbourLocInd.m_data[n5] = 2;
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < n4) {
            this.m_bndList[n5].assignVertices();
            ++n5;
        }
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public boolean hasBoundary() {
        return this.getNumBoundaries() > 0;
    }

    public void showElementBackColors(boolean bl) {
        this.m_bShowElementBackColors = bl;
    }

    public boolean hasElementColors() {
        return this.m_elementColor != null && this.m_elementColor.length == this.m_maxNumElements;
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void makeTriangleConn(int n) {
        if (n < 1) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        this.setDimOfElements(3);
        this.setNumElements((n - 1) * (n - 1));
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n - 1 - n4) {
                this.m_element[n2++].set(n3 + n5, n3 + (n - n4) + n5, n3 + n5 + 1);
                if (n5 != n - 2 - n4) {
                    this.m_element[n2++].set(n3 + n5 + 1, n3 + (n - n4) + n5, n3 + (n - n4) + n5 + 1);
                }
                ++n5;
            }
            n3 += n - n4;
            ++n4;
        }
        this.makeNeighbour();
    }

    public void removeElementColors() {
        this.setElementColors(null);
    }

    public void setElementBackColors(Color[] colorArray) {
        if (this.m_bInstanceSharing) {
            this.m_elementBackColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementBackColor == null || this.m_numElements > this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        PdColor.copy(this.m_elementBackColor, 0, colorArray, 0, this.m_numElements);
    }

    public void fixBoundaries() {
        PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
        if (pgBndPolygonArray == null) {
            return;
        }
        int n = 0;
        while (n < pgBndPolygonArray.length) {
            if (pgBndPolygonArray[n] != null) {
                PgBndConstraint pgBndConstraint = new PgBndConstraint(this.getDimOfVertices());
                pgBndConstraint.setShape(3);
                pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            }
            ++n;
        }
    }

    public boolean checkNeighbour() {
        return this.checkNeighbour(true);
    }

    public boolean checkNeighbour(boolean bl) {
        if (this.m_neighbour == null) {
            PsDebug.warning("missing neighbour information");
            return false;
        }
        int n = -1;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < this.m_numElements) {
            if (!bl2 && stringBuffer.length() > 50000) {
                stringBuffer.append("---- message exceeded max message size, message truncated -----\n");
                break;
            }
            int n3 = this.m_element[n2].getSize();
            if (n3 != this.m_neighbour[n2].getSize()) {
                bl2 = false;
                stringBuffer.append(PsConfig.getMessage(33009) + "\n");
                stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n2 + " " + PsConfig.getMessage(33011) + " = " + n3 + "\n");
                stringBuffer.append("\t" + PsConfig.getMessage(33012) + " = " + this.m_neighbour[n2].getSize() + "\n");
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.m_neighbour[n2].m_data[n4];
                if (n5 != -1) {
                    int n6;
                    if (n5 == n2) {
                        bl2 = false;
                        stringBuffer.append("element has itself as neighbour\n");
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n2 + " " + PsConfig.getMessage(33013) + " = " + this.m_element[n2].m_data[n4] + "\n");
                        n6 = 0;
                        while (n6 < n3) {
                            stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", neighbour[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                            ++n6;
                        }
                    } else if (n5 >= this.m_numElements) {
                        bl2 = false;
                        stringBuffer.append(PsConfig.getMessage(33014) + "\n");
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n2 + " " + PsConfig.getMessage(33013) + " = " + this.m_element[n2].m_data[n4] + " >= m_numElements.\n");
                        n6 = 0;
                        while (n6 < n3) {
                            stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", neighbour[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                            ++n6;
                        }
                    } else {
                        int n7 = this.m_neighbour[n5].getSize();
                        boolean bl3 = false;
                        int n8 = 0;
                        while (n8 < n7) {
                            if (this.m_neighbour[n5].m_data[n8] == n2 && (this.m_element[n2].m_data[(n4 + 1) % n3] == this.m_element[n5].m_data[(n8 + 2) % n7] && this.m_element[n2].m_data[(n4 + 2) % n3] == this.m_element[n5].m_data[(n8 + 1) % n7] || this.m_element[n2].m_data[(n4 + 1) % n3] == this.m_element[n5].m_data[(n8 + 1) % n7] && this.m_element[n2].m_data[(n4 + 2) % n3] == this.m_element[n5].m_data[(n8 + 2) % n7])) {
                                bl3 = true;
                                n = n8;
                                break;
                            }
                            ++n8;
                        }
                        if (!bl3) {
                            bl2 = false;
                            stringBuffer.append(PsConfig.getMessage(33015) + "\n");
                            stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n2 + " " + PsConfig.getMessage(33013) + " = " + this.m_element[n2].m_data[n4] + "\n");
                            n6 = 0;
                            while (n6 < n3) {
                                stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", " + PsConfig.getMessage(33016) + "[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                                ++n6;
                            }
                            if (bl3) {
                                stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n5 + " " + PsConfig.getMessage(33013) + " = " + this.m_element[n5].m_data[n] + "\n");
                            } else {
                                stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n5 + " " + PsConfig.getMessage(33017) + "\n");
                            }
                            n6 = 0;
                            while (n6 < n7) {
                                stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n5 + "][" + n6 + "] = " + this.m_element[n5].m_data[n6] + ", " + PsConfig.getMessage(33016) + "[" + n5 + "][" + n6 + "] = " + this.m_neighbour[n5].m_data[n6] + "\n");
                                ++n6;
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (bl) {
            if (!bl2) {
                PsDebug.message(stringBuffer.toString());
            } else {
                PsDebug.message(PsConfig.getMessage(33018));
            }
        }
        return bl2;
    }

    public boolean close() {
        int n;
        if (this.m_bndList == null || this.m_bndList.length == 0) {
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.warning("less than 2 vertices in " + this.getName());
            return false;
        }
        double d = 0.01;
        boolean bl = true;
        int n2 = this.m_bndList.length;
        double[] dArray = new double[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                ++n3;
                dArray[n4] = this.m_bndList[n4].getLength();
                if (dArray[n4] > 1.0) {
                    dArray[n4] = 1.0;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                n = n4 + 1;
                while (n < n2) {
                    int n5;
                    if (!this.m_bndList[n].hasTag(2) && (n5 = this.m_bndList[n4].bndcmp(this.m_bndList[n], Math.min(dArray[n4], dArray[n]) * d)) != 0) {
                        this.m_bndList[n4].bnd_id(this.m_bndList[n], n5);
                        this.m_bndList[n4].setTag(2);
                        this.m_bndList[n].setTag(2);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        if (bl) {
            n4 = 0;
            while (n4 < n2) {
                if (!this.m_bndList[n4].hasTag(2) && this.m_bndList[n4].bndtst(d) == 1) {
                    this.m_bndList[n4].bnd_shrink();
                    this.m_bndList[n4].setTag(2);
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.m_bndList[n4] != null && !this.m_bndList[n4].hasTag(2)) {
                this.m_bndList[n4].assignVertices();
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                n = 0;
                while (n < n4) {
                    int n6;
                    if (!this.m_bndList[n].hasTag(2) && (n6 = this.m_bndList[n4].bnd_cmp_paste(this.m_bndList[n], Math.min(dArray[n4], dArray[n]) * d)) != 0 && this.m_bndList[n4].bnd_paste(this.m_bndList[n], n6)) {
                        this.m_bndList[n].setTag(2);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.m_bndList[n4] != null && !this.m_bndList[n4].hasTag(2)) {
                this.m_bndList[n4].assignVertices();
            }
            ++n4;
        }
        int n7 = this.removeDeletedBoundaries();
        if (n7 > 0) {
            // empty if block
        }
        this.removeUnusedVertices();
        return true;
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeRotation(pgPolygon, n);
        int n2 = pgPolygon.getNumVertices();
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public PiVector[] getSavedElements() {
        return this.m_elementSaved;
    }

    public void setSavedElements(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_elementSaved = null;
            return;
        }
        if (this.m_elementSaved == null) {
            this.m_elementSaved = PiVector.copyNew(piVectorArray, this.m_numElements);
            return;
        }
        this.m_elementSaved = PiVector.realloc(this.m_elementSaved, piVectorArray.length);
        PiVector.copy(this.m_elementSaved, 0, piVectorArray, 0, piVectorArray.length);
    }

    public boolean makeElementColorsFromZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n2 = 0;
        while (n2 < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n2].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n2] = new Color(f2, 0.0f, 1.0f - f2);
            ++n2;
        }
        return true;
    }

    public boolean makeElementColorsFromZHue() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n2 = 0;
        while (n2 < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n2].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n2] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public boolean hasElementBackColors() {
        return this.m_elementBackColor != null && this.m_elementBackColor.length == this.m_maxNumElements;
    }

    public void removeElementBackColors() {
        this.setElementBackColors(null);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgElementSet) || !(pgGeometry2 instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        PgElementSet pgElementSet2 = (PgElementSet)pgGeometry2;
        if (pgElementSet.m_numElements != pgElementSet2.m_numElements) {
            PsDebug.warning("unequal number of elements");
            return false;
        }
        PgElementSet pgElementSet3 = d > 0.5 ? pgElementSet : pgElementSet2;
        this.m_bShowEdgeLabels = pgElementSet3.m_bShowEdgeLabels;
        this.m_bShowElementLabels = pgElementSet3.m_bShowElementLabels;
        this.m_bShowBoundaries = pgElementSet3.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgElementSet3.m_bShowTaggedBoundaries;
        this.m_bShowElementTexture = pgElementSet3.m_bShowElementTexture;
        this.m_bShowSilhouette = pgElementSet3.m_bShowSilhouette;
        this.m_bShowEdges = pgElementSet3.m_bShowEdges;
        this.m_bShowTaggedEdges = pgElementSet3.m_bShowTaggedEdges;
        this.m_bShowEdgeColors = pgElementSet3.m_bShowEdgeColors;
        this.m_bShowElements = pgElementSet3.m_bShowElements;
        this.m_bShowTaggedElements = pgElementSet3.m_bShowTaggedElements;
        this.m_bShowBackface = pgElementSet3.m_bShowBackface;
        this.m_bShowElementNormals = pgElementSet3.m_bShowElementNormals;
        this.m_bShowElementNormalArrow = pgElementSet3.m_bShowElementNormalArrow;
        this.m_bShowElementColors = pgElementSet3.m_bShowElementColors;
        this.m_bShowElementBackColor = pgElementSet3.m_bShowElementBackColor;
        this.m_bShowElementBackColors = pgElementSet3.m_bShowElementBackColors;
        this.m_bConforming = pgElementSet3.m_bConforming;
        this.m_globalBndColor.blend(d, pgElementSet.m_globalBndColor, d2, pgElementSet2.m_globalBndColor);
        this.m_globalBndTagColor.blend(d, pgElementSet.m_globalBndTagColor, d2, pgElementSet2.m_globalBndTagColor);
        this.m_globalBndSize.blend(d, pgElementSet.m_globalBndSize, d2, pgElementSet2.m_globalBndSize);
        this.m_globalEdgeColor.blend(d, pgElementSet.m_globalEdgeColor, d2, pgElementSet2.m_globalEdgeColor);
        this.m_globalEdgeTagColor.blend(d, pgElementSet.m_globalEdgeTagColor, d2, pgElementSet2.m_globalEdgeTagColor);
        this.m_globalEdgeSize.blend(d, pgElementSet.m_globalEdgeSize, d2, pgElementSet2.m_globalEdgeSize);
        this.m_globalElementNormalLength.blend(d, pgElementSet.m_globalElementNormalLength, d2, pgElementSet2.m_globalElementNormalLength);
        this.m_globalElementNormalSize.blend(d, pgElementSet.m_globalElementNormalSize, d2, pgElementSet2.m_globalElementNormalSize);
        this.m_globalElementNormalColor.blend(d, pgElementSet.m_globalElementNormalColor, d2, pgElementSet2.m_globalElementNormalColor);
        this.m_globalElementColor.blend(d, pgElementSet.m_globalElementColor, d2, pgElementSet2.m_globalElementColor);
        this.m_globalElementTagColor.blend(d, pgElementSet.m_globalElementTagColor, d2, pgElementSet2.m_globalElementTagColor);
        this.m_globalElementBackColor.blend(d, pgElementSet.m_globalElementBackColor, d2, pgElementSet2.m_globalElementBackColor);
        this.setNumElements(pgElementSet3.getNumElements());
        int n = 0;
        while (n < this.m_numElements) {
            this.m_element[n].copy(pgElementSet3.m_element[n]);
            if (pgElementSet3.m_neighbour != null) {
                this.m_neighbour[n].copy(pgElementSet3.m_neighbour[n]);
            }
            ++n;
        }
        if (pgElementSet.m_elementNormal != null && pgElementSet2.m_elementNormal != null) {
            this.assureElementNormals();
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementNormal[n].blend(d, pgElementSet.m_elementNormal[n], d2, pgElementSet2.m_elementNormal[n]);
                this.m_elementNormal[n].normalize();
                ++n;
            }
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null && pgElementSet2.m_elementColor != null) {
            this.assureElementColors();
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementColor[n] = PdColor.blend(d, pgElementSet.m_elementColor[n], d2, pgElementSet2.m_elementColor[n]);
                ++n;
            }
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null && pgElementSet2.m_elementBackColor != null) {
            this.assureElementBackColors();
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementBackColor[n] = PdColor.blend(d, pgElementSet.m_elementBackColor[n], d2, pgElementSet2.m_elementBackColor[n]);
                ++n;
            }
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.hasBoundary() && pgElementSet2.hasBoundary()) {
            this.assureBoundary(pgElementSet3.m_bndList.length);
            n = 0;
            while (n < this.m_bndList.length) {
                this.m_bndList[n].blend(d, pgElementSet.m_bndList[n], d2, pgElementSet2.m_bndList[n]);
                ++n;
            }
        } else {
            this.m_bndList = null;
        }
        return true;
    }

    public void makeQuadrElementTexture(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.assureElementTextures();
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        if (this.m_dimOfElements == 3) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                int n5 = 0;
                while (n5 < n2 - 1) {
                    this.m_elementTexture[n3][0].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(n5 + 1) * d2;
                    this.m_elementTexture[++n3][0].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)(n5 + 1) * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(n5 + 1) * d2;
                    ++n3;
                    ++n5;
                }
                ++n4;
            }
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n6 = 0;
        int n7 = 0;
        while (n7 < n - 1) {
            int n8 = 0;
            while (n8 < n2 - 1) {
                this.m_elementTexture[n6][0].m_data[0] = (double)n7 * d;
                this.m_elementTexture[n6][0].m_data[1] = (double)n8 * d2;
                this.m_elementTexture[n6][1].m_data[0] = (double)(n7 + 1) * d;
                this.m_elementTexture[n6][1].m_data[1] = (double)n8 * d2;
                this.m_elementTexture[n6][2].m_data[0] = (double)(n7 + 1) * d;
                this.m_elementTexture[n6][2].m_data[1] = (double)(n8 + 1) * d2;
                this.m_elementTexture[n6][3].m_data[0] = (double)n7 * d;
                this.m_elementTexture[n6][3].m_data[1] = (double)(n8 + 1) * d2;
                ++n6;
                ++n8;
            }
            ++n7;
        }
    }

    public void buildQuadrFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pgPolygonArray.length != 4 || pgBndConstraintArray.length != 4) {
            PsDebug.warning("wrong argument array list");
            return;
        }
        int n = pgPolygonArray[0].getNumVertices();
        int n2 = pgPolygonArray[1].getNumVertices();
        int n3 = 0;
        int n4 = 0;
        int n5 = (1 + (n - 1) * (n3 + 1)) * (1 + (n2 - 1) * (n4 + 1));
        int n6 = 4 + 2 * n3 + 2 * n4 - 2;
        int n7 = (n - 1) * (n2 - 1) * n6;
        this.setNumVertices(n5);
        this.setNumElements(n7);
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            double d = (double)n9 / ((double)n - 1.0);
            PdVector pdVector = pgPolygonArray[0].m_vertex[n9];
            PdVector pdVector2 = pgPolygonArray[2].m_vertex[n - 1 - n9];
            int n10 = 0;
            while (n10 < n2) {
                double d2 = (double)n10 / ((double)n2 - 1.0);
                PdVector pdVector3 = pgPolygonArray[1].m_vertex[n10];
                PdVector pdVector4 = pgPolygonArray[3].m_vertex[n2 - 1 - n10];
                int n11 = 0;
                while (n11 < this.m_dim) {
                    double d3 = pdVector.m_data[n11] + d2 * (pdVector2.m_data[n11] - pdVector.m_data[n11]);
                    double d4 = pdVector4.m_data[n11] + d * (pdVector3.m_data[n11] - pdVector4.m_data[n11]);
                    this.m_vertex[n8].m_data[n11] = n9 == 0 || n9 == n - 1 ? d4 : (n10 == 0 || n10 == n2 - 1 ? d3 : (d3 + d4) / 2.0);
                    ++n11;
                }
                ++n8;
                ++n10;
            }
            ++n9;
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        n9 = 0;
        while (n9 < pgBndConstraintArray.length) {
            this.m_bndList[n9].m_bndConstraint = pgBndConstraintArray[n9];
            ++n9;
        }
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize.getValue();
    }

    public void setGlobalElementNormalSize(double d) {
        this.setGlobalVertexNormalSize(d);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalElementNormalSize.setValue(d);
        super.setGlobalVertexNormalSize(d);
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_element[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_element[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_element[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_element[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public boolean applyModelingMatrix() {
        if (!this.hasModelMatrix()) {
            return false;
        }
        if (this.hasElementNormals()) {
            PdVector pdVector = new PdVector(3);
            PdVector pdVector2 = new PdVector(3);
            int n = 0;
            while (n < this.m_numElements) {
                pdVector.copyArray(this.m_elementNormal[n]);
                pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                this.m_elementNormal[n].copyArray(pdVector2);
                ++n;
            }
        }
        if (this.hasBoundary()) {
            int n = this.getNumBoundaries();
            int n2 = 0;
            while (n2 < n) {
                this.m_bndList[n2].setModelMatrix(this.m_modelMatrix);
                this.m_bndList[n2].applyModelingMatrix();
                ++n2;
            }
        }
        return super.applyModelingMatrix();
    }

    public PdMatrix getL2Matrix(PdMatrix pdMatrix) {
        int n;
        Object[] objectArray;
        double d;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("elements must be triangular.");
            return null;
        }
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(this.m_numVertices);
        } else if (pdMatrix.getSize() != this.m_numVertices) {
            pdMatrix.setSize(this.m_numVertices);
        }
        int n2 = 0;
        while (n2 < this.m_numElements) {
            d = this.getAreaOfElement(n2) / 12.0;
            objectArray = this.m_element[n2].m_data;
            n = 0;
            do {
                double[] dArray = pdMatrix.m_data[objectArray[n]];
                double d2 = objectArray[n];
                dArray[d2] = dArray[d2] + (d + d);
                double[] dArray2 = pdMatrix.m_data[objectArray[n]];
                double d3 = objectArray[(n + 1) % 3];
                dArray2[d3] = dArray2[d3] + d;
                double[] dArray3 = pdMatrix.m_data[objectArray[(n + 1) % 3]];
                double d4 = objectArray[n];
                dArray3[d4] = dArray3[d4] + d;
            } while (++n < 3);
            ++n2;
        }
        d = 0.0;
        objectArray = new double[this.m_dim];
        n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = 0;
            while (n3 < this.m_dim) {
                objectArray[n3] = 0.0;
                ++n3;
            }
            n = 0;
            while (n < this.m_numVertices) {
                n3 = 0;
                while (n3 < this.m_dim) {
                    int n4 = n3;
                    objectArray[n4] = objectArray[n4] + pdMatrix.m_data[n2][n] * this.m_vertex[n].m_data[n3];
                    ++n3;
                }
                ++n;
            }
            n3 = 0;
            while (n3 < this.m_dim) {
                d += this.m_vertex[n2].m_data[n3] * objectArray[n3];
                ++n3;
            }
            ++n2;
        }
        if (Math.abs(d - this.getL2Norm()) > 1.0E-10) {
            PsDebug.warning("different L2-norms:\n\t getL2Norm()   = " + this.getL2Norm() + "\n\t getL2Matrix() = " + d);
        }
        return pdMatrix;
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 2);
        nArray2[nArray.length] = this.getNumEdges();
        nArray2[nArray.length + 1] = this.getNumElements();
        return nArray2;
    }
}

