/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FilePermission;
import java.util.List;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.pc.cartridge.ROMLoader;

public final class ROMTransferHandlerUtil {
    private static DataFlavor DATA_FLAVOR_TEXT;
    private static DataFlavor DATA_FLAVOR_FILE_LIST;

    static {
        try {
            DATA_FLAVOR_TEXT = new DataFlavor("text/plain; class=java.lang.String");
            DATA_FLAVOR_FILE_LIST = new DataFlavor("application/x-java-file-list; class=java.util.List");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean canAccept(Transferable transf) {
        if (transf.isDataFlavorSupported(DATA_FLAVOR_TEXT)) {
            return true;
        }
        if (!transf.isDataFlavorSupported(DATA_FLAVOR_FILE_LIST)) {
            return false;
        }
        try {
            new FilePermission(".", "read").checkGuard("Ignored");
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static Cartridge importCartridgeData(Transferable transf) {
        String url = ROMTransferHandlerUtil.getSingleURL(transf);
        if (url != null) {
            return ROMLoader.load(url, false);
        }
        File file = ROMTransferHandlerUtil.getSingleFile(transf);
        if (file != null) {
            return ROMLoader.load(file);
        }
        return null;
    }

    private static String getSingleURL(Transferable transf) {
        if (!transf.isDataFlavorSupported(DATA_FLAVOR_TEXT)) {
            return null;
        }
        try {
            String data = (String)transf.getTransferData(DATA_FLAVOR_TEXT);
            data = data.trim();
            if (!data.isEmpty()) {
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static File getSingleFile(Transferable transf) {
        List data;
        block4: {
            if (!transf.isDataFlavorSupported(DATA_FLAVOR_FILE_LIST)) {
                return null;
            }
            try {
                data = (List)transf.getTransferData(DATA_FLAVOR_FILE_LIST);
                if (!data.isEmpty()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (File)data.get(0);
    }
}

