/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.room;

import java.awt.Component;
import java.security.AccessControlException;
import java.util.ArrayList;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.console.Console;
import org.javatari.atari.network.ClientConsole;
import org.javatari.atari.network.RemoteReceiver;
import org.javatari.atari.network.RemoteTransmitter;
import org.javatari.atari.network.ServerConsole;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.BuiltInROM;
import org.javatari.pc.cartridge.ROMLoader;
import org.javatari.pc.controls.AWTConsoleControls;
import org.javatari.pc.controls.JoystickConsoleControls;
import org.javatari.pc.room.settings.SettingsDialog;
import org.javatari.pc.savestate.FileSaveStateMedia;
import org.javatari.pc.screen.DesktopScreenWindow;
import org.javatari.pc.screen.Screen;
import org.javatari.pc.speaker.Speaker;
import org.javatari.utils.Terminator;

public class Room {
    protected Console currentConsole;
    protected Console standaloneConsole;
    protected ServerConsole serverConsole;
    protected ClientConsole clientConsole;
    protected Screen screen;
    protected Speaker speaker;
    protected AWTConsoleControls awtControls;
    protected FileSaveStateMedia stateMedia;
    protected Cartridge cartridgeProvided;
    protected boolean triedToLoadCartridgeProvided = false;
    protected SettingsDialog settingsDialog;
    protected static Room currentRoom;

    protected Room() {
    }

    public void powerOn() {
        this.screen.powerOn();
        this.speaker.powerOn();
        this.awtControls.powerOn();
        this.insertCartridgeProvidedIfNoneInserted();
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            this.currentConsole.powerOn();
        }
    }

    public void powerOff() {
        if (this.currentConsole != null) {
            this.currentConsole.extendedPowerOff();
        }
        this.awtControls.powerOff();
        this.speaker.powerOff();
        this.screen.powerOff();
    }

    public Console currentConsole() {
        return this.currentConsole;
    }

    public Console standaloneCurrentConsole() {
        if (this.currentConsole != this.standaloneConsole) {
            throw new IllegalStateException("Not a Standalone Room");
        }
        return this.standaloneConsole;
    }

    public ServerConsole serverCurrentConsole() {
        if (this.currentConsole != this.serverConsole) {
            throw new IllegalStateException("Not a Server Room");
        }
        return this.serverConsole;
    }

    public ClientConsole clientCurrentConsole() {
        if (this.currentConsole != this.clientConsole) {
            throw new IllegalStateException("Not a Client Room");
        }
        return this.clientConsole;
    }

    public Screen screen() {
        return this.screen;
    }

    public Speaker speaker() {
        return this.speaker;
    }

    public AWTConsoleControls awtControls() {
        return this.awtControls;
    }

    public JoystickConsoleControls joystickControls() {
        return this.awtControls.joystickControls();
    }

    public FileSaveStateMedia stateMedia() {
        return this.stateMedia;
    }

    public boolean isStandaloneMode() {
        return this.currentConsole == this.standaloneConsole;
    }

    public boolean isServerMode() {
        return this.currentConsole == this.serverConsole;
    }

    public boolean isClientMode() {
        return this.currentConsole == this.clientConsole;
    }

    public void morphToStandaloneMode() {
        Cartridge lastCartridge;
        if (this.isStandaloneMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? this.cartridgeProvided : this.currentConsole.cartridgeSocket().inserted();
        if (this.standaloneConsole == null) {
            this.buildAndPlugStandaloneConsole();
        } else {
            this.plugConsole(this.standaloneConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        this.powerOn();
    }

    public void morphToServerMode() {
        Cartridge lastCartridge;
        if (this.isServerMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? this.cartridgeProvided : this.currentConsole.cartridgeSocket().inserted();
        if (this.serverConsole == null) {
            this.buildAndPlugServerConsole();
        } else {
            this.plugConsole(this.serverConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        this.powerOn();
    }

    public void morphToClientMode() {
        if (this.isClientMode()) {
            return;
        }
        this.powerOff();
        if (this.clientConsole == null) {
            this.buildAndPlugClientConsole();
        } else {
            this.plugConsole(this.clientConsole);
        }
        this.adjustPeripheralsToClientOperation();
        this.powerOn();
    }

    public void openSettings(Component parent) {
        if (this.settingsDialog == null) {
            this.settingsDialog = new SettingsDialog(this);
        }
        this.settingsDialog.open(parent);
    }

    public void destroy() {
        this.powerOff();
        if (this.standaloneConsole != null) {
            this.standaloneConsole.destroy();
        }
        if (this.serverConsole != null) {
            this.serverConsole.destroy();
        }
        if (this.clientConsole != null) {
            this.clientConsole.destroy();
        }
        this.screen.destroy();
        this.speaker.destroy();
        this.awtControls.destroy();
        if (this.settingsDialog != null) {
            this.settingsDialog.setVisible(false);
            this.settingsDialog.dispose();
        }
        currentRoom = null;
    }

    protected void buildPeripherals() {
        if (this.screen != null) {
            throw new IllegalStateException();
        }
        this.screen = this.buildScreenPeripheral();
        this.speaker = new Speaker();
        this.awtControls = new AWTConsoleControls();
        this.awtControls.connectScreen(this.screen);
        this.stateMedia = new FileSaveStateMedia();
    }

    protected Screen buildScreenPeripheral() {
        return this.buildDesktopScreenPeripheral();
    }

    public DesktopScreenWindow buildDesktopScreenPeripheral() {
        return new DesktopScreenWindow();
    }

    private void plugConsole(Console console) {
        if (this.currentConsole == console) {
            return;
        }
        this.currentConsole = console;
        this.screen.connect(this.currentConsole.videoOutput(), this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket());
        this.speaker.connect(this.currentConsole.audioOutput());
        this.awtControls.connect(this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket());
        this.stateMedia.connect(this.currentConsole.saveStateSocket());
    }

    private void insertCartridgeProvidedIfNoneInserted() {
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            return;
        }
        this.loadCartridgeProvided();
        if (this.cartridgeProvided != null) {
            this.currentConsole.cartridgeSocket().insert(this.cartridgeProvided, false);
        }
    }

    private void loadCartridgeProvided() {
        if (this.triedToLoadCartridgeProvided) {
            return;
        }
        this.triedToLoadCartridgeProvided = true;
        if (this.isClientMode()) {
            return;
        }
        ArrayList<BuiltInROM> builtInROMs = BuiltInROM.all();
        if (builtInROMs.size() > 0) {
            this.cartridgeProvided = ROMLoader.load(builtInROMs.get(0));
            if (this.cartridgeProvided == null) {
                Terminator.terminate();
            }
            Parameters.SCREEN_CARTRIDGE_CHANGE = false;
            this.screen.monitor().setCartridgeChangeEnabled(false);
        } else if (Parameters.mainArg != null) {
            this.cartridgeProvided = ROMLoader.load(Parameters.mainArg, true);
            if (this.cartridgeProvided == null) {
                Terminator.terminate();
            }
        }
    }

    protected Console buildAndPlugStandaloneConsole() {
        if (this.standaloneConsole != null) {
            throw new IllegalStateException();
        }
        this.standaloneConsole = new Console();
        this.plugConsole(this.standaloneConsole);
        return this.standaloneConsole;
    }

    protected ServerConsole buildAndPlugServerConsole() {
        if (this.serverConsole != null) {
            throw new IllegalStateException();
        }
        RemoteTransmitter remoteTransmitter = new RemoteTransmitter();
        this.serverConsole = new ServerConsole(remoteTransmitter);
        this.plugConsole(this.serverConsole);
        return this.serverConsole;
    }

    protected ClientConsole buildAndPlugClientConsole() {
        RemoteReceiver remoteReceiver = new RemoteReceiver();
        this.clientConsole = new ClientConsole(remoteReceiver);
        this.plugConsole(this.clientConsole);
        return this.clientConsole;
    }

    protected void adjustPeripheralsToStandaloneOrServerOperation() {
        this.awtControls.p1ControlsMode(false);
        this.screen.monitor().setCartridgeChangeEnabled(Parameters.SCREEN_CARTRIDGE_CHANGE);
    }

    protected void adjustPeripheralsToClientOperation() {
        this.awtControls.p1ControlsMode(true);
        this.screen.monitor().setCartridgeChangeEnabled(false);
    }

    public static Room currentRoom() {
        return currentRoom;
    }

    public static Room buildStandaloneRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    public static Room buildServerRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugServerConsole();
        return currentRoom;
    }

    public static Room buildClientRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToClientOperation();
        currentRoom.buildAndPlugClientConsole();
        return currentRoom;
    }

    public void exit() {
        try {
            this.destroy();
            System.out.println("<<<<<<<<<<<<  EXIT   >>>>>>>>>>>>>");
            System.exit(0);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

