/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.javatari.atari.network.ClientConsole;
import org.javatari.atari.network.ConnectionStatusListener;
import org.javatari.atari.network.ServerUpdate;
import org.javatari.parameters.Parameters;

public final class RemoteReceiver {
    private ClientConsole console;
    private Socket socket;
    private String serverAddress;
    private ConcurrentLinkedQueue<ServerUpdate> updates;
    private UpdatesConsumer updatesConsumer;
    private UpdatesReceiver updatesReceiver;
    private OutputStream socketOutputStream;
    private InputStream socketInputStream;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private List<ConnectionStatusListener> connectionListeners = new ArrayList<ConnectionStatusListener>();
    private static final int MAX_UPDATES_PENDING = Parameters.CLIENT_MAX_UPDATES_PENDING;

    public RemoteReceiver() {
        this.updates = new ConcurrentLinkedQueue();
    }

    public void connect(String server) throws IOException {
        this.tryConnection(server);
    }

    public void disconnect() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        UpdatesReceiver rec = this.updatesReceiver;
        UpdatesConsumer cons = this.updatesConsumer;
        this.socket.close();
        try {
            if (rec != null) {
                rec.join();
            }
            if (cons != null) {
                cons.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.inputStream != null;
    }

    public String serverAddress() {
        return this.serverAddress;
    }

    public void clientConsole(ClientConsole console) {
        this.console = console;
    }

    public void addConnectionStatusListener(ConnectionStatusListener lis) {
        if (!this.connectionListeners.contains(lis)) {
            this.connectionListeners.add(lis);
        }
    }

    private void tryConnection(String serverAddress) throws IOException, IllegalArgumentException {
        this.serverAddress = serverAddress;
        try {
            String addr = this.getHost(serverAddress);
            int port = this.getPort(serverAddress);
            this.socket = new Socket(addr, port);
            this.socket.setTcpNoDelay(true);
            this.socketOutputStream = this.socket.getOutputStream();
            this.outputStream = new ObjectOutputStream(this.socketOutputStream);
            this.socketInputStream = this.socket.getInputStream();
            this.inputStream = new ObjectInputStream(this.socketInputStream);
        }
        catch (IOException ex) {
            this.disconnection();
            throw ex;
        }
        this.resetUpdatesPending();
        this.updatesReceiver = new UpdatesReceiver();
        this.updatesReceiver.start();
        this.updatesConsumer = new UpdatesConsumer();
        this.updatesConsumer.start();
        this.console.connected();
        this.notifyConnectionStatusListeners();
    }

    private String getHost(String serverAddress) {
        int divider = serverAddress.indexOf(":");
        if (divider < 0) {
            return serverAddress;
        }
        return serverAddress.substring(0, divider).trim();
    }

    private int getPort(String serverAddress) throws IllegalArgumentException {
        int divider = serverAddress.indexOf(":");
        String p = "";
        try {
            if (divider < 0) {
                return Parameters.SERVER_SERVICE_PORT;
            }
            p = serverAddress.substring(divider + 1).trim();
            return Integer.valueOf(p);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port number: " + p);
        }
    }

    private void disconnection() {
        boolean wasConnected = this.inputStream != null;
        this.cleanStreamsSilently();
        if (this.updatesConsumer != null) {
            this.updatesConsumer.interrupt();
        }
        if (wasConnected) {
            this.console.disconnected();
            this.notifyConnectionStatusListeners();
        }
    }

    private void cleanStreamsSilently() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socketOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socketInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.socketOutputStream = null;
        this.outputStream = null;
        this.socketInputStream = null;
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveServerUpdate(ServerUpdate update) {
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            while (true) {
                if (this.updates.size() <= MAX_UPDATES_PENDING) {
                    this.updates.add(update);
                    this.updates.notifyAll();
                    return;
                }
                try {
                    this.updates.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUpdatesPending() {
        this.console.controlChangesToSend();
        ConcurrentLinkedQueue<ServerUpdate> concurrentLinkedQueue = this.updates;
        synchronized (concurrentLinkedQueue) {
            this.updates.clear();
            this.updates.notifyAll();
        }
    }

    private void notifyConnectionStatusListeners() {
        for (ConnectionStatusListener lis : this.connectionListeners) {
            lis.connectionStatusChanged();
        }
    }

    private class UpdatesConsumer
    extends Thread {
        public UpdatesConsumer() {
            super("RemoteReceiver Consumer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (RemoteReceiver.this.inputStream != null) {
                    ServerUpdate update;
                    ConcurrentLinkedQueue concurrentLinkedQueue = RemoteReceiver.this.updates;
                    synchronized (concurrentLinkedQueue) {
                        while ((update = (ServerUpdate)RemoteReceiver.this.updates.poll()) == null) {
                            RemoteReceiver.this.updates.wait();
                        }
                        RemoteReceiver.this.updates.notifyAll();
                    }
                    if (RemoteReceiver.this.inputStream == null || update == null) continue;
                    RemoteReceiver.this.console.receiveServerUpdate(update);
                    UpdatesConsumer.yield();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RemoteReceiver.this.updatesConsumer = null;
        }
    }

    private class UpdatesReceiver
    extends Thread {
        public UpdatesReceiver() {
            super("RemoteReceiver Receiver");
        }

        @Override
        public void run() {
            try {
                while (RemoteReceiver.this.inputStream != null) {
                    ServerUpdate update = (ServerUpdate)RemoteReceiver.this.inputStream.readObject();
                    RemoteReceiver.this.outputStream.writeObject(RemoteReceiver.this.console.controlChangesToSend());
                    RemoteReceiver.this.outputStream.flush();
                    RemoteReceiver.this.socketOutputStream.flush();
                    RemoteReceiver.this.receiveServerUpdate(update);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RemoteReceiver.this.disconnection();
            RemoteReceiver.this.updatesReceiver = null;
        }
    }
}

