/*
 * Decompiled with CFR 0.152.
 */
package moagg.util.math;

import moagg.types.math.Point;
import moagg.types.math.Rectangle;
import moagg.types.math.Vector;

public class AngleUtil {
    public static double getAngle(double x, double y) {
        double angle = Math.atan2(y, -x) * 360.0 / (Math.PI * 2) - 90.0;
        return AngleUtil.normalize(angle);
    }

    public static double getAngle(double x1, double y1, double x2, double y2) {
        return AngleUtil.getAngle(x2 - x1, y2 - y1);
    }

    public static double getAngle(Point p1, Point p2) {
        return AngleUtil.getAngle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double getAngle(Vector v1, Vector v2) {
        return AngleUtil.getAngle(v1.getX(), v1.getY(), v2.getX(), v2.getY());
    }

    public static double getAngle(Rectangle r1, Rectangle r2) {
        return AngleUtil.getAngle(r1.getCenter(), r2.getCenter());
    }

    public static double normalize(double angle) {
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static int normalize(int angle) {
        while (angle >= 360) {
            angle -= 360;
        }
        while (angle < 0) {
            angle += 360;
        }
        return angle;
    }
}

