/*
 * Decompiled with CFR 0.152.
 */
package moagg.types.prefs;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Language {
    EN("English"),
    DE("Deutsch"),
    IT("Italiano");

    private String description = null;

    private Language(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDefaultLocale() {
        Locale.setDefault(this.getLocale());
    }

    public Locale getLocale() {
        switch (this) {
            case EN: {
                return Locale.ENGLISH;
            }
            case DE: {
                return Locale.GERMAN;
            }
            case IT: {
                return Locale.ITALIAN;
            }
        }
        return null;
    }

    public static Language fromString(String lang) {
        for (Language value : Language.values()) {
            if (!value.toString().equals(lang)) continue;
            return value;
        }
        return EN;
    }
}

