/*
 * Decompiled with CFR 0.152.
 */
package moagg.types.math;

import moagg.types.math.Point;
import moagg.util.ToStringStyle;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Rectangle {
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;

    public Rectangle() {
    }

    public Rectangle(int x, int y, int w, int h) {
        this.setX(x);
        this.setY(y);
        this.setW(w);
        this.setH(h);
    }

    public Rectangle(Rectangle other) {
        this.setX(other.getX());
        this.setY(other.getY());
        this.setW(other.getW());
        this.setH(other.getH());
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        if (w < 0) {
            throw new IllegalArgumentException("The width must be >= 0");
        }
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        if (h < 0) {
            throw new IllegalArgumentException("The height must be >= 0");
        }
        this.h = h;
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public boolean contains(Rectangle other) {
        return this.x <= other.getX() && this.x + this.w >= other.getX() + other.getW() && this.y <= other.getY() && this.y + this.h >= other.getY() + other.getH();
    }

    public boolean contains(Point point) {
        return this.x <= point.getX() && this.x + this.w >= point.getX() && this.y <= point.getY() && this.y + this.h >= point.getY();
    }

    public Point getCenter() {
        return new Point(this.x + this.w / 2, this.y + this.h / 2);
    }

    public Rectangle intersect(Rectangle other) {
        if (this.getX() + this.getW() <= other.getX() || this.getY() + this.getH() <= other.getY() || other.getX() + other.getW() <= this.getX() || other.getY() + other.getH() <= this.getY()) {
            return null;
        }
        Rectangle i = new Rectangle();
        i.setX(Math.max(this.getX(), other.getX()));
        i.setY(Math.max(this.getY(), other.getY()));
        i.setW(Math.min(this.getX() + this.getW(), other.getX() + other.getW()) - i.getX());
        i.setH(Math.min(this.getY() + this.getH(), other.getY() + other.getH()) - i.getY());
        return i;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.x).append(this.y).append(this.w).append(this.h).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        return new EqualsBuilder().append(this.x, other.getX()).append(this.y, other.getY()).append(this.w, other.getW()).append(this.h, other.getH()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE).append("x", this.x).append("y", this.y).append("w", this.w).append("h", this.h).toString();
    }
}

