/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.system;

import java.util.prefs.Preferences;
import moagg.prefs.AbstractPrefs;
import moagg.types.prefs.Language;
import moagg.types.prefs.ScreenResolution;
import moagg.types.prefs.TimerType;

public class SystemPrefs
extends AbstractPrefs {
    private static final String PREF_LANGUAGE = "language";
    private static final String PREF_RESOLUTION = "resolution";
    private static final String PREF_FULLSCREEN = "fullscreen";
    private static final String PREF_MUSIC = "music";
    private static final String PREF_TIMER = "timer";
    private static final String DEFAULT_RESOLUTION = "640x480";
    private static final boolean DEFAULT_FULLSCREEN = false;
    private static final boolean DEFAULT_MUSIC = true;
    private static final String DEFAULT_TIMER = "GAGE";
    private Language language = null;
    private ScreenResolution resolution = null;
    private boolean fullScreen;
    private boolean music;
    private TimerType timer = null;
    private static SystemPrefs instance = new SystemPrefs();

    public static SystemPrefs getInstance() {
        return instance;
    }

    protected SystemPrefs() {
        this.prefs = Preferences.userNodeForPackage(SystemPrefs.class);
        String lang = this.prefs.get(PREF_LANGUAGE, null);
        this.language = lang != null ? Language.fromString(lang) : null;
        this.resolution = ScreenResolution.fromString(this.prefs.get(PREF_RESOLUTION, DEFAULT_RESOLUTION));
        this.fullScreen = this.prefs.getBoolean(PREF_FULLSCREEN, false);
        this.music = this.prefs.getBoolean(PREF_MUSIC, true);
        this.timer = TimerType.fromString(this.prefs.get(PREF_TIMER, DEFAULT_TIMER));
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
        this.prefs.put(PREF_LANGUAGE, language.toString());
    }

    public ScreenResolution getScreenResolution() {
        return this.resolution;
    }

    public void setScreenResolution(ScreenResolution resolution) {
        this.resolution = resolution;
        this.prefs.put(PREF_RESOLUTION, resolution.toString());
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean enabled) {
        this.fullScreen = enabled;
        this.prefs.putBoolean(PREF_FULLSCREEN, enabled);
    }

    public boolean isMusic() {
        return this.music;
    }

    public void setMusic(boolean enabled) {
        this.music = enabled;
        this.prefs.putBoolean(PREF_MUSIC, enabled);
    }

    public TimerType getTimer() {
        return this.timer;
    }

    public void setTimerType(TimerType timer) {
        this.timer = timer;
        this.prefs.put(PREF_TIMER, timer.toString());
    }
}

