/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.score;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import moagg.prefs.AbstractPrefs;
import moagg.prefs.score.LevelKey;
import moagg.prefs.score.ScoreEntries;
import moagg.prefs.score.ScoreEntry;
import org.apache.log4j.Logger;

public class ScorePrefs
extends AbstractPrefs {
    private static Logger log = Logger.getLogger(ScorePrefs.class);
    private static final File HISCORES = new File("hiscores.dat");
    private static final int MAX_SCORES_PER_LEVEL = 5;
    private Map<LevelKey, ScoreEntries> scores = new HashMap<LevelKey, ScoreEntries>();
    private static ScorePrefs instance = new ScorePrefs();

    public static ScorePrefs getInstance() {
        return instance;
    }

    protected ScorePrefs() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(HISCORES)));
            this.scores = (Map)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            log.warn("Error loading " + HISCORES.getAbsolutePath(), e);
        }
    }

    public ScoreEntries getScoreEntries(LevelKey levelKey) {
        ScoreEntries entries = this.scores.get(levelKey);
        return entries != null ? entries : new ScoreEntries();
    }

    public boolean addScore(LevelKey levelKey, ScoreEntry entry) {
        ScoreEntry last = null;
        boolean dirty = false;
        if (!this.scores.containsKey(levelKey)) {
            this.scores.put(levelKey, new ScoreEntries());
            dirty = true;
        }
        ScoreEntries levelScores = this.scores.get(levelKey);
        while (levelScores.size() > 5) {
            levelScores.remove(levelScores.last());
            dirty = true;
        }
        levelScores.add(entry);
        if (levelScores.size() <= 5) {
            dirty = true;
        }
        if (levelScores.size() > 5) {
            last = levelScores.last();
            levelScores.remove(last);
            if (entry != last) {
                dirty = true;
            }
        }
        if (dirty) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(HISCORES)));
                oos.writeObject(this.scores);
                oos.close();
            }
            catch (IOException e) {
                log.warn("Error saving " + HISCORES.getAbsolutePath(), e);
            }
        }
        return levelScores.contains(entry);
    }

    public ScoreEntry getBestScoreOfPlayer(LevelKey levelKey, String name) {
        ScoreEntries entries = this.scores.get(levelKey);
        if (entries == null) {
            return null;
        }
        for (ScoreEntry entry : entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }
}

