/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.score;

import java.io.Serializable;
import moagg.util.ToStringStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Score
implements Serializable,
Comparable<Score> {
    private static final long serialVersionUID = 1L;
    private int wrecks = 0;
    private int points = 0;
    private long elapsedTime = 0L;

    public int getWrecks() {
        return this.wrecks;
    }

    public void setWrecks(int wrecks) {
        this.wrecks = wrecks;
    }

    public void incWrecks() {
        ++this.wrecks;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void incPoints() {
        ++this.points;
    }

    public void addPoints(int points) {
        this.points += points;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void addElapsedTime(long elapsedTime) {
        this.elapsedTime += elapsedTime;
    }

    public String getElapsedTimeAsString() {
        long time = this.elapsedTime;
        int ms = (int)(time % 1000L);
        int sec = (int)((time /= 1000L) % 60L);
        int min = (int)(time /= 60L);
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad(String.valueOf(min), 2, '0'));
        sb.append(':');
        sb.append(StringUtils.leftPad(String.valueOf(sec), 2, '0'));
        sb.append('.');
        sb.append(StringUtils.leftPad(String.valueOf(ms / 10), 2, '0'));
        return sb.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.wrecks).append(this.points).append(this.elapsedTime).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Score)) {
            return false;
        }
        Score other = (Score)obj;
        return new EqualsBuilder().append(this.wrecks, other.getWrecks()).append(this.points, other.getPoints()).append(this.elapsedTime, other.getElapsedTime()).isEquals();
    }

    @Override
    public int compareTo(Score other) {
        return new CompareToBuilder().append(this.wrecks, other.getWrecks()).append(other.getPoints(), this.points).append(this.elapsedTime, other.getElapsedTime()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE).append("wrecks", this.wrecks).append("points", this.points).append("elapsedTime", this.elapsedTime).toString();
    }
}

