/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.ghost;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moagg.prefs.ghost.GhostFrame;
import moagg.prefs.score.LevelKey;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ghost
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Ghost.class);
    private static final String GHOST_DIRECTORY = "ghosts";
    private int frameDelay = 0;
    private int shipType = 0;
    private List<GhostFrame> frames = new LinkedList<GhostFrame>();

    public void setFrameDelay(int frameDelay) {
        this.frameDelay = frameDelay;
    }

    public int getFrameDelay() {
        return this.frameDelay;
    }

    public void setShipType(int shipType) {
        this.shipType = shipType;
    }

    public int getShipType() {
        return this.shipType;
    }

    public void add(GhostFrame shipState) {
        this.frames.add(shipState);
    }

    public Iterator<GhostFrame> iterator() {
        return this.frames.iterator();
    }

    public static Ghost load(LevelKey levelKey, String name) {
        File file = Ghost.getGhostFile(levelKey, name);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Ghost entry = (Ghost)ois.readObject();
            ois.close();
            return entry;
        }
        catch (FileNotFoundException e) {
            log.debug("Ghost file " + file.getAbsolutePath() + " doesn't exist.");
        }
        catch (Exception e) {
            log.warn("Error loading ghost from " + file.getAbsolutePath(), e);
        }
        return null;
    }

    public void save(LevelKey levelKey, String name) {
        File file = Ghost.getGhostFile(levelKey, name);
        this.ensurePath(Ghost.getGhostPath(levelKey));
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            log.warn("Error saving ghost to " + file.getAbsolutePath(), e);
        }
    }

    protected void ensurePath(String path) {
        File file;
        int slash = path.lastIndexOf(47);
        if (slash > 0) {
            this.ensurePath(path.substring(0, slash));
        }
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }
    }

    protected static String getGhostPath(LevelKey levelKey) {
        return "ghosts/" + levelKey.getMission() + "/" + levelKey.getLevel().replace(".xml", "");
    }

    protected static File getGhostFile(LevelKey levelKey, String name) {
        return new File(Ghost.getGhostPath(levelKey) + "/" + name + ".dat");
    }
}

