/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import java.util.ArrayList;
import java.util.List;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.types.math.Vector;
import moagg.util.math.AngleUtil;
import moagg.util.math.SinusTable;

public class Grinder
extends AbstractMoaggAnimatedSprite
implements MoaggGameObject {
    private static final long serialVersionUID = 1L;
    private double velocity = 0.0;
    private List<Vector> waypoints = new ArrayList<Vector>();
    private int waypointId = 0;
    private double oldDistance = -1.0;

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void addWaypoint(Vector waypoint) {
        this.waypoints.add(waypoint);
    }

    public void clearWaypoints() {
        this.waypoints.clear();
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.updateHeading();
    }

    protected void updateHeading() {
        Vector target;
        if (this.waypoints.isEmpty()) {
            return;
        }
        Vector current = new Vector(this.getX(), this.getY());
        double distance = Vector.distance(current, target = this.waypoints.get(this.waypointId));
        if (distance > this.oldDistance) {
            this.waypointId = (this.waypointId + 1) % this.waypoints.size();
            target = this.waypoints.get(this.waypointId);
            this.oldDistance = Vector.distance(current, target);
        } else {
            this.oldDistance = distance;
        }
        double angle = AngleUtil.getAngle(current, target);
        this.setSpeed(this.velocity * SinusTable.sin(angle), this.velocity * SinusTable.cos(angle));
    }
}

