/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.level;

import java.util.LinkedList;
import java.util.List;
import moagg.model.level.Map;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Platform;
import moagg.types.math.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayGround {
    private String mapName = null;
    private Map map = null;
    private Matrix gravityX = null;
    private Matrix gravityY = null;
    private Matrix streamX = null;
    private Matrix streamY = null;
    private Matrix friction = null;
    private List<MoaggGameObject> objects = new LinkedList<MoaggGameObject>();
    private List<Platform> platforms = new LinkedList<Platform>();

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMap(Map map) {
        this.map = map;
        this.gravityX = new Matrix(map.getWidth(), map.getHeight());
        this.gravityY = new Matrix(map.getWidth(), map.getHeight());
        this.streamX = new Matrix(map.getWidth(), map.getHeight());
        this.streamY = new Matrix(map.getWidth(), map.getHeight());
        this.friction = new Matrix(map.getWidth(), map.getHeight());
    }

    public Map getMap() {
        return this.map;
    }

    public Matrix getGravityX() {
        return this.gravityX;
    }

    public Matrix getGravityY() {
        return this.gravityY;
    }

    public Matrix getStreamX() {
        return this.streamX;
    }

    public Matrix getStreamY() {
        return this.streamY;
    }

    public Matrix getFriction() {
        return this.friction;
    }

    public void addObject(MoaggGameObject object) {
        this.objects.add(object);
        if (object instanceof Platform) {
            this.platforms.add((Platform)object);
        }
    }

    public List<MoaggGameObject> getObjects() {
        return this.objects;
    }

    public List<Platform> getPlatforms() {
        return this.platforms;
    }

    public MoaggGameObject getObjectById(int id) {
        for (MoaggGameObject object : this.objects) {
            if (object.getID() != id) continue;
            return object;
        }
        return null;
    }
}

