/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.object;

import moagg.level.IllegalAttributeXmlHandlerException;
import moagg.level.xml.AbstractSpriteHandler;
import moagg.level.xml.Handler;
import moagg.level.xml.data.object.TurretData;
import moagg.level.xml.object.DataProvider;
import moagg.level.xml.object.TurretBarrelHandler;
import moagg.types.TurretBarrelType;
import moagg.types.TurretType;
import moagg.types.WeaponType;
import org.xml.sax.Attributes;

public class TurretHandler
extends AbstractSpriteHandler
implements Handler,
DataProvider {
    public static final String NAME = "turret";
    private TurretData data = new TurretData();

    public TurretData getData() {
        return this.data;
    }

    public void handleAttributes(Attributes attrs) {
        this.data.setId(this.getUnsignedIntAttribute(NAME, "id", attrs, 0));
        this.data.setX(this.getUnsignedIntAttribute(NAME, "x", attrs));
        this.data.setY(this.getUnsignedIntAttribute(NAME, "y", attrs));
        this.data.setVisible(this.getBooleanAttribute(NAME, "visible", attrs, true));
        this.data.setOrientation(this.parseOrientation(NAME, attrs));
        this.handleDestroyableAttributes(NAME, this.data, attrs);
        String preset = this.getStringAttribute(NAME, "preset", attrs, null);
        if (preset != null) {
            this.parsePreset(preset);
        } else {
            this.data.setType(this.parseType(this.getStringAttribute(NAME, "type", attrs)));
        }
    }

    public Handler createSubHandler(String name, Attributes attrs) {
        if ("barrel".equals(name)) {
            return new TurretBarrelHandler(attrs);
        }
        return null;
    }

    public void handleTag(String name, String value) {
    }

    public void finishSubHandler(String name, Handler subHandler) {
        if ("barrel".equals(name)) {
            this.data.addBarrel(((TurretBarrelHandler)subHandler).getTurretBarrelData());
        }
    }

    protected void parsePreset(String preset) {
        if ("mark1".equals(preset)) {
            this.data.setType(TurretType.TUBE);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.FIXED);
            barrel.setSpeed(200);
            barrel.setDelay(20);
            this.data.addBarrel(barrel);
        } else if ("mark1b".equals(preset)) {
            this.data.setType(TurretType.TUBE);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.FIXED);
            barrel.setSpeed(250);
            barrel.setDelay(15);
            this.data.addBarrel(barrel);
        } else if ("mark1c".equals(preset)) {
            this.data.setType(TurretType.TUBE);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.FIXED);
            barrel.setSpeed(300);
            barrel.setDelay(10);
            this.data.addBarrel(barrel);
        } else if ("dome1".equals(preset)) {
            this.data.setType(TurretType.DOME);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.SMART);
            barrel.setSpeed(200);
            barrel.setDelay(20);
            this.data.addBarrel(barrel);
        } else if ("dome1b".equals(preset)) {
            this.data.setType(TurretType.DOME);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.SMART);
            barrel.setSpeed(250);
            barrel.setDelay(15);
            this.data.addBarrel(barrel);
        } else if ("dome1c".equals(preset)) {
            this.data.setType(TurretType.DOME);
            TurretData.BarrelData barrel = new TurretData.BarrelData();
            barrel.setWeaponType(WeaponType.BLASTER);
            barrel.setType(TurretBarrelType.SMART);
            barrel.setSpeed(300);
            barrel.setDelay(10);
            this.data.addBarrel(barrel);
        } else {
            throw new IllegalAttributeXmlHandlerException(NAME, "preset", preset);
        }
    }

    protected TurretType parseType(String type) {
        if ("tube".equals(type)) {
            return TurretType.TUBE;
        }
        if ("dome".equals(type)) {
            return TurretType.DOME;
        }
        throw new IllegalAttributeXmlHandlerException(NAME, "type", type);
    }
}

