/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.CrateImageFactory;
import moagg.artwork.object.PlatformImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.CrateData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Crate;
import org.apache.log4j.Logger;

public class CrateFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(CrateFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        CrateData data = (CrateData)abstractData;
        Crate crate = new Crate();
        crate.setID(data.getId());
        crate.setImage(CrateImageFactory.getInstance().getImage(data.getType()));
        crate.setType(data.getType());
        switch (data.getType()) {
            case SMALL: {
                crate.setMass(200);
                break;
            }
            case MEDIUM: {
                crate.setMass(400);
                break;
            }
            case BIG: {
                crate.setMass(600);
                break;
            }
            case FUEL: {
                crate.setFuelPercentage(data.getFuelPercentage());
                break;
            }
        }
        int x = data.getX() * 16 + (16 - CrateImageFactory.getInstance().getCrateWidth(data.getType())) / 2;
        int y = data.getY() * 16 + 16 - CrateImageFactory.getInstance().getCrateHeight(data.getType()) - PlatformImageFactory.getInstance().getPlatformHeight() + 1;
        crate.setLocation(x, y);
        crate.setVisible(data.isVisible());
        return crate;
    }
}

