/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory;

import moagg.level.xml.data.LevelData;
import moagg.level.xml.data.PlayGroundData;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.factory.ObjectFactory;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.level.Level;
import moagg.model.level.PlayGround;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Platform;

public class ObjectFactoryImpl
implements ObjectFactory {
    private static final String OBJECT_FACTORY_PACKAGE_NAME = "moagg.level.xml.factory.object";

    public Level createLevel(String mission, String level, LevelData levelData) {
        Level l = new Level();
        l.setMission(mission);
        l.setLevel(level);
        PlayGround playGround = this.createPlayGround(levelData.getPlayGround());
        l.setPlayGround(playGround);
        if (levelData.getStartPlatformId() != 0) {
            l.setStartPlatform((Platform)playGround.getObjectById(levelData.getStartPlatformId()));
        } else {
            l.setStartPosition(levelData.getStartPosition());
        }
        l.setFuelPercentage(levelData.getFuelPercentage());
        l.setGameControlScript(levelData.getGameControlScript());
        return l;
    }

    protected PlayGround createPlayGround(PlayGroundData playGroundData) {
        PlayGround playGround = new PlayGround();
        playGround.setMapName(playGroundData.getMapName());
        for (AbstractDecorationData data : playGroundData.getDecorations()) {
            playGround.addObject(this.createObject(data));
        }
        return playGround;
    }

    protected MoaggGameObject createObject(AbstractDecorationData data) {
        try {
            String factoryName = "moagg.level.xml.factory.object." + data.getClass().getSimpleName().replace("Data", "Factory");
            AbstractObjectFactory factory = (AbstractObjectFactory)Class.forName(factoryName).newInstance();
            return factory.createObject(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create object factory for " + data.getClass().getName(), e);
        }
    }
}

