/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml;

import moagg.level.LevelXmlHandlerException;
import moagg.level.UnexpectedNodeXmlHandlerException;
import moagg.level.xml.Handler;
import moagg.level.xml.PlayGroundHandler;
import moagg.level.xml.StartPositionHandler;
import moagg.level.xml.data.LevelData;
import moagg.types.math.Point;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class LevelHandler
implements Handler {
    public static Logger log = Logger.getLogger(LevelHandler.class);
    public static final String NAME = "level";
    public static final String DESCRIPTION = "description";
    public static final String BONUS = "bonus";
    public static final String GAMECONTROL = "gamecontrol";
    private LevelData level = new LevelData();

    public LevelData getLevel() {
        return this.level;
    }

    public Handler createSubHandler(String name, Attributes attrs) {
        if (DESCRIPTION.equals(name)) {
            log.warn("The <description> node is deprecated and will be ignored.");
            return null;
        }
        if (BONUS.equals(name)) {
            log.warn("The <bonus> node is deprecated and will be ignored.");
            return null;
        }
        if (GAMECONTROL.equals(name)) {
            return null;
        }
        if ("playground".equals(name)) {
            return new PlayGroundHandler(attrs);
        }
        if ("startposition".equals(name)) {
            return new StartPositionHandler(attrs);
        }
        throw new UnexpectedNodeXmlHandlerException(name);
    }

    public void handleTag(String name, String value) {
        if (GAMECONTROL.equals(name)) {
            this.level.setGameControlScript(value);
        }
    }

    public void finishSubHandler(String name, Handler subHandler) {
        if ("playground".equals(name)) {
            this.level.setPlayGround(((PlayGroundHandler)subHandler).getPlayGround());
        } else if ("startposition".equals(name)) {
            StartPositionHandler handler = (StartPositionHandler)subHandler;
            if (handler.getStartPlatformId() != 0) {
                this.level.setStartPlatformId(((StartPositionHandler)subHandler).getStartPlatformId());
            } else if (handler.getStartX() != 0 && handler.getStartY() != 0) {
                this.level.setStartPosition(new Point(handler.getStartX(), handler.getStartY()));
            } else {
                throw new LevelXmlHandlerException("The startposition node must either define a platform or x/y attributes.");
            }
            this.level.setFuelPercentage(handler.getFuelPercentage());
        }
    }
}

