/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml;

import moagg.level.IllegalAttributeXmlHandlerException;
import moagg.level.MissingAttributeXmlHandlerException;
import moagg.level.xml.data.object.Activatable;
import moagg.level.xml.data.object.Destroyable;
import moagg.types.Orientation;
import org.xml.sax.Attributes;

public abstract class AbstractHandler {
    protected String getStringAttribute(String node, String attr, Attributes attrs) {
        String value = attrs.getValue(attr);
        if (value == null) {
            throw new MissingAttributeXmlHandlerException(node, attr);
        }
        return value;
    }

    protected String getStringAttribute(String node, String attr, Attributes attrs, String defaultValue) {
        String value = attrs.getValue(attr);
        return value != null ? value : defaultValue;
    }

    protected int getIntAttribute(String node, String attr, Attributes attrs) {
        String value = this.getStringAttribute(node, attr, attrs);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeXmlHandlerException(node, attr, value);
        }
    }

    protected int getIntAttribute(String node, String attr, Attributes attrs, int defaultValue) {
        String value = this.getStringAttribute(node, attr, attrs, null);
        try {
            return value != null ? Integer.parseInt(this.getStringAttribute(node, attr, attrs)) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeXmlHandlerException(node, attr, value);
        }
    }

    protected int getUnsignedIntAttribute(String node, String attr, Attributes attrs) {
        int value = this.getIntAttribute(node, attr, attrs);
        if (value < 0) {
            throw new IllegalAttributeXmlHandlerException(node, attr, String.valueOf(value));
        }
        return value;
    }

    protected int getUnsignedIntAttribute(String node, String attr, Attributes attrs, int defaultValue) {
        int value = this.getIntAttribute(node, attr, attrs, defaultValue);
        if (value < 0) {
            throw new IllegalAttributeXmlHandlerException(node, attr, String.valueOf(value));
        }
        return value;
    }

    protected int getHexAttribute(String node, String attr, Attributes attrs) {
        String value = this.getStringAttribute(node, attr, attrs);
        try {
            return Integer.parseInt(value, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeXmlHandlerException(node, attr, value);
        }
    }

    protected int getHexAttribute(String node, String attr, Attributes attrs, int defaultValue) {
        String value = this.getStringAttribute(node, attr, attrs, null);
        try {
            return value != null ? Integer.parseInt(value, 16) : defaultValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeXmlHandlerException(node, attr, value);
        }
    }

    protected Boolean getBooleanAttribute(String node, String attr, Attributes attrs, Boolean defaultValue) {
        String value = attrs.getValue(attr);
        if (value == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalAttributeXmlHandlerException(node, attr, value);
    }

    protected Orientation parseOrientation(String node, Attributes attrs) {
        String value = this.getStringAttribute(node, "orientation", attrs);
        if ("top".equals(value)) {
            return Orientation.TOP;
        }
        if ("bottom".equals(value)) {
            return Orientation.BOTTOM;
        }
        if ("left".equals(value)) {
            return Orientation.LEFT;
        }
        if ("right".equals(value)) {
            return Orientation.RIGHT;
        }
        throw new IllegalAttributeXmlHandlerException(node, "orientation", value);
    }

    protected void handleActivateableAttributes(String node, Activatable data, Attributes attrs) {
        data.setOnInterval(this.getUnsignedIntAttribute(node, "on", attrs, 0));
        data.setOffInterval(this.getUnsignedIntAttribute(node, "off", attrs, 0));
        data.setInitialDelay(this.getUnsignedIntAttribute(node, "delay", attrs, 0));
        data.setActivation(this.getBooleanAttribute(node, "activated", attrs, null));
    }

    protected void handleDestroyableAttributes(String node, Destroyable data, Attributes attrs) {
        data.setHealth(this.getUnsignedIntAttribute(node, "hitpoints", attrs, 10));
    }
}

