/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.converter;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import moagg.level.MapReaderException;

public class BricksRandomizer {
    public static final String MISSION_PATH = "src/main/resources/mission";

    public void randomize(File file) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.randomize(files[i]);
            }
        } else if (file.getName().endsWith(".map")) {
            this.randomizeMap(file);
        }
    }

    protected void randomizeMap(File map) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(map));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        DataOutputStream os = new DataOutputStream(bos);
        if (this.randomizeMap(is, os)) {
            File newMap = new File(map.getCanonicalPath());
            FileOutputStream fos = new FileOutputStream(newMap);
            fos.write(bos.toByteArray());
            fos.close();
        }
        os.close();
        is.close();
    }

    protected boolean randomizeMap(DataInputStream is, DataOutputStream os) throws Exception {
        byte version = is.readByte();
        os.writeByte(version);
        switch (version) {
            case 2: {
                return this.randomizeMapV2(is, os);
            }
        }
        throw new MapReaderException("Illegal map version: " + version);
    }

    protected boolean randomizeMapV1(DataInputStream is, DataOutputStream os) throws Exception {
        boolean changed = false;
        return changed;
    }

    protected boolean randomizeMapV2(DataInputStream is, DataOutputStream os) throws Exception {
        boolean changed = false;
        short xTiles = is.readShort();
        os.writeShort(xTiles);
        short yTiles = is.readShort();
        os.writeShort(yTiles);
        int layers = is.readByte();
        os.writeByte(layers);
        for (int layer = 1; layer <= layers; ++layer) {
            byte categoryId = is.readByte();
            os.writeByte(categoryId);
            os.writeByte(is.readByte());
            os.writeByte(is.readByte());
            os.writeByte(is.readByte());
            for (short y = 0; y < yTiles; y = (short)(y + 1)) {
                for (short x = 0; x < xTiles; x = (short)(x + 1)) {
                    byte tileId = is.readByte();
                    if (categoryId == 1 && tileId != 0) {
                        tileId = (byte)(tileId & 0xF);
                        tileId = (byte)(tileId + 16 * ((int)(3.0 * Math.random()) + 1));
                        os.writeByte(tileId);
                        changed = true;
                        continue;
                    }
                    os.writeByte(tileId);
                }
            }
        }
        while ((layers = (byte)(layers - 1)) > 0) {
        }
        return changed;
    }

    public static void main(String[] args) {
        try {
            BricksRandomizer randomize = new BricksRandomizer();
            File root = new File(MISSION_PATH);
            randomize.randomize(root);
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

