/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.converter;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import moagg.level.MapReaderException;

public class BricksConverter {
    public static final String MISSION_PATH = "src/main/resources/mission";

    public void convert(File file) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.convert(files[i]);
            }
        } else if (file.getName().endsWith(".map")) {
            this.convertMap(file);
        }
    }

    protected void convertMap(File map) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(map));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        DataOutputStream os = new DataOutputStream(bos);
        if (this.convertMap(is, os)) {
            File newMap = new File(map.getCanonicalPath() + ".new");
            FileOutputStream fos = new FileOutputStream(newMap);
            fos.write(bos.toByteArray());
            fos.close();
        }
        os.close();
        is.close();
    }

    protected boolean convertMap(DataInputStream is, DataOutputStream os) throws Exception {
        byte version = is.readByte();
        os.writeByte(version);
        switch (version) {
            case 2: {
                return this.convertMapV2(is, os);
            }
        }
        throw new MapReaderException("Illegal map version: " + version);
    }

    protected boolean convertMapV1(DataInputStream is, DataOutputStream os) throws Exception {
        boolean changed = false;
        return changed;
    }

    protected boolean convertMapV2(DataInputStream is, DataOutputStream os) throws Exception {
        boolean changed = false;
        short xTiles = is.readShort();
        os.writeShort(xTiles);
        short yTiles = is.readShort();
        os.writeShort(yTiles);
        int layers = is.readByte();
        os.writeByte(layers);
        for (int layer = 1; layer <= layers; ++layer) {
            byte categoryId = is.readByte();
            os.writeByte(categoryId);
            os.writeByte(is.readByte());
            os.writeByte(is.readByte());
            os.writeByte(is.readByte());
            for (short y = 0; y < yTiles; y = (short)(y + 1)) {
                for (short x = 0; x < xTiles; x = (short)(x + 1)) {
                    byte tileId = is.readByte();
                    if ((categoryId == 1 || categoryId == 2) && tileId >= 16 && tileId <= 18) {
                        os.writeByte(tileId - 6);
                        changed = true;
                        continue;
                    }
                    os.writeByte(tileId);
                }
            }
        }
        while ((layers = (byte)(layers - 1)) > 0) {
        }
        return changed;
    }

    public static void main(String[] args) {
        try {
            BricksConverter converter = new BricksConverter();
            File root = new File(MISSION_PATH);
            converter.convert(root);
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

