/*
 * Decompiled with CFR 0.152.
 */
package moagg.level;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import moagg.game.SystemProperties;
import moagg.level.LevelReader;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissionReader {
    private static Logger log = Logger.getLogger(LevelReader.class);
    private static final String MISSIONS = "missions.idx";
    private static final String LEVELS = "levels.idx";
    private List<String> missionOrder = new LinkedList<String>();
    private List<MissionEntry> missions = new LinkedList<MissionEntry>();
    private static MissionReader instance = new MissionReader();

    public static MissionReader getInstance() {
        return instance;
    }

    public void init() throws IOException, URISyntaxException {
        this.initMissionOrder();
        String missionPath = SystemProperties.getInstance().getMissionsPath();
        File missionsFile = new File(this.getClass().getResource(missionPath).toURI());
        if (!missionsFile.exists() || !missionsFile.isDirectory()) {
            log.fatal("Missions directory '" + missionPath + "' not found.");
            throw new RuntimeException("Missions directory '" + missionPath + "' not found.");
        }
        for (String mission : this.missionOrder) {
            this.initMission(missionPath, mission);
        }
        for (String mission : missionsFile.list()) {
            if (this.missionOrder.contains(mission)) continue;
            this.initMission(missionPath, mission);
        }
    }

    protected void initMissionOrder() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(SystemProperties.getInstance().getMissionsPath() + "/" + MISSIONS)));
        while (br.ready()) {
            String mission = br.readLine().trim();
            if (mission.length() == 0 || mission.startsWith("#")) continue;
            this.missionOrder.add(mission);
        }
    }

    protected void initMission(String missionPath, String mission) throws IOException {
        InputStream levels = this.getClass().getResourceAsStream(missionPath + "/" + mission + "/" + LEVELS);
        if (levels == null) {
            return;
        }
        log.trace("Adding mission '" + mission + "'");
        MissionEntry entry = new MissionEntry();
        entry.directory = mission;
        entry.levels = new LinkedList<String>();
        this.initLevelList(levels, entry);
        this.missions.add(entry);
    }

    protected void initLevelList(InputStream levels, MissionEntry entry) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(levels));
        while (br.ready()) {
            String line = br.readLine().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            entry.levels.add(line);
        }
    }

    public List<MissionEntry> getMissions() {
        return this.missions;
    }

    public List<String> getLevelsFor(String mission) {
        for (MissionEntry entry : this.missions) {
            if (!entry.directory.equals(mission)) continue;
            return entry.levels;
        }
        return null;
    }

    public static class MissionEntry {
        public String directory;
        public List<String> levels;
    }
}

