/*
 * Decompiled with CFR 0.152.
 */
package moagg.level;

import com.golden.gamedev.GameObject;
import java.io.IOException;
import moagg.game.SystemProperties;
import moagg.level.LevelReaderException;
import moagg.level.LevelXmlHandlerException;
import moagg.level.MapReader;
import moagg.level.xml.LevelContentHandler;
import moagg.level.xml.data.GravityData;
import moagg.level.xml.data.LevelData;
import moagg.level.xml.data.LocalGravityData;
import moagg.level.xml.data.PlayGroundData;
import moagg.level.xml.factory.ObjectFactory;
import moagg.level.xml.factory.ObjectFactoryImpl;
import moagg.model.level.Level;
import moagg.model.level.PlayGround;
import moagg.types.math.Rectangle;
import moagg.util.StopWatch;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LevelReader {
    private static Logger log = Logger.getLogger(LevelReader.class);
    private ObjectFactory objectFactory = new ObjectFactoryImpl();
    private static LevelReader instance = new LevelReader();

    public static LevelReader getInstance() {
        return instance;
    }

    public Level readLevel(String mission, String level, GameObject loader) {
        log.debug("Reading level '" + mission + "/" + level + "'");
        StopWatch duration = new StopWatch("duration");
        duration.start();
        try {
            XMLReader r = XMLReaderFactory.createXMLReader();
            LevelContentHandler handler = new LevelContentHandler();
            r.setContentHandler(handler);
            r.parse(new InputSource(loader.bsIO.getStream(SystemProperties.getInstance().getMissionsPath() + "/" + mission + "/" + level)));
            LevelData levelData = handler.getLevel();
            Level l = this.objectFactory.createLevel(mission, level, levelData);
            PlayGround playGround = l.getPlayGround();
            playGround.setMap(MapReader.getInstance().readMap(mission, playGround.getMapName(), loader));
            this.initGravityMatrix(levelData.getPlayGround(), playGround);
            Level level2 = l;
            return level2;
        }
        catch (IOException e) {
            throw new LevelReaderException("I/O exception while reading level '" + mission + "/" + level + "'", e);
        }
        catch (SAXException e) {
            throw new LevelReaderException("SAX exception while reading level '" + mission + "/" + level + "'", e);
        }
        catch (LevelXmlHandlerException e) {
            throw new LevelReaderException("Error while reading level '" + mission + "/" + level + "'", e);
        }
        finally {
            duration.stop();
            log.debug("Reading level finished, " + duration);
        }
    }

    protected void initGravityMatrix(PlayGroundData playGroundData, PlayGround playGround) {
        GravityData globalGravityData = playGroundData.getGlobalGravity();
        playGround.getGravityX().setAll((double)globalGravityData.getGX() * 8.0E-7);
        playGround.getGravityY().setAll((double)globalGravityData.getGY() * 8.0E-7);
        playGround.getStreamX().setAll((double)globalGravityData.getVX() * 8.0E-7);
        playGround.getStreamY().setAll((double)globalGravityData.getVY() * 8.0E-7);
        playGround.getFriction().setAll((double)globalGravityData.getFriction() * 0.006);
        for (LocalGravityData localGravityData : playGroundData.getLocalGravities()) {
            Rectangle r = new Rectangle(localGravityData.getX(), localGravityData.getY(), localGravityData.getW(), localGravityData.getH());
            if (localGravityData.isRelative()) {
                playGround.getGravityX().add(r, (double)localGravityData.getGX() * 8.0E-7);
                playGround.getGravityY().add(r, (double)localGravityData.getGY() * 8.0E-7);
                playGround.getStreamX().add(r, (double)localGravityData.getVX() * 0.002);
                playGround.getStreamY().add(r, (double)localGravityData.getVY() * 0.002);
                playGround.getFriction().add(r, (double)localGravityData.getFriction() * 0.006);
                continue;
            }
            playGround.getGravityX().set(r, (double)localGravityData.getGX() * 8.0E-7);
            playGround.getGravityY().set(r, (double)localGravityData.getGY() * 8.0E-7);
            playGround.getStreamX().set(r, (double)localGravityData.getVX() * 0.002);
            playGround.getStreamY().set(r, (double)localGravityData.getVY() * 0.002);
            playGround.getFriction().set(r, (double)localGravityData.getFriction() * 0.006);
        }
    }
}

