/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.image.BufferedImage;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.game.menu.ControlsMenu;
import moagg.game.menu.GhostMenu;
import moagg.game.menu.PlayerMenu;
import moagg.game.menu.SystemMenu;
import org.apache.log4j.Logger;

public class SettingsMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(SettingsMenu.class);
    private static final int INDEX_SYSTEM = 0;
    private static final int INDEX_PLAYER = 1;
    private static final int INDEX_CONTROLS = 2;
    private static final int INDEX_GHOST = 3;
    private static final int INDEX_BACK = 4;
    private static final String KEY_SYSTEM = "menu.settings.system";
    private static final String KEY_PLAYER = "menu.settings.player";
    private static final String KEY_CONTROLS = "menu.settings.controls";
    private static final String KEY_GHOST = "menu.settings.ghost";
    private static final String KEY_BACK = "menu.back";

    public SettingsMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.initMenuItems();
    }

    public void initMenuItems() {
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 100, Strings.getString(KEY_SYSTEM)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 120, Strings.getString(KEY_PLAYER)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 140, Strings.getString(KEY_CONTROLS)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 160, Strings.getString(KEY_GHOST)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 180, Strings.getString(KEY_BACK)));
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: {
                new SystemMenu(this.parent, this.background).start();
                this.initMenuItems();
                break;
            }
            case 1: {
                new PlayerMenu(this.parent, this.background).start();
                this.initMenuItems();
                break;
            }
            case 2: {
                new ControlsMenu(this.parent, this.background).start();
                this.initMenuItems();
                break;
            }
            case 3: {
                new GhostMenu(this.parent, this.background).start();
                this.initMenuItems();
                break;
            }
            case 4: {
                this.finish();
            }
        }
    }
}

