/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import moagg.artwork.object.ShipImageFactory;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.model.ControllableImpl;
import moagg.model.object.sprite.Ship;
import moagg.prefs.player.PlayerPrefs;
import moagg.types.Rotation;
import moagg.types.prefs.Difficulty;
import moagg.util.math.AngleUtil;
import org.apache.log4j.Logger;

public class PlayerMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(PlayerMenu.class);
    private static final int INDEX_NAME = 0;
    private static final int INDEX_DIFFICULTY = 1;
    private static final int INDEX_SHIP = 2;
    private static final int INDEX_BACK = 3;
    private static final String KEY_NAME = "menu.player.name";
    private static final String KEY_DIFFICULTY = "difficulty.label";
    private static final String KEY_SHIP = "menu.player.shiptype";
    private static final String KEY_BACK = "menu.back";
    private PlayerPrefs prefs = PlayerPrefs.getInstance();
    private String name = null;
    private Ship ship = null;
    private boolean selectName = false;
    private boolean selectDifficulty = false;
    private Difficulty difficulty = null;
    private int selectedDifficulty = 0;
    private boolean selectShip = false;
    private int selectedShip = 0;

    public PlayerMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.initMenuItems();
        this.name = this.prefs.getName();
        this.difficulty = this.prefs.getDifficulty();
        this.selectedDifficulty = this.difficulty.ordinal();
        ControllableImpl controllable = new ControllableImpl();
        controllable.setRotation(Rotation.RIGHT);
        controllable.setRotationSpeed(0.1);
        controllable.setAngle(180.0);
        this.ship = new Ship();
        this.ship.setControllable(controllable);
        this.ship.setY(140.0);
        this.selectShip(this.prefs.getShipType());
    }

    protected void initMenuItems() {
        this.maxTextWidth = 0;
        this.updateMaxTextWidth(Strings.getString(KEY_NAME));
        this.updateMaxTextWidth(Strings.getString(KEY_DIFFICULTY));
        this.updateMaxTextWidth(Strings.getString(KEY_SHIP));
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 100, Strings.getString(KEY_NAME)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 120, Strings.getString(KEY_DIFFICULTY)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 150, Strings.getString(KEY_SHIP)));
        this.menuItems.add(new AbstractMenu.MenuItem(this, 100, 180, Strings.getString(KEY_BACK)));
    }

    public void update(long elapsedTime) {
        block21: {
            block20: {
                if (!this.selectName) break block20;
                int key = this.bsInput.getKeyPressed();
                switch (key) {
                    case -2147483648: {
                        break;
                    }
                    case 10: {
                        this.prefs.setName(this.name);
                        this.selectName = false;
                        break;
                    }
                    case 27: {
                        this.name = this.prefs.getName();
                        this.selectName = false;
                        break;
                    }
                    case 8: {
                        if (this.name.length() > 0) {
                            this.name = this.name.substring(0, this.name.length() - 1);
                            break;
                        }
                        break block21;
                    }
                    case 32: {
                        this.name = this.name + " ";
                        break;
                    }
                    default: {
                        String ch = KeyEvent.getKeyText(key);
                        if (ch.length() == 1) {
                            this.name = this.name + (this.bsInput.isKeyDown(16) ? ch.toUpperCase() : ch.toLowerCase());
                            break;
                        }
                        break block21;
                    }
                }
                break block21;
            }
            if (this.selectDifficulty) {
                this.selectedDifficulty = (this.selectedDifficulty + 1) % Difficulty.values().length;
                this.difficulty = Difficulty.values()[this.selectedDifficulty];
                this.prefs.setDifficulty(this.difficulty);
                this.selectDifficulty = false;
            } else if (this.selectShip) {
                int key = this.bsInput.getKeyPressed();
                switch (key) {
                    case 37: 
                    case 40: {
                        if (this.selectedShip <= 0) break;
                        this.selectShip(this.selectedShip - 1);
                        break;
                    }
                    case 38: 
                    case 39: {
                        if (this.selectedShip >= ShipImageFactory.getInstance().getAvailableShips() - 1) break;
                        this.selectShip(this.selectedShip + 1);
                        break;
                    }
                    case 10: {
                        this.prefs.setShipType(this.selectedShip);
                        this.selectShip = false;
                        break;
                    }
                    case 27: {
                        this.selectShip(this.prefs.getShipType());
                        this.selectShip = false;
                    }
                }
            } else {
                super.update(elapsedTime);
            }
        }
        if (this.selectShip) {
            this.ship.setAngle(AngleUtil.normalize(this.ship.getAngle() - this.ship.getRotationSpeed() * (double)elapsedTime));
        }
    }

    protected void selectShip(int selectedShip) {
        this.selectedShip = selectedShip;
        this.ship.setImages(ShipImageFactory.getInstance().getImages(selectedShip));
        this.ship.setAngle(this.ship.getAngle());
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: {
                this.selectName = true;
                break;
            }
            case 1: {
                this.selectDifficulty = true;
                break;
            }
            case 2: {
                this.selectShip = true;
                break;
            }
            case 3: {
                this.finish();
            }
        }
    }

    public void render(Graphics2D g) {
        super.render(g);
        int x = 100 + this.maxTextWidth + 32;
        this.renderText(g, this.name, x, 100, this.selectName);
        this.renderText(g, this.difficulty.getLabel(), x, 120, false);
        this.ship.setX(x);
        this.ship.render(g);
    }
}

